
'use strict';
/**
 * Jorte services
 * 
 */
angular.module('services.sync.jorteSync', [])

        // jorte sync service
        .factory('jorteSyncSvc', ['jorteAuthSvc', function(jorteAuthSvc) {

                var ACCOUNT_PARAM = {
                    userCode: '',
                    applicationCode: '',
                    accessToken: '',
                    sync_version: ''
                };
                var zipConfig = {
                    applicationCode: 'applicationCode',
                    token: 'token',
                    userCode: 'userCode',
                    jsonDeleteList: 'jsonDeleteList',
                    jsonUpdateList: 'jsonUpdateList',
                    processId: 'processId',
                    appVersion: 'appVersion',
                    syncVersionFrom: 'syncVersionFrom',
                    syncVersionTo: 'syncVersionTo',
                    targets: 'targets',
                    syncMinEvent: 'syncMinEvent',
                    calendarId: 'calendarId',
                    tasklistId: 'tasklistId',
                    syncVersion: 'syncVersion',
                    updateCalendar: 'updateCalendar',
                    updateEvents: 'updateEvents',
                    idList: 'idList',
                    schedule: 'schedule',
                    tasklist: 'tasklist',
                    updateTasklists: 'updateTasklists',
                    task: 'task',
                    updateTasks: 'updateTasks',
                    syncKnownCalendars: 'syncKnownCalendars',
                    syncKnownTaskLists: 'syncKnownTaskLists',
                    cancelSchedule: 'cancelSchedule',
                    updateSharedCalendarSettings : 'updateSharedCalendarSettings',
                    deleteSharedCalendarSettings : 'deleteSharedCalendarSettings',
                    updateSharedCalendars : 'updateSharedCalendars'
                };

                function Date2Julian(d) {
                    return Math.round((new Date(d) / 86400000) - ((new Date(d)).getTimezoneOffset() / 1440) + 2440587.5);
                }
                function yyyyMMddToDate(yyyyMMdd, HHmmss) {
                    yyyyMMdd = yyyyMMdd.toString();
                    HHmmss = HHmmss ? HHmmss.toString() : null;
                    var new_date = null;
                    var year = null, month = null, date = null, hour = 0, minute = 0, second = 0;
                    if (yyyyMMdd && yyyyMMdd.length === 8) {
                        year = parseInt(yyyyMMdd.substring(0, 4));
                        month = parseInt(yyyyMMdd.substring(4, 6));
                        date = parseInt(yyyyMMdd.substring(6, 8));
                        if (HHmmss && HHmmss.length === 5) {
                            HHmmss = '0' + HHmmss;
                        }
                        if (HHmmss && HHmmss.length === 6) {
                            hour = parseInt(HHmmss.substring(0, 2));
                            minute = parseInt(HHmmss.substring(2, 4));
                            second = parseInt(HHmmss.substring(4, 6));
                        }
                        new_date = new Date(year, month - 1, date, hour, minute, second).getTime();
                    }
                    return new_date;
                }
                function minuteToHHmmss(minute) {
                    var totalSec = parseInt(minute) * 60;
                    var hours = parseInt(totalSec / 3600) % 24;
                    var minutes = parseInt(totalSec / 60) % 60;
                    var seconds = totalSec % 60;
                    var result = (hours < 10 ? "0" + hours : hours).toString() + (minutes < 10 ? "0" + minutes : minutes).toString() + (seconds < 10 ? "0" + seconds : seconds).toString();
                    return result;
                }
                function HHmmssToMinute(HHmmss) {
                    var totalMinute = 0;
                    HHmmss = HHmmss.toString();
                    if (HHmmss.length === 5) {
                        HHmmss = '0' + HHmmss;
                    }
                    if (HHmmss.length === 6) {
                        var hour = parseInt(HHmmss.substring(0, 2));
                        var minute = parseInt(HHmmss.substring(2, 4));
                        totalMinute = (hour * 60) + minute;
                    }
                    return totalMinute;
                }
                function arrangeItem(list) {
                    var newList = [];
                    for (var key in list) {
                        newList.push(list[key]);
                    }
                    return newList;
                }
                function sendToJorte(content, url, callback) {
                    var oMyForm = new FormData();
                    oMyForm.append("js", content);
                    var oReq = new XMLHttpRequest({mozSystem: true, mozAnon: true});
                    oReq.open("POST", url, true);
                    oReq.responseType = "blob";
                    oReq.onload = function(xhr) {
                        if (this.status === 200) {
                            var reader = new FileReader();
                            reader.onload = function(theFile) {
                                var zip = new JSZip(theFile.target.result);
                                if (callback) {
                                    callback(zip, 200);
                                }
                            };
                            reader.readAsArrayBuffer(oReq.response);
                        } else {
                            console.log('failed :' + this.status);
                            callback(null, this.status);
                        }
                    };
                    oReq.onerror = function(xhr) {
                        console.log(' Error ', xhr);
                        callback(null, 400);
                    };
                    oReq.send(oMyForm);

                }
                function getCurrentSyncVersion(cb) {// getCurrentSyncVersion from jorte...
                    var zip = new JSZip();
                    zip.file(zipConfig.applicationCode, jorteConfig.JORTE.JORTE_APPLICATION_CODE);
                    zip.file(zipConfig.token, ACCOUNT_PARAM.accessToken);
                    zip.file(zipConfig.userCode, ACCOUNT_PARAM.userCode);
                    zip.file(zipConfig.appVersion, jorteConfig.JORTE.appVersion);

                    var content = zip.generate({
                        base64: false,
                        type: "blob"
                    });
                    sendToJorte(content, jorteConfig.JORTE.current_sync_version_URL, function(zip, statusFlag) {
                        $.each(zip.files, function(index, zipEntry) {
                            if (zipEntry.name === zipConfig.syncVersion) {
                                var text = zipEntry.asText();
                                var lines = text.split(/[\r\n]+/g);
                                ACCOUNT_PARAM.sync_version = lines[0];

                            }
                        });
                        if (cb) {
                            cb();
                        }
                    });
                }

                function receiveCalendars(jorteSyncList, resultCB) {
                    var targets = 'calendars,sharedCalendarSetting';
                    var syncKnownCalendars = '';
                    for (var i = 0; i < jorteSyncList.length; i++) {
                        if (jorteSyncList[i].global_id) {
                            if (syncKnownCalendars === '') {
                                syncKnownCalendars = jorteSyncList[i].global_id;
                            } else {
                                syncKnownCalendars += '\n' + jorteSyncList[i].global_id;
                            }
                        }
                    }
                    var zip = new JSZip();
                    zip.file(zipConfig.applicationCode, jorteConfig.JORTE.JORTE_APPLICATION_CODE);
                    zip.file(zipConfig.token, ACCOUNT_PARAM.accessToken);
                    zip.file(zipConfig.userCode, ACCOUNT_PARAM.userCode);
                    zip.file(zipConfig.syncVersionFrom, jorteConfig.JORTE.JORTE_MIN_VALUE);
                    zip.file(zipConfig.syncVersionTo, ACCOUNT_PARAM.sync_version);
                    zip.file(zipConfig.targets, targets);
                    zip.file(zipConfig.syncKnownCalendars, syncKnownCalendars);
                    zip.file(zipConfig.appVersion, jorteConfig.JORTE.appVersion);

                    var content = zip.generate({
                        base64: false,
                        type: "blob"
                    });
                    var jorteCal = [];
                    sendToJorte(content, jorteConfig.JORTE.sync_web2droid_URL, function(zip, statusFlag) {
                        if (!zip || statusFlag !== 200) {
                            resultCB && resultCB(null, statusFlag);
                            return;
                        }
                        $.each(zip.files, function(index, zipEntry) {
                            if (zipEntry.name === zipConfig.updateCalendar) {
                                var text = zipEntry.asText();
                                var lines = text.split(/[\r\n]+/g);
                                for (var i = 0; i < lines.length; i++) {
                                    if (!lines[i] || lines[i].length === 0) {
                                        continue;
                                    }
                                    var calendarEntry = JSON.parse(lines[i]);
                                    var calendar = new Calendar();
                                    calendar.global_id = calendarEntry.id.toString(), calendar.calendar_rule = calendarEntry.calendarRule,
                                            calendar.type = calendarEntry.calendarType, calendar.name = calendarEntry.name,
                                            calendar.description = calendarEntry.description, calendar.timezone = jorteConfig.TIME_ZONE,
                                            calendar.owner_account = calendarEntry.ownerAccount, calendar.sync_account = ACCOUNT_PARAM.userCode,
                                            calendar.seqno = calendarEntry.seqno, calendar.create_date = calendarEntry.insertDatetime,
                                            calendar.update_date = calendarEntry.updateDatetime, calendar.sync_events = 1, calendar.selected = 1,
                                            calendar.dirty = 0, calendar.sync_version = calendarEntry.syncVersion,
                                            calendar.is_visible = calendarEntry.isVisible,calendar.is_public = calendarEntry.isPublic,
                                            calendar.is_share = calendarEntry.isShare;
                                    if (calendar.owner_account === calendar.sync_account || calendar.is_share !== 1) {
                                        calendar.is_updated = 1;
                                    } else {
                                        calendar.is_updated = 0;
                                    }
                                    jorteCal.push(calendar);
                                }
                            }

                            if (zipEntry.name === zipConfig.updateSharedCalendarSettings) {
                                var text = zipEntry.asText();
                                var lines = text.split(/[\r\n]+/g);
                                for (var i = 0; i < lines.length; i++) {
                                    if (!lines[i] || lines[i].length === 0) {
                                        continue;
                                    }
                                    var calendarEntry = JSON.parse(lines[i]);
                                    if (calendarEntry.approveStatus === 10 && calendarEntry.userAccount === ACCOUNT_PARAM.userCode) {
                                        for (var j = 0; j < jorteCal.length; j++) {
                                            if (jorteCal[j].global_id === calendarEntry.jorteCalendarId.toString()) {
                                                jorteCal[j].is_updated = 1;
                                                break;
                                            }
                                        }
                                    }
                                }
                            }
                        });
                        resultCB && resultCB(jorteCal, 200);
                    });
                }

                function sendCalendars(jorteTargetList, resultCB) {
                    var deleteList = [], updateList = [];
                    for (var i = 0; i < jorteTargetList.length; i++) {
                        var item = jorteTargetList[i];
                        if (item.deleted_status === 1) {
                            var dList = {};
                            dList.deletedId = item.global_id;
                            dList.syncVersion = item.sync_version;
                            if (deleteList.length === 0) {
                                deleteList = JSON.stringify(dList);
                            } else {
                                deleteList += '\n' + JSON.stringify(dList);
                            }

                            jorteTargetList.splice(i, 1);
                            i--;
                            continue;

                        } else {
                            var mainFlag;
                            if (item.id === 1) {
                                mainFlag = 1;
                            } else {
                                mainFlag = 0;
                            }
                            var tList = [];
                            var tJorteCalendarsAuthorityList = {};
                            tJorteCalendarsAuthorityList.accessLevel = 900;
                            tJorteCalendarsAuthorityList.groupId = null;
                            tJorteCalendarsAuthorityList.id = item.global_id;
                            tJorteCalendarsAuthorityList.insertDatetime = null;
                            tJorteCalendarsAuthorityList.jorteCalendarId = item.global_id;
                            tJorteCalendarsAuthorityList.mailAddress = null;
                            tJorteCalendarsAuthorityList.syncVersion = null;
                            tJorteCalendarsAuthorityList.tJorteCalendars = null;
                            tJorteCalendarsAuthorityList.updateDatetime = null;
                            tJorteCalendarsAuthorityList.userAccount = ACCOUNT_PARAM.userCode;
                            tJorteCalendarsAuthorityList.version = null;
                            tList.push(tJorteCalendarsAuthorityList);
                            var uList = {};
                            uList.calendarRule = item.calendar_rule;
                            uList.calendarType = item.type;
                            uList.category = item.category;
                            uList.country = item.country;
                            uList.description = item.description;
                            uList.encrypt = 0;
                            uList.encryptCrc = null;
                            uList.id = item.global_id;
                            uList.insertDatetime = null;

                            uList.isPublic = mainFlag === 0 ? item.is_public : 0;
                            uList.isShare = mainFlag === 0 ? item.is_share : 0;
                            uList.isVisible = item.is_visible;
                            uList.jorteCalendarIdentifier = null;
                            uList.language = item.language;
                            uList.location = item.location;
                            uList.mainFlag = mainFlag;
                            uList.name = item.name;
                            uList.ownerAccount = item.owner_account?item.owner_account:ACCOUNT_PARAM.userCode;
                            uList.relatedJorteCalendarId = null;
                            uList.seqno = item.seqno;
                            uList.syncEvents = 1;
                            uList.syncVersion = item.sync_version;
                            uList.tJorteCalendarsAuthorityList = tList;
                            uList.timezone = jorteConfig.TIME_ZONE;
                            uList.updateDatetime = null;
                            uList.version = null;
                            if (updateList.length === 0) {
                                updateList = JSON.stringify(uList);
                            } else {
                                updateList += '\n' + JSON.stringify(uList);
                            }
                        }
                    }
                    var zip = new JSZip();
                    zip.file(zipConfig.applicationCode, jorteConfig.JORTE.JORTE_APPLICATION_CODE);
                    if (deleteList.length !== 0) {
                        zip.file(zipConfig.jsonDeleteList, deleteList);
                    }
                    if (updateList.length !== 0) {
                        zip.file(zipConfig.jsonUpdateList, updateList);
                    }
                    zip.file(zipConfig.processId, "calendar");
                    zip.file(zipConfig.token, ACCOUNT_PARAM.accessToken);
                    zip.file(zipConfig.userCode, ACCOUNT_PARAM.userCode);
                    zip.file(zipConfig.appVersion, jorteConfig.JORTE.appVersion);
                    var content = zip.generate({
                        base64: false,
                        type: "blob"
                    });
                    if (updateList.length !== 0 || deleteList.length !== 0) {
                        sendToJorte(content, jorteConfig.JORTE.sync_droid2web_URL, function(zip, statusFlag) {
                            if (!zip || statusFlag !== 200) {
                                resultCB && resultCB(null, statusFlag);
                                return;
                            }
                            $.each(zip.files, function(index, zipEntry) {
                                if (zipEntry.name === zipConfig.idList) {
                                    var text = zipEntry.asText();
                                    var lines = text.split(/[\r\n]+/g);
                                    for (var i = 0; i < lines.length; i++) {
                                        if (i < jorteTargetList.length && lines[i].length > 0) {
                                            jorteTargetList[i].dirty = 0, jorteTargetList[i].sync_events = 1,
                                                    jorteTargetList[i].owner_account = ACCOUNT_PARAM.userCode,
                                                    jorteTargetList[i].sync_account = ACCOUNT_PARAM.userCode,
                                                    jorteTargetList[i].global_id = lines[i];

                                        }
                                    }
                                }

                            });
                            resultCB && resultCB(jorteTargetList, 200);
                        });
                    } else {
                        resultCB && resultCB(jorteTargetList, 200);
                    }

                }
                function sendDeletedTasks(jorteTargetDeleteList, resultCB) {
                    if (!jorteTargetDeleteList || jorteTargetDeleteList.length === 0) {
                        resultCB && resultCB(200);
                        return;
                    }
                    var deleteList = [];
                    for (var i = 0; i < jorteTargetDeleteList.length; i++) {
                        var item = jorteTargetDeleteList[i];
                        var dList = {};
                        dList.deletedId = item.global_id;
                        dList.syncVersion = item.sync_version;
                        if (deleteList.length === 0) {
                            deleteList = JSON.stringify(dList);
                        } else {
                            deleteList += '\n' + JSON.stringify(dList);
                        }

                    }
                    var zip = new JSZip();
                    zip.file(zipConfig.applicationCode, jorteConfig.JORTE.JORTE_APPLICATION_CODE);
                    if (deleteList.length !== 0) {
                        zip.file(zipConfig.jsonDeleteList, deleteList);
                    }

                    zip.file(zipConfig.processId, zipConfig.task);
                    zip.file(zipConfig.token, ACCOUNT_PARAM.accessToken);
                    zip.file(zipConfig.userCode, ACCOUNT_PARAM.userCode);
                    zip.file(zipConfig.appVersion, jorteConfig.JORTE.appVersion);

                    var content = zip.generate({
                        base64: false,
                        type: "blob"
                    });

                    if (deleteList.length !== 0) {
                        sendToJorte(content, jorteConfig.JORTE.sync_droid2web_URL, function(zip, statusFlag) {
                            if (!zip || statusFlag !== 200) {
                                resultCB && resultCB(statusFlag);
                                return;
                            }
                            resultCB && resultCB(200);

                        });
                    } else {
                        resultCB && resultCB(200);

                    }

                }
                function sendDeletedEvents(jorteTargetDeleteList, resultCB) {
                    if (!jorteTargetDeleteList || jorteTargetDeleteList.length === 0) {
                        resultCB && resultCB(200);
                        return;
                    }
                    var deleteList = [];
                    for (var i = 0; i < jorteTargetDeleteList.length; i++) {
                        var item = jorteTargetDeleteList[i];

                        if (item.type !== 300 && item.global_id) {
                            var dList = {};
                            dList.deletedId = item.global_id;
                            dList.syncVersion = item.sync_version;
                            if (deleteList.length === 0) {
                                deleteList = JSON.stringify(dList);
                            } else {
                                deleteList += '\n' + JSON.stringify(dList);
                            }
                        }
                    }
                    var zip = new JSZip();
                    zip.file(zipConfig.applicationCode, jorteConfig.JORTE.JORTE_APPLICATION_CODE);
                    if (deleteList.length !== 0) {
                        zip.file(zipConfig.jsonDeleteList, deleteList);
                    }

                    zip.file(zipConfig.processId, zipConfig.schedule);
                    zip.file(zipConfig.token, ACCOUNT_PARAM.accessToken);
                    zip.file(zipConfig.userCode, ACCOUNT_PARAM.userCode);
                    zip.file(zipConfig.appVersion, jorteConfig.JORTE.appVersion);

                    var content = zip.generate({
                        base64: false,
                        type: "blob"
                    });

                    if (deleteList.length !== 0) {
                        sendToJorte(content, jorteConfig.JORTE.sync_droid2web_URL, function(zip, statusFlag) {
                            if (!zip || statusFlag !== 200) {
                                resultCB && resultCB(statusFlag);
                                return;
                            }
                            resultCB && resultCB(200);

                        });
                    } else {
                        resultCB && resultCB(200);

                    }

                }
                function sendUpdatedEvents(jorteTargetInsertList, remainingList, resultCB) {
                    if (!jorteTargetInsertList || jorteTargetInsertList.length === 0) {
                        resultCB && resultCB(remainingList,[], 200);
                        return;
                    }
                    var updateList = [];
                    for (var i = 0; i < jorteTargetInsertList.length; i++) {
                        var item = jorteTargetInsertList[i];
                        var schedule = {};
                        schedule.charColor = (jorteConfig.PICKER_COLORS.indexOf(item.color) !== -1) ? jorteConfig.PICKER_COLORS.indexOf(item.color) + 1 : 0;
                        schedule.completion = item.completed;
                        schedule.content = item.content;
                        schedule.id = null;
                        schedule.importance = item.importance;
                        schedule.isHoliday = item.holiday;
                        schedule.jorteEventId = item.global_id;
                        schedule.location = item.location;
                        schedule.syncVersion = null;
                        schedule.version = null;

                        var eventJson = {};
                        eventJson.calendarRule = item.calendar_rule;
                        eventJson.dateFrom = Date2Julian(item.start_date);
                        eventJson.dateTo = Date2Julian(item.end_date);
                        eventJson.eventType = "1";
                        eventJson.iconDescription = null;

                        var str = item.icon;
                        if (str) {
                            var lastSlash = str.lastIndexOf("/");
                            var file = str.substring(lastSlash + 1);
                            var imageName = file.split(".")[0];
                            var lastUnderscore = imageName.lastIndexOf("_");
                            str = imageName.substring(0, lastUnderscore);
                            str = 'jorte_' + str;
                        }
                        eventJson.iconId = str;
                        eventJson.iconPosition = null;
                        eventJson.iconSize = null;
                        eventJson.iconTitle = null;

                        eventJson.id = item.global_id;
                        eventJson.jorteCalendarId = item.cal_global_id;
                        eventJson.mark = null;
                        eventJson.markText = null;
                        eventJson.onHolidayRule = (!item.repeat) ? 0 : 1;
                        var end_time = item.end_time;
                        if (item.day_time && item.day_time === 1 && item.start_date) {
                            var d = new Date(item.start_date);
                            var dt = new Date(Date.UTC(d.getFullYear(), d.getMonth(), d.getDate(), d.getHours(), d.getMinutes(), d.getSeconds()));
                            eventJson.rawDatetimeFrom = dt.getTime();
                        } else {
                            eventJson.rawDatetimeFrom = item.start_date;
                        }
                        if (item.day_time && item.day_time === 1 && item.end_date) {
                            var d = new Date(item.end_date);
                            var dt = new Date(Date.UTC(d.getFullYear(), d.getMonth(), d.getDate(), d.getHours(), d.getMinutes(), d.getSeconds()));
                            eventJson.rawDatetimeTo = dt.getTime();
                        } else if (item.day_time && item.day_time === 7 && item.end_date) {//night
                            var d = new Date(item.end_date);
                            var end_date_obj = jorteUtils.calcTimeLocal(item.timezone, item.end_date);
                            if(jorteUtils.formatDate(end_date_obj, 'HH:mm')==='23:59'){
                                var edate = new Date(end_date_obj.getFullYear(), end_date_obj.getMonth(), end_date_obj.getDate(), 24, 0, 0);
                                edate = jorteUtils.calcTime(item.timezone, edate.getTime());
                                var end_date = edate.getTime();
                                end_time = item.end_time + 1;
                                eventJson.rawDatetimeTo = end_date;
                            }else{
                                eventJson.rawDatetimeTo = item.end_date;
                            }
                        }else {
                            eventJson.rawDatetimeTo = item.end_date;
                        }

                        eventJson.rendDate = item.last_date;
                        eventJson.rrule = item.repeat;
                        eventJson.syncVersion = (!item.sync_version) ? null : item.sync_version;
                        eventJson.timeFrom = (parseInt(item.start_time) >= 0) ? item.start_time : null;
                        eventJson.timeTo = (parseInt(end_time) >= 0) ? end_time : null;
                        eventJson.timeslot = (item.day_time === 0) ? null : item.day_time;
                        eventJson.timezone = (item.day_time === 1) ? 'UTC': item.timezone;
                        eventJson.title = item.name;
                        eventJson.version = null;
                        if (item.parent_global) {
                            eventJson.originalId = item.parent_global;
                            if(item.parent_event && item.parent_event.all_day){
                                eventJson.originalStartDate = jorteUtils.calcTime("UTC",item.originalStartDate).getTime();
                                eventJson.originalTimezone = "UTC";
                            }else{
                                eventJson.originalStartDate = jorteUtils.calcTime(item.originalTimezone,item.originalStartDate).getTime();
                                eventJson.originalTimezone = item.originalTimezone;
                            }
                        }
                        var jsonObj = {};
                        jsonObj.event = eventJson;

                        if (eventJson.iconId) {
                            var icon = {};
                            icon.iconPosition = 0;
                            icon.iconSize = 10;
                            icon.id = null;
                            icon.jorteEventId = item.global_id;
                            jsonObj.icon = icon;
                        } else {
                            jsonObj.icon = null;
                        }

                        jsonObj.ownerAccount = ACCOUNT_PARAM.userCode;

                        var reminders = [];
                        for (var j = 0; j < item.reminders.length; j++) {
                            var reminderObj = {};
                            var rem = item.reminders[j];
                            reminderObj.id = null;
                            reminderObj.jorteScheduleId = item.global_id;
                            reminderObj.method = 1;
                            reminderObj.minutes = rem.minutes;
                            reminderObj.ownerAccount = ACCOUNT_PARAM.userCode;
                            reminderObj.tJorteSchedule = null;
                            reminderObj.syncVersion = null;
                            reminderObj.version = null;

                            reminders.push(reminderObj);
                        }
                        jsonObj.reminders = reminders;

                        jsonObj.schedule = schedule;
                        if (updateList.length === 0) {
                            updateList = JSON.stringify(jsonObj);
                        } else {
                            updateList += '\n' + JSON.stringify(jsonObj);
                        }

                    }
                    var zip = new JSZip();
                    zip.file(zipConfig.applicationCode, jorteConfig.JORTE.JORTE_APPLICATION_CODE);

                    if (updateList.length !== 0) {
                        zip.file(zipConfig.jsonUpdateList, updateList);
                    }
                    zip.file(zipConfig.processId, zipConfig.schedule);
                    zip.file(zipConfig.token, ACCOUNT_PARAM.accessToken);
                    zip.file(zipConfig.userCode, ACCOUNT_PARAM.userCode);
                    zip.file(zipConfig.appVersion, jorteConfig.JORTE.appVersion);

                    var content = zip.generate({
                        base64: false,
                        type: "blob"
                    });

                    if (updateList.length !== 0) {
                        sendToJorte(content, jorteConfig.JORTE.sync_droid2web_URL, function (zip, statusFlag) {
                            if (!zip || statusFlag !== 200) {
                                resultCB && resultCB(null, [], statusFlag);
                                return;
                            }
                            var lines = [];
                            for (var i in zip.files) {
                                var zipEntry = zip.files[i];
                                if (zipEntry.name === zipConfig.idList) {
                                    var text = zipEntry.asText();
                                    lines = text.split(/[\r\n]+/g);
                                    break;
                                }
                            }
                            if (lines.length > 0) {
                                for (var k in jorteTargetInsertList) {
                                    var global_id = '#' + lines[k];
                                    jorteTargetInsertList[k].dirty = 0;
                                    jorteTargetInsertList[k].global_id = lines[k];
                                    remainingList[global_id] = jorteTargetInsertList[k];
                                }
                                resultCB && resultCB(remainingList, jorteTargetInsertList, 200);

                            } else {
                                resultCB && resultCB(remainingList, [], 200);

                            }

                        });
                    } else {
                        resultCB && resultCB(remainingList,[], 200);
                    }

                }
                function sendRepeatedCancelledEvents(jorteTargetDeleteList, resultCB) {
                    if (!jorteTargetDeleteList || jorteTargetDeleteList.length === 0) {
                        resultCB && resultCB(200);
                        return;
                    }
                    var deleteList = [];
                    for (var i = 0; i < jorteTargetDeleteList.length; i++) {
                        var item = jorteTargetDeleteList[i];
                        if (item.type !== 300 && item.parent_global) {
                            var dList = {};
                            dList.id = null;
                            dList.originalId = item.parent_global;
                            if(item.all_day){
                                dList.originalStartDate = jorteUtils.calcTime("UTC",item.originalStartDate).getTime();
                                dList.originalTimezone = "UTC";
                            }else {
                                dList.originalStartDate = jorteUtils.calcTime(item.originalTimezone,item.originalStartDate).getTime();
                                dList.originalTimezone = item.originalTimezone;
                            }

                            dList.syncVersion = null;
                            dList.version = null;

                            if (deleteList.length === 0) {
                                deleteList = JSON.stringify(dList);
                            } else {
                                deleteList += '\n' + JSON.stringify(dList);
                            }
                        }
                    }
                    var zip = new JSZip();
                    zip.file(zipConfig.applicationCode, jorteConfig.JORTE.JORTE_APPLICATION_CODE);
                    if (deleteList.length !== 0) {
                        zip.file(zipConfig.jsonUpdateList, deleteList);
                    }

                    zip.file(zipConfig.processId, zipConfig.cancelSchedule);
                    zip.file(zipConfig.token, ACCOUNT_PARAM.accessToken);
                    zip.file(zipConfig.userCode, ACCOUNT_PARAM.userCode);
                    zip.file(zipConfig.appVersion, jorteConfig.JORTE.appVersion);

                    var content = zip.generate({
                        base64: false,
                        type: "blob"
                    });

                    if (deleteList.length !== 0) {
                        sendToJorte(content, jorteConfig.JORTE.sync_droid2web_URL, function(zip, statusFlag) {
                            if (!zip || statusFlag !== 200) {
                                resultCB && resultCB(statusFlag);
                                return;
                            }
                            resultCB && resultCB(200);
                        });
                    } else {
                        resultCB && resultCB(200);
                    }

                }
                function sendUpdateTasks(jorteTargetInsertList, remainingList, resultCB) {
                    if (!jorteTargetInsertList || jorteTargetInsertList.length === 0) {
                        resultCB && resultCB(remainingList, 200);
                        return;
                    }
                    var updateList = [];
                    for (var i = 0; jorteTargetInsertList && i < jorteTargetInsertList.length; i++) {
                        var item = jorteTargetInsertList[i];

                        var task = {};
                        task.archived = 0;
                        task.category = null;
                        task.color = null;
                        task.completeDate = null;
                        task.completed = item.completed;
                        task.createDate = null;
                        task.deleteDate = null;
                        task.deleted = 0;
                        task.dueDate = (item.due_date) ? jorteUtils.formatDate(new Date(item.due_date), 'yyyyMMdd') : null;
                        task.dueTime = (item.due_time) ? minuteToHHmmss(item.due_time) : null;
                        task.duration = null;
                        task.extendedValue = null;
                        task.hasAlarm = 0;
                        task.hiddenDate = null;
                        task.icon = null;
                        task.id = item.global_id;
                        task.importance = item.importance;
                        task.listId = parseInt(item.listid);
                        task.location = item.location;
                        task.name = item.name;
                        task.notes = item.memo;
                        task.ownerAccount = ACCOUNT_PARAM.userCode;
                        task.parentId = null;
                        task.repeat = null;
                        task.rowDueDatetime = (item.due_date) ? item.due_date : 0;
                        task.rowStartDatetime = (item.start_date) ? item.start_date : 0;
                        task.seqno = item.seq ? item.seq : 1;
                        task.spendTime = null;
                        task.startDate = (item.start_date) ? jorteUtils.formatDate(new Date(item.start_date), 'yyyyMMdd') : null;
                        task.startTime = (item.start_time) ? minuteToHHmmss(item.start_time) : null;
                        task.status = null;
                        task.syncVersion = item.sync_version;
                        task.tag = null;
                        task.targetDate = null;
                        task.timezone = item.timezone;
                        task.updateDate = null;
                        task.url = null;
                        task.version = null;

                        if (updateList.length === 0) {
                            updateList = JSON.stringify(task);
                        } else {
                            updateList += '\n' + JSON.stringify(task);
                        }
                    }
                    var zip = new JSZip();
                    zip.file(zipConfig.applicationCode, jorteConfig.JORTE.JORTE_APPLICATION_CODE);

                    if (updateList.length !== 0) {
                        zip.file(zipConfig.jsonUpdateList, updateList);
                    }
                    zip.file(zipConfig.processId, zipConfig.task);
                    zip.file(zipConfig.token, ACCOUNT_PARAM.accessToken);
                    zip.file(zipConfig.userCode, ACCOUNT_PARAM.userCode);
                    zip.file(zipConfig.appVersion, jorteConfig.JORTE.appVersion);

                    var content = zip.generate({
                        base64: false,
                        type: "blob"
                    });

                    if (updateList.length !== 0) {
                        sendToJorte(content, jorteConfig.JORTE.sync_droid2web_URL, function(zip, statusFlag) {
                            if (!zip || statusFlag !== 200) {
                                resultCB && resultCB(null, statusFlag);
                                return;
                            }
                            var lines = [];
                            for (var i in zip.files) {
                                var zipEntry = zip.files[i];
                                if (zipEntry.name === zipConfig.idList) {
                                    var text = zipEntry.asText();
                                    lines = text.split(/[\r\n]+/g);
                                    break;
                                }
                            }
                            if (lines.length > 0) {
                                for (var k in jorteTargetInsertList) {
                                    var global_id = '#' + lines[k];
                                    remainingList[global_id] = jorteTargetInsertList[k];
                                    remainingList[global_id].dirty = 0;
                                    remainingList[global_id].global_id = lines[k];
                                }
                                resultCB && resultCB(remainingList, 200);

                            } else {
                                resultCB && resultCB(remainingList, 200);

                            }

                        });
                    } else {
                        resultCB && resultCB(remainingList, 200);
                    }

                }
                function getEventObject(param, eventList, updatedEventList) {
                    var events = param.events;
                    var calendar = param.calendar;
                    for (var i = 0; i < events.length; i++) {
                        if (!events[i] || events[i].length === 0) {
                            continue;
                        }
                        var syncContent = JSON.parse(events[i]);
                        var event = syncContent.event;
                        var schedule = syncContent.schedule;
                        var reminders = syncContent.reminders;
                        var global_id = (event.id) ? event.id.toString() : null;
                        var calendar_id = calendar.id;
                        var start_date = event.rawDatetimeFrom;
                        var end_date = event.rawDatetimeTo;
                        var offset = new Date().getTimezoneOffset();

                        if (event.timeslot && event.timeslot === 1 && start_date) {
                            var d = new Date(start_date);
                            d.setMinutes(d.getMinutes() + offset);
                            start_date = d.getTime();
                        }
                        if (event.timeslot && event.timeslot === 1 && end_date) {
                            var d = new Date(end_date);
                            d.setMinutes(d.getMinutes() + offset);
                            end_date = d.getTime();
                        }
                        var startTime = event.timeFrom;
                        var event_name = event.title;
                        var day_time = event.timeslot;
                        if (!day_time || day_time.length === 0) {
                            day_time = 0;
                        }
                        var timezone = event.timezone;
                        var last_date = null;
                        var endTime = event.timeTo;
                        var icon = (event.iconId) ? JorteEventIcons[event.iconId] : null;

                        var content = null;
                        var location_data = null;
                        var importance = 0;
                        var completed = 0;
                        var color = null;
                        var complete_date = null;
                        var holiday = 0;
                        if (schedule) {
                            content = schedule.content;
                            location_data = schedule.location;
                            importance = (schedule.importance) ? schedule.importance : 0;
                            completed = (schedule.completion) ? schedule.completion : 0;
                            complete_date = (completed === 1) ? schedule.insertDatetime : null;
                            holiday = (schedule.isHoliday) ? schedule.isHoliday : 0;
                            color = ((!schedule.charColor) || parseInt(schedule.charColor) === 0) ? null : jorteConfig.PICKER_COLORS[parseInt(schedule.charColor) - 1];
                        }
                        var hasAlarm = (reminders.length === 0) ? 0 : 1;
                        var sync_version = event.syncVersion;
                        var dirty = 0;
                        var status = 1;
                        var type = event.eventType;
                        var all_day = (event.timeslot === 1) ? 1 : 0;
                        if (all_day) {
                            timezone = jorteConfig.TIME_ZONE;
                        }
                        var create_date = event.insertDatetime;
                        var update_date = event.updateDatetime;
                        
                        if (day_time === 7 && end_date) {//night
                            var d = new Date(end_date);
                            var end_date_obj = jorteUtils.calcTime(timezone, end_date);
                            if (jorteUtils.formatDate(end_date_obj, 'HH:mm') === '00:00') {
                                var edate = new Date(end_date_obj.getFullYear(), end_date_obj.getMonth(), end_date_obj.getDate()-1, 23, 59, 0);
                                edate = jorteUtils.calcTime(timezone, edate.getTime());
                                end_date = edate.getTime();
                                endTime = endTime - 1;
                            }
                        }
                        var start_dateObj = start_date ? new Date(start_date) : null;
                        var end_dateObj = end_date ? new Date(end_date) : null;

                        var date_diff = end_dateObj.getTime() - start_dateObj.getTime();
                        var instance_dates = [start_dateObj];

                        var repeat = event.rrule;
                        var repeatSelectObj = null;
                        var rule = null;
                        var repeatFlag = false;
                        var long_flag = false;
                        if (repeat) {
                            repeat = repeat.toString();
                            var lastChar = repeat.substring(repeat.length - 1, repeat.length);
                            if (lastChar === '') {
                                repeat = repeat.substring(0, repeat.length - 1);
                            }
                            lastChar = repeat.substring(repeat.length - 1, repeat.length);
                            if (lastChar === ';') {
                                repeat = repeat.substring(0, repeat.length - 1);
                            }
                            repeatSelectObj = RRule.parseString(repeat);
                            if (!repeatSelectObj.count && !repeatSelectObj.until) {
                                repeatSelectObj.count = 90;
                                repeatFlag = true;
                            }
                            repeatSelectObj.dtstart = start_dateObj;
                            rule = new RRule(repeatSelectObj);
                        }
                        if ((end_date - start_date) > (1000 * 60 * 60 * 24)) {
                            long_flag = true;
                        }
                        var instance_dates = [start_dateObj.toString()];
                        var length = instance_dates.length;
                        var last_date = null;
                        if (rule) {
                            instance_dates = rule.all();
                            instance_dates = instance_dates.toString().split(',');
                            if (repeatFlag && instance_dates.length !== 0) {
                                length = instance_dates.length - 1;
                            } else {
                                length = instance_dates.length - 1;
                            }
                            last_date = new Date(instance_dates[length]).getTime();
                        }
                        var e = new EventJorte();
                        e.calendar_id = calendar_id, e.global_id = global_id, e.name = event_name, e.content = content,
                                e.icon = icon, e.color = color, e.start_date = start_date, e.end_date = end_date,
                                e.start_time = startTime, e.end_time = endTime, e.type = type, e.timezone = timezone,
                                e.repeat = repeat, e.status = status, e.importance = importance, e.all_day = all_day, e.holiday = holiday,
                                e.day_time = day_time, e.location = location_data, e.completed = completed, e.complete_date = complete_date,
                                e.create_date = create_date, e.update_date = update_date, e.last_date = last_date, e.dirty = dirty,
                                e.sync_version = sync_version, e.rep_flag = repeat ? 1 : 0, e.long_flag = long_flag ? 1 : 0;
                        e.parent_global = event.originalId ? event.originalId.toString() : null;
                        e.instances = [];
                        e.reminders = [];
                        e.cancelled = null;

                        if (event.originalId && event.originalStartDate) {
                            e.originalStartDate = event.originalStartDate;
                            if (event.originalTimezone) {
                                var originalTimezone = event.originalTimezone;
                                if (eventList["#" + event.originalId] !== undefined) {
                                    originalTimezone = eventList["#" + event.originalId].all_day === 1 ? "UTC" : event.originalTimezone;
                                    }
                                    e.originalStartDate = jorteUtils.calcTimeLocal(originalTimezone, event.originalStartDate).getTime();
                                    e.originalTimezone = originalTimezone;
                                }
                            }
                        var begin, end, beginDates = [];
                        for (var j = 0; j < length; j++) {
                            begin = new Date(instance_dates[j]).getTime();
                            beginDates.push(begin); //For setting alarm/notification
                            end = begin + date_diff;
                            var inst = new EventInstance();
                            inst.begin = begin, inst.end = end;
                            e.instances.push(inst);
                        }

                        if (hasAlarm === 1) {
                            for (var k = 0; k < reminders.length; k++) {
                                var rem = new ReminderJorte();
                                rem.id = new Date().getTime(), rem.minutes = reminders[k].minutes, rem.type = reminders[k].minutes;
                                rem.beginDates = beginDates;
                                e.reminders.push(rem);
                            }
                        }
                        var global_ids = '#' + global_id;
                        if (event.originalId) {
                            updatedEventList[global_ids] = e;
                        }else {
                            eventList[global_ids] = e;
                        }
                    }
                }

                function getTaskObject(param, taskList) {
                    var tasks = param.tasks;
                    var task_list = param.task_list;
                    for (var i = 0; i < tasks.length; i++) {
                        if (!tasks[i] || tasks[i].length === 0) {
                            continue;
                        }
                        var task = JSON.parse(tasks[i]);
                        var task_list_id = task_list.id;
                        var global_id = (task.id) ? task.id.toString() : null;
                        var task_name = task.name;
                        var memo = task.notes;

                        var start_date = null;
                        var startTime = null;

                        if (task.startDate) {
                            start_date = yyyyMMddToDate(task.startDate, task.startTime);
                        }
                        if (task.startTime !== null) {
                            startTime = HHmmssToMinute(task.startTime);
                        }
                        var due_date = null;
                        var dueTime = null;
                        if (task.dueDate) {
                            due_date = yyyyMMddToDate(task.dueDate, task.dueTime);
                        }
                        if (task.dueTime !== null) {
                            dueTime = HHmmssToMinute(task.dueTime);
                        }
                        var type = 1;
                        var timezone = task.timezone;
                        var status = 1;
                        var completed = task.completed;
                        var importance = task.importance;
                        var complete_date = task.completeDate ? task.completeDate : null;
                        var create_date = task.insertDate ? task.insertDate : null;
                        var update_date = task.updateDate ? task.updateDate : null;
                        var sync_version = task.syncVersion;
                        var dirty = 0;
                        var calendar_id = 1;

                        var t = new TaskJorte();
                        t.calendar_id = calendar_id, t.task_list_id = task_list_id, t.global_id = global_id, t.name = task_name,
                                t.memo = memo, t.start_date = start_date, t.due_date = due_date, t.start_time = startTime,
                                t.due_time = dueTime, t.type = type, t.timezone = timezone, t.status = status, t.completed = completed,
                                t.importance = importance, t.complete_date = complete_date, t.create_date = create_date, t.update_date = update_date,
                                t.sync_version = sync_version, t.dirty = dirty,t.seq = task.seqno;
                        var date = new Date();
                        t.start = new Date(3000, date.getMonth(), date.getDate(), 0, 0, 0).getTime();
                        t.end = t.start;
                        if (t.start_date) {
                            date = new Date(t.start_date);
                            t.start = new Date(date.getFullYear(), date.getMonth(), date.getDate(), 0, 0, 0).getTime();
                        }
                        if (t.due_date) {
                            date = new Date(t.due_date);
                            t.end = new Date(date.getFullYear(), date.getMonth(), date.getDate(), 0, 0, 0).getTime();
                        }
                        t.instances = [];
                        t.reminders = [];

                        var inst = new EventInstance();
                        inst.begin = start_date ? start_date : due_date, inst.end = due_date;
                        t.instances.push(inst);
                        taskList.push(t);
                    }
                }

                function receiveEvents(calendarList, resultCB) {
                    var targets = 'schedules';
                    var calendarLength = calendarList.length;
                    var syncEventList = [];
                    var updatedEventList = [];

                    var getCalendarSchedules = function(k) {
                        if (k >= calendarLength) {
                            resultCB && resultCB(syncEventList, updatedEventList, 200);
                            return;
                        }
                        var item = calendarList[k];
                        var calendarId = item.global_id;
                        var latestVersion;
                        if (item.latest_schedules_sync_version === null) {
                            latestVersion = jorteConfig.JORTE.JORTE_MIN_VALUE;
                        } else {
                            latestVersion = item.latest_schedules_sync_version;
                        }
                        var zip = new JSZip();
                        zip.file(zipConfig.applicationCode, jorteConfig.JORTE.JORTE_APPLICATION_CODE);
                        zip.file(zipConfig.token, ACCOUNT_PARAM.accessToken);
                        zip.file(zipConfig.userCode, ACCOUNT_PARAM.userCode);
                        zip.file(zipConfig.syncVersionFrom, latestVersion);
                        zip.file(zipConfig.syncVersionTo, ACCOUNT_PARAM.sync_version);
                        zip.file(zipConfig.targets, targets);
                        zip.file(zipConfig.calendarId, calendarId.toString());
                        zip.file(zipConfig.appVersion, jorteConfig.JORTE.appVersion);

                        var content = zip.generate({
                            base64: false,
                            type: "blob"
                        });
                        sendToJorte(content, jorteConfig.JORTE.sync_web2droid_URL, function(zip, statusFlag) {
                            if (!zip || statusFlag !== 200) {
                                resultCB && resultCB(null,null, statusFlag);
                                return;
                            }

                            $.each(zip.files, function(index, zipEntry) {
                                if (zipEntry.name === zipConfig.updateEvents) {
                                    var text = zipEntry.asText();
                                    var lines = text.split(/[\r\n]+/g);
                                    getEventObject({'events': lines, 'calendar': item}, syncEventList, updatedEventList);
                                }
                            });
                            k++;
                            getCalendarSchedules(k);
                        });
                    };
                    getCalendarSchedules(0);

                }
                function receiveCancelledEvents(jorteSyncList, resultCB) {
                    var targets = 'cancelSchedules';
                    var syncKnownCalendars = '';
                    for (var i = 0; i < jorteSyncList.length; i++) {
                        if (jorteSyncList[i].global_id) {
                            if (syncKnownCalendars === '') {
                                syncKnownCalendars = jorteSyncList[i].global_id;
                            } else {
                                syncKnownCalendars += '\n' + jorteSyncList[i].global_id;
                            }
                        }
                    }
                    var zip = new JSZip();
                    zip.file(zipConfig.applicationCode, jorteConfig.JORTE.JORTE_APPLICATION_CODE);
                    zip.file(zipConfig.token, ACCOUNT_PARAM.accessToken);
                    zip.file(zipConfig.userCode, ACCOUNT_PARAM.userCode);
                    zip.file(zipConfig.syncVersionFrom, jorteConfig.JORTE.JORTE_MIN_VALUE);
                    zip.file(zipConfig.syncVersionTo, ACCOUNT_PARAM.sync_version);
                    zip.file(zipConfig.targets, targets);
                    zip.file(zipConfig.syncKnownCalendars, syncKnownCalendars);
                    zip.file(zipConfig.appVersion, jorteConfig.JORTE.appVersion);


                    var content = zip.generate({
                        base64: false,
                        type: "blob"
                    });
                    var jorteCancelledEvents = [];
                    sendToJorte(content, jorteConfig.JORTE.sync_web2droid_URL, function(zip, statusFlag) {
                        if (!zip || statusFlag !== 200) {
                            resultCB && resultCB(null, statusFlag);
                            return;
                        }
                        $.each(zip.files, function (index, zipEntry) {
                            if (zipEntry.name === 'updateCancelSchedules') {
                                var text = zipEntry.asText();
                                var lines = text.split(/[\r\n]+/g);
                                for (var i = 0; i < lines.length; i++) {
                                    if (!lines[i] || lines[i].length === 0) {
                                        continue;
                                    }
                                    var calendarEntry = JSON.parse(lines[i]);
                                    jorteCancelledEvents.push(calendarEntry);
                                }
                            }

                        });
                        resultCB && resultCB(jorteCancelledEvents, 200);
                    });
                }
                function sendTaskLists(jorteTargetList, resultCB) {
                    var deleteList = [], updateList = [];
                    for (var i = 0; i < jorteTargetList.length; i++) {
                        var item = jorteTargetList[i];
                        if (item.deleted_status === 1) {
                            var dList = {};
                            dList.deletedId = item.global_id;
                            dList.syncVersion = item.sync_version;
                            if (deleteList.length === 0) {
                                deleteList = JSON.stringify(dList);
                            } else {
                                deleteList += '\n' + JSON.stringify(dList);
                            }

                            jorteTargetList.splice(i, 1);
                            i--;
                            continue;

                        } else {
                            var mainFlag;
                            var seqNo;
                            if (item.id === 1) {
                                mainFlag = 1;
                                seqNo = 1;
                            } else {
                                mainFlag = 0;
                                seqNo = (i + 1);
                            }

                            var tasklist = {};
                            tasklist.color = (jorteConfig.PICKER_COLORS.indexOf(item.color) !== -1) ? jorteConfig.PICKER_COLORS.indexOf(item.color) + 1: null;
                            tasklist.createDate = null;
                            tasklist.defaultFlag = mainFlag;

                            tasklist.deleteDate = null;
                            tasklist.icon = null;
                            tasklist.id = item.global_id;
                            tasklist.mainFlag = mainFlag;
                            tasklist.name = item.name;
                            tasklist.notes = item.content;
                            tasklist.ownerAccount = ACCOUNT_PARAM.userCode;
                            tasklist.seqno = seqNo;
                            tasklist.status = null;
                            tasklist.syncVersion = item.sync_version;
                            tasklist.updateDate = null;
                            tasklist.version = null;

                            if (updateList.length === 0) {
                                updateList = JSON.stringify(tasklist);
                            } else {
                                updateList += '\n' + JSON.stringify(tasklist);
                            }
                        }
                    }
                    var zip = new JSZip();
                    zip.file(zipConfig.applicationCode, jorteConfig.JORTE.JORTE_APPLICATION_CODE);
                    if (deleteList.length !== 0) {
                        zip.file(zipConfig.jsonDeleteList, deleteList);
                    }
                    if (updateList.length !== 0) {
                        zip.file(zipConfig.jsonUpdateList, updateList);
                    }
                    zip.file(zipConfig.processId, zipConfig.tasklist);
                    zip.file(zipConfig.token, ACCOUNT_PARAM.accessToken);
                    zip.file(zipConfig.userCode, ACCOUNT_PARAM.userCode);
                    zip.file(zipConfig.appVersion, jorteConfig.JORTE.appVersion);

                    var content = zip.generate({
                        base64: false,
                        type: "blob"
                    });
                    if (updateList.length !== 0 || deleteList.length !== 0) {
                        sendToJorte(content, jorteConfig.JORTE.sync_droid2web_URL, function(zip, statusFlag) {
                            if (!zip || statusFlag !== 200) {
                                resultCB && resultCB(null, statusFlag);
                                return;
                            }
                            $.each(zip.files, function(index, zipEntry) {
                                if (zipEntry.name === zipConfig.idList) {
                                    var text = zipEntry.asText();
                                    var lines = text.split(/[\r\n]+/g);
                                    for (var i = 0; i < lines.length; i++) {
                                        if (i < jorteTargetList.length && lines[i].length > 0) {
                                            jorteTargetList[i].dirty = 0, jorteTargetList[i].global_id = lines[i];
                                        }
                                    }
                                }
                            });
                            resultCB && resultCB(jorteTargetList, 200);
                        });
                    } else {
                        resultCB && resultCB(jorteTargetList, 200);
                    }

                }

                function receiveTaskLists(jorteSyncList, resultCB) {
                    var targets = 'tasklists';
                    var syncKnownTaskLists = '';
                    for (var i = 0; i < jorteSyncList.length; i++) {
                        if (jorteSyncList[i].global_id) {
                            if (syncKnownTaskLists === '') {
                                syncKnownTaskLists = jorteSyncList[i].global_id;
                            } else {
                                syncKnownTaskLists += '\n' + jorteSyncList[i].global_id;
                            }
                        }
                    }
                    var zip = new JSZip();
                    zip.file(zipConfig.applicationCode, jorteConfig.JORTE.JORTE_APPLICATION_CODE);
                    zip.file(zipConfig.token, ACCOUNT_PARAM.accessToken);
                    zip.file(zipConfig.userCode, ACCOUNT_PARAM.userCode);
                    zip.file(zipConfig.syncVersionFrom, jorteConfig.JORTE.JORTE_MIN_VALUE);
                    zip.file(zipConfig.syncVersionTo, ACCOUNT_PARAM.sync_version);
                    zip.file(zipConfig.targets, targets);
                    zip.file(zipConfig.syncKnownTaskLists, syncKnownTaskLists);
                    zip.file(zipConfig.appVersion, jorteConfig.JORTE.appVersion);

                    var content = zip.generate({
                        base64: false,
                        type: "blob"
                    });
                    var jorteTaskList = [];
                    sendToJorte(content, jorteConfig.JORTE.sync_web2droid_URL, function(zip, statusFlag) {
                        if (!zip || statusFlag !== 200) {
                            resultCB && resultCB(null, statusFlag);
                            return;
                        }
                        $.each(zip.files, function(index, zipEntry) {
                            if (zipEntry.name === zipConfig.updateTasklists) {
                                var text = zipEntry.asText();
                                var lines = text.split(/[\r\n]+/g);
                                for (var i = 0; i < lines.length; i++) {
                                    if (!lines[i] || lines[i].length === 0) {
                                        continue;
                                    }
                                    var taskListEntry = JSON.parse(lines[i]);
                                    var color = ((!taskListEntry.color) || parseInt(taskListEntry.color) === 0) ? null :jorteConfig.PICKER_COLORS[parseInt(taskListEntry.color)-1];
                                    if (!color || color.length === 0) {
                                        color = '#181c7b';
                                    }
                                    var taskList = new TaskListJorte();
                                    taskList.global_id = taskListEntry.id.toString(), taskList.name = taskListEntry.name,
                                            taskList.content = taskListEntry.notes, taskList.icon = taskListEntry.icon,
                                            taskList.color = color,taskList.sync_status = 1, taskList.create_date = taskListEntry.createDate,
                                            taskList.update_date = taskListEntry.updateDate, taskList.sync_version = taskListEntry.syncVersion,
                                            taskList.dirty = 0;

                                    jorteTaskList.push(taskList);
                                }
                            }

                        });

                        resultCB && resultCB(jorteTaskList, 200);
                    });
                }
                function receiveTasks(taskList, resultCB) {
                    var targets = 'tasks';
                    var taskListLength = taskList.length;
                    var syncTasks = [];
                    var getTaskGroup = function(k) {
                        if (k >= taskListLength) {
                            resultCB && resultCB(syncTasks, 200);
                            return;
                        }
                        var item = taskList[k];
                        var taskListId = item.global_id;
                        var latestVersion;
                        if (!item.latest_tasks_sync_version) {
                            latestVersion = jorteConfig.JORTE.JORTE_MIN_VALUE;
                        } else {
                            latestVersion = item.latest_tasks_sync_version;
                        }
                        var zip = new JSZip();
                        zip.file(zipConfig.applicationCode, jorteConfig.JORTE.JORTE_APPLICATION_CODE);
                        zip.file(zipConfig.token, ACCOUNT_PARAM.accessToken);
                        zip.file(zipConfig.userCode, ACCOUNT_PARAM.userCode);
                        zip.file(zipConfig.syncVersionFrom, latestVersion);
                        zip.file(zipConfig.syncVersionTo, ACCOUNT_PARAM.sync_version);
                        zip.file(zipConfig.targets, targets);
                        zip.file(zipConfig.tasklistId, taskListId.toString());
                        zip.file(zipConfig.appVersion, jorteConfig.JORTE.appVersion);

                        var content = zip.generate({
                            base64: false,
                            type: "blob"
                        });
                        sendToJorte(content, jorteConfig.JORTE.sync_web2droid_URL, function(zip, statusFlag) {
                            if (!zip || statusFlag !== 200) {
                                resultCB && resultCB(null, statusFlag);
                                return;
                            }

                            $.each(zip.files, function(index, zipEntry) {
                                if (zipEntry.name === zipConfig.updateTasks) {
                                    var text = zipEntry.asText();
                                    var lines = text.split(/[\r\n]+/g);
                                    getTaskObject({'tasks': lines, 'task_list': item}, syncTasks);
                                }
                            });
                            k++;
                            getTaskGroup(k);
                        });
                    };
                    getTaskGroup(0);

                }

                return {
                    /**
                     * 
                     * @param {object} params (type)
                     * @param {function} resultCB
                     * @returns {undefined}
                     */
                    getJorteAuth: function(params, resultCB) {
                        jorteAuthSvc.init();
                        var jorteAccount = jorteAuthSvc.getAccount();
                        var syncVersion = jorteConfig.getJorteSyncVersion();
                        if (jorteAccount) {
                            ACCOUNT_PARAM.userCode = jorteAccount.jorteId;
                            ACCOUNT_PARAM.applicationCode = jorteAccount.applicationCode;
                            ACCOUNT_PARAM.accessToken = jorteAccount.accessToken;
                            ACCOUNT_PARAM.sync_version = syncVersion ? syncVersion : null;
                            resultCB && resultCB(true);
                        } else {
                            resultCB && resultCB(false);
                        }
                    },
                    syncCalendars: function(params, resultCB) {

                        var knownCalendars = params.list;
                        var jorteTargetList = [];
                        for (var i = 0; i < knownCalendars.length; i++) {
                            if (knownCalendars[i].dirty) {
                                jorteTargetList.push(knownCalendars[i]);
                            }
                        }
                        sendCalendars(jorteTargetList, function(jorteSyncList, statusFlag) {
                            for (var i = 0; i < jorteSyncList.length; i++) {
                                var syncItem = jorteSyncList[i];
                                for (var j = 0; j < knownCalendars.length; j++) {
                                    var anItem = knownCalendars[j];
                                    if (syncItem.id === anItem.id) {
                                        anItem.global_id = syncItem.global_id;
                                        break;
                                    }
                                }
                            }
                            if (statusFlag !== 200) {
                                resultCB(null, statusFlag);
                                return;
                            }
                            getCurrentSyncVersion(function() {
                                receiveCalendars(knownCalendars, function(jorteAllCalendars, statusFlag) {

                                    if (statusFlag !== 200) {
                                        resultCB && resultCB(null, statusFlag);
                                        return;
                                    }
                                    for (var i = 0; i < jorteAllCalendars.length; i++) {
                                        if(!jorteAllCalendars[i].is_updated || jorteAllCalendars[i].is_updated !== 1){
                                            jorteAllCalendars.splice(i, 1);
                                            i--;
                                        }
                                    }
                                    for (var i = 0; i < jorteSyncList.length; i++) {
                                        var syncItem = jorteSyncList[i];
                                        for (var j = 0; j < jorteAllCalendars.length; j++) {
                                            var anItem = jorteAllCalendars[j];
                                            if (syncItem.global_id === anItem.global_id) {
                                                anItem.id = syncItem.id;
                                                delete anItem.is_updated;
                                                break;
                                            }
                                        }
                                    }
                                    resultCB(jorteAllCalendars, 200);
                                });
                            });
                        });

                    },
                    syncEvents: function(params, resultCB) {
                        var calendarList = params.calendarList;
                        var delListLocal = params.delListLocal;
                        var insertListLocal = params.insertListLocal;
                        var updateListLocal = arrangeItem(params.updateListLocal);
                        var remainingList = params.remainingList;
                        var insertListChildrenLocal = params.insertListChildrenLocal;

                        sendDeletedEvents(delListLocal, function (statusFlag) {
                            if (statusFlag !== 200) {
                                resultCB(null, null, null, statusFlag);
                                return;
                            }
                            sendUpdatedEvents(insertListLocal, remainingList, function (remainingList, newLocalList, statusFlag) {
                                if (statusFlag !== 200) {
                                    resultCB(null, null, null, statusFlag);
                                    return;
                                }
                                if (delListLocal) {
                                    for (var i in newLocalList) {
                                        for (var j in delListLocal) {
                                            if (newLocalList[i] && newLocalList[i].id === delListLocal[j].parent) {
                                                delListLocal[j].parent_global = newLocalList[i].global_id;
                                                delListLocal[j].sync_version = newLocalList[i].sync_version;
                                            }
                                        }
                                    }
                                }
                                if (insertListChildrenLocal) {
                                    for (var i in newLocalList) {
                                        for (var j in insertListChildrenLocal) {
                                            if (newLocalList[i] && newLocalList[i].id === insertListChildrenLocal[j].parent) {
                                                insertListChildrenLocal[j].parent_global = newLocalList[i].global_id;
                                                insertListChildrenLocal[j].sync_version = newLocalList[i].sync_version;
                                            }
                                        }
                                    }
                                }
                                sendUpdatedEvents(insertListChildrenLocal, remainingList, function (remainingList, newLocalList, statusFlag) {
                                    if (statusFlag !== 200) {
                                        resultCB(null, null, null, statusFlag);
                                        return;
                                    }
                                    sendUpdatedEvents(updateListLocal, remainingList, function (remainingList, newLocalList, statusFlag) {
                                        if (statusFlag !== 200) {
                                            resultCB(null, null, null, statusFlag);
                                            return;
                                        }
                                        sendRepeatedCancelledEvents(delListLocal, function (statusFlag) {
                                            if (statusFlag !== 200) {
                                                resultCB(null, null, null, statusFlag);
                                                return;
                                            }

                                            getCurrentSyncVersion(function () {
                                                receiveEvents(calendarList, function (jorteAllEvents, childEvents, statusFlag) {

                                                    if (statusFlag !== 200) {
                                                        resultCB(null, null, null, statusFlag);
                                                        return;
                                                    }

                                                    receiveCancelledEvents(calendarList, function (jorteCancelledEvents, statusFlag) {
                                                        if (statusFlag !== 200) {
                                                            resultCB(jorteAllEvents, childEvents, remainingList, 200);
                                                            return;
                                                        }

                                                        for (var i = 0; i < jorteCancelledEvents.length; i++) {
                                                            var c_event = jorteCancelledEvents[i];
                                                            var globalId = '#' + c_event.originalId.toString();
                                                            if (jorteAllEvents[globalId] !== undefined) {
                                                                var originalStartDate = new Date(c_event.originalStartDate).getTime();
                                                                if (jorteAllEvents[globalId].all_day === 1) {
                                                                    var d = new Date(c_event.originalStartDate);
                                                                    d.setTime(d.getTime() + d.getTimezoneOffset() * 60 * 1000);
                                                                    originalStartDate = d.getTime();
                                                                }

                                                                var instances = jorteAllEvents[globalId].instances;
                                                                if (instances) {
                                                                    for (var k = 0; k < instances.length; k++) {
                                                                        if (instances[k].begin === originalStartDate) {
                                                                            instances.splice(k, 1);
                                                                            k--;
                                                                        }
                                                                    }
                                                                    var len = instances.length;
                                                                    jorteAllEvents[globalId].instances = instances;
                                                                    jorteAllEvents[globalId].last_date = len > 0 ? instances[len - 1].begin : jorteAllEvents[globalId].last_date;
                                                                    var cancelledItems = [];
                                                                    if (!jorteAllEvents[globalId].cancelled) {
                                                                        jorteAllEvents[globalId].cancelled = [];
                                                                    } else {
                                                                        cancelledItems = jorteAllEvents[globalId].cancelled;
                                                                    }
                                                                    cancelledItems.push(c_event.originalStartDate);
                                                                    jorteAllEvents[globalId].cancelled = cancelledItems;
                                                                }
                                                                if (!instances || instances.length === 0) {
                                                                    delete jorteAllEvents[globalId];
                                                                }
                                                            }
                                                        }
                                                        resultCB(jorteAllEvents, childEvents, remainingList, 200);
                                                    });

                                                });
                                            });
                                        });

                                    });
                                });
                            });
                        });
                    },
                    syncTaskLists: function(params, resultCB) {
                        var syncKnownTaskLists = params.list;
                        var jorteTargetList = [];
                        for (var i = 0; i < syncKnownTaskLists.length; i++) {
                            if (syncKnownTaskLists[i].dirty && syncKnownTaskLists[i].sync_status) {
                                jorteTargetList.push(syncKnownTaskLists[i]);
                            }
                        }
                        sendTaskLists(jorteTargetList, function (jorteSyncList, statusFlag) {
                            if (statusFlag !== 200) {
                                resultCB(null, statusFlag);
                                return;
                            }
                            getCurrentSyncVersion(function () {
                                receiveTaskLists(syncKnownTaskLists, function (jorteAllTaskLists, statusFlag) {
                                    if (statusFlag !== 200) {
                                        resultCB(null, statusFlag);
                                        return;
                                    }
                                    for (var i = 0; i < jorteSyncList.length; i++) {
                                        var syncItem = jorteSyncList[i];
                                        for (var j = 0; j < jorteAllTaskLists.length; j++) {
                                            var anItem = jorteAllTaskLists[j];
                                            if (syncItem.global_id === anItem.global_id) {
                                                anItem.id = syncItem.id;
                                                anItem.selected = syncItem.selected;
                                                break;
                                            }
                                        }
                                    }
                                    resultCB(jorteAllTaskLists, 200);
                                });
                            });
                        });

                    },
                    syncTasks: function(params, resultCB) {
                        var task_listList = params.task_listList;
                        var delListLocal = params.delListLocal;
                        var insertListLocal = params.insertListLocal;
                        var updateListLocal = arrangeItem(params.updateListLocal);
                        var remainingList = params.remainingList;

                        sendDeletedTasks(delListLocal, function(statusFlag) {
                            if (statusFlag !== 200) {
                                resultCB(null, null, statusFlag);
                                return;
                            }
                            sendUpdateTasks(insertListLocal, remainingList, function(remainingList, statusFlag) {
                                if (statusFlag !== 200) {
                                    resultCB(null, null, statusFlag);
                                    return;
                                }
                                sendUpdateTasks(updateListLocal, remainingList, function(remainingList, statusFlag) {
                                    if (statusFlag !== 200) {
                                        resultCB(null, null, statusFlag);
                                        return;
                                    }
                                    getCurrentSyncVersion(function() {
                                        receiveTasks(task_listList, function(jorteAllTasks, statusFlag) {
                                            if (statusFlag !== 200) {
                                                resultCB(null, null, statusFlag);
                                                return;
                                            }

                                            resultCB(jorteAllTasks, remainingList, 200);
                                        });
                                    });
                                });
                            });
                        });

                    },
                    syncSingleEvent: function(params, resultCB) {
                        var delListLocal = params.delListLocal;
                        var insertListLocal = params.insertListLocal;
                        var updateListLocal = arrangeItem(params.updateListLocal);
                        var remainingList = params.remainingList;

                        sendDeletedEvents(delListLocal, function(statusFlag) {
                            if (statusFlag !== 200) {
                                resultCB(null, statusFlag);
                                return;
                            }
                            sendUpdatedEvents(insertListLocal, remainingList, function(remainingList,newLocalList, statusFlag) {
                                if (statusFlag !== 200) {
                                    resultCB(null, statusFlag);
                                    return;
                                }
                                sendUpdatedEvents(updateListLocal, remainingList, function(remainingList,newLocalList, statusFlag) {
                                    if (statusFlag !== 200) {
                                        resultCB(null, statusFlag);
                                        return;
                                    }
                                    sendRepeatedCancelledEvents(delListLocal, function(statusFlag) {
                                        if (statusFlag !== 200) {
                                            resultCB(null, statusFlag);
                                            return;
                                        }
                                        var result = null;
                                        for (var key in remainingList) {
                                            result = remainingList[key];
                                        }
                                        resultCB(result, statusFlag);
                                    });

                                });
                            });
                        });

                    },
                    syncSingleTask: function(params, resultCB) {
                        var delListLocal = params.delListLocal;
                        var insertListLocal = params.insertListLocal;
                        var updateListLocal = arrangeItem(params.updateListLocal);
                        var remainingList = params.remainingList;

                        sendDeletedTasks(delListLocal, function(statusFlag) {
                            if (statusFlag !== 200) {
                                resultCB(null, statusFlag);
                                return;
                            }
                            sendUpdateTasks(insertListLocal, remainingList, function(remainingList, statusFlag) {
                                if (statusFlag !== 200) {
                                    resultCB(null, statusFlag);
                                    return;
                                }
                                sendUpdateTasks(updateListLocal, remainingList, function(remainingList, statusFlag) {
                                    if (statusFlag !== 200) {
                                        resultCB(null, statusFlag);
                                        return;
                                    }
                                    var result = null;
                                    for (var key in remainingList) {
                                        result = remainingList[key];
                                    }
                                    resultCB(result, statusFlag);
                                });
                            });
                        });

                    },
                    syncSingleTaskList: function(params, resultCB) {
                        var jorteTargetList = params.taskList;
                        sendTaskLists(jorteTargetList, function(jorteSyncList, statusFlag) {
                            jorteSyncList = jorteSyncList && jorteSyncList.length > 0 ? jorteSyncList[0] : null;
                            if (statusFlag !== 200) {
                                resultCB(null, statusFlag);
                                return;
                            }
                            resultCB(jorteSyncList, statusFlag);
                        });
                    }
                };

            }]);