
'use strict';
/**
 * Jorte services
 * 
 */
angular.module('services.sync.localdbSync', [])

        // localdb sync service
        .factory('localdbSyncSvc',['mainSvc','eventSvc','taskSvc', function(mainSvc, eventSvc, taskSvc) {

            return {
                getCalendars: function(params, resultCB) {
                    mainSvc.getAllCalendarsForSync(params.type, params.dirtyCheck, resultCB);
                },
                syncCalendars: function(params, resultCB) {
                    mainSvc.syncCalendars(params.type, params.list, resultCB);
                },
                getEvents: function(params, resultCB) {
                    eventSvc.getAllEventsForSync(params.type, resultCB);
                },
                syncEvents: function(op, items, resultCB) {//#op(!:insert,2:update,3:delete)
                    eventSvc.syncEvents(op, items, resultCB);
                },
                getTaskLists: function(params, resultCB) {
                    taskSvc.getAllTaskListForSync(params.type, params.dirtyCheck, resultCB);
                },
                syncTaskLists: function(params, resultCB) {
                    taskSvc.syncTaskLists(params.type, params.list, resultCB);
                },
                getTasks: function(params, resultCB) {
                    taskSvc.getAllTasksForSync(params.type, resultCB);
                },
                syncTasks: function(op, items, resultCB) {//#op(!:insert,2:update,3:delete)
                    taskSvc.syncTasks(op, items, resultCB);
                },
                getSingleEvent: function(params, resultCB) {
                    eventSvc.getSingleEventForSync(params, resultCB);
                },
                syncSingleEvent: function(params, resultCB) {
                    eventSvc.syncSingleEvent(params.type, params.list, params.local_list, resultCB);
                },
                getSingleTask: function(params, resultCB) {
                    taskSvc.getSingleTaskForSync(params, resultCB);
                },
                syncSingleTask: function(params, resultCB) {
                    taskSvc.syncSingleTask(params.type, params.list, resultCB);
                },
                getSingleTaskList: function(params, resultCB) {
                    taskSvc.getSingleTaskListForSync(params, resultCB);
                },
                syncSingleTaskList: function(params, resultCB) {
                    taskSvc.syncSingleTaskList(params.type, params.list, resultCB);
                },
                clearLocallyDeletedEvents:function (type, resultCB){
                    eventSvc.clearLocallyDeletedEvents(type, resultCB);
                },
                clearLocallyDeletedTasks:function (resultCB){
                    taskSvc.clearLocallyDeletedTasks(resultCB);
                }
            };

        }]);