'use strict';
/**
 * Jorte services
 * 
 */
angular.module('services.sync.sync', [])

        // main sync service
        .factory('syncSvc', ['$rootScope', 'jorteSyncSvc', 'googleSyncSvc', 'localdbSyncSvc', 'notificationHelperSvc', function($rootScope, jorteSyncSvc, googleSyncSvc, localdbSyncSvc, notificationHelperSvc) {
                var GoogleCalendarSyncRunning = false;
                var GoogleTasksSyncRunning = false;
                var JorteCalendarSyncRunning = false;
                var JorteTaskSyncRunning = false;
                function autoSyncComplted() {
                    $rootScope.$broadcast('syncCompleted', null);
                }
                function network_availability(callBack) {
                    if (navigator.onLine) {
                        callBack && callBack(true);
                    } else {
                        callBack && callBack(false);
                    }

                }
                function showNotificationIcon() {
                    var n;
                    notificationHelperSvc.sendNotification(getMSG('InSyncwithCloudHead'), getMSG('SyncingInProgressHead'), 'jorteSyncNotifications', function(notifyObj) {
                        n = notifyObj;
                    });
                    var varCounter = 0;
                    var varName = function() {
                        if (varCounter === 0) {
                            varCounter++;
                            try {
                                n.close();
                            } catch (err) {
                                console.log(err.name + ": " + err.message);
                            }
                        } else {
                            clearInterval(varName);
                        }
                    };
                    setInterval(varName, 5000);
                }
                function compareLocalWithCloudTask(cloudTasks, localTasks) {
                    var updateList = [];
                    for (var k = 0; k < cloudTasks.length; k++) {
                        var cloud_task = cloudTasks[k];
                        var globalId = '#' + cloud_task.global_id;
                        if (localTasks[globalId] !== undefined) {
                            var local_task = localTasks[globalId];
                            if (local_task.sync_version !== cloud_task.sync_version) { //update needed ,update locEvent
                                local_task.global_id = cloud_task.global_id, local_task.name = cloud_task.name, local_task.task_list_id = cloud_task.task_list_id,
                                        local_task.memo = cloud_task.memo, local_task.start_date = cloud_task.start_date,
                                        local_task.due_date = cloud_task.due_date, local_task.start_time = cloud_task.start_time,
                                        local_task.due_time = cloud_task.due_time, local_task.type = cloud_task.type, local_task.timezone = cloud_task.timezone,
                                        local_task.status = cloud_task.status, local_task.completed = cloud_task.completed,
                                        local_task.importance = cloud_task.importance, local_task.complete_date = cloud_task.complete_date,
                                        local_task.create_date = cloud_task.create_date, local_task.update_date = cloud_task.update_date,
                                        local_task.sync_version = cloud_task.sync_version, local_task.dirty = cloud_task.dirty;
                                local_task.instances = cloud_task.instances;
                                local_task.reminders = cloud_task.reminders;
                                updateList.push(local_task);
                            }
                            delete localTasks[globalId];//already exist
                            cloudTasks.splice(k, 1); //processed or moved
                            k--;
                        }
                    }
                    var params = {insertResult: cloudTasks, updateResult: updateList, deleteResult: arrangeItem(localTasks)};
                    return params;
                }
                function compareLocalWithCloudEvent(cloudEvents, localEvents) {
                    var updateList = [];
                    for (var k = 0; k < cloudEvents.length; k++) {
                        var cloud_event = cloudEvents[k];
                        var globalId = '#' + cloud_event.global_id;
                        if (localEvents[globalId] !== undefined) {
                            var locEvent = localEvents[globalId];
                            if (locEvent.sync_version !== cloud_event.sync_version || cloud_event.cancelled || locEvent.cancelled) { //update needed ,update locEvent
                                var newObj = {};
                                $.extend(newObj, cloud_event);
                                newObj.id = locEvent.id;
                                updateList.push(newObj);
                            }
                            delete localEvents[globalId];//already exist

                            cloudEvents.splice(k, 1); //processed or moved
                            k--;
                        }

                    }
                    var params = {insertResult: cloudEvents, updateResult: updateList, deleteResult: arrangeItem(localEvents)};
                    return params;

                }
                function arrangeItem(list) {
                    var newList = [];
                    for (var key in list) {
                        newList.push(list[key]);
                    }
                    return newList;
                }
                function localSyncTasks(op, items, callback) {
                    // op(1:insert,2:update,3:delete)
                    var splitList = jorteUtils.splitArray(items,500);

                    function loopSplit(i) {
                        if (i >= splitList.length) {
                            callback && callback();
                            return;
                        }
                        localdbSyncSvc.syncTasks(op, splitList[i], function() {
                            setTimeout(function() {
                                loopSplit(++i);
                            }, 10);
                        });
                    }
                    loopSplit(0);
                }

                function localSyncEvents(op, items, callback) {
                    // op(1:insert,2:update,3:delete)
                    var splitList = jorteUtils.splitArray(items,500);
                    function loopSplit(i) {
                        if (i >= splitList.length) {
                            callback && callback();
                            return;
                        }
                        localdbSyncSvc.syncEvents(op, splitList[i], function() {
                            setTimeout(function() {
                                loopSplit(++i);
                            }, 10);
                        });
                    }
                    loopSplit(0);
                }
                function syncJorteCalendar(params, callback) {
                    var options = {
                        type: [0, 100],
                        dirtyCheck: false
                    };
                    localdbSyncSvc.getCalendars(options, function(localCalendars) {
                        jorteSyncSvc.syncCalendars({list: localCalendars}, function(jorteCalendars, statusFlag) {
                            if (statusFlag !== 200) {
                                callback && callback(null, statusFlag);
                                return;
                            }
                            localdbSyncSvc.syncCalendars({type: [0, 100], list: jorteCalendars}, function(status) {
                                localdbSyncSvc.getCalendars({type: [0, 100], dirtyCheck: false}, function(newLocalCalendars) {

                                    localdbSyncSvc.getEvents(options, function(params) {

                                        params.calendarList = newLocalCalendars;

                                        jorteSyncSvc.syncEvents(params
                                                , function(cloudAllEvents, cloudChildEvents, list, statusFlag) {

                                                    if (statusFlag !== 200) {
                                                        callback && callback(null, statusFlag);
                                                        return;
                                                    }
                                                    var cloudEvents = arrangeItem(cloudAllEvents);

                                                    for (var key in cloudChildEvents) {
                                                        cloudEvents.push(cloudChildEvents[key]);
                                                    }

                                                    var params = compareLocalWithCloudEvent(cloudEvents, list);

                                                    localSyncEvents(1, params.insertResult, function() {
                                                        localSyncEvents(2, params.updateResult, function() {
                                                            localSyncEvents(3, params.deleteResult, function() {
                                                                localdbSyncSvc.clearLocallyDeletedEvents(0,function() {
                                                                    callback && callback(status);
                                                                });
                                                            });
                                                        });
                                                    });
                                                });
                                    });
                                });
                            });
                        });
                    });
                }

                function syncJorteTaskList(params, callback) {
                    var options = {
                        type: [1],
                        dirtyCheck: false
                    };
                    localdbSyncSvc.getTaskLists(options, function(localTaskLists) {
                        jorteSyncSvc.syncTaskLists({list: localTaskLists}, function(jorteTaskLists, statusFlag) {
                            if (statusFlag !== 200) {
                                callback && callback(statusFlag);
                                return;
                            }
                            localdbSyncSvc.syncTaskLists({type: [1], list: jorteTaskLists}, function(status) {
                                localdbSyncSvc.getTaskLists({type: [1], dirtyCheck: false}, function(newLocalTaskLists) {
                                    localdbSyncSvc.getTasks(options, function(params) {
                                        params.task_listList = newLocalTaskLists;
                                        jorteSyncSvc.syncTasks(params
                                                , function(cloudAllTasks, list, statusFlag) {
                                                    if (statusFlag !== 200) {
                                                        callback && callback(null, statusFlag);
                                                        return;
                                                    }
                                                    jorteUtils.sortTasks(cloudAllTasks);
                                                    var seqno = 0;
                                                    for (var j = 0; j < cloudAllTasks.length; j++) {
                                                        seqno++;
                                                        cloudAllTasks[j].seq = seqno;
                                                    }
                                                    var params = compareLocalWithCloudTask(cloudAllTasks, list);
                                                    localSyncTasks(1, params.insertResult, function() {
                                                        localSyncTasks(2, params.updateResult, function() {
                                                            localSyncTasks(3, params.deleteResult, function() {
                                                                localdbSyncSvc.clearLocallyDeletedTasks(function() {
                                                                    callback && callback(status);
                                                                });
                                                            });
                                                        });
                                                    });

                                                });
                                    });
                                });
                            });
                        });
                    });
                }

                function syncGoogleCalendar(params, callback, errorCB) {
                    var options = {
                        type: [300],
                        dirtyCheck: true
                    };
                    localdbSyncSvc.getCalendars(options, function(localCalendars) {
                        googleSyncSvc.syncCalendars({list: localCalendars}, function(googleCalendars) {
                            localdbSyncSvc.syncCalendars({type: [300], list: googleCalendars}, function(status) {
                                localdbSyncSvc.getCalendars({type: [300], dirtyCheck: false}, function(newLocalCalendars) {
                                    localdbSyncSvc.getEvents(options, function(params) {
                                        params.calendarList = newLocalCalendars;
                                        googleSyncSvc.syncEvents(params
                                                , function(cloudAllEvents,cloudChildEvents, list) {
                                                    var cloudEvents = arrangeItem(cloudAllEvents);
                                                    for (var key in cloudChildEvents) {
                                                        cloudEvents.push(cloudChildEvents[key]);
                                                    }
                                                    var params = compareLocalWithCloudEvent(cloudEvents, list);
                                                    localSyncEvents(1, params.insertResult, function() {
                                                        localSyncEvents(2, params.updateResult, function() {
                                                            localSyncEvents(3, params.deleteResult, function() {
                                                                localdbSyncSvc.clearLocallyDeletedEvents(300,function() {
                                                                    callback && callback(status);
                                                                });
                                                            });
                                                        });
                                                    });

                                                }, function(error) {
                                            errorCB && errorCB(error);
                                        });
                                    });
                                });
                            });

                        }, function(error) {
                            errorCB && errorCB(error);
                        });
                    });
                }
                function syncGoogleTaskList(params, callback, errorCB) {
                    var options = {
                        type: [300],
                        dirtyCheck: true
                    };
                    localdbSyncSvc.getTaskLists(options, function(localTaskLists) {

                        googleSyncSvc.syncTaskLists({list: localTaskLists}, function(googleTaskLists) {

                            localdbSyncSvc.syncTaskLists({type: [300], list: googleTaskLists}, function(status) {
                                localdbSyncSvc.getTaskLists({type: [300], dirtyCheck: false}, function(newLocalTaskLists) {

                                    localdbSyncSvc.getTasks(options, function(params) {
                                        params.task_listList = newLocalTaskLists;
                                        googleSyncSvc.syncTasks(params
                                                , function(cloudAllTasks, list) {
                                                    var params = compareLocalWithCloudTask(cloudAllTasks, list);
                                                    localSyncTasks(1, params.insertResult, function() {
                                                        localSyncTasks(2, params.updateResult, function() {
                                                            localSyncTasks(3, params.deleteResult, function() {
                                                                callback && callback(status);
                                                            });
                                                        });
                                                    });

                                                }, function(error) {
                                            errorCB && errorCB(error);
                                        });
                                    });
                                });
                            });

                        }, function(error) {
                            errorCB && errorCB(error);
                        });
                    });
                }
                function syncSingleGoogleEvent(params, callback) {
                    localdbSyncSvc.getSingleEvent(params, function(params) {
                        googleSyncSvc.syncSingleEvent(params
                                , function(googleEvents) {
                                    localdbSyncSvc.syncSingleEvent({type: [300], list: googleEvents, local_list: params.updateListLocal}, function() {
                                        callback && callback();
                                    });
                                });
                    });
                }
                function syncSingleGoogleTask(params, callback) {
                    localdbSyncSvc.getSingleTask(params, function(params) {
                        googleSyncSvc.syncSingleTask(params
                                , function(gogleTask) {
                                    localdbSyncSvc.syncSingleTask({type: [300], list: gogleTask}, function() {
                                        callback && callback();
                                    });
                                });
                    });

                }
                function syncSingleJorteEvent(params, callback) {

                    localdbSyncSvc.getSingleEvent(params, function(params) {
                        jorteSyncSvc.syncSingleEvent(params
                                , function(jorteEvents, statusFlag) {
                                    if (statusFlag !== 200) {
                                        callback && callback(statusFlag);
                                        return;
                                    }
                                    localdbSyncSvc.syncSingleEvent({type: [0, 100], list: jorteEvents}, function() {
                                        callback && callback(statusFlag);
                                    });
                                });
                    });

                }
                function syncSingleJorteTask(params, callback) {

                    localdbSyncSvc.getSingleTask(params, function(params) {
                        jorteSyncSvc.syncSingleTask(params
                                , function(jorteTask, statusFlag) {
                                    if (statusFlag !== 200) {
                                        callback && callback(statusFlag);
                                        return;
                                    }
                                    localdbSyncSvc.syncSingleTask({type: [1], list: jorteTask}, function() {
                                        callback && callback(statusFlag);
                                    });
                                });
                    });

                }
                function syncSingleJorteTaskList(params, callback) {

                    localdbSyncSvc.getSingleTaskList(params, function(localTaskList) {
                        jorteSyncSvc.syncSingleTaskList({taskList: localTaskList}
                        , function(jorteTaskList, statusFlag) {
                            if (statusFlag !== 200) {
                                callback && callback(statusFlag);
                                return;
                            }
                            localdbSyncSvc.syncSingleTaskList({type: [1], list: jorteTaskList}, function() {
                                callback && callback(statusFlag);
                            });
                        });
                    });

                }

                return {
                    sync: function(params, callback) {

                        if (params.jorteCalendar && !JorteCalendarSyncRunning) {
                            jorteSyncSvc.getJorteAuth(null, function(status) {
                                if (status) {
                                    network_availability(function(isConnected) {
                                        if (isConnected) {
                                            JorteCalendarSyncRunning = true;
                                            $rootScope.syncRunning = true;
                                            showNotificationIcon();
                                            syncJorteCalendar(params, function(statusFlag) {
                                                JorteCalendarSyncRunning = false;
                                                if(!JorteTaskSyncRunning && !GoogleCalendarSyncRunning && !GoogleTasksSyncRunning){
                                                    $rootScope.syncRunning = false;
                                                }
                                                callback && callback();
                                            });
                                        }
                                    });

                                }else{
                                    callback && callback();
                                }

                            });

                        }
                        if (params.jorteTaskList && !JorteTaskSyncRunning) {
                            jorteSyncSvc.getJorteAuth(null, function(status) {
                                if (status) {
                                    network_availability(function(isConnected) {
                                        if (isConnected) {
                                            JorteTaskSyncRunning = true;
                                            $rootScope.syncRunning = true;
                                            showNotificationIcon();
                                            syncJorteTaskList(params, function(statusFlag) {
                                                if (statusFlag === 500) {
                                                    notificationHelperSvc.sendNotification(getMSG('SyncErrorHead'), getMSG('SyncTaskListExeedErrorHead'), 'jorteSyncNotifications', function(notifyObj) {
                                                    });
                                                }
                                                JorteTaskSyncRunning = false;
                                                if(!JorteCalendarSyncRunning && !GoogleCalendarSyncRunning && !GoogleTasksSyncRunning){
                                                    $rootScope.syncRunning = false;
                                                }
                                                callback && callback();
                                            });
                                        }
                                    });

                                }else{
                                    callback && callback();
                                }

                            });
                        }
                        if (params.googleCalendar && !GoogleCalendarSyncRunning) {
                            googleSyncSvc.getGoogleAuth(null, function(status) {
                                if (status) {
                                    network_availability(function(isConnected) {
                                        if (isConnected) {
                                            GoogleCalendarSyncRunning = true;
                                            $rootScope.syncRunning = true;
                                            showNotificationIcon();
                                            syncGoogleCalendar(params, function(status) {
                                                GoogleCalendarSyncRunning = false;
                                                if(!JorteCalendarSyncRunning && !JorteTaskSyncRunning && !GoogleTasksSyncRunning){
                                                    $rootScope.syncRunning = false;
                                                }
                                                callback && callback();
                                            }, function(status) {
                                                callback && callback();
                                            });
                                        }
                                    });

                                }else{
                                    callback && callback();
                                }

                            });
                        }
                        if (params.googleTaskList && !GoogleTasksSyncRunning) {
                            googleSyncSvc.getGoogleAuth(null, function(status) {
                                if (status) {
                                    network_availability(function(isConnected) {
                                        if (isConnected) {
                                            GoogleTasksSyncRunning = true;
                                            $rootScope.syncRunning = true;
                                            showNotificationIcon();
                                            syncGoogleTaskList(params, function() {
                                                GoogleTasksSyncRunning = false;
                                                if(!JorteCalendarSyncRunning && !JorteTaskSyncRunning && !GoogleCalendarSyncRunning){
                                                    $rootScope.syncRunning = false;
                                                }
                                                callback && callback();
                                            });
                                        }
                                    });

                                }else{
                                    callback && callback();
                                }

                            });
                        }
                    },
                    setAutoSync: function(syncItem, minute) {
                        this.removePreviousAlarm(syncItem, function() {
                            if (syncItem && minute) {
                                minute = parseInt(minute);
                                var myDate = new Date();
                                myDate.setMinutes(myDate.getMinutes() + minute);
                                var alarmTime = jorteUtils.formatDate(new Date(myDate), 'MMM dd, yyyy HH:mm:00');
                                notificationHelperSvc.setAlarm(alarmTime, syncItem);
                            }
                        });
                    },
                    getAutoSync: function(mozAlarm) {
                        var lowLevel = [5, 30, 60];
                        var self = this;
                        if (mozAlarm.data && mozAlarm.data.task === jorteConfig.jorteCalendar) {
                            network_availability(function(isConnected) {
                                if (isConnected) {
                                    self.sync({jorteCalendar: true}, function() {
                                        self.sync({jorteTaskList: true}, autoSyncComplted);
                                    });
                                    self.setAutoSync(jorteConfig.jorteCalendar, jorteConfig.getJorteCalendarAutoSync());
                                } else {
                                    if ($.inArray(jorteConfig.getJorteCalendarAutoSync(), lowLevel) >= 0) {
                                        self.setAutoSync(jorteConfig.jorteCalendar, lowLevel[0]);
                                    } else {
                                        self.setAutoSync(jorteConfig.jorteCalendar, lowLevel[1]);
                                    }
                                }
                            });
                        }
                        if (mozAlarm.data && mozAlarm.data.task === jorteConfig.googleCalendar) {
                            network_availability(function(isConnected) {
                                if (isConnected) {
                                    self.sync({googleCalendar: true}, function () {
                                        self.sync({googleTaskList: true}, autoSyncComplted);
                                    });
                                    self.setAutoSync(jorteConfig.googleCalendar, jorteConfig.getGoogleCalendarAutoSync());
                                } else {
                                    if ($.inArray(jorteConfig.getGoogleCalendarAutoSync(), lowLevel) >= 0) {
                                        self.setAutoSync(jorteConfig.googleCalendar, lowLevel[0]);
                                    } else {
                                        self.setAutoSync(jorteConfig.googleCalendar, lowLevel[1]);
                                    }
                                }
                            });
                        }
                    },
                    removePreviousAlarm: function(syncItem, callBack) {
                        var request = navigator.mozAlarms.getAll();
                        request.onsuccess = function(e) {
                            for (var i = 0, item = null; i < e.target.result.length; i++) {
                                item = e.target.result[i];
                                if (item && item.data && item.data.task && item.data.task === syncItem) {
                                    navigator.mozAlarms.remove(item.id);
                                }
                            }
                            callBack && callBack();
                        };
                        request.onerror = function(e) {
                            console.log(e.target.error.name);
                            callBack && callBack();
                        };
                    },
                    syncSingleEvent: function(params, callback) {
                        network_availability(function(isConnected) {
                            if (isConnected) {
                                if (params.jorteCalendar && !JorteCalendarSyncRunning) {

                                    jorteSyncSvc.getJorteAuth(null, function(status) {
                                        if (status) {
                                            JorteCalendarSyncRunning = true;
                                            syncSingleJorteEvent(params, function() {
                                                JorteCalendarSyncRunning = false;
                                                callback && callback();
                                            });
                                        }
                                    });
                                } else if (params.googleCalendar && !GoogleCalendarSyncRunning) {

                                    googleSyncSvc.getGoogleAuth(null, function(status) {
                                        if (status) {
                                            GoogleCalendarSyncRunning = true;
                                            syncSingleGoogleEvent(params, function() {
                                                GoogleCalendarSyncRunning = false;
                                                callback && callback();
                                            });
                                        }
                                    });
                                }
                            }
                            
                        });
                    },
                    syncSingleTask: function(params, callback) {
                        network_availability(function (isConnected) {
                            if (isConnected) {
                                if (params.jorteTaskList && !JorteTaskSyncRunning) {

                                    jorteSyncSvc.getJorteAuth(null, function (status) {
                                        if (status) {
                                            JorteTaskSyncRunning = true;
                                            syncSingleJorteTask(params, function () {
                                                JorteTaskSyncRunning = false;
                                                callback && callback();
                                            });
                                        }
                                    });
                                } else if (params.googleTaskList && !GoogleTasksSyncRunning) {

                                    googleSyncSvc.getGoogleAuth(null, function (status) {
                                        if (status) {
                                            GoogleTasksSyncRunning = true;
                                            syncSingleGoogleTask(params, function () {
                                                GoogleTasksSyncRunning = false;
                                                callback && callback();
                                            });
                                        }
                                    });
                                }
                            }
                        });
                    },
                    syncSingleTaskList: function(params, callback) {
                        network_availability(function(isConnected) {
                            if (isConnected) {
                                if (params.jorteTaskList && !JorteTaskSyncRunning) {
                                    jorteSyncSvc.getJorteAuth(null, function(status) {
                                        if (status) {
                                            JorteTaskSyncRunning = true;
                                            syncSingleJorteTaskList(params, function(statusFlag) {
                                                if (statusFlag === 500) {
                                                    notificationHelperSvc.sendNotification(getMSG('SyncErrorHead'), getMSG('SyncTaskListExeedErrorHead'), 'jorteSyncNotifications', function(notifyObj) {
                                                    });
                                                }
                                                JorteTaskSyncRunning = false;
                                                callback && callback();
                                            });
                                        }
                                    });
                                }
                            }
                        });
                    }
                };
            }]);