/*
 * Calendar worker for calendar slide creation
 */
'use strict';

importScripts('../utils/utils.js');
importScripts('workerCommon.js');

var calSlideMaker = (function() {
    var dayIDs = jorteWorkerCommon.dayIDs;
    var DAY_MS = 86400000;
    var SC, ST;
    function dayOfWeekCol(dayOfWeek) {
        return ((dayOfWeek - ST.firstDay + 7) % 7);
    }

    function daySegHTML(segs, evtCnt, holidayCell) { // also sets seg.left and seg.outerWidth
        var segCnt = segs.length;
        var seg;
        var event;
        var classes;
        var minLeft = 0;
        var maxLeft = SC.viewWidth;
        var leftCol;
        var rightCol;
        var left;
        var top;
        var right;
        var skinCss;
        var html = '';
        var imgArray = [];

        // calculate desired position/dimensions, create html
        for (var i = 0; i < segCnt; i++) {
            seg = segs[i];
            event = seg.event;

            classes = ['fc-event', 'fc-event-hori'];
            if (seg.isStart) {
                classes.push('fc-event-start');
            }
            if (seg.isEnd) {
                classes.push('fc-event-end');
            }

            leftCol = dayOfWeekCol(seg.start.getDay());
            rightCol = dayOfWeekCol(seg.end.getDay() - 1);

            left = seg.isStart ? SC.colWidthNBdr * leftCol : minLeft;
            left += 2;
            right = seg.isEnd ? ((rightCol - leftCol + 1) * SC.colWidthNBdr) : maxLeft;
            right -= 7;
            if (seg.level < SC.maxLevel) {
                top = (seg.row * SC.colHeightNBdr) + SC.headHeight + ((SC.lineHeight * seg.level) + SC.dayNoHeight + seg.level) - seg.row;
                top -= seg.level;
                classes = classes.concat(event.className);
                if (event.source) {
                    classes = classes.concat(event.source.className || []);
                }
                skinCss = jorteWorkerCommon.getSkinCss(event, ST.reverseBand);

                html += "<div";
                html += " class='" + classes.join(' ') + "'" +
                        " style='position:absolute;z-index:8;font-size:" + SC.fontSize + "px;left:" + left + "px;" + skinCss + ';width:' + right + "px;top:" + top + "px'>" +
                        "<div class='fc-event-inner'>";

                html += "<span class='fc-event-title'>" + jorteUtils.htmlEscape(event.title) + "</span></div>";
                html += "</div>";
            }
            seg.left = left;
            seg.outerWidth = right - left;
            seg.startCol = leftCol;
            seg.endCol = rightCol + 1; // needs to be exclusive

            //Keep event count and holidaycell as red            
            var cntCol = evtCnt[seg.row], holCol;
            if (!cntCol) {
                cntCol = [0, 0, 0, 0, 0, 0, 0];
                holCol = [0, 0, 0, 0, 0, 0, 0];
                evtCnt[seg.row] = cntCol;
                holidayCell[seg.row] = holCol;
            }

            for (var k = seg.startCol; k < seg.endCol; k++) {
                if (event.holiday === 1) {
                    holCol[k] = 1;
                }
                //Does not count if event has no title
                if(event.title) { 
                    cntCol[k]++;
                }
            }

            if (event.img) {
                var img = event.img;
                var row = imgArray[seg.row];
                if (!row) {
                    row = [];
                    imgArray[seg.row] = row;
                }
                for (var k = seg.startCol; k < seg.endCol; k++) {

                    var col;
                    col = row[k];
                    if (!col) {
                        col = {length: 0};
                        row[k] = col;
                    }
                    if (col.length < SC.maxImgCount) {
                        if (!col[img]) {
                            col[img] = 1;
                            col.length++;
                        }
                    }
                }
            }
        }

        for (var r in imgArray) {
            var column = imgArray[r];
            r = parseInt(r);
            var imgTop = ((r + 1) * SC.colHeight) + SC.headHeight;
            for (var c in column) {
                var imgList = column[c];
                c = parseInt(c);
                var count = imgList.length;
                var iconSize = 0;
                switch (SC.iconSize) {
                    case 1:
                        iconSize = -3;
                        break;
                    case 2:
                        iconSize = 0;
                        break;
                    case 3:
                        iconSize = 3;
                        break;
                }
                var width = ((SC.colWidth) / count) + iconSize;
                if (width > SC.eventAllHeight + iconSize)
                    width = SC.eventAllHeight + iconSize;
                var top = (imgTop - width) + 3; //Top adjusted
                html += ' <div class="fc-event-icon" style="width:' + SC.colWidth + 'px;left:' +
                        (c * (SC.colWidth + 1) + c) + 'px;top:' + top + 'px;">';

                for (var i in imgList) {
                    if (i === 'length')
                        continue;
                    img = i;
                    html += '<img class="evt_icon"  style="float:right;left:' +
                            width + 'px" src="' + img + '" height=' + (width - 3) + '>';
                }
                html += '</div>';
            }
        }
        return html;
    }

    function renderSlide(data) {
        var resp = {};
        resp.id = data.id;
        resp.time = data.time;

        var start = data.start;
        var visStart = data.visStart;
        var visEnd = data.visEnd;

        var rowCnt = Math.round((visEnd - visStart) / (DAY_MS * 7));
        jorteUtils.addDays(visEnd, (6 - rowCnt) * 7);
        rowCnt = 6;
        var colCnt = 7;

        var html = '';
        var i, j;
        var headerClass = "fc-widget-header";
        var contentClass = "fc-widget-content";
        var month = start.getMonth();
        var today = jorteUtils.clearTime(new Date());
        var cellDate;
        var cellClasses;
        var evtCnt = [], holidayCell = [];
        var evtHtml = daySegHTML(jorteWorkerCommon.compileSegs(data.events, visStart, 1), evtCnt, holidayCell);
        html += "<table class='fc-border-separate' style='width:100%' cellspacing='0'><thead><tr>";

        for (i = 0; i < colCnt; i++) {
            cellDate = jorteUtils.addDays(jorteUtils.cloneDate(visStart), i);
            html += "<th class='th_border_color fc-day-header fc-" + dayIDs[cellDate.getDay()] + " " + headerClass + "'><div style='margin-top: 0.1em; margin-bottom: 0.1em;'>" + SC.dayNamesShort[cellDate.getDay()] + "</div></td>";
        }

        html += "</tr></thead><tbody>";

        var cntR, cntC, dayNo, holR, holC;
        for (i = 0; i < rowCnt; i++) {
            html += "<tr class='fc-week'>";
            cntR = evtCnt[i];
            holR = holidayCell[i];
            for (j = 0; j < colCnt; j++) {

                cntC = cntR ? cntR[j] : undefined;
                holC = holR ? holR[j] : 0;

                cellDate = jorteUtils.addDays(jorteUtils.cloneDate(visStart), i * 7 + j);
                dayNo = cellDate.getDay();
                if (holC === 1) { // Set holiday cell color as red
                    cellClasses = 'th_border_color fc-day ' + 'fc-sun' + " " + contentClass;
                } else {
                    cellClasses = 'th_border_color fc-day ' + 'fc-' + dayIDs[dayNo] + " " + contentClass;
                }

                if (cellDate.getMonth() !== month) {
                    cellClasses += ' fc-other-month';
                }
                var clickedDate = cellDate.getTime();
                html += "<td ng-click='dayClick(" + clickedDate + ")' class='" + cellClasses + "' data-date='" + jorteUtils.formatDate(cellDate, 'yyyy-MM-dd') + "'>";

                html += "<div style='height:" + SC.colHeight + "px;width:" + SC.colWidth + "px'>";

                if (+cellDate === +today) {
                    html += "<div class='today_bar' style='width:" + (SC.colWidth - 2) + "px;'></div>";
                }

                html += "<div class='fc-day-number'>" + cellDate.getDate() + "</div>";
                if (cntC && cntC > SC.maxLevel) {
                    var cntWidth = 8 + (cntC / 100) * jorteWorkerCommon.getlength(cntC);
                    html += '<div class="fc-event-total-number" style="width:' + (cntWidth) + 'px;text-align: center;"><div style="padding-top: 0.12em;">' + cntC + '</div></div>';
                    
                } else if (ST.showWeekNumber && dayNo === 1) {
                    html += '<div class="fc-week-number-custom">' + jorteUtils.formatDate(cellDate, 'W') + '</div>';
                }
                html += "<div class='fc-day-content'><div style='position:relative'></div></div></div></td>";
            }

            html += "</tr>";
        }

        html += "</tbody>" + "</table>";

        var slideHtml = '<div class="cal_slide fc fc-ltr"><table class="fc-header" style="width: 100%"><tbody><tr><td class="fc-header-left">';
        slideHtml += '<span class="fc-header-title fc-header-title-left-margin" ng-click="onShowDateClick(' + start.getTime() + ')">';
        slideHtml += jorteUtils.formatDate(start, SC.YearMonthOnlyFormat1, SC);
        slideHtml += '</span></td></tr></tbody></table>';
        slideHtml += '<div class="fc-content" style="position: relative; min-height: 1px;"><div class="fc-view fc-view-month fc-grid" style="position: relative; min-height: 1px;" unselectable="on"><div style="position:absolute;z-index:8;top:0;left:0">';
        slideHtml += evtHtml;
        slideHtml += '</div>';
        slideHtml += html;
        slideHtml += '</div></div></div>';

        resp.html = slideHtml;

        return resp;
    }

    function fetchEvents(data) {
        var calD = data.calData;
        var rows = [];
        if (calD) {
            var calDParsed = jorteWorkerCommon.sortEvents(calD, data.displayOrder);
            rows = calDParsed;
        }

        data.events = jorteWorkerCommon.getData(rows, SC, ST, 1);
        var result = renderSlide(data);
        self.postMessage({cmd: data.cmd, result: result, msg: 'ShowEvent' + data.id});
    }

    return {
        /*
         * Woker message handler to initialize, update and creating calendar slide html
         */
        msgHandler: function(e) {
            var data = e.data;

            switch (data.cmd) {
                case 'ShowEvent':
                    fetchEvents(data);
                    break;
                case 'Init':
                    SC = data.screen;
                    ST = data.options;
                    break;
                case 'OptionUpdate':
                    ST = data.options;
                    break;
            }
        }
    };
}());

self.addEventListener('message', calSlideMaker.msgHandler, false);