/*
 * Calendar worker for calendar slide creation
 */
'use strict';

importScripts('../utils/utils.js');
importScripts('workerCommon.js');

var calSlideMaker = (function() {
    var dayIDs = jorteWorkerCommon.dayIDs;
    var SC, ST;
    /*
     * 
     * @param {type} dayOfWeek
     * @returns {ST.firstDay|Number}
     */
    function dayOfWeekCol(dayOfWeek) {
        return ((dayOfWeek - ST.firstDayWeek + 7) % 7);
    }

    function daySegHTML(segs, evtCnt, holidayCell) { // also sets seg.left and seg.outerWidth
        var segCnt = segs.length;
        var seg;
        var event;
        var classes;
        var minLeft = 0;
        var leftCol;
        var rightCol;
        var left;
        var top;
        var right;
        var skinCss;
        var html = '';
        var imgArray = [];

        // calculate desired position/dimensions, create html
        for (var i = 0; i < segCnt; i++) {
            seg = segs[i];
            event = seg.event;
            classes = ['fc-event', 'fc-event-hori'];
            if (seg.isStart) {
                classes.push('fc-event-start');
            }
            if (seg.isEnd) {
                classes.push('fc-event-end');
            }
            leftCol = dayOfWeekCol(seg.start.getDay());
            rightCol = dayOfWeekCol(seg.end.getDay() - 1);
            left = seg.isStart ? SC.colWidthNBdr * leftCol : minLeft;
            left += 2;
            right = SC.viewWidth - 78;
            if (seg.level < SC.maxLevelWeek) {
                top = seg.row * (SC.rowHeightWeek + SC.heightAdj + 1) + (SC.lineHeightWeek * seg.level) - (2 * seg.level);
                top += 2;
                classes = classes.concat(event.className);
                if (event.source) {
                    classes = classes.concat(event.source.className || []);
                }
                skinCss = jorteWorkerCommon.getSkinCss(event, ST.reverseBand);

                html += "<div";
                html += " class='" + classes.join(' ') + "'" +
                        " style='position:absolute;z-index:8;left:75px;font-size:" + SC.fontSizeWeek + "px;" + skinCss + ';width:' + right + "px;top:" + top + "px'>" +
                        "<div class='fc-event-inner'>";
                var time = "";
                var timeExistCheck = (jorteUtils.formatDate(event.start, 'HHmm') / 1); //For not showing time which has no start time
                if ((event.allDay !== true && event.notimeEvents === 0) && event.type !== 2) {
                    time = (timeExistCheck !== 0) ? jorteUtils.formatDate(event.start, 'HH:mmtt') + "-" : '';
                }
                html += "<span class='fc-event-title'>" + time + jorteUtils.htmlEscape(event.title) + "</span>";
                html += "</div></div>";
            }
            seg.left = left;
            seg.outerWidth = right - left;
            seg.startCol = leftCol;
            seg.endCol = rightCol + 1; // needs to be exclusive

            //Keep event count
            var cntCol = evtCnt[seg.row], holCol;
            if (!cntCol) {
                cntCol = [0, 0, 0, 0, 0, 0, 0];
                holCol = [0, 0, 0, 0, 0, 0, 0];
                evtCnt[seg.row] = cntCol;
                holidayCell[seg.row] = holCol;
            }

            for (var k = seg.startCol; k < seg.endCol; k++) {
                if (event.holiday === 1) {
                    holCol[k] = 1;
                }
                //Does not count if event has no title
                if(event.title) { 
                    cntCol[k]++;
                }
            }

            if (event.img) {
                var img = event.img;
                var row = imgArray[seg.row];
                if (!row) {
                    row = [];
                    imgArray[seg.row] = row;
                }
                for (var k = seg.startCol; k < seg.endCol; k++) {

                    var col;
                    col = row[k];
                    if (!col) {
                        col = {length: 0};
                        row[k] = col;
                    }
                    if (col.length < SC.maxImgCount) {
                        if (!col[img]) {
                            col[img] = 1;
                            col.length++;
                        }
                    }
                }
            }
        }
        for (var r in imgArray) {
            var column = imgArray[r];
            r = parseInt(r);
            for (var c in column) {
                var imgList = column[c];
                c = parseInt(c);
                var imgTop = ((c) * (SC.rowHeightWeek  + SC.heightAdj + 1)) + SC.titleHeight - 3;
                var count = imgList.length;
                var iconSize = 0;
                switch (SC.iconSize) {
                    case 1:
                        iconSize = -3;
                        break;
                    case 2:
                        iconSize = 0;
                        break;
                    case 3:
                        iconSize = 3;
                        break;
                }
                var width = ((SC.colWidthWeek) / count) + iconSize;
                if (width > SC.eventAllHeight + iconSize)
                    width = SC.eventAllHeight + iconSize;
                var top = imgTop;
                html += ' <div class="fc-event-icon" style="width:' + SC.viewWidth + 'px;' +
                        'top:' + top + 'px;">';
                for (var i in imgList) {
                    if (i === 'length')
                        continue;
                    img = i;
                    html += '<img class="evt_icon"  style="float:right;left:' +
                            width + 'px" src="' + img + '" height="' + width + '">';
                }
                html += '</div>';
            }
        }
        return html;
    }

    function renderSlide(data) {
        var resp = {};
        resp.id = data.id;
        resp.time = data.time;

        var visStart = data.visStart;
        var rowCnt = 7;
        var html = '';
        var contentClass = "fc-widget-content";
        var today = jorteUtils.clearTime(new Date());
        var cellDate; // not to be confused with local function. TODO: better names
        var cellClasses;
        var evtCnt = [], holidayCell = [];

        var evtHtml = daySegHTML(jorteWorkerCommon.compileSegs(data.events, visStart, 2), evtCnt, holidayCell);

        html += "<table class='fc-border-separate' style='width:100%' cellspacing='0'>" + "<thead>" + "<tr>";
        html += "" +
                "</thead>" +
                "<tbody>";

        var cntR, cntC, dayNo, holR, holC;
        for (var i = 0; i < rowCnt; i++) {
            html += "<tr class='fc-week'>";
            cntR = evtCnt[i];
            holR = holidayCell[i];
            cntC = cntR ? cntR[i] : undefined;
            holC = holR ? holR[i] : 0;

            cellDate = jorteUtils.addDays(jorteUtils.cloneDate(visStart), i);
            dayNo = cellDate.getDay();
            if (holC === 1) { // Set holiday cell color as red
                cellClasses = 'th_border_color fc-day ' + 'fc-sun' + " " + contentClass;
            } else {
                cellClasses = 'th_border_color fc-day ' + 'fc-' + dayIDs[dayNo] + " " + contentClass;
            }

            if (!(dayIDs[dayNo] === 'sun' || dayIDs[dayNo] === 'sat')) {
                cellClasses += ' normaldaycell';
            } else if (dayIDs[dayNo] === 'sat') {
                cellClasses += ' saturdaycell';
            } else if (dayIDs[dayNo] === 'sun') {
                cellClasses += ' sundaycell';
            }
            var clickedDate = cellDate.getTime();
            html += "<td ng-click='dayClick(" + clickedDate + ")' " +
                    " class='" + cellClasses + "'" +
                    " data-date='" + jorteUtils.formatDate(cellDate, 'yyyy-MM-dd') + "'" +
                    ">";
            html += "<div style='height:" + (SC.heightAdj + SC.rowHeightWeek) + "px;width: 100%'>";

            if (+cellDate === +today) {
                html += "<div class='week_today_bar'></div>";
            }

            html += "<div class='fc-week-day-number'>" + cellDate.getDate() + '[' + SC.dayNamesShort[dayNo] + "]</div>";
            if (ST.showWeekNumber && dayNo === 1) {
                html += '<div class="fc-week-number-week">W' + jorteUtils.formatDate(cellDate, 'WW') + '</div>';
            } 
            if (cntC && cntC >= SC.maxLevel) {
                var cntWidth = 13 + (cntC / 100) * jorteWorkerCommon.getlength(cntC);
                html += '<div class="fc-event-total-number-week" style="width:' + (cntWidth) + 'px;text-align: center;top: 1px;"><div style="padding-top: 0.12em;">' + cntC + '</div></div>';
            }

            html += "<div class='fc-day-content'>" +
                    "<div style='position:relative'></div>" +
                    "</div>" +
                    "</div>" +
                    "</td>";
            html += "</tr>";
        }

        html += "</tbody>" + "</table>";

        var slideHtml = '<div class="cal_slide fc fc-ltr"><table class="fc-header" style="width: 100%"><tbody><tr><td class="fc-header-left"><span class="fc-header-title fc-header-title-left-margin" ng-click="onShowDateClick(' + visStart.getTime() + ')">';
        var weekStart = jorteUtils.addDays(jorteUtils.cloneDate(visStart), 0);

        slideHtml += jorteUtils.formatDate(weekStart, SC.YearMonthOnlyFormat1, SC);
        slideHtml += '</span></td><td class="fc-header-center"></td><td class="fc-header-right"></td></tr></tbody></table>';
        slideHtml += '<div class="fc-content" style="position: relative; min-height: 1px;"><div class="fc-view fc-view-month fc-grid" style="position: relative; min-height: 1px;" unselectable="on"><div style="position:absolute;z-index:8;top:0;left:0">';
        slideHtml += evtHtml;
        slideHtml += '</div>';
        slideHtml += html;
        slideHtml += '</div></div></div>';

        resp.html = slideHtml;

        return resp;
    }

    function fetchEvents(data) {
        var calD = data.calData;
        var rows = [];
        if (calD) {
            var calDParsed = jorteWorkerCommon.sortEvents(calD, data.displayOrder);
            rows = calDParsed;
        }

        data.events = jorteWorkerCommon.getData(rows, SC, ST, 2);
        var result = renderSlide(data);
        self.postMessage({cmd: data.cmd, 'result': result, 'msg': 'ShowEvent' + data.id});
    }

    return {
        /*
         * Woker message handler to initialize, update and creating calendar slide html
         */
        msgHandler: function(e) {
            var data = e.data;

            switch (data.cmd) {
                case 'ShowEvent':
                    fetchEvents(data);
                    break;
                case 'Init':
                    SC = data.screen;
                    ST = data.options;
                    break;
                case 'OptionUpdate':
                    ST = data.options;
                    break;
            }
        }
    };
}());

self.addEventListener('message', calSlideMaker.msgHandler, false);