'use strict';
var jorteWorkerCommon = (function () {

    function hexToRGB(h) {
        var clrCode = (h.charAt(0) === '#') ? h.substring(1, 7) : h;
        return parseInt((clrCode).substring(0, 2), 16) +
                ',' + parseInt((clrCode).substring(2, 4), 16) +
                ',' + parseInt((clrCode).substring(4, 6), 16);
    }

    function segsCollide(seg1, seg2) {
        return (seg1.end > seg2.start && seg1.start < seg2.end) && !((seg1.event.id === seg2.event.id) && (seg1.event.type === seg2.event.type) && !((seg1.event.id === seg2.event.id) && (seg1.event.allDay === seg2.event.allDay)));
    }

    function segCmp(a, b) {
        return (b.msLength - a.msLength) * 100 + (a.event.start - b.event.start);
    }

    function exclEndDay(event) {
        if (event.end) {
            return jorteUtils.addDays(jorteUtils.cloneDate(event.end), 1);
        } else {
            return jorteUtils.addDays(jorteUtils.cloneDate(event.start), 1);
        }
    }

    function sliceSegs(events, visEventEnds, start, end) {
        var segs = [];
        for (var i = 0; i < events.length; i++) {
            var event = events[i];
            var eventStart = event.start;
            var eventEnd = visEventEnds[i];
            if (eventEnd > start && eventStart < end) {
                var segStart, isStart;
                if (eventStart < start) {
                    segStart = jorteUtils.cloneDate(start);
                    //changed false to true
                    isStart = true;
                } else {
                    segStart = eventStart;
                    isStart = true;
                }
                var segEnd, isEnd;
                if (eventEnd > end) {
                    segEnd = jorteUtils.cloneDate(end);
                    //changed false to true
                    isEnd = true;
                } else {
                    segEnd = eventEnd;
                    isEnd = true;
                }
                segs.push({
                    event: event,
                    start: segStart,
                    end: segEnd,
                    isStart: isStart,
                    isEnd: isEnd,
                    msLength: segEnd - segStart
                });
            }
        }
        return segs.sort(segCmp); //fixed for sort events
    }

    // event rendering calculation utilities
    function stackSegs(segs) {
        var levels = [],
                i, len = segs.length, seg,
                j, collide, k;
        for (i = 0; i < len; i++) {
            seg = segs[i];
            j = 0; // the level index where seg should belong
            while (true) {
                collide = false;
                if (levels[j]) {
                    for (k = 0; k < levels[j].length; k++) {
                        //Collide if the event title is not empty, for weather calendar title is empty                        
                        if (levels[j][k].event.title) {
                            if (segsCollide(levels[j][k], seg)) {
                                collide = true;
                                break;
                            }
                        }
                    }
                }
                if (collide) {
                    j++;
                } else {
                    break;
                }
            }

            if (levels[j]) {
                levels[j].push(seg);
            } else {
                levels[j] = [seg];
            }
        }
        return levels;
    }

    function eventIcon(row) {
        var icon;
        if (row.icon_id.indexOf("http") !== -1) {
            icon = row.icon_id;
        } else {
            var icnMap = JSON.parse(row.icon_map);
            if (icnMap['default'] !== undefined) {
                icnMap = icnMap['default'];
            } else if (icnMap['logo'] !== undefined) {
                icnMap = icnMap['logo'];
            } else {
                icnMap = null;
            }

            var iconArray = row.icon_id.split(/[\/|_!\-\+&,:\*]/);
            var n = row.icon_id.match(/[\/|_!\-\+&,:\*]/g);
            if (Array.isArray(n)) {
//                icon = icnMap[iconArray[0]] + ' ' + n[0] + ' ' + icnMap[iconArray[1]];
                icon = icnMap[iconArray[0]];//For Dec Version
            } else {
                icon = (icnMap[iconArray[0]].indexOf("http") !== -1) ? icnMap[iconArray[0]] : row.icon;
            }
        }
        return icon;
    }
    function sortEvents(data, dispOrder) {
        var events = [];
        for (var i in data) {
            events.push(data[i]);
        }
        if (dispOrder === 0) {//order by start-date-time
            for (var i = 0; i < events.length; i++) {
                for (var j = 0; j < events.length - i - 1; j++) {
                    if (jorteUtils.compare(events[j], events[j + 1], 'begin') > 0) {
                        var temp = events[j];
                        events[j] = events[j + 1];
                        events[j + 1] = temp;
                    } else if (events[j].begin === events[j + 1].begin) {
                        if (jorteUtils.compare(events[j], events[j + 1], 'id') > 0) {
                            var temp = events[j];
                            events[j] = events[j + 1];
                            events[j + 1] = temp;
                        }
                    }

                    if (jorteUtils.compare(events[j], events[j + 1], 'all_day') < 0) {
                        var temp = events[j];
                        events[j] = events[j + 1];
                        events[j + 1] = temp;
                    }

                }
            }
        } else { //order by importance, date time
            for (var i = 0; i < events.length; i++) {
                for (var j = 0; j < events.length - i - 1; j++) {

                    if (jorteUtils.compare(events[j], events[j + 1], 'begin') > 0) {
                        var temp = events[j];
                        events[j] = events[j + 1];
                        events[j + 1] = temp;
                    } else if (events[j].begin === events[j + 1].begin) {
                        if (jorteUtils.compare(events[j], events[j + 1], 'id') > 0) {
                            var temp = events[j];
                            events[j] = events[j + 1];
                            events[j + 1] = temp;
                        }
                    }

                    if (jorteUtils.compare(events[j], events[j + 1], 'all_day') < 0) {
                        var temp = events[j];
                        events[j] = events[j + 1];
                        events[j + 1] = temp;
                    } else if (events[j].all_day === events[j + 1].all_day) {
                        if (jorteUtils.compare(events[j], events[j + 1], 'importance') < 0) {
                            var temp = events[j];
                            events[j] = events[j + 1];
                            events[j + 1] = temp;
                        }
                    }
                }
            }
        }
        return events;
    }
    return {
        dayIDs: ['sun', 'mon', 'tue', 'wed', 'thu', 'fri', 'sat'],
        /*
         * To set color and background color of event
         */
        getSkinCss: function(event, reverseBar) {
            var textColor = event.textColor;
            var statements = [];
            if (textColor) {
                if (event.allDay) {
                    if (reverseBar) {
                        statements.push('color: #ffffff');
                        statements.push('background-color:rgba(' + hexToRGB(textColor) + ',0.8)');
                        statements.push('border-color:' + textColor);
                    } else {
                        statements.push('color:' + textColor);
                        statements.push('background-color:rgba(' + hexToRGB(textColor) + ',0.1)');
                        statements.push('border-color:' + textColor);
                    }
                } else {
                    statements.push('color:' + textColor);
                    statements.push('border:none');
                }
            }
            return statements.join(';');
        },
        compileSegs: function(events, visStart, type) {
            var rowCnt = (type === 1) ? 6 : 7;
            var colCnt = (type === 1) ? 7 : 1;
            var d1 = jorteUtils.cloneDate(visStart);
            var d2 = jorteUtils.addDays(jorteUtils.cloneDate(d1), colCnt);
            var i, j, k;
            var segs = [];
            var visEventsEnds = [];
            for (i = 0; i < events.length; ++i) {
                visEventsEnds[i] = exclEndDay(events[i]);
            }
            for (i = 0; i < rowCnt; i++) {
                var row = stackSegs(sliceSegs(events, visEventsEnds, d1, d2));
                for (j = 0; j < row.length; j++) {
                    var level = row[j];
                    for (k = 0; k < level.length; k++) {
                        var seg = level[k];
                        seg.row = i;
                        seg.level = j; //
                        segs.push(seg);
                    }
                }
                jorteUtils.addDays(d1, colCnt);
                jorteUtils.addDays(d2, colCnt);
            }
            return segs;
        },
        getData: function(rows, SC, ST, type) {
            var events = [], row, nameHoliday;

            for (var i = 0; i < rows.length; i++) {
                row = rows[i];
                nameHoliday = "";
                if (row.holiday === 1 && !row.name) {
                    nameHoliday = SC.NoSubjectHoliday;
                }
                var name = row.name ? row.name : (nameHoliday ? nameHoliday : SC.NoSubjectHead);
                var icon = row.icon;
                var allDay = row.all_day;
                var end;
                var notimeEvents = 0;
                if (row.type === 1) {
                    end = row.begin;
                    allDay = 0;
                } else if (row.type === 2) {
                    end = row.end;
                    if (row.icon_only === 1) {
                        name = "";
                        allDay = 0;
                    }
                    if (row.icon_id) {
                        icon = eventIcon(row);
                    }
                } else {
                    end = row.end;
                    if (!row.start_time && !row.end_time) {
                        notimeEvents = 1;
                    }
                }

                var color;
                if ((row.importance && !row.completed) || row.holiday || row.provider === 200) {
                    color = ST.COLORS.red;
                } else if (row.completed && ST.dispCompletedEvents === 1) {
                    color = ST.COLORS.completed;
                } else if (row.color) {
                    color = row.color;
                } else {
                    var eventColor = ST.themeTitleColor[ST.currentTheme - 1];
                    color = row.cal_color ? row.cal_color : (row.type !== 1 ? eventColor : ST.COLORS.taskDefault);
                }

                var stDt = row.begin ? new Date(row.begin) : '';

                var endDt = end ? new Date(end) : '';
                if (!allDay && row.holiday) {
                    allDay = 1;
                } else if (row.begin && end && (
                        (endDt.getDate() - stDt.getDate() > 0) ||
                        (endDt.getMonth() - stDt.getMonth() > 0) ||
                        (endDt.getFullYear() - stDt.getFullYear() > 0))) {
                    allDay = 1;
                }
                var rec = {
                    id: row.id,
                    type: row.type,
                    title: name,
                    start: stDt,
                    end: endDt,
                    img: icon,
                    allDay: (allDay !== 0) ? true : false,
                    importance: row.importance,
                    completed: row.completed,
                    holiday: row.holiday,
                    textColor: color,
                    notimeEvents: notimeEvents
                };
                events.push(rec);
            }
            return events;
        },
        sortEvents: function(data, dispOrder) {
            return sortEvents(data, dispOrder);
        },
        getlength: function(number) {
            return number.toString().length;
        }
    };
}());
