var btnCompose = document.getElementById("btnCompose"),
	btnOpen = document.getElementById("btnOpen"),
	btnBack = document.getElementById("btnBack"),
	btnExec = document.getElementById("btnExec"),
	btnExecCmd = document.getElementById("btnExecCmd"),
	btnBackExec = document.getElementById("btnBackExec"),
	inpCmd = document.getElementById("inpCmd"),
	results = document.getElementById("results"),
	sandbox;

function on(event, el, fn){
	el.addEventListener(event, fn);
}

on('click', btnCompose, function(event) {
	event.preventDefault();

	btnOpen.style = "";

	editor.setValue("");
	
	document.querySelector('#edit').className = 'current';
    document.querySelector('[data-position="current"]').className = 'left';
});

on('click', btnOpen, function(event) {
	event.preventDefault();

	document.querySelector('#edit').className = 'current';
    document.querySelector('[data-position="current"]').className = 'left';
});

on('click', btnBack, function(event) {
	event.preventDefault();
	
	document.querySelector('#edit').className = 'right';
    document.querySelector('[data-position="current"]').className = 'current';
});

on('click', btnExec, function(event) {
	event.preventDefault();

	var iframe = document.createElement("iframe");
	iframe.style = "width: 0; height: 0; display: none;";
	document.body.appendChild(iframe);

	sandbox = iframe.contentWindow;

	results.innerHTML = "";

	/*
	for (var ent in ["log", "debug", "info", "assert", "dir", "error"]){
		evaluate("window.console[" + ent + "] = function () { window.dispatchEvent(new CustomEvent ('" + ent + "', arguments)) }");
		on(ent, sandbox.window, function(event) {
			event.preventDefault();
			
			for (var i = event.length - 1; i >= 0; i--)
				results.innerHTML += event[i];
		});
	}
	*/

	evaluate("window.console.clear = function () { window.dispatchEvent(new Event ('clear')) }");

	call(editor.getValue());
	
	on('clear', sandbox.window, function(event) {
		event.preventDefault();
		
		results.innerHTML = "";
	});
	
	document.querySelector('#exec').className = 'current';
    document.querySelector('[data-position="current"]').className = 'left';
});

on('click', btnBackExec, function(event) {
	event.preventDefault();
	
	document.querySelector('#exec').className = 'right';
    document.querySelector('[data-position="current"]').className = 'current';
});

on('click', btnExecCmd, function(event) {
	event.preventDefault();
	
	call(inpCmd.value);
	inpCmd.value = "";
});

on('keyup', inpCmd, function(event) {
	event.preventDefault();

	if(event.keyCode == 13) btnExecCmd.click();
});

window.editor = CodeMirror.fromTextArea(document.getElementById("textArea"), {
    lineNumbers: true,
    matchBrackets: true,
    continueComments: "Enter",
    mode: "text/typescript"
});

function evaluate (cmd) {
	var result;

	try {
		result = sandbox.eval(cmd);
	    if(result == "[object Object]") 
	        result = (sandbox.eval ? sandbox.eval("JSON.stringify(" + cmd + ");") : eval("JSON.stringify(" + cmd + ");"));
	} catch(e){
	    result = '<div style="color: red;">' + e + '</div>';
	}

	return result;
}

function call (cmd){
	var result = evaluate(cmd);

	results.innerHTML += ">> " + cmd + '<br><hr>' + result + "<hr>";
}