function calc() {
    "use strict";
    var form = document.mainForm,
        t1 = parseFloat(document.getElementById('tx1').value),
        t2 = parseFloat(document.getElementById('tx2').value),  
        t3 = parseFloat(document.getElementById('tx3').value),
        ans = document.getElementById('ans'),
        str = check();         
    
    if (form.tx1.value == "" || form.tx2.value == "" || form.tx3.value == "") {
        ans.innerHTML = ans.innerHTML + "<div id=\"resposta\" class=\"res\"><span>Aviso:</span><br><p>Um dos campos não está preenchido!</p><button onclick=\"deletar()\" class=\"btn\">Apagar Resposta</button></div>";
    } else if (isNaN(t1) || isNaN(t2) || isNaN(t3)) {
        ans.innerHTML = ans.innerHTML + "<div id=\"resposta\" class=\"res\"><span>Aviso:</span><br><p>Uma das respostas não é numérica</p><button onclick=\"deletar()\" class=\"btn\">Apagar Resposta</button></div>";
    } else if (str == "N") {
        ans.innerHTML = ans.innerHTML + "<div id=\"resposta\" class=\"res\"><span>Aviso:</span><br><p>você tem que escolher entre juros simples e compostos!</p><button onclick=\"deletar()\" class=\"btn\">Apagar Resposta</button></div>";
    } else if (str == "JS") {
        var jurosSimples = (t1 * t2 * t3) / 100,
            montante = jurosSimples + t1;
        ans.innerHTML = ans.innerHTML + "<div id=\"resposta\" class=\"res\"><p>A taxa de juros é: " + jurosSimples.toFixed(2) + "</p><p>O montante é: "+ montante.toFixed(2) +"</p><button onclick=\"deletar()\" class=\"btn\">Apagar Resposta</button></div>";
    } else if (str == "JC") {
        var jurosCompostos = t1 * (1 + t2) ^ t3;
        ans.innerHTML = ans.innerHTML + "<div id=\"resposta\" class=\"res\"><p>o montante é: " + jurosCompostos.toFixed(2) + "</p><button onclick=\"deletar()\" class=\"btn\">Apagar Resposta</button></div>";
    }
}

function deletar() {
    "use strict";
    var element = document.getElementById("resposta");
    element.parentNode.removeChild(element);
}
function limpar() {
    "use strict";
    document.getElementById('tx1').value = "0.00";
    document.getElementById('tx2').value = "0.00";
    document.getElementById('tx3').value = "0.00";
    
    document.getElementById('simples').checked = false;
    document.getElementById('composto').checked = false;
}

function check() {
    "use strict";
    var radio1 = document.getElementById('simples'),
        radio2 = document.getElementById('composto');
    if (radio1.checked == false && radio2.checked == false) {
        return "N";
    } else if (radio1.checked == true) {
        return "JS";
    } else if (radio2.checked == true) {
        return "JC";
    }
}