var myDebugger = true;
var currentProjectCategory = -1;
var screenState = 0;
var baseurl = "http://ws.k1ckstart3r.com/kickstarter/kickstarter.asmx";
var arrProjects = []; // new Array();
var arrSubCategories = [];
var arrFollowing = [];
var arrSearchResults = [];
var currentProjectId = 0;
var currentProjectStatisticsUrl = '';
var currentScreenState = 0;


/*var htmlListItem = "";
htmlListItem += '<li class="media" id="$id$">';
htmlListItem += '  <a class="pull-left" href="#">';
htmlListItem += '    <img class="media-object" src="$src$" width="64px" height="64px" />';
htmlListItem += '  </a>';
htmlListItem += '  <div class="media-body">';
htmlListItem += '    <h4 class="media-heading">$heading$</h4>';
// htmlListItem += '      ...';
htmlListItem += '  </div>';
htmlListItem += '</li>';*/


htmlListItem = ""
htmlListItem += "<li id='$id$'><div class='panel panel-default'>";
htmlListItem += "    <a href='#modalProject' data-toggle='modal' class='list-group-item'><div class='panel-body'>";
htmlListItem += "        <div class='panel-info'>";
htmlListItem += "            <img class='media-object' src='$src$' width='64px' height='64px' />";
htmlListItem += "        </div>";
htmlListItem += "        <div class='panel-body'>";
htmlListItem += "            <h4>$heading$</h4>";
htmlListItem += "        </div>";
htmlListItem += "    </div></a>";
htmlListItem += "</div></li>";


// Prevent scrolling of main content when modal is open
$("#modalProject").on("show", function () {
	logging("Modal opened: prevent scrolling");
	$("body").addClass("modal-open");
}).on("hidden", function () {
logging("Modal closed: stop prevent scrolling");
	$("body").removeClass("modal-open")
});


function logging(msg) {
	if (myDebugger === true) {
		var date = new Date();
		console.log(date + ': ' + msg);
	}
}

function initialize() {
	logging("initialize");
	this.bindEvents();
}

// Bind any events that are required on startup. Common events are:
// 'load', 'deviceready', 'offline', and 'online'.
function bindEvents() {
	logging("bindEvents");
	document.addEventListener('deviceready', this.onDeviceReady, false);
	document.addEventListener('backbutton', onBackKeyDown, false);
	document.addEventListener('keypress', onKeyDown, false);



	// Check if we are in the browser or in a Cordova recognized device
	if (typeof (device) !== 'undefined') {
		if ("android|blackberry 10|firefoxos|ios|wince|tizen".indexOf(device.platform.toLowerCase()) > -1) {
			logging("A cordova recognized device");
		}
	} else {
		logging("Probably a normal browser is used");
		$(window).resize(function () {
			if ($('#modalProject').hasClass('in')) {
				resizeVideoJs();
			}
		});
		
		// Disable the like button for now
		// $("#btnLike").hide();
	}

	this.onDeviceReady();
}


function onKeyDown() {
	console.log("A key was pressed");
	switch (currentScreenState) {
	case 0:
		// exit App or do nothing
		break;
	case 1:
		$("#divProjects").hide();
		$("#divCategories").show();
		break;
	}
}


function onBackKeyDown() {
	console.log("Backspace pressed");
	switch (currentScreenState) {
	case 0:
		// exit App or do nothing
		break;
	case 1:
		$("#divProjects").hide();
		$("#divCategories").show();
		break;
	}
}

// deviceready Event Handler
// The scope of 'this' is the event.
function onDeviceReady() {
	logging("onDeviceReady event has fired");
	$('.selectpicker').selectpicker();
	loadCategories();
	loadFavorites();
	loadSubCategories();

	window.setTimeout("initFacebook();", 3000);
}

$("#ddSubCategories").change(function () {
	logging('Selected value: ' + $("#ddSubCategories option:selected").val() + " / id: " + this.id);
	fillProjectsList($("#ddSubCategories option:selected").val());
});

function hideNavbarDropdown() {
	$("#navbarCollapse").removeClass("in");
	$("#navbarCollapse").css('height', '1px');
}


$("#navbarbrand").on("click", function (e) {
	logging("Clicked: Navbar brand button");
	hideNavbarDropdown();
	$("#divCategories").show();
	$("#divProjects").hide();
	$("#divFavorites").hide();
	$("#divSearch").hide();

	// Set active tab
	$("#liFavorites").removeClass('active');
	$("#liSearch").removeClass('active');
	$("#liHome").addClass('active');
	e.preventDefault();
});

$("#mnuHome").on("click", function (e) {
	logging("Clicked: Home");
	hideNavbarDropdown();
	$("#divCategories").show();
	$("#divProjects").hide();
	$("#divFavorites").hide();
	$("#divSearch").hide();

	// Set active tab
	$("#liFavorites").removeClass('active');
	$("#liSearch").removeClass('active');
	$("#liHome").addClass('active');
	e.preventDefault();
});


$("#mnuFavorites").on("click", function (e) {
	logging("Clicked: Favorites");
	hideNavbarDropdown();
	$("#divCategories").hide();
	$("#divProjects").hide();
	$("#divFavorites").show();
	$("#divSearch").hide();
	
	// Set active tab
	$("#liHome").removeClass('active');
	$("#liSearch").removeClass('active');
	$("#liFavorites").addClass('active');
	e.preventDefault();
});


$("#mnuSearch").on("click", function (e) {
	logging("Clicked: Search");
	hideNavbarDropdown();
	$("#divCategories").hide();
	$("#divProjects").hide();
	$("#divFavorites").hide();
	$("#divSearch").show();
	
		// Set active tab
	$("#liHome").removeClass('active');
	$("#liFavorites").removeClass('active');
	$("#liSearch").addClass('active');
	e.preventDefault();
});

$("#btnCloseModal").on("click", function () {
	logging("Closing modal - video stops");
	$(".video-js")[0].player.pause();
});

$("#btnFollow").on("click", function () {
	if ($("#textFollow").text() === 'Follow') {
		$("#textFollow").text('Unfollow');

		var projectData = {projectHeader : $("#projectHeader").text().replace(/(\r\n|\n|\r)/gm,""), 
		projectDescription : $("#projectDescription").text(),
		projectPledgeAmount : $("#projectPledgeAmount").text(),
		currentProjectStatisticsUrl : currentProjectStatisticsUrl,
		projectEndDate : $("#projectEndDate").text(),
		projectImage : $("#projectImage").attr('src'),
		videourl : $("#videoHigh").attr('src'),
		videopreviewurl : $("#videoJS_html5_api").attr("poster") }

		window.localStorage.setItem(currentProjectId.replace("P", "").replace("S", ""), JSON.stringify(projectData));
	} else {
		$("#textFollow").text('Follow');
		window.localStorage.removeItem(currentProjectId.replace("P", ""));
	}
	loadFavorites();
});

$("#btnSearch").on("click", function () {
	logging("Search button clicked: ");
	var searchString = $("#searchText").val();
	if (searchString !== "") {
		search(searchString, ($("#cbSearchDescriptions").prop("checked")) ? 1 : 0);
	} else {
		alert('Please enter a search string');
	}
});


$("#btnOpen").on("click", function (e) {
	e.preventDefault();
	
	var detailUrl = currentProjectStatisticsUrl.substring(0, currentProjectStatisticsUrl.length - 11)
	detailUrl = detailUrl.substring(detailUrl.indexOf("/projects"));
    detailUrl = "https://www.kickstarter.com" + detailUrl;
	detailUrl = detailUrl.replace("/sta", "");
    logging("Open url in browser: " + detailUrl);
	
	window.open(detailUrl, '_system', 'location=yes');
});


// click event on project categories list
$("#categories").on("click", "li", function () {
	// logging("Clicked category: " + this.id + "/" + this.innerText);

	if (currentProjectCategory !== this.id) {
		logging("Selected different category then last category");
		currentProjectCategory = this.id;
		loadProjectsInCategory(currentProjectCategory);

		$("#projects").empty();
	}

	$("#divCategories").hide();
	$("#divProjects").show();

	fillSubCategoriesDropdown(currentProjectCategory.replace("C", ""));

	screenState += 1;

});


// click event on project categories list
$("#favorites").on("click", "li", function () {
	logging("Clicked: Favorite: " + this.id);
	currentProjectId = this.id;

	for (var i = 0; i < arrFollowing.length; i++) {
		if (arrFollowing[i].projectid == this.id.replace('P', '')) {
			image = arrFollowing[i].imageUrl.replace('-med', '-full');
			$("#projectDescription").text(arrFollowing[i].projectDescription);
			$("#projectPledgeAmount").text(sep1000(arrFollowing[i].pledgeamount));
			$("#projectEndDate").text(arrFollowing[i].enddate);
			currentProjectStatisticsUrl = arrFollowing[i].statsurl;
			videourl = arrFollowing[i].videourl;
			videopreviewurl = arrFollowing[i].videopreviewurl;

			if (localStorage.getItem(currentProjectId.replace("P", "")) === null) {
				$("#textFollow").text('Follow');
			} else {
				$("#textFollow").text('Unfollow');
			}
		}
	}

	loadProjectStatistics(this.innerText, image, currentProjectStatisticsUrl, videourl, videopreviewurl);

});



// click event on project categories list
$("#projects").on("click", "li", function () {
	// logging("Clicked project: " + this.id + "/" + this.innerText);
	currentProjectId = this.id;

	var image;
	var projectTitle;
	var projectDescription;
	var pledgeamount;
	var endDate;
	var statsurl;
	var videourl;
	var videopreviewurl;
	// var progressValue;
	// var maxValue

	currentProjectCategory = this.id;

	if (localStorage.getItem(currentProjectId.replace("P", "")) === null) {
		$("#textFollow").text('Follow');
	} else {
		$("#textFollow").text('Unfollow');
	}

	// Do something to show selected project
	for (var i = 0; i < arrProjects.length; i++) {
		if (arrProjects[i].projectid == this.id.replace('P', '')) {
			image = arrProjects[i].imageUrl.replace('-med', '-full');
			projectTitle = arrProjects[i].projectTitle;
			$("#projectDescription").text(arrProjects[i].projectDescription);
			$("#projectPledgeAmount").text(sep1000(arrProjects[i].pledgeamount));
			$("#projectEndDate").text(createLocalDateString(arrProjects[i].enddate));
			currentProjectStatisticsUrl = arrProjects[i].statsurl;
			videourl = arrProjects[i].videourl;
			videopreviewurl = arrProjects[i].videopreviewurl;
		}
	}

	// Fill panel data
	// loadProjectStatistics(this.innerText, image, currentProjectStatisticsUrl, videourl, videopreviewurl);
	loadProjectStatistics(projectTitle, image, currentProjectStatisticsUrl, videourl, videopreviewurl);

})


// click event on project categories list
$("#searchResults").on("click", "li", function () {
	logging("Clicked: searchResult: " + this.id);
	currentProjectId = this.id;

	logging("arrSearchResults.length: "+ arrSearchResults.length);
	for (var i = 0; i < arrSearchResults.length; i++) {
		if (arrSearchResults[i].projectid == this.id.replace('S', '')) {
			logging("arrSearchResults[i].projectid: " + arrSearchResults[i].projectid);
			image = arrSearchResults[i].imageUrl.replace('-med', '-full');
			$("#projectDescription").text(arrSearchResults[i].projectDescription);
			$("#projectPledgeAmount").text(sep1000(arrSearchResults[i].pledgeamount));
			$("#projectEndDate").text(arrSearchResults[i].enddate);
			currentProjectStatisticsUrl = arrSearchResults[i].statsurl;
			videourl = arrSearchResults[i].videourl;
			videopreviewurl = arrSearchResults[i].videopreviewurl;

			if (localStorage.getItem(currentProjectId.replace("S", "")) === null) {
				$("#textFollow").text('Follow');
			} else {
				$("#textFollow").text('Unfollow');
			}
		}
	}

	loadProjectStatistics(this.innerText, image, currentProjectStatisticsUrl, videourl, videopreviewurl);

});



function loadFavorites() {
	logging("Begin: loadFavorites");
	arrFollowing = [];
	for (var i = 0, l = localStorage.length; i < l; i++) {
		var key = localStorage.key(i);
		var value = JSON.parse(localStorage[key]);
		if (isNumber(key)) {
			var follow = {
				projectid: key,
				projectTitle: value.projectHeader,
				imageUrl: value.projectImage,
				projectDescription: value.projectDescription,
				pledgeamount: value.projectPledgeAmount,
				statsurl: value.currentProjectStatisticsUrl,
				enddate: createLocalDateString(value.projectEndDate),
				videourl: value.videourl,
				videopreviewurl: value.videopreviewurl
			}
			arrFollowing.push(follow);
		}
	}


	var myFavorites = $("#favorites");
	myFavorites.empty();

	if (arrFollowing.length > 0) {
		$("#notFollowing").hide();
		for (index = 0; index < arrFollowing.length; ++index) {
			// logging(e.items[index].projectTitle); //e.items[index].displayText
			// logging("Only now checkking: " + arrFollowing[index].imageUrl);
			
			var liHtml = htmlListItem
			liHtml = liHtml.replace("$id$", "P"+ arrFollowing[index].projectid);
			liHtml = liHtml.replace("$src$", arrFollowing[index].imageUrl.replace("-full", "-small"));
			liHtml = liHtml.replace("$heading$", arrFollowing[index].projectTitle);
			
			// myFavorites.append("<li id='P" + arrFollowing[index].projectid + "'><a href='#modalProject' data-toggle='modal' class='list-group-item'><img src='" + arrFollowing[index].imageUrl.replace("-full", "-small") + "' class='pull-left' width='64px' height='64px' /><h4 class='clearfix'>&nbsp;" + arrFollowing[index].projectTitle + "</h4></a></li>");
			myFavorites.append(liHtml);
			// logging("<li id='P" + arrFollowing[index].projectid + "'><a href='#modalProject' data-toggle='modal' class='list-group-item'><img src='" + arrFollowing[index].imageUrl + "' class='pull-left' width='64px' height='64px' /><h4 class='clearfix'>&nbsp;" + arrFollowing[index].projectTitle + "</h4></a></li>");
		}
	} else {
		$("#notFollowing").show();
	}



	logging("End: loadFavorites");
}


function loadProjectStatistics(name, image, statsUrl, videourl, videopreviewurl) {
	logging("Begin: loadProjectStatistics");
	$("#footer").show();
	$("#modalProject").show();
	logging("videourl in loadProjectStatistics: " + videopreviewurl);
	logging("projectHeader: " + name);

	// Hide all images/video
	$("#projectImage").hide();
	$("#projectImage").attr('src', '');
	$("#projectImagePlaceholder").hide();
	$("#videoJS").hide();

	if (typeof(videourl) !== 'undefined' && videourl !== '') {
		logging("Video is available, do not show images");
		if (videourl.length > 0) {
			$("#videoJS").show();
			var videourl = videourl.substring(0, videourl.lastIndexOf('-') + 1);
			$("#videoHigh").attr("src", videourl + "h264_high.mp4");
			$("#videoBase").attr("src", videourl + "h264_base.mp4");
			$("#videoWebm").attr("src", videourl + "webm.webm");
			$("#videoJS_html5_api").attr("poster", videopreviewurl);
			$(".video-js")[0].player.load();
		}
	} else {
		logging("No video, only show image");
		$("#videoJS").hide();
		$("#projectImagePlaceholder").show();
		$("#videoHigh").attr("src", '')
		$("#videoJS_html5_api").attr("poster", '');
		/*$("#projectImage").attr('src', './images/spinner.png');
		$("#projectImage").hide();*/
		
	}
	
	// set height of modal-body
	// setModalBodyHeight();
	
	jQuery.ajax({
		type: 'GET',
		// url: 'http://localhost:60297/Kickstarter.asmx/getProjectStatistics?projectUrl=' + 'kickstarter.com/projects/soaprouter/soap-first-smart-router-w-touch-display-powered-by/stats.json',    //url,
		url: baseurl + '/getProjectStatistics?projectUrl=' + statsUrl, //url,
		dataType: 'text',
		error: function (xhr, ajaxOptions, thrownError) {
			// hideProgress('#modalStats');
			logging('error loading project statistics');
			alert('error: ' + thrownError);
		},
		success: function (data) {
			data = data.substring(data.indexOf("{"));
			data = data.substring(0, data.lastIndexOf("}") + 1);
			data = JSON.parse(data);
			// logging("|" + data + "|");
			var jo = eval(data);

			// logging("Image: " + image);

			$('#projectImage').load(function () {
				logging('Image loaded from url: ' + image);
				$("#projectImagePlaceholder").hide();
			}).attr('src', image);
			
			if (typeof (videourl) === 'undefined' || videourl==='') {
				//logging('videourl === undefined, so load picture and show it');
				$("#projectImage").show();
			}

			$("#projectHeader").text(name);
			$("#projectFunded").text(sep1000(jo.project.pledged));
			$("#projectBackers").text(jo.project.backers_count);
			$("#projectStatus").text(jo.project.state);
			$("#projectStatus").css('text-transform', 'capitalize');

			var dateSince = new Date(jo.project.state_changed_at * 1000);
			$("#projectStatusSince").text(dateSince);

			var percent = (parseInt(jo.project.pledged) * 100) / (parseFloat($("#projectPledgeAmount").text()) * 1000)
			$("#projectProgress").css('width', percent + "%");
			$("#projectProgressPercent").text(percent.toFixed(2) + "%");

			setTimeout(resizeVideoJs, 150);
			
			$('#modalContent').animate({scrollTop:0},'slow')

			$("#footer").hide();
		}
	});
	
	// Some settings to get the footer aligned correctly
	/* $(".modal-footer").css('margin-top', '0px');
	$(".modal-footer").width($(".modal-body").width());
	$(".modal-footer").css('margin-left', '1px');
	$(".modal-content").removeClass("-webkit-box-shadow");
	$(".modal-content").removeClass("box-shadow"); */
	
	// $(".modal-content").removeClass("-webkit-box-shadow");
	// $(".modal-content").removeClass("box-shadow");
	// $(".modal-content").removeClass("");
	
	
	logging("End: loadProjectStatistics");
}




function loadProjectsInCategory(category) {
	$("#footer").show();
	var dsCategoryProjects = new kendo.data.DataSource({
		transport: {
			// specify the XML file to read. Thesame as read: { url: "books.xml" }
			// read: "http://webservices.k1ckstart3r.com/kickstarter/kickstarter.asmx/getCategories"
			// http://localhost:60297/Kickstarter.asmx/getCategories
			read: {
				// url: "http://localhost:60297/Kickstarter.asmx/getProjectsPerCategory?startId=0&category=" + currentProjectCategory.replace("C", ""),
				url: baseurl + "/getProjectsPerCategory?startId=0&category=" + category.replace("C", ""),
				dataType: "xml"
			}
		},
		change: function (e) {
			//logging("change: categories list should follow")
			$("#divCategories").hide();
			$("#divProjects").show();

			arrProjects = [];
			for (index = 0; index < e.items.length; ++index) {
				// logging("title: " + e.items[index].projectTitle);
				var project = {
					projectid: e.items[index].projectid,
					projectTitle: e.items[index].projectTitle,
					imageUrl: e.items[index].imageUrl,
					projectDescription: e.items[index].projectDescription,
					pledgeamount: e.items[index].pledgeamount,
					statsurl: e.items[index].statsurl,
					enddate: e.items[index].enddate,
					subcategoryid: e.items[index].subcategoryID,
					videourl: e.items[index].videourl,
					videopreviewurl: e.items[index].videopreviewurl
				}
				arrProjects.push(project);
			}

			// fillProjectsList(e, -1);
			fillProjectsList('0');

		},
		requestEnd: function (e) {
			// hideProgress('#modalHome');
			// window.setTimeout("hideProgress('#modalHome')", 2000);
		},
		schema: {
			// specify the the schema is XML
			type: "xml",
			// the XML element which represents a single data record
			data: "/projects/project",
			// define the model - the object which will represent a single data record
			model: { // configure the fields of the object
				fields: {
					// the "projectID" field is mapped to the text of the "projectid" XML element
					projectid: "projectid/text()",
					// the "projectName" field is mapped to the text of the "projectname" XML element
					projectTitle: "title/text()",
					// the "projectDescription" field is mapped to the text of the "description" XML element
					projectDescription: "description/text()",
					// the "imageUrl" field is mapped to the text of the "imageurl" XML element
					imageUrl: "imageurl/text()",
					pledgeamount: "pledgeamount/text()",
					enddate: "enddate/text()",
					statsurl: "statisticsurl/text()",
					subcategoryID: "subcategory_id/text()",
					videourl: "videourl/text()",
					videopreviewurl: "videopreviewurl/text()",
				}
			}
		},
	});

	dsCategoryProjects.fetch(function () {
		// arrProjects = dsCategoryProjects.data();
	});
	// arrProjects = dsCategoryProjects.data();
	// logging("arrProjects.lenght: " + arrProjects.length);
}



function loadCategories() {
	// showProgress('#modalHome');
	$("#footer").show();
	var dsProjectCategories = new kendo.data.DataSource({
		transport: {
			// specify the XML file to read. The same as read: { url: "books.xml" }
			// read: "http://webservices.k1ckstart3r.com/kickstarter/kickstarter.asmx/getCategories"
			// http://localhost:60297/Kickstarter.asmx/getCategories
			read: {
				// url: "http://localhost:60297/Kickstarter.asmx/getCategories",
				url: baseurl + "/getCategories",
				dataType: "xml"
			}
		},
		change: function (e) {
			//logging("change: categories list should follow")
			var myCategories = $("#categories");
			$("#divProjects").hide()
			myCategories.empty();
			for (index = 0; index < e.items.length; ++index) {
				//logging(e.items[index].displayText); //e.items[index].displayText
				myCategories.append("<li id='C" + e.items[index].entryID + "'><a href='#' class='list-group-item'>" + e.items[index].displayText + "</a></li>")
			}
			myCategories.html();
			$("#footer").hide();
		},
		requestEnd: function (e) {
			// hideProgress('#modalHome');
			// window.setTimeout("hideProgress('#modalHome')", 2000);
		},
		schema: {
			// specify the the schema is XML
			type: "xml",
			// type: "JSON",
			// the XML element which represents a single data record
			data: "/categories/category",
			// data: "category",
			// define the model - the object which will represent a single data record
			model: { // configure the fields of the object
				fields: {
					// the "entryID" field is mapped to the text of the "categoryid" XML element
					entryID: "categoryid/text()",
					// the "displayText" field is mapped to the text of the "category_name" XML element
					displayText: "category_name/text()",
				}
			}
		},
	});

	dsProjectCategories.fetch();

	//hideProgress('#modalHome');
}



function loadSubCategories() {
	logging('Begin: loadSubCategories');
	dsSubCategories = new kendo.data.DataSource({
		transport: {
			// specify the XML file to read. The same as read: { url: "books.xml" }
			// read: "http://webservices.k1ckstart3r.com/kickstarter/kickstarter.asmx/getSubCategories"
			read: baseurl + "/getSubCategories"
		},
		requestEnd: function (e) {
			// hideProgress('#modalHome');
			// window.setTimeout("hideProgress('#modalHome')", 2000);
		},
		change: function () {},
		schema: {
			// specify the the schema is XML
			type: "xml",
			// the XML element which represents a single data record
			data: "/subcategories/subcategory",
			// define the model - the object which will represent a single data record
			model: {
				// configure the fields of the object
				fields: {
					// the "entryID" field is mapped to the text of the "categoryid" XML element
					subcategoryid: "subcategoryid/text()",
					parentcategoryid: "parentcategory/text()",
					// the "displayText" field is mapped to the text of the "category_name" XML element
					subcategory_name: "subcategory_name/text()",
				}
			}
		},
	});

	dsSubCategories.fetch(function () {
		arrSubCategories = dsSubCategories.data();
	});
	logging('End: loadSubCategories');
}






//-------------------------------------------------------------------------------------------------------------------------------------------------
function search(searchString, searchDescription) {
	$("#footer").show();
	$("#noSearchResults").hide();
	var dsSearch = new kendo.data.DataSource({
		pageSize: 20,
		transport: {
			// specify the XML file to read. The same as read: { url: "books.xml" }
			// read: "http://webservices.k1ckstart3r.com/kickstarter/kickstarter.asmx/searchForText?searchString=" + searchString + "&searchDescription=" + searchDescription
			read: baseurl + "/searchForText?searchString=" + searchString + "&searchDescription=" + searchDescription
		},
		change: function (e) {
			arrSearchResults = [];
			for (index = 0; index < e.items.length; ++index) {
				// logging("title: " + e.items[index].projectTitle);
				var searchResult = {
					projectid: e.items[index].projectID,
					projectTitle: e.items[index].projectTitle,
					imageUrl: e.items[index].imageUrl,
					projectDescription: e.items[index].projectDescription,
					pledgeamount: e.items[index].pledgeamount,
					statsurl: e.items[index].statsurl,
					enddate: e.items[index].enddate,
					subcategoryid: e.items[index].subcategoryID,
					videourl: e.items[index].videourl,
					videopreviewurl: e.items[index].videopreviewurl
				}
				arrSearchResults.push(searchResult);
			}

			fillSearchList();
		},
		requestEnd: function (e) {
			// hideProgress('#modalSearch');
			// alert( $("#searchList").children().length);
		},
		schema: {
			// specify the the schema is XML
			type: "xml",
			// the XML element which represents a single data record
			data: "/searcresults/searchresult",
			// define the model - the object which will represent a single data record
			model: {
				// configure the fields of the object
				fields: {
					// the "projectID" field is mapped to the text of the "projectid" XML element
					projectID: "projectid/text()",
					// the "projectName" field is mapped to the text of the "projectname" XML element
					projectTitle: "title/text()",
					// the "projectDescription" field is mapped to the text of the "description" XML element
					projectDescription: "description/text()",
					// the "imageUrl" field is mapped to the text of the "imageurl" XML element
					imageUrl: "imageurl/text()",
					pledgeamount: "pledgeamount/text()",
					enddate: "enddate/text()",
					statsurl: "statisticsurl/text()",
					videourl: "videourl/text()",
					videopreviewurl: "videopreviewurl/text()",
				}
			}
		},
	});

	dsSearch.fetch();

}
//-------------------------------------------------------------------------------------------------------------------------------------------------


function fillSearchList() {
	logging("Begin: fillSearchList()");

	$("#searchResults").empty();

	if (arrSearchResults.length > 0) {
		var mySearchResults = $("#searchResults");
		for (index = 0; index < arrSearchResults.length; ++index) {
			
			var liHtml = htmlListItem
			liHtml = liHtml.replace("$id$", "S" + arrSearchResults[index].projectid);
			liHtml = liHtml.replace("$src$", arrSearchResults[index].imageUrl.replace("-full", "-small"));
			liHtml = liHtml.replace("$heading$", arrSearchResults[index].projectTitle);
			
			mySearchResults.append(liHtml)
			// mySearchResults.append("<li id='S" + arrSearchResults[index].projectid + "'><a href='#modalProject' data-toggle='modal' class='list-group-item'><img src='" + arrSearchResults[index].imageUrl.replace("-full", "-small") + "' class='pull-left' width='64px' height='64px' /><h4 class='clearfix'>&nbsp;" + arrSearchResults[index].projectTitle + "</h4></a></li>")
		}
		mySearchResults.html();
	} else {
		$("#noSearchResults").show();
	}


	$("#footer").hide();
	logging("End: fillSearchList()");
}


function fillProjectsList(filter) {
	logging("Begin: fillProjectsList(" + filter + ")");
	var myProjects = $("#projects");
	myProjects.empty();
	for (index = 0; index < arrProjects.length; ++index) {

		if ((filter === "0") || (arrProjects[index].subcategoryid === filter)) {
			
			var liHtml = htmlListItem
			liHtml = liHtml.replace("$id$", "P" + arrProjects[index].projectid);
			liHtml = liHtml.replace("$src$", arrProjects[index].imageUrl.replace("-full", "-small"));
			liHtml = liHtml.replace("$heading$", arrProjects[index].projectTitle);
			myProjects.append(liHtml);
		}

		// myProjects.append("<li id='P" + e.items[index].projectID + "'><a href='#' class='list-group-item'><img src='//placehold.it/100x100' class='img-thumbnail' />" + e.items[index].projectTitle + "</a></li>")
		/*var liHtml = htmlListItem
                liHtml = liHtml.replace("$id$", e.items[index].projectid);
                liHtml = liHtml.replace("$src$", e.items[index].imageUrl);
                liHtml = liHtml.replace("$heading$", e.items[index].projectTitle);
                myProjects.append(liHtml);*/
	}
	myProjects.html();
	$("#footer").hide();
	logging("End: fillProjectsList(" + filter + ")");
}


function fillSubCategoriesDropdown(filter) {
	logging("Begin: fillSubCategoriesDropdown(" + filter + ")");

	$("#ddSubCategories").empty();
	$("#ddSubCategories").append("<option value='0'>All sub categories</option>");

	for (index = 0; index < arrSubCategories.length; ++index) {
		// logging("parentid: " + arrSubCategories[index].parentcategoryid + " / filter: " + filter);
		if (arrSubCategories[index].parentcategoryid === filter) {
			$("#ddSubCategories").append("<option value='" + arrSubCategories[index].subcategoryid + "'>" + arrSubCategories[index].subcategory_name + "</option>");
			// logging("Subcategory added: " + arrSubCategories[index].subcategory_name + " / parentid: " + arrSubCategories[index].parentcategoryid);
		}
	}
	$('.selectpicker').selectpicker('refresh');
	logging("End: fillSubCategoriesDropdown");
}


function sep1000(somenum, usa) {
	var dec = String(somenum).split(/[.,]/),
		sep = usa ? ',' : '.',
		decsep = usa ? '.' : ',';
	var retValue = dec[0]
		.split('')
		.reverse()
		.reduce(function (prev, now, i) {
			return i % 3 === 0 ? prev + sep + now : prev + now;
		})
		.split('')
		.reverse()
		.join('') +
		(dec[1] ? decsep + dec[1] : '');

	var endString = retValue.substring((retValue.length - 2));

	if (endString.indexOf('.0') !== -1) {
		retValue = retValue + '0';
	}
	if (endString.indexOf(',0') !== -1) {
		retValue = retValue + '0';
	}

	return retValue;
}


function isNumber(n) {
	return !isNaN(parseFloat(n)) && isFinite(n);
}

function createLocalDateString(dateString) {
	var returnDate = new Date(dateString * 1000);
	return (returnDate.toLocaleString());
}