cardPick = new CustomEvent(
    "cardPicked",
    {
        detail:{
            message: "Inital card has been picked",
            time: new Date()
       },
       bubbles: true,
       cancelable: true
    }
);



// Card object to help keep track card functions
Card = function(aRomanji,aKana,aType){
    var romanji = aRomanji;
    if(romanji == "dji"){
        romanji = "ji";
    }else if(romanji == "dzu"){
        romanji = "zu";
    }else if(romanji == "cja"){
        romanji = "ja";
    }else if(romanji == "cjo"){
        romanji = "jo";
    }else if(romanji == "cju"){
        romanji = "ju";
    }else if(romanji == "wwo"){
        romanji = "wo";
    }

    var kana = aKana;
    var type = aType.toLowerCase();
    var identifier;
    // assumes tries and score will be successfully loaded before answer is provided
    var score = null;
    var tries = null;
    var loadScoreAndTries = function(){
        var transaction = database.db.transaction("kana","readwrite");
        var store = transaction.objectStore("kana");
        var request = store.get(aKana);
        request.onsuccess = function(e){
            result = e.target.result;
            // Assumes that if it's undefined it's the first time the app is loaded or after having cleared the database
            if(result == undefined || result.score == undefined){
                score = 0;
                tries = 0;
            }else{
                score = result.score;
                tries = result.tries;
            }
        }
       
    }
    loadScoreAndTries();

    if(aKana == "ぢ" || aKana == "づ" || aKana == "ヂ" || aKana == "ヅ" || aKana == "ウォ"){
        identifier = "-d-";
    }else{
        identifier = "";
    }

    //TODO add identifier for (C)JU (C)JO (C)JA

    if(aKana == "ぢょ" || aKana == "ぢゅ" || aKana == "ぢゃ" || aKana == "ヂョ" || aKana == "ヂャ" || aKana == "ヂュ"){
        identifier = "-c-";
    }else{
        identifier = "";
    }
    

    this.getRomanji = function(){
        return romanji;
    }
    this.getKana = function(){
        return kana;
    }
    this.getType = function(){
        return type;
    }
    this.getIdentifier = function(){
        return identifier;
    }

    //TODO retrieve real score, and increment
    this.incrementScore = function(){
        var transaction = database.db.transaction("kana","readwrite");
        var store = transaction.objectStore("kana");
        var request = store.put({"kana":kana,"romanji":romanji,"score":score+1,"tries":tries+1});
    }
    this.incrementTries = function(){
        var transaction = database.db.transaction("kana","readwrite");
        var store = transaction.objectStore("kana");
        var request = store.put({"kana":kana,"romanji":romanji,"score":score,"tries":tries+1});
    }
}


/*
cards = new Object();
cards.group = new Object();
cards.group["value"] = "base";
cards.group.reading = new Object();
cards.group.reading["value"] = "a";
cards.group.reading.hiragana = new Object();
cards.group.reading.hiragana["score"] = 0;
cards.group.reading.hiragana["answers"] = 0;
cards.group.reading.hiragana["value"] = "hiragana a";

cards.group.reading.katakana= new Object();
cards.group.reading.katakana["score"] = 0;
cards.group.reading.katakana["answers"] = 0;
cards.group.reading.katakana["value"] = "katakana a";
*/

groups={
    "hbase":["a","e","o","i","u"],
    "kbase":["a","e","o","i","u"],
    "hKType":["ka","ke","ko","ki","ku"],
    "kKType":["ka","ke","ko","ki","ku"],
    "hSType":["sa","se","so","shi","su"],
    "kSType":["sa","se","so","shi","su"],
    "hTType":["ta","te","to","chi","tsu"],
    "kTType":["ta","te","to","chi","tsu"],
    "hHType":["ha","he","ho","hi","fu"],
    "kHType":["ha","he","ho","hi","fu"],
    "hNVocalType":["na","ne","no","ni","nu"],
    "kNVocalType":["na","ne","no","ni","nu"],
    "hMType":["ma","me","mo","mi","mu"],
    "kMType":["ma","me","mo","mi","mu"],
    "hYType":["ya","yo","yu"],
    "kYType":["ya","yo","yu"],
    "hRType":["ra","re","ro","ri","ru"],
    "kRType":["ra","re","ro","ri","ru"],
    "hWType":["wa","wo"],
    "kWType":["wa","wo"],
    "hNType":["n"],
    "kNType":["n"],

    "hGType":["ga","ge","go","gi","gu"],
    "kGType":["ga","ge","go","gi","gu"],
    "hZType":["za","ze","zo","ji","zu"],
    "kZType":["za","ze","zo","ji","zu"],
    "hDType":["da","de","do","dji","dzu"],
    "kDType":["da","de","do","dji","dzu"],
    "hBType":["ba","be","bo","bi","bu"],
    "kBType":["ba","be","bo","bi","bu"],
    "hPType":["pa","pe","po","pi","pu"],
    "kPType":["pa","pe","po","pi","pu"],

    "hKyType":["kya","kyo","kyu"],
    "kKyType":["kya","kyo","kyu"],
    "hShType":["sha","sho","shu"],
    "kShType":["sha","sho","shu"],
    "hChType":["cha","cho","chu"],
    "kChType":["cha","cho","chu"],
    "hNyType":["nya","nyo","nyu"],
    "kNyType":["nya","nyo","nyu"],
    "hHyType":["hya","hyo","hyu"],
    "kHyType":["hya","hyo","hyu"],
    "hMyType":["mya","myo","myu"],
    "kMyType":["mya","myo","myu"],
    "hRyType":["rya","ryo","ryu"],
    "kRyType":["rya","ryo","ryu"],
    "hGyType":["gya","gyo","gyu"],
    "kGyType":["gya","gyo","gyu"],
    "hJType":["ja","jo","ju"],
    "kJType":["ja","jo","ju"],
    "hCjType":["cja","cjo","cju"],
    "kCjType":["cja","cjo","cju"],
    "hByType":["bya","byo","byu"],
    "kByType":["bya","byo","byu"],
    "hPyType":["pya","pyo","pyu"],
    "kPyType":["pya","pyo","pyu"],

    "kYeType":["ye"],
    "kWVocalType":["we","wwo","wi"],
    "kVType":["va","ve","vo","vi","vu"],
    "kSheType":["she"],
    "kJeType":["je"],
    "kCheType":["che"],
    "kTVocalType":["ti","tu"],
    "kDVocalType":["di","du"],
    "kTsVocalType":["tsa","tse","tso","tsi"],
    "kFType":["fa","fe","fo","fi"],
    "kVyVocalType":["vya","vyo","vyu"],
    "kTyuType":["tyu"],
    "kDyuType":["dyu"],
    "kFyuType":["fyu"],

}

hiraganaGroups=["hbase","hKType","hSType","hTType","hNVocalType","hHType","hMType","hYType","hRType","hWType","hNType","hGType","hZType","hDType","hBType","hPType","hKyType","hShType","hRyType","hChType","hNyType","hHyType","hMyType","hGyType","hJType","hCjType","hByType","hPyType"];
katakanaGroups=["kbase","kKType","kSType","kTType","kHType","hNVocalType","kMType","kYType","kRType","kWType","kNType","kGType","kZType","kDType","kBType","kPType","kKyType","kShType","kRyType","kChType","kNyType","kHyType","kMyType","kGyType","kJType","kCjType","kByType","kPyType","kJeType","kSheType","kCheType","kYeType","kWVocalType","kVType","kTVocalType","kDVocalType","kTsVocalType","kFType","kVyVocalType","kTyuType","kDyuType","kFyuType"];

usegroup = null;

hiragana={
    "a":"あ",
    "e":"え",
    "i":"い",
    "o":"お",
    "u":"う",
    "ka":"か",
    "ke":"け",
    "ki":"き",
    "ko":"こ",
    "ku":"く",
    "sa":"さ",
    "se":"せ",
    "shi":"し",
    "so":"そ",
    "su":"す",
    "ta":"た",
    "te":"て",
    "chi":"ち",
    "to":"と",
    "tsu":"つ",
    "na":"な",
    "ne":"ね",
    "ni":"に",
    "no":"の",
    "nu":"ぬ",
    "ha":"は",
    "he":"へ",
    "hi":"ひ",
    "ho":"ほ",
    "fu":"ふ",
    "ma":"ま",
    "me":"め",
    "mi":"み",
    "mo":"も",
    "mu":"む",
    "ya":"や",
    "yo":"よ",
    "yu":"ゆ",
    "ra":"ら",
    "re":"れ",
    "ri":"り",
    "ro":"ろ",
    "ru":"る",
    "wa":"わ",
    "wo":"を",
    "n":"ん",

    "ga":"が",
    "ge":"げ",
    "gi":"ぎ",
    "go":"ご",
    "gu":"ぐ",
    "za":"ざ",
    "ze":"ぜ",
    "ji":"じ",
    "zo":"ぞ",
    "zu":"ず",

    "da":"だ",
    "dji":"ぢ",
    "dzu":"づ",
    "de":"で",
    "do":"ど",

    "ba":"ば",
    "bi":"び",
    "bu":"ぶ",
    "be":"べ",
    "bo":"ぼ",
    "pa":"ぱ",
    "pi":"ぴ",
    "pu":"ぷ",
    "pe":"ぺ",
    "po":"ぽ",

    "kya":"きゃ",
    "kyu":"きゅ",
    "kyo":"きょ",
    "sha":"しゃ",
    "shu":"しゅ",
    "sho":"しょ",
    "cha":"ちゃ",
    "chu":"ちゅ",
    "cho":"ちょ",
    "nya":"にゃ",
    "nyu":"にゅ",
    "nyo":"にょ",
    "hya":"ひゃ",
    "hyu":"ひゅ",
    "hyo":"ひょ",
    "mya":"みゃ",
    "myu":"みゅ",
    "myo":"みょ",
    "rya":"りゃ",
    "ryu":"りゅ",
    "ryo":"りょ",
    "gya":"ぎゃ",
    "gyu":"ぎゅ",
    "gyo":"ぎょ",
    "ja":"じゃ",
    "ju":"じゅ",
    "jo":"じょ",
    "cja":"ぢゃ",
    "cju":"ぢゅ",
    "cjo":"ぢょ",
    "bya":"びゃ",
    "byu":"びゅ",
    "byo":"びょ",
    "pya":"ぴゃ",
    "pyu":"ぴゅ",
    "pyo":"ぴょ"
}

katakana={
    "a":"ア",
    "e":"エ",
    "i":"イ",
    "o":"オ",
    "u":"ウ",
    "ka":"カ",
    "ke":"ケ",
    "ki":"キ",
    "ko":"コ",
    "ku":"ク",
    "sa":"サ",
    "se":"セ",
    "shi":"シ",
    "so":"ソ",
    "su":"ス",
    "ta":"タ",
    "te":"テ",
    "chi":"チ",
    "to":"ト",
    "tsu":"ツ",
    "na":"ナ",
    "ne":"ネ",
    "ni":"ニ",
    "no":"ノ",
    "nu":"ヌ",
    "ha":"ハ",
    "he":"ヘ",
    "hi":"ヒ",
    "ho":"ホ",
    "fu":"フ",
    "ma":"マ",
    "me":"メ",
    "mi":"ミ",
    "mo":"モ",
    "mu":"ム",
    "ya":"ヤ",
    "yo":"ヨ",
    "yu":"ユ",
    "ra":"ラ",
    "re":"レ",
    "ri":"リ",
    "ro":"ロ",
    "ru":"ル",
    "wa":"ワ",
    "wo":"ヲ",
    "n":"ン",

    "ga":"ガ",
    "ge":"ゲ",
    "gi":"ギ",
    "go":"ゴ",
    "gu":"グ",
    "za":"ザ",
    "ze":"ゼ",
    "ji":"ジ",
    "zo":"ゾ",
    "zu":"ズ",

    "da":"ダ",
    "dji":"ヂ",
    "dzu":"ヅ",
    "de":"デ",
    "do":"ド",
    "ba":"バ",
    "bi":"ビ",
    "bu":"ブ",
    "be":"ベ",
    "bo":"ボ",
    "pa":"パ",
    "pi":"ピ",
    "pu":"プ",
    "pe":"ペ",
    "po":"ポ",

    "kya":"キャ",
    "kyu":"キュ",
    "kyo":"キョ",
    "sha":"シャ",
    "shu":"シュ",
    "sho":"ショ",
    "cha":"チャ",
    "chu":"チュ",
    "cho":"チョ",
    "nya":"ニャ",
    "nyu":"ニュ",
    "nyo":"ニョ",
    "hya":"ヒャ",
    "hyu":"ヒュ",
    "hyo":"ヒョ",
    "mya":"ミャ",
    "myu":"ミュ",
    "myo":"ミョ",
    "rya":"リャ",
    "ryu":"リュ",
    "ryo":"リョ",
    "gya":"ギャ",
    "gyu":"ギュ",
    "gyo":"ギョ",
    "ja":"ジャ",
    "ju":"ジュ",
    "jo":"ジョ",
    "cja":"ヂャ",
    "cju":"ヂュ",
    "cjo":"ヂョ",
    "bya":"ビャ",
    "byu":"ビュ",
    "byo":"ビョ",
    "pya":"ピャ",
    "pyu":"ピュ",
    "pyo":"ピョ",
    "ye":"イェ",
    "wi":"ウィ",
    "wwo":"ウォ",
    "we":"ウェ",
    "vya":"ヴャ",
    "vyo":"ヴョ",
    "vyu":"ヴュ",
    "va":"ヴァ",
    "ve":"ヴェ",
    "vo":"ヴォ",
    "vi":"ヴィ",
    "vu":"ヴ",
    "je":"ジェ",
    "che":"チェ",
    "she":"シェ",

    "ti":"ティ",
    "tu":"テュ",
    "di":"ディ",
    "du":"デュ",
    "tsa":"ツァ",
    "tse":"ツェ",
    "tso":"ツォ",
    "tsi":"ツィ",
    "fa":"ファ",
    "fe":"フェ",
    "fo":"フォ",
    "fi":"フィ",
    "vya":"ヴャ",
    "vyo":"ヴョ",
    "vyu":"ヴュ",
    "tyu":"チュ",
    "dyu":"ヂュ",
    "fyu":"フュ"
}

var testHiragana = function(){
    for(x = 0; x < hiraganaGroups.length; x ++){
        ob = hiraganaGroups[x];
        ob = groups[ob];
        for(y = 0; y < ob.length; y++){
            document.write(ob[y] + " => " + hiragana[ob[y]] + " ");
        }
        document.write("<br />");
    }
}

var testKatakana = function(){
    for(x = 0; x < katakanaGroups.length; x ++){
        ob = katakanaGroups[x];
        ob = groups[ob];
        for(y = 0; y < ob.length; y++){
            document.write(ob[y] + " => " + katakana[ob[y]] + " ");
        }
        document.write("<br />");
    }
}

//testHiragana();
//testKatakana();

// sets global card to null, which is redefined when pickCard is used to pick a new card
card = null;
function pickCard(launch){

    //TODO create event to be sent once a card is loaded.
    var type;
    var romanji;
    var kana;
    // Picks a random group to pick cards from this time
    if(usegroup == null){
        var db = database.db;
        var transaction = db.transaction("pref","readwrite");
        var store = transaction.objectStore("pref");
        var request = store.get("useGroups");
        request.onsuccess = function(e){
            console.log(e);
            usegroup = e.target.result["groups"];
            if(usegroup == null){
                console.log(e.target);
                return;
            }
            pickCard(true);

        }
    }else{
        var number = Math.floor(Math.random() * usegroup.length);
        var groupName = usegroup[number];
        // type is used later to know wether it is hiragana or katakana
        type = groupName.charAt(0).toLowerCase();
        var group = groups[groupName];
        // picks random card from group
        number = Math.floor(Math.random() * group.length);
        romanji = group[number];
        
        // access either hiragana or katakana object and grab the value matching the reading
        if(type == "h"){
            kana = hiragana[romanji];
        }else{
            kana = katakana[romanji];
        }
        card = new Card(romanji,kana,type);
        if(launch == true){
            window.dispatchEvent(cardPick)
        }
    }
}
