databaseLoaded = new CustomEvent(
    "databaseLoaded",
    {
        detail:{
            message: "Database loaded",
            time: new Date()
        },
        bubbles: true,
        cancelable:true
    }
);

database = {};
database.db = null;
database.open = function(){
  var version = 2;
  var isUpdate = false;
  var transaction = indexedDB.open("database",version);
  transaction.onsuccess = function(e){
      database.db = e.target.result;
      if(isUpdate){
          database.addAllKana();
      }else{
          window.dispatchEvent(databaseLoaded);
      }
  }
  transaction.onupgradeneeded = function(e){
      var DB = e.target.result;
      if(DB.objectStoreNames.contains("kana")){
          DB.deleteObjectStore("kana");
      }
      if(DB.objectStoreNames.contains("pref")){
          DB.deleteObjectStore("pref");
      }
      DB.createObjectStore("kana",{keyPath:"kana"});
      DB.createObjectStore("pref",{keyPath:"key"});
      isUpdate = true;
  }
}
var init = function(){
    database.open();
}

database.addAllKana = function(){
    for(var kana in hiragana){
        var info = new Card(kana,hiragana[kana],"h");
        database.addKana(info.getKana(),info.getRomanji());
    }
    for(var kana in katakana){
        var info = new Card(kana,katakana[kana],"k");
        database.addKana(info.getKana(),info.getRomanji());
    }
    //TODO
    var thisDB = database.db;
    var transaction = thisDB.transaction("pref","readwrite");
    var store = transaction.objectStore("pref");
    var request = store.put({"key":"useGroups","groups":["hbase","kbase"]});
    window.dispatchEvent(databaseLoaded);
}
database.addKana = function (k,r,score, tries){
    score = typeof score !== 'undefined' ? score : 0;
    tries = typeof tries !== 'undefined' ? tries : 0;
    var DB = database.db;
    var transaction = DB.transaction("kana","readwrite");
    var store = transaction.objectStore("kana");
    var request = store.put({"kana":k,"romanji":r,"score":0,"tries":0});
    request.onsuccess = function(){
        console.log("Success");
    }
    request.onerror = function(){
        console.log("Failure");
    }
}

window.addEventListener("DOMContentLoaded",database.open)
