indexInit = function(){
    pickCard();
}
    // remove placeholder & picks a card (assumes that card.js has been loaded, and set in the kana to guess
cardPicked = function(){    
    $("#placeholder").remove();

    $("#kana").text(card.getKana());

    // what to do when a user presses the submit button
    $("#submit").on('click',function(){
        //increments the amount of tries, and the score if it was a correct guess
        //incrementValue(storageNameTries);
        $("span#result").removeClass("correct").removeClass("wrong");
        
        // if correct
        if($("input#answer").val().trim().toLowerCase() == card.getRomanji()){
            card.incrementScore();
            $("span#result").addClass("correct").text("Correct");
            changeCard();
            //alert("Aye");
        }else{
            card.incrementTries();
            $("span#result").addClass("wrong").text("Incorrect! \"" +$("input#answer").val().trim().toLowerCase() + "\" is not a reading for " + card.getKana());
            $("input[name=answer]").val("");
        }
    });

    $("button#giveup").on('click',function(){
        $("span#result").removeClass("correct").removeClass("wrong");
        $("span#result").addClass("wrong").html(card.getKana()+" is read as <u><b>"+card.getRomanji()+"</b></u>");
        card.incrementTries();
        changeCard();
    });

    // makes pressing enter in the input field to the same as if you pressed the submit button
    $("input").keypress(function(e){
        if(e.which == 13){
            e.preventDefault();
            $('button#submit:first').click();
        }
    });
    // function that increments the value of the key provided by 1 (assumse numbers).
    changeCard = function(){
        pickCard();
        $("#kana")[0].textContent = card.getKana();
        $("input[name=answer]").val("");
        $("input[name=answer]:first").focus();
    }
}

window.addEventListener("databaseLoaded",indexInit);
window.addEventListener("cardPicked",cardPicked);
