(function () {
	
	var katakanaTranscription = {
		'a': 'ア',
		'i': 'イ',
		'u': 'ウ',
		'e': 'エ',
		'o': 'オ',
		'ka': 'カ',
		'ki': 'キ',
		'ku': 'ク',
		'ke': 'ケ',
		'ko': 'コ',
		'kya': 'キャ',
		'kyu': 'キュ',
		'kyo': 'キョ',
		'sa': 'サ',
		'shi': 'シ',
		'su': 'ス',
		'se': 'セ',
		'so': 'ソ',
		'sha': 'シャ',
		'shu': 'シュ',
		'sho': 'ショ',
		'ta': 'タ',
		'chi': 'チ',
		'tsu': 'ツ',
		'te': 'テ',
		'to': 'ト',
		'cha': 'チャ',
		'chu': 'チュ',
		'cho': 'チョ',
		'na': 'ナ',
		'ni': 'ニ',
		'nu': 'ヌ',
		'ne': 'ネ',
		'no': 'ノ',
		'nya': 'ニャ',
		'nyu': 'ニュ',
		'nyo': 'ニョ',
		'ha': 'ハ',
		'hi': 'ヒ',
		'fu': 'フ',
		'he': 'ヘ',
		'ho': 'ホ',
		'hya': 'ヒャ',
		'hyu': 'ヒュ',
		'hyo': 'ヒョ',
		'ma': 'マ',
		'mi': 'ミ',
		'mu': 'ム',
		'me': 'メ',
		'mo': 'モ',
		'mya': 'ミャ',
		'myu': 'ミュ',
		'myo': 'ミョ',
		'ya': 'ヤ',
		'yu': 'ユ',
		'yo': 'ヨ',
		'ra': 'ラ',
		'ri': 'リ',
		'ru': 'ル',
		're': 'レ',
		'ro': 'ロ',
		'rya': 'リャ',
		'ryu': 'リュ',
		'ryo': 'リョ',
		'wa': 'ワ',
		'wi': 'ヰ',
		'we': 'ヱ',
		'wo': 'ヲ',
		'n': 'ン',
		'ga': 'ガ',
		'gi': 'ギ',
		'gu': 'グ',
		'ge': 'ゲ',
		'go': 'ゴ',
		'gya': 'ギャ',
		'gyu': 'ギュ',
		'gyo': 'ギョ',
		'za': 'ザ',
		'ji': 'ジ',
		'zu': 'ズ',
		'ze': 'ゼ',
		'zo': 'ゾ',
		'ja': 'ジャ',
		'ju': 'ジュ',
		'jo': 'ジョ',
		'da': 'ダ',
		'ji': 'ヂ',
		'zu': 'ヅ',
		'de': 'デ',
		'do': 'ド',
		'ba': 'バ',
		'bi': 'ビ',
		'bu': 'ブ',
		'be': 'ベ',
		'bo': 'ボ',
		'bya': 'ビャ',
		'byu': 'ビュ',
		'byo': 'ビョ',
		'pa': 'パ',
		'pi': 'ピ',
		'pu': 'プ',
		'pe': 'ペ',
		'po': 'ポ',
		'pya': 'ピャ',
		'pyu': 'ピュ',
		'pyo': 'ピョ',
		'ye': 'イェ',
		'wi': 'ウィ',
		'we': 'ウェ',
		'wo': 'ウォ',
		'va': 'ヴァ',
		'vi': 'ヴィ',
		'vu': 'ヴ',
		've': 'ヴェ',
		'vo': 'ヴォ',
		'she': 'シェ',
		'je': 'ジェ',
		'che': 'チェ',
		'ti': 'ティ',
		'tu': 'トゥ',
		'tyu': 'テュ',
		'di': 'ディ',
		'du': 'ドゥ',
		'dyu': 'デュ',
		'tsa': 'ツァ',
		'tsi': 'ツィ',
		'tse': 'ツェ',
		'tso': 'ツォ',
		'fa': 'ファ',
		'fi': 'フィ',
		'fe': 'フェ',
		'fo': 'フォ',
		'fyu': 'フュ'
	};
	var hiraganaTrascription = {
		'a': 'あ',
		'i': 'い',
		'u': 'う',
		'e': 'え',
		'o': 'お',
		'ka': 'か',
		'ki': 'き',
		'ku': 'く',
		'ke': 'け',
		'ko': 'こ',
		'kya': 'きゃ',
		'kyu': 'きゅ',
		'kyo': 'きょ',
		'sa': 'さ',
		'shi': 'し',
		'su': 'す',
		'se': 'せ',
		'so': 'そ',
		'sha': 'しゃ',
		'shu': 'しゅ',
		'sho': 'しょ',
		'ta': 'た',
		'chi': 'ち',
		'tsu': 'つ',
		'te': 'て',
		'to': 'と',
		'cha': 'ちゃ',
		'chu': 'ちゅ',
		'cho': 'ちょ',
		'na': 'な',
		'ni': 'に',
		'nu': 'ぬ',
		'ne': 'ね',
		'no': 'の',
		'nya': 'にゃ',
		'nyu': 'にゅ',
		'nyo': 'にょ',
		'ha': 'は',
		'hi': 'ひ',
		'fu': 'ふ',
		'he': 'へ',
		'ho': 'ほ',
		'hya': 'ひゃ',
		'hyu': 'ひゅ',
		'hyo': 'ひょ',
		'ma': 'ま',
		'mi': 'み',
		'mu': 'む',
		'me': 'め',
		'mo': 'も',
		'mya': 'みゃ',
		'myu': 'みゅ',
		'myo': 'みょ',
		'ya': 'や',
		'yu': 'ゆ',
		'yo': 'よ',
		'ra': 'ら',
		'ri': 'り',
		'ru': 'る',
		're': 'れ',
		'ro': 'ろ',
		'rya': 'りゃ',
		'ryu': 'りゅ',
		'ryo': 'りょ',
		'wa': 'わ',
		'wi': 'ゐ',
		'we': 'ゑ',
		'wo': 'を',
		'n': 'ん',
		'ga': 'が',
		'gi': 'ぎ',
		'gu': 'ぐ',
		'ge': 'げ',
		'go': 'ご',
		'gya': 'ぎゃ',
		'gyu': 'ぎゅ',
		'gyo': 'ぎょ',
		'za': 'ざ',
		'ji': 'じ',
		'zu': 'ず',
		'ze': 'ぜ',
		'zo': 'ぞ',
		'ja': 'じゃ',
		'ju': 'じゅ',
		'jo': 'じょ',
		'da': 'だ',
		'ji': 'ぢ',
		'zu': 'づ',
		'de': 'で',
		'do': 'ど',
		'ba': 'ば',
		'bi': 'び',
		'bu': 'ぶ',
		'be': 'べ',
		'bo': 'ぼ',
		'bya': 'びゃ',
		'byu': 'びゅ',
		'byo': 'びょ',
		'pa': 'ぱ',
		'pi': 'ぴ',
		'pu': 'ぷ',
		'pe': 'ぺ',
		'po': 'ぽ',
		'pya': 'ぴゃ',
		'pyu': 'ぴゅ',
		'pyo': 'ぴょ'
	};
	
	vocshark.converter = {
		transcribe: function (word, transcription) {
			for (var l = 3; l > 0; l--) {
				for (var i in transcription) {
					if (i.length == l) {
						word = word.replace(new RegExp(i, 'g'), transcription[i]);
					}
				}
			}
			return word;
		},
		toHiragana: function (word) {
			return this.transcribe(word, hiraganaTrascription);
		},
		toKatakana: function (word) {
			return this.transcribe(word, katakanaTranscription);
		}
	}
})();
