

/* Services */

angular.module('kanatrainer.services', ['ngResource']).

value('STORAGE_ID', 'kanatrainer-store').

factory('storageManager', function ($rootScope, lessonLoader) {

  var LAST_TRAINING_STATS = 'lastTrainingStats';
  var TRAINING_STATS_HISTORY = 'trainingStatsHistory';
  var KEY_LESSONS = 'kanaLessons'
  var trainingStatistics = {
        right : 0,
        wrong : 0,
        score : 100,
        firstUpdate : new Date(),
        lastUpdate : new Date(),
        update: function(result){
          if(result){
            this.right++;
          }else{
            this.wrong++;
          }
          this.score = Math.round((this.right/(this.right+this.wrong))*100);
          this.lastUpdate = new Date();
          //prersist session
          var duration = Math.round((this.lastUpdate.getTime() - this.firstUpdate.getTime())/60000);
          asyncStorage.setItem(LAST_TRAINING_STATS, { right: this.right, wrong: this.wrong, 
                                                     time: this.lastUpdate.getTime(), 
                                                     duration: duration});
        },
        reset: function(){
          this.right = this.wrong = 0;
          this.score = 100;
        }
  };
  var trainingStatisticsHistory = [];
  var memorizedCharacters = {};
  var activeCharacters = [];
  /* last character to avoid asking it again */
  var selectedLessons = [];
  var lastChar = {};

  return {
     
     activeCharacters : activeCharacters,
     trainingStatistics : trainingStatistics,
     trainingStatisticsHistory : trainingStatisticsHistory,
     selectedLessons : selectedLessons,

     initialize : function(){
       $rootScope.ready = false;

       //load the list of activated lessons
       this.loadSelectedLessons();

       //persist the stats of the last training session to the history
       this.saveStatisticsToHistory();
     },
     
     loadSelectedLessons : function(){
       var self = this;
       asyncStorage.getItem(KEY_LESSONS, function(lessons) {
          self.setSelectedLessons(lessons != null ? lessons : ['lesson1']);
          $rootScope.$apply();
       });
     },

     loadLessons : function(){
       activeCharacters = [];      
       for (var i = 0; i < selectedLessons.length; i++) {
          activeCharacters = activeCharacters.concat(lessonLoader.loadLesson(selectedLessons[i]));
       };
       $rootScope.$broadcast('lessonsLoaded');
     },

     setSelectedLessons : function(lessons){
       selectedLessons = lessons;
       asyncStorage.setItem(KEY_LESSONS, selectedLessons);
       this.loadLessons();
     },

     getSelectedLessons : function(){
      return selectedLessons;
     },

     getCharacterCount : function(){
       return activeCharacters.length;
     },
    
     getActiveCharacterCount: function(){
        return activeCharacters.length;
     },

     getRandomEntry: function(dejavu) {
       //TODO overhaul this
       if (memorizedCharacters.size >= activeCharacters.length){
         colsole.log('reset memorized characters');
         memorizedCharacters = {};
       }

       var i = Math.floor(Math.random()*(activeCharacters.length-1)); 
       var character = activeCharacters[i];
       
       var count = 0;
       while ((lastChar == character) || dejavu[character.symbol]==true ||  memorizedCharacters[character.symbol]==true){

         dejavu[character.symbol]=false; //TODO that is kind of a hack
         i = Math.floor(Math.random()*(activeCharacters.length-1)); 
         character = activeCharacters[i];
         console.log("character: " + character.symbol + " lastchar: " + lastChar.symbol + " dejavu? " + dejavu[character.symbol] + " memorized? " +  memorizedCharacters[character.symbol]);

         if(count++ > 30){
           break;
         }
       }


//       if (!character.hasStats())
//       {
//       //get the stats from the db
//       var stats:Object = _persitenceManager.getProperty(character.label);
//       if (stats)
//       {
//      character.statsCSV = String(stats);
//       trace('got stats from DataStore: ' + stats);
//       }
//       }
//       //dynamic skip ensures that easy words are less often asked
//       if (character.skip){
//       return getRandomEntry(dejavu);
//       } 

       return	character;
     },
      
     markAsRight: function (entity) {
       memorizedCharacters[entity.symbol] = true;
       trainingStatistics.update(true);
       this.saveStats(entity,true);

       var memorized = "";
       for(var e in memorizedCharacters){
         memorized += e;
       }
       console.log("memorized: " + memorized);
     },

     markAsWrong: function (entity) {
       trainingStatistics.update(false);
       this.saveStats(entity,false);
     },

     saveStats: function (entity, right){
      //TODO   
     },
    
     saveStatisticsToHistory: function() {
       self = this;
       asyncStorage.getItem(LAST_TRAINING_STATS, function(lastStats){
         asyncStorage.getItem(TRAINING_STATS_HISTORY, function(statsHistory){
           if(!statsHistory){
            statsHistory = [];
           }
           console.log("history contains " + statsHistory.length + " items");
           self.trainingStatisticsHistory = statsHistory;
     
           //save last stats to the history
           if(lastStats && (lastStats.right + lastStats.wrong) > 1){
             console.log('last stats saved to history');
             statsHistory.push(lastStats);
             asyncStorage.setItem(TRAINING_STATS_HISTORY, statsHistory);
             asyncStorage.setItem(LAST_TRAINING_STATS, null);
           }
         });
       });
     },

     resetStatistics: function() {
       this.saveStatisticsToHistory();
       trainingStatistics.reset();
       memorizedCharacters = {};
     }
   };

}).

value('LESSONS', {
"lesson1": [
{"romaji": "a","symbol": "あ","type": "HIRAGANA","anim": "hiraganaA"},
{"romaji": "i","symbol": "い","type": "HIRAGANA","anim": "hiraganaI"},
{"romaji": "u","symbol": "う","type": "HIRAGANA","anim": "hiraganaU"},
{"romaji": "e","symbol": "え","type": "HIRAGANA","anim": "hiraganaE"},
{"romaji": "o","symbol": "お","type": "HIRAGANA","anim": "hiraganaO"},
{"romaji": "ka","symbol": "か","type": "HIRAGANA","anim": "hiraganaKA"},
{"romaji": "ki","symbol": "き","type": "HIRAGANA","anim": "hiraganaKI"},
{"romaji": "ku","symbol": "く","type": "HIRAGANA","anim": "hiraganaKU"},
{"romaji": "ke","symbol": "け","type": "HIRAGANA","anim": "hiraganaKE"},
{"romaji": "ko","symbol": "こ","type": "HIRAGANA","anim": "hiraganaKO"},
{"romaji": "sa","symbol": "さ","type": "HIRAGANA","anim": "hiraganaSA"},
{"romaji": "shi","symbol": "し","type": "HIRAGANA","anim": "hiraganaSHI"},
{"romaji": "su","symbol": "す","type": "HIRAGANA","anim": "hiraganaSU"},
{"romaji": "se","symbol": "せ","type": "HIRAGANA","anim": "hiraganaSE"},
{"romaji": "so","symbol": "そ","type": "HIRAGANA","anim": "hiraganaSO"},
{"romaji": "ta","symbol": "た","type": "HIRAGANA","anim": "hiraganaTA"},
{"romaji": "chi","symbol": "ち","type": "HIRAGANA","anim": "hiraganaCHI"},
{"romaji": "tsu","symbol": "つ","type": "HIRAGANA","anim": "hiraganaTSU"},
{"romaji": "te","symbol": "て","type": "HIRAGANA","anim": "hiraganaTE"},
{"romaji": "to","symbol": "と","type": "HIRAGANA","anim": "hiraganaTO"},
{"romaji": "na","symbol": "な","type": "HIRAGANA","anim": "hiraganaNA"},
{"romaji": "ni","symbol": "に","type": "HIRAGANA","anim": "hiraganaNI"},
{"romaji": "nu","symbol": "ぬ","type": "HIRAGANA","anim": "hiraganaNU"},
{"romaji": "ne","symbol": "ね","type": "HIRAGANA","anim": "hiraganaNE"},
{"romaji": "no","symbol": "の","type": "HIRAGANA","anim": "hiraganaNO"},
{"romaji": "ha","symbol": "は","type": "HIRAGANA","anim": "hiraganaHA"},
{"romaji": "hi","symbol": "ひ","type": "HIRAGANA","anim": "hiraganaHI"},
{"romaji": "fu","symbol": "ふ","type": "HIRAGANA","anim": "hiraganaFU"},
{"romaji": "he","symbol": "へ","type": "HIRAGANA","anim": "hiraganaHE"},
{"romaji": "ho","symbol": "ほ","type": "HIRAGANA","anim": "hiraganaHO"},
{"romaji": "ma","symbol": "ま","type": "HIRAGANA","anim": "hiraganaMA"},
{"romaji": "mi","symbol": "み","type": "HIRAGANA","anim": "hiraganaMI"},
{"romaji": "mu","symbol": "む","type": "HIRAGANA","anim": "hiraganaMU"},
{"romaji": "me","symbol": "め","type": "HIRAGANA","anim": "hiraganaME"},
{"romaji": "mo","symbol": "も","type": "HIRAGANA","anim": "hiraganaMO"},
{"romaji": "ya","symbol": "や","type": "HIRAGANA","anim": "hiraganaYA"},
{"romaji": "yu","symbol": "ゆ","type": "HIRAGANA","anim": "hiraganaYU"},
{"romaji": "yo","symbol": "よ","type": "HIRAGANA","anim": "hiraganaYO"},
{"romaji": "ra","symbol": "ら","type": "HIRAGANA","anim": "hiraganaRA"},
{"romaji": "ri","symbol": "り","type": "HIRAGANA","anim": "hiraganaRI"},
{"romaji": "ru","symbol": "る","type": "HIRAGANA","anim": "hiraganaRU"},
{"romaji": "re","symbol": "れ","type": "HIRAGANA","anim": "hiraganaRE"},
{"romaji": "ro","symbol": "ろ","type": "HIRAGANA","anim": "hiraganaRO"},
{"romaji": "wa","symbol": "わ","type": "HIRAGANA","caption": "Particle","anim": "hiraganaWA"},
{"romaji": "wo","symbol": "を","type": "HIRAGANA","caption": "Particle","anim": "hiraganaWO"},
{"romaji": "n","symbol": "ん","type": "HIRAGANA","anim": "hiraganaN"}],

"lesson2": [
{"romaji": "ga","symbol": "が","type": "HIRAGANA","anim": "hiraganaGA"},
{"romaji": "gi","symbol": "ぎ","type": "HIRAGANA","anim": "hiraganaGI"},
{"romaji": "gu","symbol": "ぐ","type": "HIRAGANA","anim": "hiraganaGU"},
{"romaji": "ge","symbol": "げ","type": "HIRAGANA","anim": "hiraganaGE"},
{"romaji": "go","symbol": "ご","type": "HIRAGANA","anim": "hiraganaGO"},
{"romaji": "za","symbol": "ざ","type": "HIRAGANA","anim": "hiraganaZA"},
{"romaji": "ji","symbol": "じ","type": "HIRAGANA","anim": "hiraganaJI"},
{"romaji": "zu","symbol": "ず","type": "HIRAGANA","anim": "hiraganaZU"},
{"romaji": "ze","symbol": "ぜ","type": "HIRAGANA","anim": "hiraganaZE"},
{"romaji": "zo","symbol": "ぞ","type": "HIRAGANA","anim": "hiraganaZO"},
{"romaji": "da","symbol": "だ","type": "HIRAGANA","anim": "hiraganaDA"},
{"romaji": "de","symbol": "で","type": "HIRAGANA","anim": "hiraganaDE"},
{"romaji": "do","symbol": "ど","type": "HIRAGANA","anim": "hiraganaDO"},
{"romaji": "ba","symbol": "ば","type": "HIRAGANA","anim": "hiraganaBA"},
{"romaji": "bi","symbol": "び","type": "HIRAGANA","anim": "hiraganaBI"},
{"romaji": "bu","symbol": "ぶ","type": "HIRAGANA","anim": "hiraganaBU"},
{"romaji": "be","symbol": "べ","type": "HIRAGANA","anim": "hiraganaBE"},
{"romaji": "bo","symbol": "ぼ","type": "HIRAGANA","anim": "hiraganaBO"},
{"romaji": "pa","symbol": "ぱ","type": "HIRAGANA","anim": "hiraganaPA"},
{"romaji": "pi","symbol": "ぴ","type": "HIRAGANA","anim": "hiraganaPI"},
{"romaji": "pu","symbol": "ぷ","type": "HIRAGANA","anim": "hiraganaPU"},
{"romaji": "pe","symbol": "ぺ","type": "HIRAGANA","anim": "hiraganaPE"},
{"romaji": "po","symbol": "ぽ","type": "HIRAGANA","anim": "hiraganaPO"}],

"lesson3": [
{"romaji": "kya","symbol": "きゃ","type": "HIRAGANA","anim": "hiraganaKYA"},
{"romaji": "kyu","symbol": "きゅ","type": "HIRAGANA","anim": "hiraganaKYU"},
{"romaji": "kyo","symbol": "きょ","type": "HIRAGANA","anim": "hiraganaKYO"},
{"romaji": "sha","symbol": "しゃ","type": "HIRAGANA","anim": "hiraganaSHA"},
{"romaji": "shu","symbol": "しゅ","type": "HIRAGANA","anim": "hiraganaSHU"},
{"romaji": "sho","symbol": "しょ","type": "HIRAGANA","anim": "hiraganaSHO"},
{"romaji": "cha","symbol": "ちゃ","type": "HIRAGANA","anim": "hiraganaCHA"},
{"romaji": "chu","symbol": "ちゅ","type": "HIRAGANA","anim": "hiraganaCHU"},
{"romaji": "cho","symbol": "ちょ","type": "HIRAGANA","anim": "hiraganaCHO"},
{"romaji": "nya","symbol": "にゃ","type": "HIRAGANA","anim": "hiraganaNYA"},
{"romaji": "nyu","symbol": "にゅ","type": "HIRAGANA","anim": "hiraganaNYU"},
{"romaji": "nyo","symbol": "にょ","type": "HIRAGANA","anim": "hiraganaNYO"},
{"romaji": "hya","symbol": "ひゃ","type": "HIRAGANA","anim": "hiraganaHYA"},
{"romaji": "hyu","symbol": "ひゅ","type": "HIRAGANA","anim": "hiraganaHYU"},
{"romaji": "hyo","symbol": "ひょ","type": "HIRAGANA","anim": "hiraganaHYO"},
{"romaji": "mya","symbol": "みゃ","type": "HIRAGANA","anim": "hiraganaMYA"},
{"romaji": "myu","symbol": "みゅ","type": "HIRAGANA","anim": "hiraganaMYU"},
{"romaji": "myo","symbol": "みょ","type": "HIRAGANA","anim": "hiraganaMYO"},
{"romaji": "rya","symbol": "りゃ","type": "HIRAGANA","anim": "hiraganaRYA"},
{"romaji": "ryu","symbol": "りゅ","type": "HIRAGANA","anim": "hiraganaRYU"},
{"romaji": "ryo","symbol": "りょ","type": "HIRAGANA","anim": "hiraganaRYO"},
{"romaji": "gya","symbol": "がゃ","type": "HIRAGANA","anim": "hiraganaGYA"},
{"romaji": "gyu","symbol": "がゅ","type": "HIRAGANA","anim": "hiraganaGYU"},
{"romaji": "gyo","symbol": "がょ","type": "HIRAGANA","anim": "hiraganaGYO"},
{"romaji": "ja","symbol": "じゃ","type": "HIRAGANA","anim": "hiraganaJA"},
{"romaji": "ju","symbol": "じゅ","type": "HIRAGANA","anim": "hiraganaJU"},
{"romaji": "jo","symbol": "じょ","type": "HIRAGANA","anim": "hiraganaJO"},
{"romaji": "bya","symbol": "びゃ","type": "HIRAGANA","anim": "hiraganaBYA"},
{"romaji": "byu","symbol": "びゅ","type": "HIRAGANA","anim": "hiraganaBYU"},
{"romaji": "byo","symbol": "びょ","type": "HIRAGANA","anim": "hiraganaBYO"},
{"romaji": "pya","symbol": "ぴゃ","type": "HIRAGANA","anim": "hiraganaPYA"},
{"romaji": "pyu","symbol": "ぴゅ","type": "HIRAGANA","anim": "hiraganaPYU"},
{"romaji": "pyo","symbol": "ぴょ","type": "HIRAGANA","anim": "hiraganaPYO"}],
"lesson4": [
{"romaji": "a","symbol": "ア","type": "KATAKANA","anim": "katakanaA"},
{"romaji": "i","symbol": "イ","type": "KATAKANA","anim": "katakanaI"},
{"romaji": "u","symbol": "ウ","type": "KATAKANA","anim": "katakanaU"},
{"romaji": "e","symbol": "エ","type": "KATAKANA","anim": "katakanaE"},
{"romaji": "o","symbol": "オ","type": "KATAKANA","anim": "katakanaO"},
{"romaji": "ka","symbol": "カ","type": "KATAKANA","anim": "katakanaKA"},
{"romaji": "ki","symbol": "キ","type": "KATAKANA","anim": "katakanaKI"},
{"romaji": "ku","symbol": "ク","type": "KATAKANA","anim": "katakanaKU"},
{"romaji": "ke","symbol": "ケ","type": "KATAKANA","anim": "katakanaKE"},
{"romaji": "ko","symbol": "コ","type": "KATAKANA","anim": "katakanaKO"},
{"romaji": "sa","symbol": "サ","type": "KATAKANA","anim": "katakanaSA"},
{"romaji": "shi","symbol": "シ","type": "KATAKANA","anim": "katakanaSHI"},
{"romaji": "su","symbol": "ス","type": "KATAKANA","anim": "katakanaSU"},
{"romaji": "se","symbol": "セ","type": "KATAKANA","anim": "katakanaSE"},
{"romaji": "so","symbol": "ソ","type": "KATAKANA","anim": "katakanaSO"},
{"romaji": "ta","symbol": "タ","type": "KATAKANA","anim": "katakanaTA"},
{"romaji": "chi","symbol": "チ","type": "KATAKANA","anim": "katakanaCHI"},
{"romaji": "tsu","symbol": "ツ","type": "KATAKANA","anim": "katakanaTSU"},
{"romaji": "te","symbol": "テ","type": "KATAKANA","anim": "katakanaTE"},
{"romaji": "to","symbol": "ト","type": "KATAKANA","anim": "katakanaTO"},
{"romaji": "na","symbol": "ナ","type": "KATAKANA","anim": "katakanaNA"},
{"romaji": "ni","symbol": "ニ","type": "KATAKANA","anim": "katakanaNI"},
{"romaji": "nu","symbol": "ヌ","type": "KATAKANA","anim": "katakanaNU"},
{"romaji": "ne","symbol": "ネ","type": "KATAKANA","anim": "katakanaNE"},
{"romaji": "no","symbol": "ノ","type": "KATAKANA","anim": "katakanaNO"},
{"romaji": "ha","symbol": "ハ","type": "KATAKANA","anim": "katakanaHA"},
{"romaji": "hi","symbol": "ヒ","type": "KATAKANA","anim": "katakanaHI"},
{"romaji": "fu","symbol": "フ","type": "KATAKANA","anim": "katakanaFU"},
{"romaji": "he","symbol": "ヘ","type": "KATAKANA","anim": "katakanaHE"},
{"romaji": "ho","symbol": "ホ","type": "KATAKANA","anim": "katakanaHO"},
{"romaji": "ma","symbol": "マ","type": "KATAKANA","anim": "katakanaMA"},
{"romaji": "mi","symbol": "ミ","type": "KATAKANA","anim": "katakanaMI"},
{"romaji": "mu","symbol": "ム","type": "KATAKANA","anim": "katakanaMU"},
{"romaji": "me","symbol": "メ","type": "KATAKANA","anim": "katakanaME"},
{"romaji": "mo","symbol": "モ","type": "KATAKANA","anim": "katakanaMO"},
{"romaji": "ya","symbol": "ヤ","type": "KATAKANA","anim": "katakanaYA"},
{"romaji": "yu","symbol": "ユ","type": "KATAKANA","anim": "katakanaYU"},
{"romaji": "yo","symbol": "ヨ","type": "KATAKANA","anim": "katakanaYO"},
{"romaji": "ra","symbol": "ラ","type": "KATAKANA","anim": "katakanaRA"},
{"romaji": "ri","symbol": "リ","type": "KATAKANA","anim": "katakanaRI"},
{"romaji": "ru","symbol": "ル","type": "KATAKANA","anim": "katakanaRU"},
{"romaji": "re","symbol": "レ","type": "KATAKANA","anim": "katakanaRE"},
{"romaji": "ro","symbol": "ロ","type": "KATAKANA","anim": "katakanaRO"},
{"romaji": "wa","symbol": "ワ","type": "KATAKANA","caption": "Particle","anim": "katakanaWA"},
{"romaji": "wo","symbol": "ヲ","type": "KATAKANA","caption": "Particle","anim": "katakanaWO"},
{"romaji": "n","symbol": "ン","type": "KATAKANA","anim": "katakanaN"}],

"lesson5": [
{"romaji": "ga","symbol": "ガ","type": "KATAKANA","anim": "katakanaGA"},
{"romaji": "gi","symbol": "ギ","type": "KATAKANA","anim": "katakanaGI"},
{"romaji": "gu","symbol": "グ","type": "KATAKANA","anim": "katakanaGU"},
{"romaji": "ge","symbol": "ゲ","type": "KATAKANA","anim": "katakanaGE"},
{"romaji": "go","symbol": "ゴ","type": "KATAKANA","anim": "katakanaGO"},
{"romaji": "za","symbol": "ザ","type": "KATAKANA","anim": "katakanaZA"},
{"romaji": "ji","symbol": "ジ","type": "KATAKANA","anim": "katakanaJI"},
{"romaji": "zu","symbol": "ズ","type": "KATAKANA","anim": "katakanaZU"},
{"romaji": "ze","symbol": "ゼ","type": "KATAKANA","anim": "katakanaZE"},
{"romaji": "zo","symbol": "ゾ","type": "KATAKANA","anim": "katakanaZO"},
{"romaji": "da","symbol": "ダ","type": "KATAKANA","anim": "katakanaDA"},
{"romaji": "de","symbol": "デ","type": "KATAKANA","anim": "katakanaDE"},
{"romaji": "do","symbol": "ド","type": "KATAKANA","anim": "katakanaDO"},
{"romaji": "ba","symbol": "バ","type": "KATAKANA","anim": "katakanaBA"},
{"romaji": "bi","symbol": "ビ","type": "KATAKANA","anim": "katakanaBI"},
{"romaji": "bu","symbol": "ブ","type": "KATAKANA","anim": "katakanaBU"},
{"romaji": "be","symbol": "ベ","type": "KATAKANA","anim": "katakanaBE"},
{"romaji": "bo","symbol": "ボ","type": "KATAKANA","anim": "katakanaBO"},
{"romaji": "pa","symbol": "パ","type": "KATAKANA","anim": "katakanaPA"},
{"romaji": "pi","symbol": "ピ","type": "KATAKANA","anim": "katakanaPI"},
{"romaji": "pu","symbol": "プ","type": "KATAKANA","anim": "katakanaPU"},
{"romaji": "pe","symbol": "ペ","type": "KATAKANA","anim": "katakanaPE"},
{"romaji": "po","symbol": "ポ","type": "KATAKANA","anim": "katakanaPO"}],

"lesson6": [
{"romaji": "kya","symbol": "キャ","type": "KATAKANA","anim": "katakanaKYA"},
{"romaji": "kyu","symbol": "キュ","type": "KATAKANA","anim": "katakanaKYU"},
{"romaji": "kyo","symbol": "キョ","type": "KATAKANA","anim": "katakanaKYO"},
{"romaji": "sha","symbol": "シャ","type": "KATAKANA","anim": "katakanaSHA"},
{"romaji": "shu","symbol": "シュ","type": "KATAKANA","anim": "katakanaSHU"},
{"romaji": "sho","symbol": "ショ","type": "KATAKANA","anim": "katakanaSHO"},
{"romaji": "cha","symbol": "チャ","type": "KATAKANA","anim": "katakanaCHA"},
{"romaji": "chu","symbol": "チュ","type": "KATAKANA","anim": "katakanaCHU"},
{"romaji": "cho","symbol": "チョ","type": "KATAKANA","anim": "katakanaCHO"},
{"romaji": "nya","symbol": "ニャ","type": "KATAKANA","anim": "katakanaNYA"},
{"romaji": "nyu","symbol": "ニュ","type": "KATAKANA","anim": "katakanaNYU"},
{"romaji": "nyo","symbol": "ニョ","type": "KATAKANA","anim": "katakanaNYO"},
{"romaji": "hya","symbol": "ヒャ","type": "KATAKANA","anim": "katakanaHYA"},
{"romaji": "hyu","symbol": "ヒュ","type": "KATAKANA","anim": "katakanaHYU"},
{"romaji": "hyo","symbol": "ヒョ","type": "KATAKANA","anim": "katakanaHYO"},
{"romaji": "mya","symbol": "ミャ","type": "KATAKANA","anim": "katakanaMYA"},
{"romaji": "myu","symbol": "ミュ","type": "KATAKANA","anim": "katakanaMYU"},
{"romaji": "myo","symbol": "ミョ","type": "KATAKANA","anim": "katakanaMYO"},
{"romaji": "rya","symbol": "リャ","type": "KATAKANA","anim": "katakanaRYA"},
{"romaji": "ryu","symbol": "リュ","type": "KATAKANA","anim": "katakanaRYU"},
{"romaji": "ryo","symbol": "リョ","type": "KATAKANA","anim": "katakanaRYO"},
{"romaji": "gya","symbol": "ギャ","type": "KATAKANA","anim": "katakanaGYA"},
{"romaji": "gyu","symbol": "ギュ","type": "KATAKANA","anim": "katakanaGYU"},
{"romaji": "gyo","symbol": "ギョ","type": "KATAKANA","anim": "katakanaGYO"},
{"romaji": "ja","symbol": "ジャ","type": "KATAKANA","anim": "katakanaJA"},
{"romaji": "ju","symbol": "ジュ","type": "KATAKANA","anim": "katakanaJU"},
{"romaji": "jo","symbol": "ジョ","type": "KATAKANA","anim": "katakanaJO"},
{"romaji": "bya","symbol": "ビャ","type": "KATAKANA","anim": "katakanaBYA"},
{"romaji": "byu","symbol": "ビュ","type": "KATAKANA","anim": "katakanaBYU"},
{"romaji": "byo","symbol": "ビョ","type": "KATAKANA","anim": "katakanaBYO"},
{"romaji": "pya","symbol": "ピャ","type": "KATAKANA","anim": "katakanaPYA"},
{"romaji": "pyu","symbol": "ピュ","type": "KATAKANA","anim": "katakanaPYU"},
{"romaji": "pyo","symbol": "ピョ","type": "KATAKANA","anim": "katakanaPYO"}],
"lesson7": [
{"romaji": "1","symbol": "一","type": "KANJI","caption": "ichi"},
{"romaji": "2","symbol": "ニ","type": "KANJI","caption": "ni"},
{"romaji": "3","symbol": "三","type": "KANJI","caption": "san"},
{"romaji": "4","symbol": "四","type": "KANJI","caption": "yon/shi"},
{"romaji": "5","symbol": "五","type": "KANJI","caption": "go"},
{"romaji": "6","symbol": "六","type": "KANJI","caption": "roku"},
{"romaji": "7","symbol": "七","type": "KANJI","caption": "shichi/nana"},
{"romaji": "8","symbol": "八","type": "KANJI","caption": "hachi"},
{"romaji": "9","symbol": "九","type": "KANJI","caption": "kyû/ku"},
{"romaji": "10","symbol": "十","type": "KANJI","caption": "jû"},
{"romaji": "100","symbol": "百","type": "KANJI","caption": "hyaku"},
{"romaji": "1000","symbol": "千","type": "KANJI","caption": "sen"},
{"romaji": "10000","symbol": "万","type": "KANJI","caption": "man"},
{"romaji": "Monday","symbol": "月","type": "KANJI","caption": "Moon, げつ, がつ"},
{"romaji": "Tuesday","symbol": "火","type": "KANJI","caption": "Fire, か, こ"},
{"romaji": "Wednesday","symbol": "水","type": "KANJI","caption": "Water, すい"},
{"romaji": "Thursday","symbol": "木","type": "KANJI","caption": "Tree, もく"},
{"romaji": "Friday","symbol": "金","type": "KANJI","caption": "Gold, きん"},
{"romaji": "Saturday","symbol": "土","type": "KANJI","caption": "Earth, Soil, ど"},
{"romaji": "Sunday","symbol": "日","type": "KANJI","caption": "にち"},
{"romaji": "Day","symbol": "曜","type": "KANJI","caption": "よう"}]
}).

factory('lessonLoader', ['LESSONS', function (LESSONS) {

  return {
     
     loadLesson: function(lesson){
       return LESSONS[lesson];
     }
  }
}]);
