/*
*
*   first array value -> determines consonant prefix (row)
*   second array value -> determines the wovel (column)
*   third array value -> determines writing type (roumaji/hiragana/katakana)
*
*/

var monographs = [
	[["a", "あ", "ア"], ["i", "い", "イ"], ["u", "う", "ウ"], ["e", "え", "エ"], ["o", "お", "オ"]],
	[["ka", "か", "カ"], ["ki", "き", "キ"], ["ku", "く", "ク"], ["ke", "け", "ケ"], ["ko", "こ", "コ"]],
	[["sa", "さ", "サ"], ["shi", "し", "シ"], ["su", "す", "ス"], ["se", "せ", "セ"], ["so", "そ", "ソ"]],
	[["ta", "た", "タ"], ["chi", "ち", "チ"], ["tsu", "つ", "ツ"], ["te", "て", "テ"], ["to", "と", "ト"]],
	[["na", "な", "ナ"], ["ni", "に", "ニ"], ["nu", "ぬ", "ヌ"], ["ne", "ね", "ネ"], ["no", "の", "ノ"]],
	[["ha", "は", "ハ"], ["hi", "ひ", "ヒ"], ["fu", "ふ", "フ"], ["he", "へ", "ヘ"], ["ho", "ほ", "ホ"]],
	[["ma", "ま", "マ"], ["mi", "み", "ミ"], ["mu", "む", "ム"], ["me", "め", "メ"], ["mo", "も", "モ"]],
	[["ya", "や", "ヤ"], ["", "", ""], ["yu", "ゆ", "ユ"], ["", "", ""], ["yo", "よ", "ヨ"]],
	[["ra", "ら", "ラ"], ["ri", "り", "リ"], ["ru", "る", "ル"], ["re", "れ", "レ"], ["ro", "ろ", "ロ"]],
	[["wa", "わ", "ワ"], ["", "", ""], ["", "", ""], ["", "", ""], ["wo", "を", "ヲ"]],
	[["n", "ん", "ン"]]
];

var digraphs = [
	[["kya", "きゃ", "キャ"], ["kyu", "きゅ", "キュ"], ["kyo", "きょ", "キョ"]],
	[["sha", "しゃ", "シャ"], ["shu", "しゅ", "シュ"], ["sho", "しょ", "ショ"]],
	[["cha", "ちゃ", "チャ"], ["chu", "ちゅ", "チュ"], ["cho", "ちょ", "チョ"]],
	[["nya", "にゃ", "ニャ"], ["nyu", "にゅ", "ニュ"], ["nyo", "にょ", "ニョ"]],
	[["hya", "ひゃ", "ヒャ"], ["hyu", "ひゅ", "ヒュ"], ["hyo", "ひょ", "ヒョ"]],
	[["mya", "みゃ", "ミャ"], ["myu", "みゅ", "ミュ"], ["myo", "みょ", "ミョ"]],
	[["rya", "りゃ", "リャ"], ["ryu", "りゅ", "リュ"], ["ryo", "りょ", "リョ"]]
];

var monographs_with_diacritics = [
	[["ga", "が", "ガ"], ["gi", "ぎ", "ギ"], ["gu", "ぐ", "グ"], ["ge", "げ", "ゲ"], ["go", "ご", "ゴ"]],
	[["za", "ざ", "ザ"], ["ji", "じ", "ジ"], ["zu", "ず", "ズ"], ["ze", "ぜ", "ゼ"], ["zo", "ぞ", "ゾ"]],
	[["da", "だ", "ダ"], ["ji", "ぢ", "ヂ"], ["zu", "づ", "ヅ"], ["de", "で", "デ"], ["do", "ど", "ド"]],
	[["ba", "ば", "バ"], ["bi", "び", "ビ"], ["bu", "ぶ", "ブ"], ["be", "べ", "ベ"], ["bo", "ぼ", "ボ"]],
	[["pa", "ぱ", "パ"], ["pi", "ぴ", "ピ"], ["pu", "ぷ", "プ"], ["pe", "ぺ", "ペ"], ["po", "ぽ", "ポ"]]
];

var digraphs_with_diacritics = [
	[["gya", "ぎゃ", "ギャ"], ["gyu", "ぎゅ", "ギュ"], ["gyo", "ぎょ", "ギョ"]],
	[["ja", "じゃ", "ジャ"], ["ju", "じゅ", "ジュ"], ["jo", "じょ", "ジョ"]],
	//[["cha", "ぢゃ", "ヂャ"], ["chu", "ぢゅ", "ヂュ"], ["cho", "ぢょ", "ヂョ"]],
	[["bya", "びゃ", "ビャ"], ["byu", "びゅ", "ビュ"], ["byo", "びょ", "ビョ"]],
	[["pya", "ぴゃ", "ピャ"], ["pyu", "ぴゅ", "ピュ"], ["pyo", "ぴょ", "ピョ"]]
];

var total_quest  = 0;
var right_answer = 0;
var answered     = 0;
var no_repeat    = new Array();

function get_exercise_cont(val_arr, mode){
	var mode = (mode == 3) ? Math.floor((Math.random()*2)+1) : mode;
	var public_cont = '\n' +
'          <h3>Number '+(answered+1)+'/'+total_quest+'</h3>\n' +
'          <h1 class="align-center answer">'+ val_arr[mode] +'</h1>\n' +
'          <input type="text" id="answer" placeholder="Romaji Answer Box" class="form-control"><br>\n' +
'          <input type="button" class="btn btn-primary btn-block btn-submit-ans" value="Submit">\n';
	return public_cont;
}

function get_xy(){
	var mode = Math.floor((Math.random()*4)+1);
	if(mode == 1){
		var x = Math.floor((Math.random()*11));
		var y = (x == 10) ? 0 : Math.floor((Math.random()*5));
		var ret = monographs[x][y];
	}else if(mode == 2){
		var x = Math.floor((Math.random()*7));
		var y = Math.floor((Math.random()*3));
		var ret = digraphs[x][y];
	}else if(mode == 3){
		var x = Math.floor((Math.random()*5));
		var y = Math.floor((Math.random()*5));
		var ret = monographs_with_diacritics[x][y];
	}else if(mode == 4){
		var x = Math.floor((Math.random()*4));
		var y = Math.floor((Math.random()*3));
		var ret = digraphs_with_diacritics[x][y];
	}

	var the_tmp_val = mode+"|"+x+"|"+y;
	if(ret[0] == "" || no_repeat.indexOf(the_tmp_val) != -1){
		ret = get_xy();
	}else{
		no_repeat.push(the_tmp_val);
	}

	return ret;
}

function get_answer(code){
	var tmp = code.split("|");
	var mode = tmp[0];
	var x = tmp[1];
	var y = tmp[2];
	if(mode == 1){
		var ret = monographs[x][y];
	}else if(mode == 2){
		var ret = digraphs[x][y];
	}else if(mode == 3){
		var ret = monographs_with_diacritics[x][y];
	}else if(mode == 4){
		var ret = digraphs_with_diacritics[x][y];
	}

	return ret[0];
}