(function() {
  var AdSenseSingleton, Asset, AssetsManager, AssetsManagerSingleton, BaitDataSingleton, BaseScene, BgmManager, BgmManagerSingleton, BitmapFont, BitmapText, BookScene, Config, EnemyDataSingleton, Env, Event, EventDispatcher, EventDispatcherSingleton, FlurrySingleton, GameCenter, GameCenterSingleton, Lang, LoadingSprite, LocalNotificationSingleton, Main, PlayerDataSingleton, PointNumberFont, ShopDataSingleton, SoundEffectManager, StageDataSingleton, TitleScene, construct, delay, dp, getAssetPathById, getAssetPaths, getPixelRate, getRetinaPath, key, makeAssets, namespace, sePlay, val, __, _ref, _ref1, _ref2, _ref3,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __slice = [].slice,
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; },
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    __hasProp = {}.hasOwnProperty;

  Env = {
    IS_DEBUG: true,
    IS_MOBILE: !!(navigator.userAgent.match(/(iPhone|iPod|iPad|Android|BlackBerry)/)),
    IS_RETINA: false,
    IS_RETINA_DEVICE: window.devicePixelRatio > 1,
    IS_FIREFOX: !!(navigator.userAgent.match(/Firefox/)),
    LANG: (_ref = (_ref1 = (_ref2 = (_ref3 = typeof navigator !== "undefined" && navigator !== null ? navigator.browserLanguage : void 0) != null ? _ref3 : typeof navigator !== "undefined" && navigator !== null ? navigator.language : void 0) != null ? _ref2 : typeof navigator !== "undefined" && navigator !== null ? navigator.userLanguage : void 0) != null ? typeof _ref1.substr === "function" ? _ref1.substr(0, 2) : void 0 : void 0) != null ? _ref : "en"
  };

  Lang = {
    "en": {
      "now_loading": "Now Loading…",
      "stage_name_001": "Garden de la Patate mousseux",
      "stage_name_002": "Crisp Highland of Gooneston",
      "stage_name_003": "Animal Path to Carrot Fields",
      "stage_name_004": "Wild land of a Lone Gunman",
      "stage_name_005": "Fantasic Field above Clouds",
      "stage_name_006": "Shinobi's Bamboo Grove",
      "stage_name_007": "Icecream Littele garden",
      "stage_name_008": "Sunbaked　Custus Desert",
      "stage_name_009": "Animal Path through the Forest of Ghosts",
      "stage_name_010": "Satans's Miracle Field",
      "stage_desc_001": "Let's hunt all animals out who eat potate!",
      "stage_desc_002": "Gooneston's crews gather here on their vacation.",
      "stage_desc_003": "Oceanfront farm that animals come for a bathing.",
      "stage_desc_004": "Let's hunt animals living in the wild feild without a strip of grass!",
      "stage_desc_005": "Let's hunt animals attracted by misterious scent of crops!",
      "stage_desc_006": "Shinobi animals sneak up on the dark creepy path.",
      "stage_desc_007": "Let's hunt animals gathering around the sweet icecream!",
      "stage_desc_008": "Water of a cuctus can attract animals in this dry desert.",
      "stage_desc_009": "Let's go for hunting to the ghost forest in which　even animals can get lost.",
      "stage_desc_010": "Let's hunt Satan's servant animals caring on his farm！",
      "enemy_name_001": "Hiyoco",
      "enemy_name_002": "QuNell",
      "enemy_name_003": "Piglin",
      "enemy_name_004": "Nezmin",
      "enemy_name_005": "Hiyolein",
      "enemy_name_006": "Piyomoiselle",
      "enemy_name_007": "GunMoth",
      "enemy_name_008": "MydGhekko",
      "enemy_name_009": "CowCow",
      "enemy_name_010": "ZoooBat",
      "enemy_name_011": "GrrNell",
      "enemy_name_012": "Gooneston",
      "enemy_name_013": "Kirilin",
      "enemy_name_014": "Kontar",
      "enemy_name_015": "OttoSay",
      "enemy_name_016": "PenPeng",
      "enemy_name_017": "Pigool",
      "enemy_name_018": "Piganthes",
      "enemy_name_019": "Alligat",
      "enemy_name_020": "Cocco",
      "enemy_name_021": "Looper",
      "enemy_name_022": "Geeyagee",
      "enemy_name_023": "Nezrun",
      "enemy_name_024": "Nezmix",
      "enemy_name_025": "Elefang",
      "enemy_name_026": "Urma",
      "enemy_name_027": "Saic",
      "enemy_name_028": "Omutang",
      "enemy_name_029": "GyaMoth",
      "enemy_name_030": "GigaMoth",
      "enemy_name_031": "Monochrotha",
      "enemy_name_032": "Ulibo",
      "enemy_name_033": "WooHoe",
      "enemy_name_034": "Bambirhena",
      "enemy_name_035": "BurGecko",
      "enemy_name_036": "MegaGecko",
      "enemy_name_037": "CavaZoe",
      "enemy_name_038": "PapaQucum",
      "enemy_name_039": "PontaNu",
      "enemy_name_040": "Zukiwag",
      "enemy_name_041": "BurBur",
      "enemy_name_042": "Uscheking",
      "enemy_name_043": "Raccuda",
      "enemy_name_044": "Shirobei",
      "enemy_name_045": "Gramon",
      "enemy_name_046": "Ukkiki",
      "enemy_name_047": "Silvat",
      "enemy_name_048": "GoldenBat",
      "enemy_name_049": "Leesen",
      "enemy_name_050": "Cacamo",
      "enemy_name_051": "Raccore",
      "enemy_name_052": "ShumaShiuma",
      "enemy_name_053": "Gnaccho",
      "enemy_name_054": "Gnalien",
      "enemy_name_055": "Dorariu",
      "enemy_name_056": "SchSchMaiMai",
      "enemy_name_057": "GaoGaon",
      "enemy_name_058": "GyuSui",
      "enemy_name_059": "Bowow",
      "enemy_name_060": "GoWangco",
      "enemy_desc_001": "She always cares about her ribbon.Still a baby",
      "enemy_desc_002": "Cute Hat is his attracting point.He's a gentleman, never frighten a person.",
      "enemy_desc_003": "Cleay and shy.But he attacks a person by his snort.",
      "enemy_desc_004": "Moves too fast to catch up.Eats anything.",
      "enemy_desc_005": "Evoluted　Silver Baby Chick.",
      "enemy_desc_006": "Extict Golden Baby Chick.",
      "enemy_desc_007": "Ordinary mammoth that lives in cold district.Sensitive to cold.",
      "enemy_desc_008": "Ordinary frog you will see anywhare around the pond or riverside.",
      "enemy_desc_009": "Sleeping most of a day. Likes to eat grasses",
      "enemy_desc_010": "Attracted by a flashing objects。Lone bat sometimes stray into a town",
      "enemy_desc_011": "Evoluted　Silver Snake.",
      "enemy_desc_012": "Extinct Golden Snale.",
      "enemy_desc_013": "A Giraffe waiting so long for something.",
      "enemy_desc_014": "Loves to prank. Be carefull of him",
      "enemy_desc_015": "Genius at controlling a ball.",
      "enemy_desc_016": "He Always dreaming about flying.But it's just a dream.",
      "enemy_desc_017": "Evoluted　Silver Pig.",
      "enemy_desc_018": "Extinct Golden Pig.",
      "enemy_desc_019": "She always leaves beautifully. See you lator, alligator.",
      "enemy_desc_020": "She can't remeber anything.So she can make a clean switch about anything.",
      "enemy_desc_021": "She is calculating in contract of her cute appearance.Worldly snake.",
      "enemy_desc_022": "He is afraid of heights.A Goat that is often screaming.",
      "enemy_desc_023": "Evoluted　Silver Rat.",
      "enemy_desc_024": "Extinct Golden Rat.",
      "enemy_desc_025": "Girl hitting elephant。Always soft on women.",
      "enemy_desc_026": "Often fails as he blinded by carrots.",
      "enemy_desc_027": "Sbobby rhino.Too proud of his　horns.",
      "enemy_desc_028": "Good at impoersonating。A Parrot who can impersonate anything.",
      "enemy_desc_029": "Evelved Silver Mammoth.",
      "enemy_desc_030": "Extinct Golden Mammoth.",
      "enemy_desc_031": "Tends to make things black and white.Having scaring eyes.",
      "enemy_desc_032": "Blow off even trees with snort.Powerful　in contrast to his small body.",
      "enemy_desc_033": "Named on its barking sound 'WooHoe'",
      "enemy_desc_034": "A deer grown up in Iga,Japan who dreams about his life in Nara someday.",
      "enemy_desc_035": "Evelved Silver Frog.",
      "enemy_desc_036": "Extinct Golden Frog.",
      "enemy_desc_037": "Often gets cold as he is under water most of a day.",
      "enemy_desc_038": "Rumoured to bring happiness to a person who could see it.Loves cucumbar.",
      "enemy_desc_039": "He hates to be mixed-up with a lesser-panda.",
      "enemy_desc_040": "Extremely dangerous.Calm down and get back slowly when you meet him.",
      "enemy_desc_041": "Evoluted　Silver OX.",
      "enemy_desc_042": "Extinct Golden OX.",
      "enemy_desc_043": "Everyone loves his droopy eyes.The most handsome guy in the oasis.",
      "enemy_desc_044": "A Rere animal that exhausts ice cold air from his own body. He can live in deserts",
      "enemy_desc_045": "Resently he hates to go out.You will rarely see him overground.",
      "enemy_desc_046": "Evolved to having desert mimicry.Moves fast.",
      "enemy_desc_047": "Evelved Silver Bat.",
      "enemy_desc_048": "Extinct Golden Bat.",
      "enemy_desc_049": "Loves acorns.Sometimes his mouth full of acorns even makes him fall down.",
      "enemy_desc_050": "Ordinary animal.Suit　for hunting beginners",
      "enemy_desc_051": "Much groumet animal who only eats Lycaeu leaves.",
      "enemy_desc_052": "A sharman animal who can syncronize with the great earth by the power of the tatoos on his face.",
      "enemy_desc_053": "Evelved Silver Cat.",
      "enemy_desc_054": "Extinct Golden Cat.",
      "enemy_desc_055": "A guard of Satan's farm. Admired by his people.",
      "enemy_desc_056": "A enployee of the Satan's farm.Works　hard",
      "enemy_desc_057": "A walkabout who is always walking about Satan's farm.",
      "enemy_desc_058": "Watering Satan's farm is his job.",
      "enemy_desc_059": "Evelved Silver Dog.",
      "enemy_desc_060": "Extinct Golden Dog.",
      "bait_set_confirm_message": "Deploying '%s'.\nAre you sure？",
      "bait_name_001": "Bone of...",
      "bait_name_002": "Plain Riceball",
      "bait_name_003": "Huicy Meat",
      "bait_name_004": "Capricious Hamburg",
      "bait_name_005": "Stamina Dumplings",
      "bait_name_006": "Magical Petfoods",
      "bait_name_007": "Miracle Drink",
      "bait_name_008": "Misterious Meat Bun",
      "bait_name_009": "Lost Harb Steak",
      "bait_name_010": "Special Melty Cheese",
      "bait_name_011": "Whole　Acorn　Pizza",
      "bait_name_012": "Goddess　Hotdog",
      "bait_name_013": "Devil's Meat Pie",
      "bait_name_014": "Wise Man's BBQ",
      "bait_name_015": "Rainbow Terrine",
      "bait_name_016": "Miracle Sandwitch",
      "bait_name_017": "Furry Omulet",
      "bait_name_018": "Cold Served Pasta",
      "bait_name_019": "Energy Charging Curry",
      "bait_name_020": "Noodle de la Aqua Angelas",
      "bait_desc_001": "Hiyolein's favorite.Much of Amino Acid and Calcium",
      "bait_desc_002": "Piyomoiselle weeps at the recalling taste of her home.",
      "bait_desc_003": "Fabulicious fat you taste as you bite.The Irrestibles to GrrNell.",
      "bait_desc_004": "Never tastes the same.Gooneston likes them because he can be easily bored.",
      "bait_desc_005": "Pigool runs hundred miles as he eat this.",
      "bait_desc_006": "Actually not magical.Nothing's special other than feeding for Piganthes.",
      "bait_desc_007": "This drink gives extraordinaly power. Nezrun hustles on it.",
      "bait_desc_008": "Recipe will never disclosed.Nezmix is fond of it.",
      "bait_desc_009": "The scent of the lost harb atracts BurBur.",
      "bait_desc_010": "Uscheking can't resist　drooling　over the melting cheese.",
      "bait_desc_011": "Big Pizza that tastes great for BurGecko.",
      "bait_desc_012": "Even the Goddes envy its　yumminess.MegaGecko loves it.",
      "bait_desc_013": "BurBur can be brouhgt to heaven byists evil taste",
      "bait_desc_014": "Wise man said 'Only fools BBQ.'.But he loves BBQ now.",
      "bait_desc_015": "Shining gorgious plates makes ShilVat　smack her lips ",
      "bait_desc_016": "It is maraclly yammy regardless how rough they cook it.",
      "bait_desc_017": "Best for breakfast.Freah cream makes difference.",
      "bait_desc_019": "Just a bite of it can evoke alpha waves in your brain.Bowow's breakfast.",
      "bait_desc_020": "Old fashoned soy sause soup noole.",
      "game_standby_time": "Waiting　Time",
      "game_return_message": "Hunt finished",
      "game_button_stop": "Break up your hunting？",
      "game_button_timer_success": "Use a Magical Timer to cut your waiting time？",
      "game_button_timer_error": "You have no Timer",
      "game_set_bait_error": "You have no bait",
      "game_enemy_get_message": "'%s' Get!",
      "shop_name_001": "Animal Dictionary",
      "shop_name_002": "Aloma del Actinidia",
      "shop_name_003": "Nut of Enchantment",
      "shop_name_004": "Lucky Clobar",
      "shop_name_005": "Bait",
      "shop_name_006": "Magical Timer",
      "shop_desc_001": "Gains your monster knowledge by %d.You will see more rare Monsters.",
      "shop_desc_002": "Improves bait accuracy by %d.You wont lose rare animal.",
      "shop_desc_003": "Raises your attractiveness by %d.Animal comes more frequently.",
      "shop_desc_004": "Raises your luck by %d.Animals will bring more items.",
      "shop_desc_005": "You can deploy one more bait。\n(Available after next game)",
      "shop_desc_006": "Magical Timer that reduces your waiting time.",
      "alert_open_new_stage": "New stage is open now!",
      "alert_get_gem": "You've got a gem!",
      "alert_level_up": "Level up！(All Params +2)"
    },
    "ja": {
      "now_loading": "よみこみちゅう…",
      "stage_name_001": "ホクホクおいもガーデン",
      "stage_name_002": "グッネストンのさわやか高原",
      "stage_name_003": "にんじん畑へのけものみち",
      "stage_name_004": "ガンマンのコーヤコーヤ",
      "stage_name_005": "雲の上のファンタジー畑",
      "stage_name_006": "忍びが通る竹ばやし",
      "stage_name_007": "ひえひえアイスの小庭",
      "stage_name_008": "灼熱のサボテン砂漠",
      "stage_name_009": "ゴーストの森のけものみち",
      "stage_name_010": "魔王のミラクル畑",
      "stage_desc_001": "おいもを狙う動物達をどんどんハントしよう！",
      "stage_desc_002": "手下達もよく遊びにくるグッネストンの高原。",
      "stage_desc_003": "動物達も海水浴にやってくるという海が見える畑。",
      "stage_desc_004": "草一本生えない荒野で生きぬく動物達をハント！",
      "stage_desc_005": "いい匂いの不思議な作物につられた動物達をハント！",
      "stage_desc_006": "薄暗い謎に満ちた小径に忍獣達が集まるらしい。",
      "stage_desc_007": "甘いアイスの香りに誘われた動物達をハントしよう！",
      "stage_desc_008": "乾いた砂漠でサボテンの水分を求めて動物が集まる。",
      "stage_desc_009": "ゴーストに惑わされた動物達が集まる森でハント！",
      "stage_desc_010": "魔王の畑を世話する動物達をハントしよう！",
      "enemy_name_001": "ヒヨーコ",
      "enemy_name_002": "クネール",
      "enemy_name_003": "ピグリン",
      "enemy_name_004": "ネズミン",
      "enemy_name_005": "ヒヨリーヌ",
      "enemy_name_006": "ピヨモワゼル",
      "enemy_name_007": "ガンモース",
      "enemy_name_008": "ミドゲコ",
      "enemy_name_009": "カウカウ",
      "enemy_name_010": "ズバット",
      "enemy_name_011": "グルネール",
      "enemy_name_012": "グッネストン",
      "enemy_name_013": "キリリン",
      "enemy_name_014": "コンタ",
      "enemy_name_015": "オットセイ",
      "enemy_name_016": "ペンペン",
      "enemy_name_017": "ピッグール",
      "enemy_name_018": "ピガンテス",
      "enemy_name_019": "アリゲター",
      "enemy_name_020": "コッコ",
      "enemy_name_021": "ルーパー",
      "enemy_name_022": "ギーヤギ",
      "enemy_name_023": "ネズルン",
      "enemy_name_024": "ネズミックス",
      "enemy_name_025": "エレファン",
      "enemy_name_026": "ウーマ",
      "enemy_name_027": "サイック",
      "enemy_name_028": "オムタン",
      "enemy_name_029": "ギャモース",
      "enemy_name_030": "ギガモース",
      "enemy_name_031": "モノクロタ",
      "enemy_name_032": "ウリボー",
      "enemy_name_033": "ウーヒョ",
      "enemy_name_034": "バンビリーナ",
      "enemy_name_035": "ブルゲコ",
      "enemy_name_036": "メガゲコ",
      "enemy_name_037": "カバゾウ",
      "enemy_name_038": "パパキューリ",
      "enemy_name_039": "ポンタヌ",
      "enemy_name_040": "ツキワグ",
      "enemy_name_041": "ブルブル",
      "enemy_name_042": "ウシキング",
      "enemy_name_043": "ラクダー",
      "enemy_name_044": "シロベー",
      "enemy_name_045": "グラモン",
      "enemy_name_046": "ウキッキ",
      "enemy_name_047": "シルバット",
      "enemy_name_048": "ゴールデンバット",
      "enemy_name_049": "リースン",
      "enemy_name_050": "カカモ",
      "enemy_name_051": "ラッコア",
      "enemy_name_052": "シマシウマ",
      "enemy_name_053": "ニャッコ",
      "enemy_name_054": "ニャリーヌ",
      "enemy_name_055": "ドラリウ",
      "enemy_name_056": "シシマイマイ",
      "enemy_name_057": "ガオガオン",
      "enemy_name_058": "ギュウスイ",
      "enemy_name_059": "バウワウ",
      "enemy_name_060": "ゴウワンコ",
      "enemy_desc_001": "毎日リボンを変えるオシャレさん。まだまだヒヨッコ。",
      "enemy_desc_002": "帽子がチャームポイント。紳士的で、人を驚かさない。",
      "enemy_desc_003": "キレイ好きで気が弱い。鼻息で攻撃してくる。",
      "enemy_desc_004": "動きが俊敏でなかなか捕まえられない。何でも食べる。",
      "enemy_desc_005": "進化した銀のヒヨコ。",
      "enemy_desc_006": "幻の金のヒヨコ。",
      "enemy_desc_007": "寒冷地域でよく見られるふつうのマンモス。寒がり。",
      "enemy_desc_008": "その辺の池や河原など、どこにでもいるカエル。",
      "enemy_desc_009": "いつも寝ているノンビリ屋さん。草が好き。",
      "enemy_desc_010": "光る物が好き。街中にもフラフラやってくるはぐれコウモリ。",
      "enemy_desc_011": "進化した銀のヘビ。",
      "enemy_desc_012": "幻の金のヘビ。",
      "enemy_desc_013": "首を長くしてずっと何かを待っているキリン。",
      "enemy_desc_014": "いたずら好きでよく人を騙している。ドッキリに注意。",
      "enemy_desc_015": "意外と器用でボール裁きが天才的。",
      "enemy_desc_016": "いつか空を飛びたいと思っている夢見がちなペンギン。",
      "enemy_desc_017": "進化した銀のブタ。",
      "enemy_desc_018": "幻の金のブタ。",
      "enemy_desc_019": "去り際の美学にこだわる。シーユーレターアリゲーター。",
      "enemy_desc_020": "なんでもきれいさっぱり忘れる後腐れのないトリ。",
      "enemy_desc_021": "愛くるしい見た目とは裏腹に意外と計算高い。世渡り上手。",
      "enemy_desc_022": "高いところが苦手。よく悲鳴をあげている恐がりなヤギ。",
      "enemy_desc_023": "進化した銀のネズミ。",
      "enemy_desc_024": "幻の金のネズミ。",
      "enemy_desc_025": "すごく軟派なゾウ。いつも鼻の下を伸ばしている。",
      "enemy_desc_026": "人参に目がくらんで度々失敗しているおっちょこちょい。",
      "enemy_desc_027": "ツノが自慢の見栄っ張りなサイ。態度が大きい。",
      "enemy_desc_028": "モノマネ王。なんでも真似する器用なオウム。",
      "enemy_desc_029": "進化した銀のマンモス。",
      "enemy_desc_030": "幻の金のマンモス。",
      "enemy_desc_031": "なんでも白黒つけたい几帳面な性格。目が怖い。",
      "enemy_desc_032": "強力な鼻息で周りの木々をなぎ倒す。小さいけれど力持ち。",
      "enemy_desc_033": "木の上からウヒョウヒョ声をかける習性からこの名がついた。",
      "enemy_desc_034": "いつか奈良に住みたいと憧れる伊賀育ちの野鹿。",
      "enemy_desc_035": "進化した銀のカエル。",
      "enemy_desc_036": "幻の金のカエル。",
      "enemy_desc_037": "一日の大半を水の中で過ごしてよく風邪をひいている。",
      "enemy_desc_038": "見ると幸せになると最近観光客に人気。やはりキューリ好き。",
      "enemy_desc_039": "レッサーパンダと間違われて近頃不機嫌。",
      "enemy_desc_040": "大変危険。見かけたらゆっくりと後ずさりで逃げよう。",
      "enemy_desc_041": "進化した銀のウシ。",
      "enemy_desc_042": "幻の金のウシ。",
      "enemy_desc_043": "たれ目が人気。オアシスいちのイケメン。",
      "enemy_desc_044": "自らが冷気を発するシロクマっぽい珍獣。砂漠でも生息可。",
      "enemy_desc_045": "最近は地中に引きこもりがち。外に出るのは珍しい。",
      "enemy_desc_046": "砂漠に同化するよう進化したサル。すばしっこい。",
      "enemy_desc_047": "進化した銀のコウモリ。",
      "enemy_desc_048": "幻の金のコウモリ。",
      "enemy_desc_049": "ドングリが大の好物。口にため過ぎてよく転んでしまう。",
      "enemy_desc_050": "どこにでも普通の動物。ハンター初心者向け。",
      "enemy_desc_051": "ゴーストの森のリカユーの葉しか食べないグルメな珍獣。",
      "enemy_desc_052": "顔に施した入れ墨で大地の精霊と一体化するシャーマン。",
      "enemy_desc_053": "進化した銀のネコ。",
      "enemy_desc_054": "幻の金のネコ。",
      "enemy_desc_055": "魔王の畑を守る門番的存在。部下の信頼も厚い。",
      "enemy_desc_056": "魔王の畑作業をまかされた働きもの。",
      "enemy_desc_057": "魔王の畑をふらふら散歩する近所のおっさん的存在。",
      "enemy_desc_058": "魔王の畑作業の水やりをまかされた働きもの。",
      "enemy_desc_059": "進化した銀のイヌ。",
      "enemy_desc_060": "幻の金のイヌ。",
      "bait_set_confirm_message": "「%s」を配置します。\nよろしいですか？",
      "bait_name_001": "何かの骨",
      "bait_name_002": "素朴なおにぎり",
      "bait_name_003": "ジューシーなお肉",
      "bait_name_004": "気まぐれハンバーグ",
      "bait_name_005": "スタミナお団子",
      "bait_name_006": "魔法のペットフード",
      "bait_name_007": "ミラクルドリンク",
      "bait_name_008": "ナゾ肉まん",
      "bait_name_009": "幻ハーブのステーキ",
      "bait_name_010": "特製とろ〜りチーズ",
      "bait_name_011": "ドングリの丸ごとピザ",
      "bait_name_012": "女神のホットドッグ",
      "bait_name_013": "デビルズミートパイ",
      "bait_name_014": "賢者の串焼き",
      "bait_name_015": "レインボーテリーヌ",
      "bait_name_016": "奇跡のサンドイッチ",
      "bait_name_017": "ふわふわオムレツ",
      "bait_name_018": "さっぱり冷製パスタ",
      "bait_name_019": "癒しのチャージカレー",
      "bait_name_020": "天使のアクアラーメン",
      "bait_desc_001": "ヒヨリーヌの好物。旨味成分カルシュウム。",
      "bait_desc_002": "お袋の味にピヨモワゼルもたまらず涙。",
      "bait_desc_003": "噛むほどに染み出す魅惑の脂。",
      "bait_desc_004": "いつも味が違うので飽きっぽい人にぴったり。",
      "bait_desc_005": "これを食べたピッグールは千里を駆ける！",
      "bait_desc_006": "種も仕掛けもない、何の変哲もないただの餌。",
      "bait_desc_007": "飲むと急激に元気が出る妙なドリンク。",
      "bait_desc_008": "絶対に材料を明かせない謎の肉まん。",
      "bait_desc_009": "貴重なハーブがギャモースを引き寄せる。",
      "bait_desc_010": "チーズの魅惑にギガモースもヨダレたら～り。",
      "bait_desc_011": "ブルゲコも思わず舌鼓を打つ、豪快ピザ。",
      "bait_desc_012": "美味しさに女神も嫉妬！メガゲコの大好物。",
      "bait_desc_013": "ブルブルが天まで登る悪魔的旨さのパイ。",
      "bait_desc_014": "インドア派の賢者が珍しくBBQに参加！",
      "bait_desc_015": "輝くオシャレ料理にシルバットが舌鼓！",
      "bait_desc_016": "適当に作っても奇跡的にいつもうまい！",
      "bait_desc_017": "生クリームを入れるのがポイント！朝ご飯に。",
      "bait_desc_018": "酸味がきいてランチ女子会にとくにおススメ。",
      "bait_desc_019": "一口でアルファ波が出るバウワウのご飯。",
      "bait_desc_020": "昔ながらのしょうゆラーメン。",
      "game_standby_time": "待機時間",
      "game_return_message": "待機完了しました",
      "game_button_stop": "待機を中止しますか？",
      "game_button_timer_success": "タイマーを消費して待機スキップします。\nよろしいですか？",
      "game_button_timer_error": "タイマーを所持していません。",
      "game_set_bait_error": "えさを所持していません。",
      "game_enemy_get_message": "「%s」ゲット!",
      "shop_name_001": "動物辞典",
      "shop_name_002": "マタタビアロマ",
      "shop_name_003": "魅力の木の実",
      "shop_name_004": "ラッキークローバー",
      "shop_name_005": "ワナ",
      "shop_name_006": "タイマー",
      "shop_desc_001": "知識が%dアップ。レアな動物が集まりやすくなる。",
      "shop_desc_002": "ワナの精度が%dアップ。動物が捕まえやすくなる。",
      "shop_desc_003": "魅力が%dアップ。動物が早く集まってくるようになる。",
      "shop_desc_004": "獲得力が%dアップ。動物から採れるアイテムが増える。",
      "shop_desc_005": "ワナの設置数が1アップ。\n(次回ターンから増加)",
      "shop_desc_006": "待機時間をスキップできる魔法アイテム。",
      "alert_open_new_stage": "新しいステージが開放されました。",
      "alert_get_gem": "GEMをゲットしました。",
      "alert_level_up": "レベルが上がった！(全パラメータ+%d)"
    }
  };

  Config = {
    APP_VERSION: '1.0.0',
    FPS: 30,
    TRACK_ID: 'KKPXTRFYD399B8DYJGVS',
    IMAGE_DIR: 'assets/images/',
    SOUND_DIR: Env.IS_FIREFOX ? 'assets_firefox/sounds/' : 'assets/sounds/',
    SCENES: {
      "title": "TitleScene",
      "game": "GameScene"
    },
    MODAL_SCENES: {
      "book": "BookScene",
      "map": "MapScene",
      "shop": "ShopScene",
      "tutorial": "TutorialScene",
      "bait": "BaitScene"
    },
    HELP_IMAGES: ["help_001", "help_002", "help_003", "help_004"],
    STATUS_UP_CYCLE_ITEM: 5,
    STATUS_UP_CYCLE_LEVEL: 5
  };

  Function.prototype.define = function(prop, desc) {
    return Object.defineProperty(this.prototype, prop, desc);
  };

  if (!(Env != null ? Env.IS_DEBUG : void 0)) {
    for (key in console) {
      val = console[key];
      console[key] = function() {};
    }
  }


  /**
  * 名前空間実装
  * @param {String} カンマ区切りのパッケージ文字列
  * @param {Function} クラス内包の無名関数
   */

  namespace = function(namespace, fn) {
    var here, klass, token, tokens, _i, _len;
    klass = fn();
    tokens = namespace.split('.');
    here = this;
    for (_i = 0, _len = tokens.length; _i < _len; _i++) {
      token = tokens[_i];
      if (here[token] == null) {
        here[token] = {};
      }
      here = here[token];
    }
    return here[klass.name] = klass;
  };


  /**
  * i18n実装
  * @param {String} 取得文字のキー
  * @param {String} 説明
   */

  __ = function(key, summary) {
    var lang;
    if (summary == null) {
      summary = "";
    }
    lang = Env.LANG;
    if (lang in Lang) {
      if (key in Lang[lang]) {
        return Lang[lang][key];
      }
    }
    return key;
  };


  /**
  * コンストラクタに可変引数の受け渡しをする
  * @param {Function} クラス
  * @param {Array} 引数の配列
  * @return {Any} 与えられたクラスのインスタンス
   */

  construct = function(constructor, args) {
    var F;
    F = function() {
      return constructor.apply(this, args);
    };
    F.prototype = constructor.prototype;
    return new F();
  };


  /**
  * 2次元配列からLoadQueueのマニフェスト配列を作成
  * @param {Array} 2次元配列
  * @return {Array} マニフェスト配列
   */

  makeAssets = function(list) {
    var count, i, item, key_ed, key_st, maked_list, match_key, match_val, re, val_ed, val_st, _i, _j, _k, _len, _len1;
    maked_list = [];
    re = /{(%[0-9]*d)\|([0-9]+)\|([0-9]+)}/i;
    for (_i = 0, _len = list.length; _i < _len; _i++) {
      item = list[_i];
      match_key = item[0].match(re);
      match_val = item[1].match(re);
      if (match_key && match_val) {
        key_st = parseInt(match_key[2], 10);
        key_ed = parseInt(match_key[3], 10);
        val_st = parseInt(match_val[2], 10);
        val_ed = parseInt(match_val[3], 10);
        count = Math.max(Math.min(key_ed - key_st, val_ed - val_st), 0);
        for (i = _j = 0; 0 <= count ? _j <= count : _j >= count; i = 0 <= count ? ++_j : --_j) {
          key = item[0].replace(re, _.str.sprintf(match_key[1], key_st + i));
          val = item[1].replace(re, _.str.sprintf(match_val[1], val_st + i));
          maked_list.push({
            id: key,
            src: getRetinaPath(val)
          });
        }
      } else {
        maked_list.push({
          id: item[0],
          src: getRetinaPath(item[1])
        });
      }
    }
    if (Env.IS_FIREFOX) {
      for (_k = 0, _len1 = maked_list.length; _k < _len1; _k++) {
        item = maked_list[_k];
        if (item.src.match(/.+\.mp3$/)) {
          item.src = item.src.replace(/\.mp3$/, ".ogg");
        }
      }
    }
    return maked_list;
  };


  /**
  * マニフェスト配列内から特定のidのsrc値を取得
  * @param {String} 固有ID
  * @param {Array} マニフェスト配列
  * @return {String|null} src値
   */

  getAssetPathById = function(id, assets) {
    var asset, _i, _len;
    for (_i = 0, _len = assets.length; _i < _len; _i++) {
      asset = assets[_i];
      if (asset.id === id) {
        return asset.src;
      }
    }
    return null;
  };


  /**
  * マニフェスト配列からsrc配列を取得
  * @param {Array} マニフェスト配列
  * @return {Array} src配列
   */

  getAssetPaths = function(assets) {
    var asset;
    return (function() {
      var _i, _len, _results;
      _results = [];
      for (_i = 0, _len = assets.length; _i < _len; _i++) {
        asset = assets[_i];
        _results.push(asset.src);
      }
      return _results;
    })();
  };


  /**
  * Retinaの場合、画像を対応パスに切り替える
  * @param {String} 画像パス
  * @return {String} 環境に対応した画像パス
   */

  getRetinaPath = function(path) {
    if (Env.IS_RETINA) {
      path = path.replace(/(.+)\.(png|jpe?g|gif)$/, "$1@2x.$2");
    }
    return path;
  };


  /**
  * ピクセル比を取得する
  * @return {Number} 環境のピクセル比
   */

  getPixelRate = function() {
    if (Env.IS_RETINA) {
      return 2;
    }
    return 1;
  };


  /**
  * 表示ピクセル数値を取得する
  * @param {Number} 基準のピクセル値
  * @return {Number} 表示ピクセル値
   */

  dp = function(base_pixcel) {
    if (base_pixcel == null) {
      base_pixcel = 1;
    }
    return base_pixcel * getPixelRate();
  };


  /**
  * 遅延実行
  * @param {Number} 遅延時間(ミリ秒)
  * @param {Function} 実行関数
  * @return {Number} Timer ID
   */

  delay = function(ms, func) {
    return setTimeout(func, ms);
  };


  /**
  * SE再生エイリアス
  * @param {String} アイテムキー
  * @param {String} 名前空間
   */

  sePlay = function(id, ns) {
    if (ns == null) {
      ns = "global";
    }
    audio.SoundEffectManager.play(id, ns);
  };

  Asset = {
    "global": [["dialogue_ok_btn", Config.IMAGE_DIR + "game/dialogue_ok_btn.png"], ["dialogue_ng_btn", Config.IMAGE_DIR + "game/dialogue_ng_btn.png"], ["button_close", Config.IMAGE_DIR + "common/button_close.png"], ["button_close_on", Config.IMAGE_DIR + "common/button_close_on.png"], ["icon_key", Config.IMAGE_DIR + "common/icon_key.png"], ["icon_new", Config.IMAGE_DIR + "common/icon_new.png"], ["modal_head", Config.IMAGE_DIR + "common/head_base.jpg"], ["modal_foot", Config.IMAGE_DIR + "common/bottom_base.jpg"], ["modal_base", Config.IMAGE_DIR + "common/modal_base.jpg"], ["modal_image_base", Config.IMAGE_DIR + "common/modal_image_base.png"], ["animal_nodata", Config.IMAGE_DIR + "common/enemy_nodata.png"], ["se_tap", Config.SOUND_DIR + "tap.mp3"], ["se_cut", Config.SOUND_DIR + "cutx5.mp3"]],
    "title": [['start', Config.IMAGE_DIR + "title/start_btn.png"], ['base', Config.IMAGE_DIR + "title/title_base.jpg"]],
    "tutorial": [['title', Config.IMAGE_DIR + "tutorial/help_title.png"], ["help_{%03d|1|4}", Config.IMAGE_DIR + "tutorial/help_{%03d|1|4}.jpg"]],
    "game": [["game_base_{%03d|1|10}", Config.IMAGE_DIR + "game/game_base_{%03d|1|10}.jpg"], ["animal_{%03d|0|60}", Config.IMAGE_DIR + "game/animal_{%03d|0|60}.png"], ['bait_{%03d|1|20}', Config.IMAGE_DIR + "game/bait{%03d|1|20}.png"], ["icon_item_{%03d|1|4}", Config.IMAGE_DIR + "game/icon_item_{%03d|1|4}.png"], ["trap", Config.IMAGE_DIR + "game/trap.png"], ["trapup", Config.IMAGE_DIR + "game/trapup.png"], ["button_start", Config.IMAGE_DIR + "game/button_start.png"], ["button_start_on", Config.IMAGE_DIR + "game/button_start_on.png"], ["button_book", Config.IMAGE_DIR + "game/button_book.png"], ["button_map", Config.IMAGE_DIR + "game/button_map.png"], ["button_shop", Config.IMAGE_DIR + "game/button_shop.png"], ["button_help", Config.IMAGE_DIR + "game/button_help.png"], ["button_bait", Config.IMAGE_DIR + "game/button_bait.png"], ["button_book_on", Config.IMAGE_DIR + "game/button_book_on.png"], ["button_map_on", Config.IMAGE_DIR + "game/button_map_on.png"], ["button_shop_on", Config.IMAGE_DIR + "game/button_shop_on.png"], ["button_help_on", Config.IMAGE_DIR + "game/button_help_on.png"], ["button_bait_on", Config.IMAGE_DIR + "game/button_bait_on.png"], ["status_bar_base", Config.IMAGE_DIR + "game/status_bar_base.png"], ["icon_dngr", Config.IMAGE_DIR + "game/icon_dngr.png"], ["icon_gem", Config.IMAGE_DIR + "game/icon_gem.png"], ["time_base", Config.IMAGE_DIR + "game/time_base.png"], ["button_time_comp", Config.IMAGE_DIR + "game/button_time_comp.png"], ["button_time_comp_on", Config.IMAGE_DIR + "game/button_time_comp_on.png"], ["button_time_stop", Config.IMAGE_DIR + "game/button_time_stop.png"], ["button_time_stop_on", Config.IMAGE_DIR + "game/button_time_stop_on.png"], ['item_{%03d|1|6}', Config.IMAGE_DIR + "shop/item{%03d|1|6}.jpg"], ["rising_sun", Config.IMAGE_DIR + "game/rising_sun.png"], ["complete_card", Config.IMAGE_DIR + "game/complete_card.jpg"]],
    "map": [["title", Config.IMAGE_DIR + "map/map_title.png"], ['map_image_{%03d|1|10}', Config.IMAGE_DIR + "map/map_image_{%03d|1|10}.jpg"]],
    "book": [['title', Config.IMAGE_DIR + "book/book_title.png"], ['book_title_base', Config.IMAGE_DIR + "book/book_title_bg.jpg"], ['icon_gold', Config.IMAGE_DIR + "book/icon_gold.png"], ['icon_silver', Config.IMAGE_DIR + "book/icon_silver.png"], ['btn_left', Config.IMAGE_DIR + "book/book_btn_left.png"], ['btn_right', Config.IMAGE_DIR + "book/book_btn_right.png"], ["animal_{%03d|1|60}", Config.IMAGE_DIR + "game/animal_{%03d|1|60}.png"]],
    "shop": [['shop_title', Config.IMAGE_DIR + "shop/shop_title.png"], ['tab_base', Config.IMAGE_DIR + "shop/tab_base.png"], ['tab_base_on', Config.IMAGE_DIR + "shop/tab_base_on.png"], ['tab_cook', Config.IMAGE_DIR + "shop/tab_cook.png"], ['tab_dngr', Config.IMAGE_DIR + "shop/tab_dngr.png"], ['tab_gem', Config.IMAGE_DIR + "shop/tab_gem.png"], ['button_buy', Config.IMAGE_DIR + "shop/button_buy.png"], ['button_buy_on', Config.IMAGE_DIR + "shop/button_buy_on.png"], ['button_buy_dngr', Config.IMAGE_DIR + "shop/button_buy_dngr.png"], ['button_buy_gem', Config.IMAGE_DIR + "shop/button_buy_gem.png"], ['button_buy_en', Config.IMAGE_DIR + "shop/button_buy_en.png"], ['bait_{%03d|1|20}', Config.IMAGE_DIR + "shop/bait{%03d|1|20}.jpg"], ['item_{%03d|1|6}', Config.IMAGE_DIR + "shop/item{%03d|1|6}.jpg"]],
    "bait": [['title', Config.IMAGE_DIR + "bait/bait_title.png"], ['bait_num_base', Config.IMAGE_DIR + "bait/bait_num_base.png"], ['bait_{%03d|1|20}', Config.IMAGE_DIR + "game/bait{%03d|1|20}.png"], ['map_image_{%03d|1|10}', Config.IMAGE_DIR + "map/map_image_{%03d|1|10}.jpg"]]
  };

  Event = {
    GAME_CENTER_SHOWED: "game_center_showed",
    GAME_CENTER_HIDED: "game_center_hided",
    TABLE_CELL_TAPPED: "table_cell_tapped",
    PLAYER_STATUS_CHANGE: "player_status_change",
    MAP_CHANGE: "map_change",
    ENEMY_SET_BAIT: "enemy_set_bait",
    ENEMY_AMBUSH_START: "enemy_ambush_start",
    ENEMY_AMBUSH_STOP: "enemy_ambush_stop",
    ENEMY_AMBUSH_COMPLETE: "enemy_ambush_complete",
    ENEMY_SET_TRAP: "enemy_set_trap",
    ENEMY_HITED: "enemy_hited",
    ENEMY_ALL_HITED: "enemy_all_hited",
    ENEMY_PRE_CAPTURE: "enemy_pre_captured",
    ENEMY_CAPTURED: "enemy_captured",
    ENEMY_ALL_CAPTURED: "enemy_all_captured",
    LOG_OPEN: "log_open",
    LOG_PAUSE: "log_pause",
    LOG_RESUME: "log_resume",
    LOG_BUTTON_TAP: "log_button_tap",
    LOG_LEVEL_UP: "log_level_up",
    LOG_STAGE_OPEN: "log_stage_open",
    LOG_STAGE_CHANGE: "log_stage_change",
    LOG_BUY_PRODUCTS: "log_buy_products",
    LOG_PAY_PRODUCTS: "log_pay_products",
    LOG_GET_ENEMY: "log_get_enemy",
    LOG_USE_ENEMY: "log_use_enemy",
    LOG_MAKE_BAIT: "log_make_bait",
    LOG_SET_BAIT: "log_set_bait",
    LOG_GAME_STATUS: "log_game_status"
  };

  AssetsManager = (function() {
    AssetsManager._INSTANCE = null;

    AssetsManager.getInstance = function() {
      if (AssetsManager._INSTANCE === null) {
        AssetsManager._INSTANCE = new AssetsManagerSingleton();
      }
      return AssetsManager._INSTANCE;
    };

    function AssetsManager() {
      return;
    }

    return AssetsManager;

  })();

  AssetsManagerSingleton = (function() {
    function AssetsManagerSingleton() {
      this._allCompleteCheckHandler = __bind(this._allCompleteCheckHandler, this);
      this._clipImageOnLoadErrorHandler = __bind(this._clipImageOnLoadErrorHandler, this);
      this._clipImageOnLoadHandler = __bind(this._clipImageOnLoadHandler, this);
      this._hasTag = __bind(this._hasTag, this);
      this._makeClipToTag = __bind(this._makeClipToTag, this);
      this._allLoadCompleteHandler = __bind(this._allLoadCompleteHandler, this);
      this._fileLoadCompleteHandler = __bind(this._fileLoadCompleteHandler, this);
      this.load = __bind(this.load, this);
      this.getTag = __bind(this.getTag, this);
      this.getItem = __bind(this.getItem, this);
      this.init = __bind(this.init, this);
    }

    AssetsManagerSingleton.prototype._resouces = {};

    AssetsManagerSingleton.prototype.init = function(list) {
      this._re = /^(.+)_([0-9]+)x([0-9]+)x([0-9]+)$/;
      this._re_prefix = /^(.+)_{(%[0-9]*d)\|([0-9]+)}$/i;
      for (key in list) {
        val = list[key];
        list[key] = makeAssets(val);
      }
      return this._resouces = list;
    };

    AssetsManagerSingleton.prototype.getItem = function(name, scene_id) {
      var data, _i, _len, _ref4;
      if (scene_id == null) {
        scene_id = "global";
      }
      if (scene_id in this._resouces) {
        _ref4 = this._resouces[scene_id];
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          data = _ref4[_i];
          if (data.id === name) {
            if ("loaded" in data) {
              return data.loaded;
            }
          }
        }
      }
    };

    AssetsManagerSingleton.prototype.getTag = function(name, scene_id) {
      var data, _i, _len, _ref4;
      if (scene_id == null) {
        scene_id = "global";
      }
      if (scene_id in this._resouces) {
        _ref4 = this._resouces[scene_id];
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          data = _ref4[_i];
          if (data.id === name) {
            if ("loaded" in data && "tag" in data.loaded) {
              return data.loaded.tag;
            }
          }
        }
      }
    };

    AssetsManagerSingleton.prototype.load = function(scene_id, callback) {
      var isNative, item, manifest, queue, _i, _len, _ref4;
      if (scene_id in this._resouces) {
        manifest = [];
        isNative = typeof Media !== "undefined" && Media !== null;
        _ref4 = this._resouces[scene_id];
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          item = _ref4[_i];
          if (!("loaded" in item)) {
            item.scene_id = scene_id;
            if (isNative && !!item.src.match(/\.mp3$/)) {
              item.loaded = new Media(item.src, null, null);
            } else {
              manifest.push(item);
            }
          }
        }
        if (manifest.length > 0) {
          queue = new createjs.LoadQueue(false);
          queue.clip_counter = 0;
          queue.all_complete = false;
          queue.callback = callback;
          queue.installPlugin(createjs.Sound);
          queue.addEventListener('complete', this._allLoadCompleteHandler);
          queue.addEventListener("fileload", this._fileLoadCompleteHandler);
          queue.addEventListener('error', (function(_this) {
            return function(e) {
              return console.log("load_error", e.item.src);
            };
          })(this));
          queue.loadManifest(manifest);
          return;
        }
      }
      callback();
    };

    AssetsManagerSingleton.prototype._fileLoadCompleteHandler = function(e) {
      var data, item, _i, _len, _ref4;
      item = e.item;
      _ref4 = this._resouces[item.scene_id];
      for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
        data = _ref4[_i];
        if (data.id === item.id) {
          data.loaded = item;
          this._makeClipToTag(item, e.target);
          return;
        }
      }
    };

    AssetsManagerSingleton.prototype._allLoadCompleteHandler = function(e) {
      var queue;
      queue = e.target;
      queue.all_complete = true;
      this._allCompleteCheckHandler(queue);
    };

    AssetsManagerSingleton.prototype._makeClipToTag = function(item, queue) {
      var clip_img_tag, count, height, i, image_tag, matches, name, number_code, number_start, prefix, prefix_matches, scene_id, sheet, width, _i;
      name = item.id;
      scene_id = item.scene_id;
      image_tag = item.loaded.tag;
      if (matches = name.match(this._re)) {
        prefix = matches[1];
        number_code = "%03d";
        number_start = 1;
        width = dp(parseInt(matches[2], 10));
        height = dp(parseInt(matches[3], 10));
        count = parseInt(matches[4], 10);
        sheet = new createjs.SpriteSheet({
          images: [image_tag],
          frames: {
            width: width,
            height: height,
            count: count
          }
        });
        if (prefix_matches = prefix.match(this._re_prefix)) {
          prefix = prefix_matches[1];
          number_code = prefix_matches[2];
          number_start = parseInt(prefix_matches[3], 10);
        }
        for (i = _i = 0; 0 <= count ? _i < count : _i > count; i = 0 <= count ? ++_i : --_i) {
          key = _.str.sprintf("%s_" + number_code, prefix, i + number_start);
          if (!this._hasTag(key, scene_id)) {
            queue.clip_counter += 1;
            clip_img_tag = createjs.SpriteSheetUtils.extractFrame(sheet, i);
            clip_img_tag.name = key;
            clip_img_tag.width = width;
            clip_img_tag.height = height;
            clip_img_tag.queue = queue;
            clip_img_tag.onload = this._clipImageOnLoadHandler;
            clip_img_tag.onerror = this._clipImageOnLoadErrorHandler;
            this._resouces[scene_id].push({
              id: key,
              loaded: {
                tag: clip_img_tag
              }
            });
          }
        }
      }
      return false;
    };

    AssetsManagerSingleton.prototype._hasTag = function(name, scene_id) {
      var item, _i, _len, _ref4;
      if (scene_id == null) {
        scene_id = "global";
      }
      if (scene_id in this._resouces) {
        _ref4 = this._resouces[scene_id];
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          item = _ref4[_i];
          if (item.id === name && "loaded" in item) {
            return true;
          }
        }
      }
      return false;
    };

    AssetsManagerSingleton.prototype._clipImageOnLoadHandler = function(e) {
      var queue;
      queue = e.target.queue;
      queue.clip_counter -= 1;
      this._allCompleteCheckHandler(queue);
    };

    AssetsManagerSingleton.prototype._clipImageOnLoadErrorHandler = function(e) {
      console.log("load_error", e.target.name);
      this._clipImageOnLoadHandler(e);
    };

    AssetsManagerSingleton.prototype._allCompleteCheckHandler = function(queue) {
      if (queue.all_complete && queue.clip_counter <= 0) {
        queue.callback();
      }
    };

    return AssetsManagerSingleton;

  })();

  if (typeof namespace === "function") {
    namespace("util", function() {
      return AssetsManager;
    });
  }

  EventDispatcher = (function() {
    function EventDispatcher() {}

    EventDispatcher._INSTANCE = null;

    EventDispatcher.getInstance = function() {
      if (EventDispatcher._INSTANCE === null) {
        EventDispatcher._INSTANCE = new EventDispatcherSingleton();
      }
      return EventDispatcher._INSTANCE;
    };

    return EventDispatcher;

  })();

  EventDispatcherSingleton = (function() {
    EventDispatcherSingleton.prototype._events = {};

    function EventDispatcherSingleton() {
      this.dispatchEvent = __bind(this.dispatchEvent, this);
      this.clearAllEventListener = __bind(this.clearAllEventListener, this);
      this.removeEventListener = __bind(this.removeEventListener, this);
      this.addEventListener = __bind(this.addEventListener, this);
      return;
    }

    EventDispatcherSingleton.prototype.addEventListener = function(key, method) {
      var events;
      if (!key) {
        return;
      }
      events = [];
      if (key in this._events) {
        events = this._events[key];
      }
      if (typeof method === 'function') {
        events.push(method);
        this._events[key] = events;
      }
    };

    EventDispatcherSingleton.prototype.removeEventListener = function(key, method) {
      var current_arr, current_method, make_arr, _i, _len;
      if (method == null) {
        method = null;
      }
      if (!key) {
        return;
      }
      if (method === null) {
        delete this._events[key];
      } else if (typeof method === 'function' && key in this._events) {
        make_arr = [];
        current_arr = this._events[key];
        for (_i = 0, _len = current_arr.length; _i < _len; _i++) {
          current_method = current_arr[_i];
          if (current_method !== method) {
            make_arr.push(current_method);
          }
        }
        this._events[key] = make_arr;
      }
    };

    EventDispatcherSingleton.prototype.clearAllEventListener = function() {
      this._events = {};
    };

    EventDispatcherSingleton.prototype.dispatchEvent = function() {
      var args, e, event_arr, event_object, key, _i, _len;
      key = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
      if (!key) {
        return;
      }
      if (key in this._events) {
        event_arr = this._events[key];
        event_object = {
          type: key
        };
        args.unshift(event_object);
        for (_i = 0, _len = event_arr.length; _i < _len; _i++) {
          e = event_arr[_i];
          e.apply(null, args);
        }
      }
    };

    return EventDispatcherSingleton;

  })();

  if (typeof namespace === "function") {
    namespace("util", function() {
      return EventDispatcher;
    });
  }

  BgmManager = (function() {
    function BgmManager() {}

    BgmManager._INSTANCE = null;

    BgmManager.getInstance = function() {
      if (BgmManager._INSTANCE === null) {
        BgmManager._INSTANCE = new BgmManagerSingleton();
      }
      return BgmManager._INSTANCE;
    };

    return BgmManager;

  })();

  BgmManagerSingleton = (function() {
    BgmManagerSingleton.prototype._current_id = "";

    BgmManagerSingleton.prototype._current_ns = "";

    BgmManagerSingleton.prototype._current_bgm = null;

    BgmManagerSingleton.prototype._is_native = false;

    BgmManagerSingleton.prototype._timer = 0;

    BgmManagerSingleton.prototype._current_volume = 0;

    BgmManagerSingleton.prototype._auto_play = false;

    function BgmManagerSingleton() {
      this._setVolume = __bind(this._setVolume, this);
      this._fadeIn = __bind(this._fadeIn, this);
      this._fadeOut = __bind(this._fadeOut, this);
      this._play = __bind(this._play, this);
      this.stop = __bind(this.stop, this);
      this.play = __bind(this.play, this);
      if (typeof Media !== "undefined" && Media !== null) {
        this._is_native = true;
      }
      return;
    }

    BgmManagerSingleton.prototype.play = function(id, ns) {
      if (ns == null) {
        ns = "global";
      }
      if (this._current_id !== id || this._current_ns !== ns) {
        this._current_id = id;
        this._current_ns = ns;
        if (this._current_bgm) {
          this._auto_play = true;
          this._fadeOut();
        } else {
          this._play();
        }
      }
    };

    BgmManagerSingleton.prototype.stop = function() {
      this._auto_play = false;
      this._fadeOut();
    };

    BgmManagerSingleton.prototype._play = function() {
      var manager, tag, _ref4, _ref5;
      if (this._current_id && this._current_ns) {
        this._current_volume = 0;
        manager = util.AssetsManager.getInstance();
        if (this._is_native) {
          this._current_bgm = manager.getItem(this._current_id, this._current_ns);
          if ((_ref4 = this._current_bgm) != null) {
            _ref4.setVolume(this._current_volume.toString());
          }
          if ((_ref5 = this._current_bgm) != null) {
            _ref5.play({
              playAudioWhenScreenIsLocked: false,
              numberOfLoops: 0
            });
          }
        } else {
          tag = manager.getTag(this._current_id, this._current_ns);
          if (tag != null) {
            this._current_bgm = createjs.Sound.createInstance(tag.src);
            this._current_bgm.setVolume(this._current_volume);
            this._current_bgm.play(createjs.Sound.INTERRUPT_NONE, 0, 0, -1);
          }
        }
        this._fadeIn();
      }
    };

    BgmManagerSingleton.prototype._fadeOut = function() {
      clearTimeout(this._timer);
      this._current_volume -= 0.1;
      if (this._current_volume <= 0) {
        this._current_bgm.stop();
        if (this._auto_play) {
          this._play();
        }
      } else {
        this._setVolume(this._current_volume);
        this._timer = delay(100, this._fadeOut);
      }
    };

    BgmManagerSingleton.prototype._fadeIn = function() {
      clearTimeout(this._timer);
      this._current_volume += 0.1;
      if (this._current_volume >= 1) {
        this._current_volume = 1;
        this._setVolume(this._current_volume);
      } else {
        this._setVolume(this._current_volume);
        this._timer = delay(100, this._fadeIn);
      }
    };

    BgmManagerSingleton.prototype._setVolume = function() {
      if (this._is_native) {
        this._current_bgm.setVolume(this._current_volume.toString());
      } else {
        if (this._current_bgm) {
          this._current_bgm.setVolume(this._current_volume);
        }
      }
    };

    return BgmManagerSingleton;

  })();

  namespace('audio', function() {
    return BgmManager;
  });

  SoundEffectManager = (function() {
    SoundEffectManager._TIMER = 0;

    SoundEffectManager._PRE_SOUND = null;

    SoundEffectManager._MEDIAS = {};

    SoundEffectManager._MEDIA_INDEX = {};

    SoundEffectManager._PLAYABLE = true;

    SoundEffectManager._PLAY_LIMIT = 300;

    function SoundEffectManager() {
      return;
    }

    SoundEffectManager.play = function(id, ns) {
      var manager, media, sound, tag;
      if (ns == null) {
        ns = "global";
      }
      manager = util.AssetsManager.getInstance();
      if (typeof Media !== "undefined" && Media !== null) {
        media = manager.getItem(id, ns);
        if (media != null) {
          media.play({
            playAudioWhenScreenIsLocked: false,
            numberOfLoops: 1
          });
        }
      } else {
        tag = manager.getTag(id, ns);
        if (tag != null) {
          sound = createjs.Sound.createInstance(tag.src);
          sound.play(createjs.Sound.INTERRUPT_ANY);
        }
      }
    };

    SoundEffectManager.preScale = function(id, count, ns) {
      var i, manager, origin_media, _base, _base1, _i;
      if (ns == null) {
        ns = "global";
      }
      manager = util.AssetsManager.getInstance();
      if (typeof Media !== "undefined" && Media !== null) {
        if (SoundEffectManager._MEDIAS == null) {
          SoundEffectManager._MEDIAS = {};
        }
        if ((_base = SoundEffectManager._MEDIAS)[ns] == null) {
          _base[ns] = {};
        }
        SoundEffectManager._MEDIAS[ns][id] = [];
        if (SoundEffectManager._MEDIA_INDEX == null) {
          SoundEffectManager._MEDIA_INDEX = {};
        }
        if ((_base1 = SoundEffectManager._MEDIA_INDEX)[ns] == null) {
          _base1[ns] = {};
        }
        SoundEffectManager._MEDIA_INDEX[ns][id] = 0;
        origin_media = manager.getItem(id, ns);
        for (i = _i = 0; 0 <= count ? _i < count : _i > count; i = 0 <= count ? ++_i : --_i) {
          SoundEffectManager._MEDIAS[ns][id].push(new Media(origin_media.src));
        }
      }
    };

    SoundEffectManager.playScale = function(id, offset, limit, ns) {
      var manager, media, sound, tag, _ref4;
      if (offset == null) {
        offset = 0;
      }
      if (limit == null) {
        limit = 0;
      }
      if (ns == null) {
        ns = "global";
      }
      if (!SoundEffectManager._PLAYABLE) {
        return;
      }
      SoundEffectManager._PLAYABLE = false;
      delay(SoundEffectManager._PLAY_LIMIT, (function(_this) {
        return function() {
          SoundEffectManager._PLAYABLE = true;
        };
      })(this));
      manager = util.AssetsManager.getInstance();
      if (typeof Media !== "undefined" && Media !== null) {
        media = SoundEffectManager._MEDIAS[ns][id][SoundEffectManager._MEDIA_INDEX[ns][id]];
        if (media != null) {
          media.stop();
        }
        if (media != null) {
          media.play({
            playAudioWhenScreenIsLocked: false,
            numberOfLoops: 1
          });
        }
        if (media != null) {
          media.seekTo(offset);
        }
        delay(limit, (function(_this) {
          return function() {
            return media != null ? media.stop() : void 0;
          };
        })(this));
        SoundEffectManager._MEDIA_INDEX[ns][id] = ++SoundEffectManager._MEDIA_INDEX[ns][id] % SoundEffectManager._MEDIAS[ns][id].length;
      } else {
        tag = manager.getTag(id, ns);
        if (tag != null) {
          if ((_ref4 = SoundEffectManager._PRE_SOUND) != null) {
            _ref4.stop();
          }
          clearTimeout(SoundEffectManager._TIMER);
          sound = createjs.Sound.createInstance(tag.src);
          sound.play(createjs.Sound.INTERRUPT_ANY, 0, offset);
          SoundEffectManager._TIMER = delay(limit - 100, (function(_this) {
            return function() {
              return sound.stop();
            };
          })(this));
          SoundEffectManager._PRE_SOUND = sound;
        }
      }
    };

    return SoundEffectManager;

  })();

  namespace('audio', function() {
    return SoundEffectManager;
  });

  namespace("data", function() {
    var DataAbstract;
    return DataAbstract = (function() {
      DataAbstract._STORAGE_KEY = "base_data";

      DataAbstract._SAVE_DELAY_TIME = 200;

      DataAbstract.prototype._storage = null;

      DataAbstract.prototype._self = null;

      DataAbstract.prototype._data = null;

      DataAbstract.prototype._data_ids = null;

      DataAbstract.prototype._timer = 0;

      function DataAbstract() {
        this._clearData = __bind(this._clearData, this);
        this._hasData = __bind(this._hasData, this);
        this._getData = __bind(this._getData, this);
        this._setData = __bind(this._setData, this);
        this._saveData = __bind(this._saveData, this);
        this._validNum = __bind(this._validNum, this);
        this.getDataIds = __bind(this.getDataIds, this);
        this.hasId = __bind(this.hasId, this);
        this._storage = typeof window !== "undefined" && window !== null ? window.localStorage : void 0;
        this._self = DataAbstract;
        this._super = DataAbstract;
        return;
      }

      DataAbstract.prototype.hasId = function(id) {
        return this._data_ids && (__indexOf.call(this._data_ids, id) >= 0);
      };

      DataAbstract.prototype.getDataIds = function() {
        return this._data_ids;
      };

      DataAbstract.prototype._validNum = function(num) {
        return Math.floor(isNaN(num) ? 0 : num);
      };

      DataAbstract.prototype._saveData = function(use_delay) {
        if (use_delay == null) {
          use_delay = true;
        }
        clearTimeout(this._timer);
        if (use_delay) {
          this._timer = delay(this._super._SAVE_DELAY_TIME, (function(_this) {
            return function() {
              return _this._setData(_this._data);
            };
          })(this));
        } else {
          this._setData(this._data);
        }
      };

      DataAbstract.prototype._setData = function(data) {
        if (this._storage) {
          this._storage.setItem(this._self._STORAGE_KEY, JSON.stringify(data));
        }
      };

      DataAbstract.prototype._getData = function() {
        if (this._storage) {
          return JSON.parse(this._storage.getItem(this._self._STORAGE_KEY));
        }
        return null;
      };

      DataAbstract.prototype._hasData = function() {
        if (this._storage) {
          if (this._storage.getItem(this._self._STORAGE_KEY)) {
            return true;
          }
        }
        return false;
      };

      DataAbstract.prototype._clearData = function() {
        if (this._storage) {
          this._storage.removeItem(this._self._STORAGE_KEY);
        }
      };

      return DataAbstract;

    })();
  });

  namespace("data", function() {
    var BaitData;
    return BaitData = (function() {
      BaitData._INSTANCE = null;

      BaitData.getInstance = function() {
        if (BaitData._INSTANCE === null) {
          BaitData._INSTANCE = new BaitDataSingleton();
        }
        return BaitData._INSTANCE;
      };

      function BaitData() {
        return;
      }

      BaitData._STORAGE_KEY = "bait_data";

      BaitData._GOLD_BASE = 10;

      BaitData._SPECIAL_GOLD_BASE = 2;

      BaitData._BAIT_DATA = [
        {
          id: 1,
          name: __("bait_name_001"),
          desc: __("bait_desc_001"),
          gold_scale: 1,
          is_sp: false,
          is_new: true,
          cost: [[2, 6], [4, 2]]
        }, {
          id: 2,
          name: __("bait_name_002"),
          desc: __("bait_desc_002"),
          gold_scale: 1,
          is_sp: true,
          is_new: true,
          cost: [[3, 6], [5, 2]]
        }, {
          id: 3,
          name: __("bait_name_003"),
          desc: __("bait_desc_003"),
          gold_scale: 5,
          is_sp: false,
          is_new: true,
          cost: [[8, 6], [6, 2]]
        }, {
          id: 4,
          name: __("bait_name_004"),
          desc: __("bait_desc_004"),
          gold_scale: 2,
          is_sp: true,
          is_new: true,
          cost: [[9, 6], [11, 2]]
        }, {
          id: 5,
          name: __("bait_name_005"),
          desc: __("bait_desc_005"),
          gold_scale: 10,
          is_sp: false,
          is_new: true,
          cost: [[14, 6], [12, 2]]
        }, {
          id: 6,
          name: __("bait_name_006"),
          desc: __("bait_desc_006"),
          gold_scale: 4,
          is_sp: true,
          is_new: true,
          cost: [[15, 6], [17, 2]]
        }, {
          id: 7,
          name: __("bait_name_007"),
          desc: __("bait_desc_007"),
          gold_scale: 20,
          is_sp: false,
          is_new: true,
          cost: [[20, 6], [18, 2]]
        }, {
          id: 8,
          name: __("bait_name_008"),
          desc: __("bait_desc_008"),
          gold_scale: 8,
          is_sp: true,
          is_new: true,
          cost: [[21, 6], [23, 2]]
        }, {
          id: 9,
          name: __("bait_name_009"),
          desc: __("bait_desc_009"),
          gold_scale: 30,
          is_sp: false,
          is_new: true,
          cost: [[26, 6], [24, 2]]
        }, {
          id: 10,
          name: __("bait_name_010"),
          desc: __("bait_desc_010"),
          gold_scale: 16,
          is_sp: true,
          is_new: true,
          cost: [[27, 6], [29, 2]]
        }, {
          id: 11,
          name: __("bait_name_011"),
          desc: __("bait_desc_011"),
          gold_scale: 40,
          is_sp: false,
          is_new: true,
          cost: [[32, 6], [30, 2]]
        }, {
          id: 12,
          name: __("bait_name_012"),
          desc: __("bait_desc_012"),
          gold_scale: 32,
          is_sp: true,
          is_new: true,
          cost: [[33, 6], [35, 2]]
        }, {
          id: 13,
          name: __("bait_name_013"),
          desc: __("bait_desc_013"),
          gold_scale: 60,
          is_sp: false,
          is_new: true,
          cost: [[38, 6], [36, 2]]
        }, {
          id: 14,
          name: __("bait_name_014"),
          desc: __("bait_desc_014"),
          gold_scale: 64,
          is_sp: true,
          is_new: true,
          cost: [[39, 6], [41, 2]]
        }, {
          id: 15,
          name: __("bait_name_015"),
          desc: __("bait_desc_015"),
          gold_scale: 80,
          is_sp: false,
          is_new: true,
          cost: [[44, 6], [42, 2]]
        }, {
          id: 16,
          name: __("bait_name_016"),
          desc: __("bait_desc_016"),
          gold_scale: 128,
          is_sp: true,
          is_new: true,
          cost: [[45, 6], [47, 2]]
        }, {
          id: 17,
          name: __("bait_name_017"),
          desc: __("bait_desc_017"),
          gold_scale: 100,
          is_sp: false,
          is_new: true,
          cost: [[50, 6], [48, 2]]
        }, {
          id: 18,
          name: __("bait_name_018"),
          desc: __("bait_desc_018"),
          gold_scale: 256,
          is_sp: true,
          is_new: true,
          cost: [[51, 6], [53, 2]]
        }, {
          id: 19,
          name: __("bait_name_019"),
          desc: __("bait_desc_019"),
          gold_scale: 200,
          is_sp: false,
          is_new: true,
          cost: [[56, 6], [54, 2]]
        }, {
          id: 20,
          name: __("bait_name_020"),
          desc: __("bait_desc_020"),
          gold_scale: 512,
          is_sp: true,
          is_new: true,
          cost: [[57, 6], [59, 2]]
        }
      ];

      BaitData._BAIT_DATA_DEFAULT = {};

      return BaitData;

    })();
  });

  BaitDataSingleton = (function(_super) {
    __extends(BaitDataSingleton, _super);

    function BaitDataSingleton() {
      this._isNewById = __bind(this._isNewById, this);
      this._setIsNewById = __bind(this._setIsNewById, this);
      this._getTotalCountById = __bind(this._getTotalCountById, this);
      this._setTotalCountById = __bind(this._setTotalCountById, this);
      this._getCountById = __bind(this._getCountById, this);
      this._setCountById = __bind(this._setCountById, this);
      this.clearIsNewById = __bind(this.clearIsNewById, this);
      this.payCountById = __bind(this.payCountById, this);
      this.addCountById = __bind(this.addCountById, this);
      this.getBaits = __bind(this.getBaits, this);
      this.getBaitById = __bind(this.getBaitById, this);
      this.getBaitLength = __bind(this.getBaitLength, this);
      var bait_data;
      BaitDataSingleton.__super__.constructor.call(this);
      this._self = data.BaitData;
      if (Env.IS_DEBUG) {
        this._clearData();
      }
      if (!this._hasData()) {
        this._setData(this._self._BAIT_DATA_DEFAULT);
      }
      this._bait_data = this._self._BAIT_DATA;
      this._data_ids = (function() {
        var _i, _len, _ref4, _results;
        _ref4 = this._bait_data;
        _results = [];
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          bait_data = _ref4[_i];
          _results.push(bait_data.id);
        }
        return _results;
      }).call(this);
      this._data = this._getData();
      return;
    }

    BaitDataSingleton.prototype.getBaitLength = function() {
      return this._bait_data.length;
    };

    BaitDataSingleton.prototype.getBaitById = function(id) {
      var isnew, item, _i, _len, _ref4;
      _ref4 = this._bait_data;
      for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
        item = _ref4[_i];
        if (item.id === id) {
          item.count = this._getCountById(id);
          item.total_count = this._getTotalCountById(id);
          if (item.is_sp) {
            item.gold = Math.floor(this._self._SPECIAL_GOLD_BASE * item.gold_scale);
          } else {
            item.gold = Math.floor(this._self._GOLD_BASE * item.gold_scale);
          }
          isnew = this._isNewById(id);
          if (isnew !== null) {
            item.is_new = isnew;
          }
          return item;
        }
      }
      return null;
    };

    BaitDataSingleton.prototype.getBaits = function() {
      var item;
      return (function() {
        var _i, _len, _ref4, _results;
        _ref4 = this._bait_data;
        _results = [];
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          item = _ref4[_i];
          _results.push(this.getBaitById(item.id));
        }
        return _results;
      }).call(this);
    };

    BaitDataSingleton.prototype.addCountById = function(id, add_count) {
      var item, _i, _len, _ref4;
      if (add_count == null) {
        add_count = 1;
      }
      add_count = this._validNum(add_count);
      _ref4 = this._bait_data;
      for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
        item = _ref4[_i];
        if (item.id === id) {
          this._setCountById(id, this._getCountById(id) + add_count);
          this._setTotalCountById(id, this._getTotalCountById(id) + add_count);
          plugin.Flurry.getInstance().logEventWithParameters(Event.LOG_MAKE_BAIT, {
            bait_id: id,
            count: add_count
          });
          break;
        }
      }
    };

    BaitDataSingleton.prototype.payCountById = function(id, pay_count) {
      var bait;
      if (pay_count == null) {
        pay_count = 0;
      }
      pay_count = Math.max(this._validNum(pay_count), 0);
      bait = this.getBaitById(id);
      if (bait && pay_count <= bait.count) {
        this._setCountById(id, bait.count - pay_count);
        plugin.Flurry.getInstance().logEventWithParameters(Event.LOG_SET_BAIT, {
          bait_id: id,
          count: pay_count
        });
        return true;
      }
      return false;
    };

    BaitDataSingleton.prototype.clearIsNewById = function(id) {
      this._setIsNewById(id);
    };

    BaitDataSingleton.prototype._setCountById = function(id, count) {
      this._data["count_" + id] = count;
      this._saveData();
    };

    BaitDataSingleton.prototype._getCountById = function(id) {
      if (this._data && ("count_" + id) in this._data) {
        return this._data["count_" + id];
      }
      return 0;
    };

    BaitDataSingleton.prototype._setTotalCountById = function(id, count) {
      this._data["total_count_" + id] = count;
      this._saveData();
    };

    BaitDataSingleton.prototype._getTotalCountById = function(id) {
      if (this._data && ("total_count_" + id) in this._data) {
        return this._data["total_count_" + id];
      }
      return 0;
    };

    BaitDataSingleton.prototype._setIsNewById = function(id, flag) {
      if (flag == null) {
        flag = false;
      }
      this._data["isnew_" + id] = flag;
      this._saveData();
    };

    BaitDataSingleton.prototype._isNewById = function(id) {
      if (this._data && ("isnew_" + id) in this._data) {
        return this._data["isnew_" + id];
      }
      return null;
    };

    return BaitDataSingleton;

  })(data.DataAbstract);

  namespace("data", function() {
    var EnemyData;
    return EnemyData = (function() {
      EnemyData._INSTANCE = null;

      EnemyData.getInstance = function() {
        if (EnemyData._INSTANCE === null) {
          EnemyData._INSTANCE = new EnemyDataSingleton();
        }
        return EnemyData._INSTANCE;
      };

      function EnemyData() {
        return;
      }

      EnemyData._STORAGE_KEY = "enemy_data";

      EnemyData._ENEMY_DATA = [
        {
          id: 1,
          name: __("enemy_name_001"),
          desc: __("enemy_desc_001"),
          gold: 1,
          gold_sp: 0,
          prob: 0,
          bait: 0,
          group: 1
        }, {
          id: 2,
          name: __("enemy_name_002"),
          desc: __("enemy_desc_002"),
          gold: 2,
          gold_sp: 0,
          prob: 1,
          bait: 0,
          group: 1
        }, {
          id: 3,
          name: __("enemy_name_003"),
          desc: __("enemy_desc_003"),
          gold: 2,
          gold_sp: 0,
          prob: 3,
          bait: 0,
          group: 1
        }, {
          id: 4,
          name: __("enemy_name_004"),
          desc: __("enemy_desc_004"),
          gold: 2,
          gold_sp: 0,
          prob: 5,
          bait: 0,
          group: 1
        }, {
          id: 5,
          name: __("enemy_name_005"),
          desc: __("enemy_desc_005"),
          gold: 3,
          gold_sp: 1,
          prob: 4,
          bait: 1,
          group: 1
        }, {
          id: 6,
          name: __("enemy_name_006"),
          desc: __("enemy_desc_006"),
          gold: 5,
          gold_sp: 0,
          prob: 4,
          bait: 2,
          group: 1
        }, {
          id: 7,
          name: __("enemy_name_007"),
          desc: __("enemy_desc_007"),
          gold: 2,
          gold_sp: 0,
          prob: 0,
          bait: 0,
          group: 2
        }, {
          id: 8,
          name: __("enemy_name_008"),
          desc: __("enemy_desc_008"),
          gold: 3,
          gold_sp: 0,
          prob: 1,
          bait: 0,
          group: 2
        }, {
          id: 9,
          name: __("enemy_name_009"),
          desc: __("enemy_desc_009"),
          gold: 3,
          gold_sp: 0,
          prob: 3,
          bait: 0,
          group: 2
        }, {
          id: 10,
          name: __("enemy_name_010"),
          desc: __("enemy_desc_010"),
          gold: 3,
          gold_sp: 0,
          prob: 5,
          bait: 0,
          group: 2
        }, {
          id: 11,
          name: __("enemy_name_011"),
          desc: __("enemy_desc_011"),
          gold: 5,
          gold_sp: 3,
          prob: 4,
          bait: 3,
          group: 2
        }, {
          id: 12,
          name: __("enemy_name_012"),
          desc: __("enemy_desc_012"),
          gold: 10,
          gold_sp: 0,
          prob: 4,
          bait: 4,
          group: 2
        }, {
          id: 13,
          name: __("enemy_name_013"),
          desc: __("enemy_desc_013"),
          gold: 4,
          gold_sp: 0,
          prob: 0,
          bait: 0,
          group: 3
        }, {
          id: 14,
          name: __("enemy_name_014"),
          desc: __("enemy_desc_014"),
          gold: 5,
          gold_sp: 0,
          prob: 1,
          bait: 0,
          group: 3
        }, {
          id: 15,
          name: __("enemy_name_015"),
          desc: __("enemy_desc_015"),
          gold: 5,
          gold_sp: 0,
          prob: 3,
          bait: 0,
          group: 3
        }, {
          id: 16,
          name: __("enemy_name_016"),
          desc: __("enemy_desc_016"),
          gold: 5,
          gold_sp: 0,
          prob: 5,
          bait: 0,
          group: 3
        }, {
          id: 17,
          name: __("enemy_name_017"),
          desc: __("enemy_desc_017"),
          gold: 7,
          gold_sp: 5,
          prob: 4,
          bait: 5,
          group: 3
        }, {
          id: 18,
          name: __("enemy_name_018"),
          desc: __("enemy_desc_018"),
          gold: 15,
          gold_sp: 0,
          prob: 4,
          bait: 6,
          group: 3
        }, {
          id: 19,
          name: __("enemy_name_019"),
          desc: __("enemy_desc_019"),
          gold: 5,
          gold_sp: 0,
          prob: 0,
          bait: 0,
          group: 4
        }, {
          id: 20,
          name: __("enemy_name_020"),
          desc: __("enemy_desc_020"),
          gold: 6,
          gold_sp: 0,
          prob: 1,
          bait: 0,
          group: 4
        }, {
          id: 21,
          name: __("enemy_name_021"),
          desc: __("enemy_desc_021"),
          gold: 6,
          gold_sp: 0,
          prob: 3,
          bait: 0,
          group: 4
        }, {
          id: 22,
          name: __("enemy_name_022"),
          desc: __("enemy_desc_022"),
          gold: 6,
          gold_sp: 0,
          prob: 5,
          bait: 0,
          group: 4
        }, {
          id: 23,
          name: __("enemy_name_023"),
          desc: __("enemy_desc_023"),
          gold: 9,
          gold_sp: 10,
          prob: 4,
          bait: 7,
          group: 4
        }, {
          id: 24,
          name: __("enemy_name_024"),
          desc: __("enemy_desc_024"),
          gold: 20,
          gold_sp: 0,
          prob: 4,
          bait: 8,
          group: 4
        }, {
          id: 25,
          name: __("enemy_name_025"),
          desc: __("enemy_desc_025"),
          gold: 6,
          gold_sp: 0,
          prob: 0,
          bait: 0,
          group: 5
        }, {
          id: 26,
          name: __("enemy_name_026"),
          desc: __("enemy_desc_026"),
          gold: 7,
          gold_sp: 0,
          prob: 1,
          bait: 0,
          group: 5
        }, {
          id: 27,
          name: __("enemy_name_027"),
          desc: __("enemy_desc_027"),
          gold: 7,
          gold_sp: 0,
          prob: 3,
          bait: 0,
          group: 5
        }, {
          id: 28,
          name: __("enemy_name_028"),
          desc: __("enemy_desc_028"),
          gold: 7,
          gold_sp: 0,
          prob: 5,
          bait: 0,
          group: 5
        }, {
          id: 29,
          name: __("enemy_name_029"),
          desc: __("enemy_desc_029"),
          gold: 10,
          gold_sp: 15,
          prob: 4,
          bait: 9,
          group: 5
        }, {
          id: 30,
          name: __("enemy_name_030"),
          desc: __("enemy_desc_030"),
          gold: 25,
          gold_sp: 0,
          prob: 4,
          bait: 10,
          group: 5
        }, {
          id: 31,
          name: __("enemy_name_031"),
          desc: __("enemy_desc_031"),
          gold: 7,
          gold_sp: 0,
          prob: 0,
          bait: 0,
          group: 6
        }, {
          id: 32,
          name: __("enemy_name_032"),
          desc: __("enemy_desc_032"),
          gold: 8,
          gold_sp: 0,
          prob: 1,
          bait: 0,
          group: 6
        }, {
          id: 33,
          name: __("enemy_name_033"),
          desc: __("enemy_desc_033"),
          gold: 8,
          gold_sp: 0,
          prob: 3,
          bait: 0,
          group: 6
        }, {
          id: 34,
          name: __("enemy_name_034"),
          desc: __("enemy_desc_034"),
          gold: 8,
          gold_sp: 0,
          prob: 5,
          bait: 0,
          group: 6
        }, {
          id: 35,
          name: __("enemy_name_035"),
          desc: __("enemy_desc_035"),
          gold: 15,
          gold_sp: 20,
          prob: 4,
          bait: 11,
          group: 6
        }, {
          id: 36,
          name: __("enemy_name_036"),
          desc: __("enemy_desc_036"),
          gold: 30,
          gold_sp: 0,
          prob: 4,
          bait: 12,
          group: 6
        }, {
          id: 37,
          name: __("enemy_name_037"),
          desc: __("enemy_desc_037"),
          gold: 8,
          gold_sp: 0,
          prob: 0,
          bait: 0,
          group: 7
        }, {
          id: 38,
          name: __("enemy_name_038"),
          desc: __("enemy_desc_038"),
          gold: 9,
          gold_sp: 0,
          prob: 1,
          bait: 0,
          group: 7
        }, {
          id: 39,
          name: __("enemy_name_039"),
          desc: __("enemy_desc_039"),
          gold: 9,
          gold_sp: 0,
          prob: 3,
          bait: 0,
          group: 7
        }, {
          id: 40,
          name: __("enemy_name_040"),
          desc: __("enemy_desc_040"),
          gold: 9,
          gold_sp: 0,
          prob: 5,
          bait: 0,
          group: 7
        }, {
          id: 41,
          name: __("enemy_name_041"),
          desc: __("enemy_desc_041"),
          gold: 20,
          gold_sp: 25,
          prob: 4,
          bait: 13,
          group: 7
        }, {
          id: 42,
          name: __("enemy_name_042"),
          desc: __("enemy_desc_042"),
          gold: 35,
          gold_sp: 0,
          prob: 4,
          bait: 14,
          group: 7
        }, {
          id: 43,
          name: __("enemy_name_043"),
          desc: __("enemy_desc_043"),
          gold: 9,
          gold_sp: 0,
          prob: 0,
          bait: 0,
          group: 8
        }, {
          id: 44,
          name: __("enemy_name_044"),
          desc: __("enemy_desc_044"),
          gold: 10,
          gold_sp: 0,
          prob: 1,
          bait: 0,
          group: 8
        }, {
          id: 45,
          name: __("enemy_name_045"),
          desc: __("enemy_desc_045"),
          gold: 10,
          gold_sp: 0,
          prob: 3,
          bait: 0,
          group: 8
        }, {
          id: 46,
          name: __("enemy_name_046"),
          desc: __("enemy_desc_046"),
          gold: 10,
          gold_sp: 0,
          prob: 5,
          bait: 0,
          group: 8
        }, {
          id: 47,
          name: __("enemy_name_047"),
          desc: __("enemy_desc_047"),
          gold: 25,
          gold_sp: 30,
          prob: 4,
          bait: 15,
          group: 8
        }, {
          id: 48,
          name: __("enemy_name_048"),
          desc: __("enemy_desc_048"),
          gold: 40,
          gold_sp: 0,
          prob: 4,
          bait: 16,
          group: 8
        }, {
          id: 49,
          name: __("enemy_name_049"),
          desc: __("enemy_desc_049"),
          gold: 10,
          gold_sp: 0,
          prob: 0,
          bait: 0,
          group: 9
        }, {
          id: 50,
          name: __("enemy_name_050"),
          desc: __("enemy_desc_050"),
          gold: 11,
          gold_sp: 0,
          prob: 1,
          bait: 0,
          group: 9
        }, {
          id: 51,
          name: __("enemy_name_051"),
          desc: __("enemy_desc_051"),
          gold: 11,
          gold_sp: 0,
          prob: 3,
          bait: 0,
          group: 9
        }, {
          id: 52,
          name: __("enemy_name_052"),
          desc: __("enemy_desc_052"),
          gold: 11,
          gold_sp: 0,
          prob: 5,
          bait: 0,
          group: 9
        }, {
          id: 53,
          name: __("enemy_name_053"),
          desc: __("enemy_desc_053"),
          gold: 30,
          gold_sp: 40,
          prob: 4,
          bait: 17,
          group: 9
        }, {
          id: 54,
          name: __("enemy_name_054"),
          desc: __("enemy_desc_054"),
          gold: 45,
          gold_sp: 0,
          prob: 4,
          bait: 18,
          group: 9
        }, {
          id: 55,
          name: __("enemy_name_055"),
          desc: __("enemy_desc_055"),
          gold: 11,
          gold_sp: 0,
          prob: 0,
          bait: 0,
          group: 10
        }, {
          id: 56,
          name: __("enemy_name_056"),
          desc: __("enemy_desc_056"),
          gold: 12,
          gold_sp: 0,
          prob: 1,
          bait: 0,
          group: 10
        }, {
          id: 57,
          name: __("enemy_name_057"),
          desc: __("enemy_desc_057"),
          gold: 12,
          gold_sp: 0,
          prob: 3,
          bait: 0,
          group: 10
        }, {
          id: 58,
          name: __("enemy_name_058"),
          desc: __("enemy_desc_058"),
          gold: 12,
          gold_sp: 0,
          prob: 5,
          bait: 0,
          group: 10
        }, {
          id: 59,
          name: __("enemy_name_059"),
          desc: __("enemy_desc_059"),
          gold: 35,
          gold_sp: 50,
          prob: 4,
          bait: 19,
          group: 10
        }, {
          id: 60,
          name: __("enemy_name_060"),
          desc: __("enemy_desc_060"),
          gold: 50,
          gold_sp: 0,
          prob: 4,
          bait: 20,
          group: 10
        }
      ];

      EnemyData._ENEMY_DATA_DEFAULT = {};

      return EnemyData;

    })();
  });

  EnemyDataSingleton = (function(_super) {
    __extends(EnemyDataSingleton, _super);

    function EnemyDataSingleton() {
      this._isNewById = __bind(this._isNewById, this);
      this._setIsNewById = __bind(this._setIsNewById, this);
      this._getTotalCountById = __bind(this._getTotalCountById, this);
      this._setTotalCountById = __bind(this._setTotalCountById, this);
      this._getCountById = __bind(this._getCountById, this);
      this._setCountById = __bind(this._setCountById, this);
      this.clearIsNewById = __bind(this.clearIsNewById, this);
      this.isComplete = __bind(this.isComplete, this);
      this.payCountById = __bind(this.payCountById, this);
      this.addCountById = __bind(this.addCountById, this);
      this.getEnemies = __bind(this.getEnemies, this);
      this.hasBossEnemyByGroup = __bind(this.hasBossEnemyByGroup, this);
      this.getEnemiesByGroup = __bind(this.getEnemiesByGroup, this);
      this.getEnemyById = __bind(this.getEnemyById, this);
      this.getEnemyLength = __bind(this.getEnemyLength, this);
      var enemy_data;
      EnemyDataSingleton.__super__.constructor.call(this);
      this._self = data.EnemyData;
      if (Env.IS_DEBUG) {
        this._clearData();
      }
      if (!this._hasData()) {
        this._setData(this._self._ENEMY_DATA_DEFAULT);
      }
      this._enemy_data = this._self._ENEMY_DATA;
      this._data_ids = (function() {
        var _i, _len, _ref4, _results;
        _ref4 = this._enemy_data;
        _results = [];
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          enemy_data = _ref4[_i];
          _results.push(enemy_data.id);
        }
        return _results;
      }).call(this);
      this._data = this._getData();
      return;
    }

    EnemyDataSingleton.prototype.getEnemyLength = function() {
      return this._enemy_data.length;
    };

    EnemyDataSingleton.prototype.getEnemyById = function(id) {
      var item, _i, _len, _ref4;
      _ref4 = this._enemy_data;
      for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
        item = _ref4[_i];
        if (item.id === id) {
          item.count = this._getCountById(id);
          item.total_count = this._getTotalCountById(id);
          item.is_new = this._isNewById(id);
          return item;
        }
      }
      return null;
    };

    EnemyDataSingleton.prototype.getEnemiesByGroup = function(group) {
      var item, result;
      result = (function() {
        var _i, _len, _ref4, _results;
        _ref4 = this._enemy_data;
        _results = [];
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          item = _ref4[_i];
          if (item.group === group) {
            _results.push(this.getEnemyById(item.id));
          }
        }
        return _results;
      }).call(this);
      if (result) {
        return result;
      }
      return [];
    };

    EnemyDataSingleton.prototype.hasBossEnemyByGroup = function(group) {
      var enemies, enemy;
      enemies = (function() {
        var _i, _len, _ref4, _results;
        _ref4 = this.getEnemiesByGroup(group);
        _results = [];
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          enemy = _ref4[_i];
          if (enemy.bait > 0 && enemy.count > 0) {
            _results.push(enemy);
          }
        }
        return _results;
      }).call(this);
      return enemies.length > 0;
    };

    EnemyDataSingleton.prototype.getEnemies = function() {
      var item;
      return (function() {
        var _i, _len, _ref4, _results;
        _ref4 = this._enemy_data;
        _results = [];
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          item = _ref4[_i];
          _results.push(this.getEnemyById(item.id));
        }
        return _results;
      }).call(this);
    };

    EnemyDataSingleton.prototype.addCountById = function(id, add_count) {
      var item, _i, _len, _ref4;
      if (add_count == null) {
        add_count = 1;
      }
      add_count = this._validNum(add_count);
      _ref4 = this._enemy_data;
      for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
        item = _ref4[_i];
        if (item.id === id) {
          this._setCountById(id, this._getCountById(id) + add_count);
          this._setTotalCountById(id, this._getTotalCountById(id) + add_count);
          plugin.Flurry.getInstance().logEventWithParameters(Event.LOG_GET_ENEMY, {
            enemy_id: id,
            count: add_count
          });
          break;
        }
      }
    };

    EnemyDataSingleton.prototype.payCountById = function(id, pay_count) {
      var enemy;
      if (pay_count == null) {
        pay_count = 0;
      }
      pay_count = Math.max(this._validNum(pay_count), 0);
      enemy = this.getEnemyById(id);
      if (enemy && pay_count <= enemy.count) {
        this._setCountById(id, enemy.count - pay_count);
        plugin.Flurry.getInstance().logEventWithParameters(Event.LOG_USE_ENEMY, {
          enemy_id: id,
          count: pay_count
        });
        return true;
      }
      return false;
    };

    EnemyDataSingleton.prototype.isComplete = function() {
      var empty_enemies, enemy;
      empty_enemies = (function() {
        var _i, _len, _ref4, _results;
        _ref4 = this.getEnemies();
        _results = [];
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          enemy = _ref4[_i];
          if (enemy.total_count <= 0) {
            _results.push(enemy);
          }
        }
        return _results;
      }).call(this);
      return empty_enemies.length === 0;
    };

    EnemyDataSingleton.prototype.clearIsNewById = function(id) {
      this._setIsNewById(id);
    };

    EnemyDataSingleton.prototype._setCountById = function(id, count) {
      if (this._getCountById(id) === 0 && 0 < count) {
        this._setIsNewById(id, true);
      }
      this._data["count_" + id] = count;
      this._saveData();
    };

    EnemyDataSingleton.prototype._getCountById = function(id) {
      if (this._data && ("count_" + id) in this._data) {
        return this._data["count_" + id];
      }
      return 0;
    };

    EnemyDataSingleton.prototype._setTotalCountById = function(id, count) {
      this._data["total_count_" + id] = count;
      this._saveData();
    };

    EnemyDataSingleton.prototype._getTotalCountById = function(id) {
      if (this._data && ("total_count_" + id) in this._data) {
        return this._data["total_count_" + id];
      }
      return 0;
    };

    EnemyDataSingleton.prototype._setIsNewById = function(id, flag) {
      if (flag == null) {
        flag = false;
      }
      this._data["isnew_" + id] = flag;
      this._saveData();
    };

    EnemyDataSingleton.prototype._isNewById = function(id) {
      if (this._data && ("isnew_" + id) in this._data) {
        return this._data["isnew_" + id];
      }
      return false;
    };

    return EnemyDataSingleton;

  })(data.DataAbstract);

  namespace("data", function() {
    var ShopData;
    return ShopData = (function() {
      ShopData._INSTANCE = null;

      ShopData.getInstance = function() {
        if (ShopData._INSTANCE === null) {
          ShopData._INSTANCE = new ShopDataSingleton();
        }
        return ShopData._INSTANCE;
      };

      function ShopData() {
        return;
      }

      ShopData._STORAGE_KEY = "shop_data";

      ShopData._SHOP_DATA = [
        {
          id: 1,
          name: __("shop_name_001"),
          desc: _.str.sprintf(__("shop_desc_001"), Config.STATUS_UP_CYCLE_ITEM),
          gold_base: 10,
          is_sp: false,
          is_new: true,
          cost: 1.25
        }, {
          id: 2,
          name: __("shop_name_002"),
          desc: _.str.sprintf(__("shop_desc_002"), Config.STATUS_UP_CYCLE_ITEM),
          gold_base: 10,
          is_sp: false,
          is_new: true,
          cost: 1.25
        }, {
          id: 3,
          name: __("shop_name_003"),
          desc: _.str.sprintf(__("shop_desc_003"), Config.STATUS_UP_CYCLE_ITEM),
          gold_base: 10,
          is_sp: false,
          is_new: true,
          cost: 1.25
        }, {
          id: 4,
          name: __("shop_name_004"),
          desc: _.str.sprintf(__("shop_desc_004"), Config.STATUS_UP_CYCLE_ITEM),
          gold_base: 10,
          is_sp: false,
          is_new: true,
          cost: 1.25
        }, {
          id: 5,
          name: __("shop_name_005"),
          desc: __("shop_desc_005"),
          gold_base: 10,
          is_sp: true,
          is_new: true,
          cost: 1.4
        }, {
          id: 6,
          name: __("shop_name_006"),
          desc: __("shop_desc_006"),
          gold_base: 200,
          is_sp: true,
          is_new: true,
          cost: 1
        }
      ];

      ShopData._SHOP_DATA_DEFAULT = {
        count_6: 3
      };

      return ShopData;

    })();
  });

  ShopDataSingleton = (function(_super) {
    __extends(ShopDataSingleton, _super);

    function ShopDataSingleton() {
      this._isNewById = __bind(this._isNewById, this);
      this._setIsNewById = __bind(this._setIsNewById, this);
      this._getCountById = __bind(this._getCountById, this);
      this._setCountById = __bind(this._setCountById, this);
      this.clearIsNewById = __bind(this.clearIsNewById, this);
      this.payCountById = __bind(this.payCountById, this);
      this.addCountById = __bind(this.addCountById, this);
      this.getProducts = __bind(this.getProducts, this);
      this.getProductById = __bind(this.getProductById, this);
      this.getProductLength = __bind(this.getProductLength, this);
      var shop_data;
      ShopDataSingleton.__super__.constructor.call(this);
      this._self = data.ShopData;
      if (Env.IS_DEBUG) {
        this._clearData();
      }
      if (!this._hasData()) {
        this._setData(this._self._SHOP_DATA_DEFAULT);
      }
      this._shop_data = this._self._SHOP_DATA;
      this._data_ids = (function() {
        var _i, _len, _ref4, _results;
        _ref4 = this._shop_data;
        _results = [];
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          shop_data = _ref4[_i];
          _results.push(shop_data.id);
        }
        return _results;
      }).call(this);
      this._data = this._getData();
      return;
    }

    ShopDataSingleton.prototype.getProductLength = function() {
      return this._shop_data.length;
    };

    ShopDataSingleton.prototype.getProductById = function(id) {
      var isnew, item, _i, _len, _ref4;
      _ref4 = this._shop_data;
      for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
        item = _ref4[_i];
        if (item.id === id) {
          item.count = this._getCountById(id);
          item.gold = Math.floor(item.gold_base * Math.pow(item.cost, item.count));
          isnew = this._isNewById(id);
          if (isnew !== null) {
            item.is_new = isnew;
          }
          return item;
        }
      }
      return null;
    };

    ShopDataSingleton.prototype.getProducts = function() {
      var item;
      return (function() {
        var _i, _len, _ref4, _results;
        _ref4 = this._shop_data;
        _results = [];
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          item = _ref4[_i];
          _results.push(this.getProductById(item.id));
        }
        return _results;
      }).call(this);
    };

    ShopDataSingleton.prototype.addCountById = function(id, add_count) {
      var item, _i, _len, _ref4;
      if (add_count == null) {
        add_count = 1;
      }
      add_count = this._validNum(add_count);
      _ref4 = this._shop_data;
      for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
        item = _ref4[_i];
        if (item.id === id) {
          this._setCountById(id, this._getCountById(id) + add_count);
          plugin.Flurry.getInstance().logEventWithParameters(Event.LOG_BUY_PRODUCTS, {
            product_id: id
          });
          break;
        }
      }
    };

    ShopDataSingleton.prototype.payCountById = function(id, pay_count) {
      var product;
      if (pay_count == null) {
        pay_count = 0;
      }
      pay_count = Math.max(this._validNum(pay_count), 0);
      product = this.getProductById(id);
      if (product && pay_count <= product.count) {
        this._setCountById(id, product.count - pay_count);
        plugin.Flurry.getInstance().logEventWithParameters(Event.LOG_PAY_PRODUCTS, {
          product_id: id
        });
        return true;
      }
      return false;
    };

    ShopDataSingleton.prototype.clearIsNewById = function(id) {
      this._setIsNewById(id);
    };

    ShopDataSingleton.prototype._setCountById = function(id, count) {
      this._data["count_" + id] = count;
      this._saveData();
    };

    ShopDataSingleton.prototype._getCountById = function(id) {
      if (this._data && ("count_" + id) in this._data) {
        return this._data["count_" + id];
      }
      return 0;
    };

    ShopDataSingleton.prototype._setIsNewById = function(id, flag) {
      if (flag == null) {
        flag = false;
      }
      this._data["isnew_" + id] = flag;
      this._saveData();
    };

    ShopDataSingleton.prototype._isNewById = function(id) {
      if (this._data && ("isnew_" + id) in this._data) {
        return this._data["isnew_" + id];
      }
      return null;
    };

    return ShopDataSingleton;

  })(data.DataAbstract);

  namespace("data", function() {
    var StageData;
    return StageData = (function() {
      StageData._INSTANCE = null;

      StageData.getInstance = function() {
        if (StageData._INSTANCE === null) {
          StageData._INSTANCE = new StageDataSingleton();
        }
        return StageData._INSTANCE;
      };

      function StageData() {
        return;
      }

      StageData._STORAGE_KEY = "stage_data";

      StageData._STAGE_DATA = [
        {
          id: 1,
          name: __("stage_name_001"),
          desc: __("stage_desc_001"),
          time: 20,
          prob: 80
        }, {
          id: 2,
          name: __("stage_name_002"),
          desc: __("stage_desc_002"),
          time: 40,
          prob: 200
        }, {
          id: 3,
          name: __("stage_name_003"),
          desc: __("stage_desc_003"),
          time: 60,
          prob: 320
        }, {
          id: 4,
          name: __("stage_name_004"),
          desc: __("stage_desc_004"),
          time: 120,
          prob: 440
        }, {
          id: 5,
          name: __("stage_name_005"),
          desc: __("stage_desc_005"),
          time: 300,
          prob: 560
        }, {
          id: 6,
          name: __("stage_name_006"),
          desc: __("stage_desc_006"),
          time: 600,
          prob: 680
        }, {
          id: 7,
          name: __("stage_name_007"),
          desc: __("stage_desc_007"),
          time: 1200,
          prob: 800
        }, {
          id: 8,
          name: __("stage_name_008"),
          desc: __("stage_desc_008"),
          time: 2400,
          prob: 920
        }, {
          id: 9,
          name: __("stage_name_009"),
          desc: __("stage_desc_009"),
          time: 3600,
          prob: 1040
        }, {
          id: 10,
          name: __("stage_name_010"),
          desc: __("stage_desc_010"),
          time: 7200,
          prob: 1160
        }
      ];

      StageData._STAGE_DATA_DEFAULT = {
        active_1: true,
        isnew_1: false
      };

      return StageData;

    })();
  });

  StageDataSingleton = (function(_super) {
    __extends(StageDataSingleton, _super);

    function StageDataSingleton() {
      this._isNewById = __bind(this._isNewById, this);
      this._setIsNewById = __bind(this._setIsNewById, this);
      this._getActivityById = __bind(this._getActivityById, this);
      this._setActivityById = __bind(this._setActivityById, this);
      this.clearIsNewById = __bind(this.clearIsNewById, this);
      this.openStageById = __bind(this.openStageById, this);
      this.getStages = __bind(this.getStages, this);
      this.getStageById = __bind(this.getStageById, this);
      this.getStageLength = __bind(this.getStageLength, this);
      var stage_data;
      StageDataSingleton.__super__.constructor.call(this);
      this._self = data.StageData;
      if (Env.IS_DEBUG) {
        this._clearData();
      }
      if (!this._hasData()) {
        this._setData(this._self._STAGE_DATA_DEFAULT);
      }
      this._stage_data = this._self._STAGE_DATA;
      this._data_ids = (function() {
        var _i, _len, _ref4, _results;
        _ref4 = this._stage_data;
        _results = [];
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          stage_data = _ref4[_i];
          _results.push(stage_data.id);
        }
        return _results;
      }).call(this);
      this._data = this._getData();
      return;
    }

    StageDataSingleton.prototype.getStageLength = function() {
      return this._stage_data.length;
    };

    StageDataSingleton.prototype.getStageById = function(id) {
      var item, _i, _len, _ref4;
      _ref4 = this._stage_data;
      for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
        item = _ref4[_i];
        if (item.id === id) {
          item.active = this._getActivityById(id);
          item.is_new = this._isNewById(id);
          return item;
        }
      }
      return null;
    };

    StageDataSingleton.prototype.getStages = function() {
      var item;
      return (function() {
        var _i, _len, _ref4, _results;
        _ref4 = this._stage_data;
        _results = [];
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          item = _ref4[_i];
          _results.push(this.getStageById(item.id));
        }
        return _results;
      }).call(this);
    };

    StageDataSingleton.prototype.openStageById = function(id) {
      var ids, stage;
      id = this._validNum(id);
      ids = (function() {
        var _i, _len, _ref4, _results;
        _ref4 = this.getStages();
        _results = [];
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          stage = _ref4[_i];
          _results.push(stage.id);
        }
        return _results;
      }).call(this);
      if (__indexOf.call(ids, id) >= 0) {
        this._setActivityById(id, true);
        plugin.Flurry.getInstance().logEventWithParameters(Event.LOG_STAGE_OPEN, {
          stage_id: id
        });
      }
    };

    StageDataSingleton.prototype.clearIsNewById = function(id) {
      this._setIsNewById(id);
    };

    StageDataSingleton.prototype._setActivityById = function(id, active) {
      if (active == null) {
        active = false;
      }
      if (!this._getActivityById(id) && active) {
        this._setIsNewById(id, true);
      }
      this._data["active_" + id] = active;
      this._saveData();
    };

    StageDataSingleton.prototype._getActivityById = function(id) {
      var data;
      data = this._getData();
      if (this._data && ("active_" + id) in this._data) {
        return this._data["active_" + id];
      }
      return false;
    };

    StageDataSingleton.prototype._setIsNewById = function(id, flag) {
      if (flag == null) {
        flag = false;
      }
      this._data["isnew_" + id] = flag;
      this._saveData();
    };

    StageDataSingleton.prototype._isNewById = function(id) {
      if (this._data && ("isnew_" + id) in this._data) {
        return this._data["isnew_" + id];
      }
      return false;
    };

    return StageDataSingleton;

  })(data.DataAbstract);

  namespace("data", function() {
    var PlayerData;
    return PlayerData = (function() {
      PlayerData.IS_FIRST_SESSION = false;

      PlayerData._INSTANCE = null;

      PlayerData.getInstance = function() {
        if (PlayerData._INSTANCE === null) {
          PlayerData._INSTANCE = new PlayerDataSingleton();
        }
        return PlayerData._INSTANCE;
      };

      function PlayerData() {
        return;
      }

      PlayerData._STORAGE_KEY = "player_data";

      PlayerData._EXP_BASE = 30;

      PlayerData._EXP_INTEREST = 1.25;

      PlayerData._CAPTURE_MAX = 30;

      PlayerData._PRODUCT_TRAP_ID = 5;

      PlayerData._PLAYER_DATA_DEFAULT = {
        level: 1,
        exp: 0,
        int: 10,
        acc: 10,
        cha: 10,
        luc: 10,
        gold: 0,
        special_gold: 0,
        stage: 1,
        started_at: null,
        trap_time: 0,
        phase: 0,
        captures: null,
        capture_num: 15,
        bait: 0
      };

      return PlayerData;

    })();
  });

  PlayerDataSingleton = (function(_super) {
    __extends(PlayerDataSingleton, _super);

    function PlayerDataSingleton() {
      this._easeOutQuint = __bind(this._easeOutQuint, this);
      this.makeCurrentItemCount = __bind(this.makeCurrentItemCount, this);
      this.makeCurrentTime = __bind(this.makeCurrentTime, this);
      this.makeCurrentEnemies = __bind(this.makeCurrentEnemies, this);
      this.setBait = __bind(this.setBait, this);
      this.getBait = __bind(this.getBait, this);
      this.setPhase = __bind(this.setPhase, this);
      this.getPhase = __bind(this.getPhase, this);
      this.clearTrap = __bind(this.clearTrap, this);
      this.getAllTrapedList = __bind(this.getAllTrapedList, this);
      this.setAllTrapedList = __bind(this.setAllTrapedList, this);
      this.getTrapedList = __bind(this.getTrapedList, this);
      this.getRemainingText = __bind(this.getRemainingText, this);
      this.getRemainingSecond = __bind(this.getRemainingSecond, this);
      this.getRemainingTime = __bind(this.getRemainingTime, this);
      this.getFinishTime = __bind(this.getFinishTime, this);
      this.isValidTime = __bind(this.isValidTime, this);
      this.startTrap = __bind(this.startTrap, this);
      this.addCaptureNum = __bind(this.addCaptureNum, this);
      this.getCaptureNum = __bind(this.getCaptureNum, this);
      this.changeStage = __bind(this.changeStage, this);
      this.getStage = __bind(this.getStage, this);
      this.paySpecialGold = __bind(this.paySpecialGold, this);
      this.addSpecialGold = __bind(this.addSpecialGold, this);
      this.getSpecialGold = __bind(this.getSpecialGold, this);
      this.payGold = __bind(this.payGold, this);
      this.addGold = __bind(this.addGold, this);
      this.getGold = __bind(this.getGold, this);
      this.addExp = __bind(this.addExp, this);
      this.getCompExp = __bind(this.getCompExp, this);
      this.getExp = __bind(this.getExp, this);
      this.getLuck = __bind(this.getLuck, this);
      this.getCharm = __bind(this.getCharm, this);
      this.getAccuracy = __bind(this.getAccuracy, this);
      this.getIntelligence = __bind(this.getIntelligence, this);
      this.getLevel = __bind(this.getLevel, this);
      PlayerDataSingleton.__super__.constructor.call(this);
      this._self = data.PlayerData;
      this._shop_data = data.ShopData.getInstance();
      this._enemy_data = data.EnemyData.getInstance();
      this._stage_data = data.StageData.getInstance();
      this._bait_data = data.BaitData.getInstance();
      if (Env.IS_DEBUG) {
        this._clearData();
      }
      if (!this._hasData()) {
        this._setData(this._self._PLAYER_DATA_DEFAULT);
        this._self.IS_FIRST_SESSION = true;
      }
      this._data = this._getData();
      return;
    }

    PlayerDataSingleton.prototype.getLevel = function() {
      return this._data.level;
    };

    PlayerDataSingleton.prototype.getIntelligence = function() {
      return this._data.int + this._shop_data.getProductById(1).count * Config.STATUS_UP_CYCLE_ITEM;
    };

    PlayerDataSingleton.prototype.getAccuracy = function() {
      return this._data.acc + this._shop_data.getProductById(2).count * Config.STATUS_UP_CYCLE_ITEM;
    };

    PlayerDataSingleton.prototype.getCharm = function() {
      return this._data.cha + this._shop_data.getProductById(3).count * Config.STATUS_UP_CYCLE_ITEM;
    };

    PlayerDataSingleton.prototype.getLuck = function() {
      return this._data.luc + this._shop_data.getProductById(4).count * Config.STATUS_UP_CYCLE_ITEM;
    };

    PlayerDataSingleton.prototype.getExp = function() {
      return this._data.exp;
    };

    PlayerDataSingleton.prototype.getCompExp = function() {
      var exp;
      exp = Math.floor(this._self._EXP_BASE * Math.pow(this._self._EXP_INTEREST, this.getLevel() - 1));
      return Math.min(exp, Number.MAX_VALUE);
    };

    PlayerDataSingleton.prototype.addExp = function(num) {
      var comp_exp, next_exp;
      num = this._validNum(num);
      comp_exp = this.getCompExp();
      next_exp = this._data.exp + num;
      if (comp_exp <= next_exp) {
        this._data.level += 1;
        this._data.int += Config.STATUS_UP_CYCLE_LEVEL;
        this._data.acc += Config.STATUS_UP_CYCLE_LEVEL;
        this._data.cha += Config.STATUS_UP_CYCLE_LEVEL;
        this._data.luc += Config.STATUS_UP_CYCLE_LEVEL;
        this._data.exp = next_exp - comp_exp;
        plugin.Flurry.getInstance().logEventWithParameters(Event.LOG_LEVEL_UP, {
          level: Math.floor(this._data.level / 5) * 5,
          gold: Math.floor(this._data.gold / 100) * 100,
          special_gold: Math.floor(this._data.special_gold / 100) * 100,
          stage: this._data.stage
        });
      } else {
        this._data.exp = next_exp;
      }
      this._saveData();
    };

    PlayerDataSingleton.prototype.getGold = function() {
      return this._data.gold;
    };

    PlayerDataSingleton.prototype.addGold = function(num) {
      num = this._validNum(num);
      if (0 < num) {
        this._data.gold += num;
        this._data.gold = Math.min(this._data.gold, Number.MAX_VALUE);
        this._saveData();
      }
    };

    PlayerDataSingleton.prototype.payGold = function(num) {
      num = this._validNum(num);
      if (0 < num) {
        this._data.gold -= num;
        this._data.gold = Math.max(this._data.gold, 0);
        this._saveData();
      }
    };

    PlayerDataSingleton.prototype.getSpecialGold = function() {
      return this._data.special_gold;
    };

    PlayerDataSingleton.prototype.addSpecialGold = function(num) {
      num = this._validNum(num);
      if (0 < num) {
        this._data.special_gold += num;
        this._data.special_gold = Math.min(this._data.special_gold, Number.MAX_VALUE);
        this._saveData();
      }
    };

    PlayerDataSingleton.prototype.paySpecialGold = function(num) {
      num = this._validNum(num);
      if (0 < num) {
        this._data.special_gold -= num;
        this._data.special_gold = Math.max(this._data.special_gold, 0);
        this._saveData();
      }
    };

    PlayerDataSingleton.prototype.getStage = function() {
      return this._data.stage;
    };

    PlayerDataSingleton.prototype.changeStage = function(stage_id) {
      stage_id = this._validNum(stage_id);
      if (0 < stage_id) {
        this._data.stage = stage_id;
        this._saveData();
        plugin.Flurry.getInstance().logEventWithParameters(Event.LOG_STAGE_CHANGE, this._data);
      }
    };

    PlayerDataSingleton.prototype.getCaptureNum = function() {
      var product_count, _ref4, _ref5;
      product_count = (_ref4 = (_ref5 = this._shop_data.getProductById(this._self._PRODUCT_TRAP_ID)) != null ? _ref5.count : void 0) != null ? _ref4 : 0;
      return Math.min(Math.max(this._data.capture_num + product_count, this._self._PLAYER_DATA_DEFAULT.capture_num), this._self._CAPTURE_MAX);
    };

    PlayerDataSingleton.prototype.addCaptureNum = function(num) {
      if (num == null) {
        num = 1;
      }
      num = this._validNum(num);
      if (0 < num) {
        this._data.capture_num += num;
        this._data.capture_num = Math.min(this._data.capture_num, this._self._CAPTURE_MAX);
        this._saveData();
      }
    };

    PlayerDataSingleton.prototype.startTrap = function(hit_list, time) {
      this._data.trap_time = this._validNum(time) * 1000;
      this._data.captures = hit_list;
      this._data.started_at = (new Date()).getTime();
      this._saveData();
    };

    PlayerDataSingleton.prototype.isValidTime = function() {
      if (this._data.started_at !== null && this._data.started_at <= (new Date()).getTime()) {
        return true;
      }
      return false;
    };

    PlayerDataSingleton.prototype.getFinishTime = function() {
      if (this._data.started_at !== null && this._data.trap_time !== null) {
        return this._data.started_at + this._data.trap_time;
      }
      return null;
    };

    PlayerDataSingleton.prototype.getRemainingTime = function() {
      var time;
      if (this._data.started_at !== null && this._data.trap_time !== null) {
        time = (new Date()).getTime() - this._data.started_at;
        if (0 <= time) {
          return Math.max(this._data.trap_time - time, 0);
        }
      }
      return null;
    };

    PlayerDataSingleton.prototype.getRemainingSecond = function() {
      var time;
      time = this.getRemainingTime();
      if (time) {
        return Math.ceil(time / 1000);
      }
      return null;
    };

    PlayerDataSingleton.prototype.getRemainingText = function() {
      var second;
      second = this.getRemainingSecond();
      if (second) {
        return _.str.sprintf("%02d:%02d:%02d", Math.floor(second / 3600), Math.floor(second / 60), second % 60);
      }
      return null;
    };

    PlayerDataSingleton.prototype.getTrapedList = function() {
      var len, time;
      time = this.getRemainingTime();
      if (time !== null && this._data.captures !== null) {
        len = Math.floor((1 - time / this._data.trap_time) * this._data.captures.length);
        return this._data.captures.slice(0, len);
      }
      return null;
    };

    PlayerDataSingleton.prototype.setAllTrapedList = function(list) {
      if (list == null) {
        list = [];
      }
      if (list instanceof Array) {
        this._data.captures = list;
        this._saveData();
      }
    };

    PlayerDataSingleton.prototype.getAllTrapedList = function() {
      return this._data.captures;
    };

    PlayerDataSingleton.prototype.clearTrap = function() {
      this._data.started_at = null;
      this._data.captures = null;
      this._data.bait = 0;
      this._saveData();
    };

    PlayerDataSingleton.prototype.getPhase = function() {
      return this._data.phase;
    };

    PlayerDataSingleton.prototype.setPhase = function(num) {
      num = this._validNum(num);
      if (num < 0) {
        num = 0;
      }
      this._data.phase = num;
      this._saveData();
    };

    PlayerDataSingleton.prototype.getBait = function() {
      return this._data.bait;
    };

    PlayerDataSingleton.prototype.setBait = function(num) {
      num = this._validNum(num);
      if (num === 0 || this._bait_data.hasId(num)) {
        this._data.bait = num;
        this._saveData();
      }
    };

    PlayerDataSingleton.prototype.makeCurrentEnemies = function() {
      var bait_id, count, enemies, enemy, enemy_def, enemy_select, hit, i, p1, p1d, p2, p2d, prob, r1, r2, result, stage_id, stage_prob, _i, _j, _len;
      result = [];
      count = this.getCaptureNum();
      stage_id = this.getStage();
      stage_prob = this._stage_data.getStageById(stage_id).prob;
      bait_id = this.getBait();
      enemies = (function() {
        var _i, _len, _ref4, _results;
        _ref4 = this._enemy_data.getEnemiesByGroup(stage_id);
        _results = [];
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          enemy = _ref4[_i];
          if (enemy.bait === 0 || enemy.bait === bait_id) {
            _results.push(enemy);
          }
        }
        return _results;
      }).call(this);
      enemy_def = ((function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = enemies.length; _i < _len; _i++) {
          enemy = enemies[_i];
          if (enemy.prob === 0) {
            _results.push(enemy);
          }
        }
        return _results;
      })()).shift();
      enemy_select = ((function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = enemies.length; _i < _len; _i++) {
          enemy = enemies[_i];
          if (enemy.prob > 0) {
            _results.push(enemy);
          }
        }
        return _results;
      })()).reverse();
      p1 = this.getIntelligence();
      p2 = this.getAccuracy();
      for (i = _i = 0; 0 <= count ? _i < count : _i > count; i = 0 <= count ? ++_i : --_i) {
        hit = false;
        for (_j = 0, _len = enemy_select.length; _j < _len; _j++) {
          enemy = enemy_select[_j];
          prob = enemy.prob * stage_prob;
          p1d = this._easeOutQuint(p1 / prob, 0, 1, 1);
          if (p1d < 0.2) {
            p1d = 0;
          }
          r1 = Math.min(p1d, 0.5);
          p2d = this._easeOutQuint(p2 / prob, 0, 1, 1);
          if (p2d < 0.2) {
            p2d = 0;
          }
          r2 = Math.min(p2d, 0.5);
          if (Math.random() <= r1 && Math.random() <= r2) {
            result.push(enemy.id);
            hit = true;
            break;
          }
        }
        if (!hit) {
          result.push(enemy_def.id);
        }
      }
      return result;
    };

    PlayerDataSingleton.prototype.makeCurrentTime = function() {
      var count, i, stage, stage_id, time, _i, _ref4;
      stage_id = this.getStage();
      stage = this._stage_data.getStageById(stage_id);
      count = this.getCharm();
      time = stage.time;
      for (i = _i = _ref4 = this._self._PLAYER_DATA_DEFAULT["cha"]; _ref4 <= count ? _i < count : _i > count; i = _ref4 <= count ? ++_i : --_i) {
        time *= 0.998;
      }
      time = Math.max(Math.min(time, stage.time), Math.floor(stage.time * 0.1));
      return time;
    };

    PlayerDataSingleton.prototype.makeCurrentItemCount = function(item_count) {
      var scale;
      scale = Math.min(100, (this.getLuck() - this._self._PLAYER_DATA_DEFAULT["luc"]) * 0.01 + 1);
      return Math.floor(item_count * scale);
    };

    PlayerDataSingleton.prototype._easeOutQuint = function(t, b, c, d) {
      return c * ((t = t / d - 1) * t * t * t * t + 1) + b;
    };

    return PlayerDataSingleton;

  })(data.DataAbstract);


  /**
  * @class ダイアログを表示管理するクラスです
  * @param {Stage or Container} _stage 
  * @param {String or DisplayObject} content 
  * @param {Object} options 
  * @param {Function} callback
   */

  namespace('display.ui', function() {
    var DialogView;
    return DialogView = (function(_super) {
      var Dialog;

      __extends(DialogView, _super);

      function DialogView() {
        return DialogView.__super__.constructor.apply(this, arguments);
      }

      DialogView.DIALOG_TYPE_ALERT = "alert";

      DialogView.DIALOG_TYPE_CONFIRM = "confirm";

      DialogView.DIALOG_TYPE_PRONPT = "pronpt";

      DialogView.DIALOG_TYPE_INFO = "info";

      DialogView._dialogs = [];

      DialogView._toasts = [];

      DialogView._toast_showing = false;

      DialogView._dialog_showing = false;

      DialogView._assets_manager = util.AssetsManager.getInstance();

      DialogView.alert = function(stage, content, options, callback) {
        if (options == null) {
          options = {};
        }
        if (callback == null) {
          callback = null;
        }
        this._createNewDialog(stage, content, options, callback, DialogView.DIALOG_TYPE_ALERT);
      };

      DialogView.confirm = function(stage, content, options, callback) {
        if (options == null) {
          options = {};
        }
        if (callback == null) {
          callback = null;
        }
        this._createNewDialog(stage, content, options, callback, DialogView.DIALOG_TYPE_CONFIRM);
      };

      DialogView.prompt = function(stage, content, options, callback) {
        if (options == null) {
          options = {};
        }
        if (callback == null) {
          callback = null;
        }
      };

      DialogView.info = function(stage, content, options, callback) {
        var _ref4, _ref5, _ref6, _ref7, _ref8;
        if (options == null) {
          options = {};
        }
        if (callback == null) {
          callback = null;
        }
        options.position_y = (_ref4 = options.position_y) != null ? _ref4 : 0;
        options.width = (_ref5 = (_ref6 = options.width) != null ? _ref6 : stage != null ? stage.width : void 0) != null ? _ref5 : Main.STAGE_WIDTH;
        options.duration = (_ref7 = options.duration) != null ? _ref7 : 500;
        options.window_round = (_ref8 = options.window_round) != null ? _ref8 : 0;
        return this._createNewDialog(stage, content, options, callback, DialogView.DIALOG_TYPE_INFO);
      };

      DialogView._createNewDialog = function(stage, content, options, callback, type) {
        var callbackFunc, new_dialog;
        if (stage == null) {
          stage = Main.STAGE;
        }
        if (typeof options === 'function') {
          callback = options;
          options = {};
        }
        new_dialog = new Dialog(stage, content, options, type, DialogView._assets_manager);
        if (type === DialogView.DIALOG_TYPE_INFO) {
          DialogView._toasts.push(new_dialog);
          callbackFunc = function(event) {
            new_dialog.removeEventListener(Dialog.EVENT_DIALOG_CLOSED, callbackFunc);
            if ((callback != null)) {
              callback(event.response);
            }
            DialogView._toasts.splice(DialogView._toasts.indexOf(new_dialog), 1);
            DialogView._toast_showing = false;
            return DialogView._showNextDialog(type);
          };
        } else {
          DialogView._dialogs.push(new_dialog);
          callbackFunc = function(event) {
            new_dialog.removeEventListener(Dialog.EVENT_DIALOG_CLOSED, callbackFunc);
            if ((callback != null)) {
              callback(event.response);
            }
            DialogView._dialogs.splice(DialogView._dialogs.indexOf(new_dialog), 1);
            DialogView._dialog_showing = false;
            return DialogView._showNextDialog(type);
          };
        }
        new_dialog.addEventListener(Dialog.EVENT_DIALOG_CLOSED, callbackFunc);
        return DialogView._showNextDialog(type);
      };

      DialogView._showNextDialog = function(type) {
        if (type === DialogView.DIALOG_TYPE_INFO) {
          if (!DialogView._toast_showing && (DialogView._toasts[0] != null)) {
            DialogView._toasts[0].open();
            return DialogView._toast_showing = true;
          }
        } else {
          if (!DialogView._dialog_showing && (DialogView._dialogs[0] != null)) {
            DialogView._dialogs[0].open();
            return DialogView._dialog_showing = true;
          }
        }
      };


      /*@_hideDialog:(dialog, callback = null)=>
      		callbackFunc = (event)=>
      			event.target.removeEventListener(Dialog.EVENT_DIALOG_CLOSED, callbackFunc)
      			if(@_dialog? and @_dialog is dialog) then @_dialog = null
      			if(callback?) then callback()
      		dialog.addEventListener(Dialog.EVENT_DIALOG_CLOSED, callbackFunc)
       */


      /**
      	* 実際に表示されるダイアログのクラス
      	* @class 実際に表示されるダイアログのクラスです
      	* @param {Class} _stage 
      	* @param {Number} content 
      	* @param {Number} options 
      	* @param {Number} type
       */

      Dialog = (function(_super1) {
        __extends(Dialog, _super1);

        Dialog.EVENT_DIALOG_CLOSED = "event_dialog_closed";

        Dialog.CLOSE_DURATION = 0;

        Dialog.OPEN_DURATION = 0;

        Dialog._OVERLAY_ALPHA = 0.3;

        Dialog._ELEMENT_LAYOUT_MARGIN = dp(10);

        Dialog._DEFAULT_WINDOW_WIDTH = dp(250);

        Dialog._DEFAULT_WINDOW_GRADIENCE = ["#000", "#000"];

        Dialog._DEFAULT_WINDOW_ROUND = dp(3);

        Dialog.prototype._response = false;

        Dialog.prototype._bg = null;

        Dialog.prototype._stage = null;

        Dialog.prototype._covering_overlay = null;

        Dialog.prototype._window = null;

        Dialog.prototype._positive_button = null;

        Dialog.prototype._negative_button = null;

        Dialog.prototype._confirm_buttons_container = null;

        Dialog.prototype._overlay_width = 0;

        Dialog.prototype._overlay_height = 0;

        Dialog.prototype._window_width = 0;

        Dialog.prototype._window_height = 0;

        Dialog.prototype._window_gradience = null;

        Dialog.prototype._window_round = null;

        Dialog.prototype._window_padding = null;

        Dialog.prototype._auto_close_timer = 0;

        function Dialog(_at__stage, content, options, type, assets) {
          var negative_bmp, negative_bmp_on, positive_bmp, positive_bmp_on, _ref4, _ref5, _ref6, _ref7, _ref8;
          this._stage = _at__stage;
          this._initCoveringOverlay = __bind(this._initCoveringOverlay, this);
          this.open = __bind(this.open, this);
          this.close = __bind(this.close, this);
          this._setContent = __bind(this._setContent, this);
          this._overlay_width = (_ref4 = this._stage.width) != null ? _ref4 : Main.STAGE_WIDTH;
          this._overlay_height = (_ref5 = this._stage.height) != null ? _ref5 : Main.STAGE_HEIGHT;
          this._window_width = (_ref6 = options.width) != null ? _ref6 : Dialog._DEFAULT_WINDOW_WIDTH;
          this._window_gradience = (_ref7 = options.window_gradience) != null ? _ref7 : Dialog._DEFAULT_WINDOW_GRADIENCE;
          this._window_round = (_ref8 = options.window_round) != null ? _ref8 : Dialog._DEFAULT_WINDOW_ROUND;
          this._type = type;
          this._auto_close_time = (options.duration != null) ? options.duration + Dialog.OPEN_DURATION : 0;
          this._window = new createjs.Container();
          switch (type) {
            case DialogView.DIALOG_TYPE_ALERT:
              this._initCoveringOverlay(true);
              break;
            case DialogView.DIALOG_TYPE_CONFIRM:
              this._initCoveringOverlay(false);
              this._confirm_buttons_container = new createjs.Container();
              positive_bmp = new createjs.Bitmap(assets.getTag("dialogue_ok_btn", "global"));
              positive_bmp_on = new createjs.Bitmap(assets.getTag("dialogue_ok_btn", "global"));
              negative_bmp = new createjs.Bitmap(assets.getTag("dialogue_ng_btn", "global"));
              negative_bmp_on = new createjs.Bitmap(assets.getTag("dialogue_ng_btn", "global"));
              this._positive_button = new display.ui.DisplayStateButton(positive_bmp, positive_bmp_on);
              this._negative_button = new display.ui.DisplayStateButton(negative_bmp, negative_bmp_on);
              this._positive_button.width = positive_bmp.image.width;
              this._positive_button.height = positive_bmp.image.height;
              this._negative_button.width = negative_bmp.image.width;
              this._negative_button.height = negative_bmp.image.height;
              this._positive_button.y = Dialog._ELEMENT_LAYOUT_MARGIN;
              this._negative_button.y = Dialog._ELEMENT_LAYOUT_MARGIN;
              this._positive_button.x = this._negative_button.x + this._negative_button.width + Dialog._ELEMENT_LAYOUT_MARGIN;
              this._confirm_buttons_container.addChild(this._positive_button);
              this._confirm_buttons_container.addChild(this._negative_button);
              this._confirm_buttons_container.width = this._positive_button.width + this._negative_button.width + Dialog._ELEMENT_LAYOUT_MARGIN;
              this._confirm_buttons_container.height = negative_bmp.image.height + Dialog._ELEMENT_LAYOUT_MARGIN;
              this._positive_button.addEventListener("click", (function(_this) {
                return function() {
                  _this._response = true;
                  _this.close();
                };
              })(this));
              this._negative_button.addEventListener("click", (function(_this) {
                return function() {
                  _this._response = false;
                  _this.close();
                };
              })(this));
              break;
            case DialogView.DIALOG_TYPE_PRONPT:
              break;
            case DialogView.DIALOG_TYPE_INFO:
              break;
          }
          this._setContent(content, options);
          return;
        }

        Dialog.prototype._setContent = function(content, options) {
          var block_width, contentDisplayObject, content_height, content_width, label, lines, _ref10, _ref11, _ref12, _ref13, _ref14, _ref15, _ref16, _ref4, _ref5, _ref6, _ref7, _ref8, _ref9;
          if (content instanceof createjs.DisplayObject) {
            contentDisplayObject = content;
          } else {
            contentDisplayObject = new createjs.Container();
            block_width = this._window_width - Dialog._ELEMENT_LAYOUT_MARGIN * 2;
            label = display.text.FontPac.getText();
            label.lineWidth = block_width - Dialog._ELEMENT_LAYOUT_MARGIN * 2;
            label.lineHeight = dp(12);
            label.text = (_ref4 = content != null ? typeof content.toString === "function" ? content.toString() : void 0 : void 0) != null ? _ref4 : "";
            label.textAlign = "center";
            label.x = block_width / 2;
            display.text.FontPac.textFieldWithLineFeedByLineWidth(label);
            contentDisplayObject.addChild(label);
            lines = ((_ref5 = (_ref6 = label.text.match(/\n/g)) != null ? _ref6.length : void 0) != null ? _ref5 : 0) + 1;
            contentDisplayObject.width = block_width;
            contentDisplayObject.height = label.lineHeight * lines;
          }
          content_width = (_ref7 = (_ref8 = contentDisplayObject != null ? contentDisplayObject.width : void 0) != null ? _ref8 : options != null ? options.width : void 0) != null ? _ref7 : 0;
          content_height = (_ref9 = (_ref10 = contentDisplayObject != null ? contentDisplayObject.height : void 0) != null ? _ref10 : options != null ? options.height : void 0) != null ? _ref9 : 0;
          this._window_width = content_width + Dialog._ELEMENT_LAYOUT_MARGIN * 2;
          contentDisplayObject.x = (this._window_width - content_width) * 0.5;
          contentDisplayObject.y = Dialog._ELEMENT_LAYOUT_MARGIN;
          this._window_height = contentDisplayObject.y + content_height + Dialog._ELEMENT_LAYOUT_MARGIN;
          this._bg = new createjs.Shape();
          this._window.addChild(this._bg);
          if ((this._confirm_buttons_container != null)) {
            this._confirm_buttons_container.y = contentDisplayObject.y + content_height;
            this._confirm_buttons_container.x = (this._window_width - this._confirm_buttons_container.width) * 0.5;
            this._window_height += this._confirm_buttons_container.height;
            this._window.addChild(this._confirm_buttons_container);
          }
          this._bg.graphics.beginLinearGradientFill(this._window_gradience, [0, 1], 0, 0, 0, this._window_height).drawRoundRect(0, 0, this._window_width, this._window_height, this._window_round);
          if ((options.shadow != null)) {
            this._bg.shadow = new createjs.Shadow((_ref11 = options.shadow.color) != null ? _ref11 : "#000", (_ref12 = options.shadow.offset_x) != null ? _ref12 : dp(3), (_ref13 = options.shadow.offset_y) != null ? _ref13 : dp(3), (_ref14 = options.shadow.blur) != null ? _ref14 : dp(10));
          }
          this._window.addChild(contentDisplayObject);
          this._window.x = (_ref15 = options.position_x) != null ? _ref15 : (this._overlay_width - this._window_width) * 0.5;
          this._window.y = (_ref16 = options.position_y) != null ? _ref16 : (this._overlay_height - this._window_height) * 0.5;
        };

        Dialog.prototype.close = function() {
          if (this._type !== DialogView.DIALOG_TYPE_INFO) {
            createjs.Tween.get(this._covering_overlay).to({
              alpha: 0
            }, Dialog.CLOSE_DURATION).call((function(_this) {
              return function() {
                return _this._stage.removeChild(_this._covering_overlay);
              };
            })(this));
          }
          createjs.Tween.get(this._window).to({
            alpha: 0
          }, Dialog.CLOSE_DURATION).call((function(_this) {
            return function() {
              _this._stage.removeChild(_this._window);
              return _this.dispatchEvent({
                type: Dialog.EVENT_DIALOG_CLOSED,
                response: _this._response
              });
            };
          })(this));
        };

        Dialog.prototype.open = function() {
          if (this._type === DialogView.DIALOG_TYPE_INFO) {
            delay(this._auto_close_time, this.close);
          } else {
            this._covering_overlay.alpha = 0;
            this._stage.addChild(this._covering_overlay);
            createjs.Tween.get(this._covering_overlay).to({
              alpha: Dialog._OVERLAY_ALPHA
            }, Dialog.OPEN_DURATION);
          }
          this._window.alpha = 0;
          this._stage.addChild(this._window);
          createjs.Tween.get(this._window).to({
            alpha: 1
          }, Dialog.OPEN_DURATION);
        };

        Dialog.prototype._initCoveringOverlay = function(on_click_close) {
          if (on_click_close == null) {
            on_click_close = true;
          }
          this._covering_overlay = new createjs.Shape();
          if (on_click_close) {
            this._covering_overlay.addEventListener("click", this.close);
          } else {
            this._covering_overlay.addEventListener("click", (function(_this) {
              return function(e) {};
            })(this));
          }
          this._covering_overlay.graphics.beginFill("#000").drawRect(0, 0, this._overlay_width, this._overlay_height);
        };

        return Dialog;

      })(createjs.EventDispatcher);

      return DialogView;

    })(createjs.Container);
  });


  /**
  * ステートボタンを作成する
  * @class 通常、アクティブ、無効の状態表示に対応したボタンクラスです
  * @param {String|createjs.DisplayObject} normal ボタンノーマル時の画像パス又はDisplayObject
  * @param {String|createjs.DisplayObject} [active] ボタンアクティブ時の画像パス又はDisplayObject
  * @param {String|createjs.DisplayObject} [disable] ボタン無効時の画像パス又はDisplayObject
   */

  namespace('display.ui', function() {
    var DisplayStateButton;
    return DisplayStateButton = (function(_super) {
      __extends(DisplayStateButton, _super);

      DisplayStateButton._STATE_NORMAL = 0;

      DisplayStateButton._STATE_ACTIVE = 1;

      DisplayStateButton._STATE_DISABLE = 2;

      DisplayStateButton.prototype._current_state = 0;

      DisplayStateButton.prototype._current_display = null;

      DisplayStateButton.prototype._state_list = ['normal', 'active', 'disable'];

      DisplayStateButton.prototype._disabled = false;

      DisplayStateButton.prototype._width = 0;

      DisplayStateButton.prototype._height = 0;

      function DisplayStateButton(_at_normal, _at_active, _at_disable) {
        this.normal = _at_normal;
        this.active = _at_active != null ? _at_active : null;
        this.disable = _at_disable != null ? _at_disable : null;
        this._changeState = __bind(this._changeState, this);
        this._hideAllBitmap = __bind(this._hideAllBitmap, this);
        this._clickEventHandler = __bind(this._clickEventHandler, this);
        this._stateActiveHandler = __bind(this._stateActiveHandler, this);
        this._stateNormalHandler = __bind(this._stateNormalHandler, this);
        this._setupState = __bind(this._setupState, this);
        DisplayStateButton.__super__.constructor.call(this);
        this.self = DisplayStateButton;
        this._setupState();
        return;
      }

      DisplayStateButton.define('disabled', {
        get: function() {
          return this._disabled;
        },
        set: function(value) {
          if (this._disabled !== value) {
            if (value) {
              this.mouseEnabled = false;
              this._changeState(this.self._STATE_DISABLE);
            } else {
              this.mouseEnabled = true;
              this._changeState(this.self._STATE_NORMAL);
            }
          }
          return this._disabled = value;
        }
      });

      DisplayStateButton.define('width', {
        get: function() {
          if ((this._current_display != null) && this._current_display instanceof createjs.Bitmap) {
            return this._current_display.image.width || this._width;
          }
          return this._width;
        },
        set: function(value) {
          return this._width = value;
        }
      });

      DisplayStateButton.define('height', {
        get: function() {
          if ((this._current_display != null) && this._current_display instanceof createjs.Bitmap) {
            return this._current_display.image.height || this._height;
          }
          return this._height;
        },
        set: function(value) {
          return this._height = value;
        }
      });

      DisplayStateButton.prototype._setupState = function() {
        var i, _i, _len, _ref4;
        _ref4 = this._state_list;
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          i = _ref4[_i];
          if ((this[i] != null) && typeof this[i] === 'string') {
            this[i] = new createjs.Bitmap(getRetinaPath(this[i]));
          }
          if ((this[i] != null) && this[i] instanceof createjs.DisplayObject) {
            this.addChild(this[i]);
          }
        }
        this._changeState(this.self._STATE_NORMAL);
        this.addEventListener('mousedown', this._stateActiveHandler);
        this.addEventListener('mouseout', this._stateNormalHandler);
        this.addEventListener('click', this._clickEventHandler);
      };

      DisplayStateButton.prototype._stateNormalHandler = function(e) {
        this._changeState(this.self._STATE_NORMAL);
      };

      DisplayStateButton.prototype._stateActiveHandler = function(e) {
        this._changeState(this.self._STATE_ACTIVE);
      };

      DisplayStateButton.prototype._clickEventHandler = function(e) {
        this._changeState(this.self._STATE_NORMAL);
        if (typeof sePlay === "function") {
          sePlay("se_tap");
        }
      };

      DisplayStateButton.prototype._hideAllBitmap = function() {
        var i, _i, _len, _ref4;
        _ref4 = this._state_list;
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          i = _ref4[_i];
          if (this[i]) {
            this[i].visible = false;
          }
        }
      };

      DisplayStateButton.prototype._changeState = function(state) {
        var state_bitmap;
        this._current_state = state;
        state_bitmap = null;
        switch (this._current_state) {
          case this.self._STATE_ACTIVE:
            state_bitmap = this.active;
            break;
          case this.self._STATE_DISABLE:
            state_bitmap = this.disable;
        }
        if (this._disabled) {
          state_bitmap = this.disable;
        }
        this._hideAllBitmap();
        if (state_bitmap) {
          state_bitmap.visible = true;
          this._current_display = state_bitmap;
        } else {
          this.normal.visible = true;
          this._current_display = this.normal;
        }
      };

      return DisplayStateButton;

    })(createjs.Container);
  });


  /**
  * ページャービューを作成する
  * @class ページャービューを表示管理するクラスです
  * @param {Class} 画像を取得する用のクラスです
  * @param {Number} width テーブル全体の幅
  * @param {Number} height テーブル全体の高さ
   */

  namespace('display.ui', function() {
    var PagerView;
    return PagerView = (function(_super) {
      __extends(PagerView, _super);

      function PagerView(_at__display_list, _at__width, _at__height) {
        this._display_list = _at__display_list;
        this._width = _at__width;
        this._height = _at__height;
        this.getTotalPage = __bind(this.getTotalPage, this);
        this.getPage = __bind(this.getPage, this);
        this.setPage = __bind(this.setPage, this);
        PagerView.__super__.constructor.call(this);
        return;
      }


      /**
      	* Cellデータセット/更新
      	* @param {Array} data_list Cellデータ表示用のデータ配列
       */

      PagerView.prototype.setPage = function(num) {};

      PagerView.prototype.getPage = function() {
        return 0;
      };

      PagerView.prototype.getTotalPage = function() {
        return this._display_list.length;
      };

      return PagerView;

    })(createjs.Container);
  });

  namespace('display.ui', function() {
    var StateImage;
    return StateImage = (function(_super) {
      __extends(StateImage, _super);

      StateImage.prototype._current_state = "";

      StateImage.prototype._current_display = null;

      StateImage.prototype._state_images = null;

      StateImage.prototype._width = 0;

      StateImage.prototype._height = 0;

      StateImage.prototype._index = 0;

      function StateImage(_at__state_list, _at__state_images, initial_state) {
        this._state_list = _at__state_list;
        this._state_images = _at__state_images;
        if (initial_state == null) {
          initial_state = null;
        }
        this._hideAllBitmap = __bind(this._hideAllBitmap, this);
        this._setupStates = __bind(this._setupStates, this);
        this.setState = __bind(this.setState, this);
        StateImage.__super__.constructor.call(this);
        this.assets = AssetsManager.getInstance();
        this.self = StateImage;
        this._setupStates(initial_state || this._state_list[0]);
        return;
      }

      StateImage.define('state', {
        get: function() {
          return this._current_state;
        }
      });

      StateImage.define('width', {
        get: function() {
          if ((this._current_display != null) && this._current_display instanceof createjs.Bitmap) {
            return this._current_display.image.width || this._width;
          }
          return this._width;
        },
        set: function(value) {
          return this._width = value;
        }
      });

      StateImage.define('height', {
        get: function() {
          if ((this._current_display != null) && this._current_display instanceof createjs.Bitmap) {
            return this._current_display.image.height || this._height;
          }
          return this._height;
        },
        set: function(value) {
          return this._height = value;
        }
      });

      StateImage.prototype.setState = function(state) {
        var state_image;
        this._current_state = state;
        state_image = this._state_images[this._current_state];
        if ((state_image != null)) {
          this._current_display = state_image;
        } else {
          this._current_display = this._state_images[this._state_list[0]];
        }
        this._hideAllBitmap();
        this._current_display.visible = true;
      };

      StateImage.prototype._setupStates = function(initial_state) {
        var state, _i, _len, _ref4;
        _ref4 = this._state_list;
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          state = _ref4[_i];
          if ((this._state_images[state] != null) && typeof this._state_images[state] === 'string') {
            this._state_images[state] = new createjs.Bitmap(getRetinaPath(this[state]));
          }
          if ((this._state_images[state] != null) && this._state_images[state] instanceof createjs.DisplayObject) {
            this.addChild(this._state_images[state]);
          }
        }
        this.setState(initial_state);
      };

      StateImage.prototype._hideAllBitmap = function() {
        var state, state_image, _ref4;
        _ref4 = this._state_images;
        for (state in _ref4) {
          state_image = _ref4[state];
          state_image.visible = false;
        }
      };

      return StateImage;

    })(createjs.Container);
  });


  /**
  * テーブルを作成する(このクラス自体は使わない)
  * @class テーブルを表示管理するクラスです
  * @param {TableView} table 配置されているテーブル
  * @param {Number} index Cellのインデックス番号
  * @param {Number} width テーブル全体の幅
  * @param {Number} height テーブル全体の高さ
   */

  namespace('display.ui', function() {
    var TableCellView;
    return TableCellView = (function(_super) {
      __extends(TableCellView, _super);

      TableCellView.prototype._base_tap_area = null;

      function TableCellView(_at__table, _at__width, _at__height) {
        this._table = _at__table;
        this._width = _at__width != null ? _at__width : 0;
        this._height = _at__height != null ? _at__height : 0;
        this._onTouchDown = __bind(this._onTouchDown, this);
        this._tapEventDispatch = __bind(this._tapEventDispatch, this);
        this._cellTappedHandler = __bind(this._cellTappedHandler, this);
        this._refreshBaseTapArea = __bind(this._refreshBaseTapArea, this);
        this.getData = __bind(this.getData, this);
        this.setData = __bind(this.setData, this);
        TableCellView.__super__.constructor.call(this);
        this._base_tap_area = new createjs.Shape();
        this.addChild(this._base_tap_area);
        this._base_tap_area.hitArea = new createjs.Shape();
        this._refreshBaseTapArea();
        this._base_tap_area.addEventListener("mousedown", this._onTouchDown);
        return;
      }


      /**
      	* Cellデータセット/更新
      	* @param {Object} data 表示データオブジェクト
       */

      TableCellView.prototype.setData = function(_at__data, _at__index) {
        this._data = _at__data;
        this._index = _at__index;
      };


      /**
      	* Cellデータ取得
      	* @return {Object} data 表示データオブジェクト
       */

      TableCellView.prototype.getData = function() {
        return this._data;
      };

      TableCellView.define('width', {
        get: function() {
          return this._width;
        }
      });

      TableCellView.define('height', {
        get: function() {
          return this._height;
        }
      });

      TableCellView.prototype._refreshBaseTapArea = function() {
        this._base_tap_area.hitArea.graphics.clear();
        return this._base_tap_area.hitArea.graphics.beginFill("#FFFFFF").drawRect(0, 0, this.width, this.height);
      };

      TableCellView.prototype._cellTappedHandler = function(event) {
        if (!(this._table.isScrolling() || !this._table.pointIsInsideBounds(event.stageX, event.stageY))) {
          this._tapEventDispatch(this.getChildIndex(event.target));
        }
      };

      TableCellView.prototype._tapEventDispatch = function(tap_index) {
        if (tap_index == null) {
          tap_index = 0;
        }
        util.EventDispatcher.getInstance().dispatchEvent(Event.TABLE_CELL_TAPPED, this._index, tap_index);
      };

      TableCellView.prototype._onTouchDown = function(event) {
        event.addEventListener("mouseup", this._cellTappedHandler);
        return this._table.onMouseDown(event);
      };

      return TableCellView;

    })(createjs.Container);
  });


  /**
  * テーブルを作成する
  * @class テーブルを表示管理するクラスです
  * @param {Class} cell_class TableCellViewを継承したセル表示用のクラスです
  * @param {Number} width テーブル全体の幅
  * @param {Number} height テーブル全体の高さ
   */

  namespace('display.ui', function() {
    var TableView;
    return TableView = (function(_super) {
      __extends(TableView, _super);

      TableView.CELL_CONTAINER_SPRING_K = 5;

      TableView.SCROLLING_THRESHOLD_PX = 10;

      function TableView(_at__cell_class, _at__width, _at__height) {
        this._cell_class = _at__cell_class;
        this._width = _at__width;
        this._height = _at__height;
        this._shiftCursor = __bind(this._shiftCursor, this);
        this._aligncCells = __bind(this._aligncCells, this);
        this._invalidateCell = __bind(this._invalidateCell, this);
        this._layoutCells = __bind(this._layoutCells, this);
        this._overShootCellContainer = __bind(this._overShootCellContainer, this);
        this._onTick = __bind(this._onTick, this);
        this._onMouseUp = __bind(this._onMouseUp, this);
        this._onMouseMove = __bind(this._onMouseMove, this);
        this._initCells = __bind(this._initCells, this);
        this.stopScroll = __bind(this.stopScroll, this);
        this.onMouseDown = __bind(this.onMouseDown, this);
        this.pointIsInsideBounds = __bind(this.pointIsInsideBounds, this);
        this.isScrolling = __bind(this.isScrolling, this);
        this.refresh = __bind(this.refresh, this);
        this.getDataByIndex = __bind(this.getDataByIndex, this);
        this.getData = __bind(this.getData, this);
        this.setData = __bind(this.setData, this);
        TableView.__super__.constructor.call(this);
        this._cells = [];
        this._num_cells = 0;
        this._cursor = 0;
        this._cell_container = null;
        this._cell_container_force_y = 0;
        this._cell_container_spring_k = 5;
        this._container_mask = null;
        this._mouse_position_y = 0;
        this._old_mouse_position_y = 0;
        this._scroll_delta_y = 0;
        this._is_touching = false;
        this._is_scrolling = false;
        this._loop = false;
        this._on_top_edge = false;
        this._on_bottom_edge = false;
        this._last_cell_index = 0;
        this._last_cell = null;
        this._mathAbs = Math.abs;
        this._cell_container = this.addChild(new createjs.Container());
        this._container_mask = new createjs.Shape();
        this._container_mask.graphics.beginFill("#FFF").drawRect(0, 0, this._width, this._height);
        this._cell_container.mask = this._container_mask;
        this._initCells();
        return;
      }


      /**
      	* Cellデータセット/更新
      	* @param {Array} data_list Cellデータ表示用のデータ配列
       */

      TableView.prototype.setData = function(_at__data_list) {
        var cell, data, i, l, _i;
        this._data_list = _at__data_list;
        this._last_cell_index = Math.min(this._cells.length - 1, this._data_list.length - 1);
        this._last_cell = this._cells[this._last_cell_index];
        this._cursor = 0;
        this._cell_container.y = 0;
        this._cells[0].y = 0;
        this._scroll_velocity_y = 0;
        l = this._cells.length;
        for (i = _i = 0; 0 <= l ? _i < l : _i > l; i = 0 <= l ? ++_i : --_i) {
          data = this._data_list[this._cursor + i];
          cell = this._cells[i];
          if ((data != null)) {
            cell.visible = true;
            cell.setData(data, this._cursor + i);
            cell.cache(0, 0, cell.width, cell.height);
          } else {
            cell.visible = false;
          }
        }
        this._layoutCells();
      };

      TableView.prototype.getData = function() {
        return this._data_list;
      };

      TableView.prototype.getDataByIndex = function(index) {
        return this._data_list[index];
      };

      TableView.prototype.refresh = function(data_list) {
        var cell, cell_data, i, _i, _j, _len, _len1, _ref4, _ref5;
        this._data_list = data_list;
        _ref4 = this._data_list;
        for (i = _i = 0, _len = _ref4.length; _i < _len; i = ++_i) {
          cell_data = _ref4[i];
          _ref5 = this._cells;
          for (_j = 0, _len1 = _ref5.length; _j < _len1; _j++) {
            cell = _ref5[_j];
            if (cell_data.id === (cell != null ? typeof cell.getData === "function" ? cell.getData().id : void 0 : void 0)) {
              cell.setData(cell_data, i);
              cell.cache(0, 0, cell.width, cell.height);
              break;
            }
          }
        }
      };


      /**
      	* スクロール判定
      	* @return {bool}
       */

      TableView.prototype.isScrolling = function() {
        return this._is_scrolling;
      };


      /**
      	* hitArea判定
      	* @return {bool}
       */

      TableView.prototype.pointIsInsideBounds = function(x, y) {
        var lp;
        lp = this.globalToLocal(x, y);
        return this._container_mask.hitTest(lp.x, lp.y);
      };


      /**
      	* タップ開始イベントハンドラ(TableCellViewから伝搬する)
      	* @param {MouseEvent} event マウスイベント
       */

      TableView.prototype.onMouseDown = function(event) {
        if (this.pointIsInsideBounds(event.stageX, event.stageY)) {
          event.addEventListener("mousemove", this._onMouseMove);
          event.addEventListener("mouseup", this._onMouseUp);
          this._is_touching = true;
          this._is_scrolling = false;
          this._cell_container_force_y = 0;
          this._mouse_position_y = event.stageY;
          this._old_mouse_position_y = event.stageY;
          return createjs.Ticker.addEventListener("tick", this._onTick);
        }
      };

      TableView.prototype.stopScroll = function() {
        return createjs.Ticker.removeEventListener("tick", this._onTick);
      };

      TableView.define('width', {
        get: function() {
          return this._width;
        }
      });

      TableView.define('height', {
        get: function() {
          return this._height;
        }
      });

      TableView.prototype._initCells = function() {
        var cell, i, position_y;
        position_y = 0;
        i = 0;
        while (true) {
          cell = new this._cell_class(this, i);
          cell.y = position_y;
          this._cell_container.addChild(cell);
          this._cells.push(cell);
          if (position_y > this._height || cell.height <= 0) {
            break;
          }
          position_y += cell.height;
        }
        this._num_cells = this._cells.length;
      };

      TableView.prototype._onMouseMove = function(event) {
        return this._mouse_position_y = event.stageY;
      };

      TableView.prototype._onMouseUp = function(event) {
        event.removeEventListener("mousemove", this._onMouseMove);
        event.removeEventListener("mouseup", this._onMouseUp);
        this._is_touching = false;
        return this._is_scrolling = false;
      };

      TableView.prototype._onTick = function(event) {
        var abs_speed;
        if (this._is_touching) {
          this._scroll_delta_y = this._mouse_position_y - this._old_mouse_position_y;
        } else {
          this._scroll_delta_y *= 0.8;
        }
        abs_speed = this._mathAbs(this._scroll_delta_y);
        if (abs_speed > TableView.SCROLLING_THRESHOLD_PX) {
          this._is_scrolling = true;
        }
        if (this._on_top_edge && this._cells[0].y >= 0) {
          if (this._scroll_delta_y >= 0 || this._cell_container.y > 0) {
            this._aligncCells(1);
            this._overShootCellContainer(1);
          } else {
            this._layoutCells();
          }
        } else if (this._on_bottom_edge && this._last_cell.y + this._last_cell.height <= this.height) {
          if (this._scroll_delta_y <= 0 || this._cell_container.y < 0) {
            this._aligncCells(-1);
            this._overShootCellContainer(-1);
          } else {
            this._layoutCells();
          }
        } else {
          this._layoutCells();
        }
        if (!this._is_touching) {
          this._cell_container_force_y *= 0.6;
          if (abs_speed < 1 && this._mathAbs(this._cell_container.y) < 1) {
            this._cell_container_force_y = 0;
            createjs.Ticker.removeEventListener("tick", this._onTick);
          }
        }
        return this._old_mouse_position_y = this._mouse_position_y;
      };

      TableView.prototype._overShootCellContainer = function(direction) {
        this._cell_container_force_y += this._scroll_delta_y;
        this._cell_container.y = this._cell_container_force_y / TableView.CELL_CONTAINER_SPRING_K;
        if (direction * this._cell_container.y < 0) {
          return this._cell_container.y = 0;
        }
      };

      TableView.prototype._layoutCells = function() {
        var bottom, cell, i, top, _results;
        top = 0;
        bottom = this._cells[0].y + this._scroll_delta_y;
        i = 0;
        _results = [];
        while (i < this._num_cells) {
          cell = this._cells[i];
          top = bottom;
          bottom = top + cell.height;
          if (bottom < 0 && this._scroll_delta_y < 0) {
            this._shiftCursor(1);
            if (!this._on_bottom_edge) {
              this._cells.splice(i, 1);
              this._cells.push(cell);
              this._invalidateCell(cell);
              i--;
            } else {
              cell.y = top;
            }
          } else if (top > this._height && this._scroll_delta_y > 0) {
            this._shiftCursor(-1);
            if (!this._on_top_edge) {
              this._cells.splice(i, 1);
              this._cells.unshift(cell);
              this._invalidateCell(cell);
              cell.y = this._cells[1].y - cell.height;
              i++;
            } else {
              cell.y = top;
            }
          } else {
            cell.y = top;
          }
          _results.push(i++);
        }
        return _results;
      };

      TableView.prototype._invalidateCell = function(cell) {
        var cell_data_index;
        cell_data_index = (this._cells.indexOf(cell) + this._cursor) % this._data_list.length;
        cell.setData(this._data_list[cell_data_index], cell_data_index);
        cell.cache(0, 0, cell.width, cell.height);
        return this._last_cell = this._cells[this._last_cell_index];
      };

      TableView.prototype._aligncCells = function(direction) {
        var bottom, cell, i, top, _results, _results1;
        if (direction === 1) {
          top = 0;
          bottom = 0;
          i = 0;
          _results = [];
          while (i < this._num_cells) {
            cell = this._cells[i];
            top = bottom;
            bottom = top + cell.height;
            cell.y = top;
            _results.push(i++);
          }
          return _results;
        } else {
          top = this.height;
          bottom = 0;
          i = this._num_cells - 1;
          _results1 = [];
          while (i >= 0) {
            cell = this._cells[i];
            bottom = top;
            top = bottom - cell.height;
            cell.y = top;
            _results1.push(i--);
          }
          return _results1;
        }
      };

      TableView.prototype._shiftCursor = function(value) {
        this._cursor += value;
        if (this._loop) {
          while (!(this._cursor >= 0)) {
            this._cursor += this._data_list.length;
          }
          return this._cursor = this._cursor % this._data_list.length;
        } else {
          if (this._cursor < 0) {
            this._cursor = 0;
            this._on_top_edge = true;
          } else {
            this._on_top_edge = false;
          }
          if (this._cursor + this._cells.length > this._data_list.length) {
            this._cursor = this._data_list.length - this._cells.length;
            return this._on_bottom_edge = true;
          } else {
            return this._on_bottom_edge = false;
          }
        }
      };

      return TableView;

    })(createjs.Container);
  });

  namespace('display.ui', function() {
    var TabView;
    return TabView = (function(_super) {
      var TabHead, Util;

      __extends(TabView, _super);

      TabView.EVENT_TAB_CHANGED = "tab_changed";

      TabView.HEAD_HEIGHT = dp(36);

      function TabView(assets, initial_tab, _at__width, _at__height) {
        var asset, base, content, head, i, tab_width, _i, _j, _k, _len, _len1, _len2, _ref4, _ref5;
        if (initial_tab == null) {
          initial_tab = 0;
        }
        this._width = _at__width != null ? _at__width : Main.STAGE_WIDTH;
        this._height = _at__height != null ? _at__height : Main.STAGE_HEIGHT;
        this._changeState = __bind(this._changeState, this);
        this._tabClickHandler = __bind(this._tabClickHandler, this);
        this.setTabEnabled = __bind(this.setTabEnabled, this);
        this.getContent = __bind(this.getContent, this);
        this.selectTab = __bind(this.selectTab, this);
        TabView.__super__.constructor.call(this);
        this.self = TabView;
        this._tab_heads = [];
        this._tab_contents = [];
        this._current_selected_index = initial_tab;
        base = new createjs.Shape();
        base.graphics.beginFill("#e0d5c1").drawRect(0, 0, this._width, this._height);
        this.addChild(base);
        tab_width = this._width / assets.length;
        for (i = _i = 0, _len = assets.length; _i < _len; i = ++_i) {
          asset = assets[i];
          head = new TabHead(asset.head, i, tab_width);
          content = asset.content;
          this._tab_heads.push(head);
          this._tab_contents.push(content);
          head.x = tab_width * i;
          content.y = head.height;
          content.x = (this._width - Util.getSize(content).width) / 2;
          content.visible = false;
          head.addEventListener("click", this._tabClickHandler);
        }
        _ref4 = this._tab_contents;
        for (_j = 0, _len1 = _ref4.length; _j < _len1; _j++) {
          content = _ref4[_j];
          this.addChild(content);
        }
        _ref5 = this._tab_heads;
        for (_k = 0, _len2 = _ref5.length; _k < _len2; _k++) {
          head = _ref5[_k];
          this.addChild(head);
        }
        this._changeState();
        return;
      }

      TabView.define('width', {
        get: function() {
          return this._width;
        },
        set: function(value) {
          return this._width = value;
        }
      });

      TabView.define('height', {
        get: function() {
          return this._height;
        },
        set: function(value) {
          return this._height = value;
        }
      });

      TabView.define('selected', {
        get: function() {
          return this._current_selected_index;
        },
        set: function(value) {
          return this.selectTab(value);
        }
      });

      TabView.prototype.selectTab = function(index) {
        var old_tab_index;
        if (this._current_selected_index !== index) {
          old_tab_index = this._current_selected_index;
          this._current_selected_index = index;
          this._changeState();
          return this.dispatchEvent(this.self.EVENT_TAB_CHANGED);
        }
      };

      TabView.prototype.getContent = function(index) {
        return this._tab_contents[index];
      };

      TabView.prototype.setTabEnabled = function(index, bool) {
        var content, tab;
        tab = this._tab_heads[index];
        content = this._tab_contents[index];
        if (content instanceof createjs.DisplayObject) {
          content.mouseEnabled = bool;
        }
        return tab.disabled = !bool;
      };

      TabView.prototype._tabClickHandler = function(event) {
        this.selectTab(event.target.index);
      };

      TabView.prototype._changeState = function() {
        var content, head, i, _i, _len, _ref4, _results;
        _ref4 = this._tab_heads;
        _results = [];
        for (i = _i = 0, _len = _ref4.length; _i < _len; i = ++_i) {
          head = _ref4[i];
          content = this._tab_contents[i];
          if (i === this._current_selected_index) {
            head.select();
            content.visible = true;
            if (content instanceof display.ui.TableView) {
              _results.push(content.stopScroll());
            } else {
              _results.push(void 0);
            }
          } else {
            head.unselect();
            content.visible = false;
            if (content instanceof display.ui.TableView) {
              _results.push(content.stopScroll());
            } else {
              _results.push(void 0);
            }
          }
        }
        return _results;
      };

      TabHead = (function(_super1) {
        __extends(TabHead, _super1);

        TabHead._STATE_UNSELECTED = "unselected";

        TabHead._STATE_ACTIVE = "active";

        TabHead._STATE_SELECTED = "selected";

        TabHead._STATE_DISABLED = "disabled";

        TabHead.prototype._current_state = "";

        TabHead.prototype._current_display = null;

        TabHead.prototype._state_bitmaps = null;

        TabHead.prototype._disabled = false;

        TabHead.prototype._width = 0;

        TabHead.prototype._height = 0;

        TabHead.prototype._head_content = null;

        TabHead.prototype._index = 0;

        function TabHead(_at__head_content, _at__index, _at__width) {
          this._head_content = _at__head_content;
          this._index = _at__index;
          this._width = _at__width;
          this._setState = __bind(this._setState, this);
          this._hideAllBitmap = __bind(this._hideAllBitmap, this);
          this._setupState = __bind(this._setupState, this);
          this.unselect = __bind(this.unselect, this);
          this.select = __bind(this.select, this);
          TabHead.__super__.constructor.call(this);
          this.assets = AssetsManager.getInstance();
          this.self = TabHead;
          this._setupState();
          return;
        }

        TabHead.define('disabled', {
          get: function() {
            return this._disabled;
          },
          set: function(value) {
            if (this._disabled !== value) {
              if (value) {
                this.mouseEnabled = false;
                this._setState(this.self._STATE_DISABLED);
              } else {
                this.mouseEnabled = true;
                this._setState(this.self._STATE_UNSELECTED);
              }
            }
            return this._disabled = value;
          }
        });

        TabHead.define('state', {
          get: function() {
            return this._current_state;
          }
        });

        TabHead.define('width', {
          get: function() {
            return this._width;
          }
        });

        TabHead.define('height', {
          get: function() {
            if ((this._current_display != null) && this._current_display instanceof createjs.Bitmap) {
              return this._current_display.image.height || this._height;
            }
            return this._height;
          }
        });

        TabHead.define('index', {
          get: function() {
            return this._index;
          }
        });

        TabHead.prototype.select = function() {
          this._setState(this.self._STATE_SELECTED);
          return this._nonActiveState = this._current_state;
        };

        TabHead.prototype.unselect = function() {
          this._setState(this.self._STATE_UNSELECTED);
          return this._nonActiveState = this._current_state;
        };

        TabHead.prototype._setupState = function() {
          var state, state_bitmap, tab_base, tab_base_on, _ref4;
          tab_base = this.assets.getTag("tab_base", "shop");
          tab_base_on = this.assets.getTag("tab_base_on", "shop");
          this._state_bitmaps = {};
          this._state_bitmaps[this.self._STATE_UNSELECTED] = new createjs.Bitmap(tab_base);
          this._state_bitmaps[this.self._STATE_SELECTED] = new createjs.Bitmap(tab_base_on);
          this._state_bitmaps[this.self._STATE_ACTIVE] = new createjs.Bitmap(tab_base_on);
          this._state_bitmaps[this.self._STATE_DISABLED] = new createjs.Bitmap(tab_base);
          _ref4 = this._state_bitmaps;
          for (state in _ref4) {
            state_bitmap = _ref4[state];
            if (state_bitmap.image.width !== this._width) {
              state_bitmap.scaleX = this._width / state_bitmap.image.width;
            }
            this.addChild(state_bitmap);
          }
          this._setState(this.self._STATE_UNSELECTED);
          this._head_content.x = (this.width - Util.getSize(this._head_content).width) / 2;
          this._head_content.y = (this.height - Util.getSize(this._head_content).height) / 2;
          this.addChild(this._head_content);
          this.addEventListener("mousedown", (function(_this) {
            return function(event) {
              return _this._setState(_this.self._STATE_ACTIVE);
            };
          })(this));
          this.addEventListener("mouseout", (function(_this) {
            return function(event) {
              return _this._setState(_this._nonActiveState);
            };
          })(this));
        };

        TabHead.prototype._hideAllBitmap = function() {
          var state, state_bitmap, _ref4;
          _ref4 = this._state_bitmaps;
          for (state in _ref4) {
            state_bitmap = _ref4[state];
            state_bitmap.visible = false;
          }
        };

        TabHead.prototype._setState = function(state) {
          var state_bitmap;
          this._current_state = state;
          state_bitmap = this._state_bitmaps[this._current_state];
          if ((state_bitmap != null)) {
            this._current_display = state_bitmap;
          } else {
            this._current_display = this._state_bitmaps[this.self._STATE_UNSELECTED];
          }
          this._hideAllBitmap();
          this._current_display.visible = true;
        };

        return TabHead;

      })(createjs.Container);

      Util = (function() {
        function Util() {}

        Util.getSize = function(target) {
          if (target instanceof createjs.Bitmap && (target.image != null)) {
            return {
              width: target.image.width,
              height: target.image.height
            };
          }
          return {
            width: target.width || 0,
            height: target.height || 0
          };
        };

        return Util;

      })();

      return TabView;

    })(createjs.Container);
  });

  BitmapFont = (function() {
    function BitmapFont(_at__sprite_sheet, _at__char_map) {
      this._sprite_sheet = _at__sprite_sheet;
      this._char_map = _at__char_map;
      this.getCharImage = __bind(this.getCharImage, this);
      this.char_width = this._sprite_sheet._frameWidth;
      this.char_height = this._sprite_sheet._frameHeight;
      return;
    }

    BitmapFont.prototype.getCharImage = function(char) {
      var index;
      index = this._char_map.indexOf(char);
      if (index > -1) {
        return new createjs.Bitmap(createjs.SpriteSheetUtils.extractFrame(this._sprite_sheet, index));
      }
    };

    return BitmapFont;

  })();

  namespace('display.text', function() {
    return BitmapFont;
  });

  BitmapText = (function(_super) {
    __extends(BitmapText, _super);

    BitmapText.prototype._TEXT_ALIGNS = {
      "left": 0,
      "center": -0.5,
      "right": -1
    };

    BitmapText.prototype._text_align = 'left';

    function BitmapText(_at__bitmap_font, _at__text) {
      this._bitmap_font = _at__bitmap_font;
      this._text = _at__text != null ? _at__text : "";
      this._clear = __bind(this._clear, this);
      this._setCharPosition = __bind(this._setCharPosition, this);
      this._build = __bind(this._build, this);
      this.setTextAlign = __bind(this.setTextAlign, this);
      this.setText = __bind(this.setText, this);
      BitmapText.__super__.constructor.call(this);
      this._build();
      return;
    }

    BitmapText.prototype.setText = function(text) {
      this._text = text;
      this._build();
    };

    BitmapText.prototype.setTextAlign = function(align) {
      if (align in this._TEXT_ALIGNS) {
        this._text_align = align;
        this._build();
      }
    };

    BitmapText.prototype._build = function() {
      var char, char_image, i, _i, _ref4;
      this._clear();
      for (i = _i = 0, _ref4 = this._text.length; 0 <= _ref4 ? _i < _ref4 : _i > _ref4; i = 0 <= _ref4 ? ++_i : --_i) {
        char = this._text.charAt(i);
        char_image = this._bitmap_font.getCharImage(char);
        if (char_image) {
          this.addChild(char_image);
          this._setCharPosition(char_image, i);
        }
      }
    };

    BitmapText.prototype._setCharPosition = function(bitmap, index) {
      var base_x, scale;
      scale = this._TEXT_ALIGNS[this._text_align];
      base_x = this._bitmap_font.char_width * this._text.length * scale;
      bitmap.x = base_x + this._bitmap_font.char_width * index;
    };

    BitmapText.prototype._clear = function() {
      this.removeAllChildren();
    };

    return BitmapText;

  })(createjs.Container);

  namespace('display.text', function() {
    return BitmapText;
  });

  namespace('display.text', function() {
    var FontPac;
    return FontPac = (function() {
      function FontPac() {}

      FontPac.getLargeNumberText = function() {
        return new createjs.Text("", "bold " + (dp(28).toString()) + "px mplus", "#FFFFFF");
      };

      FontPac.getNumberText = function() {
        return new createjs.Text("", "bold " + (dp(16).toString()) + "px mplus", "#FFFFFF");
      };

      FontPac.getSmallNumberText = function() {
        return new createjs.Text("", "bold " + (dp(14).toString()) + "px mplus", "#FFFFFF");
      };

      FontPac.getTimeText = function() {
        return new createjs.Text("", "bold " + (dp(32).toString()) + "px mplus", "#FFFFFF");
      };

      FontPac.getHeaderText = function() {
        return new createjs.Text("", "bold " + (dp(11).toString()) + "px mplus", "#FFFFFF");
      };

      FontPac.getText = function() {
        return new createjs.Text("", (dp(11).toString()) + "px mplus", "#FFFFFF");
      };

      FontPac.getTitleText = function() {
        return new createjs.Text("", "bold " + (dp(14).toString()) + "px mplus", "#FFFFFF");
      };

      FontPac.textFieldWithLineFeedByLineWidth = function(text_field) {
        var char, char_size, chars, current_size, current_width, i, matches, max_width, text, _i, _len;
        matches = text_field.font.match(/([0-9]+)\s*px/);
        max_width = text_field.lineWidth;
        if (matches && max_width) {
          current_width = 0;
          char_size = parseInt(matches[1], 10);
          text = text_field.text;
          chars = [];
          for (i = _i = 0, _len = text.length; _i < _len; i = ++_i) {
            char = text[i];
            if (char === "\n") {
              current_width = 0;
            } else {
              current_size = FontPac.getCharactorSize(char, char_size);
              current_width += current_size;
              if (max_width < current_width) {
                chars.push("\n");
                current_width = current_size;
              }
            }
            chars.push(char);
          }
          text_field.text = chars.join("");
        }
        return text_field;
      };

      FontPac.getCharactorSize = function(char, size) {
        var c;
        if (char) {
          c = char.charCodeAt(0);
          if ((c >= 0x0 && c < 0x81) || (c === 0xf8f0) || (c >= 0xff61 && c < 0xffa0) || (c >= 0xf8f1 && c < 0xf8f4)) {
            return size * 0.51;
          }
        }
        return size;
      };

      return FontPac;

    })();
  });

  PointNumberFont = (function(_super) {
    __extends(PointNumberFont, _super);

    function PointNumberFont() {
      var assets;
      assets = util.AssetsManager.getInstance();
      PointNumberFont.__super__.constructor.call(this, new createjs.SpriteSheet({
        images: [assets.getTag("font_game_num")],
        frames: {
          width: dp(12),
          height: dp(18),
          count: 11
        }
      }), '0123456789,');
      return;
    }

    return PointNumberFont;

  })(display.text.BitmapFont);

  namespace('display.text', function() {
    return PointNumberFont;
  });

  LoadingSprite = (function(_super) {
    __extends(LoadingSprite, _super);

    function LoadingSprite() {
      this._viewSetup = __bind(this._viewSetup, this);
      LoadingSprite.__super__.constructor.call(this);
      this._viewSetup();
      return;
    }

    LoadingSprite.prototype._viewSetup = function() {
      var base;
      base = new createjs.Shape();
      base.graphics.beginFill("#000").drawRect(0, 0, Main.STAGE_WIDTH, Main.STAGE_HEIGHT);
      this.addChild(base);
      this.text = new createjs.Text(__("now_loading"), "bold " + (dp(12).toString()) + "px mplus", "#FFFFFF");
      this.text.regY = this.text.getMeasuredHeight();
      this.text.x = Main.STAGE_WIDTH - dp(10);
      this.text.y = Main.STAGE_HEIGHT - dp(10);
      this.text.textAlign = 'right';
      this.addChild(this.text);
      this.addEventListener('click', function() {});
    };

    return LoadingSprite;

  })(createjs.Container);

  namespace('display.sprite', function() {
    return LoadingSprite;
  });

  BaseScene = (function(_super) {
    __extends(BaseScene, _super);

    function BaseScene() {
      this.tickHandler = __bind(this.tickHandler, this);
      this.init = __bind(this.init, this);
      BaseScene.__super__.constructor.call(this);
      return;
    }

    BaseScene.prototype.init = function() {};

    BaseScene.prototype.tickHandler = function(delta) {};

    return BaseScene;

  })(createjs.Container);

  if (typeof namespace === "function") {
    namespace('display.scene', function() {
      return BaseScene;
    });
  }


  /**
  * テーブルを作成する(このクラス自体は使わない)
  * @class テーブルを表示管理するクラスです
  * @param {TableView} table 配置されているテーブル
  * @param {Number} index Cellのインデックス番号
  * @param {Number} width テーブル全体の幅
  * @param {Number} height テーブル全体の高さ
   */

  namespace('display.scene.map', function() {
    var BaitTableCellView;
    return BaitTableCellView = (function(_super) {
      __extends(BaitTableCellView, _super);

      BaitTableCellView.prototype._base_tap_area = null;

      function BaitTableCellView(_at__table) {
        this._table = _at__table;
        this._init = __bind(this._init, this);
        this.setData = __bind(this.setData, this);
        this._width = Main.STAGE_WIDTH;
        this._height = dp(71);
        BaitTableCellView.__super__.constructor.call(this, this._table, this._width, this._height);
        this._assets = util.AssetsManager.getInstance();
        this._init();
        return;
      }


      /**
      	* Cellデータセット/更新
      	* @param {Object} data 表示データオブジェクト
       */

      BaitTableCellView.prototype.setData = function(_at__data, _at__index) {
        var base, image, image_base;
        this._data = _at__data;
        this._index = _at__index;
        this._image_container.removeAllChildren();
        image_base = new createjs.Bitmap(this._assets.getTag("modal_image_base"));
        this._image_container.addChild(image_base);
        image_base = new createjs.Bitmap(this._assets.getTag(_.str.sprintf("map_image_%03d", Math.ceil(this._data.id / 2)), "bait"));
        image_base.x = dp(4);
        image_base.y = dp(4);
        this._image_container.addChild(image_base);
        base = new createjs.Shape();
        base.graphics.beginFill("#000000").drawRect(0, 0, image_base.image.width, image_base.image.height);
        base.x = image_base.x;
        base.y = image_base.y;
        base.alpha = 0.4;
        this._image_container.addChild(base);
        image = new createjs.Bitmap(this._assets.getTag(_.str.sprintf("bait_%03d", this._data.id), "bait"));
        image.regX = image.image.width / 2;
        image.regY = image.image.height / 2;
        image.x = image_base.x + image_base.image.width / 2;
        image.y = image_base.y + image_base.image.height * 0.6;
        this._image_container.addChild(image);
        this._title.text = this._data.name;
        this._desc.text = this._data.desc;
        this._desc = display.text.FontPac.textFieldWithLineFeedByLineWidth(this._desc);
        this._count.text = this._data.count;
        if (this._data.count > 0) {
          this.alpha = 1;
        } else {
          this.alpha = 0.6;
        }
      };

      BaitTableCellView.prototype._init = function() {
        var base, count_base;
        base = new createjs.Shape();
        base.graphics.beginFill("#FFF").drawRect(0, 0, this._width, this._height - dp(1));
        this.addChild(base);
        this._image_container = new createjs.Container();
        this._image_container.x = dp(6);
        this._image_container.y = dp(6);
        this.addChild(this._image_container);
        count_base = new createjs.Bitmap(this._assets.getTag("bait_num_base", "bait"));
        count_base.x = this._width - count_base.image.width - dp(10);
        count_base.y = (this._height - count_base.image.height) / 2;
        this.addChild(count_base);
        this._title = display.text.FontPac.getTitleText();
        this._title.color = "#000";
        this._title.text = "";
        this._title.x = dp(70);
        this._title.y = dp(8);
        this.addChild(this._title);
        this._desc = display.text.FontPac.getText();
        this._desc.color = "#000";
        this._desc.text = "";
        this._desc.x = dp(70);
        this._desc.y = dp(32);
        this._desc.lineWidth = dp(130);
        this._desc.lineHeight = dp(14);
        this.addChild(this._desc);
        this._count = display.text.FontPac.getLargeNumberText();
        this._count.color = "#e52729";
        this._count.text = "000";
        this._count.x = this._width - dp(20);
        this._count.y = dp(16);
        this._count.textAlign = "right";
        this.addChild(this._count);
      };

      return BaitTableCellView;

    })(display.ui.TableCellView);
  });

  namespace('display.scene.game', function() {
    var Enemy;
    return Enemy = (function(_super) {
      __extends(Enemy, _super);

      Enemy._EASE_TIME = 1000;

      Enemy.prototype.chara_rotation = 0;

      Enemy.prototype.chara_scale = 1;

      Enemy.prototype._cutable = false;

      function Enemy(_at__bm, _at__bm_net, _at__target_bm) {
        this._bm = _at__bm;
        this._bm_net = _at__bm_net;
        this._target_bm = _at__target_bm;
        this.cutTrap = __bind(this.cutTrap, this);
        this._lineDraw = __bind(this._lineDraw, this);
        this._charaProp = __bind(this._charaProp, this);
        this.isCutable = __bind(this.isCutable, this);
        this.hitTrap = __bind(this.hitTrap, this);
        this.setToTrap = __bind(this.setToTrap, this);
        this.moveToTrap = __bind(this.moveToTrap, this);
        this.init = __bind(this.init, this);
        Enemy.__super__.constructor.call(this);
        this._self = Enemy;
        this.init();
        return;
      }

      Enemy.prototype.init = function() {
        this._bm.regX = this._bm.image.width / 2;
        this._bm.regY = this._bm.image.height;
        this.addChild(this._bm);
        this._graphic = new createjs.Graphics();
        this._shape = new createjs.Shape(this._graphic);
        this._shape.alpha = 0.8;
        this.addChild(this._shape);
        this._bm_net.regX = this._bm_net.image.width / 2;
        this._bm_net.regY = this._bm_net.image.height * 0.9;
        this._bm_net.visible = false;
        this.addChild(this._bm_net);
      };

      Enemy.prototype.moveToTrap = function(delay) {
        if (delay == null) {
          delay = 0;
        }
        if (!this.visible) {
          this.visible = true;
          createjs.Tween.get(this).wait(delay).to({
            x: this._target_bm.x,
            y: this._target_bm.y
          }, this._self._EASE_TIME).call(this.hitTrap);
        }
      };

      Enemy.prototype.setToTrap = function() {
        this._target_bm.visible = false;
        if (this._target_bm._bait) {
          this._target_bm._bait.visible = false;
        }
        this._bm_net.visible = true;
        this._cutable = true;
        this.chara_rotation = 180;
        this.x = this._target_bm.x;
        this.y = this._target_bm.y - dp(150);
        this._lineDraw();
        this.visible = true;
      };

      Enemy.prototype.hitTrap = function() {
        var rot;
        this._target_bm.visible = false;
        if (this._target_bm._bait) {
          this._target_bm._bait.visible = false;
        }
        this._bm_net.visible = true;
        rot = 180;
        if (this.x > Main.STAGE_WIDTH / 2) {
          rot *= -1;
        }
        createjs.Tween.get(this).to({
          chara_rotation: rot,
          y: this.y - dp(150)
        }, this._self._EASE_TIME * 2, createjs.Ease.elasticOut).call((function(_this) {
          return function() {
            _this._cutable = true;
            return util.EventDispatcher.getInstance().dispatchEvent(Event.ENEMY_HITED, _this);
          };
        })(this)).addEventListener("change", this._lineDraw);
      };

      Enemy.prototype.isCutable = function() {
        return this._cutable;
      };

      Enemy.prototype._charaProp = function(e) {
        this._bm_net.rotation = this._bm.rotation = this.chara_rotation;
      };

      Enemy.prototype._lineDraw = function(e) {
        var p1, p2;
        this._charaProp();
        p1 = new createjs.Point(0, 0);
        p2 = new createjs.Point(0, -this.y);
        this._graphic.clear();
        this._graphic.setStrokeStyle(1);
        this._graphic.beginStroke(createjs.Graphics.getRGB(255, 216, 140));
        this._graphic.moveTo(p1.x, p1.y);
        this._graphic.lineTo(p2.x, p2.y);
      };

      Enemy.prototype.cutTrap = function() {
        if (this._cutable) {
          util.EventDispatcher.getInstance().dispatchEvent(Event.ENEMY_PRE_CAPTURE, this);
          this._cutable = false;
          this._bm_net.visible = false;
          this._graphic.clear();
          createjs.Tween.get(this).to({
            chara_rotation: 0,
            chara_scale: 2,
            y: this.y - dp(75)
          }, this._self._EASE_TIME / 2, createjs.Ease.cubicOut).call((function(_this) {
            return function() {
              return createjs.Tween.get(_this).to({
                y: _this.y + dp(100),
                alpha: 0
              }, _this._self._EASE_TIME / 2, createjs.Ease.cubicOut).call(function() {
                _this.visible = false;
                return util.EventDispatcher.getInstance().dispatchEvent(Event.ENEMY_CAPTURED, _this);
              });
            };
          })(this)).addEventListener("change", this._charaProp);
        }
      };

      return Enemy;

    })(createjs.Container);
  });

  namespace('display.scene.game', function() {
    var ExpGauge;
    return ExpGauge = (function(_super) {
      __extends(ExpGauge, _super);

      function ExpGauge() {
        this.setExp = __bind(this.setExp, this);
        this.init = __bind(this.init, this);
        ExpGauge.__super__.constructor.call(this);
        this.self = ExpGauge;
        this.init();
        return;
      }

      ExpGauge.prototype.init = function() {
        var graphics;
        graphics = new createjs.Graphics().beginFill("#ff6600").drawRect(0, 0, dp(35), dp(2));
        this._bar = new createjs.Shape(graphics);
        this.addChild(this._bar);
        this.setExp(0, 0);
      };

      ExpGauge.prototype.setExp = function(exp, exp_max) {
        var _ref4;
        if ((_ref4 = this._bar) != null) {
          _ref4.scaleX = exp / exp_max;
        }
      };

      return ExpGauge;

    })(createjs.Container);
  });

  namespace('display.scene.game', function() {
    var Item;
    return Item = (function(_super) {
      __extends(Item, _super);

      Item._EASE_TIME = 400;

      Item._KV = 0.98;

      Item._G = 0.98;

      function Item(_at__stage, _at__bm, _at__pos_x, _at__pos_y) {
        this._stage = _at__stage;
        this._bm = _at__bm;
        this._pos_x = _at__pos_x;
        this._pos_y = _at__pos_y;
        this._completeHandler = __bind(this._completeHandler, this);
        this._changeHandler = __bind(this._changeHandler, this);
        this._playTweens = __bind(this._playTweens, this);
        this.init = __bind(this.init, this);
        Item.__super__.constructor.call(this);
        this.self = Item;
        this.init();
        return;
      }

      Item.prototype.init = function() {
        this._bm.regX = this._bm.image.width / 2;
        this._bm.regY = this._bm.image.height / 2;
        this.addChild(this._bm);
        this._power_x = Math.random() * dp(20) - dp(10);
        this._power_y = -(Math.random() * dp(10) + dp(10));
        this.x = this._pos_x;
        this.y = this._pos_y;
        this._stage.addChild(this);
        this._playTweens();
      };

      Item.prototype._playTweens = function() {
        createjs.Tween.get(this).wait(this.self._EASE_TIME * 0.8).to({
          alpha: 0
        }, this.self._EASE_TIME * 0.2).call(this._completeHandler).addEventListener("change", this._changeHandler);
      };

      Item.prototype._changeHandler = function(e) {
        this._power_x *= this.self._KV;
        this._power_y *= this.self._KV;
        this._power_y += this.self._G;
        this.x += this._power_x;
        this.y += this._power_y;
      };

      Item.prototype._completeHandler = function(e) {
        this._stage.removeChild(this);
      };

      return Item;

    })(createjs.Container);
  });

  namespace('display.scene.game', function() {
    var StatusBar;
    return StatusBar = (function(_super) {
      __extends(StatusBar, _super);

      function StatusBar(_at__assets, _at__scene_id) {
        this._assets = _at__assets;
        this._scene_id = _at__scene_id;
        this._statusChangeHandler = __bind(this._statusChangeHandler, this);
        this.init = __bind(this.init, this);
        StatusBar.__super__.constructor.call(this);
        this.self = StatusBar;
        this.init();
        return;
      }

      StatusBar.prototype.init = function() {
        var bm, i, label, pos, _i;
        this._player_data = data.PlayerData.getInstance();
        bm = new createjs.Bitmap(this._assets.getTag("status_bar_base", this._scene_id));
        this.addChild(bm);
        pos = [[dp(6), dp(2)], [dp(6), dp(23)], [dp(68), dp(2)], [dp(68), dp(23)]];
        this._param_labels = [];
        for (i = _i = 0; _i < 4; i = ++_i) {
          bm = new createjs.Bitmap(this._assets.getTag(_.str.sprintf("icon_item_%03d", i + 1), this._scene_id));
          bm.x = pos[i][0];
          bm.y = pos[i][1];
          this.addChild(bm);
          label = display.text.FontPac.getSmallNumberText();
          label.x = pos[i][0] + dp(22);
          label.y = pos[i][1] + dp(1);
          label.text = "000";
          this.addChild(label);
          this._param_labels.push(label);
        }
        this._level = display.text.FontPac.getNumberText();
        this._level.textAlign = "center";
        this._level.color = "#ffe3a0";
        this._level.x = dp(152);
        this._level.y = dp(16);
        this._level.text = this._player_data.getLevel();
        this.addChild(this._level);
        this._gauge = new display.scene.game.ExpGauge();
        this._gauge.x = dp(134);
        this._gauge.y = dp(39);
        this.addChild(this._gauge);
        bm = new createjs.Bitmap(this._assets.getTag("icon_dngr", this._scene_id));
        bm.x = Main.STAGE_WIDTH - bm.image.width - dp(40);
        bm.y = dp(2);
        this.addChild(bm);
        this._gold = display.text.FontPac.getNumberText();
        this._gold.x = Main.STAGE_WIDTH - bm.image.width - dp(42);
        this._gold.y = dp(1);
        this._gold.textAlign = "right";
        this.addChild(this._gold);
        bm = new createjs.Bitmap(this._assets.getTag("icon_gem", this._scene_id));
        bm.x = Main.STAGE_WIDTH - bm.image.width - dp(40);
        bm.y = dp(24);
        this.addChild(bm);
        this._gold_sp = display.text.FontPac.getNumberText();
        this._gold_sp.x = Main.STAGE_WIDTH - bm.image.width - dp(42);
        this._gold_sp.y = dp(22);
        this._gold_sp.textAlign = "right";
        this.addChild(this._gold_sp);
        util.EventDispatcher.getInstance().addEventListener(Event.PLAYER_STATUS_CHANGE, this._statusChangeHandler);
        this._statusChangeHandler();
      };

      StatusBar.prototype._statusChangeHandler = function(e) {
        var exp, exp_comp;
        exp = this._player_data.getExp();
        exp_comp = this._player_data.getCompExp();
        this._gauge.setExp(exp, exp_comp);
        if (this._level.text !== this._player_data.getLevel()) {
          display.ui.DialogView.info(this.parent, _.str.sprintf(__("alert_level_up"), Config.STATUS_UP_CYCLE_LEVEL), {
            duration: 2000,
            position_x: 0,
            position_y: dp(45)
          });
          this._level.text = this._player_data.getLevel();
        }
        this._param_labels[0].text = _.str.sprintf("%03d", this._player_data.getIntelligence());
        this._param_labels[1].text = _.str.sprintf("%03d", this._player_data.getAccuracy());
        this._param_labels[2].text = _.str.sprintf("%03d", this._player_data.getCharm());
        this._param_labels[3].text = _.str.sprintf("%03d", this._player_data.getLuck());
        this._gold.text = this._player_data.getGold();
        this._gold_sp.text = this._player_data.getSpecialGold();
      };

      return StatusBar;

    })(createjs.Container);
  });

  namespace('display.scene.game', function() {
    var TimeBoard;
    return TimeBoard = (function(_super) {
      __extends(TimeBoard, _super);

      TimeBoard._DEFAULT_TEXT = "00:00:00";

      TimeBoard._TIMER_PRODUCT_ID = 6;

      TimeBoard._DIALOG_WIDTH = dp(240);

      TimeBoard._DIALOG_HEIGHT = dp(90);

      TimeBoard._DIALOG_MARGIN = dp(10);

      function TimeBoard(_at__assets, _at__scene_id) {
        this._assets = _at__assets;
        this._scene_id = _at__scene_id != null ? _at__scene_id : "game";
        this._makeTimerSuccessContainer = __bind(this._makeTimerSuccessContainer, this);
        this._isActive = __bind(this._isActive, this);
        this.setStatus = __bind(this.setStatus, this);
        this.setText = __bind(this.setText, this);
        this.init = __bind(this.init, this);
        TimeBoard.__super__.constructor.call(this);
        this._self = TimeBoard;
        this._status = display.scene.game.TrapStage.STATUS_READY;
        this._lock = false;
        this.init();
        return;
      }

      TimeBoard.prototype.init = function() {
        var bitmap, bm, bm_on, comp_button, label, stop_button;
        this._shop_data = data.ShopData.getInstance();
        bitmap = this._assets.getTag("time_base", this._scene_id);
        this.addChild(new createjs.Bitmap(bitmap));
        this.regX = bitmap.width / 2;
        label = display.text.FontPac.getText();
        label.text = __("game_standby_time");
        label.textAlign = "center";
        label.x = bitmap.width / 2;
        label.y = dp(10);
        this.addChild(label);
        this._time = display.text.FontPac.getTimeText();
        this._time.text = this._self._DEFAULT_TEXT;
        this._time.textAlign = "center";
        this._time.x = bitmap.width / 2;
        this._time.y = dp(28);
        this.addChild(this._time);
        bm = new createjs.Bitmap(this._assets.getTag("button_time_stop", this._scene_id));
        bm_on = new createjs.Bitmap(this._assets.getTag("button_time_stop_on", this._scene_id));
        stop_button = new display.ui.DisplayStateButton(bm, bm_on);
        stop_button.x = bitmap.width - bm.image.width - dp(10);
        stop_button.y = bitmap.height + dp(10);
        stop_button.addEventListener("click", (function(_this) {
          return function(e) {
            if (_this._isActive()) {
              display.ui.DialogView.confirm(null, __("game_button_stop"), function(is_ok) {
                if (is_ok && _this._isActive()) {
                  _this._lock = true;
                  util.EventDispatcher.getInstance().dispatchEvent(Event.ENEMY_AMBUSH_STOP);
                  plugin.Flurry.getInstance().logEventWithParameters(Event.LOG_BUTTON_TAP, {
                    status: "stop"
                  });
                }
              });
            }
          };
        })(this));
        this.addChild(stop_button);
        bm = new createjs.Bitmap(this._assets.getTag("button_time_comp", this._scene_id));
        bm_on = new createjs.Bitmap(this._assets.getTag("button_time_comp_on", this._scene_id));
        comp_button = new display.ui.DisplayStateButton(bm, bm_on);
        comp_button.x = dp(10);
        comp_button.y = bitmap.height + dp(10);
        comp_button.addEventListener("click", (function(_this) {
          return function(e) {
            var options, product;
            if (_this._isActive()) {
              product = _this._shop_data.getProductById(_this._self._TIMER_PRODUCT_ID);
              if (product.count > 0) {
                options = {
                  window_round: dp(3),
                  window_gradience: ["#000", "#000"],
                  width: _this._self._DIALOG_WIDTH,
                  height: _this._self._DIALOG_HEIGHT
                };
                display.ui.DialogView.confirm(null, _this._makeTimerSuccessContainer(), options, function(is_ok) {
                  if (is_ok && _this._isActive()) {
                    _this._shop_data.payCountById(_this._self._TIMER_PRODUCT_ID, 1);
                    _this._lock = true;
                    util.EventDispatcher.getInstance().dispatchEvent(Event.ENEMY_AMBUSH_COMPLETE);
                    plugin.Flurry.getInstance().logEventWithParameters(Event.LOG_BUTTON_TAP, {
                      status: "timer"
                    });
                  }
                });
              } else {
                display.ui.DialogView.alert(null, __("game_button_timer_error"));
              }
            }
          };
        })(this));
        this.addChild(comp_button);
      };

      TimeBoard.prototype.setText = function(text) {
        var _ref4, _ref5;
        if (text == null) {
          text = this._self._DEFAULT_TEXT;
        }
        if (text) {
          if ((_ref4 = this._time) != null) {
            _ref4.text = text;
          }
        } else {
          if ((_ref5 = this._time) != null) {
            _ref5.text = this._self._DEFAULT_TEXT;
          }
        }
      };

      TimeBoard.prototype.setStatus = function(num) {
        this._status = num;
        this._lock = false;
      };

      TimeBoard.prototype._isActive = function() {
        return this._status === display.scene.game.TrapStage.STATUS_WAIT && !this._lock;
      };

      TimeBoard.prototype._makeTimerSuccessContainer = function() {
        var container, item_clip, item_icon, number_field, product, text_field, text_width;
        container = new createjs.Container();
        item_icon = new createjs.Bitmap(this._assets.getTag(_.str.sprintf("item_%03d", this._self._TIMER_PRODUCT_ID), this._scene_id));
        item_icon.x = this._self._DIALOG_WIDTH / 2 - item_icon.image.width - this._self._DIALOG_MARGIN;
        item_icon.y = 0;
        item_clip = new createjs.Shape();
        item_clip.graphics.beginFill("#000").drawRoundRect(item_icon.x, item_icon.y, item_icon.image.width, item_icon.image.height, dp(6));
        item_icon.mask = item_clip;
        product = this._shop_data.getProductById(this._self._TIMER_PRODUCT_ID);
        number_field = display.text.FontPac.getNumberText();
        number_field.text = _.str.sprintf("x %d", product.count);
        number_field.x = this._self._DIALOG_WIDTH / 2;
        number_field.y = item_icon.image.height - dp(18);
        text_width = this._self._DIALOG_WIDTH - this._self._DIALOG_MARGIN * 2;
        text_field = display.text.FontPac.getText();
        text_field.textAlign = "center";
        text_field.x = this._self._DIALOG_MARGIN + text_width / 2;
        text_field.y = item_icon.image.height + this._self._DIALOG_MARGIN;
        text_field.text = __("game_button_timer_success");
        text_field.lineWidth = text_width;
        text_field.lineHeight = dp(14);
        display.text.FontPac.textFieldWithLineFeedByLineWidth(text_field);
        container.addChild(item_icon);
        container.addChild(number_field);
        container.addChild(text_field);
        return container;
      };

      return TimeBoard;

    })(createjs.Container);
  });

  namespace('display.scene.game', function() {
    var TrapStage;
    return TrapStage = (function(_super) {
      __extends(TrapStage, _super);

      TrapStage.STATUS_READY = 0;

      TrapStage.STATUS_WAIT = 1;

      TrapStage.STATUS_CAPTURE = 2;

      TrapStage._SIDE_MARGIN = dp(10);

      TrapStage._BOTTOM_MARGIN = dp(20);

      TrapStage._COL_MAX_COUNT = 8;

      TrapStage._ROW_COUNT = 5;

      TrapStage._SOUND_STEP = 5;

      TrapStage._SOUND_LENGTH = 500;

      TrapStage.prototype._traps = [];

      TrapStage.prototype._enemies = [];

      TrapStage.prototype._status = TrapStage.STATUS_READY;

      TrapStage.prototype._pre_status = TrapStage.STATUS_READY - 1;

      TrapStage.prototype._container = null;

      TrapStage.prototype._skip_timer = false;

      TrapStage.prototype._cut_count = 0;

      function TrapStage(_at__assets, _at__width, _at__height, _at__scene_id) {
        this._assets = _at__assets;
        this._width = _at__width != null ? _at__width : Main.STAGE_WIDTH;
        this._height = _at__height != null ? _at__height : Main.STAGE_HEIGHT;
        this._scene_id = _at__scene_id != null ? _at__scene_id : "game";
        this._showComplete = __bind(this._showComplete, this);
        this._showGetEnemy = __bind(this._showGetEnemy, this);
        this._showBaitListHandler = __bind(this._showBaitListHandler, this);
        this._hitCheck = __bind(this._hitCheck, this);
        this._clearSwipeEvent = __bind(this._clearSwipeEvent, this);
        this._swipeMoveEventHandler = __bind(this._swipeMoveEventHandler, this);
        this._swipeStartEventHandler = __bind(this._swipeStartEventHandler, this);
        this._setSwipeEvent = __bind(this._setSwipeEvent, this);
        this._clearEnemies = __bind(this._clearEnemies, this);
        this._makeEnemies = __bind(this._makeEnemies, this);
        this._makeEnemiesData = __bind(this._makeEnemiesData, this);
        this._clearBaits = __bind(this._clearBaits, this);
        this._setBaits = __bind(this._setBaits, this);
        this._setBaitHandler = __bind(this._setBaitHandler, this);
        this._clearTraps = __bind(this._clearTraps, this);
        this._makeTraps = __bind(this._makeTraps, this);
        this._capturedAllHandler = __bind(this._capturedAllHandler, this);
        this._capturedHandler = __bind(this._capturedHandler, this);
        this._preCaptureHandler = __bind(this._preCaptureHandler, this);
        this._hitedAllHandler = __bind(this._hitedAllHandler, this);
        this._hitedHandler = __bind(this._hitedHandler, this);
        this._startTapHandler = __bind(this._startTapHandler, this);
        this._trapCountChangeHandler = __bind(this._trapCountChangeHandler, this);
        this._ambushCompleteHandler = __bind(this._ambushCompleteHandler, this);
        this._ambushStopHandler = __bind(this._ambushStopHandler, this);
        this._ambushStartHandler = __bind(this._ambushStartHandler, this);
        this.update = __bind(this.update, this);
        this.init = __bind(this.init, this);
        TrapStage.__super__.constructor.call(this);
        this._self = TrapStage;
        this.init();
        return;
      }

      TrapStage.prototype.init = function() {
        var bg, bitmap, bitmap_on, bm;
        bg = new createjs.Shape();
        bg.graphics.beginFill("#FFF").drawRect(dp(0), dp(0), this._width, this._height);
        bg.alpha = 0.01;
        this.addChild(bg);
        this._player_data = data.PlayerData.getInstance();
        this._stage_data = data.StageData.getInstance();
        this._enemy_data = data.EnemyData.getInstance();
        this._shop_data = data.ShopData.getInstance();
        this._bait_data = data.BaitData.getInstance();
        SoundEffectManager.preScale("se_cut", 30);
        this._container = new createjs.Container();
        this.addChild(this._container);
        this._makeTraps();
        this._setBaits(this._player_data.getBait());
        bitmap = this._assets.getTag("button_start", this._scene_id);
        bm = new createjs.Bitmap(bitmap);
        this._start_button = new display.ui.DisplayStateButton(bm, new createjs.Bitmap(this._assets.getTag("button_start_on", this._scene_id)));
        this._start_button.width = bitmap.width;
        this._start_button.height = bitmap.height;
        this._start_button.regX = this._start_button.width / 2;
        this._start_button.x = this._width / 2;
        this._start_button.y = this._height * 0.25;
        this._start_button.visible = false;
        this._start_button.addEventListener("click", this._startTapHandler);
        this.addChild(this._start_button);
        this._time_board = new display.scene.game.TimeBoard(this._assets, this._scene_id);
        this._time_board.x = this._width / 2;
        this._time_board.y = this._height * 0.2;
        this._time_board.visible = false;
        this.addChild(this._time_board);
        bitmap = new createjs.Bitmap(this._assets.getTag("button_bait", this._scene_id));
        bitmap_on = new createjs.Bitmap(this._assets.getTag("button_bait_on", this._scene_id));
        this._button_bait = new display.ui.DisplayStateButton(bitmap, bitmap_on);
        this._button_bait.width = bitmap.image.width;
        this._button_bait.height = bitmap.image.height;
        this._button_bait.x = (Main.STAGE_WIDTH - bitmap.image.width) / 2;
        this._button_bait.y = Main.STAGE_HEIGHT - bitmap.image.height - dp(108);
        this._button_bait.addEventListener("click", this._showBaitListHandler);
        this.addChild(this._button_bait);
        this._event = util.EventDispatcher.getInstance();
        this._event.addEventListener(Event.ENEMY_HITED, this._hitedHandler);
        this._event.addEventListener(Event.ENEMY_ALL_HITED, this._hitedAllHandler);
        this._event.addEventListener(Event.ENEMY_PRE_CAPTURE, this._preCaptureHandler);
        this._event.addEventListener(Event.ENEMY_CAPTURED, this._capturedHandler);
        this._event.addEventListener(Event.ENEMY_ALL_CAPTURED, this._capturedAllHandler);
        this._event.addEventListener(Event.ENEMY_AMBUSH_START, this._ambushStartHandler);
        this._event.addEventListener(Event.ENEMY_AMBUSH_STOP, this._ambushStopHandler);
        this._event.addEventListener(Event.ENEMY_AMBUSH_COMPLETE, this._ambushCompleteHandler);
        this._event.addEventListener(Event.ENEMY_SET_BAIT, this._setBaitHandler);
        this._event.addEventListener(Event.PLAYER_STATUS_CHANGE, this._trapCountChangeHandler);
        this._status = this._player_data.getPhase();
        this.update();
      };

      TrapStage.prototype.update = function() {
        var enemy, filter_list, i, list, time, _i, _j, _k, _l, _len, _ref10, _ref11, _ref12, _ref4, _ref5, _ref6, _ref7, _ref8, _ref9;
        if (this._status !== this._pre_status) {
          this._player_data.setPhase(this._status);
          this._start_button.visible = false;
          this._time_board.visible = false;
          this._time_board.setStatus(this._status);
          this._button_bait.visible = false;
          this._clearSwipeEvent();
          this._skip_timer = false;
          this._cut_count = 0;
          plugin.LocalNotification.getInstance().removeAllNotification();
          switch (this._status) {
            case this._self.STATUS_READY:
              this._enemy_ids = null;
              this._player_data.clearTrap();
              this._start_button.visible = true;
              if (!this._player_data.getBait()) {
                this._button_bait.visible = true;
              }
              this._makeTraps();
              plugin.Flurry.getInstance().logEventWithParameters(Event.LOG_GAME_STATUS, {
                status: "ready"
              });
              break;
            case this._self.STATUS_WAIT:
              this._makeEnemies();
              this._time_board.visible = true;
              if (this._player_data.getRemainingTime() === null) {
                this._player_data.startTrap(this._enemy_ids, this._player_data.makeCurrentTime());
              }
              time = this._player_data.getFinishTime();
              plugin.LocalNotification.getInstance().addNotification({
                message: __("game_return_message"),
                date: Math.ceil(time / 1000)
              });
              plugin.Flurry.getInstance().logEventWithParameters(Event.LOG_GAME_STATUS, {
                status: "wait"
              });
              break;
            case this._self.STATUS_CAPTURE:
              if (this._enemies.length <= 0) {
                this._makeEnemies();
                for (i = _i = 0, _ref4 = this._enemies.length; 0 <= _ref4 ? _i < _ref4 : _i > _ref4; i = 0 <= _ref4 ? ++_i : --_i) {
                  if (0 < this._enemy_ids[i]) {
                    if (!((_ref5 = this._enemies[i]) != null ? _ref5.visible : void 0)) {
                      if ((_ref6 = this._enemies[i]) != null) {
                        _ref6.setToTrap();
                      }
                    }
                  } else {
                    this._traps[i].visible = false;
                  }
                }
              }
              this._setSwipeEvent();
              plugin.Flurry.getInstance().logEventWithParameters(Event.LOG_GAME_STATUS, {
                status: "capture"
              });
              break;
            default:
              console.log("error");
          }
        }
        this._pre_status = this._status;
        if (this._status === this._self.STATUS_WAIT) {
          if (!this._player_data.isValidTime()) {
            this._clearEnemies();
            this._clearTraps();
            this._status = this._self.STATUS_READY;
            return;
          }
          if (this._skip_timer) {
            for (i = _j = 0, _ref7 = this._enemies.length; 0 <= _ref7 ? _j < _ref7 : _j > _ref7; i = 0 <= _ref7 ? ++_j : --_j) {
              if (!((_ref8 = this._enemies[i]) != null ? _ref8.visible : void 0) && 0 < this._enemy_ids[i]) {
                if ((_ref9 = this._enemies[i]) != null) {
                  _ref9.moveToTrap(i * 100);
                }
              }
            }
            this._time_board.setText(0);
          } else {
            list = this._player_data.getTrapedList();
            filter_list = [];
            for (i = _k = 0, _ref10 = list.length; 0 <= _ref10 ? _k < _ref10 : _k > _ref10; i = 0 <= _ref10 ? ++_k : --_k) {
              if (!((_ref11 = this._enemies[i]) != null ? _ref11.visible : void 0) && 0 < this._enemy_ids[i]) {
                filter_list.push(this._enemies[i]);
              }
            }
            if (filter_list.length) {
              if (filter_list.length > 1) {
                for (_l = 0, _len = filter_list.length; _l < _len; _l++) {
                  enemy = filter_list[_l];
                  if (enemy != null) {
                    enemy.setToTrap();
                  }
                }
              } else {
                if ((_ref12 = filter_list[0]) != null) {
                  _ref12.moveToTrap();
                }
              }
            }
            this._time_board.setText(this._player_data.getRemainingText());
          }
          this._hitedHandler();
        }
      };

      TrapStage.prototype._ambushStartHandler = function(e) {
        this._status = this._self.STATUS_WAIT;
      };

      TrapStage.prototype._ambushStopHandler = function(e) {
        var active_enemies, enemy;
        active_enemies = (function() {
          var _i, _len, _ref4, _results;
          _ref4 = this._enemies;
          _results = [];
          for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
            enemy = _ref4[_i];
            if (enemy.visible) {
              _results.push(enemy);
            }
          }
          return _results;
        }).call(this);
        if (this._status === this._self.STATUS_WAIT && !this._skip_timer) {
          if (active_enemies.length > 0) {
            this._status = this._self.STATUS_CAPTURE;
          } else {
            this._status = this._self.STATUS_READY;
          }
        }
        this._player_data.clearTrap();
      };

      TrapStage.prototype._ambushCompleteHandler = function(e) {
        var active_enemies, enemy, wait_enemies;
        wait_enemies = (function() {
          var _i, _len, _ref4, _results;
          _ref4 = this._enemies;
          _results = [];
          for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
            enemy = _ref4[_i];
            if (!enemy.visible) {
              _results.push(enemy);
            }
          }
          return _results;
        }).call(this);
        active_enemies = this._player_data.getTrapedList();
        if (this._status === this._self.STATUS_WAIT && active_enemies.length < this._enemies.length && wait_enemies.length > 0) {
          this._skip_timer = true;
        }
      };

      TrapStage.prototype._trapCountChangeHandler = function(e) {
        if (this._status === this._self.STATUS_READY) {
          this._makeTraps();
          this._setBaits(this._player_data.getBait());
        }
      };

      TrapStage.prototype._startTapHandler = function(e) {
        util.EventDispatcher.getInstance().dispatchEvent(Event.ENEMY_AMBUSH_START);
        plugin.Flurry.getInstance().logEventWithParameters(Event.LOG_BUTTON_TAP, {
          status: "start"
        });
      };

      TrapStage.prototype._hitedHandler = function(e, enemy) {
        var filter_list;
        filter_list = (function() {
          var _i, _len, _ref4, _results;
          _ref4 = this._enemies;
          _results = [];
          for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
            enemy = _ref4[_i];
            if (enemy.isCutable()) {
              _results.push(enemy);
            }
          }
          return _results;
        }).call(this);
        if (filter_list.length === this._enemies.length) {
          this._event.dispatchEvent(Event.ENEMY_ALL_HITED);
        }
      };

      TrapStage.prototype._hitedAllHandler = function(e) {
        this._skip_timer = false;
        util.EventDispatcher.getInstance().dispatchEvent(Event.ENEMY_AMBUSH_STOP);
      };

      TrapStage.prototype._preCaptureHandler = function(e, enemy) {
        var bitmap_gold, bitmap_gold_sp, enemy_data, gold_count, gold_sp_count, index;
        index = Math.floor(Math.random() * this._self._SOUND_STEP);
        SoundEffectManager.playScale("se_cut", index * this._self._SOUND_LENGTH, this._self._SOUND_LENGTH);
        if ("enemy_index" in enemy && this._enemy_ids[enemy.enemy_index] > 0) {
          enemy_data = this._enemy_data.getEnemyById(this._enemy_ids[enemy.enemy_index]);
          if (enemy_data) {
            bitmap_gold = this._assets.getTag("icon_dngr", this._scene_id);
            bitmap_gold_sp = this._assets.getTag("icon_gem", this._scene_id);
            gold_count = this._player_data.makeCurrentItemCount(enemy_data.gold);
            gold_sp_count = this._player_data.makeCurrentItemCount(enemy_data.gold_sp);
            if (gold_count > 0) {
              new display.scene.game.Item(this, new createjs.Bitmap(bitmap_gold), enemy.x, enemy.y);
            }
            if (gold_sp_count > 0) {
              new display.scene.game.Item(this, new createjs.Bitmap(bitmap_gold_sp), enemy.x, enemy.y);
            }
          }
        }
      };

      TrapStage.prototype._capturedHandler = function(e, enemy) {
        var check_complete, enemy_data, filter_list, gold, gold_sp;
        if ("enemy_index" in enemy && this._enemy_ids[enemy.enemy_index] > 0) {
          enemy_data = this._enemy_data.getEnemyById(this._enemy_ids[enemy.enemy_index]);
          if (enemy_data) {
            gold = this._player_data.makeCurrentItemCount(enemy_data.gold);
            gold_sp = this._player_data.makeCurrentItemCount(enemy_data.gold_sp);
            check_complete = false;
            if (enemy_data.count <= 0) {
              check_complete = true;
              if (enemy_data.bait > 0) {
                this._showGetEnemy(enemy_data);
              }
            }
            this._enemy_data.addCountById(enemy_data.id);
            this._player_data.addExp(gold);
            this._player_data.addGold(gold);
            this._player_data.addSpecialGold(gold_sp);
            if (gold_sp > 0) {
              display.ui.DialogView.info(this.parent, __("alert_get_gem"), {
                duration: 2000,
                position_x: 0,
                position_y: dp(45)
              });
            }
            util.EventDispatcher.getInstance().dispatchEvent(Event.PLAYER_STATUS_CHANGE);
            if (check_complete && this._enemy_data.isComplete()) {
              this._showComplete();
            }
          }
          this._enemy_ids[enemy.enemy_index] = 0;
          this._player_data.setAllTrapedList(this._enemy_ids);
        }
        filter_list = (function() {
          var _i, _len, _ref4, _results;
          _ref4 = this._enemies;
          _results = [];
          for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
            enemy = _ref4[_i];
            if (!enemy.visible) {
              _results.push(enemy);
            }
          }
          return _results;
        }).call(this);
        if (filter_list.length === this._enemies.length) {
          this._event.dispatchEvent(Event.ENEMY_ALL_CAPTURED);
        }
      };

      TrapStage.prototype._capturedAllHandler = function(e) {
        this._status = this._self.STATUS_READY;
      };

      TrapStage.prototype._makeTraps = function(trap_image) {
        var bitmap, bm, cell_width, col, count, count_max, i, j, margin, row, _i, _j, _ref4;
        if (trap_image == null) {
          trap_image = "trap";
        }
        bitmap = this._assets.getTag(trap_image, this._scene_id);
        row = this._self._ROW_COUNT;
        col = this._self._COL_MAX_COUNT;
        margin = this._self._SIDE_MARGIN;
        cell_width = (Main.STAGE_WIDTH - margin * 2) / col;
        count = 0;
        count_max = this._player_data.getCaptureNum();
        this._clearTraps();
        for (i = _i = 0; 0 <= row ? _i < row : _i > row; i = 0 <= row ? ++_i : --_i) {
          for (j = _j = 0, _ref4 = col - i; 0 <= _ref4 ? _j < _ref4 : _j > _ref4; j = 0 <= _ref4 ? ++_j : --_j) {
            if (count < count_max) {
              count += 1;
              bm = new createjs.Bitmap(bitmap);
              bm.regX = bm.image.width / 2;
              bm.regY = bm.image.height;
              bm.x = Math.floor(j * cell_width + margin + cell_width / 2 * (i + 1));
              bm.y = this._height - this._self._BOTTOM_MARGIN - i * bm.image.height;
              this._container.addChild(bm);
              this._traps.push(bm);
            }
          }
        }
      };

      TrapStage.prototype._clearTraps = function() {
        var trap, _i, _len, _ref4;
        this._clearBaits();
        _ref4 = this._traps;
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          trap = _ref4[_i];
          this._container.removeChild(trap);
        }
        this._traps = [];
      };

      TrapStage.prototype._setBaitHandler = function(e, bait_id) {
        this._setBaits(bait_id);
      };

      TrapStage.prototype._setBaits = function(bait_id) {
        var bitmap, bm, trap, _i, _len, _ref4, _ref5;
        if (!bait_id) {
          return;
        }
        this._clearBaits();
        bitmap = this._assets.getTag(_.str.sprintf("bait_%03d", bait_id), this._scene_id);
        _ref4 = this._traps;
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          trap = _ref4[_i];
          bm = new createjs.Bitmap(bitmap);
          bm.regX = bitmap.width / 2;
          bm.regY = bitmap.height;
          bm.x = trap.x;
          bm.y = trap.y;
          trap._bait = bm;
          this._container.addChild(bm);
        }
        this._player_data.setBait(bait_id);
        if ((_ref5 = this._button_bait) != null) {
          _ref5.visible = false;
        }
      };

      TrapStage.prototype._clearBaits = function() {
        var trap, _i, _len, _ref4;
        _ref4 = this._traps;
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          trap = _ref4[_i];
          if (trap._bait) {
            this._container.removeChild(trap._bait);
          }
        }
      };

      TrapStage.prototype._makeEnemiesData = function() {
        return this._player_data.makeCurrentEnemies();
      };

      TrapStage.prototype._makeEnemies = function() {
        var bitmap, bitmap_net, bm, bm_net, enemy, i, trap, _i, _len, _ref4;
        this._enemy_ids = this._player_data.getAllTrapedList();
        if (this._enemy_ids === null) {
          this._enemy_ids = this._makeEnemiesData();
        }
        this._clearEnemies();
        bitmap_net = this._assets.getTag("trapup", this._scene_id);
        _ref4 = this._traps;
        for (i = _i = 0, _len = _ref4.length; _i < _len; i = ++_i) {
          trap = _ref4[i];
          bitmap = this._assets.getTag(_.str.sprintf("animal_%03d", this._enemy_ids[i]), this._scene_id);
          bm = new createjs.Bitmap(bitmap);
          bm_net = new createjs.Bitmap(bitmap_net);
          enemy = new display.scene.game.Enemy(bm, bm_net, trap);
          enemy.x = this._width / 2;
          enemy.visible = false;
          enemy.enemy_index = i;
          this._container.addChild(enemy);
          this._enemies.push(enemy);
        }
      };

      TrapStage.prototype._clearEnemies = function() {
        var enemy, _i, _len, _ref4;
        _ref4 = this._enemies;
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          enemy = _ref4[_i];
          enemy.removeAllChildren();
          enemy.removeAllEventListeners();
          this.removeChild(enemy);
        }
        this._enemies = [];
      };

      TrapStage.prototype._setSwipeEvent = function() {
        this.addEventListener("mousedown", this._swipeStartEventHandler);
      };

      TrapStage.prototype._swipeStartEventHandler = function(down_event) {
        this._down_event = down_event;
        this._hitCheck(this._down_event.stageX, this._down_event.stageY, true);
        this._down_event.addEventListener("mousemove", this._swipeMoveEventHandler);
      };

      TrapStage.prototype._swipeMoveEventHandler = function(move_event) {
        this._hitCheck(move_event.stageX, move_event.stageY);
      };

      TrapStage.prototype._clearSwipeEvent = function() {
        var _ref4;
        if ((_ref4 = this._down_event) != null) {
          _ref4.removeEventListener("mousemove", this._swipeMoveEventHandler);
        }
        this.removeEventListener("mousedown", this._swipeStartEventHandler);
      };

      TrapStage.prototype._hitCheck = function(x, y, is_down) {
        var enemy, i, local_pos, max_x, min_x, pos, _i, _len, _ref4, _ref5;
        if (is_down == null) {
          is_down = false;
        }
        if (this._status !== this._self.STATUS_CAPTURE) {
          return;
        }
        pos = this.globalToLocal(x, y);
        min_x = Math.min(Math.floor(pos.x), Math.floor(this._pre_x));
        max_x = Math.max(Math.floor(pos.x), Math.floor(this._pre_x));
        _ref4 = this._enemies;
        for (i = _i = 0, _len = _ref4.length; _i < _len; i = ++_i) {
          enemy = _ref4[i];
          if (this._enemy_ids[enemy.enemy_index] > 0) {
            local_pos = enemy.globalToLocal(x, y);
            if (enemy.hitTest(local_pos.x, local_pos.y)) {
              enemy.cutTrap();
            }
            if (!is_down) {
              if ((min_x <= (_ref5 = enemy.x) && _ref5 <= max_x) && pos.y < enemy.y) {
                enemy.cutTrap();
              }
            }
          }
        }
        this._pre_x = pos.x;
      };

      TrapStage.prototype._showBaitListHandler = function(e) {
        var bait, baits, has_bait, _i, _len;
        has_bait = false;
        baits = this._bait_data.getBaits();
        for (_i = 0, _len = baits.length; _i < _len; _i++) {
          bait = baits[_i];
          if (bait.count > 0) {
            has_bait = true;
            break;
          }
        }
        if (has_bait) {
          Main.getInstance().showModal("bait");
          plugin.Flurry.getInstance().logEventWithParameters(Event.LOG_BUTTON_TAP, {
            type: "bait"
          });
        } else {
          display.ui.DialogView.alert(null, __("game_set_bait_error"));
        }
      };

      TrapStage.prototype._showGetEnemy = function(enemy) {
        var bitmap, bm, container, label, options;
        options = {
          window_round: dp(3),
          window_gradience: ['#e0d5c1', '#e0d5c1'],
          width: dp(150),
          height: dp(120)
        };
        container = new createjs.Container();
        bitmap = this._assets.getTag("rising_sun", this._scene_id);
        bm = new createjs.Bitmap(bitmap);
        container.addChild(bm);
        bitmap = this._assets.getTag(_.str.sprintf("animal_%03d", enemy.id), this._scene_id);
        bm = new createjs.Bitmap(bitmap);
        bm.regX = bm.image.width / 2;
        bm.regY = bm.image.height / 2;
        bm.x = options.width / 2;
        bm.y = options.height / 2;
        container.addChild(bm);
        label = display.text.FontPac.getText();
        label.text = _.str.sprintf(__('game_enemy_get_message'), enemy.name);
        label.textAlign = 'center';
        label.color = '#330000';
        label.x = options.width / 2;
        label.y = options.height - dp(20);
        label.shadow = new createjs.Shadow("#000000", 0, 0, 5);
        container.addChild(label);
        display.ui.DialogView.alert(null, container, options);
      };

      TrapStage.prototype._showComplete = function() {
        var bitmap, bm, container, options;
        options = {
          window_round: dp(0),
          window_gradience: ['#e0d5c1', '#e0d5c1'],
          width: Main.STAGE_WIDTH,
          height: Main.STAGE_HEIGHT
        };
        container = new createjs.Container();
        bitmap = this._assets.getTag("complete_card", this._scene_id);
        bm = new createjs.Bitmap(bitmap);
        bm.regY = bm.image.height;
        bm.y = Main.STAGE_HEIGHT;
        container.addChild(bm);
        display.ui.DialogView.alert(null, container, options);
      };

      return TrapStage;

    })(createjs.Container);
  });


  /**
  * テーブルを作成する(このクラス自体は使わない)
  * @class テーブルを表示管理するクラスです
  * @param {TableView} table 配置されているテーブル
  * @param {Number} index Cellのインデックス番号
  * @param {Number} width テーブル全体の幅
  * @param {Number} height テーブル全体の高さ
   */

  namespace('display.scene.map', function() {
    var MapTableCellView;
    return MapTableCellView = (function(_super) {
      __extends(MapTableCellView, _super);

      MapTableCellView.prototype._base_tap_area = null;

      function MapTableCellView(_at__table) {
        this._table = _at__table;
        this._init = __bind(this._init, this);
        this.setData = __bind(this.setData, this);
        this._width = Main.STAGE_WIDTH;
        this._height = dp(71);
        MapTableCellView.__super__.constructor.call(this, this._table, this._width, this._height);
        this._assets = util.AssetsManager.getInstance();
        this._init();
        return;
      }


      /**
      	* Cellデータセット/更新
      	* @param {Object} data 表示データオブジェクト
       */

      MapTableCellView.prototype.setData = function(_at__data, _at__index) {
        var image, image_base;
        this._data = _at__data;
        this._index = _at__index;
        this._image_container.removeAllChildren();
        image_base = new createjs.Bitmap(this._assets.getTag("modal_image_base"));
        this._image_container.addChild(image_base);
        image = new createjs.Bitmap(this._assets.getTag(_.str.sprintf("map_image_%03d", this._data.id), "map"));
        image.x = dp(4);
        image.y = dp(4);
        this._image_container.addChild(image);
        this._icon_lock.visible = !this._data.active;
        this._icon_new.visible = this._data.is_new;
        this._title.text = this._data.name;
        this._desc.text = this._data.desc;
        this._desc = display.text.FontPac.textFieldWithLineFeedByLineWidth(this._desc);
      };

      MapTableCellView.prototype._init = function() {
        var base;
        base = new createjs.Shape();
        base.graphics.beginFill("#FFF").drawRect(0, 0, this._width, this._height - dp(1));
        this.addChild(base);
        this._image_container = new createjs.Container();
        this._image_container.x = dp(6);
        this._image_container.y = dp(6);
        this.addChild(this._image_container);
        this._icon_lock = new createjs.Bitmap(this._assets.getTag("icon_key"));
        this._icon_lock.x = (dp(50) - this._icon_lock.image.width) / 2 + dp(10);
        this._icon_lock.y = (dp(50) - this._icon_lock.image.height) / 2 + dp(10);
        this.addChild(this._icon_lock);
        this._icon_new = new createjs.Bitmap(this._assets.getTag("icon_new"));
        this._icon_new.x = (dp(50) - this._icon_new.image.width) / 2 + dp(10);
        this._icon_new.y = dp(60) - this._icon_new.image.height;
        this.addChild(this._icon_new);
        this._title = display.text.FontPac.getTitleText();
        this._title.color = "#000";
        this._title.text = "";
        this._title.x = dp(70);
        this._title.y = dp(10);
        this.addChild(this._title);
        this._desc = display.text.FontPac.getText();
        this._desc.color = "#000";
        this._desc.text = "";
        this._desc.x = dp(70);
        this._desc.y = dp(32);
        this._desc.lineWidth = dp(200);
        this._desc.lineHeight = dp(14);
        this.addChild(this._desc);
      };

      return MapTableCellView;

    })(display.ui.TableCellView);
  });

  namespace('display.scene.shop', function() {
    var ItemImage;
    return ItemImage = (function(_super) {
      __extends(ItemImage, _super);

      ItemImage._SCENE_ID = "shop";

      ItemImage.prototype._image = null;

      ItemImage.prototype._bg = null;

      function ItemImage(assets) {
        this.setImage = __bind(this.setImage, this);
        ItemImage.__super__.constructor.call(this);
        this._bg = new createjs.Bitmap(assets.getTag("modal_image_base", "global"));
        this.addChild(this._bg);
        this._image = new createjs.Bitmap();
        this.addChild(this._image);
        return;
      }

      ItemImage.prototype.setImage = function(image_tag) {
        this._image.image = image_tag;
        this._image.x = (this.height - this._image.image.height) / 2;
        return this._image.y = (this.width - this._image.image.width) / 2;
      };

      ItemImage.define('width', {
        get: function() {
          return this._bg.image.width;
        }
      });

      ItemImage.define('height', {
        get: function() {
          return this._bg.image.height;
        }
      });

      return ItemImage;

    })(createjs.Container);
  });

  namespace('display.scene.shop', function() {
    var PurchaseButton;
    return PurchaseButton = (function(_super) {
      __extends(PurchaseButton, _super);

      PurchaseButton._SCENE_ID = "shop";

      PurchaseButton.prototype._price_field = null;

      PurchaseButton.prototype._currency_unit = null;

      PurchaseButton.prototype._enabled = true;

      PurchaseButton.prototype._soldout_display = null;

      function PurchaseButton(assets, click_handler) {
        this.setData = __bind(this.setData, this);
        var base_active_bmp, base_normal_bmp, donguri_bmp, gem_bmp, yen_bmp;
        PurchaseButton.__super__.constructor.call(this);
        this.self = PurchaseButton;
        base_active_bmp = new createjs.Bitmap(assets.getTag("button_buy_on", this.self._SCENE_ID));
        base_normal_bmp = new createjs.Bitmap(assets.getTag("button_buy", this.self._SCENE_ID));
        this._button_base = new display.ui.DisplayStateButton(base_normal_bmp, base_active_bmp);
        this._price_field = display.text.FontPac.getNumberText();
        donguri_bmp = new createjs.Bitmap(assets.getTag("button_buy_dngr", this.self._SCENE_ID));
        gem_bmp = new createjs.Bitmap(assets.getTag("button_buy_gem", this.self._SCENE_ID));
        yen_bmp = new createjs.Bitmap(assets.getTag("button_buy_en", this.self._SCENE_ID));
        this._currency_unit = new display.ui.StateImage(["donguri", "gem", "yen"], {
          "donguri": donguri_bmp,
          "gem": gem_bmp,
          "yen": yen_bmp
        });
        this._currency_unit.y = this._button_base.height * 0.45;
        this._currency_unit.x = dp(10);
        this._price_field.textAlign = "center";
        this._price_field.x = this._button_base.width * 0.65;
        this._price_field.y = this._button_base.height * 0.4;
        this._soldout_display = display.text.FontPac.getTitleText();
        this._soldout_display.text = "SOLD OUT";
        this._soldout_display.color = "#FFF";
        this._soldout_display.textAlign = "center";
        this._soldout_display.y = this._price_field.y;
        this._soldout_display.x = this._button_base.width * 0.5;
        this.addChild(this._button_base);
        this.addChild(this._currency_unit);
        this.addChild(this._price_field);
        this.addChild(this._soldout_display);
        this._button_base.addEventListener("mousedown", (function(_this) {
          return function(event) {
            event.target = _this;
            return click_handler(event);
          };
        })(this));
      }

      PurchaseButton.prototype.setData = function(price, currency) {
        if (price === "soldout") {
          this._soldout_display.visible = true;
          this._price_field.visible = false;
          return this._currency_unit.visible = false;
        } else {
          this._soldout_display.visible = false;
          this._price_field.visible = true;
          this._currency_unit.visible = true;
          this._price_field.text = price;
          return this._currency_unit.setState(currency);
        }
      };

      PurchaseButton.define('width', {
        get: function() {
          return this._button_base.width;
        }
      });

      PurchaseButton.define('height', {
        get: function() {
          return this._button_base.height;
        }
      });

      PurchaseButton.define('enabled', {
        get: function() {
          return this._enabled;
        },
        set: function(value) {
          this._enabled = value;
          return this._button_base.mouseEnabled = value;
        }
      });

      return PurchaseButton;

    })(createjs.Container);
  });

  namespace('display.scene.shop', function() {
    var TableCookCell;
    return TableCookCell = (function(_super) {
      __extends(TableCookCell, _super);

      TableCookCell.PURCHASE_BUTTON_INDEX = 2;

      TableCookCell.CELL_HEIGHT = dp(70);

      TableCookCell.SCENE_ID = "shop";

      TableCookCell.prototype._bg = null;

      TableCookCell.prototype._title_field = null;

      TableCookCell.prototype._purchase_button = null;

      TableCookCell.prototype._item_image = null;

      TableCookCell.prototype._lock_label = null;

      TableCookCell.prototype._monster1_image = null;

      TableCookCell.prototype._monster1_requirement_field = null;

      TableCookCell.prototype._monster2_image = null;

      TableCookCell.prototype._monster2_requirement_field = null;

      TableCookCell.prototype._new_label = null;

      TableCookCell.prototype._assets = util.AssetsManager.getInstance();

      TableCookCell.prototype._enemy_data = data.EnemyData.getInstance();

      function TableCookCell(_at__table) {
        this._table = _at__table;
        this._checkAffordable = __bind(this._checkAffordable, this);
        this._initContent = __bind(this._initContent, this);
        this.setData = __bind(this.setData, this);
        this.self = TableCookCell;
        TableCookCell.__super__.constructor.call(this, this._table, Main.STAGE_WIDTH, this.self.CELL_HEIGHT);
        this._initContent();
        return;
      }

      TableCookCell.prototype.setData = function(data, index) {
        var enemy1_data, enemy1_id, enemy2_data, enemy2_id, num_enemy1, num_enemy2, require1_satisfied, require2_satisfied, required_num_enemy1, required_num_enemy2;
        TableCookCell.__super__.setData.call(this, data, index);
        this._title_field.set({
          text: this._data.name
        });
        this._purchase_button.setData(this._data.gold, this._data.is_sp ? "gem" : "donguri");
        this._item_image.setImage(this._assets.getTag(_.str.sprintf("bait_%03d", data.id), this.self.SCENE_ID));
        this._new_label.visible = this._data.is_new;
        enemy1_data = this._enemy_data.getEnemyById(data.cost[0][0]);
        enemy2_data = this._enemy_data.getEnemyById(data.cost[1][0]);
        num_enemy1 = enemy1_data.count;
        num_enemy2 = enemy2_data.count;
        required_num_enemy1 = data.cost[0][1];
        required_num_enemy2 = data.cost[1][1];
        require1_satisfied = num_enemy1 >= required_num_enemy1;
        require2_satisfied = num_enemy2 >= required_num_enemy2;
        this._monster1_requirement_field.color = require1_satisfied ? "#000" : "#f00";
        this._monster2_requirement_field.color = require2_satisfied ? "#000" : "#f00";
        this._monster1_requirement_field.text = (Math.min(num_enemy1, 99)) + "/" + (Math.min(required_num_enemy1, 99));
        this._monster2_requirement_field.text = (Math.min(num_enemy2, 99)) + "/" + (Math.min(required_num_enemy2, 99));

        /*@_monster1_requirement_field.text = "88/88"
        		@_monster2_requirement_field.text = "88/88"
         */
        if (enemy1_data.total_count > 0) {
          enemy1_id = _.string.sprintf("%03d", data.cost[0][0]);
          this._monster1_image.image = this._assets.getTag("animal_" + enemy1_id, "game");
        } else {
          this._monster1_image.image = this._assets.getTag("animal_nodata", "global");
        }
        if (enemy2_data.total_count > 0) {
          enemy2_id = _.string.sprintf("%03d", data.cost[1][0]);
          this._monster2_image.image = this._assets.getTag("animal_" + enemy2_id, "game");
        } else {
          this._monster2_image.image = this._assets.getTag("animal_nodata", "global");
        }
        if (this._checkAffordable(this._data) && require1_satisfied && require2_satisfied) {
          this.alpha = 1;
          return this._purchase_button.enabled = true;
        } else {
          this.alpha = 0.6;
          return this._purchase_button.enabled = false;
        }
      };

      TableCookCell.prototype._initContent = function() {
        var plus;
        this._bg = new createjs.Shape();
        this._bg.graphics.beginBitmapFill(this._assets.getTag("modal_base", "global")).drawRect(0, dp(1), this.width, this.height - dp(2));
        this._purchase_button = new display.scene.shop.PurchaseButton(this._assets, this._onTouchDown);
        this._purchase_button.x = this.width - this._purchase_button.width - dp(10);
        this._purchase_button.y = dp(10);
        this._title_field = display.text.FontPac.getTitleText();
        this._title_field.color = "#000";
        this._title_field.y = dp(10);
        this._item_image = new display.scene.shop.ItemImage(this._assets);
        this._item_image.x = dp(6);
        this._item_image.y = dp(6);
        this._title_field.x = this._item_image.x + this._item_image.width + dp(6);
        this._monster1_image = new createjs.Bitmap();
        this._monster2_image = new createjs.Bitmap();
        this._monster1_requirement_field = display.text.FontPac.getSmallNumberText();
        this._monster2_requirement_field = display.text.FontPac.getSmallNumberText();
        this._monster1_image.x = this._title_field.x;
        this._monster1_requirement_field.x = this._monster1_image.x + dp(25);
        this._monster2_image.x = this._title_field.x + dp(88);
        this._monster2_requirement_field.x = this._monster2_image.x + dp(25);
        this._monster1_requirement_field.textBaseline = this._monster2_requirement_field.textBaseline = "bottom";
        this._monster1_requirement_field.y = this._monster2_requirement_field.y = this.height - dp(10);
        this._monster1_image.scaleX = this._monster1_image.scaleY = this._monster2_image.scaleX = this._monster2_image.scaleY = 0.5;
        this._monster1_image.y = this._monster2_image.y = this._title_field.y + this._title_field.getMeasuredHeight() + dp(6);
        plus = display.text.FontPac.getTitleText();
        plus.color = "#000";
        plus.text = "+";
        plus.textBaseline = "bottom";
        plus.x = this._monster2_image.x - plus.getMeasuredWidth() - dp(3);
        plus.y = this._monster1_requirement_field.y;
        this._new_label = new createjs.Bitmap(this._assets.getTag("icon_new", "global"));
        this._new_label.x = (this._item_image.width - this._new_label.image.width) * 0.5;
        this._new_label.y = (this._item_image.height - this._new_label.image.height) * 0.5;
        this._item_image.addChild(this._new_label);
        this.addChild(this._bg);
        this.addChild(plus);
        this.addChild(this._title_field);
        this.addChild(this._monster1_image);
        this.addChild(this._monster2_image);
        this.addChild(this._monster1_requirement_field);
        this.addChild(this._monster2_requirement_field);
        this.addChild(this._item_image);
        return this.addChildAt(this._purchase_button, this.self.PURCHASE_BUTTON_INDEX);
      };

      TableCookCell.prototype._checkAffordable = function(item_data) {
        var player_data;
        player_data = data.PlayerData.getInstance();
        if (item_data.is_sp) {
          return player_data.getSpecialGold() >= item_data.gold;
        } else {
          return player_data.getGold() >= item_data.gold;
        }
      };

      return TableCookCell;

    })(display.ui.TableCellView);
  });

  namespace('display.scene.shop', function() {
    var TableDonguriCell;
    return TableDonguriCell = (function(_super) {
      __extends(TableDonguriCell, _super);

      TableDonguriCell.MAX_TRAP_COUNT = 15;

      TableDonguriCell.TRAP_PRODUCT_ID = 5;

      TableDonguriCell.PURCHASE_BUTTON_INDEX = 2;

      TableDonguriCell.CELL_HEIGHT = dp(70);

      TableDonguriCell.SCENE_ID = "shop";

      TableDonguriCell.prototype._bg = null;

      TableDonguriCell.prototype._title_field = null;

      TableDonguriCell.prototype._description_field = null;

      TableDonguriCell.prototype._purchase_button = null;

      TableDonguriCell.prototype._item_image = null;

      TableDonguriCell.prototype._new_label = null;

      TableDonguriCell.prototype._assets = util.AssetsManager.getInstance();

      function TableDonguriCell(_at__table) {
        this._table = _at__table;
        this._checkAffordable = __bind(this._checkAffordable, this);
        this._initContent = __bind(this._initContent, this);
        this.setData = __bind(this.setData, this);
        this.self = TableDonguriCell;
        TableDonguriCell.__super__.constructor.call(this, this._table, Main.STAGE_WIDTH, this.self.CELL_HEIGHT);
        this._initContent();
        return;
      }

      TableDonguriCell.prototype.setData = function(data, index) {
        var exceed_max;
        TableDonguriCell.__super__.setData.call(this, data, index);
        if (this._data.id === this.self.TRAP_PRODUCT_ID) {
          exceed_max = this._data.count >= this.self.MAX_TRAP_COUNT;
        } else {
          exceed_max = false;
        }
        this._title_field.set({
          text: this._data.name
        });
        this._purchase_button.setData((exceed_max ? "soldout" : this._data.gold), (this._data.is_sp ? "gem" : "donguri"));
        this._description_field.set({
          text: this._data.desc
        });
        display.text.FontPac.textFieldWithLineFeedByLineWidth(this._description_field);
        this._item_image.setImage(this._assets.getTag(_.str.sprintf("item_%03d", this._data.id), this.self.SCENE_ID));
        this._new_label.visible = this._data.is_new;
        if (this._checkAffordable(this._data) && !exceed_max) {
          this.alpha = 1;
          return this._purchase_button.enabled = true;
        } else {
          this.alpha = 0.6;
          return this._purchase_button.enabled = false;
        }
      };

      TableDonguriCell.prototype._initContent = function() {
        this._bg = new createjs.Shape();
        this._bg.graphics.beginBitmapFill(this._assets.getTag("modal_base", "global")).drawRect(0, dp(1), this.width, this.height - dp(2));
        this.addChild(this._bg);
        this._purchase_button = new display.scene.shop.PurchaseButton(this._assets, this._onTouchDown);
        this._purchase_button.x = this.width - this._purchase_button.width - dp(10);
        this._purchase_button.y = dp(10);
        this._title_field = display.text.FontPac.getTitleText();
        this._title_field.color = "#000";
        this._title_field.y = dp(10);
        this._description_field = display.text.FontPac.getText();
        this._description_field.color = "#000";
        this._description_field.textBaseline = "bottom";
        this._description_field.lineWidth = dp(140);
        this._description_field.lineHeight = dp(12);
        this._description_field.y = dp(45);
        this.addChild(this._title_field);
        this.addChild(this._description_field);
        this._item_image = new display.scene.shop.ItemImage(this._assets);
        this._item_image.x = dp(6);
        this._item_image.y = dp(6);
        this._title_field.x = this._description_field.x = this._item_image.x + this._item_image.width + dp(6);
        this.addChild(this._item_image);
        this._new_label = new createjs.Bitmap(this._assets.getTag("icon_new", "global"));
        this._new_label.x = (this._item_image.width - this._new_label.image.width) * 0.5;
        this._new_label.y = (this._item_image.height - this._new_label.image.height) * 0.5;
        this._item_image.addChild(this._new_label);
        return this.addChildAt(this._purchase_button, this.self.PURCHASE_BUTTON_INDEX);
      };

      TableDonguriCell.prototype._checkAffordable = function(item_data) {
        var player_data;
        player_data = data.PlayerData.getInstance();
        if (item_data.is_sp) {
          return player_data.getSpecialGold() >= item_data.gold;
        } else {
          return player_data.getGold() >= item_data.gold;
        }
      };

      return TableDonguriCell;

    })(display.ui.TableCellView);
  });

  namespace('display.scene.shop', function() {
    var TableGemCell;
    return TableGemCell = (function(_super) {
      __extends(TableGemCell, _super);

      function TableGemCell(_at__table) {
        this._table = _at__table;
        this._initContent = __bind(this._initContent, this);
        this.setData = __bind(this.setData, this);
        TableGemCell.__super__.constructor.call(this, this._table, dp(250), dp(70));
        this._initContent();
        return;
      }

      TableGemCell.prototype._dummy_bg = null;

      TableGemCell.prototype._dummy_text = null;

      TableGemCell.prototype._dummy_child1 = null;

      TableGemCell.prototype.setData = function(data, index) {
        var col;
        TableGemCell.__super__.setData.call(this, data, index);
        this._dummy_text.set({
          text: this._data.text
        });
        this.height = dp(70) + Math.random() * dp(70);
        this._dummy_bg.graphics.clear();
        col = Math.floor(Math.random() * parseInt("0xFFFFFF")).toString(16);
        this._dummy_bg.graphics.beginFill("#" + col).drawRect(dp(2), dp(2), this.width - dp(4), this.height - dp(4));
        return this._dummy_bg.alpha = 0.35;
      };

      TableGemCell.prototype._initContent = function() {
        var col;
        this._dummy_bg = new createjs.Shape();
        col = Math.floor(Math.random() * parseInt("0xFFFFFF")).toString(16);
        this._dummy_bg.graphics.beginFill("#" + col).drawRect(dp(2), dp(2), this.width - dp(4), this.height - dp(4));
        this._dummy_bg.alpha = 0.35;
        this.addChild(this._dummy_bg);
        this._dummy_child1 = new createjs.Shape();
        col = Math.floor(Math.random() * parseInt("0xFFFFFF")).toString(16);
        this._dummy_child1.graphics.beginFill("#" + col).drawRect(this.width / 2 + dp(5), dp(5), this.height - dp(10), this.height - dp(10));
        this.addChild(this._dummy_child1);
        this._dummy_text = new createjs.Text("", "30px san-serif", "#CCC");
        this.addChild(this._dummy_text);

        /*@_dummy_bg.addEventListener("mousedown", (event)=>
        			@_onTouchDown(event))
         */
        this._dummy_text.addEventListener("mousedown", (function(_this) {
          return function(event) {
            return _this._onTouchDown(event);
          };
        })(this));
        return this._dummy_child1.addEventListener("mousedown", (function(_this) {
          return function(event) {
            return _this._onTouchDown(event);
          };
        })(this));
      };

      return TableGemCell;

    })(display.ui.TableCellView);
  });

  namespace('display.scene', function() {
    var BaitScene;
    return BaitScene = (function(_super) {
      __extends(BaitScene, _super);

      BaitScene.SCENE_ID = "bait";

      function BaitScene() {
        this._tapEventHandler = __bind(this._tapEventHandler, this);
        this._hideModal = __bind(this._hideModal, this);
        this.tickHandler = __bind(this.tickHandler, this);
        this.init = __bind(this.init, this);
        BaitScene.__super__.constructor.call(this);
        this.self = BaitScene;
        return;
      }

      BaitScene.prototype.init = function(_at_assets) {
        var base, bitmap, bitmap_on, button, foot, head, table, title;
        this.assets = _at_assets;
        base = new createjs.Shape();
        base.graphics.beginFill("#e0d5c1").drawRect(0, 0, Main.STAGE_WIDTH, Main.STAGE_HEIGHT);
        this.addChild(base);
        bitmap = this.assets.getTag("modal_head");
        head = new createjs.Bitmap(bitmap);
        this.addChild(head);
        bitmap = this.assets.getTag("title", this.self.SCENE_ID);
        title = new createjs.Bitmap(bitmap);
        title.x = (Main.STAGE_WIDTH - title.image.width) / 2;
        title.y = (head.image.height - title.image.height) / 2;
        this.addChild(title);
        bitmap = this.assets.getTag("modal_foot");
        foot = new createjs.Bitmap(bitmap);
        foot.y = Main.STAGE_HEIGHT - foot.image.height;
        this.addChild(foot);
        bitmap = new createjs.Bitmap(this.assets.getTag("button_close"));
        bitmap_on = new createjs.Bitmap(this.assets.getTag("button_close_on"));
        button = new display.ui.DisplayStateButton(bitmap, bitmap_on);
        button.width = bitmap.image.width;
        button.height = bitmap.image.height;
        button.x = Main.STAGE_WIDTH - button.width;
        button.y = Main.STAGE_HEIGHT - button.height;
        button.addEventListener("click", this._hideModal);
        table = new display.ui.TableView(display.scene.map.BaitTableCellView, Main.STAGE_WIDTH, Main.STAGE_HEIGHT - head.image.height - button.height);
        table.y = head.image.height;
        this.addChild(table);
        this._stage_data = data.BaitData.getInstance();
        this._data = this._stage_data.getBaits();
        table.setData(this._data);
        util.EventDispatcher.getInstance().addEventListener(Event.TABLE_CELL_TAPPED, this._tapEventHandler);
        this.addChild(button);
      };

      BaitScene.prototype.tickHandler = function(delta) {};

      BaitScene.prototype._hideModal = function(e) {
        util.EventDispatcher.getInstance().removeEventListener(Event.TABLE_CELL_TAPPED, this._tapEventHandler);
        Main.getInstance().hideModal();
      };

      BaitScene.prototype._tapEventHandler = function(e, index) {
        var current_data;
        current_data = this._data[index];
        if ((current_data != null ? current_data.count : void 0) > 0) {
          display.ui.DialogView.confirm(null, _.str.sprintf(__("bait_set_confirm_message"), current_data.name), (function(_this) {
            return function(is_ok) {
              if (is_ok) {
                data.BaitData.getInstance().payCountById(current_data.id, 1);
                util.EventDispatcher.getInstance().dispatchEvent(Event.ENEMY_SET_BAIT, current_data.id);
                return _this._hideModal();
              }
            };
          })(this));
        }
      };

      return BaitScene;

    })(display.scene.BaseScene);
  });

  BookScene = (function(_super) {
    __extends(BookScene, _super);

    BookScene.SCENE_ID = "book";

    function BookScene() {
      this._hideModal = __bind(this._hideModal, this);
      this._changeScene = __bind(this._changeScene, this);
      this._presentModal = __bind(this._presentModal, this);
      this._footViewSetup = __bind(this._footViewSetup, this);
      this._mainViewSetup = __bind(this._mainViewSetup, this);
      this._headViewSetup = __bind(this._headViewSetup, this);
      this.tickHandler = __bind(this.tickHandler, this);
      this.init = __bind(this.init, this);
      BookScene.__super__.constructor.call(this);
      this.self = BookScene;
      this._player_data = data.PlayerData.getInstance();
      this.stage_id = this._player_data.getStage();
      this._stage_data = data.StageData.getInstance();
      this._enemy_data = data.EnemyData.getInstance();
      return;
    }

    BookScene.prototype.init = function(_at_assets) {
      this.assets = _at_assets;
      this._headViewSetup();
      this._mainViewSetup();
      this._footViewSetup();
    };

    BookScene.prototype.tickHandler = function(delta) {};

    BookScene.prototype._headViewSetup = function() {
      var head_base, title;
      this._headContainer = new createjs.Container();
      this._headContainer.x = 0;
      this._headContainer.y = 0;
      this.addChild(this._headContainer);
      head_base = new createjs.Bitmap(this.assets.getTag("modal_head", "global"));
      this._headContainer.addChild(head_base);
      title = new createjs.Bitmap(this.assets.getTag("title", this.self.SCENE_ID));
      title.x = (Main.STAGE_WIDTH - title.image.width) / 2;
      title.y = 0;
      return this._headContainer.addChild(title);
    };

    BookScene.prototype._mainViewSetup = function() {
      var base, beige_base, gold, green_base, i, silver, stagename, title_base, _count, _enemyContainer, _i, _img, _name, _new, _ref4, _results;
      this._stage_data_byid = this._stage_data.getStageById(this.stage_id);
      this._mainContainer = new createjs.Container();
      this._mainContainer.x = 0;
      this._mainContainer.y = dp(45);
      this.addChild(this._mainContainer);
      base = new createjs.Shape();
      base.graphics.beginFill("#e0d5c1").drawRect(0, 0, Main.STAGE_WIDTH, Main.STAGE_HEIGHT);
      this._mainContainer.addChild(base);
      title_base = new createjs.Bitmap(this.assets.getTag("book_title_base", this.self.SCENE_ID));
      title_base.y = dp(8);
      this._mainContainer.addChild(title_base);
      stagename = display.text.FontPac.getTitleText();
      stagename.text = this._stage_data_byid.name;
      stagename.x = (Main.STAGE_WIDTH - stagename.getMeasuredWidth()) / 2;
      stagename.y = dp(20);
      this._mainContainer.addChild(stagename);
      this._enemy_group = this._enemy_data.getEnemiesByGroup(this.stage_id);
      _results = [];
      for (i = _i = 0, _ref4 = this._enemy_group.length; 0 <= _ref4 ? _i < _ref4 : _i > _ref4; i = 0 <= _ref4 ? ++_i : --_i) {
        _enemyContainer = new createjs.Container();
        _enemyContainer.x = (dp(103) * (i % 3)) + dp(10);
        _enemyContainer.tag = this._enemy_group[i].id;
        this._ememy_data_byid = this._enemy_data.getEnemyById(_enemyContainer.tag);
        if (i < 3) {
          _enemyContainer.y = dp(60);
        } else {
          _enemyContainer.y = dp(195);
        }
        this._mainContainer.addChild(_enemyContainer);
        beige_base = new createjs.Shape();
        beige_base.graphics.beginFill("#b7a98c").drawRoundRect(0, 0, dp(89), dp(118), dp(8));
        _enemyContainer.addChild(beige_base);
        green_base = new createjs.Shape();
        green_base.graphics.beginFill("#93cb70").drawRoundRect(dp(10), dp(6), dp(70), dp(70), dp(70));
        _enemyContainer.addChild(green_base);
        if (this._ememy_data_byid.total_count > 0) {
          _img = new createjs.Bitmap(this.assets.getTag(_.str.sprintf("animal_%03d", this._ememy_data_byid.id), this.self.SCENE_ID));
        } else {
          _img = new createjs.Bitmap(this.assets.getTag("animal_nodata", "global"));
        }
        _img.x = dp(24);
        _img.y = dp(10);
        _enemyContainer.addChild(_img);
        if (this._ememy_data_byid.is_new) {
          _new = new createjs.Bitmap(this.assets.getTag("icon_new", "global"));
          _new.y = dp(10);
          _enemyContainer.new_sprite = _new;
          _enemyContainer.addChild(_new);
        }
        if (i === 4) {
          silver = new createjs.Bitmap(this.assets.getTag("icon_silver", this.self.SCENE_ID));
          silver.x = dp(5);
          silver.y = dp(70);
          _enemyContainer.addChild(silver);
        }
        if (i === 5) {
          gold = new createjs.Bitmap(this.assets.getTag("icon_gold", this.self.SCENE_ID));
          gold.x = dp(5);
          gold.y = dp(70);
          _enemyContainer.addChild(gold);
        }
        _name = display.text.FontPac.getText();
        _name.text = this._ememy_data_byid.name;
        _name.x = dp(5);
        _name.y = dp(85);
        _enemyContainer.addChild(_name);
        _count = display.text.FontPac.getText();
        _count.text = "×" + this._ememy_data_byid.total_count;
        _count.x = dp(5);
        _count.y = dp(100);
        _enemyContainer.addChild(_count);
        _results.push(_enemyContainer.addEventListener("click", (function(_this) {
          return function(e) {
            var _ref5, _ref6;
            _this._presentModal(e.target.tag);
            _this._enemy_data.clearIsNewById(e.target.tag);
            if ((_ref5 = e.target) != null) {
              if ((_ref6 = _ref5.new_sprite) != null) {
                _ref6.visible = false;
              }
            }
          };
        })(this)));
      }
      return _results;
    };

    BookScene.prototype._footViewSetup = function() {
      var bitmap, bitmap_on, button, foot_base, pagenum, _leftArrow, _rightArrow;
      this._stage_length = this._stage_data.getStageLength(this.stage_id);
      this._footContainer = new createjs.Container();
      this._footContainer.x = 0;
      this._footContainer.y = Main.STAGE_HEIGHT - dp(45);
      this.addChild(this._footContainer);
      foot_base = new createjs.Bitmap(this.assets.getTag("modal_foot", "global"));
      this._footContainer.addChild(foot_base);
      pagenum = new createjs.Text(this.stage_id + " ／ " + this._stage_length, dp(13) + "px Arial", "#000");
      pagenum.x = (Main.STAGE_WIDTH - pagenum.getMeasuredWidth()) / 2;
      pagenum.y = dp(18);
      this._footContainer.addChild(pagenum);
      _leftArrow = new createjs.Bitmap(this.assets.getTag("btn_left", this.self.SCENE_ID));
      _leftArrow.x = dp(70);
      _leftArrow.y = dp(10);
      this._footContainer.addChild(_leftArrow);
      if (this.stage_id <= 1) {
        _leftArrow.visible = false;
        _leftArrow.alpha = 0;
      }
      _leftArrow.addEventListener("click", (function(_this) {
        return function() {
          _this.stage_id -= 1;
          return _this._changeScene();
        };
      })(this));
      _rightArrow = new createjs.Bitmap(this.assets.getTag("btn_right", this.self.SCENE_ID));
      _rightArrow.x = Main.STAGE_WIDTH - dp(130);
      _rightArrow.y = dp(10);
      this._footContainer.addChild(_rightArrow);
      if (this.stage_id >= this._stage_length) {
        _rightArrow.visible = false;
        _rightArrow.alpha = 0;
      }
      _rightArrow.addEventListener("click", (function(_this) {
        return function() {
          _this.stage_id += 1;
          return _this._changeScene();
        };
      })(this));
      bitmap = new createjs.Bitmap(this.assets.getTag("button_close"));
      bitmap_on = new createjs.Bitmap(this.assets.getTag("button_close_on"));
      button = new display.ui.DisplayStateButton(bitmap, bitmap_on);
      button.width = bitmap.image.width;
      button.height = bitmap.image.height;
      button.x = Main.STAGE_WIDTH - button.width;
      button.y = 0;
      this._footContainer.addChild(button);
      button.addEventListener("click", this._hideModal);
    };

    BookScene.prototype._presentModal = function(id) {
      var box_container, box_height, box_width, desc, img, name, options;
      this._ememy_data_byid = this._enemy_data.getEnemyById(id);
      box_container = new createjs.Container();
      box_width = dp(180);
      box_height = dp(120);
      if (this._ememy_data_byid.total_count > 0) {
        img = new createjs.Bitmap(this.assets.getTag(_.str.sprintf("animal_%03d", id), this.self.SCENE_ID));
      } else {
        img = new createjs.Bitmap(this.assets.getTag("animal_nodata", "global"));
      }
      img.x = (box_width - img.image.width * img.scaleX) / 2;
      img.y = 0;
      box_container.addChild(img);
      name = display.text.FontPac.getTitleText();
      name.text = this._ememy_data_byid.name;
      name.x = dp(15);
      name.y = img.image.height * img.scaleY + dp(5);
      box_container.addChild(name);
      desc = display.text.FontPac.getText();
      desc.text = this._ememy_data_byid.desc;
      desc.lineWidth = box_width - dp(30);
      desc.lineHeight = dp(12);
      desc.x = dp(15);
      desc.y = img.image.height * img.scaleY + dp(25);
      display.text.FontPac.textFieldWithLineFeedByLineWidth(desc);
      box_container.addChild(desc);
      options = {
        window_round: dp(3),
        window_gradience: ["#000", "#000"],
        width: box_width,
        height: box_height
      };
      display.ui.DialogView.alert(null, box_container, options);
    };

    BookScene.prototype._changeScene = function() {
      this._mainContainer.removeAllChildren();
      this._footContainer.removeAllChildren();
      this._mainViewSetup();
      this._footViewSetup();
    };

    BookScene.prototype._hideModal = function(e) {
      Main.getInstance().hideModal();
    };

    return BookScene;

  })(display.scene.BaseScene);

  namespace('display.scene', function() {
    return BookScene;
  });

  namespace('display.scene', function() {
    var GameScene;
    return GameScene = (function(_super) {
      __extends(GameScene, _super);

      GameScene._SCENE_ID = "game";

      function GameScene() {
        this._changeBaseImage = __bind(this._changeBaseImage, this);
        this._playerStatusChangeHandler = __bind(this._playerStatusChangeHandler, this);
        this._mapChangeHandler = __bind(this._mapChangeHandler, this);
        this._openHelpHandler = __bind(this._openHelpHandler, this);
        this._menuTapHandler = __bind(this._menuTapHandler, this);
        this.tickHandler = __bind(this.tickHandler, this);
        this.init = __bind(this.init, this);
        GameScene.__super__.constructor.call(this);
        this._self = GameScene;
        this.dummy_count = 0;
        return;
      }

      GameScene.prototype.init = function(_at_assets) {
        var bitmap, bitmap_on, button, button_keys, i, left_pos, status_bar, _i, _len;
        this.assets = _at_assets;
        this._enemy_data = data.EnemyData.getInstance();
        this._stage_data = data.StageData.getInstance();
        this._bg_container = new createjs.Container();
        this.addChild(this._bg_container);
        this._changeBaseImage();
        button_keys = ["shop", "book", "map"];
        left_pos = 0;
        for (i = _i = 0, _len = button_keys.length; _i < _len; i = ++_i) {
          key = button_keys[i];
          bitmap = new createjs.Bitmap(this.assets.getTag("button_" + key, this._self._SCENE_ID));
          bitmap_on = new createjs.Bitmap(this.assets.getTag("button_" + key + "_on", this._self._SCENE_ID));
          button = new display.ui.DisplayStateButton(bitmap, bitmap_on);
          button.width = bitmap.image.width;
          button.height = bitmap.image.height;
          button.x = left_pos;
          left_pos += button.width;
          button.y = Main.STAGE_HEIGHT - bitmap.image.height;
          button.tag = key;
          button.addEventListener("click", this._menuTapHandler);
          this.addChild(button);
        }
        this._trap_stage = new display.scene.game.TrapStage(this.assets, Main.STAGE_WIDTH, Main.STAGE_HEIGHT - dp(95), this._self._SCENE_ID);
        this._trap_stage.y = dp(45);
        this.addChild(this._trap_stage);
        status_bar = new display.scene.game.StatusBar(this.assets, this._self._SCENE_ID);
        this.addChild(status_bar);
        bitmap = new createjs.Bitmap(this.assets.getTag("button_help", this._self._SCENE_ID));
        bitmap_on = new createjs.Bitmap(this.assets.getTag("button_help_on", this._self._SCENE_ID));
        button = new display.ui.DisplayStateButton(bitmap, bitmap_on);
        button.width = bitmap.image.width;
        button.height = bitmap.image.height;
        button.x = Main.STAGE_WIDTH - bitmap.image.width;
        button.addEventListener("click", this._openHelpHandler);
        this.addChild(button);
        this._event = util.EventDispatcher.getInstance();
        this._event.addEventListener(Event.MAP_CHANGE, this._mapChangeHandler);
        this._event.addEventListener(Event.PLAYER_STATUS_CHANGE, this._playerStatusChangeHandler);
        if (data.PlayerData.IS_FIRST_SESSION) {
          this._openHelpHandler();
        }
      };

      GameScene.prototype.tickHandler = function(delta) {
        var _ref4;
        if ((_ref4 = this._trap_stage) != null) {
          _ref4.update();
        }
      };

      GameScene.prototype._menuTapHandler = function(e) {
        Main.getInstance().showModal(e.target.tag);
        plugin.Flurry.getInstance().logEventWithParameters(Event.LOG_BUTTON_TAP, {
          type: e.target.tag
        });
      };

      GameScene.prototype._openHelpHandler = function(e) {
        var type;
        type = "tutorial";
        Main.getInstance().showModal(type);
        plugin.Flurry.getInstance().logEventWithParameters(Event.LOG_BUTTON_TAP, {
          type: type
        });
      };

      GameScene.prototype._mapChangeHandler = function(e) {
        this._event.dispatchEvent(Event.ENEMY_AMBUSH_STOP);
        this._changeBaseImage();
      };

      GameScene.prototype._playerStatusChangeHandler = function(e) {
        var ids, index, _ref4;
        if (this._enemy_data.hasBossEnemyByGroup(this._stage_id)) {
          ids = this._stage_data.getDataIds();
          index = ids.indexOf(this._stage_id) + 1;
          if (ids[index] && !((_ref4 = this._stage_data.getStageById(ids[index])) != null ? _ref4.active : void 0)) {
            this._stage_data.openStageById(ids[index]);
            display.ui.DialogView.info(this, __("alert_open_new_stage"), {
              duration: 2000,
              position_x: 0,
              position_y: dp(45)
            });
          }
        }
      };

      GameScene.prototype._changeBaseImage = function() {
        var bitmap;
        if (this._stage_base) {
          this._bg_container.removeChild(this._stage_base);
        }
        this._stage_id = data.PlayerData.getInstance().getStage();
        bitmap = this.assets.getTag(_.str.sprintf("game_base_%03d", this._stage_id), this._self._SCENE_ID);
        this._stage_base = new createjs.Bitmap(bitmap);
        this._stage_base.regY = bitmap.height;
        this._stage_base.y = Main.STAGE_HEIGHT;
        this._bg_container.addChild(this._stage_base);
      };

      return GameScene;

    })(display.scene.BaseScene);
  });

  namespace('display.scene', function() {
    var MapScene;
    return MapScene = (function(_super) {
      __extends(MapScene, _super);

      MapScene.SCENE_ID = "map";

      function MapScene() {
        this._tapEventHandler = __bind(this._tapEventHandler, this);
        this._hideModal = __bind(this._hideModal, this);
        this.tickHandler = __bind(this.tickHandler, this);
        this.init = __bind(this.init, this);
        MapScene.__super__.constructor.call(this);
        this.self = MapScene;
        return;
      }

      MapScene.prototype.init = function(_at_assets) {
        var base, bitmap, bitmap_on, button, foot, head, table, title;
        this.assets = _at_assets;
        base = new createjs.Shape();
        base.graphics.beginFill("#e0d5c1").drawRect(0, 0, Main.STAGE_WIDTH, Main.STAGE_HEIGHT);
        this.addChild(base);
        bitmap = this.assets.getTag("modal_head");
        head = new createjs.Bitmap(bitmap);
        this.addChild(head);
        bitmap = this.assets.getTag("title", this.self.SCENE_ID);
        title = new createjs.Bitmap(bitmap);
        title.x = (Main.STAGE_WIDTH - title.image.width) / 2;
        title.y = (head.image.height - title.image.height) / 2;
        this.addChild(title);
        bitmap = this.assets.getTag("modal_foot");
        foot = new createjs.Bitmap(bitmap);
        foot.y = Main.STAGE_HEIGHT - foot.image.height;
        this.addChild(foot);
        bitmap = new createjs.Bitmap(this.assets.getTag("button_close"));
        bitmap_on = new createjs.Bitmap(this.assets.getTag("button_close_on"));
        button = new display.ui.DisplayStateButton(bitmap, bitmap_on);
        button.width = bitmap.image.width;
        button.height = bitmap.image.height;
        button.x = Main.STAGE_WIDTH - button.width;
        button.y = Main.STAGE_HEIGHT - button.height;
        button.addEventListener("click", this._hideModal);
        table = new display.ui.TableView(display.scene.map.MapTableCellView, Main.STAGE_WIDTH, Main.STAGE_HEIGHT - head.image.height - button.height);
        table.y = head.image.height;
        this.addChild(table);
        this._stage_data = data.StageData.getInstance();
        this._data = this._stage_data.getStages();
        table.setData(this._data);
        util.EventDispatcher.getInstance().addEventListener(Event.TABLE_CELL_TAPPED, this._tapEventHandler);
        this.addChild(button);
      };

      MapScene.prototype.tickHandler = function(delta) {};

      MapScene.prototype._hideModal = function(e) {
        util.EventDispatcher.getInstance().removeEventListener(Event.TABLE_CELL_TAPPED, this._tapEventHandler);
        Main.getInstance().hideModal();
      };

      MapScene.prototype._tapEventHandler = function(e, index) {
        var current_data, current_stage;
        current_data = this._data[index];
        current_stage = data.PlayerData.getInstance().getStage();
        if (current_data != null ? current_data.active : void 0) {
          if (current_stage !== current_data.id) {
            data.PlayerData.getInstance().changeStage(current_data.id);
            this._stage_data.clearIsNewById(current_data.id);
            util.EventDispatcher.getInstance().dispatchEvent(Event.MAP_CHANGE);
          }
          this._hideModal();
        }
      };

      return MapScene;

    })(display.scene.BaseScene);
  });

  namespace('display.scene', function() {
    var ShopScene;
    return ShopScene = (function(_super) {
      var PurchaseConfirmDialogContent;

      __extends(ShopScene, _super);

      ShopScene.SCENE_ID = "shop";

      ShopScene.prototype._tabs = null;

      ShopScene.prototype._table_donguri = null;

      ShopScene.prototype._table_cook = null;

      ShopScene.prototype._table_gem = null;

      ShopScene.prototype._shop_data = data.ShopData.getInstance();

      ShopScene.prototype._bait_data = data.BaitData.getInstance();

      ShopScene.prototype._enemy_data = data.EnemyData.getInstance();

      ShopScene.prototype._player_data = data.PlayerData.getInstance();

      ShopScene.prototype._confirmDialogContent = null;

      function ShopScene() {
        this._onTabChanged = __bind(this._onTabChanged, this);
        this._createDummyShopData = __bind(this._createDummyShopData, this);
        this._playerStatusChangeHandler = __bind(this._playerStatusChangeHandler, this);
        this._openDialog = __bind(this._openDialog, this);
        this._refreshData = __bind(this._refreshData, this);
        this._buyGem = __bind(this._buyGem, this);
        this._cookBait = __bind(this._cookBait, this);
        this._buyItem = __bind(this._buyItem, this);
        this._onTableCellClicked = __bind(this._onTableCellClicked, this);
        this.tickHandler = __bind(this.tickHandler, this);
        this.init = __bind(this.init, this);
        ShopScene.__super__.constructor.call(this);
        this.self = ShopScene;
        return;
      }

      ShopScene.prototype.init = function(_at__assets) {
        var assets, close_bmp, close_button, close_on_bmp, footer, footerbg, head_title, header, headerbg, ic1, ic2, tab_head_cook, tab_head_donguri, tab_head_gem, tabview_height;
        this._assets = _at__assets;
        header = new createjs.Container();
        footer = new createjs.Container();
        headerbg = new createjs.Bitmap(this._assets.getTag("modal_head", "global"));
        footerbg = new createjs.Bitmap(this._assets.getTag("modal_foot", "global"));
        head_title = new createjs.Bitmap(this._assets.getTag("shop_title", this.self.SCENE_ID));
        head_title.x = dp(10);
        close_bmp = new createjs.Bitmap(this._assets.getTag("button_close", "global"));
        close_on_bmp = new createjs.Bitmap(this._assets.getTag("button_close_on", "global"));
        close_button = new display.ui.DisplayStateButton(close_bmp, close_on_bmp);
        close_button.x = Main.STAGE_WIDTH - close_button.width;
        close_button.addEventListener("click", (function(_this) {
          return function() {
            EventDispatcher.getInstance().removeEventListener(Event.TABLE_CELL_TAPPED, _this._onTableCellClicked);
            return Main.getInstance().hideModal();
          };
        })(this));
        ic1 = new createjs.Bitmap(this._assets.getTag("icon_dngr", "game"));
        ic1.x = Main.STAGE_WIDTH - ic1.image.width - dp(10);
        ic1.y = dp(2);
        this._gold = display.text.FontPac.getNumberText();
        this._gold.x = Main.STAGE_WIDTH - ic1.image.width - dp(12);
        this._gold.y = dp(0);
        this._gold.textAlign = "right";
        ic2 = new createjs.Bitmap(this._assets.getTag("icon_gem", "game"));
        ic2.x = Main.STAGE_WIDTH - ic2.image.width - dp(10);
        ic2.y = dp(24);
        this._gold_sp = display.text.FontPac.getNumberText();
        this._gold_sp.x = Main.STAGE_WIDTH - ic2.image.width - dp(12);
        this._gold_sp.y = dp(21);
        this._gold_sp.textAlign = "right";
        header.addChild(headerbg);
        header.addChild(head_title);
        header.addChild(ic1);
        header.addChild(ic2);
        header.addChild(this._gold);
        header.addChild(this._gold_sp);
        footer.addChild(footerbg);
        footer.addChild(close_button);
        footer.y = Main.STAGE_HEIGHT - footerbg.image.height;
        tabview_height = Main.STAGE_HEIGHT - headerbg.image.height - footerbg.image.height;
        tab_head_donguri = new createjs.Bitmap(this._assets.getTag("tab_dngr", this.self.SCENE_ID));
        tab_head_cook = new createjs.Bitmap(this._assets.getTag("tab_cook", this.self.SCENE_ID));
        tab_head_gem = new createjs.Bitmap(this._assets.getTag("tab_gem", this.self.SCENE_ID));
        this._table_donguri = new display.ui.TableView(display.scene.shop.TableDonguriCell, Main.STAGE_WIDTH, tabview_height - display.ui.TabView.HEAD_HEIGHT);
        this._table_cook = new display.ui.TableView(display.scene.shop.TableCookCell, Main.STAGE_WIDTH, tabview_height - display.ui.TabView.HEAD_HEIGHT);
        assets = [
          {
            head: tab_head_donguri,
            content: this._table_donguri
          }, {
            head: tab_head_cook,
            content: this._table_cook
          }
        ];
        this._tabs = new display.ui.TabView(assets, 0, Main.STAGE_WIDTH, tabview_height);
        this._tabs.y = headerbg.image.height;
        this._tabs.addEventListener(display.ui.TabView.EVENT_TAB_CHANGED, this._onTabChanged);

        /* temporary dsiable gem tab */

        /*@_tabs.setTabEnabled(2, false)
        		tab_head_gem.alpha = 0.5
         */
        this.addChild(header);
        this.addChild(this._tabs);
        this.addChild(footer);
        this._refreshData();
        EventDispatcher.getInstance().addEventListener(Event.TABLE_CELL_TAPPED, this._onTableCellClicked);
        util.EventDispatcher.getInstance().addEventListener(Event.PLAYER_STATUS_CHANGE, this._playerStatusChangeHandler);
        this._playerStatusChangeHandler();
      };

      ShopScene.prototype.tickHandler = function(delta) {};

      ShopScene.prototype._onTableCellClicked = function(event, index, tap_index) {
        var target_data;
        target_data = null;
        switch (this._tabs.selected) {
          case 0:
            if (tap_index === display.scene.shop.TableDonguriCell.PURCHASE_BUTTON_INDEX) {
              target_data = this._table_donguri.getDataByIndex(index);
              target_data.type = "item";
              return this._openDialog(target_data);
            }
            break;
          case 1:
            if (tap_index === display.scene.shop.TableCookCell.PURCHASE_BUTTON_INDEX) {
              target_data = this._table_cook.getDataByIndex(index);
              target_data.type = "bait";
              return this._openDialog(target_data);
            }
            break;
          case 2:
            if (tap_index === 1) {

              /* 
              					targetData = @_table_gem.getDataByIndex(index).id
              					@_openDialog(item_id, targetData)
               */
              break;
            }
        }
      };

      ShopScene.prototype._buyItem = function(data) {
        this._shop_data.addCountById(data.id);
        this._shop_data.clearIsNewById(data.id);
        if (data.is_sp) {
          return this._player_data.paySpecialGold(data.gold);
        } else {
          return this._player_data.payGold(data.gold);
        }
      };

      ShopScene.prototype._cookBait = function(data) {
        var enemycost, _i, _len, _ref4, _results;
        this._bait_data.addCountById(data.id);
        this._bait_data.clearIsNewById(data.id);
        if (data.is_sp) {
          this._player_data.paySpecialGold(data.gold);
        } else {
          this._player_data.payGold(data.gold);
        }
        _ref4 = data.cost;
        _results = [];
        for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
          enemycost = _ref4[_i];
          _results.push(this._enemy_data.payCountById(enemycost[0], enemycost[1]));
        }
        return _results;
      };

      ShopScene.prototype._buyGem = function(data) {};

      ShopScene.prototype._refreshData = function() {
        this._table_donguri.setData(this._shop_data.getProducts());
        return this._table_cook.setData(this._bait_data.getBaits());
      };

      ShopScene.prototype._openDialog = function(data) {
        if (this._confirmDialogContent == null) {
          this._confirmDialogContent = new PurchaseConfirmDialogContent(this._assets);
        }
        this._confirmDialogContent.setData(data);
        display.ui.DialogView.confirm(this, this._confirmDialogContent, null, (function(_this) {
          return function(positive) {
            if (positive) {
              switch (_this._tabs.selected) {
                case 0:
                  _this._buyItem(data);
                  _this._table_donguri.refresh(_this._shop_data.getProducts());
                  break;
                case 1:
                  _this._cookBait(data);
                  _this._table_cook.refresh(_this._bait_data.getBaits());
                  break;
                case 2:
                  _this._buyGem(data);
              }
              return util.EventDispatcher.getInstance().dispatchEvent(Event.PLAYER_STATUS_CHANGE);
            }
          };
        })(this));
      };

      ShopScene.prototype._playerStatusChangeHandler = function(event) {
        this._gold.text = this._player_data.getGold();
        return this._gold_sp.text = this._player_data.getSpecialGold();
      };

      ShopScene.prototype._createDummyShopData = function() {
        var dummyData, i, l, _i;
        dummyData = [];
        l = Math.floor(Math.random() * 25);
        for (i = _i = 0; 0 <= l ? _i < l : _i > l; i = 0 <= l ? ++_i : --_i) {
          dummyData.push({
            text: "string" + i + "/" + l
          });
        }
        return dummyData;
      };

      ShopScene.prototype._onTabChanged = function(event) {
        switch (this._tabs.selected) {
          case 1:
            return this._table_donguri.setData(this._shop_data.getProducts());
          case 2:
            return this._table_cook.setData(this._bait_data.getBaits());
          case 3:
            break;
        }
      };

      PurchaseConfirmDialogContent = (function(_super1) {
        __extends(PurchaseConfirmDialogContent, _super1);

        PurchaseConfirmDialogContent._WIDTH = dp(150);

        PurchaseConfirmDialogContent._HEIGHT = dp(115);

        PurchaseConfirmDialogContent.prototype._item_img = null;

        PurchaseConfirmDialogContent.prototype._price_field = null;

        PurchaseConfirmDialogContent.prototype._description_field = null;

        PurchaseConfirmDialogContent.prototype._title_field = null;

        PurchaseConfirmDialogContent.prototype._purchase_type = null;

        function PurchaseConfirmDialogContent(_at__assets) {
          var donguri_bmp, gem_bmp;
          this._assets = _at__assets;
          this.setData = __bind(this.setData, this);
          PurchaseConfirmDialogContent.__super__.constructor.call(this);
          donguri_bmp = new createjs.Bitmap(this._assets.getTag("icon_dngr", "game"));
          gem_bmp = new createjs.Bitmap(this._assets.getTag("icon_gem", "game"));
          this._purchase_type = new display.ui.StateImage(["donguri", "gem"], {
            "donguri": donguri_bmp,
            "gem": gem_bmp
          });
          this._purchase_type.x = dp(106);
          this._price_field = display.text.FontPac.getNumberText();
          this._price_field.textAlign = "right";
          this._price_field.x = this.width;
          this._purchase_type.y = this._price_field.y = dp(14);
          this.addChild(this._purchase_type);
          this.addChild(this._price_field);
          this._title_field = display.text.FontPac.getTitleText();
          this._title_field.color = "#FFF";
          this._title_field.y = dp(60);
          this._description_field = display.text.FontPac.getText();
          this._description_field.color = "#FFF";
          this._description_field.textBaseline = "bottom";
          this._description_field.lineWidth = this.width - dp(10);
          this._description_field.lineHeight = dp(12);
          this._description_field.y = this.height - dp(10);
          this.addChild(this._title_field);
          this.addChild(this._description_field);
          this._item_image = new createjs.Bitmap();
          this.addChild(this._item_image);
        }

        PurchaseConfirmDialogContent.prototype.setData = function(data) {
          this._title_field.set({
            text: data.name
          });
          this._purchase_type.setState(data.is_sp ? "gem" : "donguri");
          this._price_field.text = data.gold;
          this._description_field.text = data.desc;
          display.text.FontPac.textFieldWithLineFeedByLineWidth(this._description_field);
          return this._item_image.image = this._assets.getTag(_.str.sprintf("%s_%03d", data.type, data.id), "shop");

          /*@_item_image.y = (@self.CELL_HEIGHT - @_item_image.image.height)/2
          			@_item_image.x = dp(35) - @_item_image.image.width/2
           */
        };

        PurchaseConfirmDialogContent.define('width', {
          get: function() {
            return PurchaseConfirmDialogContent._WIDTH;
          }
        });

        PurchaseConfirmDialogContent.define('height', {
          get: function() {
            return PurchaseConfirmDialogContent._HEIGHT;
          }
        });

        return PurchaseConfirmDialogContent;

      })(createjs.Container);

      return ShopScene;

    })(display.scene.BaseScene);
  });

  TitleScene = (function(_super) {
    __extends(TitleScene, _super);

    TitleScene.SCENE_ID = "title";

    TitleScene.prototype._table = null;

    function TitleScene() {
      this._textFlashing = __bind(this._textFlashing, this);
      this._nextSceneHandler = __bind(this._nextSceneHandler, this);
      this.tickHandler = __bind(this.tickHandler, this);
      this.init = __bind(this.init, this);
      TitleScene.__super__.constructor.call(this);
      this.self = TitleScene;
      return;
    }

    TitleScene.prototype.init = function(_at_assets) {
      var base;
      this.assets = _at_assets;
      base = new createjs.Bitmap(this.assets.getTag("base", this.self.SCENE_ID));
      base.regY = base.image.height;
      base.y = Main.STAGE_HEIGHT;
      this.addChild(base);
      this._start = new createjs.Bitmap(this.assets.getTag("start", this.self.SCENE_ID));
      this._start.regX = this._start.image.width / 2;
      this._start.x = Main.STAGE_WIDTH / 2;
      if (Env.IS_FIREFOX) {
        this._start.y = dp(330) + Main.AD_CANVAS_HEIGHT;
      } else {
        this._start.y = dp(330);
      }
      this.addChild(this._start);
      this._textFlashing();
      this.addEventListener("click", this._nextSceneHandler);
    };

    TitleScene.prototype.tickHandler = function(delta) {};

    TitleScene.prototype._nextSceneHandler = function(e) {
      var type;
      type = "game";
      Main.getInstance().changeScene(type);
      plugin.Flurry.getInstance().logEventWithParameters(Event.LOG_BUTTON_TAP, {
        type: type
      });
    };

    TitleScene.prototype._textFlashing = function() {
      var ease_time;
      ease_time = 500;
      createjs.Tween.get(this._start).to({
        alpha: 1
      }, ease_time).wait(ease_time).to({
        alpha: 0
      }, ease_time).call(this._textFlashing);
    };

    return TitleScene;

  })(display.scene.BaseScene);

  namespace('display.scene', function() {
    return TitleScene;
  });

  namespace('display.scene', function() {
    var TutorialScene;
    return TutorialScene = (function(_super) {
      __extends(TutorialScene, _super);

      TutorialScene._SCENE_ID = "tutorial";

      function TutorialScene() {
        this._onTouchUp = __bind(this._onTouchUp, this);
        this._onTouchMove = __bind(this._onTouchMove, this);
        this._onTouchDown = __bind(this._onTouchDown, this);
        this._buttonSetting = __bind(this._buttonSetting, this);
        this._tutorialSetting = __bind(this._tutorialSetting, this);
        this._hideModal = __bind(this._hideModal, this);
        this.tickHandler = __bind(this.tickHandler, this);
        this.init = __bind(this.init, this);
        TutorialScene.__super__.constructor.call(this);
        this.self = TutorialScene;
        this.helps = Config.HELP_IMAGES;
        return;
      }

      TutorialScene.prototype.init = function(_at_assets) {
        var base, bitmap, bitmap_on, button;
        this.assets = _at_assets;
        this._stage_width = Main.STAGE_WIDTH;
        this._stage_height = Main.STAGE_HEIGHT;
        this._current_index = 0;
        base = new createjs.Shape();
        base.graphics.beginFill("#eeefe6").drawRect(0, 0, Main.STAGE_WIDTH, Main.STAGE_HEIGHT);
        this.addChild(base);
        bitmap = this.assets.getTag("modal_head");
        this._head = new createjs.Bitmap(bitmap);
        this.addChild(this._head);
        bitmap = this.assets.getTag("title", this.self._SCENE_ID);
        this._title = new createjs.Bitmap(bitmap);
        this._title.x = (Main.STAGE_WIDTH - this._title.image.width) / 2;
        this._title.y = (this._head.image.height - this._title.image.height) / 2;
        this.addChild(this._title);
        bitmap = this.assets.getTag("modal_foot");
        this._foot = new createjs.Bitmap(bitmap);
        this._foot.y = Main.STAGE_HEIGHT - this._foot.image.height;
        this.addChild(this._foot);
        bitmap = new createjs.Bitmap(this.assets.getTag("button_close"));
        bitmap_on = new createjs.Bitmap(this.assets.getTag("button_close_on"));
        button = new display.ui.DisplayStateButton(bitmap, bitmap_on);
        button.width = bitmap.image.width;
        button.height = bitmap.image.height;
        button.x = Main.STAGE_WIDTH - button.width;
        button.y = Main.STAGE_HEIGHT - button.height;
        button.addEventListener("click", this._hideModal);
        this._help_container = new createjs.Container();
        this._help_container.y = this._head.image.height;
        this.addChild(this._help_container);
        this._tutorialSetting();
        this.addChild(button);
      };

      TutorialScene.prototype.tickHandler = function(delta) {};

      TutorialScene.prototype._hideModal = function(e) {
        Main.getInstance().hideModal();
      };

      TutorialScene.prototype._tutorialSetting = function() {
        var help, i, len, _i, _len, _ref4;
        len = this.helps.length;
        _ref4 = this.helps;
        for (i = _i = 0, _len = _ref4.length; _i < _len; i = ++_i) {
          help = _ref4[i];
          help = new createjs.Bitmap(this.assets.getTag(help, this.self._SCENE_ID));
          help.x = (this._stage_width - help.image.width) / 2 + (this._stage_width * i);
          help.y = (this._stage_height - help.image.height) / 2 - this._head.image.height;
          this._help_container.addChild(help);
        }
        this._btn_margin = dp(15);
        this._btn_size = dp(3);
        this._btn_container = new createjs.Container();
        this._btn_container.x = (this._stage_width - (this._btn_margin * (len - 1) + this._btn_size * len)) / 2 + this._btn_size;
        this._btn_container.y = this._title.image.height + help.y + help.image.height + dp(10);
        this.addChild(this._btn_container);
        this._buttonSetting();
        this._help_container.addEventListener("mousedown", (function(_this) {
          return function(event) {
            return _this._onTouchDown(event);
          };
        })(this));
      };

      TutorialScene.prototype._buttonSetting = function() {
        var button, help, i, _i, _len, _ref4, _results;
        _ref4 = this.helps;
        _results = [];
        for (i = _i = 0, _len = _ref4.length; _i < _len; i = ++_i) {
          help = _ref4[i];
          button = new createjs.Shape();
          if (i === this._current_index) {
            button.graphics.beginFill("#333");
          } else {
            button.graphics.beginFill("#aaa");
          }
          button.graphics.drawCircle(this._btn_margin * i, 0, this._btn_size);
          _results.push(this._btn_container.addChild(button));
        }
        return _results;
      };

      TutorialScene.prototype._onTouchDown = function(event) {
        this._down_x = event.stageX;
        this._default_x = this._help_container.x;
        event.addEventListener("mousemove", this._onTouchMove);
        return event.addEventListener("mouseup", this._onTouchUp);
      };

      TutorialScene.prototype._onTouchMove = function(event) {
        var _x;
        _x = event.stageX;
        this._move_x = this._default_x + (_x - this._down_x);
        return this._help_container.x = this._move_x;
      };

      TutorialScene.prototype._onTouchUp = function(event) {
        var area, diff_x;
        area = Math.ceil(this._stage_width / 3);
        diff_x = event.stageX - this._down_x;
        if (diff_x > area) {
          --this._current_index;
        } else if (diff_x < -area) {
          ++this._current_index;
        }
        this._current_index = Math.min(Math.max(this._current_index, 0), this.helps.length - 1);
        createjs.Tween.get(this._help_container).to({
          x: -this._current_index * this._stage_width
        }, 200);
        this._btn_container.removeAllChildren();
        return this._buttonSetting();
      };

      return TutorialScene;

    })(display.scene.BaseScene);
  });

  if (typeof namespace === "function") {
    namespace("plugin", function() {
      var AdSense;
      return AdSense = (function() {
        AdSense._INSTANCE = null;

        AdSense.getInstance = function() {
          if (AdSense._INSTANCE === null) {
            AdSense._INSTANCE = new AdSenseSingleton();
          }
          return AdSense._INSTANCE;
        };

        function AdSense() {
          return;
        }

        return AdSense;

      })();
    });
  }

  AdSenseSingleton = (function() {
    AdSenseSingleton.prototype._is_show = false;

    function AdSenseSingleton() {
      this._showAd = __bind(this._showAd, this);
      this._iAdBannerViewDidFailToReceiveAdWithErrorEventHandler = __bind(this._iAdBannerViewDidFailToReceiveAdWithErrorEventHandler, this);
      this._iAdBannerViewDidLoadAdEventHandler = __bind(this._iAdBannerViewDidLoadAdEventHandler, this);
      this.prepare = __bind(this.prepare, this);
      this.hide = __bind(this.hide, this);
      this.show = __bind(this.show, this);
      this.isShow = __bind(this.isShow, this);
      this.orientationChanged = __bind(this.orientationChanged, this);
      if (typeof cordova !== "undefined" && cordova !== null) {
        cordova.addConstructor((function(_this) {
          return function() {
            if (typeof window !== "undefined" && window !== null) {
              window.adSense = _this;
            }
            if (typeof window !== "undefined" && window !== null) {
              window.addEventListener("orientationchange", _this.orientationChanged, false);
            }
            if (typeof document !== "undefined" && document !== null) {
              document.addEventListener("iAdBannerViewDidLoadAdEvent", _this._iAdBannerViewDidLoadAdEventHandler, false);
            }
            return typeof document !== "undefined" && document !== null ? document.addEventListener("iAdBannerViewDidFailToReceiveAdWithErrorEvent", _this._iAdBannerViewDidFailToReceiveAdWithErrorEventHandler, false) : void 0;
          };
        })(this));
      }
      return;
    }

    AdSenseSingleton.prototype.orientationChanged = function(e) {
      if (typeof cordova !== "undefined" && cordova !== null) {
        cordova.exec(null, null, "SAiOSAdPlugin", "orientationChanged", [window.orientation]);
        return true;
      }
      return false;
    };

    AdSenseSingleton.prototype.isShow = function() {
      return this._is_show;
    };

    AdSenseSingleton.prototype.show = function() {
      this._showAd(true);
    };

    AdSenseSingleton.prototype.hide = function() {
      this._showAd(false);
    };

    AdSenseSingleton.prototype.prepare = function(bool) {
      if (bool == null) {
        bool = true;
      }
      if (typeof cordova !== "undefined" && cordova !== null) {
        cordova.exec(null, null, "SAiOSAdPlugin", "prepare", [bool]);
        return true;
      }
      return false;
    };

    AdSenseSingleton.prototype._iAdBannerViewDidLoadAdEventHandler = function() {
      this.show();
    };

    AdSenseSingleton.prototype._iAdBannerViewDidFailToReceiveAdWithErrorEventHandler = function(error) {
      this.hide();
    };

    AdSenseSingleton.prototype._showAd = function(bool) {
      if (bool == null) {
        bool = true;
      }
      if (typeof cordova !== "undefined" && cordova !== null) {
        if (this._is_show !== bool) {
          cordova.exec(null, null, "SAiOSAdPlugin", "showAd", [bool]);
          this._is_show = bool;
        }
        return true;
      }
      return false;
    };

    return AdSenseSingleton;

  })();

  if (typeof namespace === "function") {
    namespace("plugin", function() {
      var Flurry;
      return Flurry = (function() {
        function Flurry() {}

        Flurry._INSTANCE = null;

        Flurry.getInstance = function() {
          var cordova, _ref4, _ref5;
          if (Flurry._INSTANCE === null) {
            cordova = (_ref4 = (_ref5 = typeof window !== "undefined" && window !== null ? window.cordova : void 0) != null ? _ref5 : typeof window !== "undefined" && window !== null ? window.Cordova : void 0) != null ? _ref4 : typeof window !== "undefined" && window !== null ? window.PhoneGap : void 0;
            Flurry._INSTANCE = new FlurrySingleton(cordova);
            Flurry.install = function() {
              if (typeof window !== "undefined" && window !== null) {
                if (window.plugins == null) {
                  window.plugins = {};
                }
              }
              return window.plugins.flurry = Flurry._INSTANCE;
            };
            if (cordova != null) {
              cordova.addConstructor(Flurry.install);
            }
          }
          return Flurry._INSTANCE;
        };

        return Flurry;

      })();
    });
  }

  FlurrySingleton = (function() {
    function FlurrySingleton(_at_cordova) {
      this.cordova = _at_cordova;
      return;
    }

    FlurrySingleton.prototype.setAppVersion = function(version, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'setAppVersion', [version]) : void 0;
    };

    FlurrySingleton.prototype.setShowErrorInLogEnabled = function(enableValue, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'setShowErrorInLogEnabled', [enableValue]) : void 0;
    };

    FlurrySingleton.prototype.setEventLoggingEnabled = function(enableValue, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'setEventLoggingEnabled', [enableValue]) : void 0;
    };

    FlurrySingleton.prototype.setDebugLogEnabled = function(enableValue, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'setDebugLogEnabled', [enableValue]) : void 0;
    };

    FlurrySingleton.prototype.setSecureTransportEnabled = function(enableValue, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'setSecureTransportEnabled', [enableValue]) : void 0;
    };

    FlurrySingleton.prototype.setSessionContinueSeconds = function(seconds, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'setSessionContinueSeconds', [seconds]) : void 0;
    };

    FlurrySingleton.prototype.setCrashReportingEnabled = function(enableValue, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'setCrashReportingEnabled', [enableValue]) : void 0;
    };

    FlurrySingleton.prototype.startSession = function(key, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'startSession', [key]) : void 0;
    };

    FlurrySingleton.prototype.logEvent = function(event, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'logEvent', [event]) : void 0;
    };

    FlurrySingleton.prototype.logEventWithParameters = function(event, parameters, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'logEventWithParameters', [event, parameters]) : void 0;
    };

    FlurrySingleton.prototype.logPageView = function(successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'logPageView', []) : void 0;
    };

    FlurrySingleton.prototype.logTimedEvent = function(event, timed, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'logTimedEvent', [event, timed]) : void 0;
    };

    FlurrySingleton.prototype.logTimedEventWithParameters = function(event, parameters, timed, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'logTimedEventWithParameters', [event, parameters, timed]) : void 0;
    };

    FlurrySingleton.prototype.endTimedEvent = function(event, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'endTimedEvent', [event]) : void 0;
    };

    FlurrySingleton.prototype.endTimedEventWithParameters = function(event, parameters, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'endTimedEventWithParameters', [event, parameters]) : void 0;
    };

    FlurrySingleton.prototype.setUserID = function(userID, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'setUserID', [userID]) : void 0;
    };

    FlurrySingleton.prototype.setGender = function(gender, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'setGender', [gender]) : void 0;
    };

    FlurrySingleton.prototype.setAge = function(age, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'setAge', [age]) : void 0;
    };

    FlurrySingleton.prototype.setLatitude = function(latitude, longitude, horizontalAccuracy, verticalAccuracy, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'setLatitude', [latitude, longitude, horizontalAccuracy, verticalAccuracy]) : void 0;
    };

    FlurrySingleton.prototype.setSessionReportsOnCloseEnabled = function(enabled, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'setSessionReportsOnCloseEnabled', [enabled]) : void 0;
    };

    FlurrySingleton.prototype.setSessionReportsOnPauseEnabled = function(enabled, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'setSessionReportsOnPauseEnabled', [enabled]) : void 0;
    };

    FlurrySingleton.prototype.logError = function(errorID, message, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'FlurryPlugin', 'logError', [errorID, message]) : void 0;
    };

    return FlurrySingleton;

  })();

  GameCenter = (function() {
    GameCenter._INSTANCE = null;

    GameCenter.getInstance = function() {
      if (GameCenter._INSTANCE === null) {
        GameCenter._INSTANCE = new GameCenterSingleton();
      }
      return GameCenter._INSTANCE;
    };

    function GameCenter() {
      return;
    }

    return GameCenter;

  })();

  GameCenterSingleton = (function() {
    GameCenterSingleton.prototype._event_dispatcher = null;

    function GameCenterSingleton() {
      this._viewDidHide = __bind(this._viewDidHide, this);
      this._viewDidShow = __bind(this._viewDidShow, this);
      this.reportAchievement = __bind(this.reportAchievement, this);
      this.showAchievements = __bind(this.showAchievements, this);
      this.reportScore = __bind(this.reportScore, this);
      this.showLeaderboard = __bind(this.showLeaderboard, this);
      this.authenticate = __bind(this.authenticate, this);
      if (typeof cordova !== "undefined" && cordova !== null) {
        cordova.addConstructor((function(_this) {
          return function() {
            return typeof window !== "undefined" && window !== null ? window.gameCenter = _this : void 0;
          };
        })(this));
      }
      if (typeof (typeof Main !== "undefined" && Main !== null ? Main.getEventDispatcher : void 0) === 'function') {
        this._event_dispatcher = Main.getEventDispatcher();
      }
      return;
    }

    GameCenterSingleton.prototype.authenticate = function(success_handler, error_handler) {
      if (typeof cordova !== "undefined" && cordova !== null) {
        cordova.exec(success_handler, error_handler, "GameCenterPlugin", "authenticateLocalPlayer", []);
        return true;
      }
      return false;
    };

    GameCenterSingleton.prototype.showLeaderboard = function(category) {
      if (typeof cordova !== "undefined" && cordova !== null) {
        cordova.exec(null, null, "GameCenterPlugin", "showLeaderboard", [category]);
        return true;
      }
      return false;
    };

    GameCenterSingleton.prototype.reportScore = function(category, score, success_handler, error_handler) {
      if (typeof cordova !== "undefined" && cordova !== null) {
        cordova.exec(success_handler, error_handler, "GameCenterPlugin", "reportScore", [category, score]);
        return true;
      }
      return false;
    };

    GameCenterSingleton.prototype.showAchievements = function() {
      if (typeof cordova !== "undefined" && cordova !== null) {
        cordova.exec(null, null, "GameCenterPlugin", "showAchievements", []);
        return true;
      }
      return false;
    };

    GameCenterSingleton.prototype.reportAchievement = function(category, success_handler, error_handler) {
      if (typeof cordova !== "undefined" && cordova !== null) {
        cordova.exec(success_handler, error_handler, "GameCenterPlugin", "reportAchievementIdentifier", [category, 100]);
        return true;
      }
      return false;
    };

    GameCenterSingleton.prototype._viewDidShow = function() {
      var event_key;
      if (this._event_dispatcher) {
        event_key = (Event != null ? Event.GAME_CENTER_SHOWED : void 0) || "game_center_showed";
        this._event_dispatcher.dispatchEvent(event_key);
      }
    };

    GameCenterSingleton.prototype._viewDidHide = function() {
      var event_key;
      if (this._event_dispatcher) {
        event_key = (Event != null ? Event.GAME_CENTER_HIDED : void 0) || "game_center_hided";
        this._event_dispatcher.dispatchEvent(event_key);
      }
    };

    return GameCenterSingleton;

  })();

  if (typeof namespace === "function") {
    namespace("plugin", function() {
      return GameCenter;
    });
  }

  if (typeof namespace === "function") {
    namespace("plugin", function() {
      var LocalNotification;
      return LocalNotification = (function() {
        function LocalNotification() {}

        LocalNotification._DEFAULT_OPTION = {
          date: false,
          message: '',
          has_action: true,
          action: 'View',
          repeat: '',
          badge: 0,
          id: 0,
          sound: '',
          background: '',
          foreground: ''
        };

        LocalNotification._INSTANCE = null;

        LocalNotification.getInstance = function() {
          var cordova, _ref4, _ref5;
          if (LocalNotification._INSTANCE === null) {
            cordova = (_ref4 = (_ref5 = typeof window !== "undefined" && window !== null ? window.cordova : void 0) != null ? _ref5 : typeof window !== "undefined" && window !== null ? window.Cordova : void 0) != null ? _ref4 : typeof window !== "undefined" && window !== null ? window.PhoneGap : void 0;
            LocalNotification._INSTANCE = new LocalNotificationSingleton(LocalNotification, cordova);
            LocalNotification.install = function() {
              if (typeof window !== "undefined" && window !== null) {
                if (window.plugins == null) {
                  window.plugins = {};
                }
              }
              return window.plugins.local_notification = LocalNotification._INSTANCE;
            };
            if (cordova != null) {
              cordova.addConstructor(LocalNotification.install);
            }
          }
          return LocalNotification._INSTANCE;
        };

        return LocalNotification;

      })();
    });
  }

  LocalNotificationSingleton = (function() {
    function LocalNotificationSingleton(_at_self, _at_cordova) {
      this.self = _at_self;
      this.cordova = _at_cordova;
      this._alarmMessageHandler = __bind(this._alarmMessageHandler, this);
      this._notification_click_handlers = {};
      if (typeof navigator !== "undefined" && navigator !== null ? navigator.mozSetMessageHandler : void 0) {
        navigator.mozSetMessageHandler("alarm", this._alarmMessageHandler);
      }
      return;
    }

    LocalNotificationSingleton.prototype.addNotification = function(options, successCallback, failureCallback) {
      var alarm_request, params, _ref4;
      if (options == null) {
        options = {};
      }
      params = {};
      for (key in this.self._DEFAULT_OPTION) {
        if (key in options) {
          params[key] = options[key];
        } else {
          params[key] = this.self._DEFAULT_OPTION[key];
        }
      }
      if ((_ref4 = this.cordova) != null) {
        _ref4.exec(successCallback, failureCallback, 'LocalNotificationPlugin', 'addNotification', [params]);
      }
      if (typeof navigator !== "undefined" && navigator !== null ? navigator.mozAlarms : void 0) {
        alarm_request = navigator.mozAlarms.add(new Date(params.date * 1000), 'ignoreTimezone', {
          message: params.message
        });
        alarm_request.onsuccess = (function(_this) {
          return function() {
            _this._notification_click_handlers[alarm_request.result] = params.action;
            if (typeof successCallback === "function") {
              successCallback();
            }
          };
        })(this);
        alarm_request.onerror = (function(_this) {
          return function() {
            if (typeof failureCallback === "function") {
              failureCallback();
            }
          };
        })(this);
      }
    };

    LocalNotificationSingleton.prototype.removeNotification = function(notification_id, successCallback, failureCallback) {
      var alarm_request, _ref4;
      if ((_ref4 = this.cordova) != null) {
        _ref4.exec(successCallback, failureCallback, 'LocalNotificationPlugin', 'removeNotification', [notification_id]);
      }
      if (typeof navigator !== "undefined" && navigator !== null ? navigator.mozAlarms : void 0) {
        alarm_request = navigator.mozAlarms.remove(notification_id);
        alarm_request.onsuccess = (function(_this) {
          return function() {
            delete _this._notification_click_handlers[notification_id];
            if (typeof successCallback === "function") {
              successCallback();
            }
          };
        })(this);
        alarm_request.onerror = (function(_this) {
          return function() {
            if (typeof failureCallback === "function") {
              failureCallback();
            }
          };
        })(this);
      }
    };

    LocalNotificationSingleton.prototype.removeAllNotification = function(successCallback, failureCallback) {
      var alarm_request, _ref4;
      if ((_ref4 = this.cordova) != null) {
        _ref4.exec(successCallback, failureCallback, 'LocalNotificationPlugin', 'removeAllNotification', []);
      }
      if (typeof navigator !== "undefined" && navigator !== null ? navigator.mozAlarms : void 0) {
        alarm_request = navigator.mozAlarms.getAll();
        alarm_request.onsuccess = (function(_this) {
          return function() {
            var _ref5;
            _ref5 = alarm_request.result;
            for (key in _ref5) {
              val = _ref5[key];
              _this.removeNotification(val.id, null, null);
            }
            if (typeof successCallback === "function") {
              successCallback();
            }
          };
        })(this);
        alarm_request.onerror = (function(_this) {
          return function() {
            if (typeof failureCallback === "function") {
              failureCallback();
            }
          };
        })(this);
      }
    };

    LocalNotificationSingleton.prototype.setBadgeNumber = function(num, successCallback, failureCallback) {
      var _ref4;
      return (_ref4 = this.cordova) != null ? _ref4.exec(successCallback, failureCallback, 'LocalNotificationPlugin', 'setBadgeNumber', [num]) : void 0;
    };

    LocalNotificationSingleton.prototype._alarmMessageHandler = function(alarm) {
      var app_request, _ref4;
      if (app_request = typeof navigator !== "undefined" && navigator !== null ? (_ref4 = navigator.mozApps) != null ? _ref4.getSelf() : void 0 : void 0) {
        app_request.onsuccess = (function(_this) {
          return function() {
            var app, notification;
            app = app_request.result;
            notification = navigator.mozNotification.createNotification(app.manifest.name, alarm.data.message);
            if (alarm.id in _this._notification_click_handlers) {
              if (_this._notification_click_handlers[alarm.id] instanceof Function) {
                notification.onclick = function() {
                  _this._notification_click_handlers[alarm.id]();
                  return notification.close();
                };
              } else if (_this._notification_click_handlers[alarm.id] === "View") {
                notification.onclick = function() {
                  app.launch();
                  return notification.close();
                };
              }
            }
            return notification.show();
          };
        })(this);
        app_request.onerror = (function(_this) {
          return function() {};
        })(this);
      }
    };

    return LocalNotificationSingleton;

  })();

  Main = (function() {
    Main.INSTANCE = null;

    Main._EVENT_INSTANCE = null;

    Main.STAGE = null;

    Main.STAGE_WIDTH = 320 * getPixelRate();

    Main.STAGE_HEIGHT = 480 * getPixelRate();

    Main.CANVAS_WIDTH = 320;

    Main.CANVAS_HEIGHT = 480;

    Main.AD_CANVAS_HEIGHT = 50;

    Main.prototype._assets_manager = null;

    Main.prototype._child_container = null;

    Main.prototype._loading_sprite = null;

    Main.prototype._scene = null;

    Main.prototype._modal = null;

    Main.getInstance = function() {
      return Main.INSTANCE;
    };

    Main.getEventDispatcher = function() {
      return util.EventDispatcher.getInstance();
    };

    function Main(_at_global, _at_stage) {
      var ad_height;
      this.global = _at_global;
      this.stage = _at_stage;
      this._resumeHandler = __bind(this._resumeHandler, this);
      this._pauseHandler = __bind(this._pauseHandler, this);
      this._orientationChangeHandler = __bind(this._orientationChangeHandler, this);
      this._cycleEngineHandler = __bind(this._cycleEngineHandler, this);
      this._hideLoading = __bind(this._hideLoading, this);
      this.hideModal = __bind(this.hideModal, this);
      this.showModal = __bind(this.showModal, this);
      this.changeScene = __bind(this.changeScene, this);
      this.init = __bind(this.init, this);
      Main.INSTANCE = this;
      this.global.addEventListener('orientationchange', this._orientationChangeHandler, true);
      ad_height = Main.AD_CANVAS_HEIGHT;
      if (Env.IS_FIREFOX) {
        ad_height = 0;
      }
      if (Env.IS_MOBILE) {
        Main.CANVAS_WIDTH = Math.min(screen.width, screen.height);
        Main.STAGE_WIDTH = Main.CANVAS_WIDTH * getPixelRate();
        Main.CANVAS_HEIGHT = Math.max(screen.width, screen.height) - ad_height;
        Main.STAGE_HEIGHT = Main.CANVAS_HEIGHT * getPixelRate();
        this.global.document.addEventListener('deviceready', this.init, false);
        this.global.document.addEventListener('pause', this._pauseHandler, false);
        this.global.document.addEventListener('resume', this._resumeHandler, false);
      } else {
        Main.CANVAS_HEIGHT -= ad_height;
        Main.STAGE_HEIGHT -= dp(ad_height);
        this.init();
      }
      return;
    }

    Main.prototype.init = function() {
      var base;
      this._orientationChangeHandler();
      Main.STAGE = new createjs.Stage("stage");
      Main.STAGE.enableMouseOver(10);
      Main.STAGE.mouseMoveOutside = true;
      createjs.Touch.enable(Main.STAGE);
      createjs.Ticker.setFPS(Config.FPS);
      createjs.Sound.registerPlugins([createjs.WebAudioPlugin, createjs.HTMLAudioPlugin]);
      base = new createjs.Shape();
      base.graphics.beginFill("#000").drawRect(0, 0, Main.STAGE_WIDTH, Main.STAGE_HEIGHT);
      Main.STAGE.addChild(base);
      this._child_container = new createjs.Container();
      Main.STAGE.addChild(this._child_container);
      this._modal_container = new createjs.Container();
      Main.STAGE.addChild(this._modal_container);
      this._loading_sprite = new display.sprite.LoadingSprite();
      Main.STAGE.addChild(this._loading_sprite);
      this._assets_manager = util.AssetsManager.getInstance();
      this._assets_manager.init(Asset);
      data.PlayerData.getInstance();
      this._loading_sprite.visible = true;
      this._assets_manager.load("global", (function(_this) {
        return function() {
          return _this.changeScene("title");
        };
      })(this));
      plugin.GameCenter.getInstance();
      createjs.Ticker.addEventListener("tick", this._cycleEngineHandler);
      plugin.AdSense.getInstance().prepare(true);
      plugin.Flurry.getInstance().startSession(Config.TRACK_ID);
      plugin.Flurry.getInstance().setAppVersion(Config.APP_VERSION);
      plugin.Flurry.getInstance().logEvent(Event.LOG_OPEN);
      if (typeof cordova !== "undefined" && cordova !== null) {
        cordova.exec(null, null, "SplashScreen", "hide", []);
      }
    };

    Main.prototype.changeScene = function() {
      var args, scene_id, scene_name;
      scene_id = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
      if (scene_id in Config.SCENES) {
        scene_name = Config.SCENES[scene_id];
      } else {
        return;
      }
      this._loading_sprite.visible = true;
      if (this._scene != null) {
        this._child_container.removeAllEventListeners();
        this._child_container.removeAllChildren();
        this._modal_container.removeAllEventListeners();
        this._modal_container.removeAllChildren();
        this._modal = null;
        createjs.Tween.removeAllTweens();
        Main.getEventDispatcher().clearAllEventListener();
      }
      if (scene_name in display.scene) {
        this._scene = construct(display.scene[scene_name], args);
        this._child_container.addChild(this._scene);
        this._assets_manager.load(scene_id, (function(_this) {
          return function() {
            _this._scene.init(_this._assets_manager);
            return _this._hideLoading();

            /*
            				switch scene_id
            					when "game"
            						audio.BgmManager.getInstance().play("bgm_game")
            					else
            						audio.BgmManager.getInstance().play("bgm_opening")
             */
          };
        })(this));
      }
    };

    Main.prototype.showModal = function() {
      var args, base, scene_id, scene_name;
      scene_id = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
      if (this._modal === null && scene_id in Config.MODAL_SCENES) {
        scene_name = Config.MODAL_SCENES[scene_id];
        this._is_show_modal = true;
      } else {
        return;
      }
      if (scene_name in display.scene) {
        base = new createjs.Shape();
        base.graphics.beginFill("#000").drawRect(0, 0, Main.STAGE_WIDTH, Main.STAGE_HEIGHT);
        base.alpha = 0.8;
        this._modal_container.addChild(base);
        base.addEventListener('click', function() {});
        this._modal = construct(display.scene[scene_name], args);
        this._modal_container.addChild(this._modal);
        this._modal.y = -Main.STAGE_HEIGHT;
        this._assets_manager.load(scene_id, (function(_this) {
          return function() {
            _this._modal.init(_this._assets_manager);
            return createjs.Tween.get(_this._modal).to({
              y: 0
            }, 500, createjs.Ease.cubicOut);
          };
        })(this));
      }
    };

    Main.prototype.hideModal = function() {
      var modal;
      if (this._modal !== null) {
        modal = this._modal;
        this._modal = null;
        createjs.Tween.get(modal).to({
          y: -Main.STAGE_HEIGHT
        }, 500, createjs.Ease.cubicOut).call((function(_this) {
          return function() {
            _this._modal_container.removeAllEventListeners();
            return _this._modal_container.removeAllChildren();
          };
        })(this));
      }
    };

    Main.prototype._hideLoading = function() {
      this._loading_sprite.visible = false;
    };

    Main.prototype._cycleEngineHandler = function(delta) {
      var _ref4, _ref5;
      Main.STAGE.update();
      if ((_ref4 = this._scene) != null) {
        if (typeof _ref4.tickHandler === "function") {
          _ref4.tickHandler(delta);
        }
      }
      if ((_ref5 = this._modal) != null) {
        if (typeof _ref5.tickHandler === "function") {
          _ref5.tickHandler(delta);
        }
      }
    };

    Main.prototype._orientationChangeHandler = function(e) {
      var _ref10, _ref11, _ref12, _ref13, _ref14, _ref15, _ref4, _ref5, _ref6, _ref7, _ref8, _ref9;
      switch (this.global.orientation) {
        case 90:
        case -90:
          if ((_ref4 = this.stage) != null) {
            if (typeof _ref4.setAttribute === "function") {
              _ref4.setAttribute('width', Main.STAGE_HEIGHT);
            }
          }
          if ((_ref5 = this.stage) != null) {
            if (typeof _ref5.setAttribute === "function") {
              _ref5.setAttribute('height', Main.STAGE_WIDTH);
            }
          }
          if ((_ref6 = this.stage) != null) {
            if ((_ref7 = _ref6.style) != null) {
              _ref7.width = Main.CANVAS_HEIGHT + "px";
            }
          }
          if ((_ref8 = this.stage) != null) {
            if ((_ref9 = _ref8.style) != null) {
              _ref9.height = Main.CANVAS_WIDTH + "px";
            }
          }
          break;
        default:
          if ((_ref10 = this.stage) != null) {
            if (typeof _ref10.setAttribute === "function") {
              _ref10.setAttribute('width', Main.STAGE_WIDTH);
            }
          }
          if ((_ref11 = this.stage) != null) {
            if (typeof _ref11.setAttribute === "function") {
              _ref11.setAttribute('height', Main.STAGE_HEIGHT);
            }
          }
          if ((_ref12 = this.stage) != null) {
            if ((_ref13 = _ref12.style) != null) {
              _ref13.width = Main.CANVAS_WIDTH + "px";
            }
          }
          if ((_ref14 = this.stage) != null) {
            if ((_ref15 = _ref14.style) != null) {
              _ref15.height = Main.CANVAS_HEIGHT + "px";
            }
          }
      }
    };

    Main.prototype._pauseHandler = function(e) {
      console.log("device pause");
      plugin.Flurry.getInstance().logEvent(Event.LOG_PAUSE);
    };

    Main.prototype._resumeHandler = function(e) {
      console.log("device resume");
      plugin.Flurry.getInstance().logEvent(Event.LOG_RESUME);
    };

    return Main;

  })();

  new Main(window, document.getElementById('stage'));

}).call(this);
