(function() {
  var AnimalPilingBG, AssetsManager, AssetsManagerSingleton, BaseScene, BgmManager, BgmManagerSingleton, BitmapFont, BitmapText, ButtonsSprite, CharactorWithBaloon, CompleteScene, Config, EventDispatcher, GameCenter, GameCenterSingleton, GameManager, GameScene, GameSceneOverlay, InfinityScene, LandStartAnimation, LoadingSprite, Main, PlayerData, PlayerDataSingleton, PointNumberFont, ResultHud, ResultScene, ScoreSprite, SelectScene, SoundEffectManager, StatusSprite, TitleScene, construct, delay, dp, getAssetPathById, getAssetPaths, getPixelRate, getRetinaPath, key, makeAssets, namespace, sePlay, val,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __slice = [].slice,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    __hasProp = {}.hasOwnProperty;

  Config = (function() {
    function Config() {}

    Config.IS_DEBUG = false;

    Config.FPS = 30;

    Config.IS_MOBILE = !!(navigator.userAgent.match(/(iPhone|iPod|iPad|Android|BlackBerry)/));

    Config.IS_RETINA = window.devicePixelRatio > 1;

    Config.IS_FIREFOX = !!(navigator.userAgent.match(/Firefox/));

    Config.IMAGE_DIR = 'assets/images/';

    Config.SOUND_DIR = Config.IS_FIREFOX ? 'assets_firefox/sounds/' : 'assets/sounds/';

    Config.SCENES = {
      "title": "TitleScene",
      "select": "SelectScene",
      "game": "GameScene",
      "result": "ResultScene",
      "infinity": "InfinityScene"
    };

    Config.LAND_DATA = [
      {
        label: "ひよこ",
        rate: 0.5,
        stages: [3, 3, 4, 4, 4],
        speed: 1200,
        board: "land_001"
      }, {
        label: "ねこ",
        rate: 0.6,
        stages: [4, 4, 5, 5, 5],
        speed: 1200,
        board: "land_002"
      }, {
        label: "いぬ",
        rate: 0.6,
        stages: [5, 5, 6, 6, 6],
        speed: 1000,
        board: "land_003"
      }, {
        label: "ぱんだ",
        rate: 0.7,
        stages: [7, 7, 8, 8, 8],
        speed: 1000,
        board: "land_004"
      }, {
        label: "まんもす",
        rate: 0.7,
        stages: [8, 9, 10, 11, 12],
        speed: 1000,
        board: "land_005"
      }
    ];

    Config.ZOO_DATA = [
      {
        id: 1,
        label: "ひよこ"
      }, {
        id: 2,
        label: "ねこ"
      }, {
        id: 3,
        label: "いぬ"
      }, {
        id: 4,
        label: "ぱんだ"
      }, {
        id: 5,
        label: "まんもす"
      }, {
        id: 6,
        label: "ひつじ"
      }, {
        id: 7,
        label: "うし"
      }, {
        id: 8,
        label: "ぶた"
      }, {
        id: 9,
        label: "うさぎ"
      }, {
        id: 10,
        label: "あひる"
      }
    ];

    Config.TAP_POINT_BASE = 100;

    Config.TAP_CHAIN_BONUS = 0.1;

    Config.RANK_DATA = [
      {
        rank: 1,
        accuracy_min: 1,
        accuracy_max: Number.MAX_VALUE
      }, {
        rank: 2,
        accuracy_min: 0.9,
        accuracy_max: 1
      }, {
        rank: 3,
        accuracy_min: 0.6,
        accuracy_max: 0.9
      }, {
        rank: 4,
        accuracy_min: 0.3,
        accuracy_max: 0.6
      }, {
        rank: 5,
        accuracy_min: 0,
        accuracy_max: 0.3
      }
    ];

    Config.POINT = 0;

    return Config;

  })();

  Function.prototype.define = function(prop, desc) {
    return Object.defineProperty(this.prototype, prop, desc);
  };

  if (!(Config != null ? Config.IS_DEBUG : void 0)) {
    for (key in console) {
      val = console[key];
      console[key] = function() {};
    }
  }


  /**
  * 名前空間実装
  * @param {String} カンマ区切りのパッケージ文字列
  * @param {Function} クラス内包の無名関数
   */

  namespace = function(namespace, fn) {
    var here, klass, token, tokens, _i, _len;
    klass = fn();
    tokens = namespace.split('.');
    here = this;
    for (_i = 0, _len = tokens.length; _i < _len; _i++) {
      token = tokens[_i];
      if (here[token] == null) {
        here[token] = {};
      }
      here = here[token];
    }
    return here[klass.name] = klass;
  };


  /**
  * コンストラクタに可変引数の受け渡しをする
  * @param {Function} クラス
  * @param {Array} 引数の配列
  * @return {Any} 与えられたクラスのインスタンス
   */

  construct = function(constructor, args) {
    var F;
    F = function() {
      return constructor.apply(this, args);
    };
    F.prototype = constructor.prototype;
    return new F();
  };


  /**
  * 2次元配列からLoadQueueのマニフェスト配列を作成
  * @param {Array} 2次元配列
  * @return {Array} マニフェスト配列
   */

  makeAssets = function(list) {
    var item, _i, _len;
    list = (function() {
      var _i, _len, _results;
      _results = [];
      for (_i = 0, _len = list.length; _i < _len; _i++) {
        item = list[_i];
        _results.push({
          id: item[0],
          src: getRetinaPath(item[1])
        });
      }
      return _results;
    })();
    if (Config.IS_FIREFOX) {
      for (_i = 0, _len = list.length; _i < _len; _i++) {
        item = list[_i];
        if (item.src.match(/.+\.mp3$/)) {
          item.src = item.src.replace(/\.mp3$/, ".ogg");

          /*if not Config.IS_WEB
          					Config.SOUND_ASSETS[item.id] = item.src
          				else
          					createjs.Sound.registerSound(item.src, item.id)
           */
        }
      }
    }
    return list;
  };


  /**
  * マニフェスト配列内から特定のidのsrc値を取得
  * @param {String} 固有ID
  * @param {Array} マニフェスト配列
  * @return {String|null} src値
   */

  getAssetPathById = function(id, assets) {
    var asset, _i, _len;
    for (_i = 0, _len = assets.length; _i < _len; _i++) {
      asset = assets[_i];
      if (asset.id === id) {
        return asset.src;
      }
    }
    return null;
  };


  /**
  * マニフェスト配列からsrc配列を取得
  * @param {Array} マニフェスト配列
  * @return {Array} src配列
   */

  getAssetPaths = function(assets) {
    var asset;
    return (function() {
      var _i, _len, _results;
      _results = [];
      for (_i = 0, _len = assets.length; _i < _len; _i++) {
        asset = assets[_i];
        _results.push(asset.src);
      }
      return _results;
    })();
  };


  /**
  * Retinaの場合、画像を対応パスに切り替える
  * @param {String} 画像パス 
  * @return {String} 環境に対応した画像パス
   */

  getRetinaPath = function(path) {
    if (Config.IS_RETINA) {
      path = path.replace(/(.+)\.(png|jpe?g|gif)$/, "$1@2x.$2");
    }
    return path;
  };


  /**
  * ピクセル比を取得する 
  * @return {Number} 環境のピクセル比
   */

  getPixelRate = function() {
    if (Config.IS_RETINA) {
      return 2;
    }
    return 1;
  };


  /**
  * 表示ピクセル数値を取得する
  * @param {Number} 基準のピクセル値
  * @return {Number} 表示ピクセル値
   */

  dp = function(base_pixcel) {
    if (base_pixcel == null) {
      base_pixcel = 1;
    }
    return base_pixcel * getPixelRate();
  };


  /**
  * 遅延実行
  * @param {Number} 遅延時間(ミリ秒)
  * @param {Function} 実行関数
  * @return {Number} Timer ID
   */

  delay = function(ms, func) {
    return setTimeout(func, ms);
  };


  /**
  * SE再生エイリアス
  * @param {String} アイテムキー
  * @param {String} 名前空間
   */

  sePlay = function(id, ns) {
    if (ns == null) {
      ns = "global";
    }
    audio.SoundEffectManager.play(id, ns);
  };

  Config.RESOURCES = {
    "global": [['bgm_opening', Config.SOUND_DIR + "bgm_opening.mp3"], ['bgm_game', Config.SOUND_DIR + "bgm_game.mp3"], ['se_high_001', Config.SOUND_DIR + "se_high_001.mp3"], ['se_high_002', Config.SOUND_DIR + "se_high_002.mp3"], ['se_high_003', Config.SOUND_DIR + "se_high_003.mp3"], ['se_high_004', Config.SOUND_DIR + "se_high_004.mp3"], ['se_high_005', Config.SOUND_DIR + "se_high_005.mp3"], ['se_high_006', Config.SOUND_DIR + "se_high_006.mp3"], ['se_high_007', Config.SOUND_DIR + "se_high_007.mp3"], ['se_high_008', Config.SOUND_DIR + "se_high_008.mp3"], ['se_high_009', Config.SOUND_DIR + "se_high_009.mp3"], ['se_high_010', Config.SOUND_DIR + "se_high_010.mp3"], ['se_low_001', Config.SOUND_DIR + "se_low_001.mp3"], ['se_low_002', Config.SOUND_DIR + "se_low_002.mp3"], ['se_low_003', Config.SOUND_DIR + "se_low_003.mp3"], ['se_low_004', Config.SOUND_DIR + "se_low_004.mp3"], ['se_low_005', Config.SOUND_DIR + "se_low_005.mp3"], ['se_low_006', Config.SOUND_DIR + "se_low_006.mp3"], ['se_low_007', Config.SOUND_DIR + "se_low_007.mp3"], ['se_low_008', Config.SOUND_DIR + "se_low_008.mp3"], ['se_low_009', Config.SOUND_DIR + "se_low_009.mp3"], ['se_low_010', Config.SOUND_DIR + "se_low_010.mp3"], ['font_game_num', Config.IMAGE_DIR + "font/game_num.png"], ['font_result_num', Config.IMAGE_DIR + "font/result_num.png"]],
    "title": [['title', Config.IMAGE_DIR + "titlescene/title.png"], ['start', Config.IMAGE_DIR + "titlescene/title_start.png"], ['base', Config.IMAGE_DIR + "titlescene/title_base.jpg"], ['animal_sprite', Config.IMAGE_DIR + "titlescene/animal_sprite.png"]],
    "select": [['title', Config.IMAGE_DIR + "selectscene/stage_select.png"], ['base', Config.IMAGE_DIR + "selectscene/select_base.jpg"], ['bt1', Config.IMAGE_DIR + "selectscene/stage1bt.png"], ['bt2', Config.IMAGE_DIR + "selectscene/stage2bt.png"], ['bt3', Config.IMAGE_DIR + "selectscene/stage3bt.png"], ['bt4', Config.IMAGE_DIR + "selectscene/stage4bt.png"], ['bt5', Config.IMAGE_DIR + "selectscene/stage5bt.png"], ['bt6', Config.IMAGE_DIR + "selectscene/stage6bt.png"], ['bt_disable', Config.IMAGE_DIR + "selectscene/stage_disable.png"], ['gamecenter', Config.IMAGE_DIR + "tmp/gamecenter.png"], ['help', Config.IMAGE_DIR + "tmp/help.png"], ['helptxt', Config.IMAGE_DIR + "tmp/helptxt.png"]],
    "game": [['stagename_001', Config.IMAGE_DIR + "gamescene/land_name_001.png"], ['stagename_002', Config.IMAGE_DIR + "gamescene/land_name_002.png"], ['stagename_003', Config.IMAGE_DIR + "gamescene/land_name_003.png"], ['stagename_004', Config.IMAGE_DIR + "gamescene/land_name_004.png"], ['stagename_005', Config.IMAGE_DIR + "gamescene/land_name_005.png"], ['stage_on', Config.IMAGE_DIR + "gamescene/stage_icon_on.png"], ['stage_off', Config.IMAGE_DIR + "gamescene/stage_icon_off.png"], ['pt', Config.IMAGE_DIR + "gamescene/barPT.png"], ['stage_icon_on', Config.IMAGE_DIR + "gamescene/stage_icon_on.png"], ['stage_icon_off', Config.IMAGE_DIR + "gamescene/stage_icon_off.png"], ['land_name_001', Config.IMAGE_DIR + "gamescene/land_name_001.png"], ['land_name_002', Config.IMAGE_DIR + "gamescene/land_name_002.png"], ['land_name_003', Config.IMAGE_DIR + "gamescene/land_name_003.png"], ['land_name_004', Config.IMAGE_DIR + "gamescene/land_name_004.png"], ['land_name_005', Config.IMAGE_DIR + "gamescene/land_name_005.png"], ['bar_your', Config.IMAGE_DIR + "gamescene/barYousprite.png"], ['bar_com_base', Config.IMAGE_DIR + "gamescene/barComBase.png"], ['bar_coml_001', Config.IMAGE_DIR + "gamescene/barCom1sprite.png"], ['bar_coml_002', Config.IMAGE_DIR + "gamescene/barCom2sprite.png"], ['bar_coml_003', Config.IMAGE_DIR + "gamescene/barCom3sprite.png"], ['bar_coml_004', Config.IMAGE_DIR + "gamescene/barCom4sprite.png"], ['bar_coml_005', Config.IMAGE_DIR + "gamescene/barCom5sprite.png"], ['bar_animal_001', Config.IMAGE_DIR + "gamescene/barAnimal1.png"], ['bar_animal_002', Config.IMAGE_DIR + "gamescene/barAnimal2.png"], ['bar_animal_003', Config.IMAGE_DIR + "gamescene/barAnimal3.png"], ['bar_animal_004', Config.IMAGE_DIR + "gamescene/barAnimal4.png"], ['bar_animal_005', Config.IMAGE_DIR + "gamescene/barAnimal5.png"], ['bar_animal_006', Config.IMAGE_DIR + "gamescene/barAnimal6.png"], ['bar_animal_007', Config.IMAGE_DIR + "gamescene/barAnimal7.png"], ['bar_animal_008', Config.IMAGE_DIR + "gamescene/barAnimal8.png"], ['bar_animal_009', Config.IMAGE_DIR + "gamescene/barAnimal9.png"], ['bar_animal_010', Config.IMAGE_DIR + "gamescene/barAnimal10.png"], ['bar_ok', Config.IMAGE_DIR + "gamescene/barAnimalOK.png"], ['bar_ng', Config.IMAGE_DIR + "gamescene/barAnimalNG.png"], ['bar_hatena', Config.IMAGE_DIR + "gamescene/barAnimal11.png"], ['base_001', Config.IMAGE_DIR + "gamescene/baseStage1.png"], ['base_002', Config.IMAGE_DIR + "gamescene/baseStage2.png"], ['base_003', Config.IMAGE_DIR + "gamescene/baseStage3.png"], ['base_004', Config.IMAGE_DIR + "gamescene/baseStage4.png"], ['base_005', Config.IMAGE_DIR + "gamescene/baseStage5.png"], ['animal_001', Config.IMAGE_DIR + "animal/default1.png"], ['animal_002', Config.IMAGE_DIR + "animal/default2.png"], ['animal_003', Config.IMAGE_DIR + "animal/default3.png"], ['animal_004', Config.IMAGE_DIR + "animal/default4.png"], ['animal_005', Config.IMAGE_DIR + "animal/default5.png"], ['animal_006', Config.IMAGE_DIR + "animal/default6.png"], ['animal_007', Config.IMAGE_DIR + "animal/default7.png"], ['animal_008', Config.IMAGE_DIR + "animal/default8.png"], ['animal_009', Config.IMAGE_DIR + "animal/default9.png"], ['animal_010', Config.IMAGE_DIR + "animal/default10.png"], ['animal_ok_001', Config.IMAGE_DIR + "animal/ok1.png"], ['animal_ok_002', Config.IMAGE_DIR + "animal/ok2.png"], ['animal_ok_003', Config.IMAGE_DIR + "animal/ok3.png"], ['animal_ok_004', Config.IMAGE_DIR + "animal/ok4.png"], ['animal_ok_005', Config.IMAGE_DIR + "animal/ok5.png"], ['animal_ok_006', Config.IMAGE_DIR + "animal/ok6.png"], ['animal_ok_007', Config.IMAGE_DIR + "animal/ok7.png"], ['animal_ok_008', Config.IMAGE_DIR + "animal/ok8.png"], ['animal_ok_009', Config.IMAGE_DIR + "animal/ok9.png"], ['animal_ok_010', Config.IMAGE_DIR + "animal/ok10.png"], ['animal_no_001', Config.IMAGE_DIR + "animal/no1.png"], ['animal_no_002', Config.IMAGE_DIR + "animal/no2.png"], ['animal_no_003', Config.IMAGE_DIR + "animal/no3.png"], ['animal_no_004', Config.IMAGE_DIR + "animal/no4.png"], ['animal_no_005', Config.IMAGE_DIR + "animal/no5.png"], ['animal_no_006', Config.IMAGE_DIR + "animal/no6.png"], ['animal_no_007', Config.IMAGE_DIR + "animal/no7.png"], ['animal_no_008', Config.IMAGE_DIR + "animal/no8.png"], ['animal_no_009', Config.IMAGE_DIR + "animal/no9.png"], ['animal_no_010', Config.IMAGE_DIR + "animal/no10.png"], ['overlay_start1', Config.IMAGE_DIR + "gamescene/modal1Stage1Sprite.png"], ['overlay_start2', Config.IMAGE_DIR + "gamescene/modal1Stage2Sprite.png"], ['overlay_start3', Config.IMAGE_DIR + "gamescene/modal1Stage3Sprite.png"], ['overlay_start4', Config.IMAGE_DIR + "gamescene/modal1Stage4Sprite.png"], ['overlay_start5', Config.IMAGE_DIR + "gamescene/modal1Stage5Sprite.png"], ['overlay_char1', Config.IMAGE_DIR + "gamescene/modal2Stage1Sprite.png"], ['overlay_char2', Config.IMAGE_DIR + "gamescene/modal2Stage2Sprite.png"], ['overlay_char3', Config.IMAGE_DIR + "gamescene/modal2Stage3Sprite.png"], ['overlay_char4', Config.IMAGE_DIR + "gamescene/modal2Stage4Sprite.png"], ['overlay_char5', Config.IMAGE_DIR + "gamescene/modal2Stage5Sprite.png"], ['overlay_char_baloon', Config.IMAGE_DIR + "gamescene/modal2FukiSprite.png"], ['overlay_char_text_demo', Config.IMAGE_DIR + "gamescene/modal2txt.png"], ['overlay_char_text_start', Config.IMAGE_DIR + "gamescene/modal4txt.png"], ['overlay_char_text_clear', Config.IMAGE_DIR + "gamescene/modal5txt.png"], ['overlay_char_text_gameover', Config.IMAGE_DIR + "gamescene/modal6txt.png"], ['overlay_continue_button', Config.IMAGE_DIR + "gamescene/modal5bt.png"], ['overlay_retry_button', Config.IMAGE_DIR + "gamescene/modal6bt.png"], ['se_gameover_001', Config.SOUND_DIR + "gameover_001.mp3"], ['se_gameover_002', Config.SOUND_DIR + "gameover_002.mp3"], ['se_gameover_003', Config.SOUND_DIR + "gameover_003.mp3"], ['se_gameover_004', Config.SOUND_DIR + "gameover_004.mp3"], ['se_gameover_005', Config.SOUND_DIR + "gameover_005.mp3"], ['se_great_001', Config.SOUND_DIR + "great_001.mp3"], ['se_great_002', Config.SOUND_DIR + "great_002.mp3"], ['se_great_003', Config.SOUND_DIR + "great_003.mp3"], ['se_great_004', Config.SOUND_DIR + "great_004.mp3"], ['se_great_005', Config.SOUND_DIR + "great_005.mp3"]],
    "result": [['animal1', Config.IMAGE_DIR + "resultscene/animal1.png"], ['animal2', Config.IMAGE_DIR + "resultscene/animal2.png"], ['animal3', Config.IMAGE_DIR + "resultscene/animal3.png"], ['animal4', Config.IMAGE_DIR + "resultscene/animal4.png"], ['animal5', Config.IMAGE_DIR + "resultscene/animal5.png"], ['animal6', Config.IMAGE_DIR + "resultscene/animal6.png"], ['animal7', Config.IMAGE_DIR + "resultscene/animal7.png"], ['animal8', Config.IMAGE_DIR + "resultscene/animal8.png"], ['animal9', Config.IMAGE_DIR + "resultscene/animal9.png"], ['animal10', Config.IMAGE_DIR + "resultscene/animal10.png"], ['hudBase', Config.IMAGE_DIR + "resultscene/result_base.png"], ['hudTitle1', Config.IMAGE_DIR + "resultscene/stage1clear.png"], ['hudTitle2', Config.IMAGE_DIR + "resultscene/stage2clear.png"], ['hudTitle3', Config.IMAGE_DIR + "resultscene/stage3clear.png"], ['hudTitle4', Config.IMAGE_DIR + "resultscene/stage4clear.png"], ['hudTitle5', Config.IMAGE_DIR + "resultscene/stage5clear.png"], ['hudChara1', Config.IMAGE_DIR + "resultscene/stage1chara.png"], ['hudChara2', Config.IMAGE_DIR + "resultscene/stage2chara.png"], ['hudChara3', Config.IMAGE_DIR + "resultscene/stage3chara.png"], ['hudChara4', Config.IMAGE_DIR + "resultscene/stage4chara.png"], ['hudChara5', Config.IMAGE_DIR + "resultscene/stage5chara.png"], ['hudLandScore', Config.IMAGE_DIR + "resultscene/landscore.png"], ['hudTotalScore', Config.IMAGE_DIR + "resultscene/totalscore.png"], ['hudNextButton', Config.IMAGE_DIR + "resultscene/nextLandBt.png"], ['hudSelectButton', Config.IMAGE_DIR + "resultscene/selectLandBt.png"], ['hudRank1', Config.IMAGE_DIR + "resultscene/lank1.png"], ['hudRank2', Config.IMAGE_DIR + "resultscene/lank2.png"], ['hudRank3', Config.IMAGE_DIR + "resultscene/lank3.png"], ['hudRank4', Config.IMAGE_DIR + "resultscene/lank4.png"], ['hudRank5', Config.IMAGE_DIR + "resultscene/lank5.png"], ['numFont', Config.IMAGE_DIR + "font/result_num.png"], ['gamecenter', Config.IMAGE_DIR + "tmp/gamecenter.png"]],
    "infinity": [['animal_ok_001', Config.IMAGE_DIR + "animal/ok1.png"], ['animal_ok_002', Config.IMAGE_DIR + "animal/ok2.png"], ['animal_ok_003', Config.IMAGE_DIR + "animal/ok3.png"], ['animal_ok_004', Config.IMAGE_DIR + "animal/ok4.png"], ['animal_ok_005', Config.IMAGE_DIR + "animal/ok5.png"], ['animal_ok_006', Config.IMAGE_DIR + "animal/ok6.png"], ['animal_ok_007', Config.IMAGE_DIR + "animal/ok7.png"], ['animal_ok_008', Config.IMAGE_DIR + "animal/ok8.png"], ['animal_ok_009', Config.IMAGE_DIR + "animal/ok9.png"], ['animal_ok_010', Config.IMAGE_DIR + "animal/ok10.png"], ['animal_no_001', Config.IMAGE_DIR + "animal/no1.png"], ['animal_no_002', Config.IMAGE_DIR + "animal/no2.png"], ['animal_no_003', Config.IMAGE_DIR + "animal/no3.png"], ['animal_no_004', Config.IMAGE_DIR + "animal/no4.png"], ['animal_no_005', Config.IMAGE_DIR + "animal/no5.png"], ['animal_no_006', Config.IMAGE_DIR + "animal/no6.png"], ['animal_no_007', Config.IMAGE_DIR + "animal/no7.png"], ['animal_no_008', Config.IMAGE_DIR + "animal/no8.png"], ['animal_no_009', Config.IMAGE_DIR + "animal/no9.png"], ['animal_no_010', Config.IMAGE_DIR + "animal/no10.png"]]
  };

  Config.EVENTS = {
    GAME_CENTER_SHOWED: "game_center_showed",
    GAME_CENTER_HIDED: "game_center_hided"
  };

  AssetsManager = (function() {
    AssetsManager._INSTANCE = null;

    AssetsManager.getInstance = function() {
      if (AssetsManager._INSTANCE === null) {
        AssetsManager._INSTANCE = new AssetsManagerSingleton();
      }
      return AssetsManager._INSTANCE;
    };

    function AssetsManager() {
      return;
    }

    return AssetsManager;

  })();

  AssetsManagerSingleton = (function() {
    function AssetsManagerSingleton() {
      this._fileLoadComplete = __bind(this._fileLoadComplete, this);
      this.load = __bind(this.load, this);
      this.getTag = __bind(this.getTag, this);
      this.getItem = __bind(this.getItem, this);
      this.init = __bind(this.init, this);
    }

    AssetsManagerSingleton.prototype._resouces = [];

    AssetsManagerSingleton.prototype.init = function(list) {
      for (key in list) {
        val = list[key];
        list[key] = makeAssets(val);
      }
      return this._resouces = list;
    };

    AssetsManagerSingleton.prototype.getItem = function(name, scene_id) {
      var data, _i, _len, _ref;
      if (scene_id == null) {
        scene_id = "global";
      }
      if (scene_id in this._resouces) {
        _ref = this._resouces[scene_id];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          data = _ref[_i];
          if (data.id === name) {
            if ("loaded" in data) {
              return data.loaded;
            }
          }
        }
      }
    };

    AssetsManagerSingleton.prototype.getTag = function(name, scene_id) {
      var data, _i, _len, _ref;
      if (scene_id == null) {
        scene_id = "global";
      }
      if (scene_id in this._resouces) {
        _ref = this._resouces[scene_id];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          data = _ref[_i];
          if (data.id === name) {
            if ("loaded" in data && "tag" in data.loaded) {
              return data.loaded.tag;
            }
          }
        }
      }
    };

    AssetsManagerSingleton.prototype.load = function(scene_id, callback) {
      var isNative, item, manifest, queue, _i, _len, _ref;
      if (scene_id in this._resouces) {
        manifest = [];
        isNative = typeof Media !== "undefined" && Media !== null;
        _ref = this._resouces[scene_id];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          item = _ref[_i];
          if (!("loaded" in item)) {
            item.scene_id = scene_id;
            if (isNative && !!item.src.match(/\.mp3$/)) {
              item.loaded = new Media(item.src, null, null);
            } else {
              manifest.push(item);
            }
          }
        }
        if (manifest.length > 0) {
          queue = new createjs.LoadQueue(false);
          queue.installPlugin(createjs.Sound);
          queue.addEventListener('complete', callback);
          queue.addEventListener("fileload", this._fileLoadComplete);
          queue.addEventListener('error', (function(_this) {
            return function(e) {
              return console.log("load_error", e.item.src);
            };
          })(this));
          queue.loadManifest(manifest);
          return;
        }
      }
      callback();
    };

    AssetsManagerSingleton.prototype._fileLoadComplete = function(e) {
      var data, item, _i, _len, _ref;
      item = e.item;
      _ref = this._resouces[item.scene_id];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        data = _ref[_i];
        if (data.id === item.id) {
          console.log(item);
          data.loaded = item;
          return;
        }
      }
    };

    return AssetsManagerSingleton;

  })();

  if (typeof namespace === "function") {
    namespace("util", function() {
      return AssetsManager;
    });
  }

  EventDispatcher = (function() {
    EventDispatcher.prototype._events = {};

    function EventDispatcher() {
      this.dispatchEvent = __bind(this.dispatchEvent, this);
      this.clearAllEventListener = __bind(this.clearAllEventListener, this);
      this.removeEventListener = __bind(this.removeEventListener, this);
      this.addEventListener = __bind(this.addEventListener, this);
      return;
    }

    EventDispatcher.prototype.addEventListener = function(key, method) {
      var events;
      if (!key) {
        return;
      }
      events = [];
      if (key in this._events) {
        events = this._events[key];
      }
      if (typeof method === 'function') {
        events.push(method);
        this._events[key] = events;
      }
    };

    EventDispatcher.prototype.removeEventListener = function(key, method) {
      var current_arr, current_method, make_arr, _i, _len;
      if (method == null) {
        method = null;
      }
      if (!key) {
        return;
      }
      if (method === null) {
        delete this._events[key];
      } else if (typeof method === 'function' && key in this._events) {
        make_arr = [];
        current_arr = this._events[key];
        for (_i = 0, _len = current_arr.length; _i < _len; _i++) {
          current_method = current_arr[_i];
          if (current_method !== method) {
            make_arr.push(current_method);
          }
        }
        this._events[key] = make_arr;
      }
    };

    EventDispatcher.prototype.clearAllEventListener = function() {
      this._events = {};
    };

    EventDispatcher.prototype.dispatchEvent = function() {
      var args, e, event_arr, event_object, key, _i, _len;
      key = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
      if (!key) {
        return;
      }
      if (key in this._events) {
        event_arr = this._events[key];
        event_object = {
          type: key
        };
        args.unshift(event_object);
        for (_i = 0, _len = event_arr.length; _i < _len; _i++) {
          e = event_arr[_i];
          e.apply(null, args);
        }
      }
    };

    return EventDispatcher;

  })();

  if (typeof namespace === "function") {
    namespace("util", function() {
      return EventDispatcher;
    });
  }

  GameManager = (function() {
    GameManager.prototype._questions = [];

    GameManager.prototype._answers = [];

    GameManager.prototype._chain_count = 0;

    function GameManager(_at__len, _at__item_count) {
      var i, _i, _ref;
      this._len = _at__len != null ? _at__len : 0;
      this._item_count = _at__item_count != null ? _at__item_count : 6;
      this.getCurrentTapPoint = __bind(this.getCurrentTapPoint, this);
      this.isCurrentCorrectAnswer = __bind(this.isCurrentCorrectAnswer, this);
      this.getAverage = __bind(this.getAverage, this);
      this.getAnswers = __bind(this.getAnswers, this);
      this.isComplete = __bind(this.isComplete, this);
      this.getChoiceStack = __bind(this.getChoiceStack, this);
      this.addChoiceStack = __bind(this.addChoiceStack, this);
      this.getQuestions = __bind(this.getQuestions, this);
      if (this._len < 0 || isNaN(this._len)) {
        this._len = 0;
      }
      if (this._item_count < 0 || isNaN(this._item_count)) {
        this._item_count = 0;
      }
      this._questions = [];
      this._answers = [];
      for (i = _i = 0, _ref = this._len; 0 <= _ref ? _i < _ref : _i > _ref; i = 0 <= _ref ? ++_i : --_i) {
        this._questions.push(Math.floor(Math.random() * this._item_count));
      }
      return;
    }

    GameManager.prototype.getQuestions = function() {
      return this._questions;
    };

    GameManager.prototype.addChoiceStack = function(num) {
      if (isNaN(num)) {
        return false;
      }
      if ((0 <= num && num < this._item_count) && this._answers.length < this._len) {
        this._answers.push(num);
        if (this.isCurrentCorrectAnswer()) {
          this._chain_count += 1;
        } else {
          this._chain_count = 0;
        }
        return true;
      }
      return false;
    };

    GameManager.prototype.getChoiceStack = function() {
      return this._answers;
    };

    GameManager.prototype.isComplete = function() {
      if (this._len !== 0 && this._answers.length === this._len) {
        return true;
      }
      return false;
    };

    GameManager.prototype.getAnswers = function() {
      var arr, i, _i, _ref;
      arr = [];
      for (i = _i = 0, _ref = this._questions.length; 0 <= _ref ? _i < _ref : _i > _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (i < this._answers.length) {
          if (this._questions[i] === this._answers[i]) {
            arr.push(1);
          } else {
            arr.push(2);
          }
        } else {
          arr.push(0);
        }
      }
      return arr;
    };

    GameManager.prototype.getAverage = function() {
      var arr, arr_success, av, num;
      arr = this.getAnswers();
      arr_success = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = arr.length; _i < _len; _i++) {
          num = arr[_i];
          if (num === 1) {
            _results.push(num);
          }
        }
        return _results;
      })();
      av = arr_success.length / arr.length;
      if (!isNaN(av) && (0 <= av && av <= 1)) {
        return av;
      }
      return 0;
    };

    GameManager.prototype.isCurrentCorrectAnswer = function() {
      var len;
      len = this._answers.length;
      if (len <= 0) {
        return false;
      }
      if (this._answers[len - 1] === this._questions[len - 1]) {
        return true;
      }
      return false;
    };

    GameManager.prototype.getCurrentTapPoint = function(base, chain) {
      if (base < 0 || isNaN(base)) {
        base = 0;
      }
      if (chain < 0 || isNaN(chain)) {
        chain = 0;
      }
      if (this.isCurrentCorrectAnswer()) {
        return Math.floor(base * (1 + chain * Math.max(0, this._chain_count - 1)));
      }
      return 0;
    };

    return GameManager;

  })();

  if (typeof namespace === "function") {
    namespace("util", function() {
      return GameManager;
    });
  }

  BgmManager = (function() {
    function BgmManager() {}

    BgmManager._INSTANCE = null;

    BgmManager.getInstance = function() {
      if (BgmManager._INSTANCE === null) {
        BgmManager._INSTANCE = new BgmManagerSingleton();
      }
      return BgmManager._INSTANCE;
    };

    return BgmManager;

  })();

  BgmManagerSingleton = (function() {
    BgmManagerSingleton.prototype._current_id = "";

    BgmManagerSingleton.prototype._current_ns = "";

    BgmManagerSingleton.prototype._current_bgm = null;

    BgmManagerSingleton.prototype._is_native = false;

    BgmManagerSingleton.prototype._timer = 0;

    BgmManagerSingleton.prototype._current_volume = 0;

    BgmManagerSingleton.prototype._auto_play = false;

    function BgmManagerSingleton() {
      this._setVolume = __bind(this._setVolume, this);
      this._fadeIn = __bind(this._fadeIn, this);
      this._fadeOut = __bind(this._fadeOut, this);
      this._play = __bind(this._play, this);
      this.stop = __bind(this.stop, this);
      this.play = __bind(this.play, this);
      if (typeof Media !== "undefined" && Media !== null) {
        this._is_native = true;
      }
      return;
    }

    BgmManagerSingleton.prototype.play = function(id, ns) {
      if (ns == null) {
        ns = "global";
      }
      if (this._current_id !== id || this._current_ns !== ns) {
        this._current_id = id;
        this._current_ns = ns;
        if (this._current_bgm) {
          this._auto_play = true;
          this._fadeOut();
        } else {
          this._play();
        }
      }
    };

    BgmManagerSingleton.prototype.stop = function() {
      this._auto_play = false;
      this._fadeOut();
    };

    BgmManagerSingleton.prototype._play = function() {
      var manager, tag, _ref, _ref1;
      if (this._current_id && this._current_ns) {
        this._current_volume = 0;
        manager = util.AssetsManager.getInstance();
        if (this._is_native) {
          this._current_bgm = manager.getItem(this._current_id, this._current_ns);
          if ((_ref = this._current_bgm) != null) {
            _ref.setVolume(this._current_volume.toString());
          }
          if ((_ref1 = this._current_bgm) != null) {
            _ref1.play({
              playAudioWhenScreenIsLocked: false,
              numberOfLoops: 0
            });
          }
        } else {
          tag = manager.getTag(this._current_id, this._current_ns);
          if (tag != null) {
            this._current_bgm = createjs.Sound.createInstance(tag.src);
            this._current_bgm.setVolume(this._current_volume);
            this._current_bgm.play(createjs.Sound.INTERRUPT_NONE, 0, 0, -1);
          }
        }
        this._fadeIn();
      }
    };

    BgmManagerSingleton.prototype._fadeOut = function() {
      clearTimeout(this._timer);
      this._current_volume -= 0.1;
      if (this._current_volume <= 0) {
        this._current_bgm.stop();
        if (this._auto_play) {
          this._play();
        }
      } else {
        this._setVolume(this._current_volume);
        this._timer = delay(100, this._fadeOut);
      }
    };

    BgmManagerSingleton.prototype._fadeIn = function() {
      clearTimeout(this._timer);
      this._current_volume += 0.1;
      if (this._current_volume >= 1) {
        this._current_volume = 1;
        this._setVolume(this._current_volume);
      } else {
        this._setVolume(this._current_volume);
        this._timer = delay(100, this._fadeIn);
      }
    };

    BgmManagerSingleton.prototype._setVolume = function() {
      if (this._is_native) {
        this._current_bgm.setVolume(this._current_volume.toString());
      } else {
        if (this._current_bgm) {
          this._current_bgm.setVolume(this._current_volume);
        }
      }
    };

    return BgmManagerSingleton;

  })();

  namespace('audio', function() {
    return BgmManager;
  });

  SoundEffectManager = (function() {
    SoundEffectManager.currentSound = null;

    function SoundEffectManager() {
      return;
    }

    SoundEffectManager.play = function(id, ns) {
      var manager, media, tag, _ref;
      if (ns == null) {
        ns = "global";
      }
      manager = util.AssetsManager.getInstance();
      if (typeof Media !== "undefined" && Media !== null) {
        media = manager.getItem(id, ns);
        if (media != null) {
          media.play({
            playAudioWhenScreenIsLocked: false,
            numberOfLoops: 1
          });
        }
      } else {
        tag = manager.getTag(id, ns);
        if (tag != null) {
          if (((_ref = SoundEffectManager.currentSound) != null ? _ref.src : void 0) === tag.src) {
            SoundEffectManager.currentSound.stop();
          }
          SoundEffectManager.currentSound = createjs.Sound.createInstance(tag.src);

          /*SoundEffectManager.currentSound.addEventListener("failed", SoundEffectManager._hundleEvents);
          				SoundEffectManager.currentSound.addEventListener("interrupted", SoundEffectManager._hundleEvents);
          				SoundEffectManager.currentSound.addEventListener("succeeded", SoundEffectManager._hundleEvents);
          				SoundEffectManager.currentSound.addEventListener("complete", SoundEffectManager._hundleEvents);
          				SoundEffectManager.currentSound.addEventListener("loop", SoundEffectManager._hundleEvents);
           */
          SoundEffectManager.currentSound.play(createjs.Sound.ANY, 0, 0, 0);
        }
      }
    };

    SoundEffectManager._hundleEvents = function(event) {
      if (event.type === "failed") {
        return console.log("falure");
      }
    };

    return SoundEffectManager;

  })();

  namespace('audio', function() {
    return SoundEffectManager;
  });

  PlayerData = (function() {
    PlayerData._LAND_COMPLETE_KEY = "land_complete_key";

    PlayerData.CHARA_MOBS_COUNT = 5;

    PlayerData.CHARA_MAX_COUNT = 10;

    PlayerData._INSTANCE = null;

    PlayerData.getInstance = function() {
      if (PlayerData._INSTANCE === null) {
        PlayerData._INSTANCE = new PlayerDataSingleton();
      }
      return PlayerData._INSTANCE;
    };

    function PlayerData() {
      return;
    }

    return PlayerData;

  })();

  PlayerDataSingleton = (function() {
    PlayerDataSingleton.prototype._palette = [];

    PlayerDataSingleton.prototype._history = [];

    PlayerDataSingleton.prototype._accuracy = [];

    PlayerDataSingleton.prototype._point = 0;

    PlayerDataSingleton.prototype._rand_point = 0;

    function PlayerDataSingleton() {
      this._getLandKeyById = __bind(this._getLandKeyById, this);
      this.clearAllLandCompleteFlag = __bind(this.clearAllLandCompleteFlag, this);
      this.getCompleteFlagByLandId = __bind(this.getCompleteFlagByLandId, this);
      this.isActiveLand = __bind(this.isActiveLand, this);
      this.setCompleteFlagByLandId = __bind(this.setCompleteFlagByLandId, this);
      this.getLandAccuracy = __bind(this.getLandAccuracy, this);
      this.addLandAccuracy = __bind(this.addLandAccuracy, this);
      this.clearRandPoint = __bind(this.clearRandPoint, this);
      this.getRandPoint = __bind(this.getRandPoint, this);
      this.clearPoint = __bind(this.clearPoint, this);
      this.getPoint = __bind(this.getPoint, this);
      this.addPoint = __bind(this.addPoint, this);
      this.clearTapHistories = __bind(this.clearTapHistories, this);
      this.getTapHistories = __bind(this.getTapHistories, this);
      this.addTapHistoryByIndex = __bind(this.addTapHistoryByIndex, this);
      this.getPalette = __bind(this.getPalette, this);
      this.makePaletteByRandId = __bind(this.makePaletteByRandId, this);
      return;
    }

    PlayerDataSingleton.prototype.makePaletteByRandId = function(rand_id) {
      var add_id, arr, _i, _ref, _results;
      if (!rand_id || isNaN(rand_id)) {
        rand_id = 1;
      }
      rand_id = parseInt(rand_id, 10);
      arr = (function() {
        _results = [];
        for (var _i = 1, _ref = PlayerData.CHARA_MOBS_COUNT; 1 <= _ref ? _i <= _ref : _i >= _ref; 1 <= _ref ? _i++ : _i--){ _results.push(_i); }
        return _results;
      }).apply(this);
      add_id = PlayerData.CHARA_MOBS_COUNT + rand_id;
      if (add_id > PlayerData.CHARA_MAX_COUNT) {
        add_id = PlayerData.CHARA_MAX_COUNT;
      }
      arr.push(add_id);
      this._palette = _.shuffle(arr);
    };

    PlayerDataSingleton.prototype.getPalette = function() {
      return this._palette;
    };

    PlayerDataSingleton.prototype.addTapHistoryByIndex = function(index) {
      if (!isNaN(index) && (0 <= index && index < this._palette.length)) {
        this._history.push(this._palette[index]);
      }
    };

    PlayerDataSingleton.prototype.getTapHistories = function() {
      return this._history;
    };

    PlayerDataSingleton.prototype.clearTapHistories = function() {
      this._history = [];
    };

    PlayerDataSingleton.prototype.addPoint = function(point) {
      if (point == null) {
        point = 0;
      }
      if (!isNaN(point) && 0 < point) {
        point = Math.floor(point);
        this._point += point;
        this._rand_point += point;
      }
    };

    PlayerDataSingleton.prototype.getPoint = function() {
      return this._point;
    };

    PlayerDataSingleton.prototype.clearPoint = function() {
      this._point = 0;
    };

    PlayerDataSingleton.prototype.getRandPoint = function() {
      return this._rand_point;
    };

    PlayerDataSingleton.prototype.clearRandPoint = function() {
      this.clearPoint();
      this._rand_point = 0;
      this._accuracy = [];
    };

    PlayerDataSingleton.prototype.addLandAccuracy = function(bool) {
      this._accuracy.push(bool);
    };

    PlayerDataSingleton.prototype.getLandAccuracy = function() {
      var ac, bool, true_arr;
      true_arr = (function() {
        var _i, _len, _ref, _results;
        _ref = this._accuracy;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          bool = _ref[_i];
          if (bool) {
            _results.push(bool);
          }
        }
        return _results;
      }).call(this);
      ac = true_arr.length / this._accuracy.length;
      if (!isNaN(ac) && (0 <= ac && ac <= 1)) {
        return ac;
      }
      return 0;
    };

    PlayerDataSingleton.prototype.setCompleteFlagByLandId = function(land_id) {
      var container, storage;
      key = this._getLandKeyById(land_id);
      storage = typeof window !== "undefined" && window !== null ? window.localStorage : void 0;
      if (storage) {
        container = JSON.parse(storage.getItem(PlayerData._LAND_COMPLETE_KEY));
        if (!container) {
          container = {};
        }
        container[key] = true;
        storage.setItem(PlayerData._LAND_COMPLETE_KEY, JSON.stringify(container));
      }
    };

    PlayerDataSingleton.prototype.isActiveLand = function(land_id) {
      if (land_id <= 1) {
        return true;
      }
      return this.getCompleteFlagByLandId(land_id - 1);
    };

    PlayerDataSingleton.prototype.getCompleteFlagByLandId = function(land_id) {
      var container, storage;
      key = this._getLandKeyById(land_id);
      storage = typeof window !== "undefined" && window !== null ? window.localStorage : void 0;
      if (storage) {
        container = JSON.parse(storage.getItem(PlayerData._LAND_COMPLETE_KEY));
        if (container) {
          return (key in container) && !!container[key];
        }
      }
      return false;
    };

    PlayerDataSingleton.prototype.clearAllLandCompleteFlag = function() {
      var storage;
      storage = typeof window !== "undefined" && window !== null ? window.localStorage : void 0;
      if (storage) {
        storage.removeItem(PlayerData._LAND_COMPLETE_KEY);
      }
    };

    PlayerDataSingleton.prototype._getLandKeyById = function(land_id) {
      return "land_" + land_id;
    };

    return PlayerDataSingleton;

  })();

  if (typeof namespace === "function") {
    namespace("data", function() {
      return PlayerData;
    });
  }

  LandStartAnimation = (function(_super) {
    __extends(LandStartAnimation, _super);

    function LandStartAnimation(_at__landId) {
      this._landId = _at__landId;
      LandStartAnimation.__super__.constructor.call(this);
      return;
    }

    return LandStartAnimation;

  })(createjs.BitmapAnimation);

  namespace('display.animation', function() {
    return LandStartAnimation;
  });

  AnimalPilingBG = (function(_super) {
    __extends(AnimalPilingBG, _super);

    AnimalPilingBG.FALL_SPEED_IN_PIXEL_PER_SEC = dp(60);

    AnimalPilingBG.FALL_DELAY_PER_ITEM_MSEC = 50;

    AnimalPilingBG.prototype._numRows = 0;

    AnimalPilingBG.prototype._gridWidth = 0;

    AnimalPilingBG.prototype._gridHeight = 0;

    AnimalPilingBG.prototype._history = null;

    AnimalPilingBG.prototype._base = null;

    function AnimalPilingBG(_at__history, _at__numRows, gridAspect) {
      this._history = _at__history;
      this._numRows = _at__numRows != null ? _at__numRows : 6;
      if (gridAspect == null) {
        gridAspect = 1;
      }
      this._getPosition = __bind(this._getPosition, this);
      this._pileAnimal = __bind(this._pileAnimal, this);
      this._init = __bind(this._init, this);
      this.fallAnimals = __bind(this.fallAnimals, this);
      AnimalPilingBG.__super__.constructor.call(this);
      this._gridWidth = Math.floor(Main.STAGE_WIDTH / this._numRows);
      this._gridHeight = this._gridWidth * gridAspect;
      this._init();
      return;
    }

    AnimalPilingBG.prototype.fallAnimals = function() {
      var animalId, i, _i, _len, _ref;
      _ref = this._history;
      for (i = _i = 0, _len = _ref.length; _i < _len; i = ++_i) {
        animalId = _ref[i];
        setTimeout(this._pileAnimal(animalId, i), i * AnimalPilingBG.FALL_DELAY_PER_ITEM_MSEC);
      }
    };

    AnimalPilingBG.prototype._init = function() {
      this._base = this.addChildAt(new createjs.Shape(new createjs.Graphics().beginFill("#009900").drawRect(0, 0, Main.STAGE_WIDTH, Main.STAGE_HEIGHT).endFill()), 0);
    };

    AnimalPilingBG.prototype._pileAnimal = function(animalId, index) {
      return (function(_this) {
        return function() {
          var animal, fallDuration, pos, xPos, yPos, _assets;
          _assets = util.AssetsManager.getInstance();
          animal = new createjs.Bitmap(_assets.getTag(_.str.sprintf("animal%d", animalId), "result"));
          pos = _this._getPosition(index);
          xPos = pos.x * _this._gridWidth;
          yPos = Main.STAGE_HEIGHT - pos.y * _this._gridHeight;
          animal.x = xPos;
          animal.y = -_this._gridHeight;
          fallDuration = 1000 * (pos.y + 1) * _this._gridHeight / AnimalPilingBG.FALL_SPEED_IN_PIXEL_PER_SEC;
          createjs.Tween.get(animal).to({
            y: yPos
          }, fallDuration, createjs.Ease.bounceOut);
          return _this.addChild(animal);
        };
      })(this);
    };

    AnimalPilingBG.prototype._getPosition = function(index) {
      var pos;
      pos = {
        x: index % this._numRows,
        y: Math.floor(index / this._numRows) + 1
      };
      return pos;
    };

    return AnimalPilingBG;

  })(createjs.Container);

  namespace('display.hud', function() {
    return AnimalPilingBG;
  });

  GameSceneOverlay = (function(_super) {
    __extends(GameSceneOverlay, _super);

    GameSceneOverlay.EVENT = {
      LAND_START: 0,
      DEMONSTRATION_START: 1,
      GAME_START: 2,
      GAME_OVER: 3,
      STAGE_CLEAR: 4
    };

    GameSceneOverlay.FADE_DURATION = 500;

    GameSceneOverlay.TALK_WAIT = 3000;

    GameSceneOverlay.prototype._callbackFunction = null;

    GameSceneOverlay.prototype._callbackScope = null;

    GameSceneOverlay.prototype._base = null;

    GameSceneOverlay.prototype._startAnimation = null;

    GameSceneOverlay.prototype._charactorSprite = null;

    GameSceneOverlay.prototype._continueButton = null;

    GameSceneOverlay.prototype._retryButton = null;

    GameSceneOverlay.prototype._timeoutId = null;

    function GameSceneOverlay(_at__landId) {
      this._landId = _at__landId;
      this._makeBaloonContent = __bind(this._makeBaloonContent, this);
      this._continueButtonHandler = __bind(this._continueButtonHandler, this);
      this._retryButtonHandler = __bind(this._retryButtonHandler, this);
      this._onFinish = __bind(this._onFinish, this);
      this._onCountDownAnimationFinished = __bind(this._onCountDownAnimationFinished, this);
      this._onStartAnimationFinished = __bind(this._onStartAnimationFinished, this);
      this._countDown = __bind(this._countDown, this);
      this._postShow = __bind(this._postShow, this);
      this._preShow = __bind(this._preShow, this);
      this._resetContents = __bind(this._resetContents, this);
      this.show = __bind(this.show, this);
      GameSceneOverlay.__super__.constructor.call(this);
      this._base = new createjs.Shape();
      this._base.graphics.beginFill("#000").drawRect(0, 0, Main.STAGE_WIDTH, Main.STAGE_HEIGHT).endFill();
      this._base.alpha = 0.5;
      this._base.addEventListener("click", function() {});
      this._startAnimation = new createjs.BitmapAnimation(new createjs.SpriteSheet({
        images: [getRetinaPath(Config.IMAGE_DIR + 'gamescene/modal1Stage' + this._landId + 'Sprite.png')],
        frames: {
          width: dp(320),
          height: dp(100)
        },
        animations: {
          start: {
            frames: [0, 1, 2, 3],
            next: false,
            frequency: 2
          }
        }
      }));
      this._startAnimation.x = (Main.STAGE_WIDTH - dp(320)) * 0.5;
      this._startAnimation.y = (Main.STAGE_HEIGHT - dp(100)) * 0.5;
      this._charactorSprite = new display.sprite.CharactorWithBaloon(this._landId);
      this._charactorSprite.x = (Main.STAGE_WIDTH - this._charactorSprite.width) * 0.5;
      this._charactorSprite.y = (Main.STAGE_HEIGHT - this._charactorSprite.height) * 0.5;

      /*
      		@_countDownSprite = new createjs.BitmapAnimation(new createjs.SpriteSheet(
      			{
      				images: [getRetinaPath(Config.IMAGE_DIR + 'gamescene/modal3Sprite.png')]
      				frames: {width: dp(80), height: dp(120)}
      				animations: {
      					countDowm:{frames:[0..2], next:false, frequency:Config.FPS}
      				}
      			}))
      		@_countDownSprite.x = (Main.STAGE_WIDTH-dp(80))*0.5
      		@_countDownSprite.y = (Main.STAGE_HEIGHT-dp(120))*0.5
       */
      this._continueButton = new display.ui.DisplayStateButton(new createjs.Bitmap(Config.IMAGE_DIR + getRetinaPath("gamescene/modal5bt.png")));
      this._continueButton.y = this._charactorSprite.y + this._charactorSprite.height + dp(10);
      this._continueButton.x = (Main.STAGE_WIDTH - this._continueButton.width) * 0.5;
      this._retryButton = new display.ui.DisplayStateButton(new createjs.Bitmap(Config.IMAGE_DIR + getRetinaPath("gamescene/modal6bt.png")));
      this._retryButton.y = this._charactorSprite.y + this._charactorSprite.height + dp(10);
      this._retryButton.x = (Main.STAGE_WIDTH - this._retryButton.width) * 0.5;
      this.visible = false;
      this.alpha = 0;
      return;
    }

    GameSceneOverlay.prototype.show = function(type, _at__callbackFunction, _at__callbackScope) {
      this._callbackFunction = _at__callbackFunction;
      this._callbackScope = _at__callbackScope;
      this._resetContents();
      this._preShow(type);
      if (this.alpha === 1) {
        return this._postShow(type);
      } else {
        return createjs.Tween.get(this).to({
          alpha: 1
        }, GameSceneOverlay.FADE_DURATION).call(this._postShow, [type], this);
      }
    };

    GameSceneOverlay.prototype._resetContents = function() {
      this.removeAllChildren();
      this.addChild(this._base);
      this._charactorSprite.x = (Main.STAGE_WIDTH - this._charactorSprite.width) * 0.5;
      this._charactorSprite.y = (Main.STAGE_HEIGHT - this._charactorSprite.height) * 0.5;
      this._charactorSprite.reset();
      return this.visible = true;
    };

    GameSceneOverlay.prototype._preShow = function(type) {
      this.visible = true;
      switch (type) {
        case GameSceneOverlay.EVENT.LAND_START:
          this._startAnimation.alpha = 1.0;
          this.addChild(this._startAnimation);
          return this._startAnimation.gotoAndStop("start");
        case GameSceneOverlay.EVENT.DEMONSTRATION_START:
          this.addChild(this._charactorSprite);
          break;
        case GameSceneOverlay.EVENT.GAME_START:
          this.addChild(this._charactorSprite);
          break;
        case GameSceneOverlay.EVENT.GAME_OVER:
          this.addChild(this._charactorSprite);
          this.addChild(this._retryButton);
          break;
        case GameSceneOverlay.EVENT.STAGE_CLEAR:
          this.addChild(this._charactorSprite);
          this.addChild(this._continueButton);
      }
    };

    GameSceneOverlay.prototype._postShow = function(type) {
      switch (type) {
        case GameSceneOverlay.EVENT.LAND_START:
          this._startAnimation.addEventListener("animationend", this._onStartAnimationFinished);
          this.addEventListener("click", this._onStartAnimationFinished);
          return this._startAnimation.gotoAndPlay("start");
        case GameSceneOverlay.EVENT.DEMONSTRATION_START:
          this.addEventListener("click", this._onCountDownAnimationFinished);
          this._charactorSprite.talk(this._makeBaloonContent(type));
          this._timeoutId = setTimeout(this._onCountDownAnimationFinished, GameSceneOverlay.TALK_WAIT);
          break;
        case GameSceneOverlay.EVENT.GAME_START:
          this.addEventListener("click", this._onCountDownAnimationFinished);
          this._charactorSprite.talk(this._makeBaloonContent(type));
          this._timeoutId = setTimeout(this._onCountDownAnimationFinished, GameSceneOverlay.TALK_WAIT);
          break;
        case GameSceneOverlay.EVENT.GAME_OVER:
          this._charactorSprite.talk(this._makeBaloonContent(type));
          this.addEventListener("click", this._retryButtonHandler);
          break;
        case GameSceneOverlay.EVENT.STAGE_CLEAR:
          this._charactorSprite.talk(this._makeBaloonContent(type));
          this.addEventListener("click", this._continueButtonHandler);
      }
    };

    GameSceneOverlay.prototype._countDown = function() {

      /*
      		@_charactorSprite.shutup()
      		createjs.Tween.get(@_charactorSprite).to({y:Main.STAGE_HEIGHT}, GameSceneOverlay.FADE_DURATION)
      		createjs.Tween.get(@_countDownSprite).to({alpha:1}, GameSceneOverlay.FADE_DURATION)
      		createjs.Tween.get(@_base).to({alpha:0}, GameSceneOverlay.FADE_DURATION).call(=>
      			@_countDownSprite.visible = true
      			@_countDownSprite.alpha = 1.0
      			@_countDownSprite.addEventListener("animationend", @_onCountDownAnimationFinished)
      			@_countDownSprite.gotoAndPlay("countDowm"))
       */
    };

    GameSceneOverlay.prototype._onStartAnimationFinished = function(event) {
      this.removeEventListener("click", this._onStartAnimationFinished);
      this._startAnimation.removeEventListener("animationend", this._onStartAnimationFinished);
      return createjs.Tween.get(this._startAnimation).to({
        alpha: 0
      }, GameSceneOverlay.FADE_DURATION).call(this._onFinish, [], this);
    };

    GameSceneOverlay.prototype._onCountDownAnimationFinished = function(event) {
      clearTimeout(this._timeoutId);
      this.removeEventListener("click", this._onCountDownAnimationFinished);
      return createjs.Tween.get(this).to({
        alpha: 0
      }, GameSceneOverlay.FADE_DURATION).call(this._onFinish, [], this);
    };

    GameSceneOverlay.prototype._onFinish = function() {
      this.visible = false;
      if (this._callbackFunction) {
        return this._callbackFunction.call(this._callbackScope);
      }
    };

    GameSceneOverlay.prototype._retryButtonHandler = function() {
      this.removeEventListener("click", this._retryButtonHandler);
      return Main.INSTANCE.changeScene('title');
    };

    GameSceneOverlay.prototype._continueButtonHandler = function() {
      this.removeEventListener("click", this._continueButtonHandler);
      return createjs.Tween.get(this).to({
        alpha: 0
      }, GameSceneOverlay.FADE_DURATION).call(this._onFinish, [], this);
    };

    GameSceneOverlay.prototype._makeBaloonContent = function(type) {
      switch (type) {
        case GameSceneOverlay.EVENT.DEMONSTRATION_START:
          return new createjs.Bitmap(Config.IMAGE_DIR + getRetinaPath("gamescene/modal2txt.png"));
        case GameSceneOverlay.EVENT.GAME_START:
          return new createjs.Bitmap(Config.IMAGE_DIR + getRetinaPath("gamescene/modal4txt.png"));
        case GameSceneOverlay.EVENT.STAGE_CLEAR:
          return new createjs.Bitmap(Config.IMAGE_DIR + getRetinaPath("gamescene/modal5txt.png"));
        case GameSceneOverlay.EVENT.GAME_OVER:
          return new createjs.Bitmap(Config.IMAGE_DIR + getRetinaPath("gamescene/modal6txt.png"));
      }
      return null;
    };

    return GameSceneOverlay;

  })(createjs.Container);

  namespace('display.hud', function() {
    return GameSceneOverlay;
  });

  ResultHud = (function(_super) {
    __extends(ResultHud, _super);

    ResultHud.prototype._titleSprite = null;

    ResultHud.prototype._charactorSprite = null;

    ResultHud.prototype._rankSprite = null;

    ResultHud.prototype._landScoreTitle = null;

    ResultHud.prototype._landScoreSprite = null;


    /*_totalScoreTitle:null
    	_totalScoreSprite:null
     */

    ResultHud.prototype._nextLandButton = null;

    ResultHud.prototype._selectLandButton = null;

    ResultHud.prototype._width = 0;

    ResultHud.prototype._heigh = 0;

    ResultHud.prototype._accuracy = 0;

    ResultHud.prototype._landId = 0;

    ResultHud.prototype._landScore = 0;

    ResultHud.COUNT_DURATION = 1000;

    ResultHud.COUNT_WAIT = 1500;

    ResultHud.define('width', {
      get: function() {
        return this._width;
      },
      set: function(value) {
        return this._width = value;
      }
    });

    ResultHud.define('height', {
      get: function() {
        return this._height;
      },
      set: function(value) {
        return this._height = value;
      }
    });

    function ResultHud(_at__landId, _at__landScore, _at__accuracy, _at__gamecenter_modal) {
      this._landId = _at__landId;
      this._landScore = _at__landScore != null ? _at__landScore : 0;
      this._accuracy = _at__accuracy;
      this._gamecenter_modal = _at__gamecenter_modal;
      this._handleValChange = __bind(this._handleValChange, this);
      this._animateScore = __bind(this._animateScore, this);
      this._nextSceneButtonHandler = __bind(this._nextSceneButtonHandler, this);
      this._selectLandButtonHandler = __bind(this._selectLandButtonHandler, this);
      this._calcRank = __bind(this._calcRank, this);
      this._sendGameCenterErrorHandler = __bind(this._sendGameCenterErrorHandler, this);
      this._sendGameCenterSuccessAndShowHandler = __bind(this._sendGameCenterSuccessAndShowHandler, this);
      this._sendGameCenterSuccessHandler = __bind(this._sendGameCenterSuccessHandler, this);
      this._openGameCenterHandler = __bind(this._openGameCenterHandler, this);
      this._init = __bind(this._init, this);
      this.startScoring = __bind(this.startScoring, this);
      ResultHud.__super__.constructor.call(this);
      this._board_id = Config.LAND_DATA[this._landId - 1].board;
      this._score_sended = false;
      this._init();
      return;
    }

    ResultHud.prototype.startScoring = function() {
      return this._animateScore(this._landScoreSprite, 0, this._landScore);
    };

    ResultHud.prototype._init = function() {
      var assets, base, gamecenter, gm, numFont, rank;
      assets = util.AssetsManager.getInstance();
      base = this.addChild(new createjs.Bitmap(assets.getTag("hudBase", "result")));
      this.width = base.image.width;
      this.height = base.image.height;
      this._titleSprite = this.addChild(new createjs.Bitmap(Config.IMAGE_DIR + getRetinaPath("resultscene/stage" + this._landId + "clear.png")));
      this._titleSprite.x = (this.width - this._titleSprite.image.width) * 0.5;
      this._titleSprite.y = dp(20);
      this._charactorSprite = this.addChild(new createjs.Bitmap(Config.IMAGE_DIR + getRetinaPath("resultscene/stage" + this._landId + "chara.png")));
      this._charactorSprite.y = this._titleSprite.y + this._titleSprite.image.height + dp(25);
      this._charactorSprite.x = dp(20);
      this._landScoreTitle = this.addChild(new createjs.Bitmap(Config.IMAGE_DIR + getRetinaPath("resultscene/landscore.png")));
      this._landScoreTitle.y = this._charactorSprite.y + this._charactorSprite.image.height + dp(25);
      this._landScoreTitle.x = dp(20);

      /*@_totalScoreTitle = @addChild(new createjs.Bitmap(Config.IMAGE_DIR + getRetinaPath("resultscene/totalscore.png")))
      		@_totalScoreTitle.y = @_landScoreTitle.y+@_landScoreTitle.image.height+dp(8)
      		@_totalScoreTitle.x = dp(20)
       */
      this._nextLandButton = this.addChild(new display.ui.DisplayStateButton(new createjs.Bitmap(Config.IMAGE_DIR + getRetinaPath("resultscene/nextLandBt.png"))));
      this._nextLandButton.y = this._landScoreTitle.y + this._landScoreTitle.image.height + dp(8);
      this._nextLandButton.x = dp(10);
      this._nextLandButton.addEventListener("click", this._nextSceneButtonHandler);
      if (this._landId >= Config.LAND_DATA.length) {
        this._nextLandButton.visible = false;
      }
      this._selectLandButton = this.addChild(new display.ui.DisplayStateButton(new createjs.Bitmap(Config.IMAGE_DIR + getRetinaPath("resultscene/selectLandBt.png"))));
      this._selectLandButton.y = this._nextLandButton.y + this._nextLandButton.height - dp(8);
      this._selectLandButton.x = dp(10);
      this._selectLandButton.addEventListener("click", this._selectLandButtonHandler);
      rank = this._calcRank();
      this._rankSprite = this.addChild(new createjs.Bitmap(Config.IMAGE_DIR + getRetinaPath("resultscene/lank" + rank + ".png")));
      this._rankSprite.y = this._charactorSprite.y + dp(8);
      this._rankSprite.x = this._charactorSprite.x + this._charactorSprite.image.width + dp(10);
      numFont = new display.text.BitmapFont(new createjs.SpriteSheet({
        images: [assets.getTag("numFont", "result")],
        frames: {
          width: dp(20),
          height: dp(31),
          count: 11
        }
      }), '0123456789,');
      this._landScoreSprite = this.addChild(new display.text.BitmapText(numFont, _.str.sprintf("%05d", 0)));
      this._landScoreSprite.setTextAlign("right");
      this._landScoreSprite.x = this.width - dp(10);
      this._landScoreSprite.y = this._landScoreTitle.y;

      /*@_totalScoreSprite = @addChild(new display.text.BitmapText(numFont,  _.str.sprintf("%05d", @_totalScore-@_landScore)))
      		@_totalScoreSprite.x = @width-dp(10)
      		@_totalScoreSprite.y = @_totalScoreTitle.y
      		@_totalScoreSprite.setTextAlign("right")
       */
      if (!Config.IS_FIREFOX) {
        gamecenter = new createjs.Bitmap(assets.getTag("gamecenter", "result"));
        gamecenter.regX = gamecenter.image.width;
        gamecenter.regY = gamecenter.image.height;
        gamecenter.x = this.width - dp(25);
        gamecenter.y = this.height - dp(35);
        gamecenter.addEventListener('click', this._openGameCenterHandler);
        this.addChild(gamecenter);
      }
      gm = plugin.GameCenter.getInstance();
      gm.reportScore(this._board_id, this._landScore, this._sendGameCenterSuccessHandler, this._sendGameCenterErrorHandler);
    };

    ResultHud.prototype._openGameCenterHandler = function() {
      var gm;
      this._gamecenter_modal.visible = true;
      gm = plugin.GameCenter.getInstance();
      gm.authenticate((function(_this) {
        return function(success) {
          if (_this._score_sended) {
            gm.showLeaderboard(_this._board_id);
          } else {
            gm.reportScore(_this._board_id, _this._landScore, _this._sendGameCenterSuccessAndShowHandler, _this._sendGameCenterErrorHandler);
          }
        };
      })(this), (function(_this) {
        return function(error) {
          _this._gamecenter_modal.visible = false;
          console.log(error);
        };
      })(this));
    };

    ResultHud.prototype._sendGameCenterSuccessHandler = function(success) {
      this._score_sended = true;
      console.log("GameCenter: SendSuccess");
    };

    ResultHud.prototype._sendGameCenterSuccessAndShowHandler = function(success) {
      this._score_sended = true;
      this._openGameCenterHandler();
      console.log("GameCenter: SendSuccess");
    };

    ResultHud.prototype._sendGameCenterErrorHandler = function(error) {
      this._gamecenter_modal.visible = false;
      console.log("GameCenter: SendError");
    };

    ResultHud.prototype._calcRank = function() {
      var rankObject, _i, _len, _ref;
      _ref = Config.RANK_DATA;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        rankObject = _ref[_i];
        if (this._accuracy >= rankObject.accuracy_min && this._accuracy < rankObject.accuracy_max) {
          return rankObject.rank;
        }
      }
      return 5;
    };

    ResultHud.prototype._selectLandButtonHandler = function() {
      Main.INSTANCE.changeScene('title');
    };

    ResultHud.prototype._nextSceneButtonHandler = function() {
      var nextLand;
      nextLand = (this._landId % Config.LAND_DATA.length) + 1;
      Main.INSTANCE.changeScene('game', nextLand);
    };

    ResultHud.prototype._animateScore = function(targetText, fromValue, toValue, callback) {
      var tmp;
      if (callback == null) {
        callback = null;
      }
      tmp = {
        v: fromValue
      };
      if (callback) {
        createjs.Tween.get(tmp).to({
          v: toValue
        }, ResultHud.COUNT_DURATION).call(callback, [], this).addEventListener("change", this._handleValChange(targetText, tmp));
      } else {
        createjs.Tween.get(tmp).to({
          v: toValue
        }, ResultHud.COUNT_DURATION).addEventListener("change", this._handleValChange(targetText, tmp));
      }
    };

    ResultHud.prototype._handleValChange = function(targetText, valObject) {
      return function(event) {
        return targetText.setText(_.str.sprintf("%05d", valObject.v));
      };
    };


    /*_formatPoint:(inputNumber, digit = 0) ->
    		digit = isNaN(digit = Math.abs(digit)) ? 2 : digit
    		d = "."
    		t = ","
    		s = inputNumber < 0 ? "-" : ""
    		i = parseInt(inputNumber = Math.abs(+inputNumber || 0).toFixed(digit)) + ""
    		j = (j = i.length) > 3 ? j % 3 : 0
    		b = d + Math.abs(inputNumber-i).toFixed(digit).slice(2)
    		a = (digit ?  b:"")
    		return s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + a
     */

    return ResultHud;

  })(createjs.Container);

  namespace('display.hud', function() {
    return ResultHud;
  });

  BaseScene = (function(_super) {
    __extends(BaseScene, _super);

    function BaseScene() {
      this.tickHandler = __bind(this.tickHandler, this);
      this.init = __bind(this.init, this);
      BaseScene.__super__.constructor.call(this);
      return;
    }

    BaseScene.prototype.init = function() {};

    BaseScene.prototype.tickHandler = function(delta) {};

    return BaseScene;

  })(createjs.Container);

  if (typeof namespace === "function") {
    namespace('display.scene', function() {
      return BaseScene;
    });
  }

  CompleteScene = (function(_super) {
    __extends(CompleteScene, _super);

    function CompleteScene() {
      CompleteScene.__super__.constructor.call(this);
      return;
    }

    return CompleteScene;

  })(display.scene.BaseScene);

  namespace('display.scene', function() {
    return CompleteScene;
  });

  GameScene = (function(_super) {
    __extends(GameScene, _super);

    GameScene.SCENE_KEY = "game";

    function GameScene(_at_land_id, _at_stage_id) {
      this.land_id = _at_land_id != null ? _at_land_id : 1;
      this.stage_id = _at_stage_id != null ? _at_stage_id : 1;
      this._gameStart = __bind(this._gameStart, this);
      this._questionSetup = __bind(this._questionSetup, this);
      this._demoStart = __bind(this._demoStart, this);
      this._viewSetup = __bind(this._viewSetup, this);
      this._destroy = __bind(this._destroy, this);
      this._clearLand = __bind(this._clearLand, this);
      this._changeScene = __bind(this._changeScene, this);
      this.gameOver = __bind(this.gameOver, this);
      this.clearStage = __bind(this.clearStage, this);
      this.ngAction = __bind(this.ngAction, this);
      this.okAction = __bind(this.okAction, this);
      this.updateStatus = __bind(this.updateStatus, this);
      this.updateScore = __bind(this.updateScore, this);
      this.init = __bind(this.init, this);
      GameScene.__super__.constructor.call(this);
      this.self = GameScene;
      this._stages = Config.LAND_DATA[this.land_id - 1].stages;
      this._game_manager = new util.GameManager(this._stages[this.stage_id - 1]);
      this._player_data = PlayerData.getInstance();
      this._point_rate = Config.LAND_DATA[this.land_id - 1].rate;
      this._game_speed = Config.LAND_DATA[this.land_id - 1].speed;
      this._player_data.makePaletteByRandId(this.land_id);
    }

    GameScene.prototype.init = function(_at__assets) {
      this._assets = _at__assets;
      this.overlay = new display.hud.GameSceneOverlay(this.land_id);
      this._status_sprite = new display.sprite.StatusSprite(this._assets, this.land_id, this.stage_id);
      this._score_sprite = new display.sprite.ScoreSprite(this._assets, this.land_id, this._game_manager);
      this._buttons_sprite = new display.sprite.ButtonsSprite(this, this._assets, this.land_id, this._game_manager);
      this.addChild(this._buttons_sprite);
      this.addChild(this._status_sprite);
      this.addChild(this._score_sprite);
      this._viewSetup();
      this.addChild(this.overlay);
      this.overlay.show(display.hud.GameSceneOverlay.EVENT.LAND_START, this._demoStart, this);
    };

    GameScene.prototype.updateScore = function() {
      this._score_sprite.updateView();
    };

    GameScene.prototype.updateStatus = function() {
      this._status_sprite.updateView();
    };

    GameScene.prototype._point = 0;

    GameScene.prototype.okAction = function(_count) {
      this._score_sprite._ok_box[_count - 1].visible = true;
      this._score_sprite._ok_box[_count - 1].alpha = 1;
      this._score_sprite._hatena_box[_count - 1].alpha = 0;
    };

    GameScene.prototype.ngAction = function(_count) {
      this._score_sprite._ng_box[_count - 1].visible = true;
      this._score_sprite._ng_box[_count - 1].alpha = 1;
      this._score_sprite._hatena_box[_count - 1].alpha = 0;
    };

    GameScene.prototype.clearStage = function() {
      if (this.stage_id === this._stages.length) {
        this.overlay.show(display.hud.GameSceneOverlay.EVENT.STAGE_CLEAR, this._clearLand, this);
      } else {
        this.overlay.show(display.hud.GameSceneOverlay.EVENT.STAGE_CLEAR, this._destroy, this);
        sePlay(_.str.sprintf("se_great_%03d", this.land_id), this.self.SCENE_KEY);
      }
    };

    GameScene.prototype.gameOver = function() {
      this.overlay.show(display.hud.GameSceneOverlay.EVENT.GAME_OVER, this._changeScene, this);
      sePlay(_.str.sprintf("se_gameover_%03d", this.land_id), this.self.SCENE_KEY);
    };

    GameScene.prototype._changeScene = function() {
      Main.getInstance().changeScene('title');
    };

    GameScene.prototype._clearLand = function() {
      this._player_data.setCompleteFlagByLandId(this.land_id);
      Main.INSTANCE.changeScene("result", this.land_id, this.stage_id + 1);
    };

    GameScene.prototype._destroy = function() {
      Main.INSTANCE.changeScene("game", this.land_id, this.stage_id + 1);
    };

    GameScene.prototype._viewSetup = function() {
      this._status_sprite.makeView();
      this._score_sprite.makeView(this._game_manager);
      this._buttons_sprite.makeView(this._game_manager);
    };

    GameScene.prototype._demoStart = function() {
      this.overlay.show(display.hud.GameSceneOverlay.EVENT.DEMONSTRATION_START, this._questionSetup, this);
    };

    GameScene.prototype._questionSetup = function() {
      this._score_sprite.questionSprite(this._game_speed);
      this._buttons_sprite.questionSprite(this._game_speed);
    };

    GameScene.prototype._gameStart = function() {
      this.overlay.show(display.hud.GameSceneOverlay.EVENT.GAME_START, this._buttons_sprite._gameStart, this);
    };

    return GameScene;

  })(display.scene.BaseScene);

  namespace('display.scene', function() {
    return GameScene;
  });

  InfinityScene = (function(_super) {
    __extends(InfinityScene, _super);

    function InfinityScene() {
      this.init = __bind(this.init, this);
      InfinityScene.__super__.constructor.call(this);
      return;
    }

    InfinityScene.prototype.init = function(_at__assets) {
      var assets, bmp;
      this._assets = _at__assets;
      console.log(this._assets, this._assets.getTag("animal_ok_001", "infinity"), this._assets.getItem("animal_ok_001", "infinity"));
      bmp = new createjs.Bitmap(this._assets.getTag("animal_ok_001", "infinity"));
      this.addChild(bmp);
      assets = util.AssetsManager.getInstance();
      bmp = new createjs.Bitmap(assets.getTag("animal_ok_001", "infinity"));
      bmp.x = bmp.image.width + dp(10);
      this.addChild(bmp);
      delay(5000, (function(_this) {
        return function() {
          return Main.INSTANCE.changeScene("infinity");
        };
      })(this));
    };

    return InfinityScene;

  })(display.scene.BaseScene);

  namespace('display.scene', function() {
    return InfinityScene;
  });

  ResultScene = (function(_super) {
    __extends(ResultScene, _super);

    ResultScene.prototype._bg = null;

    ResultScene.prototype._hud = null;

    function ResultScene(_at__landId) {
      this._landId = _at__landId;
      this._startScoring = __bind(this._startScoring, this);
      this._preloadCompleteHandler = __bind(this._preloadCompleteHandler, this);
      this.init = __bind(this.init, this);
      ResultScene.__super__.constructor.call(this);
      return;
    }

    ResultScene.prototype.init = function(_at__assets) {
      this._assets = _at__assets;
      return this._preloadCompleteHandler();
    };

    ResultScene.prototype._preloadCompleteHandler = function(e) {
      var animals, landscore, playerData, stageAccuracy;
      this._gamecenter_modal = new createjs.Shape();
      this._gamecenter_modal.graphics.beginFill("#000").drawRect(0, 0, Main.STAGE_WIDTH, Main.STAGE_HEIGHT);
      this._gamecenter_modal.alpha = 0.75;
      this._gamecenter_modal.addEventListener('click', (function(_this) {
        return function() {};
      })(this));
      this._gamecenter_modal.visible = false;
      Main.getEventDispatcher().addEventListener(Config.EVENTS.GAME_CENTER_HIDED, (function(_this) {
        return function() {
          _this._gamecenter_modal.visible = false;
        };
      })(this));
      playerData = PlayerData.getInstance();
      animals = playerData.getTapHistories();
      landscore = playerData.getRandPoint();
      stageAccuracy = playerData.getLandAccuracy();
      this._bg = this.addChild(new display.hud.AnimalPilingBG(animals));
      this._hud = this.addChild(new display.hud.ResultHud(this._landId, landscore, stageAccuracy, this._gamecenter_modal));
      this._hud.x = (Main.STAGE_WIDTH - this._hud.width) * 0.5;
      this._hud.y = (Main.STAGE_HEIGHT - this._hud.height) * 0.5;
      this._startScoring();
      playerData.clearTapHistories();
      playerData.clearRandPoint();
      this.addChild(this._gamecenter_modal);
    };

    ResultScene.prototype._startScoring = function() {
      this._bg.fallAnimals();
      this._hud.startScoring();
    };

    return ResultScene;

  })(display.scene.BaseScene);

  namespace('display.scene', function() {
    return ResultScene;
  });

  SelectScene = (function(_super) {
    __extends(SelectScene, _super);

    SelectScene.SCENE_KEY = "select";

    function SelectScene() {
      this._closeHelpHandler = __bind(this._closeHelpHandler, this);
      this._openHelpHandler = __bind(this._openHelpHandler, this);
      this._openGameCenterHandler = __bind(this._openGameCenterHandler, this);
      this._nextSceneHandler = __bind(this._nextSceneHandler, this);
      this.init = __bind(this.init, this);
      SelectScene.__super__.constructor.call(this);
      this.self = SelectScene;
      this.player_data = data.PlayerData.getInstance();
      return;
    }

    SelectScene.prototype.init = function(_at__assets) {
      var base, button, gamecenter, help_box_base, help_box_txt, help_button, i, is_active, title, _i;
      this._assets = _at__assets;
      base = new createjs.Bitmap(this._assets.getTag("base", this.self.SCENE_KEY));
      this.addChild(base);
      title = new createjs.Bitmap(this._assets.getTag("title", this.self.SCENE_KEY));
      title.regX = title.image.width / 2;
      title.x = Main.STAGE_WIDTH / 2;
      title.y = dp(15);
      this.addChild(title);
      for (i = _i = 1; _i <= 5; i = ++_i) {
        is_active = this.player_data.isActiveLand(i);
        if (is_active) {
          button = new createjs.Bitmap(this._assets.getTag(_.str.sprintf('bt%d', i), this.self.SCENE_KEY));
        } else {
          button = new createjs.Bitmap(this._assets.getTag("bt_disable", this.self.SCENE_KEY));
        }
        button.regX = button.image.width / 2;
        button.x = Main.STAGE_WIDTH / 2;
        button.y = dp(15 + 55 * i);
        if (is_active) {
          button.alpha = 1;
          button.land_id = i;
          button.addEventListener('click', this._nextSceneHandler);
        }
        this.addChild(button);
      }
      help_button = new createjs.Bitmap(this._assets.getTag("help", this.self.SCENE_KEY));
      help_button.regX = help_button.image.width / 2;
      help_button.x = Main.STAGE_WIDTH / 2;
      help_button.y = dp(355);
      help_button.addEventListener('click', this._openHelpHandler);
      this.addChild(help_button);
      if (!Config.IS_FIREFOX) {
        gamecenter = new createjs.Bitmap(this._assets.getTag("gamecenter", this.self.SCENE_KEY));
        gamecenter.regX = gamecenter.image.width / 2;
        gamecenter.x = Main.STAGE_WIDTH / 2;
        gamecenter.y = dp(400);
        gamecenter.addEventListener('click', this._openGameCenterHandler);
        this.addChild(gamecenter);
      }
      this._help_box = new createjs.Container();
      help_box_base = new createjs.Shape();
      help_box_base.graphics.beginFill("#000").drawRect(0, 0, Main.STAGE_WIDTH, Main.STAGE_HEIGHT);
      help_box_base.alpha = 0.75;
      help_box_txt = new createjs.Bitmap(this._assets.getTag("helptxt", this.self.SCENE_KEY));
      help_box_txt.regX = help_box_txt.image.width / 2;
      help_box_txt.regY = help_box_txt.image.height / 2;
      help_box_txt.x = Main.STAGE_WIDTH / 2;
      help_box_txt.y = Main.STAGE_HEIGHT / 2;
      this._help_box.addChild(help_box_base);
      this._help_box.addChild(help_box_txt);
      this._help_box.addEventListener('click', this._closeHelpHandler);
      this.addChild(this._help_box);
      this._help_box.visible = false;
      this._gamecenter_modal = new createjs.Shape();
      this._gamecenter_modal.graphics.beginFill("#000").drawRect(0, 0, Main.STAGE_WIDTH, Main.STAGE_HEIGHT);
      this._gamecenter_modal.alpha = 0.75;
      this._gamecenter_modal.addEventListener('click', (function(_this) {
        return function() {};
      })(this));
      this._gamecenter_modal.visible = false;
      this.addChild(this._gamecenter_modal);
      Main.getEventDispatcher().addEventListener(Config.EVENTS.GAME_CENTER_HIDED, (function(_this) {
        return function() {
          _this._gamecenter_modal.visible = false;
        };
      })(this));
    };

    SelectScene.prototype._nextSceneHandler = function(e) {
      var land_id;
      land_id = e.target.land_id;
      Main.getInstance().changeScene('game', land_id, 1);
    };

    SelectScene.prototype._openGameCenterHandler = function(e) {
      var gm;
      this._gamecenter_modal.visible = true;
      gm = plugin.GameCenter.getInstance();
      gm.authenticate((function(_this) {
        return function(success) {
          var board_id;
          board_id = Config.LAND_DATA[0].board;
          gm.showLeaderboard(board_id);
        };
      })(this), (function(_this) {
        return function(error) {
          _this._gamecenter_modal.visible = false;
          console.log(error);
        };
      })(this));
    };

    SelectScene.prototype._openHelpHandler = function(e) {
      this._help_box.visible = true;
    };

    SelectScene.prototype._closeHelpHandler = function(e) {
      this._help_box.visible = false;
    };

    return SelectScene;

  })(display.scene.BaseScene);

  namespace('display.scene', function() {
    return SelectScene;
  });

  TitleScene = (function(_super) {
    __extends(TitleScene, _super);

    TitleScene.SCENE_KEY = "title";

    function TitleScene() {
      this._textFlashing = __bind(this._textFlashing, this);
      this._nextSceneHandler = __bind(this._nextSceneHandler, this);
      this.init = __bind(this.init, this);
      TitleScene.__super__.constructor.call(this);
      this.self = TitleScene;
      return;
    }

    TitleScene.prototype.init = function(_at__assets) {
      var anim_data, animal_sprite, base, sprite_sheet, title;
      this._assets = _at__assets;
      base = new createjs.Bitmap(this._assets.getTag("base", this.self.SCENE_KEY));
      this.addChild(base);
      title = new createjs.Bitmap(this._assets.getTag("title", this.self.SCENE_KEY));
      title.regX = title.image.width / 2;
      title.x = Main.STAGE_WIDTH / 2;
      title.y = dp(110);
      this.addChild(title);
      anim_data = {
        images: [this._assets.getTag("animal_sprite", this.self.SCENE_KEY)],
        frames: {
          width: Main.STAGE_WIDTH,
          height: dp(100)
        },
        animations: {
          run: [0, 8, 'run', 16]
        }
      };
      sprite_sheet = new createjs.SpriteSheet(anim_data);
      animal_sprite = new createjs.BitmapAnimation(sprite_sheet);
      delay(1000, (function(_this) {
        return function() {
          return animal_sprite.gotoAndPlay("run");
        };
      })(this));
      animal_sprite.y = dp(270);
      this.addChild(animal_sprite);
      this._start = new createjs.Bitmap(this._assets.getTag("start", this.self.SCENE_KEY));
      this._start.regX = this._start.image.width / 2;
      this._start.x = Main.STAGE_WIDTH / 2;
      this._start.y = dp(350);
      this.addChild(this._start);
      this._textFlashing();
      this.addEventListener("click", this._nextSceneHandler);
    };

    TitleScene.prototype._nextSceneHandler = function(e) {
      Main.getInstance().changeScene("select");
    };

    TitleScene.prototype._textFlashing = function() {
      var ease_time;
      ease_time = 500;
      createjs.Tween.get(this._start).to({
        alpha: 1
      }, ease_time).wait(ease_time).to({
        alpha: 0
      }, ease_time).call(this._textFlashing);
    };

    return TitleScene;

  })(display.scene.BaseScene);

  namespace('display.scene', function() {
    return TitleScene;
  });

  ButtonsSprite = (function(_super) {
    __extends(ButtonsSprite, _super);

    ButtonsSprite.prototype._delay_time = 800;

    function ButtonsSprite(_at__game_scene, _at__assets, _at_land_id, _at__game_manager) {
      this._game_scene = _at__game_scene;
      this._assets = _at__assets;
      this.land_id = _at_land_id;
      this._game_manager = _at__game_manager;
      this._stageComplete = __bind(this._stageComplete, this);
      this._charaReset = __bind(this._charaReset, this);
      this._charaSelect = __bind(this._charaSelect, this);
      this._buttonDownHandler = __bind(this._buttonDownHandler, this);
      this._viewSetup = __bind(this._viewSetup, this);
      this._gameStart = __bind(this._gameStart, this);
      this._inAnimal = __bind(this._inAnimal, this);
      this._outAnimal = __bind(this._outAnimal, this);
      this.questionSprite = __bind(this.questionSprite, this);
      this.makeView = __bind(this.makeView, this);
      ButtonsSprite.__super__.constructor.call(this);
      return;
    }

    ButtonsSprite.prototype.makeView = function(_at__game_manager) {
      this._game_manager = _at__game_manager;
      return this._viewSetup();
    };

    ButtonsSprite.prototype.questionSprite = function(_at_question_time) {
      var i;
      this.question_time = _at_question_time;
      i = 0;
      this.timer_id = setInterval(this._outAnimal(i), this.question_time);
    };

    ButtonsSprite.prototype._outAnimal = function(i) {
      return (function(_this) {
        return function() {
          if (i < _this._question.length) {
            _this._buttons[_this._question[i]].visible = false;
            _this._buttons[_this._question[i]].alpha = 0;
            _this._buttons_ok[_this._question[i]].visible = true;
            _this._buttons_ok[_this._question[i]].alpha = 1;
            sePlay(_.str.sprintf("se_high_%03d", _this._palette[_this._question[i]]));
            setTimeout(_this._inAnimal(_this._question[i], i), _this.question_time / 2);
          } else if (i === _this._question.length) {
            clearInterval(_this.timer_id);
            _this._game_scene._gameStart();
          }
          return ++i;
        };
      })(this);
    };

    ButtonsSprite.prototype._inAnimal = function(num, i) {
      return (function(_this) {
        return function() {
          _this._buttons[num].visible = true;
          _this._buttons[num].alpha = 1;
          _this._buttons_ok[num].visible = false;
          return _this._buttons_ok[num].visible = 0;
        };
      })(this);
    };

    ButtonsSprite.prototype._gameStart = function() {
      return this._play_lock = false;
    };

    ButtonsSprite.prototype._viewSetup = function() {
      var base, button, button_no, button_ok, i, _i;
      this._buttons = [];
      this._buttons_ok = [];
      this._buttons_no = [];
      this._play_lock = true;
      this._buttonsContainer = new createjs.Container();
      this._buttonsContainer.x = 0;
      this._buttonsContainer.y = dp(98);
      this.addChild(this._buttonsContainer);
      this._player_data = PlayerData.getInstance();
      this._palette = this._player_data.getPalette();
      this._question = this._game_manager.getQuestions();
      base = new createjs.Bitmap(this._assets.getTag('base_' + _.str.sprintf("%03d", this.land_id), "game"));
      this._buttonsContainer.addChild(base);
      for (i = _i = 0; _i < 6; i = ++_i) {
        this._animalButton = new createjs.Container();
        if (i < 3) {
          this._animalButton.x = dp(25);
        } else {
          this._animalButton.x = dp(168);
        }
        this._animalButton.y = dp(120) * (i % 3) + dp(20);
        button = new createjs.Bitmap(this._assets.getTag('animal_' + _.str.sprintf("%03d", this._palette[i]), "game"));
        button_ok = new createjs.Bitmap(this._assets.getTag('animal_ok_' + _.str.sprintf("%03d", this._palette[i]), "game"));
        button_no = new createjs.Bitmap(this._assets.getTag('animal_no_' + _.str.sprintf("%03d", this._palette[i]), "game"));
        button_ok.visible = button_no.visible = false;
        button_ok.alpha = button_no.alpha = 0;
        this._buttons.push(button);
        this._buttons_ok.push(button_ok);
        this._buttons_no.push(button_no);
        this._animalButton.addEventListener('mousedown', this._buttonDownHandler);
        this._animalButton.tag = i;
        this._animalButton.addChild(button);
        this._animalButton.addChild(button_ok);
        this._animalButton.addChild(button_no);
        this._buttonsContainer.addChild(this._animalButton);
      }
    };

    ButtonsSprite.prototype._buttonDownHandler = function(e) {
      var current_count, current_point, tap_id;
      if (!this._play_lock) {
        tap_id = e.target.tag;
        this._game_manager.addChoiceStack(tap_id);
        this._player_data.addTapHistoryByIndex(tap_id);
        current_point = this._game_manager.getCurrentTapPoint(Config.TAP_POINT_BASE, Config.TAP_CHAIN_BONUS);
        this._player_data.addPoint(current_point);
        this._player_data.addLandAccuracy(this._game_manager.isCurrentCorrectAnswer());
        this._game_scene.updateScore();
        this._game_scene.updateStatus();
        current_count = this._game_manager.getChoiceStack().length;
        if (this._game_manager.isCurrentCorrectAnswer()) {
          this._charaSelect(tap_id, true);
          this._game_scene.okAction(current_count);
          sePlay(_.str.sprintf("se_high_%03d", this._palette[tap_id]));
        } else {
          this._charaSelect(tap_id, false);
          this._game_scene.ngAction(current_count);
          sePlay(_.str.sprintf("se_low_%03d", this._palette[tap_id]));
        }
        if (this._game_manager.isComplete()) {
          this._play_lock = true;
          clearTimeout(this._timer);
          delay(this._delay_time, this._stageComplete);
        }
      }
    };

    ButtonsSprite.prototype._charaSelect = function(index, isOk) {
      this._charaReset();
      this._buttons[index].visible = false;
      this._buttons[index].alpha = 0;
      if (isOk) {
        this._buttons_ok[index].visible = true;
        this._buttons_ok[index].alpha = 1;
      } else {
        this._buttons_no[index].visible = true;
        this._buttons_no[index].alpha = 1;
      }
      clearTimeout(this._timer);
      this._timer = delay(this._delay_time, this._charaReset);
    };

    ButtonsSprite.prototype._charaReset = function() {
      var i, _i, _ref;
      for (i = _i = 0, _ref = this._buttons.length; 0 <= _ref ? _i < _ref : _i > _ref; i = 0 <= _ref ? ++_i : --_i) {
        this._buttons[i].visible = true;
        this._buttons[i].alpha = 1;
        this._buttons_ok[i].visible = false;
        this._buttons_ok[i].alpha = 0;
        this._buttons_no[i].visible = false;
        this._buttons_no[i].alpha = 0;
      }
    };

    ButtonsSprite.prototype._stageComplete = function() {
      this._charaReset();
      if (Config.LAND_DATA[this.land_id - 1].rate <= this._game_manager.getAverage()) {
        this._player_data.clearPoint();
        this._game_scene.clearStage();
      } else {
        this._player_data.clearRandPoint();
        this._game_scene.gameOver();
      }
    };

    return ButtonsSprite;

  })(createjs.Container);

  namespace('display.sprite', function() {
    return ButtonsSprite;
  });

  CharactorWithBaloon = (function(_super) {
    __extends(CharactorWithBaloon, _super);

    CharactorWithBaloon._CHARACTOR_ANIM_FPS = 3;

    CharactorWithBaloon._BALOON_ANIM_FPS = 6;

    CharactorWithBaloon.prototype._charactorAnimation = null;

    CharactorWithBaloon.prototype._baloonAniamtion = null;

    CharactorWithBaloon.prototype._textSprite = null;

    function CharactorWithBaloon(_at__landId) {
      this._landId = _at__landId;
      this.reset = __bind(this.reset, this);
      this.shutup = __bind(this.shutup, this);
      this.talk = __bind(this.talk, this);
      CharactorWithBaloon.__super__.constructor.call(this);
      this._charactorAnimation = new createjs.BitmapAnimation(new createjs.SpriteSheet({
        images: [getRetinaPath(Config.IMAGE_DIR + 'gamescene/modal2Stage' + this._landId + 'Sprite.png')],
        frames: {
          width: dp(121),
          height: dp(106)
        },
        animations: {
          talk: {
            frames: [0, 1],
            frequency: Config.FPS / CharactorWithBaloon._CHARACTOR_ANIM_FPS
          }
        }
      }));
      this._charactorAnimation.y = dp(30);
      this._baloonAniamtion = new createjs.BitmapAnimation(new createjs.SpriteSheet({
        images: [getRetinaPath(Config.IMAGE_DIR + 'gamescene/modal2FukiSprite.png')],
        frames: {
          width: dp(190),
          height: dp(100)
        },
        animations: {
          inflate: {
            frames: [0, 1, 2],
            next: false,
            frequency: Config.FPS / CharactorWithBaloon._BALOON_ANIM_FPS
          },
          deflate: {
            frames: [2, 1, 0],
            next: false,
            frequency: Config.FPS / CharactorWithBaloon._BALOON_ANIM_FPS
          }
        }
      }));
      this._baloonAniamtion.x = dp(100);
      this.addChild(this._charactorAnimation);
      this.addChild(this._baloonAniamtion);
      this.width = dp(190) + this._baloonAniamtion.x;
      this.height = dp(106) + this._charactorAnimation.y;
      return;
    }

    CharactorWithBaloon.define('width', {
      get: function() {
        return this._width;
      },
      set: function(value) {
        return this._width = value;
      }
    });

    CharactorWithBaloon.define('height', {
      get: function() {
        return this._height;
      },
      set: function(value) {
        return this._height = value;
      }
    });

    CharactorWithBaloon.prototype.talk = function(content) {
      var inflateAnim, waittime;
      this._baloonAniamtion.visible = true;
      if (this._textSprite && this._textSprite.parent) {
        this.removeChild(this._textSprite);
      }
      if (content instanceof createjs.DisplayObject) {
        this._textSprite = content;
        this._textSprite.alpha = 0;
        this._textSprite.x = this._baloonAniamtion.x + dp(95) - this._textSprite.image.width * 0.5;
        this._textSprite.y = this._baloonAniamtion.y + dp(46) - this._textSprite.image.height * 0.5;
        inflateAnim = this._baloonAniamtion.spriteSheet.getAnimation("inflate");
        waittime = inflateAnim.frequency * inflateAnim.frames.length / Config.FPS * 1000;
        createjs.Tween.get(this._textSprite).wait(waittime).to({
          alpha: 1
        }, 100);
        this.addChild(this._textSprite);
      }
      this._charactorAnimation.gotoAndPlay("talk");
      this._baloonAniamtion.gotoAndPlay("inflate");
    };

    CharactorWithBaloon.prototype.shutup = function() {
      if (this._textSprite && this._textSprite.parent) {
        createjs.Tween.get(this._textSprite).to({
          alpha: 0
        }, 100);
      }
      return this._baloonAniamtion.gotoAndPlay("deflate");
    };

    CharactorWithBaloon.prototype.reset = function() {
      this._baloonAniamtion.gotoAndStop("inflate");
      this._baloonAniamtion.visible = false;
      if (this._textSprite && this._textSprite.parent) {
        return this.removeChild(this._textSprite);
      }
    };

    return CharactorWithBaloon;

  })(createjs.Container);

  namespace('display.sprite', function() {
    return CharactorWithBaloon;
  });

  LoadingSprite = (function(_super) {
    __extends(LoadingSprite, _super);

    function LoadingSprite() {
      this._viewSetup = __bind(this._viewSetup, this);
      LoadingSprite.__super__.constructor.call(this);
      this._viewSetup();
      return;
    }

    LoadingSprite.prototype._viewSetup = function() {
      var base;
      base = new createjs.Shape();
      base.graphics.beginFill("#000").drawRect(0, 0, Main.STAGE_WIDTH, Main.STAGE_HEIGHT);
      this.addChild(base);
      this.text = new createjs.Text("Now Loading...", dp(12).toString() + "px Arial", "#FFFFFF");
      this.text.regY = this.text.getMeasuredHeight();
      this.text.x = Main.STAGE_WIDTH - dp(10);
      this.text.y = Main.STAGE_HEIGHT - dp(10);
      this.text.textAlign = 'right';
      this.addChild(this.text);
      this.addEventListener('click', function() {});
    };

    return LoadingSprite;

  })(createjs.Container);

  namespace('display.sprite', function() {
    return LoadingSprite;
  });

  ScoreSprite = (function(_super) {
    __extends(ScoreSprite, _super);

    function ScoreSprite(_at__assets, _at_land_id, _at__game_manager) {
      this._assets = _at__assets;
      this.land_id = _at_land_id;
      this._game_manager = _at__game_manager;
      this._viewSetup = __bind(this._viewSetup, this);
      this._changeYou = __bind(this._changeYou, this);
      this._hideCard = __bind(this._hideCard, this);
      this._showCard = __bind(this._showCard, this);
      this.questionSprite = __bind(this.questionSprite, this);
      this.updateView = __bind(this.updateView, this);
      this.makeView = __bind(this.makeView, this);
      ScoreSprite.__super__.constructor.call(this);
      return;
    }

    ScoreSprite.prototype.makeView = function(_at__game_manager) {
      this._game_manager = _at__game_manager;
      return this._viewSetup();
    };

    ScoreSprite.prototype.updateView = function() {};

    ScoreSprite.prototype.questionSprite = function(_at_question_time) {
      var i;
      this.question_time = _at_question_time;
      i = 0;
      this.timer_id = setInterval(this._showCard(i), this.question_time);
    };

    ScoreSprite.prototype._showCard = function(i) {
      return (function(_this) {
        return function() {
          if (i >= _this._question.length - 1) {
            clearInterval(_this.timer_id);
            setTimeout(_this._hideCard(), _this.question_time / 2);
          }
          _this._hatena_box[i].visible = false;
          _this._hatena_box[i].alpha = 0;
          return ++i;
        };
      })(this);
    };

    ScoreSprite.prototype._hideCard = function() {
      return (function(_this) {
        return function() {
          var j, _i, _ref, _results;
          _results = [];
          for (j = _i = 0, _ref = _this._question.length; 0 <= _ref ? _i < _ref : _i > _ref; j = 0 <= _ref ? ++_i : --_i) {
            _this._hatena_box[j].visible = true;
            _this._hatena_box[j].alpha = 1;
            _results.push(_this._changeYou());
          }
          return _results;
        };
      })(this);
    };

    ScoreSprite.prototype._changeYou = function() {
      this._charaContainer.visible = false;
      this._charaContainer.alpha = 0;
      this._you.visible = true;
      this._you.alpha = 1;
    };

    ScoreSprite.prototype._box_posx = 0;

    ScoreSprite.prototype._box_posy = 0;

    ScoreSprite.prototype._viewSetup = function() {
      var animal_box, i, sprite_sheet, _i, _ref;
      this._scoreContainer = new createjs.Container();
      this._scoreContainer.x = 0;
      this._scoreContainer.y = dp(25);
      this.addChild(this._scoreContainer);
      this._player_data = PlayerData.getInstance();
      this._palette = this._player_data.getPalette();
      this._question = this._game_manager.getQuestions();
      this._answer = this._game_manager.getAnswers();
      this._base = new createjs.Bitmap(this._assets.getTag('bar_com_base', "game"));
      this._scoreContainer.addChild(this._base);
      this._you = new createjs.Bitmap(this._assets.getTag('bar_your', "game"));
      this._you.visible = false;
      this._you.alpha = 0;
      this._scoreContainer.addChild(this._you);
      this._charaContainer = new createjs.Container();
      this._scoreContainer.addChild(this._charaContainer);
      sprite_sheet = new createjs.SpriteSheet({
        images: [this._assets.getTag('bar_coml_' + _.str.sprintf("%03d", this.land_id), "game")],
        frames: {
          width: dp(44),
          height: dp(73),
          count: 4,
          regX: dp(0),
          regY: dp(0)
        },
        animations: {
          "run": [0, 3, "run", 8]
        }
      });
      this._character_face = new createjs.BitmapAnimation(sprite_sheet);
      this._character_face.gotoAndPlay("run");
      this._charaContainer.addChild(this._character_face);
      this._box_posy = dp(2);
      this._hatena_box = [];
      this._ok_box = [];
      this._ng_box = [];
      for (i = _i = 0, _ref = this._question.length; 0 <= _ref ? _i < _ref : _i > _ref; i = 0 <= _ref ? ++_i : --_i) {
        animal_box = new createjs.Bitmap(this._assets.getTag('bar_animal_' + _.str.sprintf("%03d", this._palette[this._question[i]]), "game"));
        this._hatena_box[i] = new createjs.Bitmap(this._assets.getTag('bar_hatena', "game"));
        this._ok_box[i] = new createjs.Bitmap(this._assets.getTag('bar_ok', "game"));
        this._ng_box[i] = new createjs.Bitmap(this._assets.getTag('bar_ng', "game"));
        if (i === 6) {
          this._box_posy = dp(38);
        }
        animal_box.x = this._hatena_box[i].x = this._ok_box[i].x = this._ng_box[i].x = dp(47) + ((i % 6) * dp(45));
        animal_box.y = this._hatena_box[i].y = this._ok_box[i].y = this._ng_box[i].y = this._box_posy;
        this._ok_box[i].alpha = this._ng_box[i].alpha = 0;
        this._ok_box[i].visible = this._ng_box[i].visible = false;
        this._scoreContainer.addChild(animal_box);
        this._scoreContainer.addChild(this._hatena_box[i]);
        this._scoreContainer.addChild(this._ok_box[i]);
        this._scoreContainer.addChild(this._ng_box[i]);
      }
    };

    return ScoreSprite;

  })(createjs.Container);

  namespace('display.sprite', function() {
    return ScoreSprite;
  });

  StatusSprite = (function(_super) {
    __extends(StatusSprite, _super);

    function StatusSprite(_at__assets, _at_land_id, _at_stage_id) {
      this._assets = _at__assets;
      this.land_id = _at_land_id;
      this.stage_id = _at_stage_id;
      this._stageRank = __bind(this._stageRank, this);
      this.makeView = __bind(this.makeView, this);
      this.updateView = __bind(this.updateView, this);
      StatusSprite.__super__.constructor.call(this);
      this._player_data = PlayerData.getInstance();
      this._stages = Config.LAND_DATA[this.land_id - 1].stages;
      return;
    }

    StatusSprite.prototype.updateView = function() {
      this._score.setText(_.str.sprintf("%04d", this._player_data.getPoint()));
    };

    StatusSprite.prototype.makeView = function() {
      var base, font, land_name, pt;
      this._statusContainer = new createjs.Container();
      this._statusContainer.x = 0;
      this._statusContainer.y = 0;
      this.addChild(this._statusContainer);
      base = new createjs.Shape();
      base.graphics.beginFill("#000").drawRect(0, 0, Main.STAGE_WIDTH, dp(25));
      this._statusContainer.addChild(base);
      land_name = new createjs.Bitmap(this._assets.getTag('land_name_' + _.str.sprintf("%03d", this.land_id), "game"));
      this._statusContainer.addChild(land_name);
      this._stageRank();
      this._pointContainer = new createjs.Container();
      this._pointContainer.x = 0;
      this._pointContainer.y = 0;
      this._statusContainer.addChild(this._pointContainer);
      this._pointContainer.removeAllChildren();
      font = new display.text.PointNumberFont();
      this._score = new display.text.BitmapText(font, _.str.sprintf("%04d", this._player_data.getPoint()));
      this._score.point = 0;
      this._score.x = Main.STAGE_WIDTH - dp(70);
      this._score.y = dp(5);
      this._pointContainer.addChild(this._score);
      pt = new createjs.Bitmap(this._assets.getTag("pt", "game"));
      pt.x = dp(302);
      pt.y = dp(9);
      this._pointContainer.addChild(pt);
    };

    StatusSprite.prototype._stageRank = function() {
      var i, stage, _i, _ref, _results;
      this.assets = util.AssetsManager.getInstance();
      _results = [];
      for (i = _i = 0, _ref = this._stages.length; 0 <= _ref ? _i < _ref : _i > _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (i < this.stage_id) {
          stage = new createjs.Bitmap(this._assets.getTag("stage_icon_on", "game"));
        } else if (i >= this.stage_id) {
          stage = new createjs.Bitmap(this._assets.getTag("stage_icon_off", "game"));
        }
        stage.x = dp(130 + (i * 19));
        stage.y = dp(5);
        _results.push(this._statusContainer.addChild(stage));
      }
      return _results;
    };

    return StatusSprite;

  })(createjs.Container);

  namespace('display.sprite', function() {
    return StatusSprite;
  });

  BitmapFont = (function() {
    function BitmapFont(_at__sprite_sheet, _at__char_map) {
      this._sprite_sheet = _at__sprite_sheet;
      this._char_map = _at__char_map;
      this.getCharImage = __bind(this.getCharImage, this);
      this.char_width = this._sprite_sheet._frameWidth;
      this.char_height = this._sprite_sheet._frameHeight;
      return;
    }

    BitmapFont.prototype.getCharImage = function(char) {
      var index;
      index = this._char_map.indexOf(char);
      if (index > -1) {
        return new createjs.Bitmap(createjs.SpriteSheetUtils.extractFrame(this._sprite_sheet, index));
      }
    };

    return BitmapFont;

  })();

  namespace('display.text', function() {
    return BitmapFont;
  });

  BitmapText = (function(_super) {
    __extends(BitmapText, _super);

    BitmapText.prototype._TEXT_ALIGNS = {
      "left": 0,
      "center": -0.5,
      "right": -1
    };

    BitmapText.prototype._text_align = 'left';

    function BitmapText(_at__bitmap_font, _at__text) {
      this._bitmap_font = _at__bitmap_font;
      this._text = _at__text != null ? _at__text : "";
      this._clear = __bind(this._clear, this);
      this._setCharPosition = __bind(this._setCharPosition, this);
      this._build = __bind(this._build, this);
      this.setTextAlign = __bind(this.setTextAlign, this);
      this.setText = __bind(this.setText, this);
      BitmapText.__super__.constructor.call(this);
      this._build();
      return;
    }

    BitmapText.prototype.setText = function(text) {
      this._text = text;
      this._build();
    };

    BitmapText.prototype.setTextAlign = function(align) {
      if (align in this._TEXT_ALIGNS) {
        this._text_align = align;
        this._build();
      }
    };

    BitmapText.prototype._build = function() {
      var char, char_image, i, _i, _ref;
      this._clear();
      for (i = _i = 0, _ref = this._text.length; 0 <= _ref ? _i < _ref : _i > _ref; i = 0 <= _ref ? ++_i : --_i) {
        char = this._text.charAt(i);
        char_image = this._bitmap_font.getCharImage(char);
        if (char_image) {
          this.addChild(char_image);
          this._setCharPosition(char_image, i);
        }
      }
    };

    BitmapText.prototype._setCharPosition = function(bitmap, index) {
      var base_x, scale;
      scale = this._TEXT_ALIGNS[this._text_align];
      base_x = this._bitmap_font.char_width * this._text.length * scale;
      bitmap.x = base_x + this._bitmap_font.char_width * index;
    };

    BitmapText.prototype._clear = function() {
      this.removeAllChildren();
    };

    return BitmapText;

  })(createjs.Container);

  namespace('display.text', function() {
    return BitmapText;
  });

  PointNumberFont = (function(_super) {
    __extends(PointNumberFont, _super);

    function PointNumberFont() {
      var assets;
      assets = util.AssetsManager.getInstance();
      PointNumberFont.__super__.constructor.call(this, new createjs.SpriteSheet({
        images: [assets.getTag("font_game_num")],
        frames: {
          width: dp(12),
          height: dp(18),
          count: 11
        }
      }), '0123456789,');
      return;
    }

    return PointNumberFont;

  })(display.text.BitmapFont);

  namespace('display.text', function() {
    return PointNumberFont;
  });


  /**
  * ステートボタンを作成する
  * @class 通常、アクティブ、無効の状態表示に対応したボタンクラスです
  * @param {String|createjs.DisplayObject} normal ボタンノーマル時の画像パス又はDisplayObject
  * @param {String|createjs.DisplayObject} [active] ボタンアクティブ時の画像パス又はDisplayObject
  * @param {String|createjs.DisplayObject} [disable] ボタン無効時の画像パス又はDisplayObject
   */

  namespace('display.ui', function() {
    var DisplayStateButton;
    return DisplayStateButton = (function(_super) {
      __extends(DisplayStateButton, _super);

      DisplayStateButton._STATE_NORMAL = 0;

      DisplayStateButton._STATE_ACTIVE = 1;

      DisplayStateButton._STATE_DISABLE = 2;

      DisplayStateButton.prototype._current_state = 0;

      DisplayStateButton.prototype._current_display = null;

      DisplayStateButton.prototype._state_list = ['normal', 'active', 'disable'];

      DisplayStateButton.prototype._disabled = false;

      DisplayStateButton.prototype._width = 0;

      DisplayStateButton.prototype._height = 0;

      function DisplayStateButton(_at_normal, _at_active, _at_disable) {
        this.normal = _at_normal;
        this.active = _at_active != null ? _at_active : null;
        this.disable = _at_disable != null ? _at_disable : null;
        this._changeState = __bind(this._changeState, this);
        this._hideAllBitmap = __bind(this._hideAllBitmap, this);
        this._clickEventHandler = __bind(this._clickEventHandler, this);
        this._stateActiveHandler = __bind(this._stateActiveHandler, this);
        this._stateNormalHandler = __bind(this._stateNormalHandler, this);
        this._setupState = __bind(this._setupState, this);
        DisplayStateButton.__super__.constructor.call(this);
        this.self = DisplayStateButton;
        this._setupState();
        return;
      }

      DisplayStateButton.define('disabled', {
        get: function() {
          return this._disabled;
        },
        set: function(value) {
          if (this._disabled !== value) {
            if (value) {
              this.mouseEnabled = false;
              this._changeState(this.self._STATE_DISABLE);
            } else {
              this.mouseEnabled = true;
              this._changeState(this.self._STATE_NORMAL);
            }
          }
          return this._disabled = value;
        }
      });

      DisplayStateButton.define('width', {
        get: function() {
          if ((this._current_display != null) && this._current_display instanceof createjs.Bitmap) {
            return this._current_display.image.width || this._width;
          }
          return this._width;
        },
        set: function(value) {
          return this._width = value;
        }
      });

      DisplayStateButton.define('height', {
        get: function() {
          if ((this._current_display != null) && this._current_display instanceof createjs.Bitmap) {
            return this._current_display.image.height || this._height;
          }
          return this._height;
        },
        set: function(value) {
          return this._height = value;
        }
      });

      DisplayStateButton.prototype._setupState = function() {
        var i, _i, _len, _ref;
        _ref = this._state_list;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          i = _ref[_i];
          if ((this[i] != null) && typeof this[i] === 'string') {
            this[i] = new createjs.Bitmap(getRetinaPath(this[i]));
          }
          if ((this[i] != null) && this[i] instanceof createjs.DisplayObject) {
            this.addChild(this[i]);
          }
        }
        this._changeState(this.self._STATE_NORMAL);
        this.addEventListener('mousedown', this._stateActiveHandler);
        this.addEventListener('mouseout', this._stateNormalHandler);
        this.addEventListener('click', this._clickEventHandler);
      };

      DisplayStateButton.prototype._stateNormalHandler = function(e) {
        this._changeState(this.self._STATE_NORMAL);
      };

      DisplayStateButton.prototype._stateActiveHandler = function(e) {
        this._changeState(this.self._STATE_ACTIVE);
      };

      DisplayStateButton.prototype._clickEventHandler = function(e) {
        this._changeState(this.self._STATE_NORMAL);
      };

      DisplayStateButton.prototype._hideAllBitmap = function() {
        var i, _i, _len, _ref;
        _ref = this._state_list;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          i = _ref[_i];
          if (this[i]) {
            this[i].visible = false;
          }
        }
      };

      DisplayStateButton.prototype._changeState = function(state) {
        var state_bitmap;
        this._current_state = state;
        state_bitmap = null;
        switch (this._current_state) {
          case this.self._STATE_ACTIVE:
            state_bitmap = this.active;
            break;
          case this.self._STATE_DISABLE:
            state_bitmap = this.disable;
        }
        if (this._disabled) {
          state_bitmap = this.disable;
        }
        this._hideAllBitmap();
        if (state_bitmap) {
          state_bitmap.visible = true;
          this._current_display = state_bitmap;
        } else {
          this.normal.visible = true;
          this._current_display = this.normal;
        }
      };

      return DisplayStateButton;

    })(createjs.Container);
  });

  GameCenter = (function() {
    GameCenter._INSTANCE = null;

    GameCenter.getInstance = function() {
      if (GameCenter._INSTANCE === null) {
        GameCenter._INSTANCE = new GameCenterSingleton();
      }
      return GameCenter._INSTANCE;
    };

    function GameCenter() {
      return;
    }

    return GameCenter;

  })();

  GameCenterSingleton = (function() {
    GameCenterSingleton.prototype._event_dispatcher = null;

    function GameCenterSingleton() {
      this._viewDidHide = __bind(this._viewDidHide, this);
      this._viewDidShow = __bind(this._viewDidShow, this);
      this.reportAchievement = __bind(this.reportAchievement, this);
      this.showAchievements = __bind(this.showAchievements, this);
      this.reportScore = __bind(this.reportScore, this);
      this.showLeaderboard = __bind(this.showLeaderboard, this);
      this.authenticate = __bind(this.authenticate, this);
      if (typeof cordova !== "undefined" && cordova !== null) {
        cordova.addConstructor((function(_this) {
          return function() {
            return typeof window !== "undefined" && window !== null ? window.gameCenter = _this : void 0;
          };
        })(this));
      }
      if (typeof (typeof Main !== "undefined" && Main !== null ? Main.getEventDispatcher : void 0) === 'function') {
        this._event_dispatcher = Main.getEventDispatcher();
      }
      return;
    }

    GameCenterSingleton.prototype.authenticate = function(success_handler, error_handler) {
      if (typeof cordova !== "undefined" && cordova !== null) {
        cordova.exec(success_handler, error_handler, "GameCenterPlugin", "authenticateLocalPlayer", []);
        return true;
      }
      return false;
    };

    GameCenterSingleton.prototype.showLeaderboard = function(category) {
      if (typeof cordova !== "undefined" && cordova !== null) {
        cordova.exec(null, null, "GameCenterPlugin", "showLeaderboard", [category]);
        return true;
      }
      return false;
    };

    GameCenterSingleton.prototype.reportScore = function(category, score, success_handler, error_handler) {
      if (typeof cordova !== "undefined" && cordova !== null) {
        cordova.exec(success_handler, error_handler, "GameCenterPlugin", "reportScore", [category, score]);
        return true;
      }
      return false;
    };

    GameCenterSingleton.prototype.showAchievements = function() {
      if (typeof cordova !== "undefined" && cordova !== null) {
        cordova.exec(null, null, "GameCenterPlugin", "showAchievements", []);
        return true;
      }
      return false;
    };

    GameCenterSingleton.prototype.reportAchievement = function(category, success_handler, error_handler) {
      if (typeof cordova !== "undefined" && cordova !== null) {
        cordova.exec(success_handler, error_handler, "GameCenterPlugin", "reportAchievementIdentifier", [category, 100]);
        return true;
      }
      return false;
    };

    GameCenterSingleton.prototype._viewDidShow = function() {
      var event_key, _ref;
      if (this._event_dispatcher) {
        event_key = (Config != null ? (_ref = Config.EVENT) != null ? _ref.GAME_CENTER_SHOWED : void 0 : void 0) || "game_center_showed";
        this._event_dispatcher.dispatchEvent(event_key);
      }
    };

    GameCenterSingleton.prototype._viewDidHide = function() {
      var event_key, _ref;
      if (this._event_dispatcher) {
        event_key = (Config != null ? (_ref = Config.EVENT) != null ? _ref.GAME_CENTER_HIDED : void 0 : void 0) || "game_center_hided";
        this._event_dispatcher.dispatchEvent(event_key);
      }
    };

    return GameCenterSingleton;

  })();

  if (typeof namespace === "function") {
    namespace("plugin", function() {
      return GameCenter;
    });
  }

  Main = (function() {
    Main.INSTANCE = null;

    Main._EVENT_INSTANCE = null;

    Main.STAGE = null;

    Main.STAGE_WIDTH = 320 * getPixelRate();

    Main.STAGE_HEIGHT = 480 * getPixelRate();

    Main.prototype._assets_manager = null;

    Main.prototype._child_container = null;

    Main.prototype._loading_sprite = null;

    Main.prototype._scene = null;

    Main.getInstance = function() {
      return Main.INSTANCE;
    };

    Main.getEventDispatcher = function() {
      if (Main._EVENT_INSTANCE === null) {
        Main._EVENT_INSTANCE = new util.EventDispatcher();
      }
      return Main._EVENT_INSTANCE;
    };

    function Main(_at_global, _at_stage) {
      this.global = _at_global;
      this.stage = _at_stage;
      this._orientationChangeHandler = __bind(this._orientationChangeHandler, this);
      this._cycleEngineHandler = __bind(this._cycleEngineHandler, this);
      this._hideLoading = __bind(this._hideLoading, this);
      this.changeScene = __bind(this.changeScene, this);
      this.init = __bind(this.init, this);
      Main.INSTANCE = this;
      this.global.addEventListener('orientationchange', this._orientationChangeHandler, true);
      if (Config.IS_MOBILE) {
        this.global.document.addEventListener('deviceready', this.init, false);
      } else {
        this.init();
      }
      return;
    }

    Main.prototype.init = function() {
      var base;
      this._orientationChangeHandler();
      Main.STAGE = new createjs.Stage("stage");
      Main.STAGE.enableMouseOver(5);
      createjs.Touch.enable(Main.STAGE);
      createjs.Ticker.setFPS(Config.FPS);
      createjs.Sound.registerPlugins([createjs.WebAudioPlugin, createjs.HTMLAudioPlugin]);
      base = new createjs.Shape();
      base.graphics.beginFill("#000").drawRect(0, 0, Main.STAGE_WIDTH, Main.STAGE_HEIGHT);
      Main.STAGE.addChild(base);
      this._child_container = new createjs.Container();
      Main.STAGE.addChild(this._child_container);
      this._loading_sprite = new display.sprite.LoadingSprite();
      Main.STAGE.addChild(this._loading_sprite);
      this._assets_manager = util.AssetsManager.getInstance();
      this._assets_manager.init(Config.RESOURCES);
      data.PlayerData.getInstance();
      this._loading_sprite.visible = true;
      this._assets_manager.load("global", (function(_this) {
        return function() {
          return _this.changeScene("title");
        };
      })(this));
      plugin.GameCenter.getInstance();
    };

    Main.prototype.changeScene = function() {
      var args, scene_id, scene_name;
      scene_id = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
      if (scene_id in Config.SCENES) {
        scene_name = Config.SCENES[scene_id];
      } else {
        return;
      }
      this._loading_sprite.visible = true;
      if (this._scene != null) {
        createjs.Ticker.removeEventListener("tick", this._cycleEngineHandler);
        this._child_container.removeAllEventListeners();
        this._child_container.removeAllChildren();
        createjs.Tween.removeAllTweens();
        Main.getEventDispatcher().clearAllEventListener();
      }
      if (scene_name in display.scene) {
        this._scene = construct(display.scene[scene_name], args);
        this._child_container.addChild(this._scene);
        this._assets_manager.load(scene_id, (function(_this) {
          return function() {
            _this._scene.init(_this._assets_manager);
            createjs.Ticker.addEventListener("tick", _this._cycleEngineHandler);
            _this._hideLoading();
            switch (scene_id) {
              case "game":
                return audio.BgmManager.getInstance().play("bgm_game");
              default:
                return audio.BgmManager.getInstance().play("bgm_opening");
            }
          };
        })(this));
      }
    };

    Main.prototype._hideLoading = function() {
      this._loading_sprite.visible = false;
    };

    Main.prototype._cycleEngineHandler = function(delta) {
      var _ref;
      Main.STAGE.update();
      if ((_ref = this._scene) != null) {
        if (typeof _ref.tickHandler === "function") {
          _ref.tickHandler(delta);
        }
      }
    };

    Main.prototype._orientationChangeHandler = function(e) {
      var _ref, _ref1, _ref2, _ref3;
      switch (this.global.orientation) {
        case 90:
        case -90:
          if ((_ref = this.stage) != null) {
            if (typeof _ref.setAttribute === "function") {
              _ref.setAttribute('width', Main.STAGE_HEIGHT);
            }
          }
          if ((_ref1 = this.stage) != null) {
            if (typeof _ref1.setAttribute === "function") {
              _ref1.setAttribute('height', Main.STAGE_WIDTH);
            }
          }
          break;
        default:
          if ((_ref2 = this.stage) != null) {
            if (typeof _ref2.setAttribute === "function") {
              _ref2.setAttribute('width', Main.STAGE_WIDTH);
            }
          }
          if ((_ref3 = this.stage) != null) {
            if (typeof _ref3.setAttribute === "function") {
              _ref3.setAttribute('height', Main.STAGE_HEIGHT);
            }
          }
      }
    };

    return Main;

  })();

  new Main(window, document.getElementById('stage'));

}).call(this);
