function doesConnectionExist() {
    var xhr = new XMLHttpRequest();
    var file = "http://www.telize.com/geoip";
    var randomNum = Math.round(Math.random() * 10000);
    xhr.open('HEAD', file + "?rand=" + randomNum, false);
    try {
        xhr.send();
        if (xhr.status >= 200 && xhr.status < 304) {
            return true;
        } else {
            return false;
        }
    } catch (e) {
        return false;
    }
}

if (!doesConnectionExist()) {
    var knownLanguage,
        userLang = navigator.language.split('-');

    $('.square').fadeOut();
    $.getJSON( "./json/languages.json", function( languages ) {
        $.each(languages, function (key, value) {
            if (value.iso === userLang[0].toLowerCase()) {
                knownLanguage = value.string;
            }
        });
    }).done(function() {
        if(knownLanguage) {
            $('.no-internet').html(knownLanguage);
        } else {
            $('.no-internet').html("You don't seem to be connected to the internet and a connection is required to use the aplication");
        }
    });

} else {
    var countryRecognized;
    $.ajax({
        type: 'GET',
        url: "http://www.telize.com/geoip",
        async: false,
        jsonpCallback: 'getgeoip',
        contentType: "application/json",
        dataType: 'jsonp',
        success: function (response) {
            $.getJSON( "./json/countries.json", function( countries ) {
                $.each(countries, function (key, value) {
                    if (value.iso === response.country_code.toLowerCase()) {
                        countryRecognized = value.url;
                    }
                });
            }).done(function() {
                if(countryRecognized) {
                    setTimeout(function () {
                        window.location = countryRecognized;
                    }, 1000);
                } else {
                    setTimeout(function () {
                        window.location = 'http://kaymu.com';
                    }, 1000);      
                }
        });
        }
    });
}
