var db;
var page = 'home';
var saved = false;

if (!String.prototype.trim) {
  String.prototype.trim = function () {
    return this.replace(/^\s+|\s+$/g, '');
  };
}
 
function initializeDB() {
  if (window.indexedDB) {
    console.log("IndexedDB ok");
  }
  else {
    alert("Sorry, this app require that your browser support IndexedDB to work");
  }
  var request = indexedDB.open('notesdb', 1);
  
  request.onsuccess = function (e) {
    db = e.target.result;
    getNotes();
  }
   
  request.onerror = function (e) {
    console.log(e);
  };
  
  request.onupgradeneeded = function (e) {
    db = e.target.result;
     
    if (db.objectStoreNames.contains("notes")) {
      db.deleteObjectStore("notes");
    }
    
    var objectStore = db.createObjectStore('notes', { keyPath: 'id', autoIncrement: true });
    
    objectStore.createIndex("fulltext", "fulltext", { unique: false });
    objectStore.createIndex("date", "date", { unique: false });
     
    console.log("Object Store has been created");
  };
}

function checkInput(value) {
  value = value.trim();
  if (value !== '') { return true; }
  else { return false; }
}

function setTitle(value) {
  if(checkInput(value)) { return value.trim(); }
  else { return 'Unnamed note'; }
}

function checkSave() {
  if(page === 'view-note') {
    // c'est un update
    if($("#noteTitle2").val() !== $("#prevTitle").val() || $("#noteDetails2").val() !== $("#prevDetails").val()) {
      updateNote(1);
    }
  }
  if(page === 'add-note') {
    // c'est une nouvelle note
    if(!saved) {
      if(checkInput($("#noteTitle").val()) || checkInput($("#noteDetails2").val())) {
        var r = confirm("Save this note ?");
        if (r == true) {
          saveNote(1);
        }
        else { saved = true; }
      }
    }
  }
}

function getNote(id) {
  var transaction = db.transaction(["notes"]);
  var objectStore = transaction.objectStore("notes");
  var request = objectStore.get(id);
  request.onerror = function(e) {
    console.log(e);
  };
  request.onsuccess = function(e) {
    $.mobile.changePage($("#view-note"));
    page = 'view-note';
    $("#noteTitle2").val(request.result.title);
    $("#noteDetails2").val(request.result.details);
    $("#noteId").val(request.result.id);
  };
};

function getNotes() {
  if(page === 'view-note' || page === 'add-note') { checkSave(); }
  $.mobile.changePage($("#home"));
  page = 'home';
  $("#note-list table").html("");
  
  var transaction = db.transaction([ 'notes' ]);
  var store = transaction.objectStore('notes');
  
  store.openCursor(null, 'prev').onsuccess = function (e) {
    var cursor = e.target.result;
    if (cursor) {
      var value = cursor.value;
      $("#note-list table").append('<tr><td style="width:3em;"><a href="javascript:deleteNote('+value.id+')" class="ui-btn ui-icon-delete ui-btn-icon-notext ui-corner-all">No text</a></td><td><a href="javascript:getNote('+value.id+')" class="ui-btn ui-icon-carat-r ui-btn-icon-right">'+value.title+'</a></td></tr>');
      cursor.continue();
    }
  };
};

function addNote() {
  if(page === 'view-note' || page === 'add-note') { checkSave(); }
  $.mobile.changePage($("#add-note"));
  page = 'add-note';
  $("#noteTitle").val("");
  $("#noteDetails").val("");
  $("#noteTitle").focus();
};

function saveNote(silent) {
  noteTitle = $("#noteTitle").val();
  noteDetails = $("#noteDetails").val();
  
  if(checkInput(noteTitle) || checkInput(noteDetails)) {
    var d = new Date();
    
    var transaction = db.transaction([ 'notes' ], 'readwrite');
    
    var value = {};
    value.title = setTitle(noteTitle);
    value.details = noteDetails;
    value.fulltext = value.title+' '+noteDetails;
    value.fulltext = value.fulltext.toLowerCase();
    value.date = d.getTime();
    
    var store = transaction.objectStore('notes');
    var request = store.add(value);
    
    request.onsuccess = function (e) {
      saved = true;
      if(!silent) {
        alert("Saved");
        getNotes()
      }
    };
    request.onerror = function (e) {
      alert("Error : " + e.value);
    }
  }
  else { alert('This note is empty !'); }
  
}

function updateNote(silent) {
  noteTitle = $("#noteTitle2").val();
  noteDetails = $("#noteDetails2").val();
  noteId = parseInt($("#noteId").val());
  var d = new Date();
  if(checkInput(noteTitle) || checkInput(noteDetails)) {
    var transaction = db.transaction(["notes"], "readwrite");
    var objectStore = transaction.objectStore("notes");
    var request = objectStore.get(noteId);
    request.onerror = function(e) {
      console.log(e);
    };
    request.onsuccess = function(e) {
      var value = request.result;
      value.title = setTitle(noteTitle);
      value.details = noteDetails;
      value.fulltext = value.title+' '+noteDetails;
      value.fulltext = value.fulltext.toLowerCase();
      value.date = d.getTime();
    
      // Put this updated object back into the database.
      var requestUpdate = objectStore.put(value);
      requestUpdate.onsuccess = function(e) {
        if(!silent) {
          alert("Saved");
          getNotes()
        }
      };
      requestUpdate.onerror = function(e) {
        alert("Error : " + e.value);
      };
    };
  }
  else { alert('This note is empty ! You can use the delete note function instead'); }
}

function deleteNote(id) {
  var r = confirm("Delete this note ?");
  if (r == true) {
    var transaction = db.transaction([ 'notes' ], 'readwrite');
    var store = transaction.objectStore('notes');
    
    var request = store.delete(id);
    request.onsuccess = function () {
      getNotes();
    }
    request.onerror = function (e) {
      alert("Error while deleting note : " + e.value);
    };
  }
}
 
$(document).ready(function(){ 
  initializeDB();
  $( "#noteTitle" ).change(function() { saved = false; });
  $( "#noteDetails" ).change(function() { saved = false; });
});
