var KidsFingers = (function() {
	var _paintAreaCanvas,
	_paintAreaContext,
	_pen = {r: 255, g: 0, b: 0},
	_penWidth = 100,
	_penWidthTimer,
	_drawing = false,
	_border = 3,
	_paintWidth = 40,
	_widthCorrection = 60,
	_tempCanvas = document.createElement('canvas'),
	_tempContext,
	_penWidthTimerRun = false,
	_queue = [],
	_paintTimer,
	_paintTimerInterval = 10,
	_pointCounter = 0,
	_pointCounterReset = 200,
	
	paintMouseDown = function(color, event) {
		//event.preventDefault();
		
		event.currentTarget.className += ' active';
		
		_pen = color;
		_penWidth = 50;
		
		_drawing = true;
		
		window.clearInterval(_penWidthTimer);
		_penWidthTimer = window.setInterval(paintMouseDownPenWidthTimer, 100);
		
		return false;
	},
	
	paintMouseUp = function(event) {
		event.preventDefault();
		
		event.currentTarget.className = event.currentTarget.className.replace(' active', '');
		
		_drawing = false;
		
		window.clearInterval(_penWidthTimer);
		_penWidthTimerRun = false;

		return false;
	},
	
	paintMouseOut = function(event) {
		event.preventDefault();
		
		event.currentTarget.className = event.currentTarget.className.replace(' active', '');
		
		window.clearInterval(_penWidthTimer);
		_penWidthTimerRun = false;

		return false;
	},
	
	paintMouseDownPenWidthTimer = function() {
		//A fehr szn hosszabban vlaszthat, de 2 msodperc utn trli a canvast
		if ((_pen.r === 255) && (_pen.g === 255) && (_pen.b === 255)) {
			if (_penWidth < 200) {
				_penWidth += 10;
			} else {
				window.clearInterval(_penWidthTimer);
				_penWidthTimerRun = false;
				clearCanvas();
			}
		} else {
			if (_penWidth < 100) {
				_penWidth += 10;
			} else {
				window.clearInterval(_penWidthTimer);
				_penWidthTimerRun = false;
			}
		}
	},
	
	mouseDown = function(event) {
		//event.preventDefault();

		if (event.touches !== undefined) {
			event = event.touches[0] || event || window.event;
			touching = true;
		} else {
			event = event || window.event;
		}
		
		var x = event.pageX - _paintAreaCanvas.offsetLeft,
		y = event.pageY - _paintAreaCanvas.offsetTop;
		
		_drawing = true;
		
		_queue.push({x: x, y: y, r: _pen.r, g: _pen.g, b: _pen.b, w: _penWidth});
		
		return false;
	},
	
	mouseUp = function(event) {
		if (event !== undefined) {
			event.preventDefault();
		}
		
		_drawing = false;
		
		window.clearInterval(_penWidthTimer);
		_penWidthTimerRun = false;
		
		return false;
	},
	
	mouseOut = function(event) {
		event.preventDefault();
		mouseUp();
		
		return false;
	},
	
	mouseMove = function(event) {
		event.preventDefault();
		if (_drawing) {
			if (event.touches !== undefined) {
				event = event.touches[0] || event || window.event;
			} else {
				event = event || window.event;
			}
			
			var x = event.pageX - _paintAreaCanvas.offsetLeft,
			y = event.pageY - _paintAreaCanvas.offsetTop;
			
			if (!_penWidthTimerRun) {
				_penWidthTimerRun = true;
				window.clearInterval(_penWidthTimer);
				_penWidthTimer = window.setInterval(mouseMovePenWidthTimer, 500);
			}
			
			_queue.push({x: x, y: y, r: _pen.r, g: _pen.g, b: _pen.b, w: _penWidth});
		}
		
		return false;
	},
	
	mouseMovePenWidthTimer = function() {
		if (_penWidth > 0) {
			_penWidth -= 10;
		} else {
			_drawing = false;

			window.clearInterval(_penWidthTimer);
			_penWidthTimerRun = false;
		}
	},
	
	paint = function() {
		window.clearInterval(_paintTimer);
		
		var point = _queue.shift();
		
		if (point !== undefined) {
			_paintAreaContext.fillStyle = 'rgba(' + point.r + ', ' + point.g + ', ' + point.b + ', ' + Math.min(point.w / 100, 1) + ')';
			_paintAreaContext.beginPath();
			_paintAreaContext.arc(point.x, point.y, 15, 0, 2 * Math.PI, false);
			_paintAreaContext.closePath();
			_paintAreaContext.fill();
			
			_pointCounter += 1;
			
			if (_pointCounter >= _pointCounterReset) {
				var tmpPen = _pen,
				tmpPenWidth = _penWidth;
				
				clearCanvas();
				//_paintAreaContext.clearRect(0, 0, _paintAreaCanvas.width, _paintAreaCanvas.height);
				_paintAreaContext.drawImage(_tempCanvas, 0, 0);
				_pointCounter = 0;
				
				_pen = tmpPen;
				_penWidth = tmpPenWidth;
			}
		}
		
		_paintTimer = window.setInterval(paint, _paintTimerInterval);
	}
	
	clearCanvas = function() {
		_queue = [];
		saveCanvas();
		
		var tmpCanvas = document.createElement('canvas')
		tmpCanvas.setAttribute('id', 'paintAreaCanvas');
		tmpCanvas.width = _tempCanvas.width;
		tmpCanvas.height = _tempCanvas.height;
		
		var area = document.getElementById('paintArea');
		area.removeChild(document.getElementById('paintAreaCanvas'));
		area.innerHTML = '<canvas id="paintAreaCanvas"></canvas>';
		
		_paintAreaCanvas = document.getElementById('paintAreaCanvas');
		_paintAreaCanvas.width = _tempCanvas.width;
		_paintAreaCanvas.height = _tempCanvas.height;
		_paintAreaContext = _paintAreaCanvas.getContext('2d');
		
		setHandlers();

		_pen = {r: 255, g: 0, b: 0};
		_penWidth = 100;
		_pointCounter = 0;
	},
	
	saveCanvas = function() {
		//http://stackoverflow.com/questions/5517783/preventing-canvas-clear-when-resizing-window

		_tempCanvas.width = _paintAreaCanvas.width;
		_tempCanvas.height = _paintAreaCanvas.height;
		_tempContext.clearRect(0, 0, _tempCanvas.width, _tempCanvas.height);
		_tempContext.drawImage(_paintAreaCanvas, 0, 0);
	},
	
	hideAddressBar = function() {
		if (!window.location.hash) {
			if(document.height < window.outerHeight) {
				document.body.style.height = (window.outerHeight + 50) + 'px';
			}
			
			setTimeout( function() {
				window.scrollTo(0, 1);
			}, 50 );
		}
	},
	
	isBugged = function() {
		return (navigator.userAgent.toLowerCase().indexOf('android 2.2') !== -1)
			|| (navigator.userAgent.toLowerCase().indexOf('android 2.3') !== -1)
	},
	
	isLandscape = function () {
		//http://stackoverflow.com/questions/10131782/detect-orientation-using-javascript-on-android-devices
		var width = screen.width,
		height = screen.height;
		
		if (isBugged()) {
			var temp = width;
			width = height;
			height = temp;
		}
		
		var landscape = width > height;
		return landscape;
	},
	
	initPaint = function(paintDivId, color) {
		var div = document.getElementById(paintDivId);
		
		if (typeof(window.ontouchstart) != 'undefined') {
			div.ontouchstart = function(event) { return paintMouseDown(color, event) };
			div.ontouchend = paintMouseUp;
			div.ontouchcancel = paintMouseUp;
		} else {
			div.onmousedown = function(event) { return paintMouseDown(color, event) };
			div.onmouseup = paintMouseUp;
		}
		
		div.onmouseout = paintMouseOut;
	},
	
	setLandscape = function() {
		var paints_area = document.querySelectorAll('#paints, #paintArea');
		for (var i = 0; i < paints_area.length; i++) {
			paints_area[i].className += ' floatLeft';
		}
		
		var paints = document.querySelectorAll('.paint');
		for (var i = 0; i < paints.length; i++) {
			paints[i].className = 'paint margin10_0';
		}
		
		_paintAreaCanvas.width = window.innerWidth - (2 * _border) - _paintWidth - _widthCorrection / 2;
		_paintAreaCanvas.height = window.innerHeight - (2 * _border);
	},
	
	setPortrait = function() {
		var paints_area = document.querySelectorAll('#paints, #paintArea');
		for (var i = 0; i < paints_area.length; i++) {
			paints_area[i].className = paints_area[i].className.replace(' floatLeft', '');
		}
		
		var paints = document.querySelectorAll('.paint');
		for (var i = 0; i < paints.length; i++) {
			paints[i].className = 'paint floatLeft margin0_10';
		}
		
		_paintAreaCanvas.width = window.innerWidth - (2 * _border);
		_paintAreaCanvas.height = window.innerHeight - (2 * _border) - _paintWidth - _widthCorrection / 2;
	},
	
	handleOrientationChanged = function() {
		saveCanvas();
		
		switch(window.orientation) {
			case -90:
			case 90:
				//http://stackoverflow.com/questions/7341318/android-javascript-problem-with-window-innerwidth-and-window-orientationeven
				setTimeout(setLandscape, 500);
				break;
			default:
				setTimeout(setPortrait, 500);
				break; 
		}			

		setTimeout(function() {
			_paintAreaContext.drawImage(_tempCanvas, 0, 0);
		} , 500);
		
		//clearCanvas(_paintAreaContext, _paintAreaCanvas);
		hideAddressBar();
	},
	
	hideSplash = function() {
		var splashDiv = document.getElementById('splash');
		splashDiv.style.visibility = 'hidden';
	},
	
	setHandlers = function() {
		if (typeof(window.ontouchstart) != 'undefined') {
			_paintAreaCanvas.ontouchstart = mouseDown;
			_paintAreaCanvas.ontouchend = mouseUp;
			_paintAreaCanvas.ontouchcancel = mouseUp;
			document.ontouchmove = mouseMove;
			document.ontouchstart = function(e) { e.preventDefault(); };
		}
		else {
			_paintAreaCanvas.onmousedown = mouseDown;
			_paintAreaCanvas.onmouseup = mouseUp;
			document.onmousemove = mouseMove;
			document.onmousedown = function(e) { e.preventDefault(); };
		}
		
		_paintAreaCanvas.onmouseout = mouseOut;
	},
	
	init = function() {
		_paintAreaCanvas = document.getElementById('paintAreaCanvas');
		_paintAreaContext = _paintAreaCanvas.getContext('2d');
		
		_tempContext = _tempCanvas.getContext('2d');
		
		if ((!isBugged() && isLandscape()) || (isBugged() && !isLandscape())) {
			setLandscape();
		} else {
			setPortrait();
		}
		
		initPaint('red', {r: 255, g: 0, b: 0});
		initPaint('blue', {r: 0, g: 0, b: 255});
		initPaint('green', {r: 0, g: 255, b: 0});
		initPaint('yellow', {r: 255, g: 255, b: 0});
		initPaint('brown', {r: 127, g: 51, b: 0});
		initPaint('black', {r: 0, g: 0, b: 0});
		initPaint('white', {r: 255, g: 255, b: 255});
		
		setHandlers();
		
		// Cmsor eltntetse
		window.addEventListener("load", function() {
			setTimeout(function() {
				if (!window.pageYOffset) {
					hideAddressBar();
				}
			} , 500);
		} );
		
		setTimeout(hideSplash, 3000);
		
		window.addEventListener("orientationchange", handleOrientationChanged);
		
		document.addEventListener('touchmove', function (e) {
			e.preventDefault();
		}, false);
		
		_paintTimer = window.setInterval(paint, _paintTimerInterval);
	};
	
	init();
	
	return {
	}
})();
