// Level related functions

/**
 * Displays a coinfirm popup to restart the game
 */
Game.confirmRestart = function() {
	audioBotao.play();
	Popup.confirm('Deseja recomeçar ?', null, Game.restart);
	Game.removeHint();
};

/**
 * Restarts the game
 */
Game.restart = function() {
	Game.removeHint();
	Game.emptyGrid();
	Game.resetTimer();
	Game.init();	
};

/**
 * Notices the player of the end of the level
 */
Game.endLevel = function() {
	audioStage.pause(); audioStage.currentTime = 0;
	audioWin.play();
	
	Popup.alert('Nível ' + Game.level + ' finalizado !', Game.nextLevel);
	Game.removeHint();
}

/**
 * Goes to the next level
 */
Game.nextLevel = function() {	
	audioWin.pause(); audioWin.currentTime = 0;
	audioStage.play();
	Game.level++;
	if (Game.bonus.bomb != undefined) {
		delete Game.bonus.bomb;
	}

	if (Game.level == 5) {
		Game.gemRange++;
	}

	get('#current_gauge').style.height = '100%';
	get('#level').innerHTML = Game.level;
	Game.resetScore();
	Game.resetTimer();
	Game.emptyGrid();
	Game.createGrid();
};

/**
 * Checks if the game is over (no possibility to make a streak)
 */
Game.checkGameOver = function() {
	if (!Game.checkHint()) {
		Game.gameOver();
	}
};

/**
 * When the game is over : displays a popup to make the player restart
 */
Game.gameOver = function() {
	Popup.confirm('Game over.<br/>Deseja recomeçar ?', null, Game.restart);
	Game.paused = true;
};