Keyboards.latex = {
  label: 'LaTeX',
  shortLabel: 'Br',
  imEngine: 'latex',
  types: ['text', 'url', 'email'],
  menuLabel: 'LaTeX',
  disableAlternateLayout: true,
  alt: {
       
    e: [
    { value: 'é' }, { value: 'è' }
    ],
        u: [
    { value: 'ù' }],

        '.': [
    { value: ',' }, { value: '?' }, { value: '!' },
    { value: ';' }, { value: ':' },
    { value: '…', compositeKey: '…' }
    
    ]
  },
  keys: [
    [
      { value: 'CTRL', ratio: 10, keyCode: KeyboardEvent.DOM_VK_CONTROL }
    ],
    [
       { value: 'C\'H', compositeKey: 'c\'h', uppervalue: 'C\'H'}, { value: 'w' }, { value: 'e' } , { value: 'r' },
      { value: 't' } , { value: 'y' }, { value: 'u' } , { value: 'i' },
      { value: 'o' }, { value: 'p' }
    ], [
      { value: 'a' }, { value: 's' }, { value: 'd' }, { value: 'f' },
      { value: 'g' } , { value: 'h' }, { value: 'j' }, { value: 'k' },
      { value: 'l' },{ value: 'm' },
      { value: ':', visible: ['url']}, { value: '_', visible: ['email']}
    ], [
      { value: '⇪', ratio: 1.5, keyCode: KeyEvent.DOM_VK_CAPS_LOCK },
      { value: 'z' }, { value: 'v' }, { value: 'b' }, { value: 'n' },
      { value: 'CH', compositeKey: 'ch'}, { value: 'ñ' },{ value: '\'' },
      { value: '⌫', ratio: 1.5, keyCode: KeyEvent.DOM_VK_BACK_SPACE }
    ], [
      { value: '&nbsp', ratio: 8, keyCode: KeyboardEvent.DOM_VK_SPACE },
      { value: '↵', ratio: 2, keyCode: KeyEvent.DOM_VK_RETURN }
    ]
  ],
  alternateLayout: {
    disableAlternateLayout: true,
    alt: {
      '0': 'º',
      '1': '1añ ',
      '2': '2ved ',
      '3': '3de ',
      '4': '4re ',
      '5': '5ved ',
      '6': '6ved ',
      '7': '7ved ',
      '8': '8ved ',
      '9': '9ved ',
      '€': '$ £ ¥',
      '?': '¿',
      '!': '¡'
    },
    keys: [
      [
        { value: 'CTRL', ratio: 10, keyCode: KeyboardEvent.DOM_VK_CONTROL }
      ],
      [
        { value: '1' }, { value: '2' }, { value: '3' } , { value: '4' },
        { value: '5' } , { value: '6' }, { value: '7' } , { value: '8' },
        { value: '9' }, { value: '0' }
      ], [
        { value: '@' }, { value: '#' },
        { value: '€', className: 'alternate-indicator' }, { value: '&' },
        { value: '*' }, { value: '-' }, { value: '_' }, { value: '/' },
        { value: '(' }, { value: ')' }
      ], [
        { value: 'ALT', ratio: 1.5, keyCode: KeyEvent.DOM_VK_ALT },
        { value: '+', supportsSwitchingValue: ',' }, { value: ':' },
        { value: ';' }, { value: '"' },
        { value: '\'' }, { value: '?' }, { value: '!' },
        { value: '⌫', ratio: 1.5, keyCode: KeyEvent.DOM_VK_BACK_SPACE }
      ], [
        { value: '&nbsp', ratio: 8, keyCode: KeyboardEvent.DOM_VK_SPACE },
        { value: '↵', ratio: 2, keyCode: KeyEvent.DOM_VK_RETURN }
      ]
    ]
  },
  symbolLayout: {
    disableAlternateLayout: true,
    keys: [
      [
        { value: 'CTRL', ratio: 10, keyCode: KeyboardEvent.DOM_VK_CONTROL }
      ],
      [
        { value: '¥' }, { value: '€' }, { value: '£' }, { value: '¢' },
        { value: '₠' }, { value: '%' }, { value: '©' }, { value: '®' },
        { value: '|' }, { value: '\\' }
      ], [
        { value: '~' }, { value: '°C', compositeKey: '°C' },
        { value: '°F', compositeKey: '°F' }, { value: '°' },
        { value: '<' }, { value: '>' }, { value: '[' }, { value: ']' },
        { value: '{' }, { value: '}' }
      ], [
        { value: 'ALT', ratio: 1.5, keyCode: KeyEvent.DOM_VK_ALT },
        { value: '`' }, { value: '^' }, { value: '±', supportsSwitchingValue: '+' },
        { value: '=' }, { value: '§' }, { value: '¿'}, {value: '¡'},
        { value: '⌫', ratio: 1.5, keyCode: KeyEvent.DOM_VK_BACK_SPACE }
      ], [
        { value: '&nbsp', ratio: 8, keyCode: KeyboardEvent.DOM_VK_SPACE },
        { value: '↵', ratio: 2, keyCode: KeyEvent.DOM_VK_RETURN }
      ]
    ]
  }
  
 
};
