// JavaScript Document
$(document).ready(function(){
	//incomes list
	incomeList = $('#incomeList');
	incomes = km_datas.incomes[year][month];
	if(incomeList){
	for(na=0;na<incomes.rows.length;na++){
		if(incomes.rows[na]==null){
			continue;
		}
		row = document.createElement('tr');
		td = document.createElement('td');
		td.innerHTML = incomes.rows[na].text;
		row.appendChild(td);
		td = document.createElement('td');
		td.innerHTML = currencyFormat(incomes.rows[na].value);
		if(na>0){
			delBtn = document.createElement('div');
			delBtn.className = 'del-btn';
			delBtn.innerHTML = 'x';
			delBtn.setAttribute('onclick',"deleteRow('income','"+na+"')");
			td.appendChild(delBtn);
		}
		row.appendChild(td);
		incomeList.append(row);
	}
	row = document.createElement('tr');
	td = document.createElement('th');
	td.innerHTML = 'Totals';
	row.appendChild(td);
	td = document.createElement('th');
	td.innerHTML = currencyFormat(incomes.totals);
	row.appendChild(td);
	incomeList.append(row);
	}
	//payments list
	paymentList = $('#paymentList');
	payments = km_datas.payments[year][month];
	if(paymentList){
	for(na=0;na<payments.rows.length;na++){
		if(payments.rows[na]==null){
			continue;
		}
		row = document.createElement('tr');
		td = document.createElement('td');
		td.innerHTML = payments.rows[na].text;
		row.appendChild(td);
		td = document.createElement('td');
		td.innerHTML = currencyFormat(payments.rows[na].value);
		if(na>0){
			delBtn = document.createElement('div');
			delBtn.className = 'del-btn';
			delBtn.innerHTML = 'x';
			delBtn.setAttribute('onclick',"deleteRow('payment','"+na+"')");
			td.appendChild(delBtn);
		}
		row.appendChild(td);
		paymentList.append(row);
	}
	row = document.createElement('tr');
	td = document.createElement('th');
	td.innerHTML = 'Totals';
	row.appendChild(td);
	td = document.createElement('th');
	td.innerHTML = currencyFormat(payments.totals);
	row.appendChild(td);
	paymentList.append(row);
	}
	//Add Form
	money_format = $('#money-format');
	money_value = $('#money-value');
	money_format.click(function(){
		money_value.addClass('unvis');
		money_value.focus();
		money_value.select();
	});
	money_value.keyup(function(){
		if(parseInt(money_value.val())){
			money_value.addClass('unvis');
			money_format.removeClass('unvis');
			money_format.html(currencyFormat(money_value.val()));
		}else{
			money_value.removeClass('unvis');
			money_format.addClass('unvis');
			money_format.html('');
		}
	});
	$('#income-add-form').submit(function(a){
		date = new Date();
		time = date.getTime();
		year = date.getFullYear();
		month = date.getMonth();
		if($('#info').val()!=''&&(!isNaN(parseInt(money_value.val())))){
			idx = km_datas.incomes[year][month].rows.length;
			km_datas.incomes[year][month].totals += parseInt(money_value.val());
			km_datas.incomes[year][month].rows[idx] = {
				"date" : time,
				"text" : $('#info').val(),
				"value" : parseInt(money_value.val())
			};
			$.jStorage.set("km_CCNA",km_datas);
			document.location = 'income.html';
		}else{
			$('#error-msg').css('display','block')
		}
		a.preventDefault();
	});
	$('#payment-add-form').submit(function(a){
		date = new Date();
		time = date.getTime();
		year = date.getFullYear();
		month = date.getMonth();
		if($('#info').val()!=''&&(!isNaN(parseInt(money_value.val())))){
			idx = km_datas.payments[year][month].rows.length;
			km_datas.payments[year][month].totals += parseInt(money_value.val());
			km_datas.payments[year][month].rows[idx] = {
				"date" : time,
				"text" : $('#info').val(),
				"value" : parseInt(money_value.val())
			};
			$.jStorage.set("km_CCNA",km_datas);
			document.location = 'payment.html';
		}else{
			$('#error-msg').css('display','block')
		}
		a.preventDefault();
	});
});
function deleteRow(type,idx){
	value = 0;
	msg = '';
	switch(type){
		case 'income' :
			value = km_datas.incomes[year][month].rows[idx].value;
			msg = km_datas.incomes[year][month].rows[idx].text;
		break;
		case 'payment' :
			value = km_datas.payments[year][month].rows[idx].value;
			msg = km_datas.payments[year][month].rows[idx].text;
		break;
	}
	if(confirm('Are you sure delete this record ?\n"'+msg+'"')){
		switch(type){
			case 'income' :
				km_datas.incomes[year][month].totals -= value;
				km_datas.incomes[year][month].rows[idx] = null;
			break;
			case 'payment' :
				km_datas.payments[year][month].totals -= value;
				km_datas.payments[year][month].rows[idx] = null;
			break;
		}
		$.jStorage.set("km_CCNA",km_datas);
		document.location.reload();
	}
}