// JavaScript Document
jStorage = $.jStorage;
txtmonth = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Agt','Sep','Nov','Des'];
//Cek Data
var km_datas = jStorage.get("km_CCNA");
date = new Date();
time = date.getTime();
year = date.getFullYear();
month = date.getMonth();
if(!km_datas){
	km_datas = {
		"km_settings" : {
			"currency" : {
				"prefx" : 'Rp.',
				'thousand' : '.'
			},
			"password" : '1234',
			"using_password" : 0,
		},
		"incomes" : Array(), 
		"payments" : Array(),
	};
	$.jStorage.set("km_CCNA",km_datas);
}
//Auth
$(document).ready(function(){
	if(km_datas.km_settings.using_password){
		if(!sessionStorage.currentPassword){//if before login
			document.location = 'login.html';
		}
	}else{
		sessionStorage.currentPassword=1;
	}
});
function countIncomePayment(pos){
	date = new Date();
	year = date.getFullYear();
	month = date.getMonth();
	if(pos==1){
		if(month<11){
			month++;
		}else{//new year
			year++;
			month=0;
		}
	}else if(pos==-1){
		if(month==0){//last year
			year--;
			month=11;
		}else{
			month--;
		}
	}
	lastIncome = km_datas.incomes[year]&&km_datas.incomes[year][month] ? km_datas.incomes[year][month] : 0;
	income = lastIncome ? lastIncome.totals : 0;
	lastPayment = km_datas.payments[year]&&km_datas.payments[year][month] ? km_datas.payments[year][month] : 0;
	payment = lastPayment ? lastPayment.totals : 0;
	return [income,payment];
}
function currencyFormat(number){
	value = km_datas.km_settings.currency.prefx+' ';
	tmpNmb = '';
	number = number==null ? 0 : number;
	number = typeof number == 'string' ? number : number.toString();
	n2 = 0;
	for(n=number.length-1;n>=0;n--){
		if(n2%3==0){
			tmpNmb += km_datas.km_settings.currency.thousand;
		}
		tmpNmb += number[n];
		n2++;
	}
	for(n=tmpNmb.length-1;n>0;n--){
		value += tmpNmb[n];
	}
	value += ',-';
	return value;
}
$(document).ready(function(){
	//content
	$('#content').attr('style','height:'+(window.innerHeight-160)+'px');
	//link handle
	$('.link-btn').click(function(a){
		target = $(a.originalTarget);
		href = target.attr('data-href') ? target.attr('data-href') : target.parent().attr('data-href');
		document.location = href;
	});
	$('.close').click(function(){
		window.close();
	});
	
	//data handling
	if(!km_datas.incomes[year]||!km_datas.incomes[year][month]){
		lastIncomePayment = countIncomePayment(-1);
		lastIncome = lastIncomePayment[0];
		lastPayment = lastIncomePayment[1];
		
		date = new Date();
		time = date.getTime();
		year = date.getFullYear();
		month = date.getMonth();
		
		yearData = km_datas.incomes[year] ? km_datas.incomes[year] : Array();
		yearData[month] = {
			'totals' : lastIncome-lastPayment<0 ? 0 : lastIncome-lastPayment,
			'rows' : [
				{
					"date" : time,
					"text" : "Last Month Remain",
					"value" : lastIncome-lastPayment<0 ? 0 : lastIncome-lastPayment
				}
			]
		};
		km_datas.incomes[year] = yearData;
		
		yearData = km_datas.payments[year] ? km_datas.payments[year] : Array();
		yearData[month] = {
			'totals' : lastIncome-lastPayment>0 ? 0 : lastIncome-lastPayment,
			'rows' : [
				{
					"date" : time,
					"text" : "Last Month Remain",
					"value" : lastIncome-lastPayment>0 ? 0 : lastIncome-lastPayment
				}
			]
		};
		km_datas.payments[year] = yearData;
		$.jStorage.set("km_CCNA",km_datas);
	}
	//display in front page
	$('.income-nominal').html(currencyFormat(km_datas.incomes[year][month].totals));
	$('.payment-nominal').html(currencyFormat(km_datas.payments[year][month].totals));
	$('.remain-nominal').html(currencyFormat(km_datas.incomes[year][month].totals-km_datas.payments[year][month].totals));
	//display month
	$('.month').html(txtmonth[month]+' '+year);
});
$('#reset').click(function(){
	conf = confirm('Are you sure reset your KuMoney?');
	if(conf){
		conf = confirm('All of your datas will be deleted if you do this.');
		if(conf){
			$.jStorage.flush();
			document.location = 'index.html';
		}
	}
});