//---------------------------------------------------------------
// Glavna funkcija za parsovanje xml response koji dobijemo od
// servera
function GetValute(xml)	//prolazi kroz sve valute
{
	p1 	= xml.indexOf('<item>',0);		//EUR
	p2 	= xml.indexOf('</item>',0);
	txt = xml.substr(p1+6,(p2-(p1+6)));
	//procesiramo TXT
	var drzava = GetFullImeValute(txt);
	var valuta = GetSkracenoImeValute(txt);
	var kolicina = GetKolicinuValute(txt);
	var kupovni = GetKupovniKurs(txt);
	var srednji = GetSrednjiKurs(txt);
	var prodajni = GetProdajniKurs(txt);
	/*
	$('#log').append('<p>Ime drzve: ' + drzava + '</p>');
	$('#log').append('<p>Valuta: ' + valuta + '</p>');
	$('#log').append('<p>Kolicina: ' + kolicina + '</p>');
	$('#log').append('<p>Kupovni: ' + kupovni + '</p>');
	$('#log').append('<p>Srednji: ' + srednji + '</p>');
	$('#log').append('<p>Prodajni: ' + prodajni + '</p><hr>');
	*/
	localStorage.setItem(valuta, txt); //upisujemo informacije o valuti na telefon
	
	while((p2 != -1) && (p1 != -1))
	{
		p1 	= xml.indexOf('<item>',p2+7);		
		p2 	= xml.indexOf('</item>',p2+7);
		txt = xml.substr(p1+6,(p2-(p1+6)));
		//procesiramo TXT
		//prov uzimamo sve u varijable
		
		drzava = GetFullImeValute(txt);
		valuta = GetSkracenoImeValute(txt);
		kolicina = GetKolicinuValute(txt);
		kupovni = GetKupovniKurs(txt);
		srednji = GetSrednjiKurs(txt);
		prodajni = GetProdajniKurs(txt);
		
		if( (drzava != "") && (valuta != "") && (kolicina != "") && (kupovni != "") && (srednji != "") && (prodajni != "") )
		{
			/*
			$('#log').append('<p>Ime drzve: ' + drzava + '</p>');
			$('#log').append('<p>Valuta: ' + valuta + '</p>');
			$('#log').append('<p>Kolicina: ' + kolicina + '</p>');
			$('#log').append('<p>Kupovni: ' + kupovni + '</p>');
			$('#log').append('<p>Srednji: ' + srednji + '</p>');
			$('#log').append('<p>Prodajni: ' + prodajni + '</p><hr>');
			*/
			localStorage.setItem(valuta, txt); //upisujemo informacije o valuti na telefon
		}
		//alert(txt);
	}
}
//---------------------------------------------------------------
// Dobijamo ime drzave
function GetFullImeValute(str)	//vraca ime drzave
{
	p = str.indexOf(' -');
	return str.substr(11,p-11);
}
//---------------------------------------------------------------
// Dobijamo oznaku valute (EUR,USD...)
function GetSkracenoImeValute(str)	//vraca valutu
{
	p3 = str.indexOf('- ');
	p4 = str.indexOf(' -',p3+2);
	return str.substr(p3+2,p4-(p3+2));
}
//---------------------------------------------------------------
// Dobijamo kolicinu value (1 EUR, 100 YEN itd...)
function GetKolicinuValute(str) //vraca kolicinu
{
	p5 = str.indexOf('- ');
	p5 = str.indexOf('- ',p5+1);
	p6 = str.indexOf(' -',p5+1);
	return str.substr(p5+1,p6-(p5+1));
}
//---------------------------------------------------------------
// Dobijamo Kupovni kurs za odredjeni str
function GetKupovniKurs(str)
{
	p7 = str.indexOf('Kupovni: ');
	if(p7 == -1)
		return "0,0000";
	p8 = str.indexOf(' -',p7+8);
	return str.substr(p7+8,p8-(p7+8));
}
//---------------------------------------------------------------
// Dobijamo srednji kurs
function GetSrednjiKurs(str)
{
	p9 = str.indexOf('Srednji: ');
	p10 = str.indexOf(' -',p9+8);
	if(p10 == -1)
	{
		p10 = str.indexOf('</description>',p9+8);
		return str.substr(p9+8,p10-(p9+8));
	}
	return str.substr(p9+8,p10-(p9+8));
}
//---------------------------------------------------------------
// Dobijamo prodajni kurs
function GetProdajniKurs(str)
{
	p11 = str.indexOf('Prodajni: ');
	if(p11 == -1)
		return "0,0000";
	p12 = str.indexOf('</description>',p11+9);
	return str.substr(p11+9,p12-(p11+9));
}
//----------------------------------------------------------------
// Popunjavamo skroll listu sa informacijama iz baze

function PopuniSkrollListu()
{
	//TODO: Napravimo da korisnik bira 5 zeljene :D
	$('.kursskroll marquee').html(""); //obrisemo skroll listu
	$('.kursskroll marquee').append("<div class=\"left\" id=\"EUR\">" + GetSrednjiKurs(localStorage.getItem("EUR")) + "</div>"); //EUR
	$('.kursskroll marquee').append("<div class=\"left\" id=\"USD\">" + GetSrednjiKurs(localStorage.getItem("USD")) + "</div>"); //USD
	$('.kursskroll marquee').append("<div class=\"left\" id=\"CHF\">" + GetSrednjiKurs(localStorage.getItem("CHF")) + "</div>"); //CHF
	$('.kursskroll marquee').append("<div class=\"left\" id=\"GBP\">" + GetSrednjiKurs(localStorage.getItem("GBP")) + "</div>"); //GBP
	$('.kursskroll marquee').append("<div class=\"left\" id=\"AUD\">" + GetSrednjiKurs(localStorage.getItem("AUD")) + "</div>"); //AUD
	$('.kursskroll marquee').append("<div class=\"left\" id=\"CAD\">" + GetSrednjiKurs(localStorage.getItem("CAD")) + "</div>"); //CAD
	$('.kursskroll marquee').append("<div class=\"left\" id=\"SEK\">" + GetSrednjiKurs(localStorage.getItem("SEK")) + "</div>"); //SEK
	$('.kursskroll marquee').append("<div class=\"left\" id=\"DKK\">" + GetSrednjiKurs(localStorage.getItem("DKK")) + "</div>"); //DKK
	$('.kursskroll marquee').append("<div class=\"left\" id=\"NOK\">" + GetSrednjiKurs(localStorage.getItem("NOK")) + "</div>"); //NOK
	$('.kursskroll marquee').append("<div class=\"left\" id=\"JPY\">" + GetSrednjiKurs(localStorage.getItem("JPY")) + "</div>"); //JPY
}
function PopuniKursnuListu()
{
	$('#EURK').html(GetKupovniKurs(localStorage.getItem("EUR")));
	$('#EURS').html(GetSrednjiKurs(localStorage.getItem("EUR")));
	$('#EURP').html(GetProdajniKurs(localStorage.getItem("EUR")));
	
	$('#USDK').html(GetKupovniKurs(localStorage.getItem("USD")));
	$('#USDS').html(GetSrednjiKurs(localStorage.getItem("USD")));
	$('#USDP').html(GetProdajniKurs(localStorage.getItem("USD")));
	
	$('#CHFK').html(GetKupovniKurs(localStorage.getItem("CHF")));
	$('#CHFS').html(GetSrednjiKurs(localStorage.getItem("CHF")));
	$('#CHFP').html(GetProdajniKurs(localStorage.getItem("CHF")));
	
	$('#GBPK').html(GetKupovniKurs(localStorage.getItem("GBP")));
	$('#GBPS').html(GetSrednjiKurs(localStorage.getItem("GBP")));
	$('#GBPP').html(GetProdajniKurs(localStorage.getItem("GBP")));
	
	$('#AUDK').html(GetKupovniKurs(localStorage.getItem("AUD")));
	$('#AUDS').html(GetSrednjiKurs(localStorage.getItem("AUD")));
	$('#AUDP').html(GetProdajniKurs(localStorage.getItem("AUD")));
	
	$('#CADK').html(GetKupovniKurs(localStorage.getItem("CAD")));
	$('#CADS').html(GetSrednjiKurs(localStorage.getItem("CAD")));
	$('#CADP').html(GetProdajniKurs(localStorage.getItem("CAD")));
	
	$('#SEKK').html(GetKupovniKurs(localStorage.getItem("SEK")));
	$('#SEKS').html(GetSrednjiKurs(localStorage.getItem("SEK")));
	$('#SEKP').html(GetProdajniKurs(localStorage.getItem("SEK")));
	
	$('#DKKK').html(GetKupovniKurs(localStorage.getItem("DKK")));
	$('#DKKS').html(GetSrednjiKurs(localStorage.getItem("DKK")));
	$('#DKKP').html(GetProdajniKurs(localStorage.getItem("DKK")));
	
	$('#NOKK').html(GetKupovniKurs(localStorage.getItem("NOK")));
	$('#NOKS').html(GetSrednjiKurs(localStorage.getItem("NOK")));
	$('#NOKP').html(GetProdajniKurs(localStorage.getItem("NOK")));
	
	$('#JPYK').html(GetKupovniKurs(localStorage.getItem("JPY")));
	$('#JPYS').html(GetSrednjiKurs(localStorage.getItem("JPY")));
	$('#JPYP').html(GetProdajniKurs(localStorage.getItem("JPY")));
}

function Convert(valuta1,valuta2,vrednost1)
{
	
	
	if(valuta1 == valuta2)
		return vrednost1;
		
	if(valuta1 == "RSD")
	{
		$kurs = GetProdajniKurs(localStorage.getItem(valuta2));
		if(vrednost1.indexOf(",") != -1)
			vrednost1 = vrednost1.replace(",",".");
			
		$kurs = $kurs.replace(",",".");
		
		kolicina = GetKolicinuValute(localStorage.getItem(valuta2));
		
		$kurs = $kurs / kolicina;
		
		$res = parseFloat(vrednost1)/parseFloat($kurs);
		$res = parseFloat($res).toFixed(4);
		$res = $res.replace(".",",");
		return $res;
	}
	
	if(valuta2 == "RSD")
	{
		$kurs = GetKupovniKurs(localStorage.getItem(valuta1));
		if(vrednost1.indexOf(",") != -1)
			vrednost1 = vrednost1.replace(",",".");
			
		$kurs = $kurs.replace(",",".");
		
		kolicina = GetKolicinuValute(localStorage.getItem(valuta1));
		
		$kurs = $kurs / kolicina;
		
		$res = parseFloat(vrednost1)*parseFloat($kurs);
		$res = parseFloat($res).toFixed(4);
		$res = $res.replace(".",",");
		return $res;
	}
	
	if(valuta1 != "RSD" && valuta2 != "RSD")
	{
		$kurs = GetKupovniKurs(localStorage.getItem(valuta1));
		if(vrednost1.indexOf(",") != -1)
			vrednost1 = vrednost1.replace(",",".");
		$kurs = $kurs.replace(",",".");
		$res = parseFloat(vrednost1)*parseFloat($kurs);
		$res = parseFloat($res).toFixed(4);
		
		$kurs = GetProdajniKurs(localStorage.getItem(valuta2));
		if(vrednost1.indexOf(",") != -1)
			vrednost1 = vrednost1.replace(",",".");
		$kurs = $kurs.replace(",",".");
		$res = parseFloat($res)/parseFloat($kurs);
		$res = parseFloat($res).toFixed(4);
		
		$res = $res.replace(".",",");
		return $res;
	}
	return "0,0000";
}