var SCREEN_STATE_TITLE = 0;
var SCREEN_STATE_TYPES_LIST = 1;
var SCREEN_STATE_RIDDLES_LIST = 2;
var SCREEN_STATE_RIDDLE = 3;
var NUMERIC_ANSWER = 0;
var TEXT_ANSWER = 1;
var TEXT_EXACT_ANSWER = 2;
var TEXT_MULTIPLE_ANSWER = 3;
var NUMERIC_MULTIPLE_ANSWER = 4;
var TYPES_LIST = ['Facile', 'Normal', 'Difficile', 'Devinettes', 'Idées reçues', 'Igor le sage', 'Les animaux', 'Dingbats'];

var STR_APP = 'La cave aux énigmes';
var STR_PLAY = 'JOUER';
var STR_SOLUTION = 'Solution';
var STR_HINT = 'Astuce';
var STR_ANSWER_LABEL = 'Réponse';
var STR_ANSWER_ACTION = 'Répondre';
var STR_CONGRATULATIONS = 'Félications';
var STR_BAD_ANSWER = 'Ce n\'est pas la réponse attendue. Essayez de reformuler si vous pensez avoir la bonne.';

var screenState = -1;
var currentType = -1;
var currentRiddle = -1;
var riddlesList = new Array();

$(function(){
	for (var i = 0; i < TYPES_LIST.length; ++i)
		riddlesList.push(new Array());
		
	init();
	var debug = false;
	if (debug)
	{
		var event = new EventData();
		currentType = 0;
		event.data.riddle = 0;
		showRiddle(event);
	}
	else
		showTitlePage();
});

function init()
{
	$.mobile.loading('show');
	var parser = new DOMParser();
	var xmlDoc = parser.parseFromString(xmlData, "text/xml");
	var nodes = xmlDoc.childNodes[0];
	for (var i = 0; i < nodes.childElementCount; ++i)
	{
		var riddle = new Riddle();
		riddle.answer = nodes.childNodes[i].attributes[0].nodeValue;
		riddle.answerType = parseInt(nodes.childNodes[i].attributes[1].nodeValue);
		if (nodes.childNodes[i].attributes[2].nodeValue != null)
			riddle.copyright = nodes.childNodes[i].attributes[2].nodeValue;
		if (nodes.childNodes[i].attributes[3].nodeValue != null)
			riddle.hint = nodes.childNodes[i].attributes[3].nodeValue;
		if (nodes.childNodes[i].attributes[4].nodeValue != null)
			riddle.image = nodes.childNodes[i].attributes[4].nodeValue;
		if (nodes.childNodes[i].attributes[5].nodeValue != null)
			riddle.solution = nodes.childNodes[i].attributes[5].nodeValue;
		riddle.text = nodes.childNodes[i].attributes[6].nodeValue;
		riddle.title = nodes.childNodes[i].attributes[7].nodeValue;
		riddle.type = nodes.childNodes[i].attributes[8].nodeValue;

		if (localStorage.getItem('t'+riddle.type+'r'+riddlesList[riddle.type].length) != null)
			riddle.solved = true;

		riddlesList[riddle.type].push(riddle);
	}
	$.mobile.loading('hide');
}

function showTitlePage()
{
	screenState = SCREEN_STATE_TITLE;
	removeContent();

	$('#content').append($('<img>').attr('src', 'images/icon.png').attr('id', 'title-icon'));
	$('#content').append($('<button>').append(STR_PLAY).click(function(){
		showTypesList();
		})).trigger('create');
	$('#content').append($('<table>').attr('id', 'logos-table').append($('<tr>').attr('id', 'logos-row')));
	$('#logos-row').append($('<td>').append(
		$('<a>').attr('href', 'http://www.facebook.com/group.php?gid=149401211752604')
				.attr('target', '_blank').append(
			$('<img>').attr('src', 'images/logo_facebook.png')
		)
	));
	$('#logos-row').append($('<td>').append(
		$('<a>').attr('href', 'http://twitter.com/caveauxenigmes')
				.attr('target', '_blank').append(
			$('<img>').attr('src', 'images/logo_twitter.png')
		)
	));
	$('#logos-row').append($('<td>').append(
		$('<a>').attr('href', 'mailto:lacaveauxenigmes@gmail.com').append(
			$('<img>').attr('src', 'images/logo_gmail.png')
		)
	));
}

function showTypesList()
{
	screenState = SCREEN_STATE_TYPES_LIST;
	removeContent();
	addBackButton();
	
	$('#content').append($('<ul>')
					.attr('id', 'typeslist')
					.attr('data-role', 'listview')
					.attr('data-inset', 'true'));
	for (var i = 0; i < TYPES_LIST.length; ++i)
	{
		$('#typeslist').append($('<li>').append($('<a>')
			.click({type: i}, function(e) { showRiddlesList(e) })
			.append(TYPES_LIST[i])).append(
			$('<span>').attr('class', 'ui-li-count').append(riddlesList[i].length)));
	}
	$('#typeslist').listview();
}

function showRiddlesList(eventData)
{
	currentType = eventData.data.type;
	screenState = SCREEN_STATE_RIDDLES_LIST;
	removeContent();
	addBackButton();
	
	$('#content').append($('<ul>')
					.attr('id', 'riddleslist')
					.attr('data-role', 'listview')
					.attr('data-inset', 'true')
					.attr('data-filter', 'true'));
	for (var i = 0; i < riddlesList[currentType].length; ++i)
	{
		var li = $('<li>').append(
					$('<a>')
						.click({riddle: i}, function(e) { showRiddle(e) })
						.append(riddlesList[currentType][i].title));
		if (riddlesList[currentType][i].solved)
			li.attr('data-icon', 'star');
		else
			li.attr('data-icon', 'minus');
		$('#riddleslist').append(li);
	}
	$('#riddleslist').listview();
}

function showRiddle(eventData)
{
	currentRiddle = eventData.data.riddle;
	screenState = SCREEN_STATE_RIDDLE;
	removeContent();
	addBackButton();
	addRiddleButtons();
	
	var riddle = riddlesList[currentType][currentRiddle];
	
	// Title
	$('#content').append($('<h2>').append(riddle.title));
	$('#content').append($('<p>').append(riddle.text));
	if (riddle.image != '')
	{
		var imgUrl = 'images/riddles/'+riddle.image;
		if (riddle.image.indexOf("db_") == 0)
			imgUrl += '.jpg';
		else
			imgUrl += '.png';
		
		$('#content').append($('<div>').attr('data-role', 'picture').append(
			$('<img>').attr('src', imgUrl)));
	}
	$('#content').append($('<label>').attr('for', 'answer').append(STR_ANSWER_LABEL));
	$('#content').append($('<input>').attr('type', 'text').attr('name', 'answer'));
	$('#content').append($('<button>').append(STR_ANSWER_ACTION).click(function(){
		validAnswer();
		})).trigger('create');
}

function validAnswer()
{
	if (testAnswer($('input[name=answer]').val()))
	{
		showDialog(STR_CONGRATULATIONS, riddlesList[currentType][currentRiddle].solution);
		riddlesList[currentType][currentRiddle].solved = true;
		localStorage.setItem('t'+currentType+'r'+currentRiddle, true);
	}
	else
		showDialog(STR_APP, STR_BAD_ANSWER);
}

function testAnswer(answer)
{
	var ret = false;
	var testWords;
	var riddle = riddlesList[currentType][currentRiddle];

	switch (riddle.answerType)
	{
		case NUMERIC_ANSWER:
			if (parseInt(answer) == parseInt(riddle.answer))
				ret = true;
			break;
		case NUMERIC_MULTIPLE_ANSWER:
			testWords = riddle.answer.split('|');
			for (var i = 0; i < testWords.length; ++i)
				if (parseInt(answer) == parseInt(testWords[i]))
					ret = true;
			break;
		case TEXT_ANSWER:
			answer = removeSpecialChars(answer);
			if (answer.indexOf(riddle.answer) != -1)
				ret = true;
			break;
		case TEXT_EXACT_ANSWER:
			answer = removeSpecialChars(answer);
			if (answer == riddle.answer)
				ret = true;
			break;
		case TEXT_MULTIPLE_ANSWER:
			answer = removeSpecialChars(answer);
			testWords = riddle.answer.split('|');
			for (var i = 0; i < testWords.length; ++i)
				if (answer.indexOf(testWords[i]) != -1)
					ret = true;
			break;
	}
	return ret;
}

function removeSpecialChars(str)
{
	var ret = str.toLowerCase();
	ret = ret.replace('à', 'a');
	ret = ret.replace('â', 'a');
	ret = ret.replace('ä', 'a');
	ret = ret.replace('ç', 'c');
	ret = ret.replace('é', 'e');
	ret = ret.replace('è', 'e');
	ret = ret.replace('ê', 'e');
	ret = ret.replace('ë', 'e');
	ret = ret.replace('ï', 'i');
	ret = ret.replace('î', 'i');
	ret = ret.replace('ô', 'o');
	ret = ret.replace('ö', 'o');
	ret = ret.replace('ù', 'u');
	ret = ret.replace('û', 'u');
	ret = ret.replace('ü', 'u');
	ret = ret.replace("æ", "ae");
	ret = ret.replace("œ", "oe");
	return ret;
}

function addBackButton()
{
	$('#header-left-btn').append(
		$('<a>')
			.attr('data-role', 'button')
			.attr('data-icon', 'arrow-l')
			.append("Retour")
			.click(function()
			{
				var e = new EventData();
				e.data.riddle = currentRiddle;
				e.data.type = currentType;
				
				switch (screenState)
				{
				case SCREEN_STATE_RIDDLE:
					e.data.riddle = -1;
					showRiddlesList(e);
					break;
				case SCREEN_STATE_RIDDLES_LIST:
					e.data.type = -1;
					showTypesList(e);
					break;
				case SCREEN_STATE_TYPES_LIST:
					showTitlePage();
					break;
				}
			}))
	.trigger('create');
}

function addRiddleButtons()
{
	var riddle = riddlesList[currentType][currentRiddle];
	
	$('#header-right-btn').append(
		$('<a>')
			.attr('data-role', 'button')
			.attr('data-inline', 'true')
			.attr('data-icon', 'info')
			.attr('data-rel', 'dialog')
			.append(STR_HINT)
			.click(function(){
				showDialog(STR_HINT, riddle.hint);
			})
	).trigger('create');
	$('#header-right-btn').append(
		$('<a>')
			.attr('data-role', 'button')
			.attr('data-inline', 'true')
			.attr('data-icon', 'search')
			.attr('data-rel', 'dialog')
			.append('Réponse')
			.click(function(){
				showDialog(STR_SOLUTION, riddle.solution);
			})
	).trigger('create');
}

function showDialog(title, content)
{
	$('#dialog-title').empty().append(title);
	$('#dialog-content').empty().append(content);
	var dlg = $('#dialog');
	dlg.appendTo($.mobile.pageContainer);
	$.mobile.changePage(dlg, {role: 'dialog'});
}

function removeContent()
{
	$('#content').empty();
	$('#header-left-btn').empty();
	$('#header-right-btn').empty();
}

function Riddle()
{
	this.title = "";
	this.text = "";
	this.type = -1;
	this.answerType = -1;
	this.answer = "";
	this.solution = "";
	this.hint = "";
	this.image = "";
	this.solved = false;
}

function EventData()
{
	this.data = new Data();
	
	function Data()
	{
		this.type = -1;
		this.riddle = -1;
	}
}

var inmobi_conf = {
	siteid : "4028cbff36f39ce201374d2dc7653143",
	slot : "15",
	test:false
};

(function(){if(!window._inmobi){var z="http://i.w.inmobi.com/showad",b="http://i.w.inmobi.com/showad",E="pr-JSAC-CTBTD-20130308",h=function(){var H="",F="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",G;for(G=0;G<6;G++){H+=F.charAt(Math.floor(Math.random()*F.length))}return H},n=function(){return D+h()},x={siteid:"mk-siteid",slot:"mk-ad-slot",age:"u-age",gender:"u-gender",location:"u-location",interests:"u-interests",postalCode:"u-postalCode",areaCode:"u-areaCode",dateOfBirth:"u-dateOfBirth",income:"u-income",latlong:"u-latlong-accu",education:"u-education",ethnicity:"u-ethnicity",adtype:"adtype",targetWindow:"targetWindow",testdeviceid:"d_tdid"},w={"1":{width:120,height:20},"2":{width:168,height:28},"3":{width:216,height:36},"4":{width:300,height:50},"9":{width:320,height:48},"10":{width:300,height:250},"11":{width:728,height:90},"12":{width:468,height:60},"13":{width:120,height:600},"14":{width:320,height:480},"15":{width:320,height:50},"16":{width:768,height:1024},"17":{width:800,height:1280}},r=["slot","siteid"],D="inmobi-iframe-",B="",j=[],l=function(F){for(var G in j){if(j[G].iFrameRef===F){return j[G]}}return null},f=function(G){for(var F in j){if(j[F].iFrameRef.parentNode.parentNode==G){return j[F]}}return null},a=function(F){if(typeof(F)=="object"){return F}if(JSON){return JSON.parse(F)}else{return _inmobi.globalEval("("+F+")")}},C=function(F){return w[""+F.config.slot]},v=function(I){var H,F,G=I.config;if(G===null){throw"Expected config object, got null, make sure inmobi_conf variable is set for each ad slot."}if(typeof G!=="object"){throw"Expected config object, got "+(typeof G)+" make sure inmobi_conf variable is set for each ad slot."}for(H=0;H<r.length;H++){F=r[H];if(!G.hasOwnProperty(F)||G[F]===null||G[F].length===0){throw"inmobi.js: ERROR: missing required config parameter '"+F+"'"}}if(!w[""+G.slot]){throw"inmobi.js: ERROR: inmobi_vars config slot param, '"+G.slot+"', is not a valid slot number."}},y=function(H){var I=[],F,G=H.config;for(F in G){if(x.hasOwnProperty(F)){I.push(encodeURIComponent(x[F])+"="+encodeURIComponent(G[F]))}}I.push("mk-ads=1");I.push("mk-version="+encodeURIComponent(E));I.push("format=html");I.push("__t="+(new Date()).getTime()+"-"+h());return I.join("&")},t=function(F){var G=F.config.test?b:z;return G+(G.indexOf("?")===-1?"?":"&")+y(F)},m=function(I,H){if(typeof H=="object"&&H!=null){I.config=H}if(typeof I.config=="undefined"&&typeof inmobi_conf=="object"){I.config=inmobi_conf}var K,F,G;console.log("load new ad called");window.clearTimeout(I.refresh);if(typeof(I.config)=="object"&&typeof(I.config.autoRefresh)!="undefined"){F=I.config.autoRefresh-0;if(!isNaN(F)){if(F<20){console.log("Minimum refresh interval is 20")}else{I.refresh=window.setTimeout(function(L){L.getNewAd()},F*1000,I)}}else{console.log("Refresh interval is invalid")}}try{if(!window.navigator.onLine){return}}catch(J){}if(I.adData.state=="expanded"||(I.adData.state=="loading"&&typeof(I.config.adtype)!="undefined"&&I.config.adtype=="int")){return}try{K=I.iFrame.parentNode.getElementsByClassName("inmobi-rm")[0];if(K){K.parentNode.removeChild(K)}}catch(J){}v(I);G=C(I);if(!I.iFrameRef){I.iFrameRef=document.createElement("iframe");I.iFrameRef.style.border="none";I.iFrameRef.style.overflow="hidden";I.iFrameRef.id=_inmobi.generateIframeId();I.iFrameRef.setAttribute("class","inmobi-ad");I.iFrameRef.setAttribute("scrolling","no")}else{I.iFrameRef.style.width=G.width+"px";I.iFrameRef.style.height=G.height+"px"}I.iFrameRef.src=t(I)+"&iframe="+I.iFrameRef.id;I.iFrameRef.style.display="block";I.iFrameRef.style.width=I.iFrameRef.parentNode.style.width=G.width+"px";I.iFrameRef.style.height=I.iFrameRef.parentNode.style.height=G.height+"px";return I},p=function(H,G){var I=H.iFrameRef.parentNode.getElementsByClassName("inmobi-rm")[0],F=H.iFrameRef.id.replace(/iframe/,"div");if(!I){I=H.iFrameRef.parentNode.insertBefore(document.createElement("div"),H.iFrameRef);I.id=F;I.className="inmobi-rm"}I.innerHTML=G.html;scripts=I.getElementsByTagName("script");for(i=0;i<scripts.length;i++){script=scripts[i];if(script.src){newScript=I.ownerDocument.createElement("script");newScript.src=script.src;if(script.parentNode){script.parentNode.replaceChild(newScript,script)}}else{_inmobi.globalEval(script.textContent)}}I.style.width=G.width+"px";I.style.height=G.height+"px";H.iFrameRef.style.display="none"},q=function(M,K){var L=M.adData,G=K.url,J=K.expandProperties,H,N,I=M.config,F=M.iFrameRef;if(L.state=="expanded"){M.postToContainer("fireEvent",{event:"error",eventData:"Can expanded when in expanded state."});return}if(typeof(G)!="undefined"&&G!=null&&G!=""){F.src=G}if(typeof(J.width)=="undefined"){J.width=0}if(typeof(J.height)=="undefined"){J.height=0}if(typeof(J.useCustomClose)=="undefined"){J.useCustomClose=false}if(typeof(J.isModal)=="undefined"){J.isModal=false}if(isNaN(parseInt(J.width))){J.width=0}if(isNaN(parseInt(J.height))){J.height=0}if(J.width==0){J.width=window.innerWidth}if(J.height==0){J.height=window.innerHeight}if(J.width>0){F.parentNode.style.width=F.style.width=J.width+"px"}if(J.height>0){F.parentNode.style.height=F.style.height=J.height+"px"}if(!J.useCustomClose){H=document.createElement("div");H.setAttribute("class","inmobi-close-button");N=(parseInt(F.style.width)-50);N=(N>0?N:0)+"px";H.setAttribute("style","position: absolute; margin-left:"+N+";");H.innerHTML="<img src='http://inmobi-sandbox.s3.amazonaws.com/image/close.png' width='50px' height='50px' onclick='window._inmobi.closeAd(window._inmobi.getAd(event.target.parentNode.parentNode.getElementsByTagName(\"iframe\")[0]));' />";F.parentNode.insertBefore(H,F.parentNode.firstChild)}if((typeof(I.adtype)=="undefined")||I.adtype!="int"){L.state="expanded";M.postToContainer("fireEvent",{event:"stateChange",eventData:"expanded"})}},e=function(G){var F=C(G);G.iFrameRef.parentNode.style.width=G.iFrameRef.style.width=F.width+"px";G.iFrameRef.parentNode.style.height=G.iFrameRef.style.height=F.height+"px"},c=function(F){k(F)},k=function(H){var I=H.iFrameRef.parentNode.getElementsByClassName("inmobi-close-button"),G=H.config,F=H.adData;if(I.length>0){I[0].parentNode.removeChild(I[0])}if((typeof(G.adtype)=="undefined")||G.adtype!="int"){if(F.state!="expanded"){H.postToContainer("fireEvent",{event:"error",eventData:"Can't close a non-expanded ad."});return}e(H);F.state="default";H.postToContainer("fireEvent",{event:"stateChange",eventData:"default"})}else{F.state="init";H.iFrameRef.parentNode.style.height=H.iFrameRef.style.height="0px";H.iFrameRef.src="";_inmobi.dispatchEvent("close",{container:H.iFrameRef.parentNode})}},o=function(F,G){return{iFrameRef:F,config:G,adData:{state:"init"},refresh:null,getNewAd:function(H){return m(this,H)},postToContainer:function(I,H){this.iFrameRef.contentWindow.postMessage({action:I,data:H,inmobiMessage:true},"*")}}},g=function(H){var F,I,G=null;for(F=0;F<j.length;F++){if(j[F].iFrameRef.contentWindow===H.source){G=j[F]}}if(G!=null){I=a(H.data);if(I.action!=undefined){B=I.action}switch(I.topic){case"showAdInParent":p(G,I.ad);break;case"nfr":if(typeof G.config.onError=="function"){G.config.onError("nfr")}break}switch(I.action){case"error":if(typeof G.config.onError=="function"){G.config.onError(I.data.message)}break;case"collapse":c(G);break;case"close":c(G);break;case"expand":q(G,I.data);break;case"log":console.log(I.data);break}}},A=function(F){var G="";if(typeof(F)!="undefined"&&typeof(F.sticky)!="undefined"){switch(F.sticky){case"top":case"left":G="top:0px;left:0px;";break;case"right":G="top:0px;right:0px;";break;case"bottom":G="bottom:0px;left:0px;";break}}if(G==""){return""}return"position:fixed;"+G},d=function(F){console.log(F);var I=n(),J="",H,G;J=A(F);document.write('<div style="display:inline-block;'+J+'"><iframe scrolling="no" class="inmobi-ad" id="'+I+'" style="border:none;overflow:hidden;"></iframe></div>');H=document.getElementById(I);G=o(H,F);u(G,F)},s=function(F){var I=n(),J="",H,G;J=A(F);H=document.createElement("iframe"),div=document.createElement("div");div.setAttribute("style","display:inline-block;"+J);H.setAttribute("scrolling","no");H.setAttribute("class","inmobi-ad");H.setAttribute("id",I);H.setAttribute("style","border:none;overflow:hidden;");div.appendChild(H);G=o(H,F);u(G,F);return div},u=function(G,F){G.iFrameRef.width=G.iFrameRef.style.width="0px";G.iFrameRef.height=G.iFrameRef.style.height="0px";G.iFrameRef.style.backgroundColor="white";j.push(G);if(!(typeof(F)!="undefined"&&typeof(F.manual)!="undefined"&&F.manual)){G.getNewAd()}if(typeof F.onLoad=="function"){iframe.addEventListener("load",function(H){F.onLoad(H)},false)}};window._inmobi={events:["close"],listeners:{},getNewAd:function(H,F){var G=f(H);if(G==null){try{if(typeof F!="object"){F=window.inmobi_conf}delete window.inmobi_conf.manual;H.appendChild(s(F))}catch(I){console.log("IM: Something went wrong. Please check integration. Error: "+I)}}else{if(typeof G=="object"){G.getNewAd(F)}}},getAd:function(G,F){return l(G)},closeAd:function(F){k(F)},addEventListener:function(F,G){if(this.events.indexOf(F)==-1){throw"inmobi.js: ERROR: Unknown event type '"+F+"'"}if(!this.listeners[F]){this.listeners[F]=[]}this.listeners[F].push(G)},dispatchEvent:function(H,F){var G;if(this.events.indexOf(H)==-1){throw"inmobi.js: ERROR: Unknown event type '"+H+"'"}if(!this.listeners[H]){return}for(G=0;G<this.listeners[H].length;G++){(this.listeners[H][G])(F)}},writeIframe:function(F){d(F)}};window.addEventListener("message",g,false)}if(typeof inmobi_conf=="undefined"){inmobi_conf={manual:true}}if(!inmobi_conf.manual){_inmobi.writeIframe(inmobi_conf)}})();(function(){if(!window._inmobi.globalEval){window._inmobi.globalEval=function(a){return eval(a)}}})();

var xmlData = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><riddleslist><riddle answer=\"rien\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Essayez de répondre à chaque question séparément.&lt;/p&gt;\" image=\"student\" solution=\"&lt;p&gt;Rien n'est mieux que Dieu,&lt;br/&gt;Rien n'est pire que le Diable,&lt;br/&gt;Les pauvres n'ont rien,&lt;br/&gt;Les riches ont besoin de rien,&lt;br/&gt;Et on meurt si on ne mange rien.&lt;/p&gt;\" text=\"&lt;p&gt;Cette énigme fut posée aux étudiants de l'université de Stanford lors d'une épreuve de réflexion.&lt;/p&gt;&lt;p&gt; - C'est mieux que Dieu.&lt;br/&gt; - C'est pire que le Diable.&lt;br/&gt; - Les pauvres en ont.&lt;br/&gt; - Les riches en ont besoin.&lt;br/&gt; - Et si on en mange, on meurt.&lt;/p&gt;&lt;p&gt;Qu'est ce que c'est ?&lt;/p&gt;&lt;p&gt;La version originale en anglais : &lt;i&gt;What is greater than God, More evil than the devil, The poor have it, The rich need it, And if you eat it, you'll die.&lt;/i&gt;&lt;/p&gt;\" title=\"L'énigme de Stanford\" type=\"0\"/><riddle answer=\"1\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Qu'est ce qu'un verre vide ?&lt;/p&gt;\" image=\"glass\" solution=\"&lt;p&gt;1.&lt;br/&gt;Lorsque l'on met une goutte d'eau dans un verre vide, celui-ci n'est plus vide.&lt;/p&gt;\" text=\"&lt;p&gt;Combien peut-on mettre de gouttes d'eau dans un verre vide ?&lt;/p&gt;\" title=\"Le verre d'eau\" type=\"0\"/><riddle answer=\"11\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Il prend 2 fois plus de place chaque jour.&lt;/p&gt;\" image=\"waterlily\" solution=\"&lt;p&gt;11 jours car il double de taille chaque jour, donc il prendra l'autre moitié du lac en une journée.&lt;/p&gt;\" text=\"&lt;p&gt;Un nénuphar se trouvant dans un lac double de taille chaque jour. Au bout de 10 jours, il couvre la moitié du lac.&lt;/p&gt;&lt;p&gt;Combien de jours lui aura-t-il fallu en tout pour le recouvrir entièrement ?&lt;/p&gt;\" title=\"Le nénuphar géant\" type=\"0\"/><riddle answer=\"30\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;N'oubliez pas chaque décalage.&lt;/p&gt;\" image=\"grille\" solution=\"&lt;p&gt;Il y a 30 carrés dans cette image.&lt;br/&gt;&lt;br/&gt;16 carrés de 1x1,&lt;br/&gt;9 carrés de 2x2,&lt;br/&gt;4 carrés de 3x3,&lt;br/&gt;1 carré de 4x4.&lt;br/&gt;&lt;br/&gt;Soit 30 carrés.&lt;/p&gt;\" text=\"&lt;p&gt;Combien y a t-il de carrés dans cette figure ?&lt;/p&gt;\" title=\"Les carrés\" type=\"0\"/><riddle answer=\"60\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Au bout de combien de temps prendrez vous la première gélule ?&lt;/p&gt;\" image=\"doctor\" solution=\"&lt;p&gt;La première gélule se prend instantanément, le traitement commence.&lt;br/&gt;La deuxième se prend 30 minutes après la première.&lt;br/&gt;La troisième se prend 60 minutes après la première.&lt;br/&gt;&lt;br/&gt;Le traitement a donc durée 60 minutes.&lt;/p&gt;\" text=\"&lt;p&gt;Votre médecin vous a donné un traitement de trois gélules. Il faut en prendre une toutes les demi-heures.&lt;/p&gt;&lt;p&gt;Quelle est la durée du traitement (en minutes) ?&lt;/p&gt;\" title=\"La prescription\" type=\"0\"/><riddle answer=\"33\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Quel sera l'âge maximum de l'enfant ?&lt;/p&gt;\" image=\"father\" solution=\"&lt;p&gt;Le père a 33 ans.&lt;/p&gt;&lt;p&gt;Soit x l'âge du père, y l'âge du fils.&lt;/p&gt;&lt;p&gt;x + y = 36&lt;/p&gt;&lt;p&gt;y + 30 = x&lt;/p&gt;&lt;p&gt;On a donc&lt;/p&gt;&lt;p&gt;y + 30 + y = 36&lt;/p&gt;&lt;p&gt;2y = 6&lt;/p&gt;&lt;p&gt;y = 3&lt;/p&gt;&lt;p&gt;Donc x = 33.&lt;/p&gt;&lt;p&gt;&lt;/p&gt;&lt;p&gt;Le fils ne peut avoir 6 ans et le père 30 ans car 30 - 6 = 24 ans de différence.&lt;/p&gt;\" text=\"&lt;p&gt;Un père a 30 ans de plus que son fils. Le père et le fils ont à eux deux 36 ans.&lt;/p&gt;&lt;p&gt;Quel est l'âge du père ?&lt;/p&gt;\" title=\"Le père et le fils\" type=\"0\"/><riddle answer=\"35\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Comptez les différents types de triangles.&lt;/p&gt;\" image=\"etoile\" solution=\"&lt;p&gt;Il y a 7 triangles différents répétés 5 fois tous les 72°. Donc 35.&lt;/p&gt;\" text=\"&lt;p&gt;Combien y a-t-il de triangles dans cette figure ?&lt;/p&gt;\" title=\"L'étoile\" type=\"0\"/><riddle answer=\"14\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Chaque cigarette fumée fournit un mégot.&lt;/p&gt;\" image=\"smoking\" solution=\"&lt;p&gt;10 cigarettes donnent 10 mégots.&lt;br/&gt;10 mégots donnent 3 cigarettes et 1 mégot.&lt;br/&gt;Il fume ces 3 cigarettes, il lui reste 4 mégots.&lt;br/&gt;Il en produit une dernière et il lui reste 2 mégots.&lt;br/&gt;&lt;br/&gt;Il a donc fumé 14 cigarettes.&lt;br/&gt;&lt;br/&gt;S'il pouvait emprunter une cigarette, il pourrait la fumer puis la rendre.&lt;/p&gt;\" text=\"&lt;p&gt;Sachant que l'on a besoin de 3 mégots (reste de cigarette) pour faire 1 cigarette, combien peut-on fumer de cigarettes en ayant 10 cigarettes au début ?&lt;/p&gt;\" title=\"Le fumeur chevronné\" type=\"0\"/><riddle answer=\"a\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Le temps passe pendant cette suite.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Janvier - Février - Mars - Avril - Mai - Juin - Juillet - Août.&lt;br/&gt;A&lt;/p&gt;\" text=\"&lt;p&gt;Quelle est la lettre suivante de cette suite : &lt;/p&gt;&lt;p&gt;J - F - M - A - M - J - J - ?&lt;/p&gt;\" title=\"La lettre suivante\" type=\"0\"/><riddle answer=\"3\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Combien en faudra-t-il au minimum ?&lt;/p&gt;\" image=\"duck\" solution=\"&lt;p&gt;3 canards suffisent à vérifier cette phrase.&lt;/p&gt;\" text=\"&lt;p&gt;Deux canards se trouvent devant un canard, deux canards se trouvent derrière un canard et un canard est au milieu.&lt;/p&gt;&lt;p&gt;Combien y a-t-il de canards au minimum ?&lt;/p&gt;\" title=\"Les canards\" type=\"0\"/><riddle answer=\"3\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;De combien de chaussettes est composée une paire de chaussette ?&lt;/p&gt;\" image=\"socks\" solution=\"&lt;p&gt;En prenant 3, nous aurons soit 2 rouges et 1 verte, soit 1 rouge et 2 vertes, soit 3 vertes, soit 3 rouges.&lt;br/&gt;&lt;br/&gt;Vous aurez donc bien une paire de la même couleur.&lt;/p&gt;\" text=\"&lt;p&gt;Dans un tiroir se trouvent 24 chaussettes rouges et 24 chaussettes vertes. La pièce étant plongée dans le noir, combien faudra-t-il prendre de chaussettes au minimum pour être sûr d'avoir une paire de la même couleur ?&lt;/p&gt;\" title=\"Les chaussettes\" type=\"0\"/><riddle answer=\"95\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Attention à la proportionnalité.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il y aura toujours un écart de 5 ans entre eux, donc David aura 100 ans et Franck 95 ans.&lt;/p&gt;\" text=\"&lt;p&gt;David a 10 ans, son petit frère Franck a la moitié de son âge. Quand David sera 10 fois plus âgé, quel âge aura Franck ?&lt;/p&gt;\" title=\"Le petit frère\" type=\"0\"/><riddle answer=\"100\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Que représente la moitié de sa longueur ?&lt;/p&gt;\" image=\"dragon\" solution=\"&lt;p&gt;Le dragon fait 100 mètres.&lt;br/&gt;&lt;br/&gt;50 mètres plus la moitié de sa longueur.&lt;br/&gt; &lt;br/&gt;Il fait donc plus de 50 mètres.&lt;br/&gt;Qu'elle est la moitié de sa longueur ?&lt;br/&gt; &lt;br/&gt;Si sa longueur totale faisait 75 mètres, alors la moitié de sa longueur vaut 37,5 mètres. Donc 50 + 37,5 = 87,5&lt;br/&gt; &lt;br/&gt;Donc la phrase devient fausse.&lt;br/&gt; &lt;br/&gt;Il faut bien prendre 100 mètres&lt;br/&gt; &lt;br/&gt;Sinon la preuve mathématique : &lt;br/&gt; &lt;br/&gt;y = 50 + y / 2&lt;br/&gt;y - y/2 = 50&lt;br/&gt;y/2 = 50&lt;br/&gt;y = 100&lt;/p&gt;&lt;p&gt;Une autre explication : 50 mètres plus la moitié de sa longueur. Comme le total vaut une moitié plus une moitié, '50 mètres' est donc l'autre moitié, soit 100 mètres au total.&lt;/p&gt;\" text=\"&lt;p&gt;Un dragon a été vu dans le ciel et un des témoins a déclaré qu'il mesurait 50 mètres plus la moitié de sa longueur. Quelle est la longueur totale du dragon ? (en mètres)&lt;/p&gt;\" title=\"Le dragon\" type=\"0\"/><riddle answer=\"7\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;L'écart entre les deux groupes peut être trouvé grâce à la deuxième affirmation.&lt;/p&gt;\" image=\"bird\" solution=\"&lt;p&gt;Il y a 7 oiseaux en haut et 5 en bas.&lt;/p&gt;\" text=\"&lt;p&gt;Sur un arbre ayant 2 branches, des oiseaux se parlent, l'un d'en haut dit à ceux d'en bas : &lt;/p&gt;&lt;p&gt;&lt;i&gt;&quot;Si un de vous nous rejoint, nous serons alors 2 fois plus que vous, par contre si un de nous descend, nous serons alors à égalité.&quot;&lt;/i&gt;&lt;/p&gt;&lt;p&gt;Sachant qu'il y a un nombre impair d'oiseaux sur chaque branche, combien y en a-t-il sur la branche du haut ?&lt;/p&gt;\" title=\"Les oiseaux\" type=\"0\"/><riddle answer=\"3\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Attention! Il faut bien lire.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La moitié de 2 = 1&lt;br/&gt;1 + 2 = 3&lt;/p&gt;\" text=\"&lt;p&gt;Quel est le résultat de la moitié de 2, plus 2 ?&lt;/p&gt;\" title=\"L'addition\" type=\"0\"/><riddle answer=\"99\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Combien de joueurs seront éliminés ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;99 joueurs sont éliminés donc il y aura 99 matchs joués.&lt;/p&gt;\" text=\"&lt;p&gt;Un tournoi de tennis en simple est organisé avec 100 participants. Il se déroule en élimination directe (Si le nombre de joueurs est impair, le joueur est qualifié automatiquement). Combien de matchs seront joués pour désigner le gagnant ?&lt;/p&gt;\" title=\"Le tournoi\" type=\"0\"/><riddle answer=\"9\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Vous n'êtes pas obligé de les laisser sur le grill.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;1. On fait cuire 2 faces de 2 steaks (3 minutes).&lt;br/&gt;2. On en retourne un, on met l'autre de côté pour mettre le 3e (3 minutes).&lt;br/&gt;3. On enlève celui qui est cuit, on retourne le 3e et on remet le 2e (3 minutes).&lt;br/&gt;&lt;br/&gt;Il faudra donc 9 minutes.&lt;/p&gt;\" text=\"&lt;p&gt;Dans un restaurant, une commande est passée pour 3 steaks mais le gril ne peut en cuire que 2 à la fois.&lt;/p&gt;&lt;p&gt;Sachant qu'il faut 3 minutes de cuisson par face, quel sera (en minutes) le temps minimum pour la cuisson des 3 steaks ?&lt;/p&gt;\" title=\"Les steaks\" type=\"0\"/><riddle answer=\"5\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;L'un fait descendre l'autre.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Si Stéphanie donne 5€, elle aura 5€ de moins et Marie 5€ de plus soit une différence de 10€.&lt;/p&gt;\" text=\"&lt;p&gt;Stéphanie et Marie ont chacune la même somme d'argent.&lt;/p&gt;&lt;p&gt;Combien Stéphanie devra-t-elle donner à Marie pour que celle-ci ait 10€ de plus qu'elle ?&lt;/p&gt;\" title=\"Le don\" type=\"0\"/><riddle answer=\"20\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Attention aux oublis&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;9, 19, 29, 39, 49, 59, 69, 79, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99.&lt;br/&gt;&lt;br/&gt;Soit 20 fois, et non 19, le nombre 99 en contenant 2.&lt;/p&gt;\" text=\"&lt;p&gt;Combien de fois trouve-t-on le chiffre 9 dans la série de nombres entiers de 1 à 100 ?&lt;/p&gt;\" title=\"Le chiffre 9\" type=\"0\"/><riddle answer=\"20\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Regardez bien la différence.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il gagne 10€ à chaque transaction donc 20€.&lt;br/&gt;&lt;br/&gt;Exemple complet : Supposons que le libraire a 100€ de budget&lt;br/&gt;&lt;br/&gt;Il achète le livre 70€, il lui reste 30€.&lt;br/&gt;Il vend le livre 80€, il lui reste 110€.&lt;br/&gt;Il achète le livre 90€, il lui reste 20€.&lt;br/&gt;Il vend le livre 100€, il lui reste 120€.&lt;br/&gt;&lt;br/&gt;Il a fait 20€ de bénéfice.&lt;/p&gt;\" text=\"&lt;p&gt;Un libraire achète un livre 70€, le vend 80€, le rachète 90€ et le revend 100€.&lt;/p&gt;&lt;p&gt;Quel est son bénéfice (en euros) ?&lt;/p&gt;\" title=\"Le libraire\" type=\"0\"/><riddle answer=\"blanc\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Où sommes-nous ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;En effet, le braconnier se trouve au pôle nord, c'est pour ça qu'il tourne en rond.&lt;br/&gt;&lt;br/&gt;L'ours est blanc.&lt;/p&gt;\" text=\"&lt;p&gt;Un braconnier, quittant son campement, marche pendant cinq kilomètres en direction du sud. Arrivé là, il abat un ours d'un coup de fusil. Puis il repart vers l'ouest, fait trois kilomètres et s'aperçoit que la distance qui le sépare de son campement est la même qu'au moment où il a abattu l'ours.&lt;/p&gt;&lt;p&gt;Quelle est la couleur de l'ours?&lt;/p&gt;\" title=\"Faut pas manquer l'ours\" type=\"0\"/><riddle answer=\"45\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Attention à ne pas compter les parties en double.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Chaque joueur va faire 9 parties. Le premier aura 9 adversaires. Le deuxième 8 (sa partie avec le premier étant déjà comptée). Le troisième 7, etc.&lt;br/&gt;Il y aura donc 9+8+7+6+5+4+3+2+1 parties soit 45.&lt;/p&gt;\" text=\"&lt;p&gt;Lors d'un concours d'échecs, 10 joueurs ont fait une seule partie contre tous les autres (sauf eux-mêmes bien sûr). Combien de parties ont été jouées ?&lt;/p&gt;\" title=\"Le concours\" type=\"0\"/><riddle answer=\"0\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Quel est l'élément essentiel pour que l'on puisse voir un reflet dans un miroir ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il n'y a aucune ouverture et pas de lumière. La pièce est donc plongée dans le noir. Vous ne voyez donc aucun reflet.&lt;br/&gt;Donc 0.&lt;/p&gt;\" text=\"&lt;p&gt;Dans une pièce carrée, les murs, le plafond et le sol sont d'immenses miroirs.&lt;/p&gt;&lt;p&gt;La pièce est totalement vide.&lt;/p&gt;&lt;p&gt;Si vous êtiez dans cette pièce, combien de reflet(s) verriez-vous ?&lt;/p&gt;\" title=\"La pièce\" type=\"0\"/><riddle answer=\"1\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;C'est un jeu de mot.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;1 fois.&lt;br/&gt;La deuxième fois, ce sera de 30 que nous soustrairons 6.&lt;/p&gt;\" text=\"&lt;p&gt;Combien de fois peut-on soustraire 6 de 36 ?&lt;/p&gt;\" title=\"Combien de fois ?\" type=\"0\"/><riddle answer=\"2\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Essayez de poser le système d'équation.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Soit X le conteneur et Y le cargo&lt;br/&gt;X + Y = 62&lt;br/&gt;Y = 30 * X&lt;br/&gt;&lt;br/&gt;Donc le conteneur pèse 2 tonnes&lt;/p&gt;\" text=\"&lt;p&gt;Un cargo pèse 30 fois la masse d'un conteneur. Ils pèsent à eux deux 62 tonnes.&lt;/p&gt;&lt;p&gt;Quel est la masse du conteneur (en tonnes) ?&lt;/p&gt;\" title=\"Le cargo\" type=\"0\"/><riddle answer=\"0\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Pas facile de trouver le numéro de quelqu'un parfois.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les personnes sur liste rouge n'apparaissent pas dans l'annuaire.&lt;br/&gt;&lt;br/&gt;Donc 0.&lt;/p&gt;\" text=\"&lt;p&gt;Dans le village de Monpied le Vieux vivent 2000 personnes.&lt;/p&gt;&lt;p&gt;Tous les habitants ont le téléphone et 2% d'entre eux sont sur liste rouge.&lt;/p&gt;&lt;p&gt;En prenant 50 numéros de téléphone au hasard dans l'annuaire, quelle est la probabilité de tomber sur une personne en liste rouge ?&lt;/p&gt;\" title=\"Le téléphone\" type=\"0\"/><riddle answer=\"4\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;La queue du chat.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il y a un chat dans chaque coin qui est assis sur sa propre queue. Il y a donc 4 chats en tout.&lt;/p&gt;\" text=\"&lt;p&gt;Dans chaque coin d'une pièce carrée se trouve un chat assis. Devant chaque chat, il y a 3 chats, et sur la queue de chaque chat, il y a un chat.&lt;/p&gt;&lt;p&gt;Combien y a-t-il de chats dans la pièce ?&lt;/p&gt;\" title=\"Les chats\" type=\"0\"/><riddle answer=\"mine\" answer_type=\"1\" copyright=\"Proposée par Samy.\" hint=\"&lt;p&gt;Crayon.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une mine.&lt;/p&gt;\" text=\"&lt;p&gt;Je peux être d'or ou de charbon et les enfants m'utilisent à l'école.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Temporaire\" type=\"0\"/><riddle answer=\"cela\" answer_type=\"2\" copyright=\"\" hint=\"&lt;p&gt;Lisez bien.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;écrivez CELA.&lt;/p&gt;\" text=\"&lt;p&gt;Nabuchodonosor, roi de Babylone, écrivez cela en quatre lettres.&lt;/p&gt;\" title=\"Le grand roi\" type=\"0\"/><riddle answer=\"99\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Attention à bien respecter toutes les affirmations.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il y a forcément 99 membres de la mafia.&lt;br/&gt;S'ils étaient 98 ou moins, on pourrait tomber sur les 2 villageois honnêtes ce qui annulerait la dernière affirmation.&lt;/p&gt;\" text=\"&lt;p&gt;Dans un village rongé par la mafia, il y a 100 habitants. Parmi eux il y a au moins un honnête homme mais si on en prend deux au hasard, il y a toujours au moins un mafieux.&lt;/p&gt;&lt;p&gt;Combien y a-t-il de mafieux dans le village ?&lt;/p&gt;\" title=\"La mafia\" type=\"0\"/><riddle answer=\"99\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Attention au prix qui change.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La première remise descend le prix à 90€. Puis l'augmentation à 99€.&lt;/p&gt;\" text=\"&lt;p&gt;Un vendeur décide de baisser le prix d'un article à 100€ de 10%.&lt;br/&gt;Cependant les ventes ne sont pas bonnes et il est obligé d'augmenter ses prix de 10%&lt;/p&gt;&lt;p&gt;Finalement, quel est le prix (en €) de l'article ?&lt;/p&gt;\" title=\"Le vendeur\" type=\"0\"/><riddle answer=\"0\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Pas besoin de calculette.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il n'y a pas de cerises sur un pommier.&lt;/p&gt;\" text=\"&lt;p&gt;Un pommier a 9 branches principales.&lt;/p&gt;&lt;p&gt;Sur chaque branche principale se trouvent 9 branches importantes.&lt;br/&gt;Sur chaque branche importante se trouvent 9 grosses branches.&lt;br/&gt;Sur chaque grosse branche se trouvent 9 branches normales.&lt;br/&gt;Sur chaque branche normale se trouvent 9 petites branches.&lt;br/&gt;Sur chaque petite branche se trouvent 9 très petites branches.&lt;br/&gt;Sur chaque très petite branche se trouvent 9 minuscules branches.&lt;br/&gt;Sur chaque minuscule branche se trouvent 9 fruits.&lt;/p&gt;&lt;p&gt;Combien y a-t-il de cerises en tout ?&lt;/p&gt;\" title=\"Le pommier\" type=\"0\"/><riddle answer=\"mal\" answer_type=\"2\" copyright=\"\" hint=\"&lt;p&gt;Vous l'avez lu quelque part.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Mal se prononcera toujours mal.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot de trois lettres, les français prononcent-ils toujours mal ?&lt;/p&gt;\" title=\"Le petit mot\" type=\"0\"/><riddle answer=\"s\" answer_type=\"2\" copyright=\"\" hint=\"&lt;p&gt;Un symbole peut représenter pleins de choses.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;S&lt;/p&gt;&lt;p&gt;SIX = 6&lt;/p&gt;\" text=\"&lt;p&gt;Ajoutez un symbole qui n'est pas un chiffre pour que cette égalité soit vraie : &lt;/p&gt;&lt;p&gt;IX = 6&lt;/p&gt;&lt;p&gt;(Vous devez juste noter le symbole, autre que le signe &quot;différent&quot;)&lt;/p&gt;\" title=\"Le symbole\" type=\"0\"/><riddle answer=\"suicide|sucide\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Dans quel cas ne peut-on punir quelqu'un ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est un suicide.&lt;/p&gt;\" text=\"&lt;p&gt;Le 12 décembre 2009, une personne de 25 ans a pris une vie, tout le monde sait ce qu'il s'est passé cependant, personne n'ira jamais en prison.&lt;/p&gt;&lt;p&gt;Pourquoi ?&lt;/p&gt;\" title=\"L'enquête connue\" type=\"0\"/><riddle answer=\"a\" answer_type=\"2\" copyright=\"\" hint=\"&lt;p&gt;A quoi correspond °F ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;30°F est une température inférieure à -2°C, donc l'eau du seau B est glacée. La boule ne peut donc pas toucher le fond.&lt;/p&gt;\" text=\"&lt;p&gt;Jacques possède 2 seaux (A et B) remplis d'eau.&lt;/p&gt;&lt;p&gt; - A est à une température de 68°F.&lt;br/&gt; - B est à une température de 28°F.&lt;/p&gt;&lt;p&gt;Il jette une boule de pétanque dans chaque seau en même temps.&lt;/p&gt;&lt;p&gt;Dans quel seau la boule atteindra le fond en premier ?&lt;/p&gt;\" title=\"Les seaux\" type=\"0\"/><riddle answer=\"0\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;L'effet du fusil.&lt;/p&gt;\" image=\"bird\" solution=\"&lt;p&gt;0. Les autres oiseaux se sont envolés.&lt;/p&gt;\" text=\"&lt;p&gt;Sur un arbre se trouvent 10 oiseaux.&lt;br/&gt;Un chasseur arrive, tire avec son fusil sur un oiseau et le tue.&lt;/p&gt;&lt;p&gt;Combien reste-t-il d'oiseaux sur l'arbre ?&lt;/p&gt;\" title=\"Le chasseur d'oiseaux\" type=\"0\"/><riddle answer=\"0\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Attention de bien lire.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est Noé qui a bâti une arche.&lt;/p&gt;\" text=\"&lt;p&gt;Combien d'animaux de chaque espèce Moïse a-t-il emmené dans son arche ?&lt;/p&gt;\" title=\"Le déluge\" type=\"0\"/><riddle answer=\"australie|pange\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Quel changement terrestre y'a-t-il eu à sa découverte ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Même si elle n'était pas découverte, l'Australie était déjà présente.&lt;/p&gt;&lt;p&gt;La pangée est également acceptée.&lt;/p&gt;\" text=\"&lt;p&gt;Quelle était la plus grande île du monde avant la découverte de l'Australie ?&lt;/p&gt;\" title=\"James Cook\" type=\"0\"/><riddle answer=\"7\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Combien faut-il de soeur ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il y a une seule soeur commune aux 4 frères. Il y a donc les 2 parents, les 4 garçons et la fille, soit 7 personnes.&lt;/p&gt;\" text=\"&lt;p&gt;M. et Mme Martin ont 4 garçons. Chacun de ces garçons a une soeur.&lt;/p&gt;&lt;p&gt;Combien y a-t-il de personnes au minimum dans cette famille ?&lt;/p&gt;\" title=\"Les enfants\" type=\"0\"/><riddle answer=\"12\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Que février ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Tous les mois de l'année ont 28 jours.&lt;/p&gt;\" text=\"&lt;p&gt;Certains mois ont 31 jours, d'autres en ont 30. Mais combien en contiennent 28 ?&lt;/p&gt;\" title=\"Les mois\" type=\"0\"/><riddle answer=\"5\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Attention à bien vérifier la différence d'1€.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le bouchon vaut 0.05€.&lt;br/&gt;1.05 + 0.05 = 1.10€.&lt;br/&gt;&lt;br/&gt;Si le bouchon valait 0.10€ alors la bouteille coûterait 1€ de plus soit 1€10. Le total coûterait 1€20.&lt;/p&gt;\" text=\"&lt;p&gt;1 bouteille et son bouchon coûtent ensemble 1€10. La bouteille coûte 1€ de plus que le bouchon.&lt;/p&gt;&lt;p&gt;Combien coûte le bouchon (en centimes d'euro) ?&lt;/p&gt;\" title=\"La bouteille\" type=\"0\"/><riddle answer=\"0\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Il faut bien lire.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le coq ne pond pas d'oeufs.&lt;/p&gt;\" text=\"&lt;p&gt;Il y a deux maisons séparées d'une ligne jaune. Sur cette ligne il y a un coq.&lt;/p&gt;&lt;p&gt;Combien d'oeufs ce coq a-t-il pondu ?&lt;/p&gt;\" title=\"La ligne jaune\" type=\"0\"/><riddle answer=\"ombre|reflet\" answer_type=\"3\" copyright=\"Proposée par Pierre Fernandez.\" hint=\"&lt;p&gt;Peter Pan l'a retrouvée lui.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;L'ombre de la Tour Eiffel peut être plus grande qu'elle et ne rien peser.&lt;/p&gt;\" text=\"&lt;p&gt;Je peux être plus grande que la Tour Eiffel mais je ne pèse rien.&lt;/p&gt;&lt;p&gt;Qui suis-je?&lt;/p&gt;\" title=\"La patrie\" type=\"0\"/><riddle answer=\"dorm|dort\" answer_type=\"3\" copyright=\"Proposé par Kyrou.\" hint=\"&lt;p&gt;Métier difficile.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Pour rêver il faut dormir ce qui ne fait pas partie des attributions d'un veilleur de nuit.&lt;/p&gt;\" text=\"&lt;p&gt;M. Sergent a un veilleur de nuit. Il doit partir en voyage, mais le matin de son départ, son veilleur de nuit lui dit ceci : &lt;/p&gt;&lt;p&gt;&lt;i&gt;&quot;Monsieur, ne partez pas. Cette nuit j'ai rêvé que votre avion s'était écrasé.&quot;&lt;/i&gt;&lt;/p&gt;&lt;p&gt; M. Sergent ne part pas et, le soir, il apprend que l'avion s'est écrasé. Pour remercier son veilleur, il lui donne une grosse somme d'argent, mais néanmoins il le licencie.&lt;/p&gt;&lt;p&gt;Pourquoi ?&lt;/p&gt;\" title=\"La nuit\" type=\"0\"/><riddle answer=\"t\" answer_type=\"2\" copyright=\"Proposé par Kyrou.\" hint=\"&lt;p&gt;Cette suite n'est pas si différente des autres.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;uN&lt;br/&gt;deuX&lt;br/&gt;troiS&lt;br/&gt;quatrE&lt;br/&gt;cinQ&lt;br/&gt;siX&lt;br/&gt;sepT&lt;/p&gt;\" text=\"&lt;p&gt;Quelle est la lettre suivante de cette suite logique :&lt;/p&gt;&lt;p&gt;N - X - S - E - Q - X - ?&lt;/p&gt;\" title=\"Les chiffres et les lettres\" type=\"0\"/><riddle answer=\"rien\" answer_type=\"1\" copyright=\"Proposé par Kyrou.\" hint=\"&lt;p&gt;Attention aux éléments nécessaires&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Pour que l'allumette s'enflamme, l'oxygène est nécessaire. Il ne se passera donc rien.&lt;br/&gt;&lt;br/&gt;Voir le &quot;Triangle du feu&quot; pour plus d'informations.&lt;/p&gt;\" text=\"&lt;p&gt;Si vous étiez dans une pièce remplie de méthane (vous retenez votre respiration) et que vous grattiez une allumette.&lt;/p&gt;&lt;p&gt;Que se produirait-il ?&lt;/p&gt;\" title=\"Inflammable\" type=\"0\"/><riddle answer=\"jour\" answer_type=\"1\" copyright=\"Proposée par Korijy.\" hint=\"&lt;p&gt;Qu'est ce qui influence la visibilité du conducteur ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il fait jour, les lampadaires et les phares n'ont aucune influence sur la visibilité du conducteur.&lt;/p&gt;\" text=\"&lt;p&gt;Un homme roule en voiture, tous phares éteints. Il n'y a pas de lampadaire sur la route qu'il emprunte et on ne voit pas la lune. Soudain, un chien traverse. Il arrive à l'éviter.&lt;/p&gt;&lt;p&gt;Comment cela est-il possible ?&lt;/p&gt;\" title=\"De justesse\" type=\"0\"/><riddle answer=\"timbre\" answer_type=\"1\" copyright=\"Proposé par Théo.\" hint=\"&lt;p&gt;C'est si léger.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un timbre peut parcourir le monde tout en restant dans le coin de l'enveloppe à laquelle il est collé.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est-ce qui peut faire le tour du monde en restant dans son coin ?&lt;/p&gt;\" title=\"Le voyageur\" type=\"0\"/><riddle answer=\"aucun|pareil|semblable|meme|egale|egaux\" answer_type=\"3\" copyright=\"Proposé par Tenshi.\" hint=\"&lt;p&gt;Le temps qui passe...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Aucun, en effet, 80s = 1min20.&lt;/p&gt;\" text=\"&lt;p&gt;Un homme promène son chien et lui fait faire le tour d'un champ carré (nommé A), dont Rex met 80s pour parcourir chaque côté.&lt;/p&gt;&lt;p&gt;Le lendemain, il l'emmène à un autre champ carré (nommé B). Sur celui-ci, il met 1min20 par côté.&lt;/p&gt;&lt;p&gt;Quel champ est plus grand que l'autre sachant que le chien a couru à la même vitesse ?&lt;/p&gt;\" title=\"Promenade\" type=\"0\"/><riddle answer=\"6000\" answer_type=\"0\" copyright=\"Proposé par Cocomomo.\" hint=\"&lt;p&gt;D'où viennent les matériaux de construction ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les matériaux de construction provenant de la terre, sa masse totale ne change pas, soit 6000 milliards de milliards de tonnes.&lt;/p&gt;\" text=\"&lt;p&gt;On admet que la terre fait 6000 milliards de milliards de tonnes. Un milliardaire fou décide de battre la Grande muraille de Chine et de construire un mur de 7000 km.&lt;/p&gt;&lt;p&gt;La masse pour 100 km de ce mur est de 1 milliards de milliards de tonnes.&lt;/p&gt;&lt;p&gt;A la fin de la construction de ce mur, quelle sera la masse de la terre (en milliards de milliards de tonnes) ?&lt;/p&gt;\" title=\"La grande muraille\" type=\"0\"/><riddle answer=\"marche|pied|pieton\" answer_type=\"3\" copyright=\"Proposé par Cocomomo.\" hint=\"&lt;p&gt;Pourquoi le policier ne l'a pas verbalisé ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le conducteur de bus ne travaille pas et se promène dans la rue à pied.&lt;/p&gt;\" text=\"&lt;p&gt;Un conducteur de bus s'engage de face et à contre-sens d'une rue dont la circulation est à sens unique. Au bout de 10 mètres, il croise un policier qui lui fait un signe. Après quelques minutes, il repart dans le même sens sans avoir de contravention.&lt;/p&gt;&lt;p&gt;Pourquoi ?&lt;/p&gt;\" title=\"Le policier\" type=\"0\"/><riddle answer=\"mere\" answer_type=\"1\" copyright=\"Proposé par Copix.\" hint=\"&lt;p&gt;La complexité des liens de parenté...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les deux sioux sont la mère et le fils.&lt;/p&gt;\" text=\"&lt;p&gt;Deux sioux sont assis dans un tipi. L'un est le fils de l'autre, mais l'autre n'est pas son père.&lt;/p&gt;&lt;p&gt;Qui est-ce ?&lt;/p&gt;\" title=\"Le tipi\" type=\"0\"/><riddle answer=\"triple|quadruple|quintuple\" answer_type=\"3\" copyright=\"Proposé par Cocomomo.\" hint=\"&lt;p&gt;Plus.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Ce sont 2 enfants parmis des triplés.&lt;/p&gt;&lt;p&gt;Les jumeaux représentent les enfants d'un même accouchement quelque soit leurs nombres. Ainsi les triplés, quadruplés, quintuplés et supérieurs seront aussi des jumeaux&lt;/p&gt;\" text=\"&lt;p&gt;Corentin et Morgan sont nés tous les deux le 28 février de la même année, respectivement à 23h54 et 23h59 exactement. Ils ont tous les deux le même père et la même mère. Pourtant ce ne sont pas que des jumeaux.&lt;/p&gt;&lt;p&gt;Comment cela est-il possible ?&lt;/p&gt;\" title=\"La naissance\" type=\"0\"/><riddle answer=\"deuxieme|2ieme|2eme|second|2\" answer_type=\"3\" copyright=\"Proposé par ptiprinc3.\" hint=\"&lt;p&gt;Attention au piège.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le piège était de répondre premier. Vous êtes naturellement deuxième.&lt;/p&gt;\" text=\"&lt;p&gt;Vous êtes dans une formule 1, la course est très mouvementée, vous êtes en troisième position et vous doublez le deuxième.&lt;/p&gt;&lt;p&gt;Quelle est votre position ?&lt;/p&gt;\" title=\"Les formules 1\" type=\"0\"/><riddle answer=\"52\" answer_type=\"0\" copyright=\"Proposé par dalifil06.\" hint=\"&lt;p&gt;Qu'est-ce qui a des pattes ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il y a 52 pattes.&lt;br/&gt;&lt;br/&gt;4x4+2x4+6x2+4x4 = 52. Il ne faut pas compter les 14 personnes qui elles, ont des jambes.&lt;/p&gt;\" text=\"&lt;p&gt;Dans une ferme on trouve 4 lapins, 2 chats, 14 personnes, 6 canards et 4 chiens. Combien y a t-il de pattes dans cette ferme ?&lt;/p&gt;\" title=\"La ferme\" type=\"0\"/><riddle answer=\"o\" answer_type=\"2\" copyright=\"\" hint=\"&lt;p&gt;Lisez bien.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La lettre O.&lt;/p&gt;\" text=\"&lt;p&gt;On me trouve chez l'homme mais pas chez la femme, dans une tomate mais pas dans une banane, dans un avion mais pas dans un bateau.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"La différence\" type=\"0\"/><riddle answer=\"194|083\" answer_type=\"4\" copyright=\"\" hint=\"&lt;p&gt;Le chiffre des centaines est le plus simple à trouver.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;194.&lt;br/&gt;4 + 5 = 9.&lt;br/&gt;9 - 8 = 1.&lt;br/&gt;&lt;br/&gt;083 est aussi accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Stéphanie a oublié son code. Heureusement, elle avait noté une méthode pour le retrouver : &lt;/p&gt;&lt;p&gt; - Le chiffre des dizaines fait 5 de plus par rapport au chiffre des unités.&lt;br/&gt; - Le chiffre des centaines fait 8 de moins que celui des dizaines.&lt;/p&gt;&lt;p&gt;Quel est le code de Stéphanie ?&lt;/p&gt;\" title=\"Le code\" type=\"0\"/><riddle answer=\"chauve\" answer_type=\"1\" copyright=\"Proposé par jibey.\" hint=\"&lt;p&gt;Une pilosité spéciale.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il est chauve. Il ne risque pas d'avoir les cheveux mouillés.&lt;/p&gt;\" text=\"&lt;p&gt;Un banquier sort de sa banque pour rentrer chez lui à pied. Il pleut dehors et il n'a pas de parapluie ni de couvre-chef. Arrivé chez lui, il est tout mouillé sauf les cheveux.&lt;/p&gt;&lt;p&gt;Pourquoi ?&lt;/p&gt;\" title=\"Le banquier\" type=\"0\"/><riddle answer=\"horloge|reveil|montre\" answer_type=\"3\" copyright=\"Proposé par fany64.\" hint=\"&lt;p&gt;Nécessaire pour beaucoup de personnes.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le réveil affiche de 00:00 à 23:59 et vous tire de votre sommeil lorsqu'il sonne.&lt;/p&gt;\" text=\"&lt;p&gt;Mon minimum est 0000, mon maximum est 2359, et je sonne le glas de tes rêves.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Etrange limite\" type=\"0\"/><riddle answer=\"palindrome|palyndrome\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Il faut regarder le sens.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Ces mots sont tous des palindromes.&lt;/p&gt;\" text=\"&lt;p&gt; - Rêver&lt;br/&gt; - Retater&lt;br/&gt; - Repiper&lt;br/&gt; - Kayak&lt;/p&gt;&lt;p&gt;A quel genre de mots appartiennent-ils ?&lt;/p&gt;\" title=\"Le français\" type=\"0\"/><riddle answer=\"0\" answer_type=\"0\" copyright=\"Proposé par Tuyzu.\" hint=\"&lt;p&gt;Il faut bien tout lire.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un train électrique ne produit pas de fumée. La fumée va donc à 0km/h.&lt;/p&gt;\" text=\"&lt;p&gt;Un train électrique roule en direction du nord à une vitesse de 70km/h. Sachant que le vent souffle en direction de l'est à 50km/h, quelle est la vitesse de la fumée (en km/h) du train ?&lt;/p&gt;\" title=\"Le vent\" type=\"0\"/><riddle answer=\"feuille|pomme\" answer_type=\"3\" copyright=\"Proposé par Choupi.\" hint=\"&lt;p&gt;Ce changement peut apparaitre sur une année.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une feuille est verte au printemps et en été et change de couleur à l'automne.&lt;/p&gt;&lt;p&gt;La pomme est également acceptée.&lt;/p&gt;\" text=\"&lt;p&gt;Principalement verte, je peux être rouge, jaune ou marron selon la période. Qui suis-je ?&lt;/p&gt;\" title=\"L'arc en ciel\" type=\"0\"/><riddle answer=\"savon|gomme|bougie|crayon|craie|bonbon|toilette|grelon|flocon|sucette|cigare|sucre|chandel\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;On en utilise tous les jours (j'espère pour vous).&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un savon.&lt;br/&gt;&lt;br/&gt;Une gomme, un bonbon, une bougie, une craie, un sucre, un crayon, un cigare ou du papier toilettes sont aussi acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est-ce qui est gros quand il est neuf et rétrécit avec le temps puis disparaît ?&lt;/p&gt;\" title=\"L'arnaque\" type=\"0\"/><riddle answer=\"tableau|ardoise\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Tout le monde en a regardé un pendant des années.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un tableau à craie.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est-ce qui est noir quand il est lavé et gris et blanc quand il est sale et qui nous en apprend ?&lt;/p&gt;\" title=\"Astiquer\" type=\"0\"/><riddle answer=\"ecorce|lisiere|oree|ecorse\" answer_type=\"3\" copyright=\"Proposé par Damian.\" hint=\"&lt;p&gt;Qu'est-ce que le bois ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;L'écorce fait le tour de l'arbre (le bois) sans jamais y rentrer.&lt;br/&gt;&lt;br/&gt;La lisière est également acceptée.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est-ce qui fait le tour du bois sans jamais y rentrer ?&lt;/p&gt;\" title=\"La forêt\" type=\"0\"/><riddle answer=\"nuit|pluie|neige|grele|jour|verdict|jugement|foudre|dent|orage|foudre|sanction|sentence|nouvelle|feuille|vent\" answer_type=\"3\" copyright=\"Proposé par Victor.\" hint=\"&lt;p&gt;C'est tard.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La nuit.&lt;br/&gt;&lt;br/&gt;La pluie, neige, grêle, orage, foudre, verdict, le vent et le jour sont également acceptées.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est-ce qui tombe et que l'on ne peut pas relever ?&lt;/p&gt;\" title=\"La chute\" type=\"0\"/><riddle answer=\"feu\" answer_type=\"1\" copyright=\"Créé par J.R.R. Tolkien, proposé par Mallow.\" hint=\"&lt;p&gt;Manger est une métaphore.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le feu vit lorsqu'on le nourrit (avec une matière inflammable) et meurt lorsqu'on l'arrose.&lt;/p&gt;\" text=\"&lt;p&gt;Lorsque je mange, je vis.&lt;br/&gt;Lorsque je bois, je meurs.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"L'être\" type=\"0\"/><riddle answer=\"o\" answer_type=\"2\" copyright=\"Proposée par Océane.\" hint=\"&lt;p&gt;Lire les lettres séparément.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La lettre O.&lt;/p&gt;&lt;p&gt;Toutes les lettres représentent une syllabe qui veut dire quelque chose.&lt;/p&gt;\" text=\"&lt;p&gt;Quelle est la lettre suivante dans cette suite logique : &lt;/p&gt;&lt;p&gt;D, H, K, L, M, N, ?&lt;/p&gt;\" title=\"Une seule\" type=\"0\"/><riddle answer=\"3\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Commencez par le ciel.&lt;/p&gt;\" image=\"marelle\" solution=\"&lt;p&gt;Elle a besoin de 3 couleurs pour colorier les cases sans que 2 cases qui se touchent aient la même couleur.&lt;/p&gt;\" text=\"&lt;p&gt;Marie veut jouer à la marelle, mais cette fois-ci, elle a décidé de dessiner un beau parcours. Elle veut colorier chaque case d'une couleur sans que les cases se touchant soient de la même couleur.&lt;/p&gt;&lt;p&gt;Combien de couleurs devra-t-elle utiliser au minimum ?&lt;/p&gt;\" title=\"La marelle\" type=\"0\"/><riddle answer=\"0\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Ne jamais aller trop loin.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;0 est le plus petit nombre, le suivant est 280, 560, etc. Ceci par pas de 280.&lt;/p&gt;\" text=\"&lt;p&gt;Quel est le plus petit nombre qui : &lt;br/&gt; - Devient divisible par 5 lorsqu'on lui ajoute 5,&lt;br/&gt; - Devient divisible par 7 lorsqu'on lui ajoute 7,&lt;br/&gt; - Devient divisible par 8 lorsqu'on lui ajoute 8.&lt;/p&gt;\" title=\"Nombre magique\" type=\"0\"/><riddle answer=\"22\" answer_type=\"0\" copyright=\"Proposé par Mickael.\" hint=\"&lt;p&gt;Un calcul pas si complexe.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;22.&lt;br/&gt;&lt;br/&gt;A partir du troisième terme, il s'agit de l'addition des deux précédents moins 1.&lt;/p&gt;\" text=\"&lt;p&gt;Complétez cette suite logique : &lt;br/&gt;1 - 2 - 2 - 3 - 4 - 6 - 9 - 14 - ?&lt;/p&gt;\" title=\"Encore des chiffres\" type=\"0\"/><riddle answer=\"parapluie\" answer_type=\"1\" copyright=\"Proposé par Clément.\" hint=\"&lt;p&gt;Elle n'aime pas être mouillée.&lt;/p&gt;\" image=\"lift\" solution=\"&lt;p&gt;Les jours de pluie, elle a un parapluie.&lt;/p&gt;\" text=\"&lt;p&gt;Madame Dupont habite au 11ème étage d'un immeuble, mais comme elle est petite, elle n'atteint pas le 11ème bouton de l'ascenseur. Elle monte alors jusqu'au 8ème étage puis termine par les escaliers.&lt;/p&gt;&lt;p&gt;Cependant, les jours de pluie, Madame Dupont va directement au 11ème étage avec l'ascenseur. Comment est-ce possible?&lt;/p&gt;\" title=\"L'ascenseur\" type=\"0\"/><riddle answer=\"fille|femme|soeur|sœeur|moine\" answer_type=\"3\" copyright=\"Proposé par Marine.\" hint=\"&lt;p&gt;Le pays compte.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les 3 russes sont des femmes.&lt;/p&gt;&lt;p&gt;Un moine est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Trois russes ont un frère en commun, ce dernier meurt, et pourtant les trois russes n'ont plus de frère.&lt;/p&gt;&lt;p&gt;Comment est-ce possible ?&lt;/p&gt;\" title=\"Les russes\" type=\"0\"/><riddle answer=\"v\" answer_type=\"2\" copyright=\"Proposé par John Doe.\" hint=\"&lt;p&gt;Les majuscules comptent.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;V.&lt;br/&gt;&lt;br/&gt;A H I M O T U V W X Y.&lt;br/&gt;&lt;br/&gt;Ce sont les lettres majuscules que l'on peut regarder dans un miroir sans déformation.&lt;/p&gt;\" text=\"&lt;p&gt;Trouvez la lettre suivante : &lt;/p&gt;&lt;p&gt;A H I M O T U ?&lt;/p&gt;\" title=\"Suite de majuscules\" type=\"0\"/><riddle answer=\"1\" answer_type=\"0\" copyright=\"Proposé par Nicolas.\" hint=\"&lt;p&gt;Jeu de mot en français.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;1 seule personne est morte, le capitaine. Les moines ont eu la tête dans les mains.&lt;/p&gt;\" text=\"&lt;p&gt;Un capitaine a été décapité, deux moines ont la tête tranchée.&lt;/p&gt;&lt;p&gt;Combien de personnes sont mortes ?&lt;/p&gt;\" title=\"La guillotine\" type=\"0\"/><riddle answer=\"chauve\" answer_type=\"1\" copyright=\"Proposé par Rachid.\" hint=\"&lt;p&gt;Dans une bouteille de shampooing.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le douanier a eu un doute car le voyageur est chauve.&lt;/p&gt;\" text=\"&lt;p&gt;Un voyageur qui revient de vacances passe à la douane, et passe après la vérification de ses bagages.&lt;/p&gt;&lt;p&gt;Pris d'un doute, le douanier le rappelle, revérifie ses bagages et trouve de la drogue dans une bouteille de shampooing.&lt;/p&gt;&lt;p&gt;Pourquoi le douanier a-t-il eu un doute ?&lt;/p&gt;\" title=\"Douanier 007\" type=\"0\"/><riddle answer=\"c\" answer_type=\"2\" copyright=\"Proposé par Marco.\" hint=\"&lt;p&gt;Prenez bien compte tous les éléments.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il doit choisir la porte C, en effet, si les lions n'ont pas mangé depuis 3 ans, ils sont tous morts de faim.&lt;/p&gt;\" text=\"&lt;p&gt;Un choix est imposé à un condamné à mort. Devant lui se trouvent 3 chambres (A, B et C) : &lt;/p&gt;&lt;p&gt; - A : Tous les tueurs les plus sanguinaires se trouvent dans cette chambre.&lt;br/&gt; - B : Cette chambre est totalement en flammes.&lt;br/&gt; - C : Dans cette dernière se trouvent 5 lions qui n'ont pas mangé depuis 3 ans.&lt;/p&gt;&lt;p&gt;Quelle chambre va-t-il choisir ?&lt;/p&gt;\" title=\"Le condamné\" type=\"0\"/><riddle answer=\"alphab\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Ecrivez en toute lettre.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Cette suite de chiffres est triée dans l'ordre alphabétique.&lt;/p&gt;\" text=\"&lt;p&gt;Quelle est la particularité de cette suite : &lt;/p&gt;5, 2, 8, 9, 4, 7, 6, 3, 1, 0&lt;/p&gt;\" title=\"De 1 à 10\" type=\"0\"/><riddle answer=\"c\" answer_type=\"2\" copyright=\"\" hint=\"&lt;p&gt;Il faut bien lire la question.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C.&lt;br/&gt;&lt;br/&gt;La suite représente la première lettre de chaque mot de la question : Quelle Est La Prochaine Lettre De Cette Série.&lt;/p&gt;\" text=\"&lt;p&gt;Quelle est la prochaine lettre de cette série ? &lt;/p&gt;&lt;p&gt;Q E L P L D ?&lt;/p&gt;\" title=\"Quelle logique ?\" type=\"0\"/><riddle answer=\"silvia\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Trouvez la suite logique.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Silvia.&lt;br/&gt;&lt;br/&gt;Les prénoms des enfants commencent par Do, ré, mi, fa, sol, la. Le prochain commencera donc par Si.&lt;/p&gt;\" text=\"&lt;p&gt;Une femme enceinte va accoucher d'un 7e enfant. Elle vient d'apprendre qu'elle va avoir une fille. Ses précédents enfants s'appellent Dorian, Reno, Michelle, Fanny, Solenne, Larry.&lt;/p&gt;&lt;p&gt;Quel sera le prénom de sa prochaine fille ?&lt;/p&gt;&lt;p&gt;Sarah, Karène, Silvia ou Vicky ?&lt;/p&gt;\" title=\"Famille étrange\" type=\"0\"/><riddle answer=\"3\" answer_type=\"0\" copyright=\"Proposé par Nissim.\" hint=\"&lt;p&gt;Toutes sauf 2, donc au moins 1.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il a 3 voitures.&lt;br/&gt;&lt;br/&gt;Une rouge, une blanche et une noire.&lt;/p&gt;\" text=\"&lt;p&gt;Un milliardaire possède plusieurs voitures de collection de plusieurs couleurs.&lt;/p&gt;&lt;p&gt;On sait que toutes sauf deux sont rouges, toutes sauf deux sont noires et toutes sauf deux sont blanches.&lt;/p&gt;&lt;p&gt;Combien de voitures a-t-il au minimum ?&lt;/p&gt;\" title=\"Toutes sauf deux...\" type=\"0\"/><riddle answer=\"2\" answer_type=\"0\" copyright=\"Proposé par Amine.\" hint=\"&lt;p&gt;Ma mère et la mère de mon frère...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il y a 2 personnes au minimum dans la pièce, un enfant et sa mère.&lt;/p&gt;\" text=\"&lt;p&gt;Dans une pièce, il y a un enfant, sa mère, la soeur de son oncle, la fille de son grand-père et la tante de son cousin.&lt;/p&gt;&lt;p&gt;Combien il y a de personnes au minimum dans cette piece?&lt;/p&gt;\" title=\"Liens familiaux\" type=\"0\"/><riddle answer=\"100\" answer_type=\"0\" copyright=\"Proposé par William.\" hint=\"&lt;p&gt;Ecrivez cette suite.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;100.&lt;br/&gt;Ces nombres s'écrivent tous en 4 lettres.&lt;/p&gt;\" text=\"&lt;p&gt;0, 2, 5, 7, 8, 9, 11, ?&lt;/p&gt;&lt;p&gt;Quel est le nombre suivant de cette suite ?&lt;/p&gt;\" title=\"La fameuse suite\" type=\"0\"/><riddle answer=\"petit|nain\" answer_type=\"3\" copyright=\"Proposé par Mathilde.\" hint=\"&lt;p&gt;Pas toujours facile à atteindre.&lt;/p&gt;\" image=\"lift\" solution=\"&lt;p&gt;Cet homme est petit, il n'atteint pas le bouton du 21ième étage.&lt;/p&gt;\" text=\"&lt;p&gt;Un homme qui habite au 21ième étage prend l'ascenseur tous les matins pour aller travailler. Seulement le soir, il prend l'ascenseur jusqu'au 11ième étage puis prend les escaliers jusqu'à chez lui.&lt;/p&gt;&lt;p&gt;Pourquoi ?&lt;/p&gt;\" title=\"L'ascenseur magique\" type=\"0\"/><riddle answer=\"13\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Essayez de poser un système d'équations.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Ils sont 13.&lt;br/&gt;&lt;br/&gt;Il y a x lingots et v voleurs.&lt;br/&gt;x = 6 * v + 5&lt;br/&gt;x + 8 = 7 * v&lt;br/&gt;&lt;br/&gt;De la on trouve x = 83 et v = 13.&lt;/p&gt;&lt;p&gt;On peut également poser le problème sous la forme : 6x + 5 = 7x - 8&lt;/p&gt;\" text=\"&lt;p&gt;Un groupe de voleurs doit se partager des lingots d'or. Le chef aimerait faire un partage équitable, mais si chacun en prend 6, il en restera 5. Et si chacun en prend 7, il en manquera 8.&lt;/p&gt;&lt;p&gt;Combien y a-t-il de voleurs ?&lt;/p&gt;\" title=\"Au vol!!!\" type=\"0\"/><riddle answer=\"41\" answer_type=\"0\" copyright=\"Proposé par Adrien.\" hint=\"&lt;p&gt;Il n'y a pas tant de possibilités que ça, sinon on monte vite dans les âges.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;J'ai 41 ans, ma fille en a 14.&lt;br/&gt;J'ai eu ma fille à 27 ans.&lt;/p&gt;\" text=\"&lt;p&gt;J'ai remarqué que si j'inverse les chiffres de mon âge, cela me donne celui de ma fille.&lt;/p&gt;&lt;p&gt;Sachant que j'ai eu ma fille entre 20 et 30 ans, et que mon âge est un nombre premier, quel est il ?&lt;/p&gt;\" title=\"Ma fille\" type=\"0\"/><riddle answer=\"3\" answer_type=\"0\" copyright=\"Proposé par Jeremy.\" hint=\"&lt;p&gt;Il ne faut pas soustraire et additionner n'importe comment.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Je finis à la 3ème place.&lt;/p&gt;\" text=\"&lt;p&gt;Sur 24 coureurs, je suis 12ième, 10 coureurs me dépassent, j'en dépasse 11, 9 me redépassent puis j'en redépasse 19.&lt;/p&gt;&lt;p&gt;A quelle position suis-je sachant que 2 coureurs m'ont dépassé juste avant la ligne d'arrivée ?&lt;/p&gt;\" title=\"La course\" type=\"0\"/><riddle answer=\"10\" answer_type=\"0\" copyright=\"Proposé par David.\" hint=\"&lt;p&gt;Masse, volume...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La masse reste la même donc 10 kilogrammes.&lt;/p&gt;\" text=\"&lt;p&gt;En sachant que 1 litre d'eau pèse 1 kilogramme, lorsqu'il se transforme en glace, l'eau prend 10% de son volume.&lt;/p&gt;&lt;p&gt;Quelle est la masse d'un glaçon (en kilogrammes) fait avec 10 litres d'eau ?&lt;/p&gt;\" title=\"Brrr!!\" type=\"0\"/><riddle answer=\"monopoly|monopoli\" answer_type=\"3\" copyright=\"Proposé par Arnaud.\" hint=\"&lt;p&gt;Un hôtel aurait tout changé.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Cette famille joue tranquillement au Monopoly.&lt;/p&gt;\" text=\"&lt;p&gt;C'est une famille soudée et heureuse, cependant, en moins de 15 minutes, la fille devient riche, la mère est ruinée et le père est en prison.&lt;/p&gt;&lt;p&gt;Que s'est-il passé ?&lt;/p&gt;\" title=\"Soirée en famille\" type=\"0\"/><riddle answer=\"29|fevrier|bissextile\" answer_type=\"3\" copyright=\"Proposé par Sparrow.\" hint=\"&lt;p&gt;Pas tous les ans.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Pierre est né un 29 février.&lt;/p&gt;\" text=\"&lt;p&gt;Pierre a 80 ans mais il vient de fêter son vingtième anniversaire.&lt;/p&gt;&lt;p&gt;Comment cela est-il possible ?&lt;/p&gt;\" title=\"L'anniversaire\" type=\"0\"/><riddle answer=\"50\" answer_type=\"0\" copyright=\"Proposé par JL.\" hint=\"&lt;p&gt;Demi oui, mais demi de quoi ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;50.&lt;br/&gt;&lt;br/&gt;Il vend 1 tiers du bétail plus 1 demi de ce tiers.&lt;/p&gt;\" text=\"&lt;p&gt;Un paysan a un troupeau de 100 animaux. Il en vend 1 tiers et demi.&lt;/p&gt;&lt;p&gt;Combien lui reste-t-il d'animaux ?&lt;/p&gt;\" title=\"Le paysan\" type=\"0\"/><riddle answer=\"84\" answer_type=\"0\" copyright=\"Proposé par Broussnico.\" hint=\"&lt;p&gt;12, 24, 35, 46, 54, 63, 74, ?, 94.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;84.&lt;br/&gt;&lt;br/&gt;1 s'écrit avec 2 lettres : 12,&lt;br/&gt;2 s'écrit avec 4 lettres : 24,&lt;br/&gt;3 s'écrit avec 5 lettres : 35,&lt;br/&gt;etc.&lt;/p&gt;\" text=\"&lt;p&gt;Quel est le nombre suivant de cette suite : &lt;/p&gt;&lt;p&gt;12, 24, 35, 46, 54, 63, 74, ?&lt;/p&gt;\" title=\"Suite mixte\" type=\"0\"/><riddle answer=\"n\" answer_type=\"2\" copyright=\"Proposé par Sabrine.\" hint=\"&lt;p&gt;Recitez l'alphabet.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;N.&lt;br/&gt;&lt;br/&gt;Cette suite est l'alphabet en mettant 1 lettre sur 2.&lt;/p&gt;\" text=\"&lt;p&gt;Quelle est la prochaine lettre de cette suite : &lt;/p&gt;&lt;p&gt;B, D, F, H, J, L, ?&lt;/p&gt;\" title=\"Alphabet rapide\" type=\"0\"/><riddle answer=\"rose\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;La conversation donne un indice.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Rose.&lt;br/&gt;&lt;br/&gt;Violette n'est pas habillée en violet ni en blanc (vu que c'est l'autre personne qui parle qui l'est). Elle est donc en rose. Blanche ne pouvant être en blanc, c'est donc Rose qui est habillée en blanc.&lt;/p&gt;\" text=\"&lt;p&gt;Trois femmes élégantes se rencontrent. Elles se nomment Blanche, Rose et Violette. L'une est habillée de blanc, une autre de rose et la dernière de violet.&lt;/p&gt;&lt;p&gt;- Violette : Comme cela est curieux, aucune d'entre nous n'est habillée avec des vêtements qui sont de la couleur de leur prénom.&lt;br/&gt;- Tu as raison! Confirme celle habillée de blanc.&lt;/p&gt;&lt;p&gt;Qui est habillée en blanc ?&lt;/p&gt;\" title=\"Les princesses\" type=\"0\"/><riddle answer=\"4\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Le vent à vitesse constante.&lt;/p&gt;\" image=\"globe\" solution=\"&lt;p&gt;4h, l'avion se déplacant à vitesse constante, le pilote compense la puissance de l'avion en fonction du vent.&lt;/p&gt;\" text=\"&lt;p&gt;Un avion fait un aller-retour à une vitesse constante au sol de 800km/h entre 2 villes éloignées de 1600km. A l'aller, il y avait un vent de face de 100km/h, au retour il avait le vent dans le dos à 50km/h.&lt;/p&gt;&lt;p&gt;Combien de temps (en heures) l'avion a-t-il mis pour faire l'aller-retour (on néglige les temps des escales et le décalage horaire) ?&lt;/p&gt;\" title=\"L'avion\" type=\"0\"/><riddle answer=\"999\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Le nombre de page total est un très gros indice.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le livre comportant 1000 pages, la page 999 dira la vérité.&lt;/p&gt;&lt;p&gt;Cette page dit que 999 pages sont fausses, ce qui du coup est vrai, le livre comportant 1000 pages.&lt;/p&gt;\" text=\"&lt;p&gt;Un livre a 1000 pages. Sur la première page on peut lire :&lt;/p&gt;&lt;p&gt;1 page de ce livre contient des affirmations fausses&lt;/p&gt;&lt;p&gt;Sur la 2e page on peut lire :&lt;br/&gt;&lt;p&gt;2 pages de ce livre contiennent des affirmations fausses&lt;/p&gt;&lt;p&gt;Sur la 3e page on peut lire :&lt;br/&gt;3 pages de ce livre contiennent des affirmations fausses&lt;br/&gt;....&lt;br/&gt;sur la 1000e page :&lt;br/&gt;1000 pages de ce livre contiennent des affirmations fausses.&lt;/p&gt;&lt;p&gt;Quelle page dit la vérité ?&lt;/p&gt;\" title=\"Le livre fou\" type=\"0\"/><riddle answer=\"21\" answer_type=\"0\" copyright=\"Proposé par Etienne.\" hint=\"&lt;p&gt;Une suite mathématique très connue.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;21.&lt;br/&gt;&lt;br/&gt;Cette suite est celle de Fibonacci, elle additionne les 2 nombres précédents.&lt;/p&gt;\" text=\"&lt;p&gt;Quel est le nombre manquant : &lt;br/&gt;1, 1, 2, 3, 5, 8, 13, ?&lt;/p&gt;\" title=\"Les mathématiques\" type=\"0\"/><riddle answer=\"montre|horloge|heure|reveil|mois|janvier\" answer_type=\"3\" copyright=\"Proposé par Beauval.\" hint=\"&lt;p&gt;Tic tac.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Sur une horloge à cadran, quand l'aiguille indique 11h, elle indiquera 1h si on ajoute 2h.&lt;br/&gt;&lt;br/&gt;Ce cas arrive également pour les mois de l'année (de novembre à janvier).&lt;/p&gt;\" text=\"&lt;p&gt;11 + 2 = 1&lt;/p&gt;&lt;p&gt;Pourquoi ?&lt;/p&gt;\" title=\"Addition inférieure\" type=\"0\"/><riddle answer=\"pere\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Le père de mon fils.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est mon père.&lt;br/&gt;&lt;br/&gt;En remplacant &quot;le père de mon fils&quot; par moi, la solution vient d'elle même.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis un homme. Si le fils de cet autre homme est le père de mon fils, quel est le lien de parenté entre cet homme et moi ?&lt;/p&gt;\" title=\"Qui est là ?\" type=\"0\"/><riddle answer=\"1\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Un vieux réveil&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;1h.&lt;br/&gt;&lt;br/&gt;Le réveil ne différencie pas le matin et l'après-midi. Vous vous êtes donc couché à 9h et il sonne à 10h.&lt;/p&gt;\" text=\"&lt;p&gt;Lors d'une coupure d'électricité, Vous décidez d'utiliser un vieux réveil mécanique pour ne pas arriver en retard le lendemain.&lt;/p&gt;&lt;p&gt;Vous le réglez pour sonner à 10h. A 21h vous allez au lit et vous vous endormez.&lt;/p&gt;&lt;p&gt;Combien de temps (en heures) allez-vous dormir ?&lt;/p&gt;\" title=\"Matin difficile\" type=\"0\"/><riddle answer=\"600\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Moitié fois deux.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;600 stylos.&lt;/p&gt;&lt;p&gt;5% de 600 = 30&lt;br/&gt;Donc 30 personnes ont 1 stylo. Ensuite, moitié de la classe en a 2 et l'autre moitié 0, donc 1 pour chacun.&lt;/p&gt;\" text=\"&lt;p&gt;A un examen, 600 candidats sont présents. Cependant, seul 5% d'entre eux possèdent 1 seul stylo. Parmi les personnes restantes, la moitié ne possède pas de stylo et l'autre moitié en possède 2.&lt;/p&gt;&lt;p&gt;Combien y a-t-il de stylos dans la salle d'examen ?&lt;/p&gt;\" title=\"L'examen\" type=\"0\"/><riddle answer=\"42\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Qui utilise 6cl en une journée ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La famille utilisera 42cl de savon, et non 6x5x7 = 210cl.&lt;/p&gt;\" text=\"&lt;p&gt;Ma famille et moi-même utilisons 6cl de savon par jour.&lt;/p&gt;&lt;p&gt;Sachant qu'avec nos parents, nous sommes 2 frères et 1 soeur, quelle quantité de savon allons-nous utiliser (en cl) en 1 semaine ?&lt;/p&gt;\" title=\"Le savon\" type=\"0\"/><riddle answer=\"veterinai|animau\" answer_type=\"3\" copyright=\"Proposé par Dabladji.\" hint=\"Quelle sorte de patient ?\" image=\"doctor\" solution=\"&lt;p&gt;C'est un vétérinaire.&lt;/p&gt;\" text=\"&lt;p&gt;Un docteur a soigné plus de 80000 patients adultes vivants au cours de sa carrière. Pourtant aucun ne l'a remercié.&lt;/p&gt;&lt;p&gt;Pourquoi ?&lt;/p&gt;\" title=\"Le docteur\" type=\"0\"/><riddle answer=\"dimanche\" answer_type=\"1\" copyright=\"Proposé par Melvyn.\" hint=\"&lt;p&gt;Ils sont partis le lundi...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Ils sont partis le lundi et sont revenus 5 jours après-demain (mardi), soit dimanche.&lt;/p&gt;\" text=\"&lt;p&gt;Un lundi, 3 chevaliers partent 2 jours avant après-demain. Ils reviennent 5 jours après demain.&lt;/p&gt;&lt;p&gt;Quel jour reviennent les 3 chevaliers ?&lt;/p&gt;\" title=\"Les chevaliers\" type=\"0\"/><riddle answer=\"chauffeur|conducteur\" answer_type=\"3\" copyright=\"Proposé par Anthony.\" hint=\"&lt;p&gt;Les personnes présentes, depuis le départ.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est le chauffeur de bus qui n'a pas besoin de payer son ticket.&lt;/p&gt;\" text=\"&lt;p&gt;Un bus pouvant contenir 28 passagers au total s'arrête, sans aucun passager à bord, à un premier arrêt.&lt;/p&gt;&lt;p&gt;Ses caisses de monnaie sont vides et il n'y a aucun passager à bord.&lt;/p&gt;&lt;p&gt;12 personnes montent dans le bus. C'est un jour d'école, pourtant un adolescent monte dans le bus sans sac.&lt;/p&gt;&lt;p&gt;A l'arrêt suivant, 3 personnes descendent du bus et 9 montent. Parmi celles-ci, il y a 3 jeunes femmes chaudement habillées, 5 personnes âgées, dont 2 ont une canne et un homme aux lunettes noires.&lt;/p&gt;&lt;p&gt;Enfin, au dernier arrêt, 10 personnes montent dans le bus mais personne ne descend.&lt;/p&gt;&lt;p&gt;À ce moment, il y a dans les caisses du bus 31€.&lt;/p&gt;&lt;p&gt;Sachant que le ticket de bus, valable pour 1 personne, coûte 1€, et qu'aucun animal n'a emprunté le bus, qui, parmi les personnes ayant été présentes dans le bus, n'a pas payé son ticket ?&lt;/p&gt;\" title=\"Le bus magique\" type=\"0\"/><riddle answer=\"5+545=550|545+5=550|5+545|545+5\" answer_type=\"3\" copyright=\"Proposé par Adrien.\" hint=\"&lt;p&gt;Un signe peut devenir un chiffre.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;5+545=550.&lt;/p&gt;\" text=\"&lt;p&gt;5+5+5=550&lt;/p&gt;&lt;p&gt;Ajoutez un trait pour que cette égalité soit juste.&lt;br/&gt;Le signe différent n'est pas autorisé, celui-ci indiquant une inégalité,&lt;br/&gt;L'égalité doit être réécrite en entier sans espace pour être validée.&lt;/p&gt;\" title=\"La rature\" type=\"0\"/><riddle answer=\"neveu|neuveu\" answer_type=\"3\" copyright=\"Proposé par Lounis.\" hint=\"&lt;p&gt;De quelle nourriture s'agit-il ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est le neveu qui a empoisonné sa tante car il connaissait la nourriture qu'elle avait mangé.&lt;/p&gt;\" text=\"&lt;p&gt;Une riche héritière a été empoisonnée d'une nourriture inconnue.&lt;/p&gt;&lt;p&gt;L'inspecteur, chargé de l'enquête interroge 4 suspects : &lt;/p&gt;&lt;p&gt; - Le chauffeur : Ce n'est pas parce qu'elle vient de me renvoyer que je vais l'empoisonner.&lt;br/&gt; - Le domestique : Je n'ai jamais fait ça, elle était comme une mère pour moi.&lt;br/&gt; - Son neveu : Non ce n'est pas moi, je n'ai pas mis de poison dans la tisane de ma tante.&lt;br/&gt; - Son gendre : Moi? Jamais de la vie!&lt;/p&gt;&lt;p&gt;Qui est le coupable ?&lt;/p&gt;\" title=\"L'empoisonnement\" type=\"0\"/><riddle answer=\"55\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Distance entre les deux divisée par 2.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La navette vole à 55km/h.&lt;/p&gt;&lt;p&gt;Le prochain palindrome est 16061. Ils auront donc parcouru 110km en 2h.&lt;/p&gt;\" text=\"&lt;p&gt;Une fusée a parcouru 15951km dans l'espace depuis son décollage. L'astronaute la pilotant est amusé de voir un palindrome (nombre qui peut se lire dans les deux sens) et annonce à son collègue que dans 2h ils atteindront le prochain palindrome.&lt;/p&gt;&lt;p&gt;Quelle est la vitesse de la navette en km/h?&lt;/p&gt;\" title=\"Le vol interminable\" type=\"0\"/><riddle answer=\"3\" answer_type=\"0\" copyright=\"Proposé par Florian.\" hint=\"&lt;p&gt;Il ne bouge plus.&lt;/p&gt;\" image=\"fish\" solution=\"&lt;p&gt;Il en reste 3, le poisson mort est toujours dans le seau.&lt;/p&gt;\" text=\"&lt;p&gt;Dans un seau d'eau se trouvent 3 poissons, l'un d'eux meurt.&lt;/p&gt;&lt;p&gt;Combien reste-t-il de poissons dans le seau ?&lt;/p&gt;\" title=\"Un petit poisson\" type=\"0\"/><riddle answer=\"1\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;On rassemble.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il n'y aura qu'un seul tas.&lt;/p&gt;\" text=\"&lt;p&gt;Deux jardiniers décident de ramasser les feuilles dans un immense jardin qu'ils entretiennent.&lt;/p&gt;&lt;p&gt;Le premier fait 3 tas en 1h.&lt;br/&gt;Le deuxième fait 4 tas en 2h.&lt;/p&gt;&lt;p&gt;Lorsqu'ils mettront leurs tas en commun au bout de 3h, combien y aura-t-il de tas ?&lt;/p&gt;\" title=\"L'automne\" type=\"0\"/><riddle answer=\"16\" answer_type=\"0\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;16 nombres : &lt;/p&gt;&lt;p&gt;4, 9, 10, 19, 100, 104, 109, 110, 119, 400, 409, 410, 419, 900, 904, 910&lt;/p&gt;\" text=\"&lt;p&gt;Combien de chiffres et de nombres pouvez-vous former avec les mots suivants en les utilisant une fois au maximum par proposition : &lt;/p&gt;&lt;p&gt; - dix,&lt;br/&gt; - neuf,&lt;br/&gt; - cent,&lt;br/&gt; - quatre.&lt;/p&gt;&lt;p&gt;Les nombres écrits sous la forme &quot;dix-huit cent&quot; ne seront pas acceptés. Si un des mots doit être mis au pluriel, il sera juste également.&lt;/p&gt;\" title=\"Nombres français\" type=\"0\"/><riddle answer=\"210\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Enlevez la différence avant de calculer.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La différence par rapport au premier jour est de 25 + 50 + 75 = 150.&lt;/p&gt;&lt;p&gt;990 - 150 = 840&lt;/p&gt;&lt;p&gt;Si elle n'avait pas augmenté le nombre de fléchettes lancées, elle en aurait lancé 840 fléchettes en 4 jours.&lt;/p&gt;&lt;p&gt;Elle a donc lancé 210 fléchettes.&lt;/p&gt;\" text=\"&lt;p&gt;Stéphanie s'entraine au jeu de fléchettes. En 4 jours elle a lancé 990 fléchettes. Chaque jour, elle en a lancé 25 de plus que le jour précédent.&lt;/p&gt;&lt;p&gt;Combien a-t-elle lancé de fléchettes le premier jour ?&lt;/p&gt;\" title=\"Les fléchettes\" type=\"0\"/><riddle answer=\"200\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;A haute voix.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;200€&lt;/p&gt;&lt;p&gt;Le prix est fixé en fonction des syllabes, chacune d'entre-elle vaut 100€.&lt;/p&gt;\" text=\"&lt;p&gt;Marie a ouvert un magasin de musique discount et voici les prix qu'elle affiche : &lt;/p&gt;&lt;p&gt; - Tuba : 200€&lt;br/&gt; - Violoncelle : 300€&lt;br/&gt; - Accordéon : 400€&lt;/p&gt;&lt;p&gt;Quel sera le prix des cloches ?&lt;/p&gt;\" title=\"Discount\" type=\"0\"/><riddle answer=\"101\" answer_type=\"0\" copyright=\"Proposé par Philippe.\" hint=\"&lt;p&gt;L'alphabet.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;101.&lt;/p&gt;&lt;p&gt;Il faut additionner la position de chaque lettre dans l'alphabet.&lt;/p&gt;&lt;p&gt;Exemple pour Chat : &lt;/p&gt;&lt;p&gt;C = 3, H = 8, A = 1, T = 20&lt;/p&gt;&lt;p&gt;3 + 8 + 1 + 20 = 32&lt;/p&gt;\" text=\"&lt;p&gt;Selon les valeurs suivantes : &lt;/p&gt;&lt;p&gt; - Chat = 32&lt;br/&gt; - Chien = 39&lt;br/&gt; - Rat = 39&lt;/p&gt;&lt;p&gt;Quelle sera la valeur de &quot;Souris&quot; ?&lt;/p&gt;\" title=\"L'animal cher\" type=\"0\"/><riddle answer=\"a\" answer_type=\"2\" copyright=\"Proposé par Augustin.\" hint=\"&lt;p&gt;Pas si différente des autres suites.&lt;/p&gt;\" image=\"abc\" solution=\"&lt;p&gt;A.&lt;/p&gt;&lt;p&gt;Chaque lettre représente la première lettre des chiffres en Allemand : &lt;/p&gt;&lt;p&gt;Eins, Zwei, Drei, Vier, Fünf, Sechs, Sieben, Acht&lt;/p&gt;\" text=\"&lt;p&gt;Quelle est la lettre suivante de cette suite logique ?&lt;/p&gt;&lt;p&gt;E, Z, D, V, F, S, S, ?&lt;/p&gt;\" title=\"La suite inhabituelle\" type=\"0\"/><riddle answer=\"bandit|voleur|truant|criminel|dealer|trafiquant\" answer_type=\"3\" copyright=\"Proposé par Bernard.\" hint=\"&lt;p&gt;Suivre les traces peut être pris à la lettre.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est un bandit, et l'homme le suivra pour l'arrêter.&lt;/p&gt;\" text=\"&lt;p&gt;Un homme veut suivre les traces de son cousin et veut devenir policier.&lt;/p&gt;&lt;p&gt;Pourtant, son cousin ne fait pas partie des forces de l'ordre.&lt;/p&gt;&lt;p&gt;Quel est le métier de son cousin ?&lt;/p&gt;\" title=\"Le métier\" type=\"0\"/><riddle answer=\"4\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;N'oubliez pas de prendre en compte les 2 enfants interrogés.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il y a 4 garçons.&lt;/p&gt;&lt;p&gt;x = garçons&lt;/p&gt;&lt;p&gt;y = filles&lt;/p&gt;&lt;p&gt;1) Elle a 2 fois plus de frères que de soeurs : &lt;/p&gt;&lt;p&gt;2(y - 1)= x &lt;/p&gt;&lt;p&gt;2) Il a autant de frères que de sœurs : &lt;/p&gt;&lt;p&gt;x - 1 = y&lt;/p&gt;&lt;p&gt;De ces deux équations on trouve : &lt;/p&gt;&lt;p&gt;2(y - 1) - 1 = y&lt;/p&gt;&lt;p&gt;2y - 3 = y&lt;/p&gt;&lt;p&gt;y = 3&lt;/p&gt;&lt;p&gt;x = 4&lt;/p&gt;&lt;p&gt;4 garçons et 3 filles.&lt;/p&gt;\" text=\"&lt;p&gt;Stéphanie croise 2 enfants qui sont frère et soeur à qui elle demande combien ils ont de frères et soeurs.&lt;/p&gt;&lt;p&gt;La petite fille répond qu'elle a deux fois plus de frères que de sœurs. Le petit dit qu'il a autant de frères que de soeurs.&lt;/p&gt;&lt;p&gt;Combien y a-t-il de garçons dans cette fratrie ?&lt;/p&gt;\" title=\"Les petits enfants\" type=\"0\"/><riddle answer=\"18\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Une simple équation&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;18 ans.&lt;/p&gt;&lt;p&gt;3*(x+3)-3*(x-3) = x&lt;br/&gt;3x + 9 - 3x + 9 = x&lt;br/&gt;x = 18.&lt;/p&gt;\" text=\"&lt;p&gt;Si vous prenez trois fois l'âge que j'aurai dans trois ans et que vous enlevez 3 fois l'âge que j'avais il y a 3 ans, vous aurez mon âge.&lt;/p&gt;&lt;p&gt;Quel est mon âge ?&lt;/p&gt;\" title=\"Mon âge\" type=\"0\"/><riddle answer=\"e\" answer_type=\"2\" copyright=\"Proposé par Julie.\" hint=\"&lt;p&gt;La 7ème et dernière lettre.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;E.&lt;/p&gt;&lt;p&gt;lundI, mardI, mercredI, jeudI, vendredI, samedI, dimanchE.&lt;/p&gt;\" text=\"&lt;p&gt;Quelle est la lettre suivante de cette suite : &lt;/p&gt;&lt;p&gt;i, i, i, i, i, i, ?&lt;/p&gt;\" title=\"La suite infinie\" type=\"0\"/><riddle answer=\"centre|noyau\" answer_type=\"3\" copyright=\"Proposée par Patrick.\" hint=\"&lt;p&gt;L'attraction&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Au centre de la terre (le noyau).&lt;/p&gt;&lt;p&gt;La balle va osciller d'un côté à l'autre de moins en moins à cause des frottements puis va s'arrêter au centre du noyau où la gravité est nulle.&lt;/p&gt;\" text=\"&lt;p&gt;Un puisatier fou arrive à creuser un puits de plus en plus profond en plein cœur de Paris. On suppose qu'il arrive à creuser diamétralement la Terre de part en part.&lt;/p&gt;&lt;p&gt;On lâche une balle indestructible dans le puits, où celle-ci va-t-elle aller ? (La balle n'est pas lancée au centre et rebondit sur les parois)&lt;/p&gt;\" title=\"Puisatier\" type=\"0\"/><riddle answer=\"grand|plus\" answer_type=\"3\" copyright=\"Proposée par Leucosia.\" hint=\"&lt;p&gt;Votre terrain et son terrain.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le terrain de votre voisin a une plus grande surface.&lt;/p&gt;\" text=\"&lt;p&gt;Cette nuit il a neigé sur tout le village. Pourtant, lorsque vous regardez par la fenêtre, vous voyez qu'il y a deux fois plus de neige dans le terrain de votre voisin.&lt;/p&gt;&lt;p&gt;Pourquoi ?&lt;/p&gt;\" title=\"La neige\" type=\"0\"/><riddle answer=\"1072280\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;0 + 0 = 0&lt;/p&gt;\" image=\"manger\" solution=\"&lt;p&gt;536140 + 536140 = 1072280&lt;br/&gt;&lt;br/&gt;M = 5&lt;br/&gt;A = 3&lt;br/&gt;N = 6&lt;br/&gt;G = 1&lt;br/&gt;E = 4&lt;br/&gt;R = 0&lt;br/&gt;S = 2&lt;br/&gt;I = 8.&lt;br/&gt;&lt;br/&gt;Démonstration : &lt;br/&gt;&lt;br/&gt;   MANGER&lt;br/&gt;+  MANGER&lt;br/&gt;---------&lt;br/&gt;= GROSSIR&lt;br/&gt;&lt;br/&gt;Toutes les lettres sont forcéments inférieures à 10.&lt;br/&gt; &lt;br/&gt;R + R = R&lt;br/&gt;Seule possibilité : R = 0&lt;br/&gt; &lt;br/&gt;M + M = GR&lt;br/&gt;R = 0&lt;br/&gt;G = 1 (Il ne peut être supérieur, le maximum possible étant 9 + 9 = 18)&lt;br/&gt;Donc M = 5&lt;br/&gt;&lt;br/&gt;G + G = S&lt;br/&gt;G = 1 donc S = 2 ou 3 si il y a une retenue.&lt;br/&gt;N est différent de G&lt;br/&gt; &lt;br/&gt;On en déduit que N + N n'a pas de retenu en plus possible&lt;br/&gt; &lt;br/&gt;Mais N + N est différent de G + G, le même chiffre ne pouvant correspondre à 2 lettres différentes.&lt;br/&gt;La seule possibilité est donc &lt;br/&gt; - S = 2&lt;br/&gt; - N + N = 12&lt;br/&gt; - N = 6&lt;br/&gt; &lt;br/&gt;A ce stade nous avons donc : &lt;br/&gt;   5A61E0&lt;br/&gt;+  5A61E0&lt;br/&gt;--------&lt;br/&gt;= 10O22I0&lt;br/&gt;avec une retenue sur le A.&lt;br/&gt; &lt;br/&gt;On sait que A et E sont inférieur à 5.&lt;br/&gt;Il reste 3 et 4 comme possibilité.&lt;br/&gt;Si E = 3, alors I = 6, ce qui n'est pas possible car N = 6.&lt;br/&gt;Donc E = 4, I = 8&lt;br/&gt;A = 3.&lt;/p&gt;\" text=\"&lt;p&gt;Sachant que chaque lettre représente un chiffre unique, quelle est la valeur de GROSSIR ?&lt;/p&gt;\" title=\"Le régime\" type=\"0\"/><riddle answer=\"miroir|mirroir\" answer_type=\"3\" copyright=\"Proposée par Vincent.\" hint=\"&lt;p&gt;Tous les matins on utilise un objet qui permet ceci.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il y a un miroir dans la pièce.&lt;/p&gt;\" text=\"&lt;p&gt;Une personne est au milieu d'une pièce.&lt;/p&gt;&lt;p&gt;Lorsqu'elle regarde la porte, elle ne voit que la moitié de la pièce, mais lorsqu'elle se met dos à la porte au milieu de la pièce, elle voit la pièce dans son intégralité.&lt;/p&gt;&lt;p&gt;Comment cela est-il possible ?&lt;/p&gt;\" title=\"La pièce\" type=\"0\"/><riddle answer=\"casque|cheveu\" answer_type=\"3\" copyright=\"Proposée par Philippe.\" hint=\"&lt;p&gt;Les cheveux&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il a dit qu'ils avaient des casques, il n'aurait pas pu voir leurs cheveux.&lt;/p&gt;\" text=\"&lt;p&gt;Quelqu'un est accusé d'avoir fait des tags sur un train et essaie de s'en tirer. Il dit au commissaire :&lt;/p&gt;&lt;p&gt; - Je n'y suis pour rien, ce n'est pas moi. Par contre, j'ai vu 2 personnes s'enfuir à moto.&lt;/p&gt;&lt;p&gt;Le commissaire lui pose alors quelques questions et lui demande de raconter les détails qu'il a vus : &lt;/p&gt;&lt;p&gt; - Ils sont partis tous les deux en motos avec leurs gants, leurs casques sur la tête et une espèce de bombe dans les gants.&lt;/p&gt;&lt;p&gt;Le commissaire lui demande alors plus de détails, comme la couleur de leurs yeux par exemple : &lt;/p&gt;&lt;p&gt; - L'un avait les yeux bleus et était blond, l'autre avait les yeux marrons et était brun.&lt;/p&gt;&lt;p&gt;Le commissaire l'arrête alors immédiatement voyant qu'il a menti.&lt;/p&gt;&lt;p&gt;Qu'est-ce qui a trahi le jeune homme?&lt;/p&gt;\" title=\"Le train graffé\" type=\"0\"/><riddle answer=\"4\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Attention à ne pas tout multiplier.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;4 minutes, il y 10 fois plus de personnes, ils portent donc 10 fois plus de livres durant le même intervalle de temps.&lt;/p&gt;\" text=\"&lt;p&gt;Marie-Jo a besoin d'aide pour déplacer sa collection de livres au grenier. 2 personnes déplacent 10 livres en 4 minutes.&lt;/p&gt;&lt;p&gt;Si 20 personnes sont présentes, combien faudra-t-il de temps pour déplacer 100 livres ?&lt;/p&gt;\" title=\"La bibliothèque\" type=\"0\"/><riddle answer=\"22h00\" answer_type=\"2\" copyright=\"Proposée par Erwan.\" hint=\"&lt;p&gt;A l'envers.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;22h00.&lt;/p&gt;&lt;p&gt;Le passant avait sa montre à l'envers.&lt;/p&gt;\" text=\"&lt;p&gt;Martin demande à un passant l'heure qu'il est.&lt;/p&gt;&lt;p&gt;Celui-ci lui répond &quot;minuit vingt-deux&quot;.&lt;/p&gt;&lt;p&gt;Cependant, Martin sait que ce n'est pas la bonne heure, que le passant a eu l'impression de lui donner la bonne mais qu'il a fait une erreur avec sa montre numérique.&lt;/p&gt;&lt;p&gt;Quelle heure est-il ?&lt;/p&gt;&lt;p&gt;(L'heure doit être notée sous la forme 12h34)&lt;/p&gt;\" title=\"Quelle heure est-il ?\" type=\"0\"/><riddle answer=\"0\" answer_type=\"0\" copyright=\"Proposée par Florian.\" hint=\"&lt;p&gt;Dans un trou.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;0, un trou est vide par définition.&lt;/p&gt;\" text=\"&lt;p&gt;Combien y a-t-il de mètres cube de terre dans un trou de 10 mètres de profondeur, 10 mètres de largeur et 10 mètres de longueur ?&lt;/p&gt;\" title=\"Dig\" type=\"0\"/><riddle answer=\"6\" answer_type=\"0\" copyright=\"Proposée par Dédé.\" hint=\"&lt;p&gt;10% de 30%.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il y a 6 femelles poissons rouges.&lt;/p&gt;&lt;p&gt;60 poissons rouges en tout (200*30%).&lt;/p&gt;\" text=\"&lt;p&gt;Dans un aquarium, il y a 200 poissons. Jean a remarqué que 30% des poissons étaient des poissons rouges et il sait que parmi ces derniers, 10% sont des femelles.&lt;/p&gt;&lt;p&gt;Combien y a-t-il de poissons rouges femelles ?&lt;/p&gt;\" title=\"L'aquarium\" type=\"0\"/><riddle answer=\"32\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Attention aux coins.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;32 piquets.&lt;/p&gt;&lt;p&gt;9 piquets par côté, il faut bien penser à ne pas doubler les coins, donc 9x2+7x2.&lt;/p&gt;\" text=\"&lt;p&gt;Jean a offert un chien à sa fille. Cependant, il va devoir clôturer son terrain pour éviter qu'il ne s'échappe. Cette partie sera un carré qui fera 8 mètres par côtés.&lt;/p&gt;&lt;p&gt;Sachant qu'il faut planter un piquet tous les mètres, combien de piquets vont être nécessaires ?&lt;/p&gt;\" title=\"Clôture\" type=\"0\"/><riddle answer=\"amant|cocu|autre\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Mariés ensembles ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Ils sont amants.&lt;/p&gt;&lt;p&gt;Yohan veut divorcer mais pas de Chloé.&lt;/p&gt;\" text=\"&lt;p&gt;Chloé et Yohan sont mariés et s'aiment à la folie. Un jour Yohan annonce à Chloé qu'il veut divorcer et celle-ci est très contente.&lt;/p&gt;&lt;p&gt;Pourquoi ?&lt;/p&gt;\" title=\"Amour complexe\" type=\"0\"/><riddle answer=\"48\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Intervalle piège ou non&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;48.&lt;/p&gt;&lt;p&gt;Après le 48ème rayon, on retrouve le 1er rayon. Il n'y a donc pas d'intervalle supplémentaire.&lt;/p&gt;\" text=\"&lt;p&gt;Une roue de vélo a 48 rayons.&lt;/p&gt;&lt;p&gt;Combien y a-t-il d'espaces entre les rayons sur toute la roue ?&lt;/p&gt;\" title=\"Le vélo\" type=\"0\"/><riddle answer=\"34\" answer_type=\"0\" copyright=\"Proposée par Jean-Claude.\" hint=\"&lt;p&gt;11, 22, 33...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;34 ans.&lt;/p&gt;&lt;p&gt;Les multiples sont 11, 22, 33, 44, 55, 66, 77, 88, 99, 110.&lt;/p&gt;&lt;p&gt;Elle a au moins 30 ans. Donc l'homme a au moins 50 ans. 30 + 50 = 80.&lt;/p&gt;&lt;p&gt;Donc pour 88, nous avons 34 et 54.&lt;/p&gt;&lt;p&gt;99 est un nombre impair donc nous n'aurons pas de nombres entiers.&lt;/p&gt;&lt;p&gt;Pour 110, nous aurons 45 et 65.&lt;/p&gt;\" text=\"&lt;p&gt;Un homme a 20 ans de plus que sa femme.&lt;/p&gt;&lt;p&gt;Sachant que la somme de leurs âges est un multiple de 11 et que la femme a au moins 30 ans, quel est l'âge de celle-ci au minimum (les âges sont des nombres entiers) ?&lt;/p&gt;\" title=\"Le couple chiffré\" type=\"0\"/><riddle answer=\"jeudi\" answer_type=\"1\" copyright=\"Proposée par Dédé.\" hint=\"&lt;p&gt;Le zèbre ment.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Jeudi.&lt;/p&gt;&lt;p&gt;Si le zèbre dit la vérité (lundi, mardi, mercredi et dimanche), la seule possibilité est que l'on est dimanche.&lt;/p&gt;&lt;p&gt;Mais le dimanche le lion dit la vérité et il ne ment pas le samedi.&lt;/p&gt;&lt;p&gt;Si on suppose que le lion dit la vérité (jeudi, vendredi, samedi, dimanche) alors seul jeudi est possible.&lt;/p&gt;&lt;p&gt;Ils ne peuvent mentir en même temps ni dire la vérité en même temps.&lt;/p&gt;\" text=\"&lt;p&gt;Le lion ment le lundi, le mardi et le mercredi.&lt;br/&gt;Le zèbre ment le jeudi, le vendredi et le samedi.&lt;br/&gt;Les autres jours ils disent la vérité.&lt;/p&gt;&lt;p&gt;Un jour, le zèbre affirme &quot;Hier je mentais&quot;. Le lion lui répond alors &quot;Ah oui ? Moi aussi&quot;.&lt;/p&gt;&lt;p&gt;Quel jour sommes-nous ?&lt;/p&gt;\" title=\"La savane\" type=\"0\"/><riddle answer=\"glaçon|glacon|glasson|glason\" answer_type=\"3\" copyright=\"Proposée par Romain.\" hint=\"&lt;p&gt;Pas eu le temps.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le poison était dans les glaçons. Ils n'ont pas eu le temps de fondre.&lt;/p&gt;\" text=\"&lt;p&gt;Un homme d'affaire réputé est invité à une conférence. Après celle-ci, l'ensemble des participants est invité à prendre un verre au bar. L'établissement offre à chacun des invités un cocktail à base de Pastis, de citron vert et d'eau, servi avec quelques glaçons dans un grand verre aux couleurs tropicales.&lt;/p&gt;&lt;p&gt;L'homme d'affaire prend un verre mais il est appelé au téléphone. Il boit alors son verre rapidement, part répondre au téléphone et s'en va pour une affaire urgente.&lt;/p&gt;&lt;p&gt;Le lendemain, il apprend par les médias que toutes les personnes qu'il avait côtoyées au bar sont mortes empoisonnées.&lt;/p&gt;&lt;p&gt;Le barman est soupçonné d'avoir empoisonné tout le monde et il a été arrêté sur le champ.&lt;/p&gt;&lt;p&gt;Pourquoi l'homme d'affaire n'est-il pas mort ?&lt;/p&gt;\" title=\"Empoisonner\" type=\"0\"/><riddle answer=\"v\" answer_type=\"2\" copyright=\"Proposée par Ravi.\" hint=\"&lt;p&gt;Une lettre.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La lettre V.&lt;/p&gt;\" text=\"&lt;p&gt; - Tous les voleurs me possèdent,&lt;br/&gt; - Je viens en premier dans les vengeances,&lt;br/&gt; - Tous les devins m'utilisent,&lt;br/&gt; - Les savants ne peuvent se passer de moi,&lt;br/&gt; - Car je suis le centre de gravité.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"A tous\" type=\"0\"/><riddle answer=\"185\" answer_type=\"0\" copyright=\"Proposée par Candice.\" hint=\"&lt;p&gt;4 colliers de 17 perles.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;185€ avec 4 colliers de 17 perles et 7 de 13 perles.&lt;/p&gt;\" text=\"&lt;p&gt;Vous avez 159 perles et vous savez fabriquer des colliers de 17 et 13 perles.&lt;/p&gt;&lt;p&gt;Sachant qu'un collier de 17 perles se vend 20€ et 15€ celui de 13 perles.&lt;/p&gt;&lt;p&gt;Combien vous rapportera la vente des colliers que vous allez fabriquer ?&lt;/p&gt;&lt;p&gt;Toutes les perles devront être utilisées.&lt;/p&gt;\" title=\"Des colliers\" type=\"0\"/><riddle answer=\"4\" answer_type=\"2\" copyright=\"\" hint=\"&lt;p&gt;4ième symbole.&lt;/p&gt;\" image=\"r1234\" solution=\"&lt;p&gt;C'est le chiffre 4.&lt;/p&gt;&lt;p&gt;Les 3 premiers symboles sont les chiffres 1, 2 et 3 avec leur miroir.&lt;/p&gt;\" text=\"&lt;p&gt;Quel symbole permettra de réaliser le dessin suivant de la suite ?&lt;/p&gt;\" title=\"Symbolique\" type=\"0\"/><riddle answer=\"323264\" answer_type=\"0\" copyright=\"Proposée par Dylan\" hint=\"&lt;p&gt;Addition.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;323264 &lt;/p&gt;&lt;p&gt;2+2=4 -&gt; 224&lt;/p&gt;&lt;p&gt;4+4=8 -&gt; 448&lt;/p&gt;&lt;p&gt;8+8=16 -&gt; 8816&lt;/p&gt;&lt;p&gt;16+16=32 -&gt; 161632&lt;/p&gt;&lt;p&gt;32+32=64 -&gt; 323264&lt;/p&gt;\" text=\"&lt;p&gt;Quelle est le nombre suivant de cette suite logique&lt;/p&gt;&lt;p&gt;224, 448, 8816, 161632, ?&lt;/p&gt;\" title=\"Grow grow grow\" type=\"0\"/><riddle answer=\"12\" answer_type=\"0\" copyright=\"Proposée par Dédé.\" hint=\"&lt;p&gt;x+2&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;J'ai 12 ans.&lt;/p&gt;&lt;p&gt;Dans 2 ans : X+2&lt;/p&gt;&lt;p&gt;J'aurais 2 fois l'âge que j'avais il y a 5 ans : (X-5)*2&lt;/p&gt;&lt;p&gt;Donc : X+2=(X-5)*2&lt;/p&gt;&lt;p&gt;X = 12&lt;/p&gt;\" text=\"&lt;p&gt;Dans 2 ans, j'aurai 2 fois l'âge que j'avais il y a 5 ans.&lt;/p&gt;&lt;p&gt;Quel est mon âge ?&lt;/p&gt;\" title=\"Age tordu\" type=\"0\"/><riddle answer=\"100\" answer_type=\"0\" copyright=\"Proposée par Victor Boyer\" hint=\"&lt;p&gt;Qu'est-ce qui est demandé ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il ramasse 100 pièces, ce n'est pas la valeur qui est demandée.&lt;/p&gt;\" text=\"&lt;p&gt;Un pirate arrive sur une ile. Le tour de l'ile mesure 100 mètres. Tous les mètre, il y a une pièce. La première pièce vaut 50 centimes, puis la seconde, la troisième et la quatrième valent 1€, enfin, la cinquième, la sixième, la septième et la huitième valent 2€, puis ça recommence. Le pirate a tout ramassé et sur son bateau il compte ses pièces.&lt;/p&gt;&lt;p&gt;Combien le pirate a-t-il ramasser de pièces sur cette île ?&lt;/p&gt;\" title=\"Pirate!!!\" type=\"0\"/><riddle answer=\"250\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Moitié moins de poules pour moitié moins de temps.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;250. Si 500 poules pondent 500 oeufs en 10 jours, elles en pondront la moitié en 5 jours.&lt;/p&gt;\" text=\"&lt;p&gt;1000 poules pondent 1000 oeufs en 10 jours.&lt;/p&gt;&lt;p&gt;Combien 500 poules pondent d'oeufs en 5 jours ? (On suppose qu'elles ne mettent pas 10 jours à pondre un oeuf)&lt;/p&gt;\" title=\"La grande ponte\" type=\"1\"/><riddle answer=\"homme|femme|humain|hummain\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Prendre de l'âge fait varier certaines données.&lt;/p&gt;\" image=\"sphinx\" solution=\"&lt;p&gt;Le bébé marche à 4 pattes.&lt;br/&gt;L'adulte marche sur ses 2 jambes.&lt;br/&gt;Le vieillard a besoin d'une canne.&lt;br/&gt;&lt;br/&gt;C'est donc l'homme.&lt;/p&gt;\" text=\"&lt;p&gt;Cette énigme a été posée par le Sphinx à Oedipe arrivant à la ville de Thèbes.&lt;/p&gt;&lt;p&gt;Qu'est ce qui a 4 pattes le matin, 2 le midi et 3 le soir ?&lt;/p&gt;\" title=\"L'énigme du Sphinx\" type=\"1\"/><riddle answer=\"13112221\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Mieux vaut lire distinctement les chiffres.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;A la dernière étape, il y avait : &lt;br/&gt;un 3,&lt;br/&gt;un 1,&lt;br/&gt;deux 2,&lt;br/&gt;et deux 1.&lt;br/&gt;&lt;br/&gt;Donc 13112221.&lt;/p&gt;\" text=\"&lt;p&gt;Trouvez l'étape suivante de cette suite logique : &lt;/p&gt;&lt;p&gt;1&lt;br/&gt;11&lt;br/&gt;21&lt;br/&gt;1211&lt;br/&gt;111221&lt;br/&gt;312211&lt;/p&gt;\" title=\"La suite logique\" type=\"1\"/><riddle answer=\"8\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;La chute n'est pas tous les jours nécessaire.&lt;/p&gt;\" image=\"snail\" solution=\"&lt;p&gt;8 jours : le dernier jour, il monte de 3 mètres et ne redescend pas vu qu'il est arrivé.&lt;/p&gt;\" text=\"&lt;p&gt;Un escargot est tombé dans un puits de 10m de profondeur et essaye de le remonter.&lt;br/&gt;Chaque jour il monte de 3 mètres et glisse de 2 mètres pendant la nuit.&lt;/p&gt;&lt;p&gt;Combien de jours va-t-il lui falloir pour remonter à la surface ?&lt;/p&gt;\" title=\"L'escargot glisseur\" type=\"1\"/><riddle answer=\"0\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Il ne faut pas hésiter à parcourir toutes les lettres de l'alphabet.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le résultat est 0, ...(x - w)(x - x)(x - y)... = 0.&lt;br/&gt;&lt;br/&gt;(x - x) = 0, ce membre du produit annule tout le reste.&lt;/p&gt;\" text=\"&lt;p&gt;Quel est le résultat de ce produit : &lt;/p&gt;&lt;p&gt;(x - a)(x - b)(x - c)....(x - z) ?&lt;/p&gt;&lt;p&gt;Le produit s'étend avec les 26 lettres de l'alphabet, celles-ci étant des nombres réels.&lt;/p&gt;\" title=\"Calcul de produit\" type=\"1\"/><riddle answer=\"15\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Si 70% portent un pull bleu, combien n'en portent pas ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Pour trouver le minimum, il faut trouver le pire des cas : &lt;br/&gt;&lt;br/&gt;30% n'ont pas de pull bleu&lt;br/&gt;25% n'ont pas de pantalon bleu&lt;br/&gt;15% n'ont pas de chapeau bleu&lt;br/&gt;15% n'ont pas de manteau bleu.&lt;br/&gt;&lt;br/&gt;Donc dans le pire des cas, 85% des filles ne sont pas complètement habillées en bleu. On en déduit qu'il y a minimum 15% des filles qui ont une tenue assortie.&lt;/p&gt;\" text=\"&lt;p&gt;Dans un groupe de filles,&lt;/p&gt;&lt;p&gt;70% portent un pull bleu,&lt;br/&gt;75% portent un pantalon bleu,&lt;br/&gt;85% portent un chapeau bleu,&lt;br/&gt;85% portent un manteau bleu.&lt;/p&gt;&lt;p&gt;Quel pourcentage minimum de filles ne portent que des vêtements bleus ?&lt;/p&gt;\" title=\"Le groupe de filles\" type=\"1\"/><riddle answer=\"e\" answer_type=\"2\" copyright=\"\" hint=\"&lt;p&gt;Il faudra bien lire l'énigme pour pouvoir la résoudre.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La lettre &quot;e&quot;.&lt;/p&gt;\" text=\"&lt;p&gt;Il n'y en a qu'un seul dans une minute, deux dans une heure. Mais aucun dans un jour.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Composant temporel\" type=\"1\"/><riddle answer=\"1\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Que font les 7 femmes et l'homme ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;1.&lt;br/&gt;&lt;br/&gt;Le narrateur est la seule personne qui se rend à l'église. Il croise les autres personnes sur son chemin.&lt;/p&gt;\" text=\"&lt;p&gt;Me rendant à l'église ce dimanche, j'ai croisé 1 homme et 7 femmes, chaque femme possédant 1 sac à main, chaque sac à main contenant une chatte, chaque chatte possédant 7 chatons.&lt;/p&gt;&lt;p&gt;Combien de personnes vont à la messe ?&lt;/p&gt;\" title=\"L'église\" type=\"1\"/><riddle answer=\"1\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Quel est l'élément nécessaire à la reproduction ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une souris seule ne peut pas se reproduire. Vous n'aurez donc toujours qu'une souris dans 10 mois.&lt;/p&gt;\" text=\"&lt;p&gt;Vous possédez une souris depuis 1 an.&lt;br/&gt;Sachant qu'une souris peut produire 18 souris chaque mois à partir de 2 mois, combien posséderez-vous de souris au bout de 10 mois ?&lt;/p&gt;\" title=\"La souris\" type=\"1\"/><riddle answer=\"noir\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;C'est la réponse du deuxième qui donne l'indice le plus important.&lt;/p&gt;\" image=\"hat\" solution=\"&lt;p&gt;Le dernier n'aurait pu deviner que si les 2 devants lui étaient blancs. Il voit donc soit 2 noirs, soit 1 blanc et 1 noir (et inversement).&lt;br/&gt;Le deuxième répond non, c'est donc qu'il voit un chapeau noir devant lui. S'il avait vu un chapeau blanc, il aurait pu deviner sa couleur avec la réponse négative du troisième (qui aurait vu un noir sur sa tête et non sur le premier).&lt;br/&gt;&lt;br/&gt;Le chapeau est donc noir.&lt;/p&gt;\" text=\"&lt;p&gt;3 hommes entrent dans une pièce noire et choisissent chacun un chapeau parmi un lot de 3 noirs et 2 blancs. Ils ressortent de la pièce en file indienne sans pouvoir voir la couleur de leur propre chapeau. Ils ne peuvent regarder que ceux qui sont devant eux.&lt;/p&gt;&lt;p&gt;On demande au dernier s'il peut dire la couleur du sien et répond que 'non'. La même question est posée à celui du milieu qui répond également 'non'. Le premier de la file, n'ayant vu aucun chapeau, répond qu'il connait la couleur du sien.&lt;/p&gt;&lt;p&gt;Quelle est la couleur du chapeau du premier de la file ?&lt;/p&gt;\" title=\"Les chapeaux\" type=\"1\"/><riddle answer=\"12\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;La vitesse de l'eau n'a peut être pas tant d'influence.&lt;/p&gt;\" image=\"hat\" solution=\"&lt;p&gt;La vitesse d'écoulement du fleuve ne rentre pas en compte dans le calcul car elle agit sur le bateau et sur le chapeau.&lt;br/&gt;En 6 minutes, elle a parcouru (4500*6)/60 = 450 mètres. Elle mettra donc le même temps à remonter le fleuve, soit 12 minutes en tout.&lt;/p&gt;\" text=\"&lt;p&gt;Marie est sur son bateau qui avance à une vitesse de 4,5km/h par rapport au fleuve qui lui coule à 0,5km/h&lt;/p&gt;&lt;p&gt;A 14h elle fait tomber son chapeau dans l'eau mais ne s'en rend compte qu'à 14h06. Elle décide alors de remonter le fleuve pour le récupérer.&lt;/p&gt;&lt;p&gt;Combien de minutes a-t-elle passé sans son chapeau ?&lt;/p&gt;\" title=\"Le chapeau sur l'eau\" type=\"1\"/><riddle answer=\"35\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Cherchez dans tous les sens.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La somme de chaque colonne vaut 88.&lt;br/&gt;88-53 = 35&lt;/p&gt;\" text=\"&lt;p&gt;Trouvez le nombre manquant : &lt;/p&gt;&lt;p&gt;13 25 53 44 67&lt;br/&gt;75 63 ?? 44 21&lt;/p&gt;\" title=\"Le chiffre manquant\" type=\"1\"/><riddle answer=\"12\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Essayez de poser le système d'équation.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il faut réussir à poser le système d'équation suivante (x = mon âge, y = l'âge de mon frère) : &lt;br/&gt;y-6=(x-6)*2&lt;br/&gt;x+5+y+5=40&lt;br/&gt;&lt;br/&gt;De là, on déduit facilement x = 12&lt;/p&gt;\" text=\"&lt;p&gt;Il y a 6 ans, mon frère avait le double de l'âge que j'avais.&lt;br/&gt;Dans 5 ans, nous aurons à nous deux 40 ans.&lt;/p&gt;&lt;p&gt;Quel est mon âge ?&lt;/p&gt;\" title=\"Mon frère et moi\" type=\"1\"/><riddle answer=\"15\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Essayez de trouver la suite logique avec 2 et 3 plateaux.&lt;/p&gt;\" image=\"hanoi\" solution=\"&lt;p&gt;Le nombre de déplacements minimum nécessaires à la résolution d'une tour d'Hanoï est de (2^n)-1, avec n le nombre de plateaux.&lt;br/&gt;Il faudra donc 15 coups minimum pour 4 plateaux.&lt;/p&gt;\" text=\"&lt;p&gt;Combien faudra-t-il de coups nécessaires au minimum pour déplacer tous les disques de la tige de gauche vers la tige de droite sachant que : &lt;/p&gt;&lt;p&gt;On ne peut déplacer les disques que un par un,&lt;br/&gt;On ne peut mettre un disque plus grand sur un plus petit.&lt;/p&gt;\" title=\"La tour d'Hanoï\" type=\"1\"/><riddle answer=\"dimanche\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Essayez d'éliminer les jours un par un.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les jours sont tous éliminés sauf le Dimanche.&lt;/p&gt;\" text=\"&lt;p&gt;Si nous ne sommes pas le lendemain de lundi ou le jour avant jeudi, que demain n'est pas dimanche, que ce n'était pas dimanche hier et que le jour d'après-demain n'est pas samedi, et que le jour avant hier n'était pas mercredi, quel jour sommes-nous ?&lt;/p&gt;\" title=\"Le jour J\" type=\"1\"/><riddle answer=\"270\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Quels sièges se trouvent aux extrémités ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Au moment où le siège 95 croise le 105, le n°100 se trouve à l'extrémité.&lt;br/&gt;On peut également déduire de la même façon que le 235 se trouve à l'autre extrémité.&lt;br/&gt;On peut donc déduire qu'il y a 135x2=270 sièges.&lt;/p&gt;\" text=\"&lt;p&gt;Au Mont Blanc se trouve un télésiège, au moment où le siège n°95 croise le n°105, le n°240 croise le n°230. (On sait que les sièges sont régulièrement espacés et numérotés dans l'ordre à partir du n°1).&lt;/p&gt;&lt;p&gt;Combien de sièges composent ce télésiège ?&lt;/p&gt;\" title=\"Les télésièges\" type=\"1\"/><riddle answer=\"8\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Attention, 1 personne ne peut trinquer avec elle-même.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Chaque personne trinque avec n-1 personnes, sachant que si Pierre trinque avec Paul, Paul n'aura pas à trinquer avec Pierre. Donc n*(n-1)/2 tintements.&lt;br/&gt;&lt;br/&gt;Il y avait donc 8 convives.&lt;/p&gt;\" text=\"&lt;p&gt;A une soirée, lors de trinquer, 28 tintements de verres se font entendre.&lt;/p&gt;&lt;p&gt;Combien y avait-il de convives à cette soirée ?&lt;/p&gt;\" title=\"La soirée\" type=\"1\"/><riddle answer=\"5\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Comptez d'abord le nombre de cousines qu'ils ont en communs&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Pierre a 5 soeurs.&lt;/p&gt;&lt;p&gt;Sylvie a 13 cousines, 3 ne sont pas de la famille de Pierre.&lt;/p&gt;&lt;p&gt;Ceci implique que Pierre a donc en tout 10 soeurs et cousines&lt;/p&gt;&lt;p&gt;Pierre a 8 cousines dont 2 ne sont pas de la famille de Sylvie.&lt;/p&gt;&lt;p&gt;Il en reste donc 6 en rapport avec Sylvie moins Sylvie elle-même donc 5.&lt;/p&gt;&lt;p&gt;Pierre a donc 10 - 5 = 5 soeurs.&lt;/p&gt;\" text=\"&lt;p&gt;Sylvie, qui n'a pas de soeur, a treize cousines. Son cousin Pierre a huit cousines.&lt;br/&gt;Trois des cousines de Sylvie ne sont pas de la famille de Pierre ; deux des cousines de Pierre ne sont pas de la famille de Sylvie.&lt;/p&gt;&lt;p&gt;Combien Pierre a t-il de soeurs ?&lt;/p&gt;\" title=\"Les cousines\" type=\"1\"/><riddle answer=\"mere|maman|mmemar\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;La famille au grand complet.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le chirurgien est sa mère.&lt;/p&gt;\" text=\"&lt;p&gt;M. Martin et son fils sont en voiture.&lt;/p&gt;&lt;p&gt;Cependant, M. Martin a un accident. Il meurt sur le coup et son fils doit être amené à l'hôpital d'urgence.&lt;br/&gt;Mais, en voyant le fils Martin, le chirurgien s'écrie : &quot;Je ne peux pas l'opérer! C'est mon fils!&quot;&lt;/p&gt;&lt;p&gt;Qui est le médecin ?&lt;/p&gt;\" title=\"Le chirurgien\" type=\"1\"/><riddle answer=\"qs\" answer_type=\"2\" copyright=\"\" hint=\"&lt;p&gt;Il faut bien lire.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;On prend à chaque fois la première et dernière lettre du nombre : &lt;br/&gt;Quatre-vingt troiS&lt;br/&gt;&lt;br/&gt;QS.&lt;/p&gt;\" text=\"&lt;p&gt;Quelles sont les 2 lettres manquantes à la suite : &lt;/p&gt;&lt;p&gt;27 VT&lt;br/&gt;54 CE&lt;br/&gt;32 TX&lt;br/&gt;83 ??&lt;/p&gt;\" title=\"Les lettres\" type=\"1\"/><riddle answer=\"1\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Calculez le volume.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La première excavation représente 8x8x8 soit 512 mètre cube de terre.&lt;br/&gt;4x4x4 = 64 mètre cube.&lt;br/&gt;&lt;br/&gt;Il mettra donc 8 fois moins de temps soit 1 jour.&lt;/p&gt;\" text=\"&lt;p&gt;Un ouvrier met 8 jours pour creuser une excavation de 8m de long sur 8m de large et profonde de 8m.&lt;/p&gt;&lt;p&gt;Combien de jours mettra-t-il pour creuser une cavité de 4m de long, 4m de large et de 4m de profondeur ?&lt;/p&gt;\" title=\"Le trou\" type=\"1\"/><riddle answer=\"e\" answer_type=\"2\" copyright=\"\" hint=\"&lt;p&gt;Pas très différent des autres énigmes sur les suites logiques&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La suite représente la première lettre de chaque chiffre en anglais.&lt;br/&gt;&lt;br/&gt;La lettre suivante est donc le E de Eight.&lt;/p&gt;\" text=\"&lt;p&gt;Quelle est la lettre suivante :&lt;/p&gt;&lt;p&gt;O, T, T, F, F, S, S, ?&lt;/p&gt;\" title=\"La lettre suivante\" type=\"1\"/><riddle answer=\"6\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Vous pouvez maximiser le nombre de lapins possible puis descendre pour trouver la bonne solution.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Soit L le nombre de lapins et C le nombre de canards.&lt;br/&gt;On pose le système d'équations : &lt;br/&gt;L + C = 8&lt;br/&gt;L x 4 + C x 2 = 28&lt;br/&gt;&lt;br/&gt;En résolvant l'équation, on trouve que la basse-cour contient 6 lapins et 2 canards.&lt;/p&gt;\" text=\"&lt;p&gt;Dans la basse-cour de Jeannine et Jeannot, on trouve des canards et des lapins. Ils décident de les compter.&lt;/p&gt;&lt;p&gt; Jeannine a compté 8 têtes.&lt;br/&gt;Jeannot a compté 28 pattes.&lt;/p&gt;&lt;p&gt;Combien y a-t-il de lapins ?&lt;/p&gt;\" title=\"La basse-cour\" type=\"1\"/><riddle answer=\"150\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Ils se rencontreront au bout de 5 heures&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La mouche aura volé autant de temps que les randonneurs auront marché.&lt;br/&gt;&lt;br/&gt;Donc 5 heures à 30 km/h, soit 150 km.&lt;/p&gt;\" text=\"&lt;p&gt;Deux randonneurs marchant à 5 km/h partent en même temps sur le chemin Henri IV, l'un partant de Lourdes, l'autre de Pau, soit une distance de 50 km.&lt;br/&gt;Ça amuse beaucoup une petite mouche qui volant à 30 km/h, passe de l'un à l'autre.&lt;/p&gt;&lt;p&gt;Combien de kilomètres aura parcouru la mouche lorsqu'ils se rencontreront ?&lt;/p&gt;\" title=\"La mouche\" type=\"1\"/><riddle answer=\"a\" answer_type=\"2\" copyright=\"\" hint=\"&lt;p&gt;Parfois, le chef est le premier.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est la lettre A.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis le chef de 25 soldats.&lt;br/&gt;Sans moi Paris serait pris.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Le chef des soldats\" type=\"1\"/><riddle answer=\"6313\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Essayez de poser le système d'équations.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;On peut poser les équations avec x, y, z, t chacun des chiffres : &lt;br/&gt;x+y+z+t=13&lt;br/&gt;x=2*t&lt;br/&gt;y=3*z&lt;br/&gt;&lt;br/&gt;On en déduit de la première 3t+4z=13.&lt;br/&gt;La seule solution possible est t=3 et z=1. Donc x=6 et y=3.&lt;br/&gt;&lt;br/&gt;Le code est donc 6313.&lt;/p&gt;\" text=\"&lt;p&gt;Stéphanie doit utiliser sa carte bleue mais elle a oublié le code. On sait que la somme des 4 chiffres donne 13, que le chiffre des milliers est 2 fois plus grand que celui des unités et que le chiffre des centaines est 3 fois plus grand que celui des dizaines.&lt;/p&gt;&lt;p&gt;Quel est le code de sa carte bleue ?&lt;/p&gt;\" title=\"Le code\" type=\"1\"/><riddle answer=\"620\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Il faut d'abord trouver combien elle avait au dernier magasin.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Au dernier magasin, elle avait 2x(10) = 20€.&lt;br/&gt;Au précédent 2x(20+10)=60&lt;br/&gt;Puis 2x(60+10)=140&lt;br/&gt;2x(140+10)=300&lt;br/&gt;2x(300+10)=620&lt;br/&gt;&lt;br/&gt;Stéphanie avait 620€.&lt;/p&gt;\" text=\"&lt;p&gt;Stéphanie va faire les soldes et elle a dépensé tout son argent dans 5 magasins.&lt;br/&gt;Dans chacun, elle a dépensé 10€ de plus que la moitié de ce qu'elle avait en rentrant.&lt;/p&gt;&lt;p&gt;Quel était son budget (en €) ?&lt;/p&gt;\" title=\"Les soldes\" type=\"1\"/><riddle answer=\"11\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Attention aux intervalles.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;11 secondes&lt;br/&gt;&lt;br/&gt;En effet, lorsque Big Ben sonne, les sons sont espacés de 1s.&lt;/p&gt;\" text=\"&lt;p&gt;Un touriste regardant Big Ben à 6h pile se rend compte qu'il sonne pendant 5 secondes.&lt;/p&gt;&lt;p&gt;Combien de temps (en secondes) mettra-t-il pour sonner à midi ?&lt;/p&gt;\" title=\"Big Ben\" type=\"1\"/><riddle answer=\"5050\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Essayez de trouver une logique avec les extrémités.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;On remarque que 100+1 = 101&lt;br/&gt;99+2 = 101&lt;br/&gt;98+3 = 101&lt;br/&gt;&lt;br/&gt;Donc la somme est égale à&lt;br/&gt;101 * 50 = 5050.&lt;br/&gt;&lt;br/&gt;Une autre méthode : (n^2 + n) / 2.&lt;/p&gt;\" text=\"&lt;p&gt;Quelle est la somme des nombres de 1 à 100 compris (1+2+3....+99+100) ?&lt;/p&gt;\" title=\"La somme\" type=\"1\"/><riddle answer=\"17\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Evitez de faire trop d'aller-retour.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Sébastien et Stéphanie traversent puis Stéphanie revient (3 minutes).&lt;br/&gt;Marie et Sylvain traversent puis Sébastien revient (12 minutes).&lt;br/&gt;Sébastien et Stéphanie retraversent ensemble (2 minutes).&lt;br/&gt;&lt;br/&gt;Ils mettront donc 17 minutes.&lt;/p&gt;\" text=\"&lt;p&gt;Au milieu de la jungle tropicale, un groupe de 4 aventuriers doit traverser une passerelle. Celle-ci étant fragile, elle ne peut supporter que deux personnes au maximum. De plus, la nuit est tombée et ils n'ont qu'une lanterne en leur possession et il est impossible de traverser dans le noir. Sylvain met 10 minutes pour traverser, Marie 5 minutes, Sébastien 2 minutes et Stéphanie 1 minute.&lt;/p&gt;&lt;p&gt;Combien de temps minimum (en minutes) mettront-ils pour traverser la passerelle sachant que chaque groupe de deux personnes se déplace à la vitesse du plus lent ?&lt;/p&gt;\" title=\"La passerelle\" type=\"1\"/><riddle answer=\"7\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Quel nombre a le plus de combinaisons ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Voici les probabilités des résultats d'un lancer de 2 dés: &lt;br/&gt;2 : 1/36&lt;br/&gt;3 : 2/36&lt;br/&gt;4 : 3/36&lt;br/&gt;5 : 4/36&lt;br/&gt;6 : 5/36&lt;br/&gt;7 : 6/36&lt;br/&gt;8 : 5/36&lt;br/&gt;9 : 4/36&lt;br/&gt;10 : 3/36&lt;br/&gt;11 : 2/36&lt;br/&gt;12 : 1/36&lt;br/&gt;&lt;br/&gt;Le 7 a la plus forte probabilité de sortir. En effet, c'est le nombre qui a le plus de combinaisons possible avec 2 dés.&lt;/p&gt;\" text=\"&lt;p&gt;Pierre et Paul décident de parier sur le résultat d'un lancer de 2 dés au casino.&lt;/p&gt;&lt;p&gt;Sur quel résultat (La somme des 2 dés) devront-ils parier pour avoir le plus de chance de gagner ?&lt;/p&gt;\" title=\"Le casino\" type=\"1\"/><riddle answer=\"27\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Une suite peut en cacher une autre.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Cette suite est composée de 2 suites imbriquées : &lt;br/&gt;&lt;br/&gt;9 - 15 - 21 - 27 (+6)&lt;br/&gt;12 - 9 - 6 - 3 (-3)&lt;br/&gt;&lt;br/&gt;La réponse est donc 27.&lt;/p&gt;\" text=\"&lt;p&gt;Quel est le nombre suivant de cette suite : &lt;/p&gt;&lt;p&gt;9 - 12 - 15 - 9 - 21 - 6 - ?&lt;/p&gt;\" title=\"La suite étrange\" type=\"1\"/><riddle answer=\"gerard\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Les mensonges indiquent souvent plus que la vérité.&lt;/p&gt;\" image=\"hatsherlock\" solution=\"&lt;p&gt;Gérard est le voleur.&lt;br/&gt;&lt;br/&gt;Patrice dit un mensonge,&lt;br/&gt;Philippe dit la vérité,&lt;br/&gt;et Gérard ment.&lt;br/&gt;&lt;br/&gt;Il n'y a donc qu'une personne qui dit la vérité.&lt;/p&gt;\" text=\"&lt;p&gt;Marie a un vélo neuf. Malheureusement, elle se fait voler son vélo. La police interroge Patrice, Philippe et Gérard à propos du vol du vélo. &lt;br/&gt;Patrice déclare que Philippe l'a volé,&lt;br/&gt;Philippe dit qu'il n'est pas l'auteur du vol,&lt;br/&gt;Gérard dit qu'il est innocent.&lt;br/&gt;La police sait qu'un seul des trois dit la vérité (les deux autres mentent donc).&lt;/p&gt;&lt;p&gt;Qui a volé le vélo de Marie ?&lt;/p&gt;\" title=\"L'enquête de Marie\" type=\"1\"/><riddle answer=\"3\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Pas tant que ça.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Si 3 chats attrapent 3 souris en 3 minutes, on peut déduire que chacun de ces chats attrapent 1 souris en 3 minute. Il faudra donc 3 chats pour attraper 60 souris en 60 minutes.&lt;/p&gt;\" text=\"&lt;p&gt;Trois chats attrapent trois souris en trois minutes.&lt;/p&gt;&lt;p&gt;Combien de chats faut-il pour attraper 60 souris en 60 minutes?&lt;/p&gt;\" title=\"Les chats\" type=\"1\"/><riddle answer=\"2\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Avez-vous tout lu depuis le début ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;6 = 2 et non 65436.&lt;br/&gt;La réponse est donnée sur la première ligne : 2 = 6.&lt;/p&gt;\" text=\"&lt;p&gt;Complétez cette suite : &lt;/p&gt;&lt;p&gt;2 = 6&lt;br/&gt;3 = 36&lt;br/&gt;4 = 436&lt;br/&gt;5 = 5436&lt;br/&gt;6 = ?&lt;/p&gt;\" title=\"Le calcul savant\" type=\"1\"/><riddle answer=\"120\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Combien de possibilités pour 1 personne, puis 2, puis 3, etc.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Ils vont faire 120 photos.&lt;br/&gt;&lt;br/&gt;5x4x3x2x1 = 120.&lt;br/&gt;Pas très économique.&lt;/p&gt;\" text=\"&lt;p&gt;Une famille de 5 personnes va chez le photographe pour une photo où ils apparaitront tous.&lt;br/&gt;Pour être sûr de faire une bonne photo, le photographe veut prendre une photo en testant toutes les places possibles entre les membres de la famille.&lt;/p&gt;&lt;p&gt;Combien de photos ont-ils pris ?&lt;/p&gt;\" title=\"La photo\" type=\"1\"/><riddle answer=\"monopoly\" answer_type=\"1\" copyright=\"Proposé par Naxela.\" hint=\"&lt;p&gt;On a tous fait cette activité au moins une fois.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il joue au Monopoly.&lt;br/&gt;&lt;br/&gt;Un hôtel sur la rue de la Paix en a ruiné plus d'un.&lt;/p&gt;\" text=\"&lt;p&gt;Quand cet homme s'arrête sur ce terrain, il sait qu'il est ruiné.&lt;/p&gt;&lt;p&gt;Que fait actuellement cet homme ?&lt;/p&gt;\" title=\"L'arrêt\" type=\"1\"/><riddle answer=\"prenom|sonnette|telephone|nom|mail\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Vous l'entendez souvent.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est votre prénom.&lt;br/&gt;&lt;br/&gt;Une sonnette, une adresse email ou le numéro de téléphone sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est ce qui m'appartient mais que les autres utilisent plus que moi ?&lt;/p&gt;&lt;p&gt;Proposé par MeHDoo.&lt;/p&gt;\" title=\"Ehhhh\" type=\"1\"/><riddle answer=\"10\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Attention au terme &quot;dépasser&quot;&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;10. En effet, l'aiguille des minutes ne dépasse pas celle des heures à 0h et 12h, elles commencent et finissent l'une sur l'autre.&lt;/p&gt;\" text=\"&lt;p&gt;Lucien, l'horloger de la reine, aime poser des énigmes. Hier, en croisant un chevalier, il lui pose cette énigme : &lt;/p&gt;&lt;p&gt;Sur cette horloge, combien de fois l'aiguille des minutes dépasse-t-elle celle des heures en 12h à partir de midi ?&lt;/p&gt;\" title=\"Le temps qui passe\" type=\"1\"/><riddle answer=\"4\" answer_type=\"0\" copyright=\"Proposé par Kyrou.\" hint=\"&lt;p&gt;Pas de logique mathématiques.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il faut annoncer au garde le nombre de lettres nécessaire pour écrire le chiffre qu'il prononce.&lt;br/&gt;&lt;br/&gt;Sept = 4&lt;/p&gt;\" text=\"&lt;p&gt;Un chevalier souhaite assister à une réunion secrète.&lt;br/&gt;Pour être admis, il doit donner le mot de passe au garde de l'entrée.Il se cache et écoute les personnes qui se présentent. &lt;br/&gt;Un homme arrive. Le garde lui dit : &quot;5&quot;, l'homme répond &quot;4&quot; et le garde le laisse entrer.&lt;br/&gt;Un deuxième se présente. Le garde lui dit &quot;6&quot;, il répond : &quot;3&quot; et passe.&lt;br/&gt;Un dernier paraît. Le garde lui dit : &quot;4&quot;, il répond : &quot;6&quot; et entre.&lt;/p&gt;&lt;p&gt;Arrive le tour du chevalier. Le garde lui dit : &quot;7&quot;.&lt;/p&gt;&lt;p&gt;Que doit-il répondre pour pouvoir entrer ?&lt;/p&gt;\" title=\"La réunion\" type=\"1\"/><riddle answer=\"soleil\" answer_type=\"1\" copyright=\"Proposé par muta62.\" hint=\"&lt;p&gt;Il faudra penser grand pour résoudre cette énigme.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La terre tourne autour du soleil sous la forme d'une ellipse, donc on s'en éloigne par moment et parfois s'approche de lui.&lt;/p&gt;\" text=\"&lt;p&gt;Lorsque vous lisez cette énigme, vous pouvez vous en rapprocher, mais il est autant probable que vous vous en éloigniez.&lt;/p&gt;&lt;p&gt;Ce qui est sûr, c'est que vous tournez autour mais, qu'en aucun cas, vous ne l'atteindrez.&lt;/p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Déplacement\" type=\"1\"/><riddle answer=\"fils\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Un lien de parenté direct.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;L'homme regarde un portrait de son fils.&lt;/p&gt;\" text=\"&lt;p&gt;Un homme regarde un portrait. On lui demande : &quot;qui regardez vous ?&quot;, il répond : &quot;Je n'ai ni frère, ni soeur, mais le père de cet homme est le fils de mon père.&quot;.&lt;/p&gt;&lt;p&gt;Qui est sur la photo ?&lt;/p&gt;\" title=\"La peinture\" type=\"1\"/><riddle answer=\"compote|jus\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;La cuisine permet des choses merveilleuses.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Elle n'aura qu'à faire une compote pour avoir un partage équitable.&lt;/p&gt;&lt;p&gt;Un jus de pomme est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Stéphanie dispose de 7 pommes qu'elle veut donner à manger et partager de façon équitable à ses 9 enfants.&lt;/p&gt;&lt;p&gt;De quelle façon devra-t-elle s'y prendre ?&lt;/p&gt;\" title=\"Le partage\" type=\"1\"/><riddle answer=\"allumette|briquet\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Le producteur de base n'est peut être pas énoncé.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Avant tout, il faut allumer l'allumette ou un briquet.&lt;/p&gt;\" text=\"&lt;p&gt;Vous arrivez dans un refuge, dans celui-ci se trouvent de vieux journaux, une lampe à pétrole, une cheminée et du bois. Il fait -10°C dehors et vous avez froid.&lt;/p&gt;&lt;p&gt;Qu'est ce que vous allumez en premier ?&lt;/p&gt;\" title=\"Le chauffage\" type=\"1\"/><riddle answer=\"nombril\" answer_type=\"1\" copyright=\"Proposé par Teranox.\" hint=\"&lt;p&gt;Les premiers.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Adam et Eve étant les premiers, ils n'ont pas eu de cordon ombilical donc pas de nombril.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est-ce que nous avons physiquement en plus qu'Adam et Eve ?&lt;/p&gt;\" title=\"Religion\" type=\"1\"/><riddle answer=\"sphere|boule|spherique|balle|globe|bille|rond\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Ce support n'est vraiment pas plat.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Sur une sphère, vous pourrez dessiner un triangle avec 3 angles droits.&lt;br/&gt;&lt;br/&gt;Exemple sur la terre, d'un pôle, avec 2 méridiens perpendiculaires jusqu'à l'équateur.&lt;/p&gt;\" text=\"&lt;p&gt;Sur quel type de support peut-on dessiner un triangle dont tous les coins seront un angle droit ?&lt;/p&gt;\" title=\"Le triangle\" type=\"1\"/><riddle answer=\"t\" answer_type=\"2\" copyright=\"\" hint=\"&lt;p&gt;Le point commun entre ces lettres.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La lettre T. Ce sont les lettres qui n'ont pas une partie arrondie dans l'ordre alphabétique.&lt;/p&gt;\" text=\"&lt;p&gt;Sonia est très imaginative pour son jeune âge, elle a décidé d'apprendre une partie de l'alphabet dans un ordre particulier : &lt;/p&gt;&lt;p&gt;A E F H I K L M N&lt;/p&gt;&lt;p&gt;Selon sa logique, quelle sera la prochaine lettre ?&lt;/p&gt;\" title=\"L'alphabet\" type=\"1\"/><riddle answer=\"parachute\" answer_type=\"1\" copyright=\"Proposé par Tonio.\" hint=\"&lt;p&gt;Qu'est ce qui peut entrainer la mort ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il y a un parachute dans son sac. Celui du premier ne s'est pas ouvert.&lt;/p&gt;\" text=\"&lt;p&gt;Deux hommes sont dans un champ. Le premier est mort, allongé sur le sol, avec un sac sur le dos plein. Le second est vivant, debout, avec un sac sur le dos vide.&lt;/p&gt;&lt;p&gt;Qu'y a-t-il dans le sac plein ?&lt;/p&gt;\" title=\"Le champ\" type=\"1\"/><riddle answer=\"servante\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Certaines choses sont impossibles.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est la servante qui a menti. Difficile de nettoyer les coins d'un château rond.&lt;/p&gt;\" text=\"&lt;p&gt;Le roi de Paliposie habite dans un château rond avec une seule pièce par étage. Durant la période estivale, seul le roi, un garde, le cuisinier, une servante et un orphelin se trouvent au château.&lt;br/&gt;Durant la nuit de samedi à dimanche, le roi a été assassiné. Ne sachant que faire, les personnes présentes font appel au bouffon pour savoir qui était l'assassin.&lt;br/&gt;En arrivant, celui-ci interroge toutes les personnes présentes : &lt;/p&gt;&lt;p&gt; - Le cuisinier dit qu'il était aux cuisines pour préparer un petit déjeuner copieux qui demandait une longue préparation.&lt;br/&gt; - La servante dit qu'elle nettoyait les coins du château.&lt;br/&gt; - L'orphelin dit qu'il n'a même pas l'argent pour acheter une arme.&lt;br/&gt; - Le garde dit qu'il faisait une ronde en dehors du château.&lt;/p&gt;&lt;p&gt;Cependant, le bouffon déclare qu'il connait l'assassin. Qui est-il ?&lt;/p&gt;\" title=\"Le monarque\" type=\"1\"/><riddle answer=\"4\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Il n'y en a pas tant que ça.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il possède 4 perroquets et 3 cages.&lt;/p&gt;\" text=\"&lt;p&gt;Dans une animalerie, un employé a des soucis pour placer les perroquets.&lt;/p&gt;&lt;p&gt; - S'il met un perroquet par cage, il lui manque une cage.&lt;br/&gt; - S'il met 2 perroquets par cage, il a une cage vide.&lt;/p&gt;&lt;p&gt;Combien possède-t-il de perroquets ?&lt;/p&gt;\" title=\"L'animalerie\" type=\"1\"/><riddle answer=\"cercueil|mort|decede|paraplui\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Pourquoi ces 5 hommes se rendraient-ils à l'église ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le cinquième homme est mort et se trouve dans un cercueil.&lt;br/&gt;&lt;br/&gt;Un homme possédant un parapluie est également acceptée.&lt;/p&gt;\" text=\"&lt;p&gt;5 hommes sont devant une église quand tout à coup une pluie violente éclate. 4 hommes vont s'abriter dans l'église. Le dernier ne bouge pas. Cependant, il n'est pas mouillé.&lt;/p&gt;&lt;p&gt;Comment cela est-il possible ?&lt;/p&gt;\" title=\"It's raining today\" type=\"1\"/><riddle answer=\"12\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Un jeu de carte traditionnel&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il y aura 12 yeux. En effet, sur chaque carte d'un jeu traditionnel, les valets apparaissent 2 fois coupés en diagonales.&lt;/p&gt;\" text=\"&lt;p&gt;Un imprimeur a eu une commande assez étrange pour un jeu de cartes. Celui-ci devra être tout à fait traditionnel. Cependant, les personnages devront être de face sauf les 2 valets rouges qui devront être de profil.&lt;/p&gt;&lt;p&gt;Combien d'yeux apparaissent sur les cartes des 4 valets ?&lt;/p&gt;\" title=\"Les cartes\" type=\"1\"/><riddle answer=\"haut|vertical|couche|gravite|pesanteur|attraction|lair|l'air|allonge|jongle\" answer_type=\"3\" copyright=\"Proposé par Yann.\" hint=\"&lt;p&gt;La force du lancer n'a pas d'importance.&lt;/p&gt;\" image=\"ball\" solution=\"&lt;p&gt;Si on lance une balle à la verticale, elle va forcément revenir dans nos mains.&lt;br/&gt;&lt;br/&gt;Ou alors, vous êtes couché et vous la lancez face à vous.&lt;/p&gt;\" text=\"&lt;p&gt;J'ai une balle dans la main, je suis seul sur une plaine et je la lance de toutes mes forces : &lt;/p&gt;&lt;p&gt; - Elle n'est attachée à rien,&lt;br/&gt; - Elle ne rebondit sur rien,&lt;br/&gt; - Rien ne me la renvoie,&lt;br/&gt; - Elle parcourt au moins 3 mètres.&lt;br/&gt;Pourtant, elle revient dans ma main.&lt;/p&gt;Pourquoi ?&lt;/p&gt;\" title=\"La balle\" type=\"1\"/><riddle answer=\"flechette|cible\" answer_type=\"3\" copyright=\"Proposé par kme.\" hint=\"&lt;p&gt;On en trouve de moins en moins dans les bars.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Ces chiffres sont présents autour d'un jeu de fléchette.&lt;/p&gt;\" text=\"&lt;p&gt;20 1 18 4 13, Christelle a écrit ces chiffres en rentrant chez elle, mais où a-t-elle pu voir cette suite de chiffres ?&lt;/p&gt;\" title=\"Etrange suite\" type=\"1\"/><riddle answer=\"glace|glacon\" answer_type=\"3\" copyright=\"Proposé par Maxime.\" hint=\"&lt;p&gt;L'eau dans tous ses états.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il est monté sur un bloc de glace qui a fondu.&lt;/p&gt;\" text=\"&lt;p&gt;Un homme est retrouvé pendu dans une pièce fermée de l'intérieur. Il n'y a aucun meuble. À ses pieds une flaque d'eau. Comment a-t-il fait pour se pendre ?&lt;/p&gt;\" title=\"Le pendu\" type=\"1\"/><riddle answer=\"l\" answer_type=\"2\" copyright=\"Proposé par Florian.\" hint=\"&lt;p&gt;La réponse se trouve dans la question.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;L.&lt;br/&gt;&lt;br/&gt;La suite progresse alternativement entre la première et la dernière lettre de chaque mot de la question.&lt;/p&gt;\" text=\"&lt;p&gt;Quelle lettre est la prochaine dans cette suite logique : &lt;/p&gt;&lt;p&gt;Q, E, E, A, P, S, C, E, ?&lt;/p&gt;\" title=\"Suite improbable\" type=\"1\"/><riddle answer=\"porte\" answer_type=\"1\" copyright=\"Proposé par Tounssi360.\" hint=\"&lt;p&gt;C'est un élément physique.&lt;/p&gt;\" image=\"hatsherlock\" solution=\"&lt;p&gt;La porte.&lt;br/&gt;&lt;br/&gt;Car si c'était un suicide ou un accident la porte serait restée ouverte, or Sherlock Holmes a ouvert la porte et il n'y avait pas de vent pour la claquer.&lt;/p&gt;\" text=\"&lt;p&gt;Un jour de soleil sans vent, Sherlock Holmes et Watson vont dans un bar et commandent un café.&lt;/p&gt;&lt;p&gt;Au bout d'un certain temps, Watson demande au serveur: &quot;Où sont les toilettes?&quot;.Le serveur répond: &quot;Elles sont au 4ème étage porte de droite, et faites attention de ne pas prendre la porte de gauche c'est le vide car le bâtiment est en travaux&quot;.&lt;/p&gt;&lt;p&gt;20 min passent et Sherlock Holmes s'étonne de ne pas voir son ami revenir, il décide alors d'aller voir ce qu'il fait. Arrivé au 4ème étage il ouvre la porte de droite et trouve les toilettes vides, puis il ouvre la porte de gauche et trouve Watson mort en bas. Sherlock Holmes se demande si c'est un meurtre, un suicide ou un accident, puis après réflexion est sûr que c'est un meurtre.&lt;/p&gt;&lt;p&gt;Quel est l'élément cité dans l'histoire qui lui a fait rendre cette conclusion?&lt;/p&gt;\" title=\"Sherlock Holmes\" type=\"1\"/><riddle answer=\"essence|carburant|petrole|consomme\" answer_type=\"3\" copyright=\"Proposé par Mirao.\" hint=\"&lt;p&gt;Ca se vide.&lt;/p&gt;\" image=\"truck\" solution=\"&lt;p&gt;Le poids de l'oiseau est inférieur au poids du carburant utilisé.&lt;/p&gt;\" text=\"&lt;p&gt;Un camion vert doit traverser un pont de 10km supportant une charge maximale exacte de 2 tonnes et pas un gramme de plus. Le camion est donc pesé avec le chauffeur et, coup de chance, il pèse exactement 2 tonnes.&lt;/p&gt;&lt;p&gt;Le conducteur s'engage donc sur le pont, et 100 mètres avant la fin, un oiseau bleu vient se poser sur le capot du camion. Là, sueur froide pour le chauffeur. Cependant, il passe le pont sans encombre.&lt;/p&gt;&lt;p&gt;Pourquoi ?&lt;/p&gt;\" title=\"Le camion\" type=\"1\"/><riddle answer=\"18\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Quelle sera la différence de temps entre l'aller et le retour.&lt;/p&gt;\" image=\"tractor\" solution=\"&lt;p&gt;18km/h.&lt;br/&gt;&lt;br/&gt;Pour revenir, il mettra 3 fois plus de temps qu'à l'aller.&lt;br/&gt;Si A = le temps de l'aller,&lt;br/&gt;3A = le temps du retour. Il a donc roulé sur une durée de 4A.&lt;br/&gt;&lt;br/&gt;(36*A+12*3*A)/(4*A)=18.&lt;/p&gt;\" text=\"&lt;p&gt;Jean doit aller chercher du grain avec son tracteur auquel est attachée une remorque. Pour y aller, il a une vitesse moyenne de 36km/h.&lt;br/&gt;Une fois sa cargaison prise, il revient avec une vitesse moyenne de 12km/h.&lt;/p&gt;&lt;p&gt;Quelle aura été sa vitesse moyenne sur l'aller-retour ?&lt;/p&gt;\" title=\"Le tracteur\" type=\"1\"/><riddle answer=\"2\" answer_type=\"0\" copyright=\"Proposé par Clément.\" hint=\"&lt;p&gt;L'échelle est accrochée au bateau.&lt;/p&gt;\" image=\"boat\" solution=\"&lt;p&gt;La mer sera au niveau du deuxième échelon. En effet l'échelle est accrochée au bateau, et celui-ci flotte.&lt;/p&gt;\" text=\"&lt;p&gt;Dans un port se trouve un bateau avec, pour monter à son bord, une échelle. Cette échelle a 10 échelons, espacés de 10 centimètres chacun. Sachant que le niveau de l'eau est au niveau du deuxième échelon, et que l'eau monte de 20 centimètres par heure, au niveau de quel échelon se trouvera l'eau au bout de deux heures ?&lt;/p&gt;\" title=\"Oh mon bateau!!!\" type=\"1\"/><riddle answer=\"1024\" answer_type=\"0\" copyright=\"Proposé par Jojo.\" hint=\"&lt;p&gt;Avec les puissances les valeurs montent vite...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;2^10 (2 puissance 10) est le plus grand.&lt;br/&gt;&lt;br/&gt;2x2x2x2x2x2x2x2x2x2 = 1024&lt;/p&gt;\" text=\"&lt;p&gt;Quel est le plus grand nombre dénombrable que l'on peut former avec les 3 chiffres (Une seule fois chacun) : 0, 1, 2 ? (La réponse peut être issu d'un calcul utilisant des fonctions &quot;simples&quot;, seul le résultat doit être indiqué)&lt;/p&gt;\" title=\"Petits pour un grand\" type=\"1\"/><riddle answer=\"14\" answer_type=\"0\" copyright=\"Proposé par Mathilde.\" hint=\"&lt;p&gt;Il faut simplement poser le problème mathématique.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Pauline a 14 ans.&lt;br/&gt;&lt;br/&gt;En posant le problème (a = âge), on trouve : &lt;br/&gt;&lt;br/&gt;(a - 10) x 5 = a + 6&lt;br/&gt;5a - 50 = a + 6&lt;br/&gt;a = 56 / 4 = 14.&lt;/p&gt;\" text=\"&lt;p&gt;En multipliant par 5 l'âge qu'elle avait il y a 10 ans, Pauline obtient l'âge qu'elle aura dans 6 ans.&lt;/p&gt;&lt;p&gt;Quel est l'âge actuel de Pauline ?&lt;/p&gt;\" title=\"L'âge de Pauline\" type=\"1\"/><riddle answer=\"obscuri\" answer_type=\"1\" copyright=\"Proposé par Alban.\" hint=\"&lt;p&gt;C'est sombre.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est l'obscurité.&lt;/p&gt;\" text=\"&lt;p&gt;Enigme tirée de &quot;Bilbo le Hobbit&quot; de J.R.R. Tolkien : &lt;/p&gt;&lt;p&gt;On ne peut la voir, on ne peut la sentir,&lt;br/&gt;On ne peut l'entendre, on ne peut la respirer.&lt;br/&gt;Elle s'étend derrière les étoiles et sous les collines,&lt;br/&gt;Elle remplit les trous vides.&lt;br/&gt;Elle revient d'abord et suit après.&lt;br/&gt;Elle termine la vie, tue le rire.&lt;/p&gt;&lt;p&gt;Qu'est ce que c'est ?&lt;/p&gt;\" title=\"Gollum à Bilbo\" type=\"1\"/><riddle answer=\"q\" answer_type=\"2\" copyright=\"Proposé par Pierre-Alexandre.\" hint=\"&lt;p&gt;Pensez à un jeu.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Q pour Quatre.&lt;br/&gt;&lt;br/&gt;C'est la suite des cartes dans l'ordre décroissant : As, Roi, Dame, Valet, Dix, Neuf...&lt;/p&gt;\" text=\"&lt;p&gt;Quelle est la lettre suivante : &lt;/p&gt;&lt;p&gt;A, R, D, V, D, N, H, S, S, C, ?&lt;/p&gt;\" title=\"Suite affreuse\" type=\"1\"/><riddle answer=\"6\" answer_type=\"0\" copyright=\"Proposé par Nissim.\" hint=\"&lt;p&gt;Il ne faut pas oublier le temps de redescendre.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;6 minutes.&lt;br/&gt;&lt;br/&gt;Un voyage transporte un maximum de 40 * 3 = 120 personnes.&lt;br/&gt;En 1h, il y a donc 600 / 120 = 5 voyages qui arrivent.&lt;br/&gt;Il y a donc 5 voyages dont le temps est doublé pour redescendre.&lt;br/&gt;La durée est donc de 60 / 10 = 6 minutes.&lt;/p&gt;\" text=\"&lt;p&gt;Le téléphérique à cabine unique de la Mongie compte 40 sièges de 3 places et peut transporter jusqu'au pic du Midi 600 skieurs par heure, le retour de la cabine compris dans ce temps.&lt;/p&gt;&lt;p&gt;Quelle est la durée (en minutes) de la montée jusqu'à l'observatoire ?&lt;/p&gt;\" title=\"Le téléphérique\" type=\"1\"/><riddle answer=\"5555\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;x * y = 25. Quelles possibilités ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;5555.&lt;br/&gt;&lt;br/&gt;Le produit des deux derniers chiffres étant égal à 25, on a forcément 55 (5 x 5). De là, on en déduit assez vite 5555.&lt;/p&gt;\" text=\"&lt;p&gt;Un homme veut demander une augmentation à son patron. Celui-ci, très joueur, lui demande de lui faire deviner.&lt;/p&gt;&lt;p&gt;H : Ce nombre est composé de 4 chiffres.&lt;br/&gt;P : Est-il premier ?&lt;br/&gt;H : Non, on peut le diviser par 101. Le produit de ses 2 derniers chiffres est égal à 25.&lt;br/&gt;P : C'est un salaire important, je doute que cela soit possible.&lt;/p&gt;&lt;p&gt;Quel salaire l'homme demande-t-il ?&lt;/p&gt;\" title=\"La paye\" type=\"1\"/><riddle answer=\"150\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;0, 3, 12, 39, ...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;150 minutes.&lt;br/&gt;&lt;br/&gt;t0 : 0&lt;br/&gt;t15 : 3&lt;br/&gt;t30 : 3 + (3*3) = 12&lt;br/&gt;t45 : 12 + (9*3) = 39&lt;br/&gt;t60 : 39 + (27*3) = 120&lt;br/&gt;t75 : 120 + (81*3) = 363&lt;br/&gt;t90 : 363 + (243*3) = 1092&lt;br/&gt;t105 : 1092 + (729*3) = 3279&lt;br/&gt;t120 : 3279 + (2187*3) = 9840&lt;br/&gt;t135 : 9840 + (6561*3) = 29523&lt;br/&gt;t150 : 29523 + (19683*3) = 88572&lt;/p&gt;\" text=\"&lt;p&gt;Dans une petite ville de 80000 habitants, un voyageur arrive et raconte une histoire incroyable à 3 personnes, celles-ci s'empressent de la raconter chacune à 3 autres personnes (et personne d'autre par la suite), ces 3*3 personnes font la même chose avec 3 personnes chacune.&lt;/p&gt;&lt;p&gt;Sachant que l'histoire met 15 minutes à être racontée, en combien de temps (en minutes) toute la ville la connaitra ?&lt;/p&gt;\" title=\"Le voyageur\" type=\"1\"/><riddle answer=\"u\" answer_type=\"2\" copyright=\"\" hint=\"&lt;p&gt;Incomplet&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;U.&lt;br/&gt;&lt;br/&gt;Entre A et C : 1 lettre manquante.&lt;br/&gt;Entre C et F : 2 lettres manquantes.&lt;br/&gt;Entre F et J : 3 lettres manquantes, etc.&lt;/p&gt;\" text=\"&lt;p&gt;Quelle est la lettre suivante : &lt;/p&gt;&lt;p&gt;A C F J O ?&lt;/p&gt;\" title=\"Quelle suite ?\" type=\"1\"/><riddle answer=\"quatre|4\" answer_type=\"3\" copyright=\"Proposé par Frostin.\" hint=\"&lt;p&gt;Lisez bien.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Quatre.&lt;br/&gt;&lt;br/&gt;Deux -&gt; 4 lettres.&lt;br/&gt;Trois -&gt; 5 lettres.&lt;br/&gt;Quatre -&gt; 6 lettres.&lt;br/&gt;Cinq -&gt; 4 lettres.&lt;/p&gt;\" text=\"&lt;p&gt;Quand nous sommes deux nous sommes quatre, quand nous sommes trois nous sommes cinq, quand nous sommes quatre on est six.&lt;/p&gt;&lt;p&gt;Quand nous sommes cinq, combien sommes-nous ?&lt;/p&gt;\" title=\"Les groupes variants\" type=\"1\"/><riddle answer=\"288\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;vitesse = distance / temps&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;288 minutes (4h48).&lt;/p&gt;&lt;p&gt;Preuve mathématique :&lt;/p&gt;&lt;p&gt;Soit : &lt;/p&gt;vb = vitesse du bateau,&lt;br/&gt;vc = vitesse du courant,&lt;br/&gt;d = distance parcourue.&lt;br/&gt;&lt;p&gt;On sait que vitesse = distance / temps.&lt;/p&gt;&lt;p&gt;On pose le système d'équation :&lt;/p&gt;&lt;ol&gt;vb + vc = d / 120&lt;br/&gt;(2) vb - vc = d / 180&lt;br/&gt;&lt;/ol&gt;&lt;p&gt;De (2), on sort d = 180(vb - vc)&lt;/p&gt;&lt;p&gt;On remplace d dans (1)&lt;br/&gt;vb + vc = 180 * (vb - vc) / 120&lt;br/&gt;vb + vc = 180/120 * (vb - vc)&lt;/p&gt;&lt;p&gt;On transforme&lt;br/&gt;120 * (vb + vc) = 180 * (vb - vc)&lt;br/&gt;On trouve que vb = 5 * vc&lt;/p&gt;&lt;p&gt;Il rame donc 5 fois plus vite que le courant.&lt;br/&gt;Le courant à donc une influence de 20%.&lt;/p&gt;&lt;p&gt;Il aura donc un temps ajouté de 20% à l'aller (120%) :&lt;br/&gt;120 * 120% = 144&lt;/p&gt;&lt;p&gt;Et un temps réduit de 20% au retour (80%) : &lt;br/&gt;180 * 80% = 144&lt;/p&gt;&lt;p&gt;On a bien le même temps à l'aller et au retour.&lt;br/&gt;Donc 144 + 144 = 288&lt;/p&gt;\" text=\"&lt;p&gt;Une personne rame sur un bateau et met 2 heures pour descendre une rivière et 3 heures pour remonter au point de départ, tout cela en ramant toujours à la même allure.&lt;/p&gt;&lt;p&gt;Combien de temps (en minutes) aurait-elle mis pour faire la même distance s'il n'y avait pas eu de courant ?&lt;/p&gt;\" title=\"Le rameur\" type=\"1\"/><riddle answer=\"2\" answer_type=\"0\" copyright=\"Proposé par Vidji.\" hint=\"&lt;p&gt;Il en rend une seule.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il faut prendre 2 pommes.&lt;br/&gt;&lt;br/&gt;A chaque fois, vous donnerez une pomme au garde, et il la rendra.&lt;/p&gt;\" text=\"&lt;p&gt;Dans un champ se trouve un pommier entouré de 10 remparts. Il est possible de passer un rempart en prenant une porte gardée.&lt;br/&gt;Chaque garde vous autorise à passer, mais en repassant, vous devrez-lui donner la moitié des pommes qu'il vous reste au moment où vous repasserez.&lt;br/&gt;Les gardes se sont tous mis d'accord pour vous rendre une pomme après la transaction s'il vous en reste une.&lt;/p&gt;&lt;p&gt;Combien devrez-vous cueillir de pommes pour ressortir avec exactement le même nombre de pommes ?&lt;/p&gt;\" title=\"Le pommier gardé\" type=\"1\"/><riddle answer=\"81\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Racine carrée&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;81.&lt;br/&gt;&lt;br/&gt;81 / (8 + 1) = (8 + 1)&lt;/p&gt;\" text=\"&lt;p&gt;Quel est le nombre entier composé de 2 chiffres, différent de 0, qui divisé par la somme de ses 2 chiffres donne pour résultat la somme de ses 2 chiffres ?&lt;/p&gt;\" title=\"Diviser pour régner\" type=\"1\"/><riddle answer=\"8\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;En 2, puis en 3.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;8 minutes.&lt;br/&gt;&lt;br/&gt;Le piège vient du fait qu'elle a 2 morceaux au bout de la première coupe.&lt;/p&gt;\" text=\"&lt;p&gt;Stéphanie s'est achetée une nouvelle scie. Avec celle-ci, elle coupe une planche en 2 en 1min20.&lt;/p&gt;&lt;p&gt;Combien de minutes va-t-elle mettre pour couper la planche en 7 ?&lt;/p&gt;\" title=\"La scie\" type=\"1\"/><riddle answer=\"3500\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;aX + bX + 2100 = X&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;3500 habitants.&lt;br/&gt;&lt;br/&gt;Preuve mathématique : &lt;br/&gt;Un cinquième : 1/5x&lt;br/&gt;Un quart du reste : 1/4(x - 1/5x)&lt;br/&gt;Le reste : 2100&lt;br/&gt;&lt;br/&gt;1/5x + 1/4(x - 1/5x) + 2100 = x&lt;br/&gt;4/20x + 4/20x + 2100 = x&lt;br/&gt;8/20x + 2100 = x&lt;br/&gt;2100 = x - 8/20x&lt;br/&gt;2100 = 12/20x&lt;br/&gt;x = 3500&lt;/p&gt;\" text=\"&lt;p&gt;Dans un village, un cinquième des habitants sont des agriculteurs, un quart du reste de la population travaille à l'usine. Les 2100 autres habitants travaillent en ville.&lt;/p&gt;&lt;p&gt;Combien y a-t-il d'habitants au village ?&lt;/p&gt;\" title=\"Le village\" type=\"1\"/><riddle answer=\"pair\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Ecrivez les dates avec des chiffres.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Tous les chiffres sont pairs.&lt;br/&gt;&lt;br/&gt;Entre ces deux dates, tous les chiffres composant la date en avait au moins 1 impair.&lt;/p&gt;\" text=\"&lt;p&gt;Un devin a prédit que le 2 février 2000, un évènement se produira qui n'était pas arrivé depuis le 28 août 888. Lequel est-il ?&lt;/p&gt;\" title=\"Les dates\" type=\"1\"/><riddle answer=\"23\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Le milieu implique un nombre impair.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;L'échelle a 23 barreaux.&lt;/p&gt;&lt;p&gt;Le calcul a effectuer est 3 - 5 + 7 + 6. Ce qui nous donne 11 barreaux. 2x11 = 22.&lt;/p&gt;&lt;p&gt;Il y a un barreau central, donc 23 en tout&lt;/p&gt;\" text=\"&lt;p&gt;Un homme n'ayant pas pour habitude de monter à l'échelle doit réparer sa toiture.&lt;/p&gt;&lt;p&gt;Arrivé au barreau du milieu, quand il commence à prendre peur du vide. Il réussi tout de même à gravir 3 barreaux supplémentaires, mais la peur le tenaillant, il redescend de 5 barreaux.&lt;/p&gt;&lt;p&gt;En voyant la pluie arriver, il reprend courage et remonte de 7 barreaux. Il reprend son souffle et gravit les 6 derniers barreaux.&lt;/p&gt;&lt;p&gt;Combien y a-t-il de barreaux à l'échelle ?&lt;/p&gt;\" title=\"L'échelle\" type=\"1\"/><riddle answer=\"799\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Composé de 9.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;799.&lt;/p&gt;&lt;p&gt;Le nombre devra être composé de 9 pour diminuer le nombre de chiffres pour le composer.&lt;/p&gt;&lt;p&gt;En divisant 25 par 9, on trouve 2 avec un reste de 7.&lt;/p&gt;&lt;p&gt;Le plus petit nombre sera donc 799.&lt;/p&gt;\" text=\"&lt;p&gt;Si le poids d'un nombre est égal à la somme de ses chiffres, quel est le plus petit nombre positif qui pèsera 25 ?&lt;/p&gt;\" title=\"Le poids\" type=\"1\"/><riddle answer=\"27\" answer_type=\"0\" copyright=\"\" hint=\"3 formules pour une réponse simple.\" image=\"\" solution=\"&lt;p&gt;27 verres ont été consommés.&lt;/p&gt;&lt;p&gt;J = S + 3&lt;br/&gt;S = R + 3&lt;br/&gt;J = 2 * R&lt;br/&gt;&lt;/p&gt;&lt;p&gt;On sort facilement que Romain a bu 6 verres, Sébastien 9 et Jean-Baptiste 12.&lt;/p&gt;\" text=\"&lt;p&gt;3 amis se sont rejoints dans un bar.&lt;/p&gt;&lt;p&gt;Sébastien a bu 3 verres de plus que Romain et Jean-Baptiste a bu 3 verres de plus que Sébastien.&lt;/p&gt;&lt;p&gt;Sachant que Jean-Baptiste a le double de Romain, combien de verres ont été consommés en tout ?\" title=\"Du vin!\" type=\"1\"/><riddle answer=\"15625\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Les puissances.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;15625.&lt;/p&gt;&lt;p&gt;1^2 = 1&lt;/p&gt;&lt;p&gt;2^3 = 8&lt;/p&gt;&lt;p&gt;3^4 = 81&lt;/p&gt;&lt;p&gt;4^5 = 1024&lt;/p&gt;&lt;p&gt;5^6 = 15625&lt;/p&gt;\" text=\"&lt;p&gt;Quel est le nombre suivant : &lt;/p&gt;&lt;p&gt;1, 8, 81, 1024, ?&lt;/p&gt;\" title=\"Suite galopante\" type=\"1\"/><riddle answer=\"noire\" answer_type=\"1\" copyright=\"Proposée par Paul.\" hint=\"&lt;p&gt;Facile de supprimer les billets&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La forêt noire&lt;/p&gt;&lt;p&gt;Le plus cher étant la tarte aux pommes à 3.80€, on peut enlever tous les billets/pièces supérieurs à ce prix.&lt;/p&gt;&lt;p&gt; - Kévin : 2€, 0.50€, 0.05€&lt;/p&gt;&lt;p&gt; - Mike : 2€, 1€&lt;/p&gt;&lt;p&gt; - Lucas : 0.50€, 0.10€&lt;/p&gt;&lt;p&gt; - Gabriel : 1€, 0.50€&lt;/p&gt;&lt;p&gt; - Maxime : 1€, 0.50€, 0.20€&lt;/p&gt;&lt;p&gt;On peut ensuite plus facilement tester les possibilités pour arriver au résultat.&lt;/p&gt;&lt;p&gt;On peut aussi remarquer qu'il est impossible de faire 0.40€ avec leurs pièces.&lt;/p&gt;\" text=\"&lt;p&gt;Pour les 6 ans de Julie, ses 5 copains de classe veulent lui acheter une pâtisserie. Ils se sont mis d'accord sur le fait que chacun ne devra fournir qu'une seule pièce ou billet et ils devront atteindre le prix exact avec la monnaie qu'ils ont (6 ans, mais très en avance).&lt;/p&gt;&lt;p&gt;Voici les pièces qu'ils ont dans leur porte-monnaie : &lt;br/&gt; - Kévin : 2€, 0.50€, 0.05€&lt;br/&gt; - Mike : 2€, 1€&lt;br/&gt; - Lucas : 5€, 0.50€, 0.10€&lt;br/&gt; - Gabriel : 10€, 1€, 0.50€&lt;br/&gt; - Maxime : 1€, 0.50€, 0.20€&lt;/p&gt;&lt;p&gt;Et voici le prix des pâtisseries : &lt;br/&gt; - Part de flan : 3€&lt;br/&gt; - Paris-Brest : 3.20€&lt;br/&gt; - Eclair au café : 3.30€&lt;br/&gt; - Forêt noire : 3.40€&lt;br/&gt; - Tarte aux pommes : 3.80€&lt;/p&gt;&lt;p&gt;Malheureusement, ils ne peuvent pas acheter la pâtisserie qu'ils avaient choisie.&lt;/p&gt;&lt;p&gt;Quelle est-elle ?&lt;/p&gt;\" title=\"L'anniversaire surprise\" type=\"1\"/><riddle answer=\"pi\" answer_type=\"2\" copyright=\"\" hint=\"&lt;p&gt;Comptez les mots&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Pi&lt;/p&gt;&lt;p&gt;Chaque mot donne une décimale du nombre Pi.&lt;/p&gt;3 : Que&lt;br/&gt;1 : J'&lt;br/&gt;4 : aime&lt;br/&gt;1 : à&lt;br/&gt;5 : faire&lt;br/&gt;&lt;p&gt;3,141592653589...&lt;/p&gt;\" text=\"&lt;p&gt;Quel nombre est caché derrière ce petit poème ?&lt;/p&gt;&lt;p&gt;&quot;Que j'aime à faire apprendre un nombre utile aux sages. Glorieux Archimède, artiste ingénieux! Toi, de qui Syracuse aime encore la gloire, soit ton nom conservé par de savants grimoires.&quot;&lt;/p&gt;\" title=\"Nombre caché\" type=\"1\"/><riddle answer=\"120\" answer_type=\"0\" copyright=\"Poème de Bhaskara II, mathématicien indien du XIIème siècle.\" hint=\"&lt;p&gt;Le plus petit dénominateur commun : 60.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;120.&lt;/p&gt;&lt;p&gt;Soit x le nombre de fleurs&lt;/p&gt;&lt;p&gt;x/3 + x/5 + x/6 + x/4 + 6 = x&lt;/p&gt;&lt;p&gt;(20x + 12x + 10x + 15x + 360) / 60 = x&lt;/p&gt;&lt;p&gt;57x + 360 = 60x&lt;/p&gt;&lt;p&gt;3x = 360&lt;/p&gt;&lt;p&gt;x = 120&lt;/p&gt;\" text=\"&lt;p&gt;D'une touffe de fleurs de lotus,&lt;br/&gt;Un tiers, un cinquième et un sixième ont été respectivement offerts à Shiva, à Vishnu et à Sûrya.&lt;br/&gt;Un quart a été présenté à Bhâvaî.&lt;br/&gt;Le reste, six fleurs, ont été données au vénérable précepteur.&lt;br/&gt;&lt;p&gt;Dis-moi vite quel était le nombre de fleurs ?&lt;/p&gt;\" title=\"Poème indien\" type=\"1\"/><riddle answer=\"1000\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;La matière sèche ne change pas&lt;/p&gt;\" image=\"fish\" solution=\"&lt;p&gt;1000 grammes.&lt;/p&gt;&lt;p&gt;&lt;/p&gt;&lt;p&gt;La matière sèche représente au départ 1% du poids total soit 20g.&lt;/p&gt;&lt;p&gt;Une fois séché, ces 20g n'ont pas bougés.&lt;/p&gt;&lt;p&gt;m * 2 / 100 = 20&lt;/p&gt;&lt;p&gt;m = 1000&lt;/p&gt;&lt;p&gt;&lt;/p&gt;&lt;p&gt;Une autre approche : &lt;/p&gt;&lt;p&gt;m1 : masse du poisson frais&lt;/p&gt;&lt;p&gt;m2 : masse du poisson séché&lt;/p&gt;&lt;p&gt;s : masse &quot;non eau&quot; du poisson.&lt;/p&gt;&lt;p&gt;m1 * 1 / 100 = s&lt;/p&gt;&lt;p&gt;m2 * 2 / 100 = s&lt;/p&gt;&lt;p&gt;m2 = m1 / 2&lt;/p&gt;&lt;p&gt;m2 = 2000 / 2 = 1000&lt;/p&gt;\" text=\"&lt;p&gt;Vous avez pêché un poisson de 2000g. Il est composé a 99% d'eau. Séché, ce même poisson contient 98% d'eau.&lt;/p&gt;&lt;p&gt;Quelle est la masse du poisson séché (en grammes)?&lt;/p&gt;\" title=\"La pêche\" type=\"1\"/><riddle answer=\"1\" answer_type=\"0\" copyright=\"Proposé par Manuel.\" hint=\"&lt;p&gt;Pas forcément le même nombre de pièces.&lt;/p&gt;\" image=\"gold\" solution=\"&lt;p&gt;1 seule pesée.&lt;/p&gt;&lt;p&gt;Il suffit de prendre une pièce dans le 1er sac, 2 dans le 2ième, 3 dans le 3ième, etc. et de peser le tout.&lt;/p&gt;&lt;p&gt;On devrait obtenir 1+2+3+4...+15=120g. &lt;/p&gt;&lt;p&gt;S'il manque un gramme, c'est le premier livreur qui est le voleur, s'il manque 2 grammes, c'est le 2ième, etc. &lt;/p&gt;\" text=\"&lt;p&gt;M. Louis est revendeur de pièces d'or. Tous les jours, il reçoit des sacs de pièces d'or de la part de ses contacts, mais il s'est récemment aperçu qu'un de ses quinze livreurs se comportait de façon malhonnête et grattait systématiquement la tranche des pièces d'un même sac qu'il lui livrait : une pièce d'or normale pèse 10g, une pièce grattée 9g seulement, mais la différence n'est malheureusement pas visible à l'œil nu.&lt;/p&gt;&lt;p&gt;M. Louis dispose d'une balance précise au gramme près qu'il compte bien utiliser pour confondre le livreur malhonnête. Quel est le nombre minimum de pesées qu'il devra effectuer, sachant que chaque sac contient un grand nombre de pièces ?&lt;/p&gt;\" title=\"L'or des fous\" type=\"1\"/><riddle answer=\"tour\" answer_type=\"2\" copyright=\"Proposé par Paul.\" hint=\"&lt;p&gt;Préfixe.&lt;/p&gt;\" image=\"abc\" solution=\"&lt;p&gt;Tour.&lt;/p&gt;&lt;p&gt;Les mots du groupe A peuvent avoir un préfixe &quot;dé&quot;. Dans le groupe B, il est possible de rajouter &quot;dé&quot; qu'au mot &quot;tour&quot; (détour).&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot du groupe B peut appartenir au groupe A ?&lt;/p&gt;&lt;p&gt;Groupe A : Céder, Passer, Rive, Faire&lt;br/&gt;Groupe B : Etui, Fourreau, Tour, Sac&lt;/p&gt;\" title=\"Les groupes de mots\" type=\"1\"/><riddle answer=\"3\" answer_type=\"0\" copyright=\"Proposée par Thomas.\" hint=\"&lt;p&gt;Que faut-il pour qu'une bougie disparaisse ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il ne reste que les 3 bougies qui se sont éteintes.&lt;/p&gt;\" text=\"&lt;p&gt;Un couple d'amoureux s'offre un dîner aux chandelles. Sur la table il y a 10 bougies. L'homme va les allumer puis il accueille sa compagne. Ils commencent à manger et soudain il y a un courant d'air, 3 bougies s'éteignent, l'homme va fermer la fenêtre mais ne rallume pas les bougies. &lt;/p&gt;&lt;p&gt;Il n'y aura plus de courant d'air durant la suite du repas. Sachant qu'ils n'ont pas éteint les bougies pendant la nuit, combien reste-il de bougies au petit matin ?&lt;/p&gt;\" title=\"Le couple\" type=\"1\"/><riddle answer=\"19\" answer_type=\"0\" copyright=\"Proposée par Laurent.\" hint=\"&lt;p&gt;A, B, C, D...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il y a 19 singes dans le zoo.&lt;/p&gt;&lt;p&gt;Le nombre d'animaux correspond au numéro de la première lettre dans l'alphabet.&lt;/p&gt;\" text=\"&lt;p&gt;Lors d'une visite guidée, un petit garçon écoute le guide qui lui dit : &quot;Dans notre zoo, il y a une autruche, cinq éléphants, onze koalas et quinze ours. Pour les singes, je pense que tu peux le deviner.&quot;&lt;/p&gt;&lt;p&gt;Combien y a-t-il de singes dans le zoo ?&lt;/p&gt;\" title=\"Le zoo\" type=\"1\"/><riddle answer=\"2\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;5 oranges et 3 clémentines valent 3 oranges, 5 clémentines et 2 euros.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une orange vaut 2€.&lt;/p&gt;&lt;p&gt;O = Orange, C = Clémentine.&lt;/p&gt;&lt;p&gt;O = 2C&lt;/p&gt;&lt;p&gt;5O + 3C = 3O + 5C + 2&lt;/p&gt;&lt;p&gt;2C = 2&lt;/p&gt;&lt;p&gt;C = 1&lt;/p&gt;&lt;p&gt;O = 2&lt;/p&gt;\" text=\"&lt;p&gt;Un marchand de fruits vend des clémentines et des oranges.&lt;/p&gt;&lt;p&gt;Une orange coûte 2 fois le prix d'une clémentine.&lt;br/&gt;Une cliente achète 5 oranges et 3 clémentines. Si elle avait acheté 3 oranges et 5 clémentines, elle aurait économisé 2€.&lt;/p&gt;&lt;p&gt;Quel est le prix d'une orange ?&lt;/p&gt;\" title=\"Marchand de fruits\" type=\"1\"/><riddle answer=\"electrocut\" answer_type=\"1\" copyright=\"Proposée par Gaetan.\" hint=\"&lt;p&gt;Dire l'inverse.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Je serai électrocuté.&lt;/p&gt;&lt;p&gt;Si il l'électrocute, alors la phrase sera vraie. Il y aura donc un paradoxe et le juge ne peut donc pas l'exécuter.&lt;/p&gt;\" text=\"&lt;p&gt;Un criminel en prison est condamné à mort.&lt;/p&gt;&lt;p&gt;La sentence a été rendue et il doit être exécuté une semaine après le jugement, mais la méthode n'a pas encore été décidée.&lt;/p&gt;&lt;p&gt;Le jour de son exécution, le juge vient le voir dans sa cellule et lui dit : &lt;br/&gt; - Vous aurez le droit de prononcer une phrase affirmative, si votre phrase est vraie, vous serez fusillé. Si cette phrase est fausse, vous serez électrocuté.&lt;/p&gt;&lt;p&gt;Quelle phrase, le condamné devra-t-il prononcer pour que le juge ne puisse pas décider ?&lt;/p&gt;\" title=\"Le condamné à mort\" type=\"1\"/><riddle answer=\"8\" answer_type=\"0\" copyright=\"Proposée par Jason.\" hint=\"&lt;p&gt;89*2 est impossible&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C=8&lt;/p&gt;&lt;p&gt;On trouve la formule :&lt;/p&gt;&lt;p&gt;A*100+B*10+C = A*10+A+B*10+B+C*10+C&lt;/p&gt;&lt;p&gt;On transforme : 89A-B-10C=0&lt;/p&gt;&lt;p&gt;A ne peut pas être supérieur à 1 sinon la formule est impossible.&lt;/p&gt;&lt;p&gt;On en déduit donc que A=1, B=9 et C=8&lt;/p&gt;&lt;p&gt;Une autre méthode : &lt;/p&gt;&lt;p&gt;A*100+B*10+C=10.(A+B+C)+(A+B+C)&lt;/p&gt;&lt;p&gt;A*100+B*10+C=11*(A+B+C)&lt;/p&gt;&lt;p&gt;&lt;/p&gt;&lt;p&gt;Le premier terme est un multiple de 11, et comme A,B et C sont inférieurs à 10, alors&lt;/p&gt;&lt;p&gt;&lt;/p&gt;&lt;p&gt;B=A+C&lt;/p&gt;&lt;p&gt;On remplace donc B dans les deux termes:&lt;/p&gt;&lt;p&gt;A*110+C*11=11*(A*2+C*2)&lt;/p&gt;&lt;p&gt;A*10+C=2A+2C&lt;/p&gt;&lt;p&gt;8*A=C&lt;/p&gt;&lt;p&gt;&lt;/p&gt;&lt;p&gt;La seule possibilité est donc:&lt;/p&gt;&lt;p&gt;A=1&lt;/p&gt;&lt;p&gt;B=9&lt;/p&gt;&lt;p&gt;C=8&lt;/p&gt;&lt;p&gt;&lt;/p&gt;&lt;p&gt;Vérification:&lt;/p&gt;&lt;p&gt;11+99+88=198&lt;/p&gt;\" text=\"&lt;p&gt;Soit 3 chiffres ABC.&lt;/p&gt;&lt;p&gt;Sachant que ABC = AA + BB + CC, quelle est la valeur de C (différent de 0) ?&lt;/p&gt;&lt;p&gt;Si, par exemple, A=1 et B=2, alors AB=12.&lt;/p&gt;\" title=\"Maths alphabet\" type=\"1\"/><riddle answer=\"300\" answer_type=\"0\" copyright=\"Proposée par Dédé.\" hint=\"&lt;p&gt;4h + la moitié.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;A 300km de Paris.&lt;/p&gt;&lt;p&gt;En 5h, Marcel aura parcouru 500km. Paul aura prit ses 2 heures de retard et parcouru 300km.&lt;/p&gt;\" text=\"&lt;p&gt;Paul et Marcel décident de partir respectivement de Paris et Marseille. L'itinéraire qu'ils décident d'emprunter sépare les 2 villes de 800km.&lt;/p&gt;&lt;p&gt;Sachant que Marcel est parti 2h plus tôt que Paul et qu'ils roulent tous les deux à une vitesse constante de 100km/h, à quelle distance de Paris vont-ils se rencontrer (en km) ?&lt;/p&gt;\" title=\"Le voyage\" type=\"1\"/><riddle answer=\"decapotabl|cabriolet|ouvrant\" answer_type=\"3\" copyright=\"Proposée par Xaïl.\" hint=\"&lt;p&gt;Ouverte.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La voiture est une décapotable.&lt;/p&gt;&lt;p&gt;Un toit ouvrant est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Une personne est retrouvée morte d'un coup de revolver dans sa voiture se trouvant dans la rue. La voiture est fermée de l'intérieur, les fenêtres sont relevées au maximum, elle n'a aucune marque ou trou indiquant le passage de la balle. Il n'y a pas d'arme dans la voiture et les clés sont sur le contact.&lt;/p&gt;&lt;p&gt;Comment cela est-il possible ?&lt;/p&gt;\" title=\"Mort mystérieux\" type=\"1\"/><riddle answer=\"hemisphere|sud\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Les saisons et la géographie.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Elle habite dans l'hémisphère sud où les saisons ne sont pas les mêmes.&lt;/p&gt;\" text=\"&lt;p&gt;Silvaine est née le 31 décembre, pourtant elle fête son anniversaire tous les ans en été.&lt;/p&gt;&lt;p&gt;Pourquoi ?&lt;/p&gt;\" title=\"Il fait chaud\" type=\"1\"/><riddle answer=\"anais\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Faites un tableau.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est Anaïs.&lt;/p&gt;&lt;p&gt;Anaïs a un sac rouge et va à Auchan.&lt;/p&gt;&lt;p&gt;Bernadette a un sac de n'importe quelle couleur et va à Leclerc.&lt;/p&gt;&lt;p&gt;Chloé a un sac jaune et va dans un autre magasin.&lt;/p&gt;\" text=\"&lt;p&gt;3 voisines, Anaïs, Bernadette et Chloé ont leurs habitudes pour faire leurs courses dans un magasin différent avec des sacs de couleurs différentes. &lt;/p&gt;&lt;p&gt;Celle qui a pour habitude d'aller à Auchan avec un sac rouge a croisé Bernadette qui revenait de Leclerc. Chloé n'est pas allée en course aujourd'hui car elle est allée acheter un nouveau sac Jaune.&lt;/p&gt;&lt;p&gt;Laquelle va à Auchan ?&lt;/p&gt;\" title=\"Les courses\" type=\"1\"/><riddle answer=\"5\" answer_type=\"0\" copyright=\"Proposée par Kebekess.\" hint=\"&lt;p&gt;L'âge du père ne sert à rien.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Bernard a 5 ans.&lt;/p&gt;&lt;p&gt;Ma soeur a 2 fois mon âge (1) : S = 2B&lt;/p&gt;&lt;p&gt;Dans 5 ans j'aurais l'âge de ma soeur (2) : B + 5 = S&lt;/p&gt;&lt;p&gt;Donc : &lt;/p&gt;&lt;p&gt;B + 5 = 2B&lt;/p&gt;&lt;p&gt;B = 5&lt;/p&gt;\" text=\"&lt;p&gt;Alain et Bernard discutent ensemble. Soudain, Alain demande : &lt;/p&gt;&lt;p&gt;A : Quel est ton âge ?&lt;br/&gt;B : Mon âge correspond à la différence entre l'âge de mon père et celui de ma mère. Ma soeur a aussi 2 fois mon âge, et son âge à elle correspond au tiers de l'âge de ma mère.&lt;br/&gt;A : Difficile à trouver.&lt;br/&gt;B : Dans 5 ans, j'aurai l'âge de ma soeur. Maintenant tu devrais être capable de trouver.&lt;/p&gt;&lt;p&gt;Quel est l'âge de Bernard ?&lt;/p&gt;\" title=\"L'âge\" type=\"1\"/><riddle answer=\"72\" answer_type=\"0\" copyright=\"Proposée par Jeanne.\" hint=\"&lt;p&gt;Au minimum 30 ans.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le grand-père a 72 ans.&lt;/p&gt;&lt;p&gt;Il a au minimum 30 ans (sauf cas très exceptionnels).&lt;/p&gt;&lt;p&gt;Son âge doit être un multiple de 4, ce qui nous laisse comme possibilités : 32, 36, 40, 44, 48, 52, 56, 60, 64, 68, 72, 74, 76, etc.&lt;/p&gt;&lt;p&gt;Il faut que les possibilités précédentes soient multiples de 3 quand on inverse les chiffres. Il reste : 36, 48, 72.&lt;/p&gt;&lt;p&gt;Il faut enfin vérifier les conditions avec ces possibilités.&lt;/p&gt;\" text=\"&lt;p&gt;J'ai quatre fois l'âge de mon petit-fils.&lt;/p&gt;&lt;p&gt;Si on inverse les deux chiffres de chaque âge, le nouvel âge de mon petit-fils est égal à trois fois le mien.&lt;/p&gt;&lt;p&gt;Quelle est l'âge du grand-père ?&lt;/p&gt;\" title=\"Papy\" type=\"1\"/><riddle answer=\"bastien\" answer_type=\"1\" copyright=\"Proposée par Adam.\" hint=\"&lt;p&gt;Adam et Christopher sont contradictoires.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est Bastien qui a dit la vérité.&lt;/p&gt;&lt;p&gt;Eric a forcément tort, s'il ne mentait pas, il aurait raison.&lt;/p&gt;&lt;p&gt;Adam et Christopher sont contradictoires, donc nous avons forcément 1 menteur de plus, donc Adam est un menteur.&lt;/p&gt;&lt;p&gt;Bastien et Christopher ne sont pas d'accord, ce qui implique un menteur de plus parmi eux. Nous avons donc 3 menteurs.&lt;/p&gt;&lt;p&gt;Denis ment forcément, ce qui fait 4 menteurs.&lt;/p&gt;&lt;p&gt;Donc Christopher ment aussi.&lt;/p&gt;&lt;p&gt;&lt;/p&gt;\" text=\"&lt;p&gt;Le directeur d'une école a trouvé une vitre cassée. Il soupçonne 5 élèves. Il les a interrogés et a laissé partir le(s) écolier(s) qui a/ont dit la vérité.&lt;/p&gt;&lt;p&gt;Adam : Il n'y a pas plus de 2 personnes qui mentent.&lt;br/&gt;Bastien : Il y a 4 menteurs.&lt;br/&gt;Christopher : Il y a 3 menteurs.&lt;br/&gt;Denis : Une seule personne ment.&lt;br/&gt;Eric : Tout le monde ment.&lt;/p&gt;&lt;p&gt;Qui est reparti ?&lt;/p&gt;\" title=\"Menteurs en série\" type=\"1\"/><riddle answer=\"6\" answer_type=\"0\" copyright=\"Proposée par Hrx.\" hint=\"&lt;p&gt;1 - multiple de 7&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;6 lutins.&lt;/p&gt;&lt;p&gt;On sait que le nombre de chocolats moins 1 est un multiple de 7.&lt;/p&gt;&lt;p&gt;Les possibilités sont donc 8, 15, 22, 29, 36. Il y a donc 36 chocolats au départ.&lt;/p&gt;\" text=\"&lt;p&gt;Le père noël décide de distribuer du chocolat à ses lutins.&lt;/p&gt;&lt;p&gt;Au 1er des lutins, il lui dit &quot;Prend un chocolat plus le 7e de ce qu'il reste&quot;.&lt;br/&gt;Puis au deuxième lutin, &quot;Prend deux chocolats plus le 7e de ce qu'il reste&quot;.&lt;br/&gt;Il continue ainsi jusqu'à la fin du paquet de chocolats.&lt;/p&gt;&lt;p&gt;A combien de lutins a-t-il donné des chocolats au minimum ?&lt;/p&gt;\" title=\"Le père noël\" type=\"1\"/><riddle answer=\"435\" answer_type=\"0\" copyright=\"Proposée par Charles.\" hint=\"&lt;p&gt;B est supérieur à 2.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;435.&lt;/p&gt;&lt;p&gt;Pour B=1, A+B+C=A -&gt; impossible.&lt;/p&gt;&lt;p&gt;Pour B=2, A+2+C=2A, A=2+C, Donc B+C=A sera toujours vrai.&lt;/p&gt;&lt;p&gt;Pour B=3, A+3+C=3A, C=2A-3.&lt;/p&gt;&lt;p&gt;Donc pour A=4, C=5&lt;/p&gt;\" text=\"&lt;p&gt;Charles a acheté un cadenas à code à 3 chiffres (de 1 à 9) et a laissé les instructions pour trouver celui-ci pensant que personne ne le trouverait : &lt;/p&gt;&lt;p&gt; - Le code est noté ABC,&lt;br/&gt; - A, B et C sont des chiffres différents,&lt;br/&gt; - B est le plus petit,&lt;br/&gt; - AxB=A+B+C,&lt;br/&gt; - B+C est différent de A et inférieur à 10.&lt;/p&gt;&lt;p&gt;Quel est le code ?&lt;/p&gt;\" title=\"Le cadenas\" type=\"1\"/><riddle answer=\"brun|directeur\" answer_type=\"3\" copyright=\"Proposée par Amel.\" hint=\"&lt;p&gt;Un seul possible.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est Monsieur Brun.&lt;/p&gt;\" text=\"&lt;p&gt;Un jour, l'inspecteur Lafouine fût appelé dans une résidence d'aide à la personne car il y avait eu un meurtre. Arrivé là-bas, il interrogea le directeur, Monsieur Brun, sur ses résidents : &lt;/p&gt;&lt;p&gt; - Madame Mireille est sourde,&lt;br/&gt; - Monsieur Mathieu est aveugle,&lt;br/&gt; - Monsieur Jérôme n'a plus de bras,&lt;br/&gt; - Madame Martine est en fauteuil roulant,&lt;br/&gt;&lt;p&gt; - Monsieur Paul est muet.&lt;/p&gt;&lt;p&gt;L'inspecteur, dans un élan de perspicacité, annonce à tout le monde qu'il a trouvé l'assassin et qu'il ira le dénoncer demain matin à la police.&lt;/p&gt;&lt;p&gt;En arrivant chez lui, une voiture lui fonça dessus pour essayer de le tuer puis le conducteur sorti de la voiture.&lt;/p&gt;&lt;p&gt;L'inspecteur Lafouine eu le temps de se cacher derrière les poubelles. Le tueur commençant à partir, Lafouine se releva mais fit tomber une poubelle. L'homme se retourna et se mit à courir après l'inspecteur en criant.&lt;/p&gt;&lt;p&gt;Qui est le meurtrier ?&lt;/p&gt;\" title=\"Inspecteur Lafouine\" type=\"1\"/><riddle answer=\"24\" answer_type=\"0\" copyright=\"Proposée par MariePre.\" hint=\"&lt;p&gt;33kg.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Grincheux fait 24kg et le poids des couples est de 33.&lt;/p&gt;\" text=\"&lt;p&gt;Blanche Neige a offert une balance aux sept nains.&lt;/p&gt;&lt;p&gt;Ils sont montés l'un après l'autre sur la balance et ont noté leur poids sur une feuille qu'ils ont donné à Blanche Neige, mais sans préciser leurs noms : 22 kg ? 14 kg ? 16 kg ? 11 kg ? 17 kg ? 24 kg ? 19 kg&lt;/p&gt;&lt;p&gt;Puis, pour jouer, ils sont montés deux par deux sur la balance, sauf Grincheux qui n'en avait pas envie.&lt;/p&gt;&lt;p&gt;Ils annoncent alors à Blanche Neige que :&lt;/p&gt;&lt;p&gt; - Dormeur et Prof étaient ensemble sur la balance&lt;br/&gt; - Timide et Joyeux étaient ensemble sur la balance&lt;br/&gt; - Atchoum et Simplet étaient ensemble sur la balance&lt;/p&gt;&lt;p&gt;Puis ils ajoutent que la balance indiquait chaque fois le même poids.&lt;/p&gt;&lt;p&gt;Blanche Neige répond alors : &quot;Ne me dites rien de plus, je sais maintenant quel est le poids de Grincheux.&quot;&lt;/p&gt;&lt;p&gt;Quel est le poids de Grincheux ?&lt;/p&gt;\" title=\"Petite balance\" type=\"1\"/><riddle answer=\"egal\" answer_type=\"1\" copyright=\"Proposée par Dédé.\" hint=\"&lt;p&gt;Le même.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Son égal.&lt;/p&gt;\" text=\"&lt;p&gt;Aimé des mathématiciens, Dieu ne l'a jamais rencontré, le roi parfois et le paysan toujours.&lt;/p&gt;&lt;p&gt;Qu'est-ce ?&lt;/p&gt;\" title=\"Bonjour\" type=\"1\"/><riddle answer=\"emer\" answer_type=\"1\" copyright=\"Proposée par Dela.\" hint=\"&lt;p&gt;Emeric ne peut pas être à côté de Fanny.&lt;/p&gt;\" image=\"table\" solution=\"&lt;p&gt;Emeric sera à l'autre bout de la table.&lt;/p&gt;&lt;p&gt;Deux ordres sont possibles : &lt;/p&gt;&lt;p&gt; - A, D, B, E, C, F&lt;/p&gt;&lt;p&gt; - A, F, C, E, B, D&lt;/p&gt;\" text=\"&lt;p&gt;Alexandre et Brigitte ont invités deux couples d'amis pour leur anniversaire de mariage.&lt;/p&gt;&lt;p&gt;Clara, Denis, Emeric et Fanny arrivent dans 30 minutes et ils ne savent toujours pas comment ils vont se placer autour de la table.&lt;/p&gt;&lt;p&gt; - Emeric veut toujours être entouré de deux filles,&lt;br/&gt; - Fanny veut être à côté de Clara,&lt;br/&gt;&lt;p&gt; - Une personne ne peut pas avoir à côté d'elle quelqu'un ayant une initiale qui suit ou précède directement la sienne (Brigitte ne peut être à côté d'Alexandre et Clara).&lt;/p&gt;&lt;p&gt;Alexandre, décide de s'asseoir en bout de table, qui sera à l'autre bout de la table ?&lt;/p&gt;\" title=\"Le repas\" type=\"1\"/><riddle answer=\"64\" answer_type=\"0\" copyright=\"Proposée par Danny.\" hint=\"&lt;p&gt;x²&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il a 64 ans.&lt;/p&gt;&lt;p&gt;E : Nombre de ses enfants&lt;/p&gt;&lt;p&gt;E - 1 = Nombre des petits enfants de chaque enfant.&lt;/p&gt;&lt;p&gt;E * (E - 1) = Nombre de petits enfants.&lt;/p&gt;&lt;p&gt;E + E*(E-1) = Son âge.&lt;/p&gt;&lt;p&gt;En réduisant cette formule on trouve que son âge est égal à E².&lt;/p&gt;&lt;p&gt;Donc son âge est un carré supérieur à 50 et inférieur à 70.&lt;/p&gt;&lt;p&gt;Le seul se trouvant dans cette tranche est 64.&lt;/p&gt;\" text=\"&lt;p&gt;Une personne ayant plus de 50 ans et moins de 70 ans ne veut pas dire son âge.&lt;/p&gt;&lt;p&gt;Il annonce juste que son âge est égal au nombre de ses enfants et petits enfants.&lt;br/&gt;On sait que chacun de ses enfants a eu autant d'enfants qu'il a de frères et soeurs.&lt;/p&gt;&lt;p&gt;Quelle est l'âge de cette personne ?&lt;/p&gt;\" title=\"Papy papy\" type=\"1\"/><riddle answer=\"16\" answer_type=\"0\" copyright=\"Proposée par Pierrick.\" hint=\"&lt;p&gt;3x+y=12&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;16 ans.&lt;/p&gt;&lt;p&gt;Le plus simple est de partir de leurs âges passés.&lt;/p&gt;&lt;p&gt;3T+F=12&lt;/p&gt;&lt;p&gt;Avec T, l'âge d'une triplé, et F l'âge de la fille de Raphaël.&lt;/p&gt;&lt;p&gt;Pour T = 4, F = 0. Impossible.&lt;/p&gt;&lt;p&gt;Pour T = 3, F = 3. Impossible car elles n'ont pas le même âge.&lt;/p&gt;&lt;p&gt;Pour T = 2, F = 6. La solution.&lt;/p&gt;&lt;p&gt;Pour T = 1, F = 9. Elle serait majeur aujourd'hui.&lt;/p&gt;\" text=\"&lt;p&gt;Alexandre a retrouvé son ami Raphaël. Ils commencent à parler de leurs filles.&lt;/p&gt;&lt;p&gt;A : Mes triplés vont bien et ta fille ?&lt;br/&gt;R : Elle grandit mais elle n'est pas encore majeure. Tu te rends compte, si on additionne l'âge de nos filles, on arrive à plus de 50 ans.&lt;br/&gt;A : Et dire qu'il y a 10 ans, elles avaient à elles quatre 12 ans. C'est dommage qu'elles n'aient pas le même âge.&lt;/p&gt;&lt;p&gt;Quelle est l'âge de la fille de Raphaël aujourd'hui ?&lt;/p&gt;\" title=\"Docteur March\" type=\"1\"/><riddle answer=\"8\" answer_type=\"0\" copyright=\"Proposée par Dédé.\" hint=\"&lt;p&gt;1/1=1&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;X vaut 8.&lt;/p&gt;&lt;p&gt;Z - Z = Z, donc Z = 0.&lt;/p&gt;&lt;p&gt;Y / Y = Y, donc Y = 1.&lt;/p&gt;&lt;p&gt;X + X + X + XX + XXX = 1000&lt;/p&gt;&lt;p&gt;3X + 10X + X + 100X + 10X + X = 1000&lt;/p&gt;&lt;p&gt;3X + 11X + 111X = 1000&lt;/p&gt;&lt;p&gt;125X = 1000&lt;/p&gt;&lt;p&gt;X = 1000/125 = 8&lt;/p&gt;\" text=\"&lt;p&gt;Paul a trouvé une feuille codée qui contient un calcul, mais il n'arrive pas à trouver la valeur de X. Il sait que : &lt;/p&gt;&lt;p&gt; 1) X + X + X + XX + XXX = YZZZ&lt;br/&gt; 2) Y / Y = Y&lt;br/&gt; 3) Z - Z = Z&lt;/p&gt;&lt;p&gt;Que vaut X ?&lt;/p&gt;&lt;p&gt;YZZZ représente un nombre et non Y*Z*Z*Z.&lt;/p&gt;\" title=\"Langage étrange\" type=\"1\"/><riddle answer=\"oui\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Possible ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Oui, cette affirmation est possible.&lt;br/&gt;&lt;br/&gt;Toutes les poules ne mentent pas mais elle oui.&lt;/p&gt;\" text=\"&lt;p&gt;Dans une ferme, une poule annonce fièrement que toutes les poules mentent toujours.&lt;/p&gt;&lt;p&gt;Cette affirmation est-elle possible ?&lt;/p&gt;\" title=\"Cot cot cot\" type=\"1\"/><riddle answer=\"moitie|coupe\" answer_type=\"3\" copyright=\"Proposée par Khalil\" hint=\"&lt;p&gt;Comprimés sécables.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il prend la moitié de chaque comprimé.&lt;/p&gt;\" text=\"&lt;p&gt;Un vieil homme a 4 comprimés mélangés. 2 rouges et 2 noirs.&lt;/p&gt;&lt;p&gt;Dans une pièce sans lumière, il doit prendre uniquement 1 rouge et 1 noir sinon il meurt.&lt;/p&gt;&lt;p&gt;Comment faire ?&lt;/p&gt;\" title=\"Les médicaments\" type=\"1\"/><riddle answer=\"galere\" answer_type=\"1\" copyright=\"Proposée par Norikoff.\" hint=\"&lt;p&gt;Le mot à trouver est aussi le nom d'un ancien navire romain.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Galère&lt;/p&gt;\" text=\"&lt;p&gt;Mon premier est l'entrée d'une grotte.&lt;br/&gt;Mon second est le commencement de l'amour.&lt;br/&gt;Mon troisième n'est pas lui.&lt;br/&gt;Mon quatrième clos une dispute.&lt;br/&gt;Par mon cinquième débute la réussite.&lt;br/&gt;Et mon sixième, aux limites de l'éternité se cache.&lt;/p&gt;&lt;p&gt;Si tu es en peine, tu subis mon tout.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Travail pénible\" type=\"1\"/><riddle answer=\"8\" answer_type=\"0\" copyright=\"Proposée par Tom.\" hint=\"&lt;p&gt;Chiffres romains.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;On coupe horizontalement les chiffres romains en gardant la moitié du haut.&lt;/p&gt;&lt;p&gt;X donne V&lt;/p&gt;&lt;p&gt;III donne III&lt;/p&gt;&lt;p&gt;XIII donne VIII&lt;/p&gt;\" text=\"&lt;p&gt;Dans un monde ancien qui n'est plus, où 5 était la moitié de 10 et où 3 était la moitié de 3, quelle était la moitié de 13 ?&lt;/p&gt;\" title=\"Moitié moitié\" type=\"1\"/><riddle answer=\"36\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Baptiste en premier.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Antoine a peint 36h.&lt;/p&gt;&lt;p&gt;Sa durée correspond a la totalité des autres peintres : &lt;/p&gt;&lt;p&gt;A = B + C + D&lt;/p&gt;&lt;p&gt;(Chaque lettre représente l'initiale des prénoms)&lt;/p&gt;&lt;p&gt;D = B / 2&lt;/p&gt;&lt;p&gt;C = D + 4 = B/2 + 4&lt;/p&gt;&lt;p&gt;B = C + 4 = B/2 + 4 + 4&lt;/p&gt;&lt;p&gt;Donc : &lt;/p&gt;&lt;p&gt;Baptiste = 16h&lt;/p&gt;&lt;p&gt;Clément = 12h&lt;/p&gt;&lt;p&gt;David = 8h&lt;/p&gt;&lt;p&gt;&lt;/p&gt;\" text=\"&lt;p&gt;Maxime doit faire repeindre un château le plus rapidement possible.&lt;/p&gt;&lt;p&gt;Il a embauché Antoine, un peintre qui va travailler sans s'arrêter jusqu'à la fin du chantier.&lt;/p&gt;&lt;p&gt;Cependant, il ne pourra tout faire seul et trois autres peintres vont se succéder pour peindre les autres pièces en parallèle à Antoine.&lt;/p&gt;&lt;p&gt;On sait que Baptiste a peint 4h de plus que Clément qui lui, a peint 4h de plus que David. On sait enfin que David a peint moitié moins de temps que Baptiste.&lt;/p&gt;&lt;p&gt;Combien de temps a peint Antoine ? (en heure)&lt;/p&gt;\" title=\"Repeindre\" type=\"1\"/><riddle answer=\"70\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;207/3&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;70.&lt;/p&gt;&lt;p&gt;Les maillots ont les numéros 68, 69 et 70.&lt;/p&gt;\" text=\"&lt;p&gt;Silvaine a 3 amis qui jouent au foot.&lt;/p&gt;&lt;p&gt;Aujourd'hui elle leur a offert de nouveaux maillots.&lt;/p&gt;&lt;p&gt; - On sait que la somme des 3 numéros font 207.&lt;/p&gt;&lt;p&gt; - On sait que les 3 numéros se suivent.&lt;/p&gt;&lt;p&gt;Quelle est le numéro le plus grand parmi ces 3 maillots ?&lt;/p&gt;\" title=\"Les coéquipiers\" type=\"1\"/><riddle answer=\"allemand\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Pour faciliter la résolution, il faudra poser le problème sur une feuille et utiliser les hypothèses les unes après les autres.&lt;/p&gt;\" image=\"house\" solution=\"&lt;p&gt;C'est bien l'allemand qui élève des poissons.&lt;/p&gt;\" text=\"&lt;p&gt;Cette énigme aurait été posée par Albert Einstein. D'après lui, seule 2% de la population serait capable de résoudre cette énigme.&lt;/p&gt;&lt;p&gt;5 personnes de nationalité différente : &lt;br/&gt; - habitent 5 maisons alignées de couleurs distinctes&lt;br/&gt; - fument des cigares de 5 marques différentes&lt;br/&gt; - boivent 5 boissons distinctes&lt;br/&gt; - élèvent des animaux de 5 espèces différentes.&lt;br/&gt;&lt;p&gt;Question : Qui a des poissons ?&lt;/p&gt;&lt;p&gt;Hypothèses de départ : &lt;br/&gt; - Le norvégien habite la première maison&lt;br/&gt; - L'anglais habite la maison rouge&lt;br/&gt; - La maison verte est située juste à gauche de la maison blanche&lt;br/&gt; - Le danois boit du thé&lt;br/&gt; - La personne qui fume des Rothmans habite à côté de celle qui élève des chats&lt;br/&gt; - La personne qui habite la maison jaune fume des Dunhill&lt;br/&gt; - L'allemand fume des Prince&lt;br/&gt; - La personne qui habite la maison du milieu boit du lait&lt;br/&gt; - La personne qui fume des Rothmans a un voisin qui boit de l'eau&lt;br/&gt; - La personne qui fume des Pall Mall élève des oiseaux&lt;br/&gt; - Le suédois élève des chiens&lt;br/&gt; - Le norvégien habite à côté de la maison bleue&lt;br/&gt; - La personne qui élève des chevaux habite à côté de la maison jaune&lt;br/&gt; - La personne qui fume des Blue Master boit de la bière&lt;br/&gt; - Dans la maison verte, on boit du café.&lt;/p&gt;\" title=\"L'énigme d'Einstein\" type=\"2\"/><riddle answer=\"40\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Les fractions peuvent vous aider.&lt;/p&gt;\" image=\"paint\" solution=\"&lt;p&gt;Si on divise le mur en parts, en 1h, Franck, Jacques et Léon pourront peindre respectivement &lt;br/&gt;1/1 + 1/3 + 1/6 = 9/6 = 3/2.&lt;br/&gt;Ils peindront 3/2 mur en 1h (3/2 = 1 mur et demi). On peut donc déduire qu'ils pourront le peindre à 3 en 2/3h soit 40 minutes.&lt;/p&gt;\" text=\"&lt;p&gt;Stéphanie veut faire peindre son mur, elle connait 3 personnes qui pourraient le faire.&lt;/p&gt;&lt;p&gt;Frank peut peindre un mur en 1h, Jacques en 3h et Léon en 6h. Seulement elle est pressée et les embauche tous les 3. Combien de temps (en minutes) vont-ils mettre à eux 3 ?&lt;/p&gt;\" title=\"La peinture murale\" type=\"2\"/><riddle answer=\"534|533\" answer_type=\"4\" copyright=\"\" hint=\"&lt;p&gt;Il est possible de faire des escales.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le dromadaire prend 1000 bananes, fait 200km, en pose 600 puis revient à son point de départ.&lt;br/&gt;Il répète cette opération, il y a donc un tas de 1200 bananes situé à 200km.&lt;br/&gt;Il prend les 1000 bananes restantes, parcourt les 200km, reprend 200 bananes (il en reste donc 1000), puis fait 333km, en pose 334 et revient à l'étape précédente.&lt;br/&gt;Il prend les 1000 bananes restantes, arrivé au kilomètre 533, il mange une banane, ramasse les 333 au sol pour en avoir 1000.&lt;br/&gt;Il fait les 467 kilomètres restants et arrive avec 533 bananes.&lt;/p&gt;\" text=\"&lt;p&gt;Un dromadaire doit transporter un maximum de bananes d'une oasis à une autre distantes de 1000km.&lt;/p&gt;&lt;p&gt;Il dispose de 3000 bananes mais ne peut en transporter plus de 1000 à chaque voyage.&lt;br/&gt;De plus, pour survivre à son voyage, il mangera 1 banane à chaque kilomètre parcouru.&lt;/p&gt;&lt;p&gt;Combien de bananes peut-il transporter à la deuxième oasis ?&lt;/p&gt;\" title=\"Le dromadaire\" type=\"2\"/><riddle answer=\"9\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Testez toutes les possibilités.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les possibilités du produit de 36 et leurs sommes respectives sont : &lt;br/&gt;1x1x36 &gt; 38&lt;br/&gt;1x2x18 &gt; 21&lt;br/&gt;1x3x12 &gt; 16&lt;br/&gt;1x4x9 &gt; 14&lt;br/&gt;1x6x6 &gt; 13&lt;br/&gt;2x2x9 &gt; 13&lt;br/&gt;2x3x6 &gt; 11&lt;br/&gt;3x3x4 &gt; 10&lt;br/&gt;&lt;br/&gt;Il ne trouve pas avec le numéro de la maison d'en face donc il a vu 13.&lt;br/&gt;Apprenant qu'il y a une aînée, elle a forcement 2 filles de 2 ans et une de 9 ans.&lt;/p&gt;\" text=\"&lt;p&gt;Un homme faisant connaissance avec sa voisine apprend qu'elle a 3 filles.&lt;/p&gt;&lt;p&gt;Intrigué, il lui demande leurs âges, mais ne voulant pas répondre directement elle préfère lui faire deviner : &lt;/p&gt;V : Le produit de leurs âges fait 36.&lt;br/&gt;H : Il me faudrait plus d'indices.&lt;br/&gt;V : La somme est égale au numéro de la maison d'en face.&lt;br/&gt;H : Je ne peux toujours pas trouver.&lt;br/&gt;V : L'ainée est blonde.&lt;br/&gt;H : Ah oui je vois.&lt;/p&gt;&lt;p&gt;Quel est l'âge de l'aînée ?&lt;/p&gt;\" title=\"Les 3 filles\" type=\"2\"/><riddle answer=\"3\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Essayez de trouver le raisonnement de chaque moine.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;S'il y avait 1 moine malade, le premier jour il verrait 39 personnes saines. Il partirait donc le premier jour. Mais ça n'a pas été le cas.&lt;br/&gt;&lt;br/&gt;S'il y avait 2 moines malades, le premier jour ils voient 1 malade et 38 personnes saines. Chacun des 2 a le raisonnement 'C'est l'autre qui est malade'. Le lendemain ils sont tous là, ils devinent donc qu'ils sont tous les 2 malades.&lt;br/&gt;&lt;br/&gt;Cependant la maladie a duré 3 jours. Donc les 3 moines voient 2 moines malades et 37 sains. Ils auront le même raisonnement que précédemment mais sur 3 jours.&lt;br/&gt;&lt;br/&gt;Ils sont donc 3.&lt;/p&gt;\" text=\"&lt;p&gt;L'énigme se passe dans un monastère très strict où vivent 40 moines. Ces moines ont pour seule vocation la prière et ils ne doivent absolument pas communiquer entre eux, ni par geste, encore moins par la parole. Ils ne peuvent même pas se regarder dans un miroir. Chaque jour, le père supérieur, qui est le seul à pouvoir parler, réunit les moines dans la salle de réunion pour les informer des nouvelles du jour.&lt;/p&gt;&lt;p&gt;Une maladie très dangereuse et pouvant être contagieuse vient d'arriver chez les moines, elle se caractérise par la présence de petites plaques rouges sur le visage, bien visibles mais non douloureuses. Elle ne provoque pas d'autres symptômes au début. Chaque moine ne peut donc pas savoir s'il est malade.&lt;/p&gt;&lt;p&gt;Le père supérieur décide de prévenir les moines. Lors de la réunion quotidienne, il les informe donc que cette maladie est dangereuse, et il demande qu'à la fin de chaque réunion, quand il le demandera, tous ceux qui se savent malades préparent leurs valises et partent du monastère.&lt;/p&gt;&lt;p&gt;A la fin de cette réunion, le père supérieur demande : 'Que tous ceux qui se savent malades se lèvent et s'en aillent'. Mais personne ne se lève.&lt;/p&gt;&lt;p&gt;Le lendemain, à la fin de la réunion, le père supérieur demande: 'Que tous ceux qui se savent malades se lèvent et s'en aillent'. Mais personne ne se lève.&lt;br/&gt;Le surlendemain, à la fin de la réunion, le père supérieur demande: 'Que tous ceux qui se savent malades se lèvent et s'en aillent'. A ce moment là, tous les moines qui sont malades se lèvent et s'en vont.&lt;/p&gt;&lt;p&gt;Combien sont-ils sachant que la maladie ne s'est pas propagée ?&lt;/p&gt;\" title=\"Les moines\" type=\"2\"/><riddle answer=\"+1\" answer_type=\"2\" copyright=\"\" hint=\"&lt;p&gt;C'est alphanumérique&lt;/p&gt;\" image=\"formula\" solution=\"&lt;p&gt;+1&lt;br/&gt;&lt;br/&gt;On commence de 0,&lt;br/&gt;0 : ZERO = 4 lettres&lt;br/&gt;-2 lettres&lt;br/&gt;1 : UN = 2 lettres&lt;br/&gt;+2 lettres&lt;br/&gt;2 : DEUX = 4 lettres&lt;br/&gt;+1 lettre&lt;br/&gt;3 : TROIS = 5 lettres&lt;br/&gt;+1 lettre&lt;br/&gt;4 : QUATRE = 6 lettres&lt;br/&gt;-2 lettres&lt;br/&gt;5 : CINQ = 4 lettres&lt;br/&gt;-1 lettre&lt;br/&gt;6 : SIX = 3 lettres&lt;br/&gt;etc.&lt;br/&gt;&lt;br/&gt;De 11 à 12, il faut mettre +1&lt;/p&gt;\" text=\"&lt;p&gt;-2; +2; +1; +1 ;-2 ;-1; +1; 0; 0; -1 ;+1; ?&lt;/p&gt;&lt;p&gt;Quel est le numéro suivant (avec le signe)?&lt;/p&gt;\" title=\"La suite étrange\" type=\"2\"/><riddle answer=\"15\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;La solution de la course vers la sortie apporte plus d'élément qu'il ne parait.&lt;/p&gt;\" image=\"train\" solution=\"&lt;p&gt;Si Bernadette court vers l'entrée du tunnel, elle y parviendra en même temps que le train et elle aura parcouru les 3/8 du tunnel.&lt;br/&gt;Si par contre elle court vers la sortie, elle sera rendue aux 3/8 + 3/8 = 3/4 du tunnel lorsque le train en atteindra l'entrée.&lt;br/&gt;Il lui restera 1/4 à parcourir pour atteindre la sortie.&lt;br/&gt;Le train parcourra la longueur totale du tunnel dans le temps que Bernadette prendra pour en parcourir le dernier 1/4.&lt;br/&gt;Elle court donc 4 fois moins vite que le train, qui roule à 60 km/h.&lt;br/&gt;&lt;br/&gt;Ainsi, Bernadette court à 15 km/h.&lt;/p&gt;\" text=\"&lt;p&gt;Bernadette court dans un tunnel.&lt;/p&gt;&lt;p&gt;Arrivée aux 3/8 du chemin, elle entend le sifflet d'un train venant derrière elle.&lt;/p&gt;&lt;p&gt;Elle sait que le train roule toujours à 60 km/h sur cette portion de la voie.&lt;/p&gt;&lt;p&gt;Elle fait un calcul mental rapide : elle peut éviter le train de justesse :&lt;br/&gt;Si elle court vers l'entrée du tunnel,&lt;br/&gt;Si elle court vers la sortie.&lt;/p&gt;&lt;p&gt;A quelle vitesse (en km/h) court Bernadette ?&lt;/p&gt;\" title=\"Le tunnel\" type=\"2\"/><riddle answer=\"14\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Si n est le nombre de femmes infidèles, l'un des maris cocus n'en voit que n-1&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Chacun sait qu'il y a au moins deux femmes infidèles&lt;br/&gt;Supposons qu'il y ait eu exactement deux femmes infidèles.&lt;br/&gt;Chaque mari cocu ne connaitrait qu'une seule femme infidèle chez les autres.&lt;br/&gt;Il en déduirait donc immédiatement que la deuxième femme infidèle est nécessairement la sienne.&lt;br/&gt;Il la tuerait alors le soir même.&lt;br/&gt;&lt;br/&gt;Si rien ne se passe le premier soir, cela signifie qu'il y a au moins trois femmes infidèles, ce que tous les maris déduisent le lendemain.&lt;br/&gt;Mais alors, quiconque ne connaîtrait que deux maris cocus en conclurait qu'il l'est lui aussi, et tuerait sa femme le soir même.&lt;br/&gt;&lt;br/&gt;Si rien ne se passe le deuxième soir, c'est qu'il y a alors au moins quatre femmes infidèles.&lt;br/&gt;&lt;br/&gt;On peut ainsi continuer: si rien ne se passe le énième soir, cela signifie qu'il y a au moins n+2 femmes infidèles.&lt;br/&gt;Mais si des exécutions ont lieu le énième soir, alors, c'est qu'il y avait n+1 cocus.&lt;br/&gt;&lt;br/&gt;Les meurtres ayant lieu le 13ème soir, on en déduit qu'il y avait 14 maris trompés.&lt;/p&gt;\" text=\"&lt;p&gt;Le roi convoqua un jour tous les hommes mariés de sa cité.&lt;br/&gt;&lt;p&gt;On suppose que la monogamie était la règle.&lt;/p&gt;&lt;p&gt;Le roi leur tint ces propos : &lt;/p&gt;&lt;p&gt;&lt;i&gt;&quot;Afin de lutter contre l'adultère, je demande à chacun d'entre vous, s'il s'aperçoit qu'il est trompé, de tuer sa femme le soir même à minuit.&quot;&lt;/i&gt;&lt;br/&gt;&lt;i&gt;&quot;De plus, je peux vous dire qu'au moins deux femmes sont infidèles à leur mari.&quot;&lt;/i&gt;&lt;/p&gt;&lt;p&gt;Evidemment, les habitants sont très obéissants à l'égard de leur roi, et appliquent à la lettre tous les ordres donnés.&lt;/p&gt;&lt;p&gt;Cependant, comme il est d'ailleurs toujours d'usage, les cocus sont les seuls à ignorer l'infidélité de leur femme.&lt;/p&gt;&lt;p&gt;Chaque mari sait quelles sont les femmes infidèles des autres maris, mais ignore si sa propre femme l'est ou non.&lt;/p&gt;&lt;p&gt;Par contre, on suppose que les habitants ont une grande intelligence logique, et qu'ils sont donc tout à fait capable de tirer des conclusions sur leur propre situation à partir du comportement des autres.&lt;/p&gt;&lt;p&gt;Rien ne se passe pendant 12 jours.&lt;/p&gt;&lt;p&gt;Mais le treizième jour, à minuit, tous les maris cocus exécutent leurs femmes.&lt;/p&gt;&lt;p&gt;Combien y avait-il de femmes infidèles ?&lt;/p&gt;\" title=\"Le roi\" type=\"2\"/><riddle answer=\"8000\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Il est conseillé de faire un schéma.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;On sait qu'il y a 240000/10 soit 24 000 habitants de la Papouasie concernés par les poux.&lt;br/&gt;&lt;br/&gt;Ils se répartissent en 1/3, 2/3. Donc 16000 &quot;pas papous&quot; et 8000 &quot;papous&quot;. &lt;br/&gt;&lt;br/&gt;Examinons maintenant tous le sous groupes possibles : &lt;br/&gt;Il y a 3 oppositions binaires imbriquées donc : 2 x 2 x 2 = 8 groupes possibles. (Il est conseillé de faire un petit schéma pour s'aider)&lt;br/&gt;Dans l'énoncé il y a 2 groupes à poux.&lt;br/&gt;On peut donc d'ores et déjà éliminer les 4 groupes &quot;pas à poux&quot; il en reste 4.&lt;br/&gt;Sur les 4 qui restent 2 sont éliminés par l'énoncé, il en reste 2.&lt;br/&gt;Donc nous avons bien 8000 &quot;papous pas papas à poux&quot; et 16000 &quot;papas pas papous à poux&quot;.&lt;/p&gt;\" text=\"&lt;p&gt;En Papouasie, il y a des &quot;papous&quot; et des &quot;pas-Papous&quot;.&lt;/p&gt;&lt;p&gt;Parmi les &quot;papous&quot; il y a des &quot;papas papous&quot; et des &quot;papous pas papa&quot;.&lt;/p&gt;&lt;p&gt;Mais il y a aussi des &quot;papas pas papous&quot; et des &quot;pas papous pas papas&quot;.&lt;/p&gt;&lt;p&gt;&lt;p&gt;De plus, il y a des &quot;papous pas papas à poux&quot; et des &quot;papas pas papous à poux&quot;.&lt;/p&gt;&lt;p&gt;Mais il n'y a pas de &quot;papas papous à poux&quot; ni de &quot;pas papous pas papas à poux&quot;.&lt;/p&gt;&lt;p&gt;Sachant qu'il y a 240 000 poux (en moyenne 10 par tête), et qu'il y a 2 fois plus de &quot;pas papous à poux&quot; que de &quot;papous à poux&quot;, déterminer le nombre de &quot;papous pas papas à poux&quot;.&lt;/p&gt;\" title=\"Les papous\" type=\"2\"/><riddle answer=\"4\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Pensez aux multiples.&lt;/p&gt;\" image=\"door\" solution=\"&lt;p&gt;Jacques fait 20 passages.&lt;br/&gt;Au passage x, il ouvre les portes dont le numéro est multiple de x.&lt;br/&gt;Il faut donc compter le nombre de diviseurs pour chaque porte. Les portes ayant un nombre de multiple impair seront ouvertes.&lt;br/&gt;Il y aura donc 4 portes d'ouvertes.&lt;br/&gt;&lt;br/&gt;Liste : &lt;br/&gt;1 : 1 (Ouverte)&lt;br/&gt;2 : 2,1 &lt;br/&gt;3 : 3, 1&lt;br/&gt;4 : 4, 2, 1 (Ouverte)&lt;br/&gt;5 : 5, 1&lt;br/&gt;6 : 6, 3, 2, 1&lt;br/&gt;7 : 7, 1&lt;br/&gt;8 : 8, 4, 2, 1&lt;br/&gt;9 : 9, 3, 1 (Ouverte)&lt;br/&gt;10 : 10, 5, 2, 1&lt;br/&gt;11 : 11, 1&lt;br/&gt;12 : 12, 6, 4, 3, 2, 1&lt;br/&gt;13 : 13, 1&lt;br/&gt;14 : 14, 7, 2, 1&lt;br/&gt;15 : 15, 5, 3, 1&lt;br/&gt;16 : 16, 8, 4, 2, 1 (Ouverte)&lt;br/&gt;17 : 17, 1&lt;br/&gt;18 : 18, 9, 6, 3, 2, 1&lt;br/&gt;19 : 19, 1&lt;br/&gt;20 : 20, 10, 5, 4, 2, 1&lt;/p&gt;\" text=\"&lt;p&gt;Jacques est dans une salle circulaire où se trouvent 20 portes numérotées de 1 à 20. Elles sont toutes fermées.&lt;/p&gt;&lt;p&gt;A chaque fois que Jacques s'arrête devant une porte, il l'ouvre si elle est fermée, il la ferme si elle est ouverte.&lt;/p&gt;&lt;p&gt;Il décide de faire 20 passages.&lt;/p&gt;&lt;p&gt;Au premier passage, il s'arrête devant chaque porte.&lt;/p&gt;&lt;p&gt;Au deuxième passage, il s'arrête devant 1 porte sur 2 (en commençant par la deuxième : 2 - 4 - 6?).&lt;/p&gt;&lt;p&gt;Puis 1 sur 3 (en commençant par la troisième : 3 - 6 - 9?).&lt;/p&gt;&lt;p&gt;Et ainsi de suite jusqu'à faire 20 passages.&lt;/p&gt;&lt;p&gt;Combien de portes seront ouvertes à la fin ?&lt;/p&gt;\" title=\"Les portes\" type=\"2\"/><riddle answer=\"aspirine\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;N'hésitez pas à construire un tableau.&lt;/p&gt;\" image=\"pharmacy\" solution=\"&lt;p&gt;Par déduction logique, on trouve que Ginette a acheté de l'aspirine.&lt;/p&gt;\" text=\"&lt;p&gt;Le pharmacien n'a eu que 4 clientes aujourd'hui.&lt;/p&gt;&lt;p&gt;Malheureusement, il a mélangé toutes les factures.&lt;/p&gt;&lt;p&gt;Il ne se souvient que de très peu de choses de la journée : &lt;/p&gt;&lt;p&gt; - Denise, qui est venue avant Yvette a acheté un sirop contre la toux.&lt;br/&gt; - La deuxième cliente, qui n'est pas Jeannine, a pris de l'aspirine.&lt;br/&gt; - Juste avant celle qui a acheté des cigarettes à l'eucalyptus, Yvette a acheté une brosse à dents.&lt;/p&gt;&lt;p&gt;Quel fût le produit acheté par Ginette chez son pharmacien ?&lt;/p&gt;\" title=\"Le pharmacien\" type=\"2\"/><riddle answer=\"2|4\" answer_type=\"4\" copyright=\"\" hint=\"&lt;p&gt;N'hésitez pas à faire des essais.&lt;/p&gt;\" image=\"lebal\" solution=\"&lt;p&gt;Nelly est à la 2ième ou 4ième position.&lt;/p&gt;\" text=\"&lt;p&gt;Lise organise une soirée costumée sur le thème &quot;Sans couleurs&quot;.&lt;/p&gt;&lt;p&gt;Tous les invités sont habillés d'une unique couleur du blanc au noir en passant par des nuances de gris.&lt;/p&gt;&lt;p&gt;Lise prend une photo, et une fois cette soirée finie, elle la montre à ses parents en leur disant : &lt;/p&gt;Jean-Baptiste et Sébastien font la même taille,&lt;br/&gt;Stéphanie et Sébastien étaient habillées de la même couleur,&lt;br/&gt;Marie et Stéphanie ne font pas la même taille,&lt;br/&gt;Jean-Baptiste et Marie n'étaient pas habillés de la même couleur.&lt;/p&gt;&lt;p&gt;Au dessus de quel numéro se trouve Nelly ?&lt;/p&gt;\" title=\"Le bal costumé\" type=\"2\"/><riddle answer=\"tarot\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Faites un tableau.&lt;/p&gt;\" image=\"game\" solution=\"&lt;p&gt;- Marie Joe préfère le poker,&lt;br/&gt;- Jérôme les dames,&lt;br/&gt;- Romain les jeux vidéo,&lt;br/&gt;- Nicolas les échecs.&lt;br/&gt;&lt;br/&gt;Donc Christelle préfère le tarot.&lt;/p&gt;\" text=\"&lt;p&gt;Un groupe d'amis a pour passion commune les jeux.&lt;/p&gt;&lt;p&gt;Ils jouent souvent tous ensemble, mais ils ont quand même certaines préférences (un jeu chacun).&lt;/p&gt;&lt;p&gt;Ils jouent régulièrement à ces jeux : &lt;br/&gt; - Tarot,&lt;br/&gt; - Echecs,&lt;br/&gt; - Dames,&lt;br/&gt; - Jeux Vidéo,&lt;br/&gt; - Poker.&lt;br/&gt;&lt;p&gt;On sait que : &lt;/p&gt;Jérôme et Romain n'affectionnent pas trop les jeux de cartes, ce qui n'est pas le cas de Marie-Joe.&lt;br/&gt;Marie-Joe et Nicolas ont récemment passé une soirée avec la personne qui aime le tarot et celle qui aime les dames.&lt;br/&gt;Romain joue souvent avec ceux qui aiment les jeux de plateaux.&lt;br/&gt;&lt;p&gt;Quel est le jeu préféré de Christelle ?&lt;/p&gt;\" title=\"Les joueurs\" type=\"2\"/><riddle answer=\"2\" answer_type=\"0\" copyright=\"Proposé par Kyrou.\" hint=\"&lt;p&gt;Attention, à la distance parcourue sur les rondins.&lt;/p&gt;\" image=\"pyramid\" solution=\"&lt;p&gt;2m, car après un tour de rondin, le rondin a avancé de 1m par rapport au sol. La pierre a avancé de 1m par rapport au rondin, soit 1+1=2m entre le point de départ au sol et la pierre.&lt;/p&gt;\" text=\"&lt;p&gt;A l'époque des Égyptiens, on transportait les pierres grâce à des rondins de bois. Soit une pierre de 10m de long sur 1m de large, posée sur 10 rondins. Chaque rondin fait exactement un mètre de circonférence. &lt;/p&gt;&lt;p&gt;Lorsque les rondins auront parcouru 1m, quelle distance aura parcouru la pierre (en mètres)?&lt;/p&gt;\" title=\"Les pyramides\" type=\"2\"/><riddle answer=\"381654729\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Le 5 ne devrait pas être trop dur.&lt;/p&gt;\" image=\"formula\" solution=\"&lt;p&gt;381654729&lt;br/&gt;&lt;br/&gt;3 / 1 = 3&lt;br/&gt;38 / 2 = 19&lt;br/&gt;381 / 3 = 127&lt;br/&gt;3816 / 4 = 954&lt;br/&gt;38165 / 5 = 7633&lt;br/&gt;381654 / 6 = 63609&lt;br/&gt;3816547 / 7 = 545221&lt;br/&gt;38165472 / 8 = 4770684&lt;br/&gt;381654729 / 9 = 42406081&lt;/p&gt;\" text=\"&lt;p&gt;Soit un nombre composé de neufs chiffres distincts (de 1 à 9) disposés de telle sorte que : &lt;/p&gt;&lt;p&gt; - le premier chiffre soit divisible par un,&lt;br/&gt; - le nombre formé des deux premiers chiffres soit divisible par deux,&lt;br/&gt; - le nombre formé par les trois premiers chiffres divisible par trois,&lt;br/&gt; - le nombre formé par les quatre premiers chiffres divisible par quatre.&lt;br/&gt; - et ainsi de suite jusqu'à 9.&lt;/p&gt;&lt;p&gt;Quel est ce nombre ?&lt;/p&gt;\" title=\"Les diviseurs\" type=\"2\"/><riddle answer=\"2/3\" answer_type=\"2\" copyright=\"Proposé par Simon M.\" hint=\"&lt;p&gt;L'intervention du présentateur remet en question les probabilités.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Vous avez 2 chances sur 3 de gagner si vous changez d'avis une fois l'intervention du présentateur.&lt;br/&gt;&lt;br/&gt;Voici l'explication (source : Wikipedia, Problème de Monty Hall)&lt;br/&gt;&lt;br/&gt;- Le premier affirme qu'après ouverture de la porte, il reste deux portes, chacune ayant tout autant de chances de cacher la voiture. On a donc tout autant de chances de gagner avec changement que sans changement.&lt;br/&gt;- Le second affirme que si l'on ne change pas de porte, on gagne si et seulement si on avait fait le bon choix au départ. Or ce choix avait une chance sur trois d'être bon. Il y a donc 1/3 de chances de gagner sans changer, 2/3 de chances de gagner en changeant.&lt;/p&gt;\" text=\"&lt;p&gt;Let's make a deal est un jeu télévisé américain.&lt;/p&gt;&lt;p&gt;Le jeu oppose le présentateur à un candidat (vous). Vous êtes face à trois portes fermées. Derrière l'une d'elles se trouve une voiture et derrière chacune des deux autres se trouve une chèvre.&lt;/p&gt;&lt;p&gt;Vous devez tout d'abord désigner une porte.&lt;/p&gt;&lt;p&gt;Puis le présentateur dévoile une porte qui n'est ni celle que vous avez choisie, ni celle cachant la voiture (le présentateur sait où se trouve la voiture).&lt;/p&gt;&lt;p&gt;Vous avez alors le droit ou bien d'ouvrir la porte que vous avez choisie initialement, ou bien d'ouvrir l'autre.&lt;/p&gt;&lt;p&gt;Quelle est la probabilité que vous remportiez la voiture si vous décidez de changer d'avis après l'intervention du présentateur ?&lt;/p&gt;&lt;p&gt;(Le résultat doit être proposé sous la forme d'une fraction)&lt;/p&gt;\" title=\"Let's make a deal\" type=\"2\"/><riddle answer=\"z\" answer_type=\"2\" copyright=\"Proposé par PG.\" hint=\"&lt;p&gt;Essayez toutes les possibilités.&lt;/p&gt;\" image=\"hatsherlock\" solution=\"&lt;p&gt;C'est Monsieur Z.&lt;br/&gt;&lt;br/&gt;Il faut partir de SI monsieur U est le tueur, ainsi sa première affirmation est fausse et les trois autres vraies, la logique suit et on retrouve les fausses et les vraies pour chacun, sauf pour un où il y a contradiction à chaque fois. On fait cela pour chaque suspect, et arrivé à monsieur Z, toutes les affirmations coïncident.&lt;/p&gt;Une autre méthode est de partir du fait que l'affirmation &quot;Le crime a eu lieu le 17 mars&quot; est fausse, de là, vous pouvez déduire facilement le reste de l'énigme.&lt;/p&gt;\" text=\"&lt;p&gt;Il y a eu, le 06/12/2010, un crime au 1564, boulevard de la coquille.&lt;/p&gt;&lt;p&gt;La victime, Monsieur C., a été exécutée d'une balle de revolver en pleine tête! La police a interpellé cinq suspects.&lt;/p&gt;&lt;p&gt;Chacun a donné quatre affirmations, dont 3 sont vraies et 1 est fausse pour chaque suspect.&lt;/p&gt;&lt;p&gt;Voici leurs déclarations :&lt;/p&gt;&lt;p&gt;Monsieur X :&lt;br/&gt; - &quot;Je me trouvais à Lyon au moment du meurtre.&quot;&lt;br/&gt; - &quot;Je n'ai jamais tué quelqu'un.&quot;&lt;br/&gt; - &quot;Monsieur U est le meurtrier.&quot;&lt;br/&gt; - &quot;Monsieur T et moi sommes amis.&quot;&lt;/p&gt;&lt;p&gt;Monsieur Y :&lt;br/&gt; - &quot;Je n'ai pas tué.&quot;&lt;br/&gt; - &quot;Je n'ai jamais eu de revolver entre les mains.&quot;&lt;br/&gt; - &quot;Monsieur U me connaît.&quot;&lt;br/&gt; - &quot;Je me trouvais à Toulouse le 6 décembre 2010.&quot;&lt;/p&gt;&lt;p&gt;Monsieur Z :&lt;br/&gt; - &quot;Monsieur Y ment lorsqu'il dit qu'il n'a jamais eu de revolver entre les mains.&quot;&lt;br/&gt; - &quot;Le crime a été commis le 17 mars.&quot;&lt;br/&gt; - &quot;Monsieur X était à Lyon au moment du meurtre.&quot;&lt;br/&gt; - &quot;L'un de nous est le meurtrier.&quot;&lt;/p&gt;&lt;p&gt;Monsieur T :&lt;br/&gt; - &quot;Je n'ai pas tué.&quot;&lt;br/&gt; - &quot;Monsieur U n'a jamais été à Ivry-sur-Seine.&quot;&lt;br/&gt; - &quot;Je n'ai jamais rencontré Monsieur X avant aujourd'hui.&quot;&lt;br/&gt; - &quot;Monsieur Y et moi étions à Toulouse le 17 mars 1998.&quot;&lt;/p&gt;&lt;p&gt;Monsieur U :&lt;br/&gt; - &quot;Je n'ai pas tué.&quot;&lt;br/&gt; - &quot;Je ne suis jamais allé à Ivry-sur-Seine.&quot;&lt;br/&gt; - &quot;Je n'ai jamais rencontré Monsieur Y avant aujourd'hui.&quot;&lt;br/&gt; - &quot;Monsieur X a menti en disant que j'ai tué.&quot;&lt;/p&gt;&lt;p&gt;L'inspecteur chargé de l'enquête, réputé dans la profession pour sa logique, a examiné une à une chacune des affirmations avant de rendre son verdict. Qui est le meurtrier (Entrez sa lettre)?&lt;/p&gt;\" title=\"L'enquête insoluble\" type=\"2\"/><riddle answer=\"8\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Il faut poser le problème.&lt;/p&gt;\" image=\"barrel\" solution=\"&lt;p&gt;Il faut 8 tonneaux.&lt;br/&gt;&lt;br/&gt;Preuve mathématique : &lt;br/&gt;&lt;br/&gt;On pose le problème&lt;br/&gt; 2t = 11p + 6g (1)&lt;br/&gt; 3t = 20p + 7g (2)&lt;br/&gt; Xt = 9p + 44g (3)&lt;br/&gt;&lt;br/&gt;On transforme les 2 premières lignes : &lt;br/&gt; 6t = 33p + 18g (1)&lt;br/&gt; 6t = 40p + 14g (2)&lt;br/&gt;&lt;br/&gt;On voit que (1) = (2)&lt;br/&gt; 33p + 18g = 40p + 14g&lt;br/&gt; 18g - 14g = 40p - 33p&lt;br/&gt; 4g = 7p&lt;br/&gt;&lt;br/&gt;On peut donc en déduire que : p = 4/7g et g = 7/4p.&lt;br/&gt;&lt;br/&gt;En reprenant la première formule (1) :  &lt;br/&gt;2t = 11 * 4/7g + 6g&lt;br/&gt;g = 14/86t, puis&lt;br/&gt;p = 8/86t&lt;br/&gt;&lt;br/&gt;Xt = 9 * 8/86t + 44 * 14/86t&lt;br/&gt;&lt;br/&gt;X = 8.&lt;/p&gt;\" text=\"&lt;p&gt;Un patron demande d'avoir plus de précisions sur les notes de son sommelier.&lt;/p&gt;&lt;p&gt;Celui-ci lui a indiqué : &lt;br/&gt; - 2 tonneaux remplissent 11 petits verres et 6 grands.&lt;br/&gt; - 3 tonneaux remplissent 20 petits verres et 7 grands.&lt;/p&gt;&lt;p&gt;Ce soir, il lui a dit avoir servi 9 petits verres et 44 grands verres.&lt;/p&gt;&lt;p&gt;Combien de tonneaux ont été servis ?&lt;/p&gt;\" title=\"Le sommelier\" type=\"2\"/><riddle answer=\"1588\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Le même nombre de voix moins 25&lt;/p&gt;\" image=\"ballot\" solution=\"&lt;p&gt;Il a eu 1588 voix. La façon la plus simple pour trouver la solution est de poser un système d'équation (très simple).&lt;br/&gt;&lt;br/&gt;v1 + v2 + v3 + v4 = 6217&lt;br/&gt;&lt;br/&gt;v2 = v1 - 25&lt;br/&gt;v3 = v1 - 40&lt;br/&gt;v4 = v1 - 70&lt;br/&gt;&lt;br/&gt;On a donc v1 + v1 - 25 + v1 - 40 + v1 - 70 = 6217&lt;br/&gt;-&gt;v1 = 1588&lt;/p&gt;\" text=\"&lt;p&gt;Un maire a été élu parmi 4 candidats au cours d'une élection où 6217 personnes ont voté (aucun bulletin blanc).&lt;/p&gt;&lt;p&gt;Il a eu 25 voix de plus que le deuxième, 40 de plus que le troisième et 70 de plus que le quatrième.&lt;/p&gt;&lt;p&gt;Combien de voix le maire a-t-il obtenu ?&lt;/p&gt;\" title=\"L'élection\" type=\"2\"/><riddle answer=\"baisse|descen|diminu\" answer_type=\"3\" copyright=\"Proposé par Raph.\" hint=\"&lt;p&gt;Volume, masse.&lt;/p&gt;\" image=\"boat\" solution=\"&lt;p&gt;Le niveau de l'eau baisse.&lt;br/&gt;&lt;br/&gt;Avec le rocher, la barque est plus lourde, pour qu'elle puisse flotter, elle va déplacer un volume d'eau plus important que lorsqu'elle est plus légère. (sans le rocher).&lt;br/&gt;Le rocher ayant un volume faible par rapport à la barque il va déplacer un volume d'eau plus faible que celui déplacé par la barque chargée du rocher.&lt;/p&gt;&lt;p&gt;On peut aussi tout simplement prendre en compte que la masse volumique du rocher est supérieur à l'eau.&lt;/p&gt;\" text=\"&lt;p&gt;Sur un lac se trouve une barque sur laquelle il y a un énorme rocher. Le capitaine jette ce rocher à l'eau. Que devient le niveau de l'eau du lac ?&lt;/p&gt;\" title=\"La pierre\" type=\"2\"/><riddle answer=\"1089\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;9 étant proche de 10, on a vite fait de rajouter un chiffre.&lt;/p&gt;\" image=\"formula\" solution=\"&lt;p&gt;1089.&lt;br/&gt;&lt;br/&gt;1089 x 9 = 9801&lt;/p&gt;\" text=\"&lt;p&gt;Quel est le plus petit nombre dont les chiffres qui le composent s'inversent quand on le multiplie par 9 (Ce nombre doit être supérieur à 0)?&lt;/p&gt;\" title=\"Inverse par 9\" type=\"2\"/><riddle answer=\"6\" answer_type=\"0\" copyright=\"Proposé par Nissim.\" hint=\"&lt;p&gt;un sac de blé = 3/4 d'un sac de blé + 2 kilos.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La réponse est 6kg.&lt;br/&gt;&lt;br/&gt;b = (3/4)*(b + 2)&lt;br/&gt;(4/3) * b = b + 2&lt;br/&gt;b / 3 = 2&lt;br/&gt;b = 6&lt;/p&gt;\" text=\"&lt;p&gt;Un sac de blé pèse les trois quarts d'un sac d'orge pesant 2kg de plus qu'un sac de blé.&lt;/p&gt;&lt;p&gt;Combien pèse le sac de blé ?&lt;/p&gt;\" title=\"Les sacs\" type=\"2\"/><riddle answer=\"1928\" answer_type=\"0\" copyright=\"Proposé par Tommy.\" hint=\"&lt;p&gt;Les nombres insérés sont également pris en compte.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La combinaison est 1928. La phrase doit être complétée comme suit : &quot; Cette phrase a dix-neuf voyelles et vingt-huit consonnes. &quot;&lt;/p&gt;\" text=\"&lt;p&gt;Un homme riche et célèbre qui aime les devinettes a des pertes de mémoire fréquentes. Pour palier son problème, il écrit tout sous forme de devinettes dans son journal personnel et place tous ses biens selon un ordre précis. Un certain matin, il veut montrer à un de ses amis une nouvelle montre qui vaut près de 1000$ et qu'il s'est acheté la journée précédente. Il se déplace dans sa pièce aux coffres et regarde le registre. Il remarque que les objets de petite valeur sont placés dans le coffre 13654. Il se dirige vers ce coffre et ne se rappelle malheureusement plus de la combinaison.&lt;/p&gt;&lt;p&gt;Il se rend alors dans sa chambre et ouvre son journal personnel. Sur la page du coffre 13654, il est marqué « Pour retrouver la combinaison du coffre, il faut remplacer les blancs de la phrase qui suit par des nombres en faisant en sorte que la phrase reste cohérente». Il lit ensuite la phrase et se dirige vers le coffre, essaye 1318, mais après un court instant de réflexion, il rentre un autre nombre et l'ouvre.&lt;/p&gt;&lt;p&gt;La phrase : &lt;i&gt;&quot;Cette phrase a ... voyelles et ... consonnes.&quot;&lt;/i&gt;&lt;/p&gt;&lt;p&gt;Quelle est la combinaison que l'homme riche a entré sur le clavier de son coffre pour l'ouvrir ?&lt;/p&gt;\" title=\"Le coffre\" type=\"2\"/><riddle answer=\"23\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Calculez déjà la possibilité que 2 personnes n'aient pas la même date d'anniversaire.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;23 personnes.&lt;br/&gt;&lt;br/&gt;La probabilité que 2 personnes n'aient pas le même jour d'anniversaire est de 1 - 1/365.&lt;br/&gt;Pour 3 personnes : (1 - 1/365)(1 - 2/365)&lt;br/&gt;&lt;br/&gt;On continue le raisonement : (1 - 1/365)(1 - 2/365)...(1 - (k - 1)/365).&lt;br/&gt;&lt;br/&gt;A 23, on a 49% de chance que deux personnes n'aient pas leur anniversaire commun dans le groupe, donc 51% de chance que 2 personnes aient leur anniversaire en commun.&lt;/p&gt;\" text=\"&lt;p&gt;Combien faut-il de personnes au minimum, choisies aléatoirement dans un groupe, pour que la probabilité que 2 de ces personnes aient la même date d'anniversaire soit supérieure à 1 chance sur 2 ?&lt;/p&gt;&lt;p&gt;(Pour simplifier les calculs, les années bissextiles ne seront pas prises en compte.)&lt;/p&gt;\" title=\"Les anniversaires\" type=\"2\"/><riddle answer=\"50\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Pythagore.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le diamètre du cercle est de 50 mètres.&lt;/p&gt;&lt;p&gt;Le scientifique fait un angle droit en se dirigeant vers l'ouest. Si il revenait à son point de départ, il aurait tracé un triangle rectangle.&lt;/p&gt;&lt;p&gt;Si un triangle rectangle est inscrit dans un cercle (tous ses sommets &quot;touchent&quot; les bords du cercle), alors le diamètre de ce dernier est égal à l'hypoténuse.&lt;/p&gt;&lt;p&gt;Le scientifique ayant parcouru les 2 plus petits côtés du triangle rectangle, nous pouvons appliquer le théorème de Pythagore : &lt;i&gt;&quot;L'hypoténuse au carré est égal à la somme des deux autres côtés au carré&quot;&lt;/i&gt;.&lt;/p&gt;&lt;p&gt;Hypoténuse^2 = 30^2 + 40^2&lt;br/&gt;Hypoténuse^2 = 2500&lt;br/&gt;Hypoténuse = racine carré de 2500 = 50&lt;/p&gt;&lt;p&gt;Le diamètre est de 50 mètres.&lt;/p&gt;\" text=\"&lt;p&gt;Un scientifique décide de mesurer la taille d'un cercle à l'aide d'une boussole et d'un mètre très précis.&lt;/p&gt;&lt;p&gt;Pour cela, il se met à un point quelconque du cercle situé au sud-est et se dirige vers le nord jusqu'à un autre point du cercle. Il parcourt de cette façon 30 mètres.&lt;/p&gt;&lt;p&gt;Il répète ensuite ce procédé du point où il est arrivé en partant vers l'ouest et parcourt 40 mètres.&lt;/p&gt;&lt;p&gt;Quel est le diamètre du cercle en mètres ?&lt;/p&gt;\" title=\"La science infuse\" type=\"2\"/><riddle answer=\"28\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Décalage d'1 ou 2 jours ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Elle aura 28 ans.&lt;/p&gt;&lt;p&gt;Toutes les années &quot;normales&quot;, les dates se décalent de 1 jour (lundi devient mardi).&lt;/p&gt;&lt;p&gt;Les années bissextiles, elles se décalent de 2 jours.&lt;/p&gt;&lt;p&gt;Entre deux 29 février, il y a 5 jours de décalage.&lt;/p&gt;&lt;p&gt;Il faudra donc un multiple de 7 et 4, soit 28.&lt;/p&gt;\" text=\"&lt;p&gt;Christelle est née un samedi 29 février.&lt;/p&gt;&lt;p&gt;Quel âge aura-t-elle la prochaine fois qu'elle fêtera son premier anniversaire un samedi 29 février ?&lt;/p&gt;\" title=\"Joyeux anniversaire\" type=\"2\"/><riddle answer=\"714217\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;x * 2 = yy. Donc x &gt;= 5.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;714217&lt;/p&gt;\" text=\"&lt;p&gt;Trouvez un nombre de 6 chiffres dont : &lt;/p&gt;&lt;p&gt; - Le premier et le dernier chiffre sont les mêmes.&lt;br/&gt; - Le premier chiffre multiplié par 2 produit un nombre à 2 chiffres. Ce nombre est le deuxième et troisième chiffre.&lt;br/&gt; - Le dernier chiffre multiplié par 3 donne un nombre à 2 chiffres. Ce nombre est le quatrième et cinquième chiffre.&lt;br/&gt; - La somme des 6 chiffres est égale à 22.&lt;/p&gt;\" title=\"6 chiffres\" type=\"2\"/><riddle answer=\"46824\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Posez un système d'équations.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;46824&lt;/p&gt;&lt;p&gt;Le chiffre a la forme suivante : ABCDE.&lt;/p&gt;&lt;p&gt;On peut ressortir 4 équations : &lt;/p&gt;&lt;p&gt;A = B - 2&lt;/p&gt;&lt;p&gt;A = C - 4&lt;/p&gt;&lt;p&gt;D = C / 4&lt;/p&gt;&lt;p&gt;C = A + E&lt;/p&gt;&lt;p&gt;On peut aussi voir que A est supérieur à 0&lt;/p&gt;&lt;p&gt;C doit être multiple de 4 (sinon D ne serait pas entier)&lt;/p&gt;&lt;p&gt;C &lt; 9.&lt;/p&gt;&lt;p&gt;Nous avons donc deux possibilités pour C, 4 ou 8. Si C = 4 alors A = 0, ce qui n'est pas possible. Donc C = 8 et les formules nous donnent le reste.&lt;/p&gt;\" text=\"&lt;p&gt;Soit un nombre composé de 5 chiffres : &lt;/p&gt;&lt;p&gt;Le premier chiffre fait 2 de moins que le deuxième chiffre,&lt;br/&gt;Le premier chiffre fait 4 de moins que le troisième chiffre,&lt;br/&gt;Le quatrième chiffre représente un quart du troisième,&lt;br/&gt;La somme du premier et du dernier chiffre est égale au troisième chiffre.&lt;/p&gt;&lt;p&gt;Quel est ce nombre ?&lt;/p&gt;&lt;p&gt;Ce nombre ne doit pas commencer par zéro.&lt;/p&gt;\" title=\"Le nombre cassé\" type=\"2\"/><riddle answer=\"7\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Une ancienne façon d'écrire&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;7.&lt;/p&gt;&lt;p&gt;Il faut prendre les nombres écrits en chiffres romains et les couper horizontalement : &lt;/p&gt;&lt;p&gt;10 ; X &gt; 5 ; V&lt;/p&gt;&lt;p&gt;9 ; IX &gt; 4 ; IV&lt;/p&gt;&lt;p&gt;11 ; XI &gt; 6 ; VI&lt;/p&gt;&lt;p&gt;12 ; XII &gt; 7 ; VII&lt;/p&gt;\" text=\"&lt;p&gt;5 est la moitié de 10,&lt;br/&gt;4 est la moitié de 9,&lt;br/&gt;6 est la moitié de 11.&lt;/p&gt;&lt;p&gt;Quelle est la moitié de 12 selon cette logique ?&lt;/p&gt;\" title=\"Moitiés folles\" type=\"2\"/><riddle answer=\"101\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;L'âge est forcément un entier.&lt;/p&gt;\" image=\"boat\" solution=\"&lt;p&gt;101 hommes d'équipage.&lt;/p&gt;X jour&lt;br/&gt;Y mois&lt;br/&gt;1900 + Z&lt;br/&gt;U hélices&lt;br/&gt;V cheminées&lt;br/&gt;W hommes&lt;br/&gt;C racine cubique de l'âge du capitaine&lt;br/&gt;&lt;p&gt;UVWXYZ + C = 4002331&lt;/p&gt;&lt;p&gt;On sait que le produit UVWXYZ est un entier donc C est un entier&lt;/p&gt;&lt;p&gt;Les racines cubiques entières sont 2 (pour 8), 3 (pour 27), 4 (pour 64), 5 (pour 125). La racine est donc 4 et l'âge du capitaine 64 ans.&lt;/p&gt;&lt;p&gt;UVWXYZ = 4002327 avec les contraintes suivantes : &lt;/p&gt;X &lt;= 31&lt;br/&gt;Y &lt;= 12&lt;br/&gt;Z &lt;= 100&lt;br/&gt;U &lt;= 10&lt;br/&gt;V &lt;= 10&lt;br/&gt;&lt;p&gt;4002327 est divisible par 3 -&gt; 3 * 1334109&lt;br/&gt;1334109 est divisible par 3 -&gt; 3 * 444793&lt;br/&gt;444703 est divisible par 7 -&gt; 7 * 63529&lt;br/&gt;63529 est divisible par 17 -&gt; 17 * 3737&lt;br/&gt;3737 est égale a 37 * 101&lt;/p&gt;&lt;p&gt;Nous aurons donc 101 membres d'équipages, le 17 juillet 1937 et le bateau a 3 hélices et 3 cheminées&lt;/p&gt;\" text=\"&lt;p&gt;Un bateau a fait naufrage dans l'Atlantique le Xème jour du Yème mois de l'année 1900 + Z. Il avait U hélices, V cheminées et W membres d'équipage.&lt;/p&gt;&lt;p&gt;Le produit U * V * W * X * Y * Z auquel on rajoute la racine cubique de l'âge du capitaine qui est grand-père donne 4002331.&lt;/p&gt;&lt;p&gt;Combien y a-t-il de membres d'équipage&lt;/p&gt;&lt;p&gt;Le nombre de cheminées et d'hélices est inférieur à 10.&lt;/p&gt;\" title=\"Capitaine abandonné\" type=\"2\"/><riddle answer=\"18h00\" answer_type=\"2\" copyright=\"\" hint=\"&lt;p&gt;Ecart à chaque heure.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;18h00&lt;/p&gt;&lt;p&gt;Les montres s'éloignent l'une de l'autre de 20 minutes à chaque heure.&lt;/p&gt;&lt;p&gt;Elles ont 2h de décalage, cela fait donc 6h que les montres ont été réglées.&lt;/p&gt;\" text=\"&lt;p&gt;Deux amies, Stéphanie et Marie, ont réglé leurs montres ensembles. Cependant, celle de Stéphanie avance de 10 minutes par heure et indique 19h, alors que celle de Marie qui retarde de 10 minutes par heure indique 17h.&lt;/p&gt;&lt;p&gt;Quelle heure est-il ?&lt;/p&gt;&lt;p&gt;(La réponse devra être notée sous la forme 12h34)&lt;/p&gt;\" title=\"Les montres\" type=\"2\"/><riddle answer=\"3\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Un mensonge ne concerne pas forcément les 2 personnes désignées.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il y a 3 menteurs.&lt;/p&gt;&lt;p&gt;Nommons les 5 personnes A, B, C, D et E.&lt;/p&gt;&lt;p&gt;Il y a forcément un menteur car si A dit la vérité, B et C annonce que A est un menteur.&lt;/p&gt;&lt;p&gt;Nous prenons donc arbitrairement A pour le premier menteur. Donc E et / ou B disent la vérité.&lt;/p&gt;&lt;p&gt;Par symétrie, on peut faire le cas ou 1 seul des 2 ment. B dit la vérité, E ment&lt;/p&gt;&lt;p&gt;B annonce que A et C sont des menteurs.&lt;/p&gt;&lt;p&gt;A ce stage, nous avons donc A (menteur), B (vérité), C (menteur).&lt;/p&gt;&lt;p&gt;Si D dit la vérité, alors C et E mentent, E mentant sur D mais pas sur A.&lt;/p&gt;&lt;p&gt;Si D ment, alors 5 dit la vérité et C reste peut rester menteur.&lt;/p&gt;&lt;p&gt;Pour le cas de départ où E et B disent la vérité, nous nous retrouverons dans la configuration trouvé précédemment par rotation.&lt;/p&gt;&lt;p&gt;Il y a donc 3 menteurs (A, C, E ou A, C, D).&lt;/p&gt;\" text=\"&lt;p&gt;Autour d'une table ronde se trouvent 5 personnes. Ils affirment tous que leur voisins directs à gauche et à droite sont des menteurs.&lt;/p&gt;&lt;p&gt;Les menteurs répondent toujours un mensonge et tout le monde connait la vérité sur les 5 personnes.&lt;/p&gt;&lt;p&gt;Combien y a-t-il de menteurs autour de la table ?&lt;/p&gt;\" title=\"Les menteurs\" type=\"2\"/><riddle answer=\"20\" answer_type=\"0\" copyright=\"Proposée par JB.\" hint=\"&lt;p&gt;Nombre de participants moins 1.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il y a 20 candidates.&lt;/p&gt;&lt;p&gt;On a x possibilités de gagnantes, et donc x-1 possibilités pour la seconde place. Ce qui nous donne x(x-1)=380.&lt;/p&gt;&lt;p&gt;Il n'y a plus qu'à résoudre le polynôme x^2-x-380=0&lt;/p&gt;&lt;p&gt;a = 1, b = -1, c = -380&lt;/p&gt;&lt;p&gt;delta = b^2 - 4*a*c = (-1)^2 - 4*1*(-380) = 1521&lt;/p&gt;&lt;p&gt;x1 = (-b + racine(delta)) / 2*a&lt;/p&gt;&lt;p&gt;x2 = (-b - racine(delta)) / 2*a&lt;/p&gt;&lt;p&gt;x1 = -(-1) + racine(1521) / 2&lt;/p&gt;&lt;p&gt;   = (1 + 39) / 2&lt;/p&gt;&lt;p&gt;   = 40 / 2&lt;/p&gt;&lt;p&gt;   = 20&lt;/p&gt;\" text=\"&lt;p&gt;Aujourd'hui a lieu l'élection de Miss Camping.&lt;/p&gt;&lt;p&gt;Les juges ont calculé qu'il y a 380 possibilités différentes de combinaisons de miss et dauphine.&lt;/p&gt;&lt;p&gt;Combien y a-t-il de candidates ?&lt;/p&gt;\" title=\"Miss camping\" type=\"2\"/><riddle answer=\"60\" answer_type=\"0\" copyright=\"Proposée par Pouf14.\" hint=\"&lt;p&gt;Reformulez la première phrase.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;60 ans.&lt;/p&gt;&lt;p&gt;Il faut reformuler la première phrase ce qui donne : Si j'avais ton âge (actuel), mon âge (actuel) serait égal à 10 fois ton âge (passé).&lt;/p&gt;&lt;p&gt;Nous notons P (l'âge du père), P' (l'âge qu'aurait le père), F (l'âge du fils), F' (l'âge qu'aurait le fils).&lt;/p&gt;&lt;p&gt;Si le père avait l'âge du fils alors le père aurait P' = P - (P - F) = F.&lt;/p&gt;&lt;p&gt;Le fils aurait donc F' = F - (P - F) = 2F - P.&lt;/p&gt;&lt;p&gt;On sait que P = 10*F'&lt;/p&gt;&lt;p&gt;P = 10*(2F - P)&lt;/p&gt;&lt;p&gt;P = 20F - 10P&lt;/p&gt;&lt;p&gt;11P = 20F&lt;/p&gt;&lt;p&gt;P = (20/11)F&lt;/p&gt;&lt;p&gt;La deuxième phrase dit que P + F = 93.&lt;/p&gt;&lt;p&gt;Donc P = (20/11) * (93 - P)&lt;/p&gt;&lt;p&gt;P = (20/11)*93 - (20/11)*P&lt;/p&gt;&lt;p&gt;P + (20/11)*P = (20/11)*93&lt;/p&gt;&lt;p&gt;P * (1 + 20/11) = 1860/11&lt;/p&gt;&lt;p&gt;P * (31/11) = 1860/11&lt;/p&gt;&lt;p&gt;P = 1860 / 31 = 60&lt;/p&gt;&lt;p&gt;Donc le fils a 33 ans, le père 60.&lt;/p&gt;\" text=\"&lt;p&gt;Un père dit à son fils : &quot;J'ai 10 fois l'âge que tu aurais si j'avais l'âge que tu as. Et à nous deux, nous avons 93 ans&quot;.&lt;/p&gt;&lt;p&gt;Quel est l'âge du père ?&lt;/p&gt;\" title=\"De père à fils\" type=\"2\"/><riddle answer=\"n\" answer_type=\"2\" copyright=\"Proposée par Donovan.\" hint=\"&lt;p&gt;Toutes ces lettres tournent autour d'un point.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;N pour Neptune.&lt;/p&gt;&lt;p&gt;Les lettres représentent les planètes du système solaire.&lt;/p&gt;\" text=\"&lt;p&gt;Quelle est la lettre suivante de cette suite : &lt;/p&gt;&lt;p&gt;M, V, T, M, J, S, U, ?&lt;/p&gt;\" title=\"Suite rotative\" type=\"2\"/><riddle answer=\"7\" answer_type=\"0\" copyright=\"Proposée par Dédé.\" hint=\"&lt;p&gt;Un nombre impair a perdu.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;7€.&lt;/p&gt;&lt;p&gt;Le dernier perdant est forcément celui qui a un nombre impair d'argent.&lt;/p&gt;&lt;p&gt;A la dernière partie, ils avait&lt;/p&gt;&lt;p&gt;R : 8, F : 9, L : 10&lt;/p&gt;&lt;p&gt;Donc Fifi à perdu la cinquième partie. A la fin de la 4ième partie ils avaient donc : &lt;/p&gt;&lt;p&gt;R : 4, F : 18, L : 5&lt;/p&gt;&lt;p&gt;Loulou a donc perdu la 4ième&lt;/p&gt;&lt;p&gt;R : 2, F : 9, L : 16&lt;/p&gt;&lt;p&gt;Fifi a perdu la 3ième&lt;/p&gt;&lt;p&gt;R : 1, F : 18, L : 8&lt;/p&gt;&lt;p&gt;Riri a perdu la 2ième&lt;/p&gt;&lt;p&gt;R : 14, F : 9, L : 4&lt;/p&gt;&lt;p&gt;Fifi a perdu la 1ière&lt;/p&gt;&lt;p&gt;R : 7, F : 18, L : 2&lt;/p&gt;&lt;p&gt;&lt;/p&gt;\" text=\"&lt;p&gt;Riri, Fifi et Loulou ont joué 5 parties d'un jeu avec des pièces de 1€.&lt;/p&gt;&lt;p&gt;Dans ce jeu, il est important de ne pas perdre, car le perdant devra doubler la somme totale des autres joueurs.&lt;/p&gt;&lt;p&gt;Sachant qu'à la fin, Riri possède 8€, Fifi 9€ et Loulou 10€, combien d'argent possédait Riri au début de la partie ?&lt;/p&gt;\" title=\"Jeu d'argent\" type=\"2\"/><riddle answer=\"rap\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Faites un tableau.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Zacharie chantait du Rap.&lt;/p&gt;&lt;p&gt;Zacharie a été classé 1er pour son audition de rap passée mercredi,&lt;/p&gt;&lt;p&gt;Camille a ete classée 3ème pour son audition de rock passée vendredi,&lt;/p&gt;&lt;p&gt;Edwin a ete classé 4ème pour son audition de salsa passée mardi,&lt;/p&gt;&lt;p&gt;Leeloo a ete classée 2ème pour son audition de jazz passée lundi,&lt;/p&gt;&lt;p&gt;Maya a ete classé 5ème pour son audition de classique passée jeudi.&lt;/p&gt;\" text=\"&lt;p&gt;Le directeur de l'école de musique voudrait savoir quel style de musique a chanté Zacharie.&lt;/p&gt;&lt;p&gt;Vous avez différentes affirmations qui vous permettront de trouver, pour chaque personne, son style musical, le jour de son audition et son classement au concours de chant.&lt;/p&gt; - Edwin a passé son audition avant la personne classée 5ème et après le jazz, que n'a pas chanté Camille.&lt;br/&gt; - La salsa, chantée ni par Camille ni par Leeloo, a été mieux classée que Maya et moins bien que la personne auditionnée mercredi.&lt;br/&gt; - L'audition de lundi a été classée après celle de Zacharie et avant le rock.&lt;br/&gt; - Le chant classique a eu lieu après celui classe 2ème et 1 jour avant le rock.&lt;br/&gt; - Maya a chante après le rap et avant la personne classée 3ème, qui n'est pas Zacharie.&lt;/p&gt;&lt;p&gt;Ce logigramme vient du site &lt;a href=&quot;http://www.netprof.fr/Voir-le-cours-en-video/Jeux/Logigrille/Logigrille.-Niveau-4-diabolique,10,22,142,1.aspx&quot;&gt;NetProf&lt;/a&gt; :  5 000 cours gratuits en vidéo.&lt;/p&gt;\" title=\"En chantant\" type=\"2\"/><riddle answer=\"frere\" answer_type=\"1\" copyright=\"Proposée par PYF.\" hint=\"&lt;p&gt;Même parent...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Sur la pile de gauche se trouve les personnes ayant au moins 1 frère.&lt;/p&gt;\" text=\"&lt;p&gt;C'est le jour d'un grand repas de famille. &lt;/p&gt;&lt;p&gt;Silvaine, 7 ans, récupère les prénoms des invités sur la table. Elle réfléchit un instant puis s'amuse à faire deux tas.&lt;/p&gt;&lt;p&gt;A gauche, elle met d'abord Paul son papa et à droite Denise sa maman. Son grand frère Yoan est placé à droite mais sa sœur Ludivine se retrouve à gauche. Son oncle paternel Gérard trouve sa place à gauche ainsi que sa tante paternelle Mireille. Par contre ses deux tantes maternelles Amandine et Monique sont mises à droite.&lt;/p&gt;&lt;p&gt;Enfin elle n'oublie pas de mettre son prénom dans la pile de gauche. &lt;/p&gt;&lt;p&gt;Savez-vous pourquoi la logique de Silvaine a mis ces personnes à gauche plutôt qu'à droite ?&lt;/p&gt;\" title=\"Séparation familiale\" type=\"2\"/><riddle answer=\"nbnbb\" answer_type=\"2\" copyright=\"Proposée par Dédé.\" hint=\"&lt;p&gt;La première réponse est forcément &quot;noir&quot;.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Noir - Bleu - Noir - Bleu - Bleu.&lt;/p&gt;&lt;p&gt;La première personne répond obligatoirement &lt;i&gt;&quot;J'ai les yeux noirs&lt;/i&gt;&quot;.&lt;/p&gt;&lt;p&gt;En effet, si celle-ci a les noirs, elle dira la vérité (donc noir) et si elle a les yeux bleus, elle mentira et répondra donc noir.&lt;/p&gt;&lt;p&gt;Ainsi, on sait que la deuxième personne a les yeux bleus car elle ment sur la réponse de la première personne.&lt;/p&gt;&lt;p&gt;Enfin la troisième personne dit la vérité sur le deuxième, donc forcément sur la première.&lt;/p&gt;&lt;p&gt;Les 2 personnes aux yeux noirs sont donc connus, le reste des personnes a les yeux bleus.&lt;/p&gt;\" text=\"&lt;p&gt;Isaac se vante d'être le plus intelligent du monde.&lt;br/&gt;Piqué au vif, Albert décide de le mettre au défi et l'invite chez lui pour un petit jeu.&lt;/p&gt;&lt;p&gt;En arrivant, il voit 5 personnes alignées contre un mur avec les yeux bandés.&lt;br/&gt;Albert lui dit que 2 des personnes ont les yeux noirs et les 3 autres les yeux bleus.&lt;br/&gt;Ceux avec les yeux noirs disent toujours la vérité et ceux avec les yeux bleus mentent toujours.&lt;br/&gt;Ces personnes connaissent la couleur des yeux des autres personnes.&lt;br/&gt;Il n'a le droit de ne poser qu'une question par personne.&lt;/p&gt;&lt;p&gt;Isaac se dirige vers la première personne et lui demande : &lt;br/&gt;&lt;i&gt;&quot;Quelle est la couleur de tes yeux ?&quot;&lt;/i&gt;&lt;br/&gt;Celle-ci répond dans une langue qu'il ne comprend pas.&lt;/p&gt;&lt;p&gt;Il décide tout de même d'aller vers celle d'à côté et lui demande :&lt;br/&gt;&lt;i&gt;&quot;Quelle est la réponse de la personne précédente ?&quot;&lt;/i&gt;&lt;br/&gt;Elle lui répond : &lt;i&gt;&quot;Elle a répondu mes yeux sont bleus.&quot;&lt;/i&gt;&lt;/p&gt;&lt;p&gt;Il va vers la troisième et lui demande : &lt;br/&gt;&lt;i&gt;&quot;Quelle est la couleur des yeux des deux personnes précédentes ?&quot;&lt;/i&gt;&lt;br/&gt;Cette troisième personne répond : &lt;br/&gt;&lt;i&gt;&quot;La première a les yeux noirs et la seconde les yeux bleus.&quot;&lt;/i&gt;&lt;/p&gt;&lt;p&gt;Isaac annonce alors à Albert qu'il connait la couleur des yeux des 5 personnes.&lt;/p&gt;&lt;p&gt;Quelle est la couleur des yeux des 5 personnes ?&lt;/p&gt;&lt;p&gt;&lt;i&gt;La réponse devra être nôtée avec la première lettre de la couleur des yeux dans l'ordre (exemple : NNBBN pour Noir - Noir - Bleu - Bleu - Noir).&lt;/i&gt;&lt;/p&gt;\" title=\"T'as de beaux yeux\" type=\"2\"/><riddle answer=\"fpp\" answer_type=\"2\" copyright=\"\" hint=\"&lt;p&gt;A partir de moment ou la pièce fait face, Silvaine prend l'avantage.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Face - Pile - Pile.&lt;/p&gt;&lt;p&gt;Avec cette séquence, Silvaine a plus de chance de gagner qu'Amandine.&lt;/p&gt;&lt;p&gt;Après 2 lancés, il y a 4 combinaisons possibles : &lt;/p&gt;&lt;p&gt;FF : Silvaine a son premier lancé (Face). Amandine ne pourra jamais gagner car dès que la pièce fera 2 fois pile (nécessaire au début de sa séquence), Silvaine aura gagné.&lt;/p&gt;&lt;p&gt;FP : Silvaine gagne si le prochain lancé fait Pile, sinon (FPF), elle a le même avantage que le cas FF.&lt;/p&gt;&lt;p&gt;PF : Toujours le même avantage que FF.&lt;/p&gt;&lt;p&gt;PP : C'est le seul cas où Amandine a gagne à tous les coups.&lt;/p&gt;\" text=\"&lt;p&gt;Ludivine propose à Amandine et Silvaine de jouer à pile ou face.&lt;/p&gt;&lt;p&gt;Voyant qu'elles ne sont pas intéressées, elle décide de leur proposer des règles plus compliquées : &lt;br/&gt;Elles doivent choisir toutes les deux une séquence de 3 résultats de pile ou face. La gagnante sera celle dont la séquence sortira en premier.&lt;/p&gt;&lt;p&gt;Amandine, première à parler, propose Pile - Pile - Face (Noté PPF).&lt;/p&gt;&lt;p&gt;Silvaine peut-elle proposer une séquence qui lui donnerait l'avantage ?&lt;/p&gt;&lt;p&gt;La réponse devra être notée avec les 3 premières lettres des résultats de la séquence (par exemple : FFP pour Face - Face - Pile)&lt;/p&gt;\" title=\"Pile ou face\" type=\"2\"/><riddle answer=\"max\" answer_type=\"1\" copyright=\"Proposée par Florentin\" hint=\"&lt;p&gt;Il est conseiller de commencer par trouver les cartes de Denis.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Max.&lt;/p&gt;&lt;p&gt;Pierre a 5, 2, 2, 1&lt;/p&gt;&lt;p&gt;Denis a 5, 2, 1, 1.&lt;/p&gt;&lt;p&gt;Sam a 5, 4, 4, 3.&lt;/p&gt;&lt;p&gt;Max a Valet, 4, 3, 3.&lt;/p&gt;\" text=\"&lt;p&gt;4 amis décident de jouer aux cartes.&lt;br/&gt;Ils jouent avec un jeu de carte comportant 16 cartes : &lt;/p&gt;&lt;ul&gt;&lt;li&gt; - 3x As,&lt;/li&gt;&lt;li&gt; - 3x 2, &lt;/li&gt;&lt;li&gt; - 3x 3,&lt;/li&gt;&lt;li&gt; - 3x 4,&lt;/li&gt;&lt;li&gt; - 3x 5,&lt;/li&gt;&lt;li&gt; - 1x Valet.&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;Les cartes ont ont leurs valeurs (la carte 1 vaut 1...) mais le valet vaut 10 points.&lt;/p&gt;&lt;p&gt;4 cartes sont distribuées à chacun. Chacun à leur tour annonce un nombre à partir d'un calcul fait avec les 4 cartes.&lt;/p&gt;&lt;p&gt;Pierre fait la multiplication de ses 4 cartes. Il obtient 20.&lt;/p&gt;&lt;p&gt;Denis fait la division de la 1ère carte par la 2ème, puis la 3ème et par la 4ème. Il obtient 2,5.&lt;/p&gt;&lt;p&gt;Sam fais la somme de ses 4 cartes. Il obtient 16.&lt;/p&gt;&lt;p&gt;Max fais la soustraction de la 1ère carte par la 2ème, puis la 3ème et par la 4ème. Il obtient 0.&lt;/p&gt;&lt;p&gt;Qui a le valet ?&lt;/p&gt;&lt;p&gt; &lt;/p&gt;&lt;p&gt;Indice : &lt;/p&gt;\" title=\"Le jeu de cartes\" type=\"2\"/><riddle answer=\"dictionnair|alphab\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Regardez le début de chaque mot.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;L'ordre alphabétique était à prendre en considération. La réponse est le dictionnaire.&lt;/p&gt;\" text=\"&lt;p&gt;Pour moi, l'accouchement vient avant la grossesse, l'enfance avant la naissance, l'adolescence avant l'enfance, la mort avant la vie.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Que suis-je ?\" type=\"3\"/><riddle answer=\"enveloppe|envellope|envelope|envelloppe\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Qu'est ce qui peut contenir une lettre ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une enveloppe contient une lettre et commence par un 'e'.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot commence par la lettre 'e' et contient une lettre ?&lt;/p&gt;\" title=\"Le mot\" type=\"3\"/><riddle answer=\"soleil\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Utilisez une calculatrice&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Si on tape ce chiffre sur une calculette et qu'on la retourne, on verra apparaître le mot Soleil.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot est représenté par ce nombre : 713705 ?&lt;/p&gt;\" title=\"L'école\" type=\"3\"/><riddle answer=\"vent\" answer_type=\"1\" copyright=\"J.R.R. Tolkien.\" hint=\"&lt;p&gt;Je peux être touché mais on ne peut me prendre.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le vent répond à toutes ces affirmations.&lt;/p&gt;\" text=\"&lt;p&gt;Sans voix, je hurle&lt;br/&gt;Sans ailes, je voltige&lt;br/&gt;Sans dents, je mords&lt;br/&gt;Sans bouche, je murmure&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"L'inconnu\" type=\"3\"/><riddle answer=\"horizon|soleil\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Regardez au loin.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;On marche vers l'horizon mais jamais on ne l'atteint.&lt;/p&gt;&lt;p&gt;Le soleil est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;A ciel dégagé, on peut marcher vers lui mais jamais on ne l'atteint.&lt;/p&gt;&lt;p&gt;Qui est-ce ?&lt;/p&gt;\" title=\"La longue marche\" type=\"3\"/><riddle answer=\"chien|sam|marion|simona|romain|elisa\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Il ne faut pas chercher une personne.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un chien&lt;/p&gt;&lt;p&gt;Le chien habite dans une niche.&lt;br/&gt;&lt;br/&gt;Sam - Mas, Marion - Manoir, Simona - Maison; Elisa - Asile sont aussi acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Avec les lettres de mon nom, on peut écrire celui de ma maison.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"La maison\" type=\"3\"/><riddle answer=\"n\" answer_type=\"2\" copyright=\"\" hint=\"&lt;p&gt;Il faut bien lire.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est la lettre 'n'.&lt;/p&gt;\" text=\"&lt;p&gt;Je commence la nuit, je finis le matin, je suis dans l'étang, je suis au fond du jardin et je passe 2 fois dans l'année.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Il est partout\" type=\"3\"/><riddle answer=\"ancre|petanque|hamecon|tente|amarre|cochonnet|confetti|des|herse|bommerang|freesbi|bille|filet\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Cet objet sert à éviter de s'éloigner.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;On jette l'ancre lorsqu'on en a besoin et on la remonte quand on en a plus besoin.&lt;br/&gt;&lt;br/&gt;Une boule de pétanque, les amarres, un hameçon ou une tente (Les tentes 2s) sont aussi acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Que jette-t-on lorsqu'on en a besoin et que l'on ramasse lorsqu'on n'en a plus besoin ?&lt;/p&gt;\" title=\"L'objet\" type=\"3\"/><riddle answer=\"veste|poche|paupiere|volet\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Pas toujours réversible.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une veste répond à toutes ces affirmations.&lt;/p&gt;&lt;p&gt;Une poche, les paupières et des volets sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Plus souvent ouverte que fermée, plus souvent dehors que dedans, je peux même changer de couleur en me retournant.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"L'opportuniste\" type=\"3\"/><riddle answer=\"horloge|reveil|montre|pendule\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Tout ça se fait si régulièrement...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est une horloge.&lt;br/&gt;&lt;br/&gt;Accepté : Réveil, montre, pendule.&lt;/p&gt;\" text=\"&lt;p&gt;Quand je marche, je ne dois pas avancer. Je peux m'arrêter même si je ne bougeais pas. Bien que je ne descende jamais, il faut toujours me remonter.&lt;/p&gt;&lt;p&gt;Que suis-je?&lt;/p&gt;\" title=\"Le dilemme\" type=\"3\"/><riddle answer=\"3\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Connaissez-vous bien vos 5 sens ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les 5 sens de l'homme sont : &lt;br/&gt;- Le toucher,&lt;br/&gt;- La vue,&lt;br/&gt;- L'ouïe,&lt;br/&gt;- L'odorat,&lt;br/&gt;- Le goût.&lt;br/&gt;&lt;br/&gt;La parole n'est pas un sens.&lt;/p&gt;\" text=\"&lt;p&gt;Vous êtes aveugle, sourd et muet. Combien vous reste-t-il de sens ?&lt;/p&gt;\" title=\"Les sens\" type=\"3\"/><riddle answer=\"silence\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Lorsque l'on parle on fait du bruit.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le silence est brisé dès qu'on parle.&lt;/p&gt;\" text=\"&lt;p&gt;On peut me briser rien qu'en prononçant mon nom.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Mon nom\" type=\"3\"/><riddle answer=\"hs|kc\" answer_type=\"3\" copyright=\"Proposé par Mayina.\" hint=\"&lt;p&gt;C'est la batterie qui est ...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;HS : Hors Service, ou KC&lt;/p&gt;\" text=\"&lt;p&gt;Quelles lettres sont toujours en panne ?&lt;/p&gt;\" title=\"Le dépanneur\" type=\"3\"/><riddle answer=\"peigne|fourchette|timbre|scie|braguette|engrenage|couteau|rateau|clef|courroie|vent|eclair|pignon|fermetu|cle\" answer_type=\"3\" copyright=\"Proposée par Matt.\" hint=\"&lt;p&gt;Dans la salle de bain.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un peigne possède des dents mais ne mord pas.&lt;br/&gt;&lt;br/&gt;Un timbre, une scie, une braguette ou une fourchette sont aussi acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;J'ai des dents mais je ne mords pas.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Les dents de la mer\" type=\"3\"/><riddle answer=\"et\" answer_type=\"2\" copyright=\"Proposé par Smouzi.\" hint=\"&lt;p&gt;Lisez bien.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le mot &quot;et&quot;.&lt;/p&gt;\" text=\"&lt;p&gt;Que trouve-t-on entre la terre et le ciel ?&lt;/p&gt;&#9;&#9;\" title=\"L'espace\" type=\"3\"/><riddle answer=\"oqp\" answer_type=\"2\" copyright=\"\" hint=\"&lt;p&gt;Quand quelqu'un se trouve dans les toilettes...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;OQP.&lt;/p&gt;\" text=\"&lt;p&gt;Quelles lettres sont toujours indisponibles ?&lt;/p&gt;\" title=\"Pas le temps\" type=\"3\"/><riddle answer=\"ajt|nrv\" answer_type=\"3\" copyright=\"Proposé par Naxela.\" hint=\"&lt;p&gt;Comme l'Orangina.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les lettres AJT sont difficiles à contenir.&lt;br/&gt;&lt;br/&gt;NRV est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Quelles sont les trois lettres qui ne tiennent pas en place ?&lt;/p&gt;\" title=\"Le turbulent\" type=\"3\"/><riddle answer=\"enfant|bebe\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Il est souvent nécessaire de bien s'habiller pour l'occasion.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un homme pourra donner à une femme un enfant.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est-ce qu'un homme ne peut avoir, mais peut donner à une femme ?&lt;/p&gt;\" title=\"L'homme\" type=\"3\"/><riddle answer=\"levre\" answer_type=\"1\" copyright=\"Proposé par Willow.\" hint=\"&lt;p&gt;Il faut lire cette phrase à haute voix.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Lorsque l'on prononce cette phrase, les lèvres ne se touchent pas puis elles se touchent.&lt;/p&gt;\" text=\"&lt;p&gt;Touche pas ça touche, et touche ne touche pas.&lt;/p&gt;&lt;p&gt;Qu'est-ce qui touche ?&lt;/p&gt;\" title=\"Touche touche\" type=\"3\"/><riddle answer=\"cercueil\" answer_type=\"1\" copyright=\"Proposé par Clavat.\" hint=\"&lt;p&gt;Je suis un objet que l'on utilise qu'une seule fois.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est un cercueil.&lt;/p&gt;\" text=\"&lt;p&gt;Celui qui me fabrique me revend.&lt;br/&gt;Celui qui m'achète ne se sert même pas de moi.&lt;br/&gt;Celui qui se sert de moi ne voit pas que je suis là.&lt;br/&gt;Qui suis-je ?&lt;/p&gt;\" title=\"La vente improbable\" type=\"3\"/><riddle answer=\"avocat|oseille\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;On ne me mange pas dans tous les cas.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est l'avocat (l'oseille est également acceptée).&lt;/p&gt;\" text=\"&lt;p&gt;Je suis vert, comestible, et on a souvent besoin de moi en cas de gros problèmes.&lt;/p&gt;\" title=\"Le besoin\" type=\"3\"/><riddle answer=\"110010|1110\" answer_type=\"4\" copyright=\"Proposé par Blaise1942.\" hint=\"&lt;p&gt;A haute voix ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;110010&lt;br/&gt;&lt;br/&gt;un - 1&lt;br/&gt;cent - 100&lt;br/&gt;dix - 10&lt;br/&gt;&lt;br/&gt;Incendie.&lt;/p&gt;&lt;p&gt;1110 est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Le mot incendie représente un nombre, lequel ?&lt;/p&gt;\" title=\"Fire in the hole\" type=\"3\"/><riddle answer=\"robinet\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;On s'en sert tous les jours.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un robinet, lorsqu'on lui tourne la tête, il pleure.&lt;/p&gt;\" text=\"&lt;p&gt;Chez toi, chez nous, quand on me tourne la tête, je pleure.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Tourne, tourne\" type=\"3\"/><riddle answer=\"carte|plan|gps\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Ca m'a l'air plutôt plat.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est une carte géographique.&lt;/p&gt;\" text=\"&lt;p&gt;J'ai le plus souvent des rues sans chaussées,&lt;br/&gt;Des villes sans immeubles,&lt;br/&gt;Des forêts sans arbres,&lt;br/&gt;Des rivières sans eau.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"City\" type=\"3\"/><riddle answer=\"fenetre|meurtriere\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Regardez les murs qui vous entourent.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une fenêtre permet de voir à travers les murs.&lt;/p&gt;\" text=\"&lt;p&gt;Une invention vieille comme le monde permet de voir à travers les murs.&lt;/p&gt;&lt;p&gt;Quelle est-elle ?&lt;/p&gt;\" title=\"Les murs\" type=\"3\"/><riddle answer=\"secret|intimite\" answer_type=\"3\" copyright=\"Proposé par Michel-Michel Michel.\" hint=\"&lt;p&gt;Je ne suis pas un objet.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le secret.&lt;br/&gt;&lt;br/&gt;Plus difficile à protéger lorsque beaucoup de personnes le connaissent.&lt;/p&gt;\" text=\"&lt;p&gt;Une princesse, prisonnière du donjon, s'amuse à poser une énigme à un gardien : &quot;Plus j'ai de gardiens, moins je suis gardé. Moins j'ai de gardiens, plus je suis gardé.&quot;&lt;/p&gt;&lt;p&gt;Quelle est la réponse à son énigme ?&lt;/p&gt;\" title=\"Dark Age\" type=\"3\"/><riddle answer=\"main|corde|relai|elastiqu\" answer_type=\"3\" copyright=\"Proposé par Niko.\" hint=\"&lt;p&gt;Certainement devant vos yeux actuellement.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La main.&lt;br/&gt;&lt;br/&gt;On vous tend la main, on peut passer la main, et jeu de main, jeu de vilain.&lt;/p&gt;&lt;p&gt;Corde et le relai sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;On me tend, on me passe, on en fait un jeu.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Fait-tout\" type=\"3\"/><riddle answer=\"vq|ag\" answer_type=\"3\" copyright=\"Proposé par Tiasa.\" hint=\"&lt;p&gt;Elles ont vu beaucoup de choses.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les lettres v et q car elles ont vécu.&lt;/p&gt;&lt;p&gt;Les lettres a et g sont également acceptées.&lt;/p&gt;\" text=\"&lt;p&gt;Quelles lettres ont un lourd passé ?&lt;/p&gt;\" title=\"Histoire\" type=\"3\"/><riddle answer=\"langue|mode|victoire|defaite\" answer_type=\"3\" copyright=\"Proposé par azizof.\" hint=\"&lt;p&gt;Pensez à une expression lorsqu'on ne trouve pas une énigme.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Votre langue.&lt;br/&gt;&lt;br/&gt;La victoire, la défaite ou la mode sont aussi acceptées.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est-ce qui a du goût mais qu'on ne peut pas manger ni boire ?&lt;/p&gt;\" title=\"Miam miam\" type=\"3\"/><riddle answer=\"4\" answer_type=\"0\" copyright=\"Proposé par Mélanie.\" hint=\"&lt;p&gt;Il faut juste bien suivre.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Vous serez en 4ème position.&lt;/p&gt;\" text=\"&lt;p&gt;J'étais en 5ème position, je dépasse 2 personnes devant moi mais 1 personne m'a dépassé.&lt;/p&gt;&lt;p&gt;Quelle est ma position ?&lt;/p&gt;\" title=\"La course\" type=\"3\"/><riddle answer=\"bavarois\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Des fois il faut prendre les informations sans chercher.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Bavaroise au café.&lt;br/&gt;&lt;br/&gt;- Un bavard (bavar),&lt;br/&gt;- Un oiseau (oise au),&lt;br/&gt;- Café.&lt;/p&gt;\" text=\"&lt;p&gt;Voici une célèbre charade de Victor Hugo : &lt;/p&gt;&lt;p&gt;Mon premier est bavard,&lt;br/&gt;Mon deuxième est un oiseau,&lt;br/&gt;Mon troisième est au café,&lt;br/&gt;Mon tout est un dessert.&lt;/p&gt;\" title=\"Victor Hugo\" type=\"3\"/><riddle answer=\"pigeon\" answer_type=\"1\" copyright=\"Proposé par Bastien.\" hint=\"&lt;p&gt;Il laisse souvent des traces là où il passe.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le pigeon.&lt;/p&gt;\" text=\"&lt;p&gt;Pas très aimé des citadins,&lt;br/&gt;Les enfants et les personnes âgées aiment l'attirer,&lt;br/&gt;il peuple pourtant toits et jardins, des escrocs il est le jouet.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"L'habitant\" type=\"3\"/><riddle answer=\"soleil\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Plus ou moins visible selon les périodes de l'année.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le soleil, à tout moment il éclaire une partie du globe et il peut donner des coups de soleil.&lt;/p&gt;\" text=\"&lt;p&gt;Je peux donner des coups à tout le monde. Je suis souvent le bienvenu et il ne se passe pas un seul instant dans le monde sans que quelqu'un me voie.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Le battant\" type=\"3\"/><riddle answer=\"cle|pierre\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Parfois, je suis composé d'une molette.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La clef.&lt;br/&gt;&lt;br/&gt;La clef de voûte,&lt;br/&gt;La clef de sol,&lt;br/&gt;Les clefs du paradis.&lt;br/&gt;&lt;br/&gt;Une pierre est également acceptée.&lt;/p&gt;\" text=\"&lt;p&gt;Sans moi, s'effondreraient les cathédrales. Je suis la solution pour m'élever depuis le sol et accéder au Paradis.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Le support\" type=\"3\"/><riddle answer=\"feuille|plume|cheveu|petal\" answer_type=\"3\" copyright=\"Proposé par Maxime.\" hint=\"&lt;p&gt;Elle tombe avant de se balader.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est une feuille qui se détache à l'automne.&lt;/p&gt;&lt;p&gt;Une plume, un pétale et un cheveu sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est ce qui est attaché pendant sa vie et qui vole librement pendant sa mort ?&lt;/p&gt;\" title=\"Le mort-vivant\" type=\"3\"/><riddle answer=\"vie\" answer_type=\"1\" copyright=\"Proposé par Maxime.\" hint=\"&lt;p&gt;On est tous concerné.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La vie s'allonge et sa durée restante rétrécie.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est-ce qui s'allonge et rétrécit en même temps ?&lt;/p&gt;\" title=\"Elastique\" type=\"3\"/><riddle answer=\"puit|racine|canalisation\" answer_type=\"3\" copyright=\"Proposé par Cécile.\" hint=\"&lt;p&gt;J'ai soif.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est un puits.&lt;/p&gt;&lt;p&gt;Une racine et une canalisation sont également acceptées.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis rond comme un tronc, profond dans la terre et rarement au sec.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Dans la terre\" type=\"3\"/><riddle answer=\"charbon\" answer_type=\"1\" copyright=\"Proposé par Maxime.\" hint=\"&lt;p&gt;La combustion a de drôles d'effets.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est le charbon.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est ce qui est noir, devient rouge et finit gris ?&lt;/p&gt;\" title=\"Le caméléon\" type=\"3\"/><riddle answer=\"nuage\" answer_type=\"1\" copyright=\"Proposé par Nassur.\" hint=\"&lt;p&gt;Mon tout est blanc.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est un nuage.&lt;br/&gt;&lt;br/&gt;nu - âge.&lt;/p&gt;\" text=\"&lt;p&gt;Mon premier est sans habit.&lt;br/&gt;Mon deuxième représente mon temps de vie.&lt;br/&gt;Mon tout se trouve au dessus de nous.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Charade de l'homme\" type=\"3\"/><riddle answer=\"porc|lori\" answer_type=\"3\" copyright=\"Proposé par Henri.\" hint=\"&lt;p&gt;Fonctionne phonétiquement sans la queue.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le porc devient de l'or lorsqu'on enlève le 'p' et le 'c'.&lt;br/&gt;&lt;br/&gt;Lori est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Quel animal devient de l'or lorsqu'on lui coupe la tête et la queue ?&lt;/p&gt;&lt;p&gt;p&lt;Sa tête et sa queue on la même longueur.&lt;/p&gt;\" title=\"L'animal doré\" type=\"3\"/><riddle answer=\"ombre\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Une lumière est nécessaire.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est l'ombre.&lt;/p&gt;\" text=\"&lt;p&gt;Parfois je rase les murs, parfois on me marche dessus. Je suis plus petite le midi que le soir, et la nuit je disparais.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Le change-forme\" type=\"3\"/><riddle answer=\"oeuf|ruche|œuf|kinder|tirelire|noix\" answer_type=\"3\" copyright=\"J.R.R. Tolkien.\" hint=\"&lt;p&gt;C'est rond.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est un oeuf.&lt;br/&gt;&lt;br/&gt;La ruche, une noix, la tirelire et le kinder sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Une boîte sans charnière, sans clef, sans couvercle, pourtant à l'intérieur est caché un trésor doré.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"La boite\" type=\"3\"/><riddle answer=\"chaise|cheval|poney|lit|tabouret|fauteuil|canape\" answer_type=\"3\" copyright=\"Proposé par Aurélie.\" hint=\"&lt;p&gt;Vous êtes peut être dessus actuellement.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les 4 pattes sont à une chaise sur laquelle une personne s'est assise.&lt;br/&gt;&lt;br/&gt;Cheval, poney, fauteuil, canapé et lit sont aussi acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Ce sont 2 pattes, posées sur 4 pattes. 2 pattes s'en vont, 4 pattes resteront.&lt;/p&gt;&lt;p&gt;A qui sont les 4 pattes ?&lt;/p&gt;\" title=\"Les pattes\" type=\"3\"/><riddle answer=\"escalier|escalator|balanc|pente|cote|montagne|colline|soleil\" answer_type=\"3\" copyright=\"Proposé par Jean Pierre.\" hint=\"&lt;p&gt;Ce sont surtout les personnes qui montent et descendent.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est un escalier.&lt;br/&gt;&lt;br/&gt;Une balance, le soleil, une pente ou une montagne sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est-ce qui monte et qui descend à la fois ?&lt;/p&gt;\" title=\"Les deux sens\" type=\"3\"/><riddle answer=\"guerre|proces|vie\" answer_type=\"3\" copyright=\"Proposé par Tiffany.\" hint=\"&lt;p&gt;Partout à travers le monde à différentes époques.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La guerre.&lt;br/&gt;&lt;br/&gt;Un procès et la vie sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Personne n'en veut, mais quand on l'a on ne veut pas la perdre.&lt;/p&gt;&lt;p&gt;Qu'est-ce que c'est ?&lt;/p&gt;\" title=\"Le maudit\" type=\"3\"/><riddle answer=\"feuille|cheveu\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;On s'en sert tous les jours à l'école.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une feuille.&lt;/p&gt;&#10;&lt;p&gt;Les cheveux sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;On me fabrique avec celui qui me porte.&lt;br/&gt;Je suis parfois d'or et je change de couleur avant de mourir.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Plume\" type=\"3\"/><riddle answer=\"chien|ombre|vivant|berger|detective|psychologue\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Je suis, même orthographe, et pourtant.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est un chien. Il suit son maitre.&lt;br/&gt;&lt;br/&gt;Une ombre, un détective, un psychologue ou un être vivant sont aussi acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis ce que je suis mais je ne suis pas ce que je suis...&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Paradoxe\" type=\"3\"/><riddle answer=\"gel\" answer_type=\"1\" copyright=\"Proposé par Fred.\" hint=\"&lt;p&gt;Le même mot devrait revenir à chaque phrase.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le gel s'installe quand il fait très froid.&lt;br/&gt;Batterie au Gel.&lt;br/&gt;Gel de rasage.&lt;br/&gt;Gel pour cheveux.&lt;br/&gt;Le Gel colle (givre).&lt;/p&gt;\" text=\"&lt;p&gt;Je m'installe quand il fait froid.&lt;br/&gt;Inaudible, je sers à la batterie.&lt;br/&gt;Sans moi le rasoir devient barbant.&lt;br/&gt;Le matin tu t'en frottes les mains.&lt;br/&gt;Ne pose pas ta langue sur moi sinon, elle s'allongera.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Négatif\" type=\"3\"/><riddle answer=\"poisson\" answer_type=\"1\" copyright=\"Créée par J.R.R. Tolkien et proposée par Fryjo.\" hint=\"&lt;p&gt;On en mange.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est un poisson.&lt;/p&gt;\" text=\"&lt;p&gt;Vivant sans souffle,&lt;br/&gt;Froid comme la mort,&lt;br/&gt;Toujours buvant,&lt;br/&gt;Jamais assoiffé,&lt;br/&gt;En cotte de maille,&lt;br/&gt;Jamais cliquetant.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"L'être\" type=\"3\"/><riddle answer=\"nuage\" answer_type=\"1\" copyright=\"Proposé par Daniel.\" hint=\"&lt;p&gt;Des formes tellement différentes.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le nuage est doux mais ne peut-être touché, il claque avec ses éclairs et il amène la pluie.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis doux, mais on ne peut me toucher.&lt;br/&gt;Je claque lorsque je rencontre plus chaud ou plus froid que moi.&lt;br/&gt;Je pleure lorsque je suis trop lourd.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Lunatique\" type=\"3\"/><riddle answer=\"grenade|basilic|basilique|pomme\" answer_type=\"3\" copyright=\"Proposé par Nicolas.\" hint=\"&lt;p&gt;Un aliment, un lieu, une arme&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une grenade.&lt;br/&gt;&lt;br/&gt;Le fruit,&lt;br/&gt;La ville,&lt;br/&gt;Le projectile.&lt;br/&gt;&lt;br/&gt;Le basilic est aussi accepté, la plante, le monument (basilique), le reptile.&lt;/p&gt;\" text=\"&lt;p&gt;On peut me manger ou me visiter, mais entre de mauvaises mains, je peux être très dangereuse.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Multifonctions\" type=\"3\"/><riddle answer=\"miroir|glace\" answer_type=\"3\" copyright=\"Proposé par Aude.\" hint=\"&lt;p&gt;Réfléchir ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est un miroir.&lt;/p&gt;\" text=\"&lt;p&gt;Je flatte les forts et décourage les faibles,&lt;br/&gt;Je dis la vérité sans jamais ouvrir la bouche,&lt;br/&gt;Je réfléchis sans jamais penser.&lt;/p&gt;&lt;p&gt;Qui suis-je?&lt;/p&gt;\" title=\"Ambivalent\" type=\"3\"/><riddle answer=\"demain|futur\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Bientôt.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Demain.&lt;br/&gt;&lt;br/&gt;Demain n'a pas encore été.&lt;br/&gt;Demain existera.&lt;br/&gt;Personne n'a jamais été dans le futur.&lt;br/&gt;Si quelqu'un y arrive, ce sera &quot;aujourd'hui&quot; pour lui. La plupart d'entre-vous vont vivre jusqu'à demain.&lt;/p&gt;\" text=\"&lt;p&gt;Je n'ai jamais été,&lt;br/&gt;J'existerai,&lt;br/&gt;Personne ne m'a jamais vu,&lt;br/&gt;Personne ne me verra,&lt;br/&gt;Et pourtant la plupart me verront.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"L'invisible\" type=\"3\"/><riddle answer=\"6\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Avez-vous tout lu ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il y a 6 F.&lt;br/&gt;&lt;br/&gt;Le cerveau saute les mots grammaticaux tels que &quot;Of&quot; pour lire plus rapidement les mots &quot;lexicaux&quot; ce qui fausse le compte.&lt;/p&gt;\" text=\"&lt;p&gt;Combien y a-t-il de F dans cette phrase : &lt;/p&gt;&lt;p&gt;FINISHED FILES ARE THE RESULT OF YEARS OF SCIENTIFIC STUDY COMBINED WITH THE EXPERIENCE OF YEARS.&lt;/p&gt;\" title=\"La lettre\" type=\"3\"/><riddle answer=\"canne|cane\" answer_type=\"3\" copyright=\"Proposé par Antoine-Baptiste.\" hint=\"&lt;p&gt;Et mon festival.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La canne.&lt;br/&gt;&lt;br/&gt;La femelle du canard s'appelle la cane, on cultive la canne à sucre, une canne peut aider à marcher.&lt;/p&gt;\" text=\"&lt;p&gt;A la fois animal, plante et objet, on me cultive et m'utilise lorsque le pas devient difficile.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Tout en un\" type=\"3\"/><riddle answer=\"cedille\" answer_type=\"1\" copyright=\"Proposé par Chris.\" hint=\"&lt;p&gt;La langue française ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La cédille.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis indispensable pour les français, mais inutile pour la France.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Pour la patrie\" type=\"3\"/><riddle answer=\"24\" answer_type=\"0\" copyright=\"Proposé par Indiana.\" hint=\"&lt;p&gt;Vous changez souvent de verres en soirée ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il achetera 24 verres, il a 23 invités et lui-même.&lt;/p&gt;\" text=\"&lt;p&gt;Pour ses 20 ans, Maxime organise une soirée avec 23 invités.&lt;/p&gt;&lt;p&gt;Il prévoit 3 litres de whisky. La dose de whisky est d'un tiers du verre. Le reste du verre étant rempli de soda, il lui en faudra 6 litres.&lt;/p&gt;&lt;p&gt;De plus, il a fabriqué 10 litres de sangria.&lt;/p&gt;&lt;p&gt;Et enfin il a acheté un fût de 30 litres de bière.&lt;/p&gt;&lt;p&gt;Sachant que la contenance des verres en plastique est de 16cl, combien de verres doit-il acheter ?&lt;/p&gt;\" title=\"Les courses\" type=\"3\"/><riddle answer=\"sac|verre|soutien|cintre|panier|chaussure|bretelle|chevalier|ceintur|bebe|plateau|monnai|selle|talon\" answer_type=\"3\" copyright=\"Proposé par Habiba.\" hint=\"&lt;p&gt;Les filles en portent plus que les hommes.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un sac est porté et porte également des choses.&lt;br/&gt;&lt;br/&gt;Un verre, un cintre, un porte-bébé, un plateau, un porte-monnaie ou un soutien-gorge sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis porté et je porte quelque chose en même temps.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"C'est si beau\" type=\"3\"/><riddle answer=\"pied|orteil\" answer_type=\"3\" copyright=\"Proposé par Hélène.\" hint=\"&lt;p&gt;Vous en avez 2.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les pieds.&lt;/p&gt;&lt;p&gt;Les orteils sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Quand je suis couché, ils sont debout. Quand je suis debout, ils sont couchés.&lt;/p&gt;&lt;p&gt;Qui sont-ils ?&lt;/p&gt;\" title=\"Jamais content\" type=\"3\"/><riddle answer=\"calendrier|ephemeride\" answer_type=\"3\" copyright=\"Proposé par Quentin. \" hint=\"&lt;p&gt;Tous les jours on peut s'en servir.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un calendrier.&lt;/p&gt;\" text=\"&lt;p&gt;J'ai toutes mes feuilles en janvier, mais une seule en décembre.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Les 4 saisons\" type=\"3\"/><riddle answer=\"lune|pupille\" answer_type=\"3\" copyright=\"Proposé par Benjamin.\" hint=\"&lt;p&gt;Plus souvent la nuit que le jour.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La lune.&lt;/p&gt;\" text=\"&lt;p&gt;Je grossis et je maigris sans jamais rien manger. Parfois ronde comme un ballon et parfois mince comme un sourire.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"L'orbe tourbillonante\" type=\"3\"/><riddle answer=\"livre\" answer_type=\"1\" copyright=\"Proposé par Armandinho.\" hint=\"&lt;p&gt;Une lecture vous donnerait la solution.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un livre.&lt;br/&gt;&lt;br/&gt;Un objet : le livre à lire.&lt;br/&gt;Une monnaie : la livre sterling (angleterre)&lt;br/&gt;Une unité de mesure : la livre (environ 500gr).&lt;/p&gt;\" text=\"&lt;p&gt;Je peux être un objet.&lt;br/&gt;Je peux être une monnaie.&lt;br/&gt;Je peux être une unité de mesure.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"L'ambigu\" type=\"3\"/><riddle answer=\"fevrier\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;31, 30, ...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le mois de février a moins de jour que tous les autres.&lt;/p&gt;\" text=\"&lt;p&gt;Nous sommes 12 dans la famille.&lt;br/&gt;Je suis le deuxième mais je suis le plus petit.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Famille nombreuse\" type=\"3\"/><riddle answer=\"oiseau\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Je m'envole au moindre bruit.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un oiseau.&lt;/p&gt;\" text=\"&lt;p&gt;Voici une célèbre devinette proposée par Voltaire : &lt;br/&gt;Cinq voyelles, une consonne,&lt;br/&gt;En français composent mon nom,&lt;br/&gt;Et je porte sur ma personne,&lt;br/&gt;De quoi l'écrire sans crayon.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Voltaire\" type=\"3\"/><riddle answer=\"pain|lait|gateau|cake|miche|oeuf|œuf|cafe\" answer_type=\"3\" copyright=\"Proposé par Manon.\" hint=\"&lt;p&gt;La miche.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le pain, plus il est chaud, plus il est frais.&lt;/p&gt;&lt;p&gt;Le lait, le gâteau, le café, l'œuf et le cake sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Plus il est chaud, plus il est frais.&lt;/p&gt;&lt;p&gt;Qui est-ce ?&lt;/p&gt;\" title=\"Chaud, chaud\" type=\"3\"/><riddle answer=\"carte|musique\" answer_type=\"3\" copyright=\"Proposé par Manon.\" hint=\"&lt;p&gt;On y a tous joué.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un jeu de carte.&lt;br/&gt;&lt;br/&gt;La musique est aussi acceptée.&lt;/p&gt;\" text=\"&lt;p&gt;On me bat, on me coupe, mais on ne me mange pas.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Aïe aïe aïe\" type=\"3\"/><riddle answer=\"mer|asteroidea\" answer_type=\"3\" copyright=\"Proposé par Manon.\" hint=\"&lt;p&gt;Dans l'eau.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;L'étoile de mer.&lt;/p&gt;\" text=\"&lt;p&gt;Quelle est l'étoile la plus proche de la terre ?&lt;/p&gt;\" title=\"Star in the sky\" type=\"3\"/><riddle answer=\"indice|dix|devin\" answer_type=\"3\" copyright=\"Proposé par Touma.\" hint=\"&lt;p&gt;Une astuce ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Indice (un dix).&lt;br/&gt;&lt;br/&gt;Devin est aussi accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Il faut ajouter zéro à mon premier pour obtenir mon deuxième.&lt;br/&gt;Vous aurez peut-être besoin de mon tout pour résoudre cette énigme.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"L'énigme\" type=\"3\"/><riddle answer=\"liberte\" answer_type=\"1\" copyright=\"Proposé par Daeros.\" hint=\"&lt;p&gt;New York.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La statue de la Liberté.&lt;/p&gt;\" text=\"&lt;p&gt;Par ma grande taille, je suis unique. Femme mais jamais enceinte, je lève le bras pour éclairer l'Amérique.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Symbole\" type=\"3\"/><riddle answer=\"sauce\" answer_type=\"1\" copyright=\"Proposé par Keekou.\" hint=\"&lt;p&gt;Beaucoup de saveurs et de couleurs.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La sauce.&lt;/p&gt;\" text=\"&lt;p&gt;Elle est plus facile à allonger lorsqu'elle est tournée, elle peut être blanche ou bien chocolatée. On peut parfois l'associer au laurier.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Miam\" type=\"3\"/><riddle answer=\"v\" answer_type=\"2\" copyright=\"Proposé par Béatrice.\" hint=\"&lt;p&gt;C'est du français.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La lettre V.&lt;/p&gt;\" text=\"&lt;p&gt;Tous les voleurs me possèdent.&lt;br/&gt;Je viens en premier dans les vengeances.&lt;br/&gt;Tous les devins m'utilisent.&lt;br/&gt;Les savants ne peuvent se passer de moi.&lt;br/&gt;Car je suis le centre de gravité.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Tout ça\" type=\"3\"/><riddle answer=\"dent\" answer_type=\"1\" copyright=\"Proposé par Manuel.\" hint=\"&lt;p&gt;Vous vous en servez tous les jours, 3 fois par jour.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les dents.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est-ce que la nature nous donne 2 fois gratuitement, et qui est payant la 3ème fois ?&lt;/p&gt;\" title=\"Mère nature\" type=\"3\"/><riddle answer=\"doigt\" answer_type=\"1\" copyright=\"Proposé par Dylan.\" hint=\"&lt;p&gt;Juste devant vous en ce moment.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les doigts.&lt;/p&gt;\" text=\"&lt;p&gt;Ils sont cinq frères mais le plus grand est celui du milieu.&lt;/p&gt;&lt;p&gt;Qui sont-ils ?&lt;/p&gt;\" title=\"Les frères\" type=\"3\"/><riddle answer=\"croute|oseille|pain|ble|fruit\" answer_type=\"3\" copyright=\"Proposé par Romain.\" hint=\"&lt;p&gt;Avec du fromage.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La croûte.&lt;br/&gt;&lt;br/&gt;L'oseille, le fruit et le pain sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;On me gagne en travaillant et on peut aussi me manger.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Dur labeur\" type=\"3\"/><riddle answer=\"pou\" answer_type=\"1\" copyright=\"Proposé par Kathia.\" hint=\"&lt;p&gt;Ca gratte.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un pou.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est ce qui a 6 pattes et marche sur la tête ?&lt;/p&gt;\" title=\"Les pattes\" type=\"3\"/><riddle answer=\"dent\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;32 au début.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les dents.&lt;/p&gt;\" text=\"&lt;p&gt;Trente-deux demoiselles toutes vêtues de blanc dans un palais rouge entourent un grand tapis rouge.&lt;/p&gt;&lt;p&gt;Qui sont-elles ?&lt;/p&gt;\" title=\"Le sultan\" type=\"3\"/><riddle answer=\"facteur|postier|scrabble|imprimeur|typograph|cruciverb|verbicru\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Sans lui, il y aurait peu de lettres.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le facteur.&lt;/p&gt;&lt;p&gt;Le postier, le joueur de scrabble, un crusiverbiste, un verbicrusiste, le typographe et l'imprimeur sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis un homme de lettres, mais je ne suis ni professeur, ni écrivain.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"L'écriture\" type=\"3\"/><riddle answer=\"russe|matriochka|gigogne\" answer_type=\"3\" copyright=\"Proposé par Rémy.\" hint=\"&lt;p&gt;Taillées dans le bois.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Ce sont des poupées russes (ou Matriochkas).&lt;/p&gt;\" text=\"&lt;p&gt;Je porte mon bébé en moi et pourtant, je ne suis pas enceinte.&lt;br/&gt;Je suis moi-même portée par ma soeur, qui est portée par notre soeur aînée.&lt;br/&gt;Dans le ventre de notre mère la nuit nous submerge car seulement elle peut voir la lumière.&lt;/p&gt;&lt;p&gt;Qui sommes- nous ?&lt;/p&gt;\" title=\"Quelle famille!\" type=\"3\"/><riddle answer=\"dent\" answer_type=\"1\" copyright=\"Enigme de J.R.R. Tolkien. \" hint=\"&lt;p&gt;32... pas au début.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les dents.&lt;/p&gt;\" text=\"&lt;p&gt;Trente-deux chevaux sur une colline rouge,&lt;br/&gt;D'abord ils mâchonnent,&lt;br/&gt;Puis ils frappent leurs marques,&lt;br/&gt;Ensuite ils restent immobiles.&lt;/p&gt;&lt;p&gt;Qui est-ce ?&lt;/p&gt;\" title=\"Tolkien\" type=\"3\"/><riddle answer=\"herbe\" answer_type=\"1\" copyright=\"Proposé par Chris.\" hint=\"&lt;p&gt;Attila, là où il passe...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;L'herbe&lt;/p&gt;\" text=\"&lt;p&gt;Je suis la couleur de la nature, on peut m'arracher mais je reviendrai toujours.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Mère nature\" type=\"3\"/><riddle answer=\"manege|descen\" answer_type=\"3\" copyright=\"Proposé par Amal.\" hint=\"&lt;p&gt;Où peut-on croiser un tel regroupement ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Vous descendez du manège.&lt;/p&gt;\" text=\"&lt;p&gt;Vous êtes au volant d'une voiture et vous roulez à vitesse constante. A votre gauche un ravin, à votre droite un camion de pompier qui roule à la même vitesse. Devant vous un cochon et derrière, un hélicoptère qui va également à la même vitesse. Tout d'un coup, tout le monde s'arrête.&lt;/p&gt;&lt;p&gt;Que faites-vous ?&lt;/p&gt;\" title=\"Au volant!!!\" type=\"3\"/><riddle answer=\"sel\" answer_type=\"1\" copyright=\"Proposé par Laëtitia.\" hint=\"&lt;p&gt;Culinaire.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le sel.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis un conservateur.&lt;br/&gt;On a souvent besoin de moi.&lt;br/&gt;On m'associe parfois à l'or blanc.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Les inséparables\" type=\"3\"/><riddle answer=\"nuage\" answer_type=\"1\" copyright=\"Proposé par Rima.\" hint=\"&lt;p&gt;Pleins de formes différentes.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un nuage.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est ce qui pleure, mais n'a pas d'oeil, vole mais n'a pas d'ailes ?&lt;/p&gt;\" title=\"Le fantôme\" type=\"3\"/><riddle answer=\"os\" answer_type=\"1\" copyright=\"Proposé par Léo.\" hint=\"&lt;p&gt;C'est un mot très court et connu de tous.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;os.&lt;br/&gt;&lt;br/&gt;Il s'écrit de la même façon mais ne se prononce pas pareil.&lt;/p&gt;\" text=\"&lt;p&gt;Quel est le seul mot de la langue française qui s'écrit de la même façon au singulier et au pluriel, mais qui se prononce différemment ?&lt;/p&gt;\" title=\"Le mot français\" type=\"3\"/><riddle answer=\"lune\" answer_type=\"1\" copyright=\"Proposé par Géraldine.\" hint=\"&lt;p&gt;Elle tourne depuis tellement longtemps...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est la lune.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis peut-être ancienne, mais je suis aussi nouvelle. Parfois invisible, souvent pleine.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Le neuf ancien\" type=\"3\"/><riddle answer=\"tailleur\" answer_type=\"1\" copyright=\"Proposé par Audrey.\" hint=\"&lt;p&gt;On peut se faire ... un short aussi.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un tailleur.&lt;/p&gt;\" text=\"&lt;p&gt;Les pierres ont les leurs.&lt;br/&gt; S'y asseoir demande de la souplesse.&lt;br/&gt; Il travaille pour vous sur mesure.&lt;br/&gt;Qui est-il ?&lt;/p&gt;\" title=\"Quel contexte ?\" type=\"3\"/><riddle answer=\"cafe|the|chocolat|tgv|epo\" answer_type=\"3\" copyright=\"Proposé par Nicolas.\" hint=\"&lt;p&gt;En 3 mots.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un café au lait.&lt;br/&gt;&lt;br/&gt;Café, eau, lait.&lt;br/&gt;&lt;br/&gt;Thé au lait, le chocolat au lait, le TGV (Tequila Gin Vodka), EPO (Eau, Pastis, Orgeat) sont également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Mon premier est une boisson,&lt;br/&gt;Mon second est une boisson,&lt;br/&gt;Mon troisième est une boisson,&lt;br/&gt;Mon tout est une boisson.&lt;/p&gt;\" title=\"Charade liquide\" type=\"3\"/><riddle answer=\"lettre\" answer_type=\"1\" copyright=\"Proposé par Docteur Retali.\" hint=\"&lt;p&gt;Les enfants les apprenent en chantant.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La lettre&lt;br/&gt;&lt;br/&gt;La merveilleuse œuvre de Daudet : &quot;les lettres de mon moulin&quot;.&lt;br/&gt;&quot;Obéir à la lettre&quot; pour le fait de se conformer à quelque chose.&lt;br/&gt;Sur une lettre (postale, etc.) il y a des lettres.&lt;br/&gt;L'expression : &quot;Au pied de la lettre&quot;&lt;/p&gt;\" text=\"&lt;p&gt;- Célèbres quand elles émanent de chez le meunier.&lt;br/&gt;- Se conformer, c'est y obéir.&lt;br/&gt;- Quand elle est le contenant, elle remplit son contenu.&lt;br/&gt;- Ne pas réfléchir, c'est rester à ses pieds.&lt;/p&gt;\" title=\"Longues soirées\" type=\"3\"/><riddle answer=\"poireau|poiro\" answer_type=\"3\" copyright=\"Proposé par Dan.\" hint=\"&lt;p&gt;Un légume.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un poireau.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est ce qui est vert comme le pré, blanc comme neige, et barbu comme une chèvre ?&lt;/p&gt;\" title=\"Le masticore\" type=\"3\"/><riddle answer=\"jongle|jongla\" answer_type=\"3\" copyright=\"Proposé par Swan.\" hint=\"&lt;p&gt;Il a fait du cirque.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il a jonglé avec les lingots.&lt;/p&gt;\" text=\"&lt;p&gt;Un vieux pont de 1km de long est suspendu à 25 mètres du sol. Il supporte au maximum 80kg.&lt;br/&gt;Un homme de 78kg a réussi à voler 3 lingots d'or pesant 800 grammes chacun. Il est poursuivi par la police et doit à tout prix traverser le pont en une fois.&lt;br/&gt;Le lendemain, il est retrouvé par la police et on apprend qu'il a traversé le pont.&lt;/p&gt;&lt;p&gt;Comment s'y est-il pris ?&lt;/p&gt;\" title=\"Le pont\" type=\"3\"/><riddle answer=\"preservati|capot\" answer_type=\"3\" copyright=\"Proposé par Boris.\" hint=\"&lt;p&gt;Souvent rangé dans le portefeuille.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un préservatif.&lt;/p&gt;\" text=\"&lt;p&gt;Si je ne suis pas là, je peux donner la vie.&lt;br/&gt;Si je ne suis pas là, je peux donner la mort&lt;br/&gt;Mais si je suis là, je ne peux donner ni l'un, ni l'autre.&lt;/p&gt;\" title=\"Dieu\" type=\"3\"/><riddle answer=\"paupier\" answer_type=\"1\" copyright=\"Proposé par Thomas.\" hint=\"&lt;p&gt;En ce moment elles sont ouvertes.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Ce sont les paupières.&lt;/p&gt;\" text=\"&lt;p&gt;Nous sommes jumelles, tout le monde en a, mais à nous deux, nous pouvons faire disparaitre le monde.&lt;/p&gt;&lt;p&gt;Qui sommes-nous ?&lt;/p&gt;\" title=\"Disparition\" type=\"3\"/><riddle answer=\"phare|gardien\" answer_type=\"3\" copyright=\"Proposé par Lou.\" hint=\"&lt;p&gt;Pour diriger.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;M. Martin est gardien de phare.&lt;/p&gt;\" text=\"&lt;p&gt;M. Martin allume une lumière tous les soirs avant d'aller se coucher. Malheureusement, un soir, il oublie de l'allumer et au réveil, il retrouve plein de morts autour de chez lui.&lt;/p&gt;&lt;p&gt;Pourquoi ?&lt;/p&gt;\" title=\"Avec un mot\" type=\"3\"/><riddle answer=\"mine\" answer_type=\"1\" copyright=\"Proposé par Mélody.\" hint=\"&lt;p&gt;Très dangereux.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une mine.&lt;/p&gt;\" text=\"&lt;p&gt;Bonne ou mauvaise, d'or ou d'argent, faites attention à vos pas...&lt;/p&gt;\" title=\"Attention\" type=\"3\"/><riddle answer=\"exemple\" answer_type=\"1\" copyright=\"Proposé par Béatrice.\" hint=\"&lt;p&gt;Souvent utilisé pour montrer à l'école.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un exemple.&lt;/p&gt;\" text=\"&lt;p&gt;Il aime à être montré et suivi, et l'imiter est toujours bon. Il peut servir de leçon et de mise en garde aussi.&lt;/p&gt;&lt;p&gt;Qui est-ce ?&lt;/p&gt;\" title=\"C'est pour ça\" type=\"3\"/><riddle answer=\"os\" answer_type=\"1\" copyright=\"Proposé par Boris.\" hint=\"&lt;p&gt;Ils se cassent parfois.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les os du corps humain.&lt;br/&gt;&lt;br/&gt;Les bébés en ont 270 mais certains fusionnent pour ne faire qu'un (Les os du crâne par exemple).&lt;/p&gt;\" text=\"&lt;p&gt;270 pour les petits, 206 pour les plus grands.&lt;/p&gt;&lt;p&gt;Qui sommes-nous ?&lt;/p&gt;\" title=\"Décrementer\" type=\"3\"/><riddle answer=\"plomb\" answer_type=\"1\" copyright=\"Proposé par Maiden.\" hint=\"&lt;p&gt;Certains ont essayés de le changer en or.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le plomb.&lt;/p&gt;\" text=\"&lt;p&gt;Métal ni noir, ni rouge.&lt;br/&gt;Aussi lourd que l'or convoité.&lt;br/&gt;Votre sommeil peut l'être.&lt;br/&gt;Tout comme le soleil, les jambes ou le ciel.&lt;/p&gt;\" title=\"Battre le fer\" type=\"3\"/><riddle answer=\"devise\" answer_type=\"1\" copyright=\"Proposé par Guillaume.\" hint=\"&lt;p&gt;Certaines personnes en ont une.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une devise.&lt;/p&gt;\" text=\"&lt;p&gt;On m'échange contre tout produit, mais je sers aussi de règle de vie.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Le troc\" type=\"3\"/><riddle answer=\"terre|planete\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;On est tous dessus.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La Terre.&lt;/p&gt;\" text=\"&lt;p&gt;Tel un fruit je comporte un noyau et pourtant on ne peut pas me manger.&lt;br/&gt;Tel une femme, j'ai plein de manteaux et pourtant je ne suis pas humaine.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Le fruit défendu\" type=\"3\"/><riddle answer=\"langue\" answer_type=\"1\" copyright=\"Proposé par Gaëlle.\" hint=\"&lt;p&gt;Et je suis humide.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La langue.&lt;/p&gt;\" text=\"&lt;p&gt;Je peux être de bois ou mauvaise. Je peux me délier mais sans moi je suis muet.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Multiples\" type=\"3\"/><riddle answer=\"mort\" answer_type=\"1\" copyright=\"Proposé par Géraldine.\" hint=\"&lt;p&gt;Seules les personnes en vie peuvent répondre.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La mort.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis le pire ennemi de l'Homme et tous me craignent. Je vais chez les riches et les pauvres pour les faire pleurer. Pourtant on me fête et on m'offre des présents.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Mesrine\" type=\"3\"/><riddle answer=\"temps\" answer_type=\"1\" copyright=\"Proposé par Romain.\" hint=\"&lt;p&gt;Quand arrive l'hiver ou l'été, ce n'est pas toujours vrai.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le temps.&lt;/p&gt;\" text=\"&lt;p&gt;On ne peut me reculer ni m'avancer, mais je suis pourtant compté.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Paradoxe d'avant\" type=\"3\"/><riddle answer=\"dandy|dandi\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Un homme élégant.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un dandy.&lt;br/&gt;&lt;br/&gt;C'est un homme élégant (sur son 31). Si il peut s'habiller à la minute, c'est un &quot;dandy minute&quot;.&lt;/p&gt;\" text=\"&lt;p&gt;Cette devinette est tirée du film &quot;La vie est belle&quot; : &lt;br/&gt;En moins de deux, il se met sur son 31. La solution de cette énigme te dit dans quelle limite de temps tu dois la résoudre.&lt;/p&gt;\" title=\"La vie est belle\" type=\"3\"/><riddle answer=\"courant|moulin\" answer_type=\"3\" copyright=\"Proposé par Christian.\" hint=\"&lt;p&gt;Quand on vous donne une information, on vous met au...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le courant.&lt;/p&gt;&lt;p&gt;Un moulin est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Qui suis-je ?&lt;/p&gt;&lt;p&gt; - Je peux être d'eau,&lt;br/&gt; - Je peux être d'air,&lt;br/&gt; - Je peux être d'électricité.&lt;/p&gt;\" title=\"Les éléments\" type=\"3\"/><riddle answer=\"de\" answer_type=\"1\" copyright=\"Proposé par Moumou.\" hint=\"Pour coudre.\" image=\"\" solution=\"&lt;p&gt;Le dé.&lt;/p&gt;\" text=\"&lt;p&gt;A la fois protecteur et bon compagnon de jeu, je joue cependant sur plusieurs faces.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"The gamer\" type=\"3\"/><riddle answer=\"ski|piste|oeil|œil\" answer_type=\"3\" copyright=\"Proposé par Quentin.\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une piste de ski.&lt;/p&gt;&lt;p&gt;Un oeil est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est ce qui est vert, bleu ou encore noir, mais qui est toujours blanc ?&lt;/p&gt;\" title=\"L'arc-en-ciel\" type=\"3\"/><riddle answer=\"froid|feu\" answer_type=\"3\" copyright=\"Proposé par Anthony.\" hint=\"&lt;p&gt;Trembler, jusqu'à claquer des dents.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le froid.&lt;/p&gt;&lt;p&gt;Le feu est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Je fais trembler les gens depuis la nuit des temps et l'homme me combat régulièrement. Chez toi, c'est dans une boite que je suis enfermé.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"L'ennemi public\" type=\"3\"/><riddle answer=\"telephone\" answer_type=\"1\" copyright=\"Proposé par Remy.\" hint=\"&lt;p&gt;De plus en plus petit.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le téléphone inventé par Alexander Graham Bell (Bell = cloche en anglais).&lt;/p&gt;\" text=\"&lt;p&gt;Contrairement à ce que son nom pourrait laisser croire aux anglais, mon inventeur est loin d'être une cloche.&lt;/p&gt;&lt;p&gt;De nos jours, presque personne ne peut se passer de moi. Je suis quasiment dans toutes les poches.&lt;/p&gt;&lt;p&gt;Un groupe de rock porte même son nom.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"La voix\" type=\"3\"/><riddle answer=\"puit\" answer_type=\"1\" copyright=\"Proposé par Camille\" hint=\"Un trou dans le sol\" image=\"\" solution=\"&lt;p&gt;Un puits.&lt;/p&gt;\" text=\"&lt;p&gt;Pouvant être de lumière, j'ai pour habitude d'être rempli par en bas et vidé par en haut.&lt;/p&gt;\" title=\"L'inversé\" type=\"3\"/><riddle answer=\"livre|cahier|magazine\" answer_type=\"3\" copyright=\"Proposé par Sébastien.\" hint=\"&lt;p&gt;Chacune de mes feuilles est numérotée&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un livre.&lt;/p&gt;\" text=\"&lt;p&gt;J'ai des feuilles mais je ne suis pas un arbre.&lt;br/&gt;J'ai une couverture mais je ne suis pas un lit.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Triste automne\" type=\"3\"/><riddle answer=\"aiguille\" answer_type=\"1\" copyright=\"Proposée par Ismail.\" hint=\"&lt;p&gt;Parfois elles s'arrêtent quand même, mais ce n'est que le temps de changer la pile.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les aiguilles d'une horloge ou d'une montre.&lt;/p&gt;\" text=\"&lt;p&gt;Nous sommes 3, plus grandes les unes que les autres, et nous faisons sans cesse la course.&lt;/p&gt;&lt;p&gt;Qui sommes-nous ?&lt;/p&gt;\" title=\"La course\" type=\"3\"/><riddle answer=\"unmot\" answer_type=\"2\" copyright=\"Proposé par Faika.\" hint=\"&lt;p&gt;Il faut parfois suivre l'explication à la lettre.&lt;/p&gt;\" image=\"abc\" solution=\"&lt;p&gt;M O U N T = un mot.&lt;/p&gt;\" text=\"&lt;p&gt;Ecrivez un mot avec les lettres suivantes : M O U N T.&lt;/p&gt;&lt;p&gt;Les lettres ne doivent être utilisées qu'une seule fois.&lt;/p&gt;\" title=\"Le mot magique\" type=\"3\"/><riddle answer=\"ombre\" answer_type=\"1\" copyright=\"Proposé par FarcheumD\" hint=\"&lt;p&gt;Se mettre devant une lumière peut faire apparaître la réponse.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une ombre.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis grande ou petite.&lt;br/&gt;Je peux apparaître ou disparaître.&lt;br/&gt;La lumière montre,&lt;br/&gt;Ce que la nuit cache.&lt;br/&gt;Le temps peut jouer,&lt;br/&gt;Pour vous faire voir ou oublier.&lt;br/&gt;Le poids n'est qu'un chiffre&lt;br/&gt;Qui ne veut rien dire.&lt;br/&gt;Je suis tout le temps&lt;br/&gt;Ceux qui me maintiennent.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Maléable\" type=\"3\"/><riddle answer=\"bague|alliance|bracelet|collier\" answer_type=\"3\" copyright=\"Proposé par Yann.\" hint=\"&lt;p&gt;Beaucoup de femmes en ont.&lt;/p&gt;\" image=\"heart\" solution=\"&lt;p&gt;C'est une bague.&lt;/p&gt;\" text=\"&lt;p&gt;Roméo, grand romantique, a décidé d'offrir à Juliette un objet creux, sans fond, rond, destiné à contenir de la chair, des os et du sang.&lt;/p&gt;&lt;p&gt;De quoi s'agit-il ?&lt;/p&gt;\" title=\"Roméo\" type=\"3\"/><riddle answer=\"sablier|clepsydre\" answer_type=\"3\" copyright=\"Proposé par Flamme.\" hint=\"&lt;p&gt;Le temps de vider.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un sablier.&lt;/p&gt;&lt;p&gt;Une clepsydre est également acceptée.&lt;/p&gt;\" text=\"&lt;p&gt;Plus je me vide, plus je me remplis. Pourtant, rien ne rentre ni ne sort.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Remplissage\" type=\"3\"/><riddle answer=\"echo|perroque\" answer_type=\"3\" copyright=\"Proposé par Justin.\" hint=\"&lt;p&gt;Eh ohh.&lt;/p&gt;\" image=\"speak\" solution=\"&lt;p&gt;L'écho.&lt;/p&gt;&lt;p&gt;Un perroquet est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Il parle toutes les langues sans les comprendre. Il loge dans les hauteurs et jamais dans les dunes. Il faut bien se garder de lui faire confiance car il va répéter la moindre confidence.&lt;/p&gt;&lt;p&gt;Qui est-ce ?&lt;/p&gt;\" title=\"Le linguiste\" type=\"3\"/><riddle answer=\"sommeil\" answer_type=\"1\" copyright=\"Proposée par Alex.\" hint=\"&lt;p&gt;Léger ou de plomb.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le sommeil.&lt;/p&gt;\" text=\"&lt;p&gt;Tout le monde le cherche et veut le trouver.&lt;/p&gt;&lt;p&gt;Quand on l'a trouvé, on ne s'en rend compte que lorsqu'il est parti.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Va et vient\" type=\"3\"/><riddle answer=\"averti\" answer_type=\"1\" copyright=\"Proposée par Louis.\" hint=\"&lt;p&gt;Une célèbre expression.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un homme averti en vaut deux!&lt;/p&gt;&lt;p&gt;Le chevalier pesait donc le double, soit 200kg.&lt;/p&gt;\" text=\"&lt;p&gt;Un chevalier pesant 100kg doit traverser un pont suspendu pour se rendre au château voisin quand un troubadour le prévient : &quot;Attention monseigneur! Ce pont ne supporte pas une charge de plus de 150kg!&quot;&lt;/p&gt;&lt;p&gt;Le chevalier le remercie, traverse rassuré, quand tout à coup le pont s'écroule!&lt;/p&gt;&lt;p&gt;Pourquoi ?&lt;/p&gt;\" title=\"Le pont limité\" type=\"3\"/><riddle answer=\"eau\" answer_type=\"1\" copyright=\"Proposée par Damien.\" hint=\"&lt;p&gt;Je suis nécessaire à la vie.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;De l'eau.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est-ce qui peut porter un arbre mais pas un clou ?&lt;/p&gt;\" title=\"Une forte faiblesse\" type=\"3\"/><riddle answer=\"fil\" answer_type=\"1\" copyright=\"Proposée par Théo.\" hint=\"&lt;p&gt;Il n'est pas très solide.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le fil car on se sert du fil dentaire pour l'hygiène et quand on est en de très mauvaises conditions de vie, celle-ci ne tient qu'à un fil.&lt;/p&gt;\" text=\"&lt;p&gt;Bien qu'il puisse servir pour l'hygiène, la vie peut ne tenir qu'à lui dans de très mauvaises conditions.&lt;/p&gt;&lt;p&gt;Qui suis-je?&lt;/p&gt;\" title=\"Hygiène\" type=\"3\"/><riddle answer=\"mur\" answer_type=\"1\" copyright=\"Proposée par Treiz.\" hint=\"&lt;p&gt;Sa solidité fait sa longevité.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un mur.&lt;/p&gt;\" text=\"&lt;p&gt;Je possède un pied mais je ne marche pas, des oreilles qui servent à d'autres, et sur moi, on s'appuie comme sur un ami.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"L'ami étrange\" type=\"3\"/><riddle answer=\"biere\" answer_type=\"1\" copyright=\"Proposée par Roch.\" hint=\"&lt;p&gt;Une boisson alcoolisée très répandue.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La bière.&lt;/p&gt;\" text=\"&lt;p&gt;A force de trop me boire, on finit par faire n'importe quoi et dans le pire des cas, finir dedans.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Moralès\" type=\"3\"/><riddle answer=\"hoquet\" answer_type=\"1\" copyright=\"Proposée par Luc.\" hint=\"&lt;p&gt;Il a du avoir peur.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;L'homme avait le hoquet et la peur lui a fait passer.&lt;/p&gt;\" text=\"&lt;p&gt;Un homme rentre dans un bar et commande un verre d'eau. Le serveur arrive vers lui, prend un fusil, tire et le rate. L'homme lui dit &quot;merci&quot;, laisse un pourboire et s'en va sans boire son verre.&lt;/p&gt;&lt;p&gt;Pourquoi ?&lt;/p&gt;\" title=\"Le barman\" type=\"3\"/><riddle answer=\"braille|aveugle\" answer_type=\"3\" copyright=\"Proposée par Cyrielle.\" hint=\"&lt;p&gt;Tactile.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Lucas lit un livre en braille.&lt;/p&gt;\" text=\"&lt;p&gt;En 1920, Lucas était en train de faire la lecture à Marie dans sa chambre. Fatiguée, elle a éteint la lumière plongeant la chambre dans l'obscurité totale, cependant Lucas continua son histoire.&lt;/p&gt;&lt;p&gt;Comment est-ce possible ?&lt;/p&gt;\" title=\"La lecture\" type=\"3\"/><riddle answer=\"ordre\" answer_type=\"1\" copyright=\"Proposée par Emeline.\" hint=\"&lt;p&gt;La police.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;L'ordre.&lt;/p&gt;\" text=\"&lt;p&gt;Quand on m'en donne, j'obéis. Mais certaines personnes le font régner.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Le don\" type=\"3\"/><riddle answer=\"allumet|alumett\" answer_type=\"3\" copyright=\"Proposée par Mainouma.\" hint=\"&lt;p&gt;Une boite de soeurs.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une allumette.&lt;/p&gt;\" text=\"&lt;p&gt;Allongée parmi mes soeurs, j'ai la tête rouge.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Grand lit\" type=\"3\"/><riddle answer=\"spatio|cosmona|astrona|plongeur|scaphandr\" answer_type=\"3\" copyright=\"Proposée par Adrien.\" hint=\"&lt;p&gt;Besoin d'air.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Youri est Spationaute / Astronaute / Cosmonaute / Taïkonautes.&lt;/p&gt;&lt;p&gt;Un plongeur et un scaphandrier sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Youri marche tranquillement à son travail, mais il perce son pantalon involontairement et meurt quelques instants après.&lt;/p&gt;&lt;p&gt;Quel est le métier de Youri ?&lt;/p&gt;\" title=\"Métier dangereux\" type=\"3\"/><riddle answer=\"oeil|yeux|œil\" answer_type=\"3\" copyright=\"Proposée par Emma.\" hint=\"&lt;p&gt;Vous vous en servez actuellement.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les yeux.&lt;/p&gt;\" text=\"&lt;p&gt;Bruns, bleus, verts, nous sommes deux frères. L'un ne voit pas l'autre mais on peut voir en même temps. Quand nous ouvrons nos volets, nous apercevons le reflet de la vie.&lt;/p&gt;&lt;p&gt;Qui sommes-nous ?&lt;/p&gt;\" title=\"Les frères\" type=\"3\"/><riddle answer=\"lentil\" answer_type=\"1\" copyright=\"Proposée par Pierre.\" hint=\"&lt;p&gt;C'est plein de fer.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une lentille.&lt;/p&gt;\" text=\"&lt;p&gt;Une graine aux valeurs nutritives, des myopes je fais le bonheur. Sans moi, les appareils photos ne verraient rien.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Les graines\" type=\"3\"/><riddle answer=\"rose|vent|boussole\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Course d'orientation.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La rose des vents (indication des points cardinaux sur une boussole).&lt;/p&gt;\" text=\"&lt;p&gt;Je contiens une fleur avec 4 gros pétales qui m'aideront dans l'inconnu.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Jolie fleur\" type=\"3\"/><riddle answer=\"impossible\" answer_type=\"1\" copyright=\"Proposée par Christopher.\" hint=\"&lt;p&gt;... n'est pas français.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Impossible.&lt;/p&gt;\" text=\"&lt;p&gt;En France, on dit que rien ne l'est, pourtant s'il l'est on ne peut le faire.&lt;/p&gt;&lt;p&gt;Qu'est ce que c'est ?&lt;/p&gt;\" title=\"Français\" type=\"3\"/><riddle answer=\"soufflet\" answer_type=\"1\" copyright=\"Proposée par Guillaume.\" hint=\"&lt;p&gt;Raviver le feu de la cheminée.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un soufflet.&lt;/p&gt;\" text=\"&lt;p&gt;Appliqué d'une main, il marque une offense.&lt;/p&gt;&lt;p&gt;Activé de deux, de la flamme il conduit la danse.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Les mains\" type=\"3\"/><riddle answer=\"pantalon|slip|boxer|calecon|culotte\" answer_type=\"3\" copyright=\"Proposée par Kenny.\" hint=\"&lt;p&gt;Vous en portez sans doute un.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il lui a demandé son pantalon.&lt;/p&gt;\" text=\"&lt;p&gt;Un chevalier malicieux demande à son écuyer de lui apporter un objet : &quot;On y rentre par un trou et en sort par deux&quot;.&lt;/p&gt;&lt;p&gt;Quel objet le chevalier lui a-t-il demandé ?&lt;/p&gt;\" title=\"Le chevalier\" type=\"3\"/><riddle answer=\"espoir\" answer_type=\"1\" copyright=\"Proposée par Axel.\" hint=\"&lt;p&gt;Tant qu'il y en a ...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;L'espoir.&lt;/p&gt;\" text=\"&lt;p&gt;On s'y accroche pour vivre, on est désespéré quand on n'en a plus. C'est la seule chose plus forte que la peur ?&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Honneur\" type=\"3\"/><riddle answer=\"route\" answer_type=\"1\" copyright=\"Proposée par Mathieu.\" hint=\"&lt;p&gt;On est bientôt arrivé ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La route.&lt;/p&gt;\" text=\"&lt;p&gt;Je vais de village en village, de ville en ville, mais jamais je ne m'arrête.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"C'est long\" type=\"3\"/><riddle answer=\"ceinture|securite\" answer_type=\"3\" copyright=\"Proposée par Jérémy.\" hint=\"&lt;p&gt;3 points en moins.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La ceinture de sécurité.&lt;/p&gt;\" text=\"&lt;p&gt;La clavicule, je peux te casser.&lt;br/&gt;Néanmoins, la vie je peux te sauver.&lt;br/&gt;En trois mots on peut me résumer.&lt;br/&gt;Je rime avec ce verset.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Ouf!!\" type=\"3\"/><riddle answer=\"securite|social|assurance|maladie|assure\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Mieux vaut y être inscrit.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;L'assurance maladie.&lt;/p&gt;\" text=\"&lt;p&gt;Même couvert, je peux tomber malade.&lt;br/&gt;J'ai une couverture, mais je ne suis pas un lit.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Malade imaginaire\" type=\"3\"/><riddle answer=\"o\" answer_type=\"2\" copyright=\"Proposée par Daxouene.\" hint=\"&lt;p&gt;Du français.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La lettre o.&lt;/p&gt;\" text=\"&lt;p&gt;Solo en duo et duo en solo.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Solo, duo\" type=\"3\"/><riddle answer=\"route|autoroute|chemin|rail\" answer_type=\"3\" copyright=\"Proposée par Wiloo\" hint=\"&lt;p&gt;Vous passez souvent dessus lors de vos déplacements.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La route.&lt;/p&gt;&lt;p&gt;Les rails fonctionnent également.&lt;/p&gt;\" text=\"&lt;p&gt;J'ai été inventé pour rouler mais je ne roule pas.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Roule\" type=\"3\"/><riddle answer=\"stylo|crayon\" answer_type=\"3\" copyright=\"Proposée par Thomas.\" hint=\"&lt;p&gt;Surtout à partir du CP.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un stylo.&lt;/p&gt;\" text=\"&lt;p&gt;Je compose dans toutes les langues et j'ai tout le temps la tête à l'envers.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Multilinguisme\" type=\"3\"/><riddle answer=\"laver|linge\" answer_type=\"3\" copyright=\"Proposée par Thomas.\" hint=\"&lt;p&gt;Utile pour vous habiller.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une machine à laver.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis le contraire d'un bateau : Regardez à travers le hublot, il fait beau, la tempête est dedans.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Hublot\" type=\"3\"/><riddle answer=\"fil|corde|ligne\" answer_type=\"3\" copyright=\"Proposée par Manon.\" hint=\"&lt;p&gt;Parfois il dépasse de vos vêtements.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le fil.&lt;/p&gt;&lt;p&gt;Une corde est également acceptée.&lt;/p&gt;\" text=\"&lt;p&gt;Je peux être long comme court, épais comme fin.&lt;br/&gt;On peut me couper mais je peux servir à lier deux objets.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Petit gros\" type=\"3\"/><riddle answer=\"nuisette|pyjama|pijama|nuit|chemise\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Plus pour les enfants&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un pyjama.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis une tenue de soirée mais que l'on ne met jamais pour sortir.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Habit malade\" type=\"3\"/><riddle answer=\"ombre\" answer_type=\"1\" copyright=\"Proposée par Frédéric.\" hint=\"&lt;p&gt;Avec de la lumière.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;L'ombre.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis sous tes pas au soleil de midi. Tu ne peux pas me perdre, même si tu me fuis.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Coller\" type=\"3\"/><riddle answer=\"farce\" answer_type=\"1\" copyright=\"Proposée par Mathieu.\" hint=\"&lt;p&gt;A l'intérieur&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La farce.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis une plaisanterie très utilisée en cuisine.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Cuisine\" type=\"3\"/><riddle answer=\"fraise|coin|poire\" answer_type=\"3\" copyright=\"Proposée par Thomas.\" hint=\"&lt;p&gt;Dentiste.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La fraise.&lt;/p&gt;&lt;p&gt;Le coin (coing) et la poire sont aussi acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;A la fois fruit et outil, les enfants m'aiment et me détestent.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Les opposés\" type=\"3\"/><riddle answer=\"trou|helium|vide\" answer_type=\"3\" copyright=\"Proposée par Romane.\" hint=\"&lt;p&gt;Un changement dans la matière. &lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Des trous.&lt;/p&gt;&lt;p&gt;&lt;/p&gt;&lt;p&gt;L'hélium et le vide sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Plus il y en a, moins ça pèse.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"L'inverse\" type=\"3\"/><riddle answer=\"reve|songe\" answer_type=\"3\" copyright=\"Proposée par LeMettaleux\" hint=\"&lt;p&gt;Signe d'une imagination certaine. &lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un rêve.&lt;/p&gt;&lt;p&gt;Un songe est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Je peux être tout,&lt;br/&gt;Long, court,&lt;br/&gt;Sombre, lumineux,&lt;br/&gt;Beau, immonde,&lt;br/&gt;Effrayant, féérique...&lt;br/&gt;Il arrive que l'on m'oublie,&lt;br/&gt;Ou l'on me remémore,&lt;br/&gt;Je parcours les esprits,&lt;br/&gt;Habituellement la nuit,&lt;br/&gt;Et je suis, dit-on,&lt;br/&gt;Signe de bonne santé si je passe.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Multiple\" type=\"3\"/><riddle answer=\"chat|noir\" answer_type=\"3\" copyright=\"Proposée par LeMettaleux.\" hint=\"&lt;p&gt;Whiskas.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un chat noir.&lt;/p&gt;\" text=\"&lt;p&gt;Par les superstitions et légendes,&lt;br/&gt;On me relie au mal et au mystique.&lt;br/&gt;De la nuit j'ai la couleur,&lt;br/&gt;Et je l'ai toujours parcourue sans peur.&lt;br/&gt;A notre époque je vis au logis,&lt;br/&gt;Sans le moindre souci,&lt;br/&gt;Et ceux qui me craignent,&lt;br/&gt;Se font de plus en plus rares.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Étranger\" type=\"3\"/><riddle answer=\"trou\" answer_type=\"1\" copyright=\"Proposée par Maruschka.\" hint=\"&lt;p&gt;Un plus pour mettre l'eau en dehors.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Des trous.&lt;/p&gt;\" text=\"&lt;p&gt;J'ai un tonneau fermé qui contient 7 litres d'eau. Qu'est ce que je devrais rajouter pour qu'il n'y ait plus que 5 litres d'eau ?&lt;/p&gt;\" title=\"Le tonneau\" type=\"3\"/><riddle answer=\"timbre|cheque\" answer_type=\"3\" copyright=\"Proposée par Milene.\" hint=\"&lt;p&gt;A coller.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un timbre.&lt;/p&gt;&lt;p&gt;Un chèque est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Si on me sépare de mes frères, je vous montrerai mes dents.&lt;/p&gt;&lt;p&gt;Ma valeur est influencée par l'encre qui se trouve sur moi.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Valeureux\" type=\"3\"/><riddle answer=\"aucun|personne\" answer_type=\"3\" copyright=\"Proposée par Dédé.\" hint=\"&lt;p&gt;Même surface.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Aucun des deux, en effet, la surface est la même.&lt;/p&gt;\" text=\"&lt;p&gt;Deux agriculteurs (A et B) possèdent un champ de blé chacun d'une surface de 2 hectares. L'agriculteur B met deux fois plus de temps à le récolter que son collègue.&lt;/p&gt;&lt;p&gt;Qui aura le plus de blé ?&lt;/p&gt;\" title=\"La récolte\" type=\"3\"/><riddle answer=\"amour\" answer_type=\"1\" copyright=\"Proposée par Jomistar.\" hint=\"&lt;p&gt;Le 14 février.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;L'amour.&lt;/p&gt;\" text=\"&lt;p&gt;Quand on me partage, je suis beau.&lt;br/&gt;Quand on ne me partage pas, je fais souffrir.&lt;br/&gt;Certains me cherchent désespérement,&lt;br/&gt;D'autres tombent à cause de moi.&lt;br/&gt;Pour d'autres, je reste la plus belle chose qui existe.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Partage\" type=\"3\"/><riddle answer=\"pasteque|pastek\" answer_type=\"3\" copyright=\"Proposée par Bcayla70.\" hint=\"&lt;p&gt;Un fruit&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une pastèque.&lt;/p&gt;\" text=\"&lt;p&gt;Le tour de la ville est vert.&lt;br/&gt;L'intérieur de la ville est rouge.&lt;br/&gt;Mes habitants sont noirs.&lt;br/&gt;La clef est en fer.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"La ville étrange\" type=\"3\"/><riddle answer=\"pot\" answer_type=\"1\" copyright=\"Proposée par Valentin.\" hint=\"&lt;p&gt;J'ai découvert le ...... aux roses.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un pot (Le pot aux roses).&lt;/p&gt;\" text=\"&lt;p&gt;Je représente la découverte d'un secret si on m'associe à des fleurs. De terre ou de plastique, je peux les contenir.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Matières variées\" type=\"3\"/><riddle answer=\"gras|graisse|huile\" answer_type=\"3\" copyright=\"Proposée par Cloé.\" hint=\"&lt;p&gt;A la surface des pièces.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les pièces étaient grasses, celle-ci ayant séjournées dans le panier de beignets.&lt;/p&gt;\" text=\"&lt;p&gt;Un vendeur de beignets part pour un village et vend tous ses beignets.&lt;/p&gt;&lt;p&gt;Comme il les transportait dans un panier, il met les pièces qu'il a gagné dedans.&lt;/p&gt;&lt;p&gt;En chemin, il a une envie pressante et pose son panier sur un rocher, mais quand il revient quelques minutes plus tard, toutes les pièces ne sont plus dans le panier.&lt;/p&gt;&lt;p&gt;Affolé, il court voir le juge du village. Celui-ci ordonne que  les 437 villageois se mettent en file indienne.&lt;/p&gt;&lt;p&gt;Il fait placer une grande bassine et demande à chaque villageois de placer leurs pièces dedans.&lt;/p&gt;&lt;p&gt;A la 236ième personne, il reconnait le voleur.&lt;/p&gt;&lt;p&gt;Pourquoi ?&lt;/p&gt;\" title=\"Les beignets\" type=\"3\"/><riddle answer=\"s\" answer_type=\"2\" copyright=\"Proposée par Sybil.\" hint=\"&lt;p&gt;Anglais.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;S.&lt;/p&gt;&lt;p&gt;Ce sont les jours de la semaine en anglais. Monday, Tuesday, Wednesday, Thursday, Friday, Saturday.&lt;/p&gt;\" text=\"&lt;p&gt;Quelle est la lettre suivante : &lt;/p&gt;&lt;p&gt;M, T, W, T, F, ?&lt;/p&gt;\" title=\"Suite inhabituelle\" type=\"3\"/><riddle answer=\"h\" answer_type=\"2\" copyright=\"Proposée par Pascal.\" hint=\"&lt;p&gt;Un outil pour couper le bois.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;H.&lt;/p&gt;\" text=\"&lt;p&gt;Quelle est la lettre la plus tranchante ?&lt;/p&gt;\" title=\"Pas elle!\" type=\"3\"/><riddle answer=\"ardoise\" answer_type=\"1\" copyright=\"Proposée par Nicolas.\" hint=\"&lt;p&gt;Plat et noir.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;L'ardoise.&lt;/p&gt;\" text=\"&lt;p&gt;A l'école, indispensable je fus. Je peux être demandée pour régler son dû. Grâce à moi, on est à l'abri sous mon toit.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Ancien temps\" type=\"3\"/><riddle answer=\"couleur\" answer_type=\"1\" copyright=\"Proposée par Alex.\" hint=\"&lt;p&gt;Arc-en-ciel&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les couleurs.&lt;/p&gt;\" text=\"&lt;p&gt;Le borgne les connait toutes, mais l'aveugle n'en connait qu'une.&lt;/p&gt;&lt;p&gt;Il arrive même à certains de les confondre.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Question de vue\" type=\"3\"/><riddle answer=\"joe|dalton\" answer_type=\"3\" copyright=\"Proposée par Boladji.\" hint=\"&lt;p&gt;Lucky Luke&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Joe Dalton.&lt;/p&gt;\" text=\"&lt;p&gt;De mes frères je suis le plus grand. Mais pourtant, je suis visuellement le plus petit.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Les frères\" type=\"3\"/><riddle answer=\"ciseau|ciso|cisau\" answer_type=\"3\" copyright=\"Proposée par Max1595.\" hint=\"&lt;p&gt;Pour couper.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Des ciseaux.&lt;/p&gt;\" text=\"&lt;p&gt;Quand j'écarte les yeux, j'écarte aussi les jambes.&lt;/p&gt;&lt;p&gt;Que suis-je?&lt;/p&gt;\" title=\"L'outil\" type=\"3\"/><riddle answer=\"pou|pediculu\" answer_type=\"3\" copyright=\"Proposée par Constance.\" hint=\"&lt;p&gt;Sur la tête&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un pou (Pediculus humanus).&lt;/p&gt;\" text=\"&lt;p&gt;Quel être vivant peut changer plusieurs fois de tête ?&lt;/p&gt;\" title=\"Le monstre\" type=\"3\"/><riddle answer=\"vendredi\" answer_type=\"1\" copyright=\"Proposée par Dichipie.\" hint=\"&lt;p&gt;Surlendemain = après-demain&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Vendredi.&lt;/p&gt;\" text=\"&lt;p&gt;Si le surlendemain d'hier tombe un dimanche, à quel jour correspond l'avant-veille de demain ?&lt;/p&gt;\" title=\"Jours fous\" type=\"3\"/><riddle answer=\"pause\" answer_type=\"1\" copyright=\"Proposée par Thierry.\" hint=\"&lt;p&gt;Un moment de détente.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La pause.&lt;/p&gt;\" text=\"&lt;p&gt;Elle peut être café, elle peut être cigarette. Ce n'est pas elle qui fait la cuisine.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Ce moment\" type=\"3\"/><riddle answer=\"poche\" answer_type=\"1\" copyright=\"Proposée par Thierry.\" hint=\"&lt;p&gt;Au repos.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les poches.&lt;/p&gt;\" text=\"&lt;p&gt;Ce n'est pas en y mettant les mains que l'on réussit à les remplir.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Réchauffe\" type=\"3\"/><riddle answer=\"parol\" answer_type=\"1\" copyright=\"Proposée par Laurent.\" hint=\"&lt;p&gt;Blabla.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La parole.&lt;/p&gt;\" text=\"&lt;p&gt;Tu as beau me couper, je renais.&lt;/p&gt;&lt;p&gt;Tu dois me prendre pour pouvoir me donner.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Coupe coupe\" type=\"3\"/><riddle answer=\"dent\" answer_type=\"1\" copyright=\"Proposée par Yanissa.\" hint=\"&lt;p&gt;Dans la bouche.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une dent.&lt;/p&gt;\" text=\"&lt;p&gt;Je ne suis ni un roi, ni une reine, mais pourtant je porte une couronne.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Couronné\" type=\"3\"/><riddle answer=\"fosse\" answer_type=\"1\" copyright=\"Proposée par Adelbi.\" hint=\"&lt;p&gt;Un trou souvent.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La fosse.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis au plus profond de l'océan&lt;br/&gt;Envahie de musique&lt;br/&gt;Le public et la troupe me cernent&lt;br/&gt;Je suis sceptique.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Etrangeté\" type=\"3\"/><riddle answer=\"coup\" answer_type=\"1\" copyright=\"Proposée par Isabelle.\" hint=\"&lt;p&gt;Ca peut faire mal.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un coup.&lt;/p&gt;\" text=\"&lt;p&gt;A l'échelle d'une nation, je renverse tout.&lt;br/&gt;Si l'on en compte une douzaine, nous avons un renseignement.&lt;br/&gt;Associer au fil, je peux durer longtemps.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Toute taille\" type=\"3\"/><riddle answer=\"langue\" answer_type=\"1\" copyright=\"Proposée par Mathieu.\" hint=\"&lt;p&gt;32 dents.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La langue entourée de ses 32 dents.&lt;/p&gt;\" text=\"&lt;p&gt;32 dames, toutes vêtues de blanc. Au milieu d'elles se trouve une bavarde.&lt;/p&gt;&lt;p&gt;Qui est-elle ?&lt;/p&gt;\" title=\"Blabla\" type=\"3\"/><riddle answer=\"facteur|boite\" answer_type=\"3\" copyright=\"Proposée par Dédé.\" hint=\"&lt;p&gt;Il passe presque tous les jours.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le facteur.&lt;/p&gt;&lt;p&gt;Une boite aux lettres est également acceptée.&lt;/p&gt;\" text=\"&lt;p&gt;Retire moi une lettre,&lt;br/&gt;Retire moi deux lettres,&lt;br/&gt;Retire moi toutes les lettres,&lt;br/&gt;Je reste toujours le même.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Lettré\" type=\"3\"/><riddle answer=\"heure|temps|minute\" answer_type=\"3\" copyright=\"Proposée par Fahd.\" hint=\"&lt;p&gt;Regardez votre montre.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le temps.&lt;/p&gt;\" text=\"&lt;p&gt;Pour que tu sois en avance, je dois être en retard.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Contraires\" type=\"3\"/><riddle answer=\"mur\" answer_type=\"1\" copyright=\"Proposée par Glenn.\" hint=\"&lt;p&gt;Entre quatre...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un mur.&lt;/p&gt;\" text=\"&lt;p&gt;Pouvant être de son ou d'enceinte, seul, je n'ai aucun rapport avec la musique.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Blocage\" type=\"3\"/><riddle answer=\"menage|manege\" answer_type=\"3\" copyright=\"Proposée par Aurélia.\" hint=\"&lt;p&gt;A la foire.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le ménage.&lt;/p&gt;\" text=\"&lt;p&gt;De corvée je passe à une distraction si l'on échange deux de mes lettres.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Pas drôle\" type=\"3\"/><riddle answer=\"balance\" answer_type=\"1\" copyright=\"Proposée par Fabrice.\" hint=\"&lt;p&gt;La ... de la justice.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une balance.&lt;/p&gt;\" text=\"&lt;p&gt;Je surveille votre alimentation autant que je peux prédire l'avenir pour certains.&lt;/p&gt;&lt;p&gt;J'ai depuis le début crée un pacte avec la république pour mener ses citoyens sur le même pied d'égalité pour toujours.&lt;/p&gt;&lt;p&gt;Mais ne vous confiez jamais à ce genre de personne.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Stoïque\" type=\"3\"/><riddle answer=\"maire|pretre|cure\" answer_type=\"3\" copyright=\"Proposée par John.\" hint=\"&lt;p&gt;Fonction.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est le maire.&lt;/p&gt;&lt;p&gt;Le prêtre est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Dans un petit village, un homme a marié 64 personnes au cours de sa vie. Mais jamais on ne lui a fait de remarque.&lt;/p&gt;&lt;p&gt;Pourquoi ?&lt;/p&gt;\" title=\"Don Juan\" type=\"3\"/><riddle answer=\"raison\" answer_type=\"1\" copyright=\"Proposée par Caillette9.\" hint=\"&lt;p&gt;Where's my mind.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La raison.&lt;/p&gt;\" text=\"&lt;p&gt;Aliénor et Théobald ont organisé une très belle fête pour célébrer leur union. À la fin du repas, le marié, un peu saoul, dit à ses convives: &quot;Si je sais que je l'ai et si on me dit que je ne l'ai pas, je risque de la perdre&quot;.&lt;/p&gt;&lt;p&gt;De quoi s'agit-il?&lt;/p&gt;\" title=\"La fête\" type=\"3\"/><riddle answer=\"hache\" answer_type=\"1\" copyright=\"Proposée par Tom.\" hint=\"&lt;p&gt;Alphabet.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une hache.&lt;/p&gt;\" text=\"&lt;p&gt;Souvent muette, je peux vous couper. On m'enterre à la fin des guerres.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Sans voix\" type=\"3\"/><riddle answer=\"frein|main\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;En voiture.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le frein à main.&lt;/p&gt;\" text=\"&lt;p&gt;As de l'immobilité, je suis là quand vous vous absentez.&lt;/p&gt;&lt;p&gt;Et si vous m'oubliez, les dégâts il faudra compter.&lt;/p&gt;&lt;p&gt;Certains m'utilisent à d'autres fins, en général pour faire les malins.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Stop\" type=\"3\"/><riddle answer=\"bouchon\" answer_type=\"1\" copyright=\"Proposée par Donovan.\" hint=\"&lt;p&gt;Faire sauter le ... ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un bouchon.&lt;/p&gt;\" text=\"&lt;p&gt;Fléau du conducteur, sauveur des boissons.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"A bicyclette\" type=\"3\"/><riddle answer=\"echelle\" answer_type=\"1\" copyright=\"Proposée par Dam'Dam.\" hint=\"&lt;p&gt;Celle de Richter.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une échelle.&lt;/p&gt;\" text=\"&lt;p&gt;Grande à barreaux, je peux aussi être courte avec deux mains.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Grandissant\" type=\"3\"/><riddle answer=\"face\" answer_type=\"1\" copyright=\"Proposée par Cloé\" hint=\"&lt;p&gt;Pile ou ...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Face.&lt;/p&gt;\" text=\"&lt;p&gt;On peut la perdre ou la voiler.&lt;br/&gt;Ou bien encore la cacher.&lt;br/&gt;D'une médaille c'est un côté.&lt;br/&gt;Il y en a 6 sur un dé.&lt;/p&gt;\" title=\"Tête à tête\" type=\"3\"/><riddle answer=\"mais\" answer_type=\"1\" copyright=\"Proposée par Nanou.\" hint=\"&lt;p&gt;Plein de grains.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Du maïs.&lt;/p&gt;\" text=\"&lt;p&gt;Pour me cuire, on enlève mon enveloppe extérieure pour cuire l'intérieur.&lt;br/&gt;Ensuite on mange mon extérieur pour jeter mon intérieur.&lt;br/&gt;Froid ou chaud, jamais je ne suis un fruit&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Alimentation\" type=\"3\"/><riddle answer=\"pianiste|piano\" answer_type=\"3\" copyright=\"Proposée par Justin.\" hint=\"&lt;p&gt;Clavier de ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Guillaume est pianiste.&lt;/p&gt;\" text=\"&lt;p&gt;Guillaume va au travail où toute la journée, il a tapé sur son clavier. Cependant il n'a rien écrit.&lt;/p&gt;&lt;p&gt;Pourquoi ?&lt;/p&gt;\" title=\"Feignant\" type=\"3\"/><riddle answer=\"paille\" answer_type=\"1\" copyright=\"Proposée par Nonos.\" hint=\"&lt;p&gt;Pour boire.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une paille.&lt;/p&gt;\" text=\"&lt;p&gt;On me trouve dans une ferme.&lt;br/&gt;On peut me trouver dans un verre.&lt;br/&gt;Les vaches m'apprécient.&lt;br/&gt;Je peux être de toute les couleurs.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Moulte choses\" type=\"3\"/><riddle answer=\"berge\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;L'étoile du ...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un berger.&lt;/p&gt;\" text=\"&lt;p&gt;Chien, gardien ou indicateur, je peux parfois être allemand.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Mélange\" type=\"3\"/><riddle answer=\"mort\" answer_type=\"1\" copyright=\"Proposée par Dédé.\" hint=\"&lt;p&gt;Pas très joyeux.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La mort.&lt;/p&gt;\" text=\"&lt;p&gt;Plus on en est près, plus on y pense et quand on y est, on n'y pense plus.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Va et vient\" type=\"3\"/><riddle answer=\"maire\" answer_type=\"1\" copyright=\"Proposée par Jilian.\" hint=\"&lt;p&gt;Elu.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Il a été élu maire.&lt;/p&gt;\" text=\"&lt;p&gt;Un soir, Jérémy qui est le papa de deux enfants annonce à sa femme : &quot;Ca y est, ce soir je suis ton égal phonétiquement&quot;.&lt;/p&gt;&lt;p&gt;Quel évènement s'est-il produit ?&lt;/p&gt;\" title=\"Maman\" type=\"3\"/><riddle answer=\"roseau|roso\" answer_type=\"3\" copyright=\"Proposée par Vero.\" hint=\"&lt;p&gt;Pour faire des parchemins.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le roseau.&lt;/p&gt;\" text=\"&lt;p&gt;J'ai l'air fragile.&lt;br/&gt;Je me plie mais je ne me casse pas quand le vent me souffle dessus.&lt;br/&gt;Cela fait des siècles que l'ont m'utilise.&lt;br/&gt;On me trouve souvent près de l'eau.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Des siècles d'utilité\" type=\"3\"/><riddle answer=\"ciseau|siso|ciso\" answer_type=\"3\" copyright=\"Proposée par Senda.\" hint=\"&lt;p&gt;Couper.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Des ciseaux.&lt;/p&gt;\" text=\"&lt;p&gt;Quand mes deux parties s'assemblent je sépare.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Deux font deux\" type=\"3\"/><riddle answer=\"fourchet\" answer_type=\"1\" copyright=\"Proposée par Simon.\" hint=\"&lt;p&gt;Pour manger.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une fourchette.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est ce qui a 4 dents mais pas de bouche ?&lt;/p&gt;\" title=\"Utile\" type=\"3\"/><riddle answer=\"vampir|vampyr|dracul\" answer_type=\"3\" copyright=\"Proposée par loann1999.\" hint=\"&lt;p&gt;Bram stoker&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un vampire.&lt;/p&gt;\" text=\"&lt;p&gt;Froid comme la neige, parfois changeant de peau, volant dès le crépuscule, j'aspire la subtile boisson significative de douleur.&lt;/p&gt;&lt;p&gt;Qui suis-je?&lt;/p&gt;\" title=\"Persona non grata\" type=\"3\"/><riddle answer=\"eclair|croissant|phare|far\" answer_type=\"3\" copyright=\"Proposée par Inès.\" hint=\"&lt;p&gt;Logo d'électrocution&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un éclair.&lt;/p&gt;&lt;p&gt;Un croissant et un phare (far) sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Je peux illuminer le ciel ou te régaler.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Miam ou Bam ?!\" type=\"3\"/><riddle answer=\"temps\" answer_type=\"1\" copyright=\"Proposée par Français C.\" hint=\"&lt;p&gt;Tic tac.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le temps.&lt;/p&gt;\" text=\"&lt;p&gt;Le puissant et le riche n'en ont pas plus que le petit et le pauvre. Et ni le riche ni le pauvre ne peuvent en accumuler.&lt;/p&gt;&lt;p&gt;Qu'est ce ?&lt;/p&gt;\" title=\"Tous égaux\" type=\"3\"/><riddle answer=\"tresor\" answer_type=\"1\" copyright=\"Proposée par Slim.\" hint=\"&lt;p&gt;La carte au ...&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le trésor.&lt;/p&gt;\" text=\"&lt;p&gt;Quand je suis caché, on me cherche. &lt;br/&gt;Quand je suis public, on me fuit.&lt;/p&gt;&lt;p&gt;Qui suis je ?&lt;/p&gt;\" title=\"Chassé croisé\" type=\"3\"/><riddle answer=\"langue\" answer_type=\"1\" copyright=\"Proposée par Wilcel26102011.\" hint=\"&lt;p&gt;Nous l'avons française.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La langue.&lt;/p&gt;\" text=\"&lt;p&gt;Boeuf, veau ou chat, tout le monde peut me tirer même si je suis parfois étrangère.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Manticore\" type=\"3\"/><riddle answer=\"bougi|allumet|flamme\" answer_type=\"3\" copyright=\"Proposée par Denis.\" hint=\"&lt;p&gt;Elle fond.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une bougie.&lt;/p&gt;&lt;p&gt;Une allumette est également acceptée.&lt;/p&gt;\" text=\"&lt;p&gt;Jeune je suis grande, vieille je suis plus petite. Je vis la nuit de tout mon éclat. Le souffle du vent est mon ennemi.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Tubulaire\" type=\"3\"/><riddle answer=\"derriere|derier\" answer_type=\"3\" copyright=\"Proposée par Jonathan\" hint=\"&lt;p&gt;Un coup de pied dans ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Derrière.&lt;/p&gt;\" text=\"&lt;p&gt;Il ne se voit pas.&lt;br/&gt;Il n'est pas devant.&lt;br/&gt;Il rencontre parfois un pied.&lt;/p&gt;\" title=\"Non-voyant\" type=\"3\"/><riddle answer=\"coco|noix\" answer_type=\"3\" copyright=\"Proposée par Filippo.\" hint=\"&lt;p&gt;Un fruit.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une noix de coco.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis vêtue de poils,&lt;br/&gt;Je suis doté d'une chair.&lt;br/&gt;Je sais produire du lait,&lt;br/&gt;Pourtant je ne suis pas un animal.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Un poil dans le lait\" type=\"3\"/><riddle answer=\"sang\" answer_type=\"1\" copyright=\"Proposée par Logann38\" hint=\"&lt;p&gt;Dans le corps.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le sang.&lt;/p&gt;\" text=\"&lt;p&gt;Quand il ne fait qu'un tour, ce n'est pas un bon présage.&lt;/p&gt;&lt;p&gt;Qu'est ce que c'est ?&lt;/p&gt;\" title=\"Tournicoton\" type=\"3\"/><riddle answer=\"nez|aveugle\" answer_type=\"3\" copyright=\"Proposée par Alexandre.\" hint=\"&lt;p&gt;Porte en support.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le nez.&lt;/p&gt;&lt;p&gt;Un aveugle est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est ce qui porte des lunettes mais ne voit rien ?&lt;/p&gt;\" title=\"Porteur\" type=\"3\"/><riddle answer=\"cerveau|cervo\" answer_type=\"3\" copyright=\"Proposée par Guillaume.\" hint=\"&lt;p&gt;Vous l'utilisez beaucoup avec cette application.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le cerveau&lt;/p&gt;\" text=\"&lt;p&gt;Je possède des yeux par milliard pourtant je vis dans l'obscurité.&lt;br/&gt;J'ai des millions d'oreilles pourtant je n'ai que quatre lobes.&lt;br/&gt;Je n'ai aucun muscles pourtant je contrôle deux hémisphères&lt;/p&gt;&lt;p&gt;Qui suis je ?&lt;/p&gt;\" title=\"Petit gros\" type=\"3\"/><riddle answer=\"tache\" answer_type=\"1\" copyright=\"Proposée par un anonyme.\" hint=\"&lt;p&gt;Une chose visible sur un guépard.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une tache.&lt;/p&gt;\" text=\"&lt;p&gt;Elle peut être de peinture ou de sauce.&lt;br/&gt;Elle a aussi un rapport avec le ménage.&lt;br/&gt;Pour finir, elle peut être présente sur les animaux.&lt;/p&gt;&lt;p&gt;Qu'est ce que c'est ?&lt;/p&gt;\" title=\"Couleur\" type=\"3\"/><riddle answer=\"contraire|oppos|antonym\" answer_type=\"3\" copyright=\"Proposée par Théo.\" hint=\"&lt;p&gt;Différence ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le contraire ou l'antonyme.&lt;/p&gt;\" text=\"&lt;p&gt;Si je suis petit, celui-ci est grand.&lt;br/&gt;Si je suis gentil, celui-ci est méchant.&lt;br/&gt;Si je suis poli, celui-ci est grossier.&lt;/p&gt;&lt;p&gt;Qu'est ce que c'est ?&lt;/p&gt;\" title=\"Faux-Frère\" type=\"3\"/><riddle answer=\"neige\" answer_type=\"1\" copyright=\"Proposée par Océane.\" hint=\"&lt;p&gt;Blanc.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La neige.&lt;/p&gt;\" text=\"&lt;p&gt;Eternelles au pluriel, éphémère au singulier.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Contraire\" type=\"3\"/><riddle answer=\"chien\" answer_type=\"1\" copyright=\"Proposée par Jodie.\" hint=\"&lt;p&gt;Médor.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un chien.&lt;/p&gt;\" text=\"&lt;p&gt;Je peux être de garde ou de compagnie, &lt;br/&gt;On peut me siffler comme on peut m'appeler &lt;/p&gt;&lt;p&gt;Qui suis-je?&lt;/p&gt;\" title=\"Picouic\" type=\"3\"/><riddle answer=\"mouton\" answer_type=\"1\" copyright=\"Proposée par Julie, Lou, Anne et Cloé.\" hint=\"&lt;p&gt;La ferme.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Mouton.&lt;/p&gt;&lt;p&gt;Les moutons (la poussière) ou compter les moutons avant de dormir.&lt;/p&gt;\" text=\"&lt;p&gt;Le balai les ramasse et avant les songes ils s'entassent.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Sauteur\" type=\"3\"/><riddle answer=\"chapeau\" answer_type=\"1\" copyright=\"Proposée par Pierric\" hint=\"&lt;p&gt;De toutes les formes.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un chapeau.&lt;/p&gt;&lt;p&gt;Chat - Pot&lt;/p&gt;&lt;p&gt;Le chapeau melon.&lt;/p&gt;&lt;p&gt;L'expression &quot;Chapeau bas&quot;.&lt;/p&gt;\" text=\"&lt;p&gt;Moitié animal, moitié récipient, je peux avoir une forme de melon et me trouver bien bas.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"L'étrange\" type=\"3\"/><riddle answer=\"roue\" answer_type=\"1\" copyright=\"Proposée par Cloé.\" hint=\"&lt;p&gt;4 sur les voitures.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La roue.&lt;/p&gt;\" text=\"&lt;p&gt;Elle est une experte en tours.&lt;br/&gt;Elle est parfois d'un grand secours.&lt;br/&gt;C'est aussi une figure en gymnastique.&lt;br/&gt;À la fortune on l'associe.&lt;/p&gt;\" title=\"Tourniquet\" type=\"3\"/><riddle answer=\"jupon\" answer_type=\"1\" copyright=\"Proposée par Allan\" hint=\"&lt;p&gt;Sous la robe.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le jupon.&lt;/p&gt;&lt;p&gt;Les femmes en porte sous leurs robes.&lt;/p&gt;&lt;p&gt;Les hommes coureurs de jupons.&lt;/p&gt;&lt;p&gt;Se cacher dans les jupons de sa mère.&lt;/p&gt;\" text=\"&lt;p&gt;Certaines en portent,&lt;br/&gt;&lt;p&gt;Certains en sont des coureurs,&lt;br/&gt;On se cache dans ceux de sa mère.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Run away!!!\" type=\"3\"/><riddle answer=\"indispensabl\" answer_type=\"1\" copyright=\"Proposée par Arthur\" hint=\"&lt;p&gt;Un indice est ce qu'il est.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Indispensable.&lt;/p&gt;&lt;p&gt;Un indice, pensable.&lt;/p&gt;\" text=\"&lt;p&gt;Hugo était presque arrivé jusqu'à la chambre secrète du pharaon. Un dernier obstacle subsistait : une stèle où était gravé, en hiéroglyphes :&lt;/p&gt;&lt;p&gt;&quot;Toi qui oses profaner cette tombe, tu devras te montrer digne de ses trésors en résolvant cette énigme. Prononce à haute voix la réponse, et la chambre s'ouvrira.&quot;&lt;/p&gt;&lt;p&gt;Voici les indices :&lt;br/&gt;- Mon premier est ce qu'il est.&lt;br/&gt;- Mon second est tout, sauf impensable.&lt;br/&gt;- Mon tout est absolument nécessaire.&lt;/p&gt;&lt;p&gt;Quelle est la réponse ?&lt;/p&gt;\" title=\"Le pharaon\" type=\"3\"/><riddle answer=\"magici|prestidi\" answer_type=\"3\" copyright=\"Proposée par Valentin\" hint=\"&lt;p&gt;Gandalf.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un magicien.&lt;/p&gt;\" text=\"&lt;p&gt;De son habileté, il retiendra votre attention. Mais dans son domaine, n'est permise aucune révélations.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Manipulé\" type=\"3\"/><riddle answer=\"palai\" answer_type=\"3\" copyright=\"Proposée par Pierric\" hint=\"&lt;p&gt;Un magnifique château&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un palais.&lt;/p&gt;\" text=\"&lt;p&gt;Sur la glace je suis frappé, je peux être royal, je suis dans toutes les bouches.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Glaçon\" type=\"3\"/><riddle answer=\"orange|rouge\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Une couleur visible.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Contrairement à son nom, la boite noire est orange ou rouge.&lt;/p&gt;\" text=\"&lt;p&gt;De quelle couleur est la boite noire dans les avions ?&lt;/p&gt;\" title=\"La boite noire\" type=\"4\"/><riddle answer=\"mouton\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;C'est un animal qui a bien d'autres utilités.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Elles étaient fabriquées avec l'intestin grêle d'un mouton, et non d'un chat comme beaucoup le pensent.&lt;/p&gt;\" text=\"&lt;p&gt;Les cordes de violon étaient fabriquées avec les boyaux de quel animal ?&lt;/p&gt;\" title=\"Le violon\" type=\"4\"/><riddle answer=\"116\" answer_type=\"0\" copyright=\"\" hint=\"&lt;p&gt;Souvent on arrondit&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La guerre de 100 ans a en réalité duré 116 ans (de 1337 à 1453).&lt;/p&gt;\" text=\"&lt;p&gt;Combien de temps a duré la guerre de 100 ans ?&lt;/p&gt;\" title=\"La guerre\" type=\"4\"/><riddle answer=\"electrise|electrisation\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Vous n'êtes pas mort.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Electrisé et non électrocuté. Une électrocution entraine la mort.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot devriez-vous utiliser pour dire que vous avez déjà reçu une décharge électrique ?&lt;/p&gt;\" title=\"La décharge\" type=\"4\"/><riddle answer=\"blanc\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Et le ciel ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les rayons du soleil sont blancs. Lorsqu'ils passent par l'atmosphère, le bleu est diffusé ainsi qu'une partie du vert (ce qui explique le bleu du ciel). C'est pourquoi on voit le soleil et ses rayons en jaune.&lt;/p&gt;\" text=\"&lt;p&gt;Quelle est la couleur des rayons du soleil ?&lt;/p&gt;\" title=\"Le soleil\" type=\"4\"/><riddle answer=\"albany\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;A 233km au nord de New York.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;C'est la ville d'Albany (environ 100 000 habitants) qui est la capitale de l'état de New York.&lt;/p&gt;\" text=\"&lt;p&gt;Quelle est la capitale de l'état de New York ?&lt;/p&gt;\" title=\"New York, New York\" type=\"4\"/><riddle answer=\"novembre\" answer_type=\"1\" copyright=\"Proposé par Béatrice.\" hint=\"&lt;p&gt;Changement de calendrier.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La révolution d'octobre russe de 1917 a bien eu lieu au mois d'octobre. Mais à cette époque, les russes utilisaient encore le calendrier julien. Ils sont passés au calendrier grégorien l'année suivante. Ce qui fait que le 25 octobre (julien) de l'époque est maintenant fêté le... 7 novembre (grégorien).&lt;/p&gt;\" text=\"&lt;p&gt;En quel mois les russes fêtent-ils la révolution d'octobre ?&lt;/p&gt;\" title=\"La révolution\" type=\"4\"/><riddle answer=\"chien|phoqu\" answer_type=\"3\" copyright=\"Proposé par David.\" hint=\"&lt;p&gt;Les pièges du latin... Heureusement le blason peut aider.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le chien.&lt;br/&gt;&lt;br/&gt;Lorsque les espagnols ont découverts les îles Canaries, beaucoup de chiens les peuplaient. Canaries vient du latin &quot;canis&quot; signifiant chien.&lt;br/&gt;&lt;br/&gt;Les phoques sont également acceptés (Chien de mer).&lt;/p&gt;\" text=\"&lt;p&gt;Quel animal a inspiré le nom des îles Canaries ?&lt;/p&gt;\" title=\"Les iles\" type=\"4\"/><riddle answer=\"caius\" answer_type=\"1\" copyright=\"Proposé par Béatrice.\" hint=\"&lt;p&gt;Beaucoup de célébrités de la rome antique ont ce prénom.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;César avait pour prénom Caïus, un prénom commun dans la Rome antique.&lt;br/&gt;Son nom de famille était Jules, en latin Julius.&lt;/p&gt;\" text=\"&lt;p&gt;Quel était le prénom du chef des armées romaines Jules César ?&lt;/p&gt;\" title=\"La rome antique\" type=\"4\"/><riddle answer=\"air|nitrox|trimix\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;O2 + ? + ? + ?&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;L'être humain vit car il respire non pas seulement de l'oxygène, mais de l'air. Et cet air si vital est constitué à 78% d'azote (ou diazote pour les tatillons), à 21% d'oxygène (ou dioxygène) et à 1% d'autres gaz.&lt;/p&gt;&lt;p&gt;Le nitrox 40 (et autres) est également accepté. C'est un mélange d'air suroxygéné utilisé pour remplir les bouteilles.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'y a-t-il dans les bouteilles de plongée ?&lt;/p&gt;\" title=\"Plongée\" type=\"4\"/><riddle answer=\"leporid\" answer_type=\"1\" copyright=\"Proposé par JE.\" hint=\"&lt;p&gt;Les lièvres aussi.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les lapins font parties de la famille des léporidés (Leporidae) et non de la famille des rongeurs.&lt;/p&gt;\" text=\"&lt;p&gt;A quelle famille d'animaux appartient le lapin ?&lt;/p&gt;\" title=\"Petit petit petit\" type=\"4\"/><riddle answer=\"equateur\" answer_type=\"1\" copyright=\"Proposé par Prathipan.\" hint=\"&lt;p&gt;Plus au sud.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Les chapeaux Panama sont fabriqués en Equateur.&lt;/p&gt;\" text=\"&lt;p&gt;Où sont fabriqués les chapeaux Panama ?&lt;/p&gt;\" title=\"Mon beau chapeau\" type=\"4\"/><riddle answer=\"federation\" answer_type=\"1\" copyright=\"Proposé par Remy.\" hint=\"&lt;p&gt;1 an après.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La fête de la fédération.&lt;br/&gt;&lt;br/&gt;Elle est la première à célébrer la prise de la bastille et la fin de la monarchie absolue. Cette date a été instaurée en 1880.&lt;br/&gt;&lt;br/&gt;Extrait de Wikipedia : &quot;On désigne particulièrement sous le nom de Fête de la Fédération la fête qui fut célébrée au Champ-de-Mars de Paris, le 14 juillet 1790, premier anniversaire de la prise de la Bastille. On y vit réunis les députés des 83 départements, au nombre de 60 000. Louis XVI assista à cette fête, et y prêta serment à la Nation et à la loi.&lt;br/&gt;&lt;br/&gt;L'enthousiasme y fut porté à son comble. Une seconde fédération eut lieu le 14 juillet 1792 ; mais l'union et l'entraînement qui avaient signalé la première avaient déjà fait place aux méfiances. Pendant les Cent-Jours (1815), on tenta de renouveler les anciennes fédérations à Paris et dans la Bretagne, mais sans aucun résultat.&lt;br/&gt;&lt;br/&gt;C'est cet évènement qui est fêté chaque 14 juillet depuis 1880 en tant que Fête nationale française.&quot;&lt;/p&gt;\" text=\"&lt;p&gt;Avec la prise de la bastille, quel évènement est commémoré en France le 14 juillet ?&lt;/p&gt;\" title=\"Fête nationale\" type=\"4\"/><riddle answer=\"hongrois|hongrie\" answer_type=\"3\" copyright=\"Proposé par Guillaume.\" hint=\"&lt;p&gt;L'union européenne en 2004.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Hongroise.&lt;br/&gt;&lt;br/&gt;Cette prise en main a été popularisée par Anna Sipos, célèbre pongiste hongroise.&lt;/p&gt;\" text=\"&lt;p&gt;Quelle est la nationalité du pongiste ayant popularisé la prise &quot;à la chinoise&quot; (ou porte plume) ?&lt;/p&gt;\" title=\"Tennis de table\" type=\"4\"/><riddle answer=\"urine|secretion|salive|fel\" answer_type=\"3\" copyright=\"Proposé par Audrey.\" hint=\"Ca se colle après les poils.\" image=\"\" solution=\"&lt;p&gt;L'allergie aux chats n'est pas produite par leurs poils, qu'ils soient courts ou longs, mais par leurs urines, leur salive et les secrétions de leurs glandes sébacées.&lt;/p&gt;&lt;p&gt;En se léchant, les chats déposent leurs allergènes sur leurs poils, entraînant des réactions allergiques chez ceux qui les touchent ou les approchent. &lt;/p&gt;&lt;p&gt;Leurs allergènes (la protéine Fel D1) s'accumulent sur les tapis, moquettes, tentures, vêtements qu'ils foulent.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'est-ce qui peut nous rendre allergique aux chats ?&lt;/p&gt;\" title=\"Meow!\" type=\"4\"/><riddle answer=\"chin\" answer_type=\"3\" copyright=\"Proposé par Allan.\" hint=\"&lt;p&gt;Les premières civilisations.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;De Chine. Marco Polo les a rapportées à Venise de Chine en 1295, mais les pates étaient déjà connues des italiens à l'époque romaine. Les premières nouilles découvertes viennent de Lajia en Chine et datent de -2000 av JC.&lt;/p&gt;\" text=\"&lt;p&gt;De quel pays / région sont originaires les pâtes ?&lt;/p&gt;\" title=\"Les pâtes\" type=\"4\"/><riddle answer=\"noir\" answer_type=\"1\" copyright=\"Proposé par CleMz.\" hint=\"&lt;p&gt;L'inverse&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Noire.&lt;/p&gt;&lt;p&gt;En effet, sa peau noire lui permet de mieux conserver sa chaleur corporelle.&lt;/p&gt;\" text=\"&lt;p&gt;De quelle couleur est la peau des ours blancs ?&lt;/p&gt;\" title=\"L'ours blanc\" type=\"4\"/><riddle answer=\"allema|hambourg\" answer_type=\"3\" copyright=\"Proposé par Laurence. \" hint=\"&lt;p&gt;Hamb..., une si belle ville.&lt;/p&gt;\" image=\"hamburger\" solution=\"&lt;p&gt;Le hamburger est originaire d'Allemagne, et plus précisement de la ville de Hambourg (Hamburg en allemand).&lt;/p&gt;\" text=\"&lt;p&gt;De quel pays est originaire le hamburger ?&lt;/p&gt;\" title=\"Supersize me\" type=\"4\"/><riddle answer=\"bois\" answer_type=\"1\" copyright=\"Proposée par Dji-Seb.\" hint=\"&lt;p&gt;Parmi les vents.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le saxophone est un instrument à vent faisant partie de la famille des bois.&lt;/p&gt;\" text=\"&lt;p&gt;À quelle famille d'instrument appartient le saxophone ?&lt;/p&gt;\" title=\"Adolphe Sax\" type=\"4\"/><riddle answer=\"camberra|cambera|canberra|canbera\" answer_type=\"3\" copyright=\"Proposée par Matthieu.\" hint=\"&lt;p&gt;C.......&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Canberra est la capitale de l'Australie et non Sydney qui est la plus grande ville du pays.&lt;/p&gt;\" text=\"&lt;p&gt;Quelle est la capitale de l'Australie ?&lt;/p&gt;\" title=\"Capitale\" type=\"4\"/><riddle answer=\"perou|chili|andes\" answer_type=\"3\" copyright=\"Proposée par Tristan.\" hint=\"&lt;p&gt;Les incas en mangeaient.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Du Pérou ou du Chili.&lt;/p&gt;&lt;p&gt;Les incas les élevaient pour les manger.&lt;/p&gt;\" text=\"&lt;p&gt;De quel pays sont originaires les cochons d'Inde ?&lt;/p&gt;\" title=\"Cobaye\" type=\"4\"/><riddle answer=\"blanc\" answer_type=\"1\" copyright=\"Proposée par Justin.\" hint=\"&lt;p&gt;Au stade foetal.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Blanche.&lt;/p&gt;&lt;p&gt;Au stade foetal, le zèbre est entièrement noir, ce n'est qu'après que les rayures apparaissent.&lt;/p&gt;\" text=\"&lt;p&gt;Le zèbre est un animal à rayures. Mais quelle est la couleur de ses rayures ?&lt;/p&gt;\" title=\"Le zèbre\" type=\"4\"/><riddle answer=\"inde\" answer_type=\"1\" copyright=\"Proposée par Thomas\" hint=\"&lt;p&gt;Un pays très peuplé.&lt;/p&gt;\" image=\"formula\" solution=\"&lt;p&gt;D'inde.&lt;/p&gt;&lt;p&gt;Le commerce entre l'Europe et le Moyen-Orient a apporté les chiffres à l'Europe, mais ceux-ci avait été apporté auparavant au Moyen-Orient par les indiens.&lt;/p&gt;\" text=\"&lt;p&gt;De quel pays viennent les chiffres arabes ?&lt;/p&gt;\" title=\"0 1234\" type=\"4\"/><riddle answer=\"ragot\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un ragot.&lt;/p&gt;\" text=\"&lt;p&gt;Message colporté dans un but malveillant, c'est aussi un sanglier de 2 à 3 ans. Je suis...&lt;/p&gt;\" title=\"Enigme n°1\" type=\"5\"/><riddle answer=\"moine\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un moine&lt;/p&gt;\" text=\"&lt;p&gt;Autrefois bien utile pour faire chauffer un lit, ce n'est pas toujours lui que l'on voit dans son habit. Je suis...&lt;/p&gt;\" title=\"Enigme n°2\" type=\"5\"/><riddle answer=\"ble\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Du blé&lt;/p&gt;\" text=\"&lt;p&gt;Mûr à point, il est fauché; fauché on l'est de n'en avoir point. Je suis...&lt;/p&gt;\" title=\"Enigme n°3\" type=\"5\"/><riddle answer=\"tablier\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un tablier&lt;/p&gt;\" text=\"&lt;p&gt;C'est la partie intégrante d'un pont. Le rendre, c'est en avoir ras-le-bol. Et bien qu'il déserte nos écoles, contre les taches, c'est une protection. Je suis...&lt;/p&gt;\" title=\"Enigme n°4\" type=\"5\"/><riddle answer=\"belier\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un bélier&lt;/p&gt;\" text=\"&lt;p&gt;Redoutable machine de guerre, des murs lui cédèrent naguère. Généralement il blatère, et c'est aussi un signe de feu. Je suis...&lt;/p&gt;\" title=\"Enigme n°5\" type=\"5\"/><riddle answer=\"fromage|plat|cake|foin|flan\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Du fromage.&lt;br/&gt;&lt;br/&gt;Un plat, un cake, du foin sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Quelquefois rond ou bien carré, il est plutôt bien moulé. Ca ne vaut pas le coup d'en faire un, surtout pour de tout petits riens. Je suis...&lt;/p&gt;\" title=\"Enigme n°6\" type=\"5\"/><riddle answer=\"mouche\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une mouche&lt;/p&gt;\" text=\"&lt;p&gt;Le vinaigre n'est pas conseillé si on désire l'attraper. Elle est toujours évoquée lorsque la cible est touchée. Je suis...&lt;/p&gt;\" title=\"Enigme n°7\" type=\"5\"/><riddle answer=\"nez\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un nez&lt;/p&gt;\" text=\"&lt;p&gt;Il a une arête et une aile de chaque côté. Parfois comparé à une trompette qui n'est pas forcément bouché. Je suis...&lt;/p&gt;\" title=\"Enigme n°8\" type=\"5\"/><riddle answer=\"matin|jour\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le matin&lt;/p&gt;\" text=\"&lt;p&gt;Il est bon quand il est tôt. Quand il est tôt, il est petit. Mais aussi il peut être beau et quand il est tard il est fini. Je suis...&lt;/p&gt;\" title=\"Enigme n°9\" type=\"5\"/><riddle answer=\"boulet|carton\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un boulet&lt;/p&gt;&lt;p&gt;Un carton est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;La catastrophe vous a frôlé si, près de vous, il est passé. Et personne n'est ménagé quand rouge il est tiré. Je suis...&lt;/p&gt;\" title=\"Enigme n°10\" type=\"5\"/><riddle answer=\"silence\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le silence.&lt;/p&gt;\" text=\"&lt;p&gt;Pour un secret, on peut l'acheter. On peut se taire et le garder. Dans un studio, avant de filmer, c'est toujours lui qui est demandé. Je suis...&lt;/p&gt;\" title=\"Enigme n°11\" type=\"5\"/><riddle answer=\"feu|incendi\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le feu.&lt;/p&gt;\" text=\"&lt;p&gt;Si le vent le pousse et l'excite, il dévore tout ce qu'il voit. Son appétit est sans limite mais s'il boit trop, il se noie. Qui est-il ?&lt;/p&gt;\" title=\"Enigme n°12\" type=\"5\"/><riddle answer=\"lune\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La lune.&lt;/p&gt;\" text=\"&lt;p&gt;Parfois nouvelle, parfois pleine, sa couleur n'est pas celle de l'ébène. Des rêveurs elle est la retraite favorite, c'est le pays des Sélénites. Je suis...&lt;/p&gt;\" title=\"Enigme n°13\" type=\"5\"/><riddle answer=\"debut|depart|1\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le début.&lt;/p&gt;&lt;p&gt;Le chiffre 1 est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Toujours le premier, jamais le dernier, rien sans lui n'est jamais fini, car rien ne peut commencer sans lui. Je suis...&lt;/p&gt;\" title=\"Enigme n°14\" type=\"5\"/><riddle answer=\"point\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le point.&lt;/p&gt;\" text=\"&lt;p&gt;Quand le jour se lève, il est là, mais c'est à la fin qu'on le pose. Il exprime aussi un état et aide à préciser les choses. Je suis...&lt;/p&gt;\" title=\"Enigme n°15\" type=\"5\"/><riddle answer=\"bouton|pince|mousqueton\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un bouton, une pince à linge ou un mousqueton.&lt;/p&gt;\" text=\"&lt;p&gt;C'est un accessoire très utile, qui est petit et attachant. Et s'il ne tient que par un fil, il se fixe aussi en pressant l'un contre l'autre. Je suis...&lt;/p&gt;\" title=\"Enigme n°16\" type=\"5\"/><riddle answer=\"apparence|face|image\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;L'apparence.&lt;/p&gt;&lt;p&gt;La face et l'image sont également acceptées.&lt;/p&gt;\" text=\"&lt;p&gt;D'un être, ou d'une chose, elle est ce que l'on voit. Et si par une on peut être trompé, il en est d'autres que l'on peut sauver. Je suis...&lt;/p&gt;\" title=\"Enigme n°17\" type=\"5\"/><riddle answer=\"date|heure|ephemerique\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une date.&lt;/p&gt;&lt;p&gt;L'heure et une éphéméride sont également acceptées.&lt;/p&gt;\" text=\"&lt;p&gt;Cette donnée que l'on voit changer tout au long de l'année peut cependant être fixée. Je suis...&lt;/p&gt;\" title=\"Enigme n°18\" type=\"5\"/><riddle answer=\"chien\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un chien.&lt;/p&gt;\" text=\"&lt;p&gt;D'une arme à feu, il peut être une pièce. Et nos amis sont nombreux, issus de son espèce. Je suis...&lt;/p&gt;\" title=\"Enigme n°19\" type=\"5\"/><riddle answer=\"the|te\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le thé ou le té.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis le quotidien compagnon du menuisier, mais je préfère la menthe comme compagne de mes soirées..! Qui suis-je ?&lt;/p&gt;\" title=\"Enigme n°20\" type=\"5\"/><riddle answer=\"poisson\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un poisson.&lt;/p&gt;\" text=\"&lt;p&gt;D'avril c'est une farce, de mer ou d'eau douce, il est excellent pour la santé, il est parfois volant. Qui est-il ?&lt;/p&gt;\" title=\"Enigme n°21\" type=\"5\"/><riddle answer=\"journal\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le journal.&lt;/p&gt;\" text=\"&lt;p&gt;Intime on lui confie nos secrets, interne pour les collaborateurs de l'entreprise, on le lit, on l'écoute, ou le suit chaque jour .Qui est-il ?&lt;/p&gt;\" title=\"Enigme n°22\" type=\"5\"/><riddle answer=\"pomme\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une pomme.&lt;/p&gt;\" text=\"&lt;p&gt;D'amour, c'est une friandise, on y tombe parfois suite à une émotion forte, qualifie souvent un être niais ou crédule .Qui est-elle ?&lt;/p&gt;\" title=\"Enigme n°23\" type=\"5\"/><riddle answer=\"temoignage|preuve|serment\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un témoignage.&lt;/p&gt;&lt;p&gt;Une preuve est également acceptée.&lt;/p&gt;\" text=\"&lt;p&gt;Déposition officielle effectuée à la barre, dans le cadre d'un procès. Il est parfois d'amitié&lt;/p&gt;\" title=\"Enigme n°24\" type=\"5\"/><riddle answer=\"vaisseau|vaisso\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un vaisseau.&lt;/p&gt;\" text=\"&lt;p&gt;Je vogue sur les mers et océans. Je parcours le corps humain. Je suis...&lt;/p&gt;\" title=\"Enigme n°25\" type=\"5\"/><riddle answer=\"querelle|guerre\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une querelle.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'elle soit de famille ou d'idée, il ne faut jamais la provoquer. Car si chacun peut la chercher, nul ne sait comment l'arrêter.&lt;/p&gt;\" title=\"Enigme n°26\" type=\"5\"/><riddle answer=\"voute\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une voûte.&lt;/p&gt;\" text=\"&lt;p&gt;En berceau ou surbaissée, celle du ciel n'est pas celle du palais&lt;/p&gt;\" title=\"Enigme n°27\" type=\"5\"/><riddle answer=\"baba\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Baba.&lt;/p&gt;\" text=\"&lt;p&gt;Pâtisserie ou déesse. Etonné, on y reste!&lt;/p&gt;\" title=\"Enigme n°28\" type=\"5\"/><riddle answer=\"souris\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une souris.&lt;/p&gt;\" text=\"&lt;p&gt;Souvent utilisée en laboratoire, son trou est vraiment très petit. Celle de l'ordinateur, bien que rapide, est manuelle.&lt;/p&gt;\" title=\"Enigme n°29\" type=\"5\"/><riddle answer=\"regle\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une règle.&lt;/p&gt;\" text=\"&lt;p&gt;Autrefois, le maître en frappait le cancre, qui la redoutait. Utilisée par le dessinateur. Elle doit être suivie par les joueurs.&lt;/p&gt;\" title=\"Enigme n°30\" type=\"5\"/><riddle answer=\"hache\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une hache.&lt;/p&gt;\" text=\"&lt;p&gt;Instrument du bourreau, elle accompagnait le billot. Si on ne la laisse point en terre, on se prépare à la guerre.&lt;/p&gt;\" title=\"Enigme n°31\" type=\"5\"/><riddle answer=\"laine\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La laine.&lt;/p&gt;\" text=\"&lt;p&gt;Née d'un lapin ou d'un agneau, elle tient toujours chaud. Qu'elle soit brute ou peignée, elle peut venir des Pyrénées.&lt;/p&gt;\" title=\"Enigme n°32\" type=\"5\"/><riddle answer=\"balle|ballon\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une balle.&lt;/p&gt;\" text=\"&lt;p&gt;Quand on joue, il faut la rattraper. Quand on la tire, il faut l'éviter.&lt;/p&gt;\" title=\"Enigme n°33\" type=\"5\"/><riddle answer=\"zero|doigt\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un doigt.&lt;br/&gt;Zéro est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Il est le point de départ, sans mener nulle part. Terreur de l'écolier, surtout s'il est pointé.&lt;/p&gt;\" title=\"Enigme n°34\" type=\"5\"/><riddle answer=\"champignon|lampe|manteau|perroquet\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un champignon.&lt;/p&gt;&lt;p&gt;Une lampe, un perroquet et un porte manteau sont égalements acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Je porte un chapeau mais je n'ai pas de tête. J'ai un pied, mais je ne porte pas de chaussure. Je suis...&lt;/p&gt;\" title=\"Enigme n°35\" type=\"5\"/><riddle answer=\"ame\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;L'âme.&lt;/p&gt;\" text=\"&lt;p&gt;Elle communique les vibrations, qui font chanter le violon. On la cherche par amour, mais on doit la rendre un jour.&lt;/p&gt;\" title=\"Enigme n°36\" type=\"5\"/><riddle answer=\"jardin\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un jardin.&lt;/p&gt;\" text=\"&lt;p&gt;Grâce à lui, on peut se nourrir. On peut le fleurir aussi. Public, à tous il est ouvert. Secret, il l'est pour ceux qui aiment se taire.&lt;/p&gt;\" title=\"Enigme n°37\" type=\"5\"/><riddle answer=\"labyrinthe\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un labyrinthe.&lt;/p&gt;\" text=\"&lt;p&gt;Celui de la cathédrale de Chartres est vraiment fameux. On n'en sort jamais sans mal, mais pour les enfants, c'est un jeu.&lt;/p&gt;\" title=\"Enigme n°38\" type=\"5\"/><riddle answer=\"elastique\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un élastique.&lt;/p&gt;\" text=\"&lt;p&gt;Il fait sauter les courageux, et tomber les chaussettes quand il est lâche. Arme des potaches, des petites filles, il tient les cheveux.&lt;/p&gt;\" title=\"Enigme n°39\" type=\"5\"/><riddle answer=\"formule\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une formule.&lt;/p&gt;\" text=\"&lt;p&gt;De politesse, elle est conforme à l'usage. Au restaurant, elle est du jour. Elle est magique ou algébrique.&lt;/p&gt;\" title=\"Enigme n°40\" type=\"5\"/><riddle answer=\"baiser\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un baiser.&lt;/p&gt;\" text=\"&lt;p&gt;Signe habituel de réconciliation. Pour Judas il fut signe de trahison. On le donne, on le reçoit, on le rend.&lt;/p&gt;\" title=\"Enigme n°41\" type=\"5\"/><riddle answer=\"velour\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Du velours.&lt;/p&gt;\" text=\"&lt;p&gt;Malgré sa douceur, sa patte n'est pas sans douleur. Jouer dessus est assurance d'être vainqueur.&lt;/p&gt;\" title=\"Enigme n°42\" type=\"5\"/><riddle answer=\"timbre|avocat\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un timbre.&lt;/p&gt;&lt;p&gt;Un avocat est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Son droit est bien lucratif et présente divers tarifs. Il voyage à travers le monde entier et peut s'échanger sur les marchés.&lt;/p&gt;\" title=\"Enigme n°43\" type=\"5\"/><riddle answer=\"agenda|journal|calendrier\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un agenda.&lt;/p&gt;&lt;p&gt;Un journal intime est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Du début au bout de l'an, on le garnit de l'histoire de notre vie. Affaires, amours, jours et nuits, tout s'y inscrit précisément.&lt;/p&gt;\" title=\"Enigme n°44\" type=\"5\"/><riddle answer=\"miroir\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un miroir.&lt;/p&gt;\" text=\"&lt;p&gt;S'il vous voit vieillir, sans jamais rien vous dire, c'est parce qu'il est poli. Alors réfléchissez, dites-moi de qui il s'agit.&lt;/p&gt;\" title=\"Enigme n°45\" type=\"5\"/><riddle answer=\"centre\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un centre.&lt;/p&gt;\" text=\"&lt;p&gt;C'est une région française. La ville a le sien. Commercial, on y fait ses achats.Et d'accueil, il nous informe.&lt;/p&gt;\" title=\"Enigme n°46\" type=\"5\"/><riddle answer=\"coucou\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un coucou.&lt;/p&gt;\" text=\"&lt;p&gt;Vieux zinc tout bricolé. Ou oiseau de grande ponctualité. C'est aussi une façon de se héler.&lt;/p&gt;\" title=\"Enigme n°47\" type=\"5\"/><riddle answer=\"passe\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le passé.&lt;/p&gt;\" text=\"&lt;p&gt;Il est hier, simple ou composé et peut remonter à l'Antiquité. Car sans lui, demain ne signifie rien.&lt;/p&gt;\" title=\"Enigme n°48\" type=\"5\"/><riddle answer=\"signature\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une signature.&lt;/p&gt;\" text=\"&lt;p&gt;Chacun a la sienne que nul ne doit copier, car l'imiter peut nous faire emprisonner. Fameuse et attestée, elle est collectionnée. Et pourtant, une simple croix peut la remplacer.&lt;/p&gt;\" title=\"Enigme n°49\" type=\"5\"/><riddle answer=\"coin|trou|terrier\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un coin.&lt;/p&gt;&lt;p&gt;Un trou et un terrier sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Tranquille quand on y habite. Il nous arrive même d'en boucher un.&lt;/p&gt;\" title=\"Enigme n°50\" type=\"5\"/><riddle answer=\"verite\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La vérité.&lt;/p&gt;\" text=\"&lt;p&gt;Dans une formule consacrée, par une cour est exigée. À quelqu'un peut-être assénée. Si par quatre est multipliée.&lt;/p&gt;\" title=\"Enigme n°51\" type=\"5\"/><riddle answer=\"canon\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un canon.&lt;/p&gt;\" text=\"&lt;p&gt;Chanson dans laquelle les voix se répètent les unes derrière les autres. Pièce d'artillerie militaire, tube d'une arme à feu&lt;/p&gt;\" title=\"Enigme n°52\" type=\"5\"/><riddle answer=\"sirene|courant\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une sirène.&lt;/p&gt;\" text=\"&lt;p&gt;Jadis redoutée par les marins. Aujourd'hui, appréciée par les terriens. Vous voici prévenus!&lt;/p&gt;\" title=\"Enigme n°53\" type=\"5\"/><riddle answer=\"conservation|survie\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La conservation.&lt;/p&gt;&lt;p&gt;La survie est également acceptée.&lt;/p&gt;\" text=\"&lt;p&gt;Menacé, son instinct nous pousse. On veille à celle des documents ; Elle a ses méthodes et ses moyens.&lt;/p&gt;\" title=\"Enigme n°54\" type=\"5\"/><riddle answer=\"passion\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La passion.&lt;/p&gt;\" text=\"&lt;p&gt;Amoureuse elle peut être violente. Fruit il nous ravit. Selon Matthieu elle nous ferait aimer Bach&lt;/p&gt;\" title=\"Enigme n°55\" type=\"5\"/><riddle answer=\"messe\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La messe.&lt;/p&gt;\" text=\"&lt;p&gt;À minuit on la célèbre. Dite! il est trop tard pour se plaindre. Basse! elle ne fait rien pour qu'on l entende&lt;/p&gt;\" title=\"Enigme n°56\" type=\"5\"/><riddle answer=\"credit\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un crédit.&lt;/p&gt;\" text=\"&lt;p&gt;On en use pour persuader. En accorder c'est faire confiance. Une simple signature suffit pour sa carte.&lt;/p&gt;\" title=\"Enigme n°57\" type=\"5\"/><riddle answer=\"cote\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Les côtes.&lt;/p&gt;\" text=\"&lt;p&gt;Elles font le tour des continents. On les gravit difficilement. Lorsqu'on se les tient, c'est que l'on rit beaucoup.&lt;/p&gt;\" title=\"Enigme n°58\" type=\"5\"/><riddle answer=\"nuage\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Les nuages.&lt;/p&gt;\" text=\"&lt;p&gt;Qu'il soit noir, gris ou bien blanc, il n'y en a pas deux semblables. Il suit le souffle du vent et reste pour nous impalpable&lt;/p&gt;\" title=\"Enigme n°59\" type=\"5\"/><riddle answer=\"fusil\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un fusil.&lt;/p&gt;\" text=\"&lt;p&gt;Dans la cuisine je suis apprécié. Dans la nature, redouté. Mon épaule le porte, mais si je change de côté...d'avis également j'aurais changé!&lt;/p&gt;\" title=\"Enigme n°60\" type=\"5\"/><riddle answer=\"sol|truite|scie|ton|thon\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La sole (La note Sol).&lt;/p&gt;&lt;p&gt;La truite (de Schubert), le ton (thon) et la scie sont également acceptées.&lt;/p&gt;\" text=\"&lt;p&gt;Lorsque l'on parle de ce poisson, on pourrait penser que l'on parle de musique.&lt;/p&gt;&lt;p&gt;Proposé par Mélanie.&lt;/p&gt;\" title=\"Enigme n°61\" type=\"5\"/><riddle answer=\"lit\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le lit.&lt;/p&gt;\" text=\"&lt;p&gt;La rivière travaille chaque jour à le creuser, tandis que nous aimons nous y reposer...&lt;/p&gt;\" title=\"Enigme n°62\" type=\"5\"/><riddle answer=\"fou\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le fou.&lt;/p&gt;\" text=\"&lt;p&gt;Bien que généralement amusant pour mon roi, j'ai bien aussi parfois perdu la tête. Plus que le rire, il nous fait pleurer...&lt;/p&gt;\" title=\"Enigme n°63\" type=\"5\"/><riddle answer=\"frisson\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un frisson.&lt;/p&gt;\" text=\"&lt;p&gt;L'émotion parfois nous le fait ressentir. Le froid parfois de lui nous en fait parcourir. Seul l'amour nous fait vivre le grand!&lt;/p&gt;\" title=\"Enigme n°64\" type=\"5\"/><riddle answer=\"etoile\" answer_type=\"1\" copyright=\"Proposée par Julien.\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une étoile.&lt;/p&gt;\" text=\"&lt;p&gt;On me voit mais on ne peut me toucher. Alors même que je n'existe plus on peut me voir. Le berger a la sienne.&lt;/p&gt;\" title=\"Enigme n°65\" type=\"5\"/><riddle answer=\"noir|obscurite|brouillard|desert|ocean|reve\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Dans le noir. L'obscurité, le désert, le rêve, l'océan et le brouillard sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Quand on y est, on ne sait où on est mais on ne voit que ça.&lt;/p&gt;\" title=\"Enigme n°66\" type=\"5\"/><riddle answer=\"chemin|exempl\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le chemin.&lt;/p&gt;&lt;p&gt;L'exemple est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Le montrer c'est bien le connaitre.&lt;/p&gt;\" title=\"Enigme n°67\" type=\"5\"/><riddle answer=\"coche\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le coche.&lt;/p&gt;\" text=\"&lt;p&gt;Quand il est traité, on le remarque. Il arrive que l'on me rate. J. de la Fontaine m'y associa une mouche&lt;/p&gt;\" title=\"Enigme n°68\" type=\"5\"/><riddle answer=\"fibre\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La fibre.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis à la fois maternelle et paternelle. Quand je suis nerveuse, je n'en suis pas excitée pour autant. Au chemin de la selle, parfois je contribue&lt;/p&gt;\" title=\"Enigme n°69\" type=\"5\"/><riddle answer=\"matelas|coussin|chambre\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un matelas.&lt;/p&gt;&lt;p&gt;Un coussin et une chambre sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;D'air, je sais isoler. Pneumatique cela n'est pas pour autant que je roule. Quand le sommeil gagne je suis le bienvenu.&lt;/p&gt;\" title=\"Enigme n°70\" type=\"5\"/><riddle answer=\"patte\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une patte.&lt;/p&gt;\" text=\"&lt;p&gt;Quand je suis longue je suis favori. D'éléphant me fait une belle jambe. A quatre, je n'en suis pas plus rapide!&lt;/p&gt;\" title=\"Enigme n°71\" type=\"5\"/><riddle answer=\"pensee|pense\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;pensée&lt;/p&gt;\" text=\"&lt;p&gt;Unique, je domine! A ma façon est le reflet de mon opinion. Mais c'est fleurie que j'exprime toute ma grâce.&lt;/p&gt;\" title=\"Enigme n°72\" type=\"5\"/><riddle answer=\"blanc\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le blanc.&lt;/p&gt;\" text=\"&lt;p&gt;Au féminin l'écrivain me redoute. Peu coloré je peux apporter l'ivresse.&lt;/p&gt;\" title=\"Enigme n°73\" type=\"5\"/><riddle answer=\"ram|bit\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La rame&lt;/p&gt;&lt;p&gt;Bit(te) est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Entre votre ordinateur et un bateau, le point commun je suis. A 512 nous en formons une!&lt;/p&gt;\" title=\"Enigme n°74\" type=\"5\"/><riddle answer=\"terrain\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le terrain.&lt;/p&gt;\" text=\"&lt;p&gt;Il m'arrive d'être glissant! Mais de sport je retrouve mon adhérence. Accidenté je deviens un tout!&lt;/p&gt;\" title=\"Enigme n°75\" type=\"5\"/><riddle answer=\"merlan\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un merlan.&lt;/p&gt;\" text=\"&lt;p&gt;Y aller est comme aller chez le coiffeur! Mon regard parfois déroute. Sorti de l'eau je deviens succulent&lt;/p&gt;\" title=\"Enigme n°76\" type=\"5\"/><riddle answer=\"grain\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Au grain.&lt;/p&gt;\" text=\"&lt;p&gt;En étant sur ses gardes, on y veille!&lt;/p&gt;\" title=\"Enigme n°77\" type=\"5\"/><riddle answer=\"parole\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La parole.&lt;/p&gt;\" text=\"&lt;p&gt;En l'air, je suis légère! Quand je promets on me trouve belle. Face au silence je suis d'argent!&lt;/p&gt;\" title=\"Enigme n°78\" type=\"5\"/><riddle answer=\"ciel|temps\" answer_type=\"3\" copyright=\"Proposée par Robs.\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le ciel ou le temps.&lt;/p&gt;\" text=\"&lt;p&gt;Tout le temps jugé sur mon apparence, jamais je ne me vexe. Que suis-je ?&lt;/p&gt;\" title=\"Enigme n°79\" type=\"5\"/><riddle answer=\"ronde\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une ronde.&lt;/p&gt;\" text=\"&lt;p&gt;Mon indice a son chemin. Parfois, le gardien doit en faire une.&lt;/p&gt;\" title=\"Enigme n°80\" type=\"5\"/><riddle answer=\"fou\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un fou.&lt;/p&gt;\" text=\"&lt;p&gt;Sachant voler, je n'en suis pas moins bon nageur. Sur l'échiquier je ne manque pas de raison...&lt;/p&gt;\" title=\"Enigme n°81\" type=\"5\"/><riddle answer=\"herbe|idee|plante|habitude\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;De l'herbe.&lt;/p&gt;&lt;p&gt;L'idée, la plante et l'habitude sont également acceptées.&lt;/p&gt;\" text=\"&lt;p&gt;Mauvaise, on me supprime sans jugement! Bonne, on m'entretient.&lt;/p&gt;\" title=\"Enigme n°82\" type=\"5\"/><riddle answer=\"bois|driver\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un bois, le plus long est le bois n°1 appelé le driver.&lt;/p&gt;\" text=\"&lt;p&gt;Au golf, je permets le plus long coup!&lt;/p&gt;\" title=\"Enigme n°83\" type=\"5\"/><riddle answer=\"genou\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le genou.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis à terre pour le côté solennel.&lt;/p&gt;\" title=\"Enigme n°84\" type=\"5\"/><riddle answer=\"lac\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un lac.&lt;/p&gt;\" text=\"&lt;p&gt;En Amérique il est supérieur.&lt;/p&gt;\" title=\"Enigme n°85\" type=\"5\"/><riddle answer=\"ciel\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le ciel.&lt;/p&gt;\" text=\"&lt;p&gt;Je peux être humide ou pas. Les Hommes prennent plaisir à me regarder. Les gaulois se méfient de moi.&lt;/p&gt;\" title=\"Enigme n°86\" type=\"5\"/><riddle answer=\"m\" answer_type=\"2\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La lettre m.&lt;/p&gt;\" text=\"&lt;p&gt;On me trouve chez les hommes et chez les femmes. L'ennemi n'en a qu'un. Mon inverse est « déteste » (Phonétique).&lt;/p&gt;\" title=\"Enigme n°87\" type=\"5\"/><riddle answer=\"langue\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La langue.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis souvent humide. J'existe en plusieurs versions. Babel est mon &quot;berceau&quot;.&lt;/p&gt;\" title=\"Enigme n°88\" type=\"5\"/><riddle answer=\"lit\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un lit.&lt;/p&gt;\" text=\"&lt;p&gt;Plus étroit chez les célibataires que chez les mariées. Lieu de punition pour certains. Mort, sur moi tu reposes.&lt;/p&gt;\" title=\"Enigme n°89\" type=\"5\"/><riddle answer=\"eponge\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une éponge.&lt;/p&gt;\" text=\"&lt;p&gt;J'absorbe à fort exposant. J'existe aussi pour le corps. On me trouve dans les pièces d'eau&lt;/p&gt;\" title=\"Enigme n°90\" type=\"5\"/><riddle answer=\"ombre\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une ombre.&lt;/p&gt;\" text=\"&lt;p&gt;Je n'existe pas, et pourtant on me nomme. De l'heure dépend mon influence. J'aime à imiter vos pas au gré du soleil.&lt;/p&gt;\" title=\"Enigme n°91\" type=\"5\"/><riddle answer=\"chapeau\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un chapeau.&lt;/p&gt;\" text=\"&lt;p&gt;Quand il est cloche, il ne sonne pas. Il m'arrive que l'on me mange, même si je ne suis pas melon.&lt;/p&gt;\" title=\"Enigme n°92\" type=\"5\"/><riddle answer=\"fille\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une fille.&lt;/p&gt;\" text=\"&lt;p&gt;D'air, je peux partir sans prévenir. De joie, j'offre aux hommes un plaisir intense mais éphémère! De ferme, je suis vouée à servir ces mêmes hommes!&lt;/p&gt;\" title=\"Enigme n°93\" type=\"5\"/><riddle answer=\"moelle\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La moelle.&lt;/p&gt;\" text=\"&lt;p&gt;D'un récit je suis la substance. Bien qu'osseuse, je reste très molle.&lt;/p&gt;\" title=\"Enigme n°94\" type=\"5\"/><riddle answer=\"encre\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;L'encre.&lt;/p&gt;\" text=\"&lt;p&gt;Sympathique, je me révèle mystérieusement!&lt;/p&gt;\" title=\"Enigme n°95\" type=\"5\"/><riddle answer=\"poire\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une poire.&lt;/p&gt;\" text=\"&lt;p&gt;Si l'on dit que j'en suis une bonne, on ne parle pas de blague! On peut abuser de ma crédulité.&lt;/p&gt;\" title=\"Enigme n°96\" type=\"5\"/><riddle answer=\"mousse\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La mousse.&lt;/p&gt;\" text=\"&lt;p&gt;Les poils ne m'aiment pas. Je suis leur mauvais présage. Je suis humide et j'aide au rasage.&lt;/p&gt;\" title=\"Enigme n°97\" type=\"5\"/><riddle answer=\"livre\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un(e) livre.&lt;/p&gt;\" text=\"&lt;p&gt;Anglaise, je change tous les jours! A m'ouvrir, on se cultive.&lt;/p&gt;\" title=\"Enigme n°98\" type=\"5\"/><riddle answer=\"tabac\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le tabac.&lt;/p&gt;\" text=\"&lt;p&gt;D'un océan arrivé, je suis évanescent apprécié. Pour un plaisir partagé, décrié le serais-je ? Quand j'en fais un, ceux qui me voient m'applaudissent.&lt;/p&gt;\" title=\"Enigme n°99\" type=\"5\"/><riddle answer=\"egee\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Egée.&lt;/p&gt;\" text=\"&lt;p&gt;Roi il fut. Du même nom que fut son tombeau. Et pourtant ses flots sereins nous assaillent.&lt;/p&gt;\" title=\"Enigme n°100\" type=\"5\"/><riddle answer=\"coupe\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La coupe.&lt;/p&gt;\" text=\"&lt;p&gt;Sombre, j'éclaircis! Doublé, je ne manque pas de tranchant! A trop me porter aux lèvres, survient l'enivrement!&lt;/p&gt;\" title=\"Enigme n°101\" type=\"5\"/><riddle answer=\"date|langue|blague\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une date.&lt;/p&gt;&lt;p&gt;La langue et une blague sont également acceptées.&lt;/p&gt;\" text=\"&lt;p&gt;Malgré mon goût, je peux être difficile à retenir..&lt;/p&gt;\" title=\"Enigme n°102\" type=\"5\"/><riddle answer=\"croix\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La croix.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis parfois lourde à porter. De lorraine j'ai double traverse. Un chemin pour le croyant!&lt;/p&gt;\" title=\"Enigme n°103\" type=\"5\"/><riddle answer=\"plaque\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Des plaques.&lt;/p&gt;\" text=\"&lt;p&gt;Le dermatologue les soigne, les voitures en ont ainsi que les G.I..&lt;/p&gt;\" title=\"Enigme n°104\" type=\"5\"/><riddle answer=\"regle\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une règle.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis celle qui avec l'aide des trois connus, vous livre l'inconnu! Parfois droite et rectiligne, je gagne aussi à être suivie!&lt;/p&gt;\" title=\"Enigme n°105\" type=\"5\"/><riddle answer=\"brouillard|nuage\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le brouillard.&lt;/p&gt;&lt;p&gt;Un nuage est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Quand on y est, on ne sait où on est. Il n'est fait que d'eau, mais peut devenir un impénétrable rideau.&lt;/p&gt;\" title=\"Enigme n°106\" type=\"5\"/><riddle answer=\"clairon\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le clairon.&lt;/p&gt;\" text=\"&lt;p&gt;Il n'est pas de réveil plus efficace! On m'utilise pour sonner la charge!&lt;/p&gt;\" title=\"Enigme n°107\" type=\"5\"/><riddle answer=\"galette\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La galette.&lt;/p&gt;\" text=\"&lt;p&gt;Royale, elle révèle un secret à se mettre sous la dent! Bretonne, je suis ronde et plate.&lt;/p&gt;\" title=\"Enigme n°108\" type=\"5\"/><riddle answer=\"echo\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;L'écho.&lt;/p&gt;\" text=\"&lt;p&gt;Je réponds toujours quand on m'appelle! Pourtant je n'ai pas d'existence physique.&lt;/p&gt;\" title=\"Enigme n°109\" type=\"5\"/><riddle answer=\"coup|poison\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un coup.&lt;/p&gt;&lt;p&gt;Le poison est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Contre, je soulage! Pourtant plus souvent source de douleurs.&lt;/p&gt;\" title=\"Enigme n°110\" type=\"5\"/><riddle answer=\"circuit|manege|rond|carrefour\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un circuit, un rond-point, un carrefour giratoire ou un manège.&lt;/p&gt;\" text=\"&lt;p&gt;Les autos y tournent en rond!&lt;/p&gt;\" title=\"Enigme n°111\" type=\"5\"/><riddle answer=\"point|facteur|clavier\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un point.&lt;/p&gt;&lt;p&gt;Un facteur d'orgue et un clavier sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;D'orgue, il n'est pas forcement musical!&lt;/p&gt;\" title=\"Enigme n°112\" type=\"5\"/><riddle answer=\"these|universit|facult\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une thèse.&lt;/p&gt;&lt;p&gt;Université et faculté sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Sans elle, impossible d'être docteur, quel que soit le domaine.&lt;/p&gt;\" title=\"Enigme n°113\" type=\"5\"/><riddle answer=\"main|fil\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La main.&lt;/p&gt;&lt;p&gt;Le fil est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Quand on me perd, tout est à refaire! Ses coups peuvent parfois être bien bénéfiques!&lt;/p&gt;\" title=\"Enigme n°114\" type=\"5\"/><riddle answer=\"maille|ete\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une maille.&lt;/p&gt;&lt;p&gt;L'été est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;A l'endroit et ou à l'envers, chaud sera le résultat.&lt;/p&gt;\" title=\"Enigme n°115\" type=\"5\"/><riddle answer=\"rose\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le rose.&lt;/p&gt;\" text=\"&lt;p&gt;Bonbon, il peut être de très mauvais gout.&lt;/p&gt;\" title=\"Enigme n°116\" type=\"5\"/><riddle answer=\"tapis\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un tapis.&lt;/p&gt;\" text=\"&lt;p&gt;Si l'on me déroule, c'est pour l'honneur!&lt;/p&gt;\" title=\"Enigme n°117\" type=\"5\"/><riddle answer=\"telephon|sonnet\" answer_type=\"3\" copyright=\"Proposée par Thomas.\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un téléphone.&lt;/p&gt;&lt;p&gt;Une sonnette est également acceptée.&lt;/p&gt;\" text=\"&lt;p&gt;J'existe pour qu'on me réponde, mais je ne pose pas de questions. Que suis-je ?&lt;/p&gt;\" title=\"Enigme n°118\" type=\"5\"/><riddle answer=\"route\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La route.&lt;/p&gt;\" text=\"&lt;p&gt;Pressé, je la taille!&lt;/p&gt;\" title=\"Enigme n°119\" type=\"5\"/><riddle answer=\"rond\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un rond.&lt;/p&gt;\" text=\"&lt;p&gt;Quand on me double, j'exprime une certaine monotonie. Dans l'eau, j'aime à me déplacer en me multipliant!&lt;/p&gt;\" title=\"Enigme n°120\" type=\"5\"/><riddle answer=\"index\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;L'index.&lt;/p&gt;\" text=\"&lt;p&gt;D'ici, je suis le fil d'Ariane! Bien qu'important, je ne suis pas majeur !&lt;/p&gt;\" title=\"Enigme n°121\" type=\"5\"/><riddle answer=\"pas|pied\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un pas.&lt;/p&gt;&lt;p&gt;Les pieds sont aussi acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Petits ou grands font avancer!&lt;/p&gt;\" title=\"Enigme n°122\" type=\"5\"/><riddle answer=\"crosse\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une crosse.&lt;/p&gt;\" text=\"&lt;p&gt;Il vous est préférable de ne pas trop les chercher, car a les trouver vous risquez bien des ennuis! Religieuse je suis pastorale.&lt;/p&gt;\" title=\"Enigme n°123\" type=\"5\"/><riddle answer=\"passe\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une passe.&lt;/p&gt;\" text=\"&lt;p&gt;Impair, j'ai la même valeur! Certains hôtels y ont leurs étoiles! Doublé je suis un tour!&lt;/p&gt;\" title=\"Enigme n°124\" type=\"5\"/><riddle answer=\"fil\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le fil.&lt;/p&gt;\" text=\"&lt;p&gt;Rouge, on me suit. Je peux couper certains aliments.&lt;/p&gt;\" title=\"Enigme n°125\" type=\"5\"/><riddle answer=\"luxe\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le luxe.&lt;/p&gt;\" text=\"&lt;p&gt;Raffiné, je suis couteux! Quand c'est le minimum, je n'en suis pas! J'ai mes boutiques, mais que dans certaines rues.&lt;/p&gt;\" title=\"Enigme n°126\" type=\"5\"/><riddle answer=\"classe|maniere|gout|elegance\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La classe.&lt;/p&gt;&lt;p&gt;Les manières et le goût sont égalements acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;En avoir est révélateur d'un certain raffinement!&lt;/p&gt;\" title=\"Enigme n°127\" type=\"5\"/><riddle answer=\"aimant\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Des aimants.&lt;/p&gt;\" text=\"&lt;p&gt;On dit qu'ils se ressemblent, pourtant ils s'assemblent et se repoussent parfois!&lt;/p&gt;\" title=\"Enigme n°128\" type=\"5\"/><riddle answer=\"vent\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le vent.&lt;/p&gt;\" text=\"&lt;p&gt;Quand je suis bon je débarrasse. Je peux aussi être solaire ou glacial.&lt;/p&gt;\" title=\"Enigme n°129\" type=\"5\"/><riddle answer=\"lit\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Des lits.&lt;/p&gt;\" text=\"&lt;p&gt;Jumeaux, nous sommes toujours l'un à côté de l'autre, et nous pouvons accueillir en nous d'autres jumeaux.&lt;/p&gt;\" title=\"Enigme n°130\" type=\"5\"/><riddle answer=\"note\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une note.&lt;/p&gt;\" text=\"&lt;p&gt;Souvent brève, je vais à l'essentiel. Mais sans racisme, blanche, je vaux bien deux noires.&lt;/p&gt;\" title=\"Enigme n°131\" type=\"5\"/><riddle answer=\"voile\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une voile.&lt;/p&gt;\" text=\"&lt;p&gt;Amie du vent, je fais avancer les choses.&lt;/p&gt;\" title=\"Enigme n°132\" type=\"5\"/><riddle answer=\"histoire\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;L'histoire.&lt;/p&gt;\" text=\"&lt;p&gt;Petite, je suis parfois coquine! Naturelle, je montre mon savoir.&lt;/p&gt;\" title=\"Enigme n°133\" type=\"5\"/><riddle answer=\"noce\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une noce.&lt;/p&gt;&lt;p&gt;L'expression &lt;i&gt;&quot;Il n'a jamais été à pareille noce&quot;&lt;/i&gt; n'est plus tellement utilisé (être à la fête).&lt;/p&gt;\" text=\"&lt;p&gt;Ne pas y être est parfois très gênant. Le temps passant, on m'affuble de noms charmants!&lt;/p&gt;\" title=\"Enigme n°134\" type=\"5\"/><riddle answer=\"faim\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La faim.&lt;/p&gt;\" text=\"&lt;p&gt;Par le loup souvent on l'évoque! Elle est bien trop présente dans le monde.&lt;/p&gt;\" title=\"Enigme n°135\" type=\"5\"/><riddle answer=\"arbre|cimetiere|photo|tombe|caveau\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un arbre.&lt;/p&gt;&lt;p&gt;Un cimetière, un caveau, une tombe et une photo sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;On peut y retrouver les membres de sa famille. Je change peu d'apparence au fil de l'année.&lt;/p&gt;\" title=\"Enigme n°136\" type=\"5\"/><riddle answer=\"nez\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le nez.&lt;/p&gt;\" text=\"&lt;p&gt;Parfois comparé à une trompette, je suis visible au milieu.&lt;/p&gt;\" title=\"Enigme n°137\" type=\"5\"/><riddle answer=\"table\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Les tables.&lt;/p&gt;\" text=\"&lt;p&gt;Par la justice elles sont appliquées! Pour les promeneurs, elles aident à se repérer.&lt;/p&gt;\" title=\"Enigme n°138\" type=\"5\"/><riddle answer=\"araigne\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une araignée.&lt;/p&gt;\" text=\"&lt;p&gt;Chagrine le matin, je remonte l'espoir le soir.&lt;/p&gt;\" title=\"Enigme n°139\" type=\"5\"/><riddle answer=\"humour|veuve\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;L'humour.&lt;/p&gt;&#10;&lt;p&gt;La veuve est également acceptée&lt;/p&gt;\" text=\"&lt;p&gt;Noir, je suis souvent cruel, mais pas pour tout le monde!&lt;/p&gt;\" title=\"Enigme n°140\" type=\"5\"/><riddle answer=\"plaque\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une plaque.&lt;/p&gt;\" text=\"&lt;p&gt;Quand je suis rouge, attention danger! Être à côté d'elle me fait manquer le but.&lt;/p&gt;\" title=\"Enigme n°141\" type=\"5\"/><riddle answer=\"orient\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;L'orient&lt;/p&gt;\" text=\"&lt;p&gt;A l'est toujours on me trouve! Sans les enfiler, je donne de la couleur aux perles. Sans être apostrophé, je deviens un port! Il m'arrive d'être express!&lt;/p&gt;\" title=\"Enigme n°142\" type=\"5\"/><riddle answer=\"lettre\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une lettre.&lt;/p&gt;\" text=\"&lt;p&gt;Quand nous sommes 5, nous manquons de délicatesse, voire de politesse! Ainsi qualifié, hommes ou femmes montrent une certaine culture...! Recommandée je suis souvent porteuse de mauvaises nouvelles.&lt;/p&gt;\" title=\"Enigme n°143\" type=\"5\"/><riddle answer=\"chemin|nez|mot|tronc\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un chemin.&lt;/p&gt;&lt;p&gt;Le nez, un tronc et un mot sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Je peux être creux, de travers, court ou long.&lt;/p&gt;&lt;p&gt;Proposé par Chaignedid.&lt;/p&gt;\" title=\"Enigme n°144\" type=\"5\"/><riddle answer=\"conscience|foi|intuition|raison\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une conscience.&lt;/p&gt;&lt;p&gt;La foi, la raison et l'intuition sont également acceptées.&lt;/p&gt;\" text=\"&lt;p&gt;Tout le monde en a une, bonne ou mauvaise. Parfois elle peut même dicter nos pas.&lt;/p&gt;\" title=\"Enigme n°145\" type=\"5\"/><riddle answer=\"feuille\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une feuille.&lt;/p&gt;\" text=\"&lt;p&gt;Je change de couleur au fur et a mesure des saisons, et finis par tomber.&lt;/p&gt;\" title=\"Enigme n°146\" type=\"5\"/><riddle answer=\"lanterne\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une lanterne.&lt;/p&gt;\" text=\"&lt;p&gt;Parfois gibet, mais toujours magique!&lt;/p&gt;\" title=\"Enigme n°147\" type=\"5\"/><riddle answer=\"salle\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une salle.&lt;/p&gt;\" text=\"&lt;p&gt;Obscure, on reste malgré tout assis devant tant de lumière! Obscure, mais je vous fais mon cinéma!&lt;/p&gt;\" title=\"Enigme n°148\" type=\"5\"/><riddle answer=\"sable\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Du sable.&lt;/p&gt;\" text=\"&lt;p&gt;Parfois dans les bacs, je ne suis pas pour autant musical! M'acheter endort les enfants.&lt;/p&gt;\" title=\"Enigme n°149\" type=\"5\"/><riddle answer=\"pierre\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une pierre.&lt;/p&gt;\" text=\"&lt;p&gt;Dure, parfois polie, mais souvent sans cœur!&lt;/p&gt;\" title=\"Enigme n°150\" type=\"5\"/><riddle answer=\"forme|mouche\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Les formes.&lt;/p&gt;&lt;p&gt;La mouche est également acceptée.&lt;/p&gt;\" text=\"&lt;p&gt;Les mettre évite de blesser. Et parfois il faut aussi en dessiner.&lt;/p&gt;\" title=\"Enigme n°151\" type=\"5\"/><riddle answer=\"page|feuille\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La page ou une feuille.&lt;/p&gt;\" text=\"&lt;p&gt;Blanche, je reste vierge!&lt;/p&gt;&lt;p&gt;Pourtant je suis la hantise de l'écrivain.&lt;/p&gt;\" title=\"Enigme n°152\" type=\"5\"/><riddle answer=\"greve\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La grève.&lt;/p&gt;\" text=\"&lt;p&gt;Le long de la rivière, je coule des jours paisibles. Quand on me fait, c'est signe d'un certain mécontentement !&lt;/p&gt;\" title=\"Enigme n°153\" type=\"5\"/><riddle answer=\"vert\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La couleur verte.&lt;/p&gt;\" text=\"&lt;p&gt;Rage, parfois, je complète. Symbole de la jeunesse, de la chance et du hasard, je suis. Sans moi la vie et la nature seraient bien différentes.&lt;/p&gt;&lt;p&gt;Proposé par Chaignedid.&lt;/p&gt;&lt;p&gt;Proposé par Jimmy.&lt;/p&gt;\" title=\"Enigme n°154\" type=\"5\"/><riddle answer=\"petit\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Petit.&lt;/p&gt;\" text=\"&lt;p&gt;Doublé, je progresse lentement! Doublé, j'appelle et regroupe! Quand je me fais ainsi je cherche à passer inaperçu!&lt;/p&gt;\" title=\"Enigme n°155\" type=\"5\"/><riddle answer=\"araigne\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une araignée.&lt;/p&gt;\" text=\"&lt;p&gt;J'ai des pattes, je sais sauter de feuille en feuille et je sais tisser...&lt;/p&gt;\" title=\"Enigme n°156\" type=\"5\"/><riddle answer=\"fourmi\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;fourmi&lt;/p&gt;\" text=\"&lt;p&gt;Je peux me glisser partout. Je peux parfois voler ou dévorer.&lt;/p&gt;\" title=\"Enigme n°157\" type=\"5\"/><riddle answer=\"prix\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le prix&lt;/p&gt;\" text=\"&lt;p&gt;Grand, on me considère comme un sport! Je peux être aussi une récompense!&lt;/p&gt;\" title=\"Enigme n°158\" type=\"5\"/><riddle answer=\"boucle\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une boucle&lt;/p&gt;\" text=\"&lt;p&gt;Tourner ainsi me fait toujours revenir sur mes pas! A l'oreille je suis essentiellement féminine!&lt;/p&gt;\" title=\"Enigme n°159\" type=\"5\"/><riddle answer=\"tete\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une tête&lt;/p&gt;\" text=\"&lt;p&gt;Blonde, j'ai un petit côté enfantin parfois !&lt;/p&gt;\" title=\"Enigme n°160\" type=\"5\"/><riddle answer=\"larme\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une larme.&lt;/p&gt;\" text=\"&lt;p&gt;Chaude, je suis abondante. A l'œil, je révèle toute l'émotion !&lt;/p&gt;\" title=\"Enigme n°161\" type=\"5\"/><riddle answer=\"mouche\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une mouche.&lt;/p&gt;\" text=\"&lt;p&gt;Peut être utilisée à la pêche. Une fois sur soi, agaçante elle est.&lt;/p&gt;\" title=\"Enigme n°162\" type=\"5\"/><riddle answer=\"vert\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Vert.&lt;/p&gt;\" text=\"&lt;p&gt;Tendre, parfois je suis! L'être encore à un certain âge est preuve de vitalité.&lt;/p&gt;\" title=\"Enigme n°163\" type=\"5\"/><riddle answer=\"secret|espion\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le secret.&lt;/p&gt;&lt;p&gt;Un espion est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Professionnel, je me dois d'être particulièrement discret !&lt;/p&gt;\" title=\"Enigme n°164\" type=\"5\"/><riddle answer=\"livret|arbre\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un livret.&lt;/p&gt;&lt;p&gt;L'arbre généalogique est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Pour la famille, j'en suis l'histoire.&lt;/p&gt;\" title=\"Enigme n°165\" type=\"5\"/><riddle answer=\"pupille\" answer_type=\"1\" copyright=\"Proposée par Léa.\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une pupille.&lt;/p&gt;\" text=\"&lt;p&gt;Petite au soleil, je m'épaissis à l'ombre. Mais je reste toujours très sombre.&lt;/p&gt;\" title=\"Enigme n°166\" type=\"5\"/><riddle answer=\"cravate\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une cravate.&lt;/p&gt;\" text=\"&lt;p&gt;Notariale, je ne suis pas un artifice vestimentaire, dans ce cas là!&lt;/p&gt;\" title=\"Enigme n°167\" type=\"5\"/><riddle answer=\"phare|fare|fard\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le phare.&lt;/p&gt;\" text=\"&lt;p&gt;Parfois guide, je peux changer le regard des femmes.&lt;/p&gt;\" title=\"Enigme n°168\" type=\"5\"/><riddle answer=\"bar\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un bar.&lt;/p&gt;\" text=\"&lt;p&gt;Dans les eaux, je me trouve. On m'y trouve si j'ai de graves soucis personnels. Epuisé, je peux l'avoir. J'exprime volontiers une certaine pression !&lt;/p&gt;\" title=\"Enigme n°169\" type=\"5\"/><riddle answer=\"contre\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Contre.&lt;/p&gt;\" text=\"&lt;p&gt;Même haut, avec moi je suis encore supérieur! Même bas, avec moi je suis encore inferieur! Associé au jour, je suis opposé à la lumière. Associé au temps, cela met en retard !&lt;/p&gt;\" title=\"Enigme n°170\" type=\"5\"/><riddle answer=\"bois\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Bois.&lt;/p&gt;\" text=\"&lt;p&gt;Haut, je suis à vent!&lt;/p&gt;\" title=\"Enigme n°171\" type=\"5\"/><riddle answer=\"bourse\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La bourse.&lt;/p&gt;\" text=\"&lt;p&gt;Autrefois, à la garder je risquais de perdre la vie.&lt;/p&gt;\" title=\"Enigme n°172\" type=\"5\"/><riddle answer=\"mot\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Les mots.&lt;/p&gt;\" text=\"&lt;p&gt;Jouer avec, c'est les rendre équivoques!&lt;/p&gt;\" title=\"Enigme n°173\" type=\"5\"/><riddle answer=\"mire|train|front|tir\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La mire.&lt;/p&gt;&lt;p&gt;Un train, ligne de tir et le front sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;Se trouver sur ma ligne peut se révéler dangereux !&lt;/p&gt;\" title=\"Enigme n°174\" type=\"5\"/><riddle answer=\"mirage\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un mirage.&lt;/p&gt;\" text=\"&lt;p&gt;Je peux être tout autant rapide, que trompeur, mais dans ce cas nous ne nous ressemblons pas!&lt;/p&gt;\" title=\"Enigme n°175\" type=\"5\"/><riddle answer=\"carton\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un carton.&lt;/p&gt;\" text=\"&lt;p&gt;Je peux être jaune ou rouge, ondulé ou droit.&lt;/p&gt;\" title=\"Enigme n°176\" type=\"5\"/><riddle answer=\"bougie\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une bougie.&lt;/p&gt;\" text=\"&lt;p&gt;Pour moi, on vend aussi la mèche. J'en fais voir de toutes les couleurs. J'ai mon utilité dans un moteur.&lt;/p&gt;\" title=\"Enigme n°177\" type=\"5\"/><riddle answer=\"ancre\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une ancre.&lt;/p&gt;\" text=\"&lt;p&gt;Fixée, une fois que je suis immergée.&lt;/p&gt;\" title=\"Enigme n°178\" type=\"5\"/><riddle answer=\"echelle\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une échelle.&lt;/p&gt;\" text=\"&lt;p&gt;A l'élévation je suis destinée. Mes dessous parfois effraient. De l'événement je suis l'étalon. Courte, je peux aussi être double.&lt;/p&gt;\" title=\"Enigme n°179\" type=\"5\"/><riddle answer=\"fuite\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La fuite.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis l'essence du temps. Les vieux en ont aussi parfois. Les malfrats me prennent souvent.&lt;/p&gt;\" title=\"Enigme n°180\" type=\"5\"/><riddle answer=\"goutte\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La goutte.&lt;/p&gt;\" text=\"&lt;p&gt;Peut suffir à enivrer! Terriblement douloureuse sous ma forme médicale. Petit à petit, je nourris ou soigne !&lt;/p&gt;\" title=\"Enigme n°181\" type=\"5\"/><riddle answer=\"index\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;L'index.&lt;/p&gt;\" text=\"&lt;p&gt;Bien que pas majeur, j'ai un certain doigté !&lt;/p&gt;\" title=\"Enigme n°182\" type=\"5\"/><riddle answer=\"pile\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Les piles.&lt;/p&gt;\" text=\"&lt;p&gt;Celles du pont ne manquent pas de charge !&lt;/p&gt;\" title=\"Enigme n°183\" type=\"5\"/><riddle answer=\"culot\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le culot.&lt;/p&gt;\" text=\"&lt;p&gt;Essentiel à une bonne pipe, il faut parfois oser.&lt;/p&gt;\" title=\"Enigme n°184\" type=\"5\"/><riddle answer=\"herbe\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;L'herbe.&lt;/p&gt;\" text=\"&lt;p&gt;Fine, mon goût n'a d'égal que mon odeur ! Mauvaise, je suis nuisible parait-il.&lt;/p&gt;\" title=\"Enigme n°185\" type=\"5\"/><riddle answer=\"assiette\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;L'assiette.&lt;/p&gt;\" text=\"&lt;p&gt;A cheval ou en avion, je suis garante de votre équilibre!&lt;/p&gt;\" title=\"Enigme n°186\" type=\"5\"/><riddle answer=\"bombe|charge\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une bombe.&lt;/p&gt;&lt;p&gt;Une charge est également acceptée.&lt;/p&gt;\" text=\"&lt;p&gt;A cheval, je ne suis pas explosive!&lt;/p&gt;\" title=\"Enigme n°187\" type=\"5\"/><riddle answer=\"cimeter\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un cimeterre.&lt;/p&gt;\" text=\"&lt;p&gt;Un i me sépare de la maison des morts.&lt;/p&gt;\" title=\"Enigme n°188\" type=\"5\"/><riddle answer=\"bois\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le bois.&lt;/p&gt;\" text=\"&lt;p&gt;En hiver, utile et obligatoire je suis. En orfèvrerie, je peux être d'âme.&lt;/p&gt;\" title=\"Enigme n°189\" type=\"5\"/><riddle answer=\"vierge\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Vierge.&lt;/p&gt;\" text=\"&lt;p&gt;Pour l'huile, je suis garante de sa qualité !&lt;/p&gt;\" title=\"Enigme n°190\" type=\"5\"/><riddle answer=\"marteau\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un marteau.&lt;/p&gt;\" text=\"&lt;p&gt;Un requin peut nous y faire penser tout comme une enclume.&lt;/p&gt;\" title=\"Enigme n°191\" type=\"5\"/><riddle answer=\"poche\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une poche&lt;/p&gt;\" text=\"&lt;p&gt;Celle d'argent, ne permet pas d'être très dépensier. Sous les yeux, montre une grande fatigue !&lt;/p&gt;\" title=\"Enigme n°192\" type=\"5\"/><riddle answer=\"none|nonne\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;None&lt;/p&gt;\" text=\"&lt;p&gt;On m'annonce lorsque le soleil quitte son zénith. Une lettre inaudible de plus, et voilà que mon mariage devient platonique. A plusieurs, les romains nous plaçaient en 5e ou 7e position.&lt;/p&gt;\" title=\"Enigme n°193\" type=\"5\"/><riddle answer=\"musique|danse\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La musique.&lt;/p&gt;&lt;p&gt;La danse est également acceptée.&lt;/p&gt;\" text=\"&lt;p&gt;Classique, elle est paradoxalement très diversifiée !&lt;/p&gt;\" title=\"Enigme n°194\" type=\"5\"/><riddle answer=\"ange\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un ange.&lt;/p&gt;\" text=\"&lt;p&gt;On fait silence quand je passe.&lt;/p&gt;\" title=\"Enigme n°195\" type=\"5\"/><riddle answer=\"timbre\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un timbre.&lt;/p&gt;\" text=\"&lt;p&gt;Celui de la voix, n'a nul besoin d'être collé!&lt;/p&gt;\" title=\"Enigme n°196\" type=\"5\"/><riddle answer=\"gouttiere\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une gouttière.&lt;/p&gt;\" text=\"&lt;p&gt;Peu flatteur pour un chat, elle dirige un élément.&lt;/p&gt;\" title=\"Enigme n°197\" type=\"5\"/><riddle answer=\"aiguille\" answer_type=\"1\" copyright=\"Proposée par Clémence.\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Les aiguilles.&lt;/p&gt;\" text=\"&lt;p&gt;Nous sommes deux sœurs qui travaillons jour et nuit sans jamais nous arrêter sous peine de perdre le sens de leurs vies.&lt;/p&gt;&lt;p&gt;Qui sommes-nous ?&lt;/p&gt;\" title=\"Enigme n°198\" type=\"5\"/><riddle answer=\"grace\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La grâce.&lt;/p&gt;\" text=\"&lt;p&gt;C'est un état éphémère, pour politiciens!&lt;/p&gt;\" title=\"Enigme n°199\" type=\"5\"/><riddle answer=\"image\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une image.&lt;/p&gt;\" text=\"&lt;p&gt;On me considère comme un modèle de sagesse. D'Epinal, elle est le lieu commun.&lt;/p&gt;\" title=\"Enigme n°200\" type=\"5\"/><riddle answer=\"sirene\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une sirène.&lt;/p&gt;\" text=\"&lt;p&gt;Seule la cire peut vous garder de moi. Ma voix en a détourné plus d'un.&lt;/p&gt;\" title=\"Enigme n°201\" type=\"5\"/><riddle answer=\"station\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une station.&lt;/p&gt;\" text=\"&lt;p&gt;En toute saison, je peux y être blanche, je suis appréciée sans jeu de mot, je rends service lorsque j'y vais, je paye beaucoup de taxes usées, les eaux y vont.&lt;/p&gt;\" title=\"Enigme n°202\" type=\"5\"/><riddle answer=\"identite\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;L'identité.&lt;/p&gt;\" text=\"&lt;p&gt;En principe, je suis fondamentale! Carte, avec moi on ne joue pas !&lt;/p&gt;\" title=\"Enigme n°203\" type=\"5\"/><riddle answer=\"œil|oeil\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un oeil.&lt;/p&gt;\" text=\"&lt;p&gt;Celui du bœuf nous éclaire!&lt;/p&gt;\" title=\"Enigme n°204\" type=\"5\"/><riddle answer=\"etoile\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une étoile.&lt;/p&gt;\" text=\"&lt;p&gt;Aussi à l'aise dans l'eau que dans le ciel. Danseuse, je peux également briller!&lt;/p&gt;\" title=\"Enigme n°205\" type=\"5\"/><riddle answer=\"mine\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La mine.&lt;/p&gt;\" text=\"&lt;p&gt;Quand je suis petite, on s'en inquiète. Certains y descendent.&lt;/p&gt;\" title=\"Enigme n°206\" type=\"5\"/><riddle answer=\"probleme\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un problème.&lt;/p&gt;\" text=\"&lt;p&gt;On ne m'apprécie ni petit, ni grand. Je peux mener à la calvitie. On m'efface avec une solution.&lt;/p&gt;\" title=\"Enigme n°207\" type=\"5\"/><riddle answer=\"lame\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une lame.&lt;/p&gt;\" text=\"&lt;p&gt;Fine, méfiez vous de mes bottes !&lt;/p&gt;\" title=\"Enigme n°208\" type=\"5\"/><riddle answer=\"bureau\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un bureau.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis chez chacun d'entre vous. Passer sous moi n'attire point de gloire. Certaines personnes s'y rendent les jours de travail.&lt;/p&gt;\" title=\"Enigme n°209\" type=\"5\"/><riddle answer=\"fuseau\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un fuseau.&lt;/p&gt;\" text=\"&lt;p&gt;Pour être deux, la cellule en a besoin. Dès 76, Fleming en proposa pour chaque partie du monde. Un danseur ne s'en sépare jamais lorsqu'il est sur scène. Sur le globe, je sers de frontière entre deux horaires&lt;/p&gt;\" title=\"Enigme n°210\" type=\"5\"/><riddle answer=\"bleu\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Bleu.&lt;/p&gt;\" text=\"&lt;p&gt;Roi, je suis républicain! A ne voir que moi, on ne voit rien! A l'âme, je suis blessure!&lt;/p&gt;\" title=\"Enigme n°211\" type=\"5\"/><riddle answer=\"pot\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un pot.&lt;/p&gt;\" text=\"&lt;p&gt;Quand je suis fleuri, je fâche. Alcoolisé, on m'accepte à ses risques et périls. Mis au feu, je deviens comestible.&lt;/p&gt;\" title=\"Enigme n°212\" type=\"5\"/><riddle answer=\"cercle\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un cercle.&lt;/p&gt;\" text=\"&lt;p&gt;En étant le premier, je suis tout proche du pouvoir! Pour certain poètes disparus, je fus refuge...!&lt;/p&gt;\" title=\"Enigme n°213\" type=\"5\"/><riddle answer=\"ver\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un ver&lt;/p&gt;\" text=\"&lt;p&gt;Ma production plait aux femmes. A la solitude et au confinement je suis voué.&lt;/p&gt;\" title=\"Enigme n°214\" type=\"5\"/><riddle answer=\"mal\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le mal.&lt;/p&gt;\" text=\"&lt;p&gt;Celui du siècle, dans la jeunesse fut romantique! Mon esprit est assurément malin! Armé, je suis un poète.&lt;/p&gt;\" title=\"Enigme n°215\" type=\"5\"/><riddle answer=\"train\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un train.&lt;/p&gt;\" text=\"&lt;p&gt;Doublé! Je suis fort ennuyeux. Celui de sénateur, n'est pas réputé rapide!&lt;/p&gt;\" title=\"Enigme n°216\" type=\"5\"/><riddle answer=\"parole\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La parole.&lt;/p&gt;\" text=\"&lt;p&gt;Belle, je suis prometteuse. En avoir qu'une est signe d'honnêteté.&lt;/p&gt;\" title=\"Enigme n°217\" type=\"5\"/><riddle answer=\"crise\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une crise.&lt;/p&gt;\" text=\"&lt;p&gt;De jalousie, je suis laide.&lt;/p&gt;\" title=\"Enigme n°218\" type=\"5\"/><riddle answer=\"sang\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le sang.&lt;/p&gt;\" text=\"&lt;p&gt;Chaud, il m'emporte facilement. Froid, il signe l'indifférence. Sa couleur peut faire d'un homme... un Roi&lt;/p&gt;\" title=\"Enigme n°219\" type=\"5\"/><riddle answer=\"lune\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La lune.&lt;/p&gt;\" text=\"&lt;p&gt;Jadis j'étais vénérée par les hommes. J'exerce mon pouvoir sur eux... tout comme sur les eaux. Seuls les loups me restent fidèles et chantent pour moi.&lt;/p&gt;\" title=\"Enigme n°220\" type=\"5\"/><riddle answer=\"ciel\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un arc-en-ciel.&lt;/p&gt;\" text=\"&lt;p&gt;Né d'un mariage coloré. Par l'eau, ma mère, je suis né. Quand père lumière l'a fécondée. Trésors divins gisent à mes pieds.&lt;/p&gt;\" title=\"Enigme n°221\" type=\"5\"/><riddle answer=\"fleuve|ruisseau|riviere\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un fleuve.&lt;/p&gt;\" text=\"&lt;p&gt;Je coule de source et je finis salé.&lt;/p&gt;\" title=\"Enigme n°222\" type=\"5\"/><riddle answer=\"sourir\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un sourire.&lt;/p&gt;\" text=\"&lt;p&gt;Je ne coûte rien mais je vaux de l'or quand on me voit.&lt;/p&gt;\" title=\"Enigme n°223\" type=\"5\"/><riddle answer=\"boule\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La boule.&lt;/p&gt;\" text=\"&lt;p&gt;A me perdre, on ne s'y retrouve plus! Si vous m'y mettez, méfiez vous de mon courroux!&lt;/p&gt;\" title=\"Enigme n°224\" type=\"5\"/><riddle answer=\"lunette\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une lunette.&lt;/p&gt;\" text=\"&lt;p&gt;En architecture, j'aide la principale. En plomberie, je conforte le passant. En astronomie, je permets de voir grand.&lt;/p&gt;\" title=\"Enigme n°225\" type=\"5\"/><riddle answer=\"grain\" answer_type=\"1\" copyright=\"Proposée par Marion.\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un grain.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis le blé et le sel de la terre. Je suis aussi poussière, à la folie je prétends. Je décompte le temps. Qui suis-je ?&lt;/p&gt;\" title=\"Enigme n°226\" type=\"5\"/><riddle answer=\"place\" answer_type=\"1\" copyright=\"Proposée par Abdelhamid.\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La place.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis grande, remplie d'espace et je remplis l'espace. Si tu me prends je disparais.&lt;/p&gt;\" title=\"Enigme n°227\" type=\"5\"/><riddle answer=\"ombre\" answer_type=\"1\" copyright=\"Proposée par Samuel.\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une ombre.&lt;/p&gt;\" text=\"&lt;p&gt;Je peux être portée ou chinoise. Le matin j'apparais, le soir je disparais.&lt;/p&gt;\" title=\"Enigme n°228\" type=\"5\"/><riddle answer=\"cle\" answer_type=\"1\" copyright=\"Proposée par Stef.\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La clé.&lt;/p&gt;\" text=\"&lt;p&gt;Mécanique ou électronique. Sans elle personne, ne rentre chez soi. L'agent de securité et le mécanicien en utilise.&lt;/p&gt;\" title=\"Enigme n°229\" type=\"5\"/><riddle answer=\"vent\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le vent.&lt;/p&gt;\" text=\"&lt;p&gt;Me prendre est faire preuve d'opportunisme! Insaisissable, quand je suis présent les gens me ressentent.&lt;/p&gt;\" title=\"Enigme n°230\" type=\"5\"/><riddle answer=\"sens\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le sens.&lt;/p&gt;\" text=\"&lt;p&gt;Unique, son opposé est interdit.&lt;/p&gt;\" title=\"Enigme n°231\" type=\"5\"/><riddle answer=\"pain\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le pain.&lt;/p&gt;\" text=\"&lt;p&gt;Français, blanc ou noir, j'alimente votre quotidien!&lt;/p&gt;\" title=\"Enigme n°232\" type=\"5\"/><riddle answer=\"vue\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La vue.&lt;/p&gt;\" text=\"&lt;p&gt;Y naviguer, c'est risquer de se perdre! Longue, je peux vous aider à vous y retrouver!&lt;/p&gt;\" title=\"Enigme n°233\" type=\"5\"/><riddle answer=\"fin\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La fin.&lt;/p&gt;\" text=\"&lt;p&gt;Engendrée par le début et dans la logique des choses.&lt;/p&gt;\" title=\"Enigme n°234\" type=\"5\"/><riddle answer=\"temps|coeur|cœur|pied\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le temps.&lt;/p&gt;&lt;p&gt;Coeur et pied sont également acceptés.&lt;/p&gt;\" text=\"&lt;p&gt;A ne pas le prendre, on risque de le perdre!&lt;/p&gt;\" title=\"Enigme n°235\" type=\"5\"/><riddle answer=\"main\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La main.&lt;/p&gt;\" text=\"&lt;p&gt;Quand je suis forte on me prête volontiers.&lt;/p&gt;\" title=\"Enigme n°236\" type=\"5\"/><riddle answer=\"garde\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;La garde.&lt;/p&gt;\" text=\"&lt;p&gt;Vieille, je fais preuve d'une grande fidélité. Un tel chien peut être dangereux.&lt;/p&gt;\" title=\"Enigme n°237\" type=\"5\"/><riddle answer=\"cage\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une cage.&lt;/p&gt;\" text=\"&lt;p&gt;Roi ou oiseau, j'y tourne.&lt;/p&gt;\" title=\"Enigme n°238\" type=\"5\"/><riddle answer=\"jeu\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le jeu.&lt;/p&gt;\" text=\"&lt;p&gt;En avoir, est révélateur d'une légère usure! Ceux de l'amour, sont parfois liés au hasard!&lt;/p&gt;\" title=\"Enigme n°239\" type=\"5\"/><riddle answer=\"mot\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un mot.&lt;/p&gt;\" text=\"&lt;p&gt;Gros, je manque de délicatesse et de savoir vivre ! Doux, je peux faire plaisir.&lt;/p&gt;\" title=\"Enigme n°240\" type=\"5\"/><riddle answer=\"or\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;L'or.&lt;/p&gt;\" text=\"&lt;p&gt;D'un roi, je fis le malheur. Je suis parfois lié au silence.&lt;/p&gt;\" title=\"Enigme n°241\" type=\"5\"/><riddle answer=\"dictionnaire\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le dictionnaire.&lt;/p&gt;\" text=\"&lt;p&gt;Dans le doute on me consulte car je ne peux me tromper. Je peux être petit, en couleur ou propre, et chaque année je connais de nouveaux changements.&lt;/p&gt;\" title=\"Enigme n°242\" type=\"5\"/><riddle answer=\"balai\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un balai.&lt;/p&gt;\" text=\"&lt;p&gt;Une sorcière l'utilise pour se déplacer.&lt;/p&gt;\" title=\"Enigme n°243\" type=\"5\"/><riddle answer=\"creneau|cheval\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un créneau.&lt;/p&gt;&lt;p&gt;Un cheval est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;On y monte pour protester, mais en faire un peut être difficile.&lt;/p&gt;\" title=\"Enigme n°244\" type=\"5\"/><riddle answer=\"cigarette\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Une cigarette.&lt;/p&gt;\" text=\"&lt;p&gt;Grillée, je ne suis pas au goût de tous... Pour d'autres, par contre, je fais un tabac! Abuser de moi c'est la peine de mort!&lt;/p&gt;\" title=\"Enigme n°245\" type=\"5\"/><riddle answer=\"corps\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Le corps.&lt;/p&gt;\" text=\"&lt;p&gt;Lorsque je suis perdu on ne me ménage pas. Mon esprit est synonyme de solidarité de groupe.&lt;/p&gt;\" title=\"Enigme n°246\" type=\"5\"/><riddle answer=\"filet|contrat\" answer_type=\"3\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un filet.&lt;/p&gt;&lt;p&gt;Un contrat est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;A travailler sans, on prend grand risque !&lt;/p&gt;\" title=\"Enigme n°247\" type=\"5\"/><riddle answer=\"ensemble\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un ensemble.&lt;/p&gt;\" text=\"&lt;p&gt;Fini, je suis entier et naturel. Mathématiquement je ne suis qu'une théorie !&lt;/p&gt;\" title=\"Enigme n°248\" type=\"5\"/><riddle answer=\"moulin\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un moulin.&lt;/p&gt;\" text=\"&lt;p&gt;Au café, je suis très utile. Ceux à parole finissent par être inaudibles.&lt;/p&gt;\" title=\"Enigme n°249\" type=\"5\"/><riddle answer=\"galopin\" answer_type=\"1\" copyright=\"\" hint=\"\" image=\"\" solution=\"&lt;p&gt;Un galopin.&lt;/p&gt;\" text=\"&lt;p&gt;Le passer, c'est renoncer! Je suis au demi, ce qu'une fillette est à la bouteille!&lt;/p&gt;\" title=\"Enigme n°250\" type=\"5\"/><riddle answer=\"lapin\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Mes grandes oreilles.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le lapin.&lt;/p&gt;&lt;p&gt;On le trouve souvent dans la section volaille des livres de cuisine car il est traditionnellement élevé en basse-cour.&lt;/p&gt;\" text=\"&lt;p&gt;Volaille en cuisine, je n'ai pourtant rien d'un volatile.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"L'incompris\" type=\"6\"/><riddle answer=\"pie\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Un oiseau noir et blanc&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La pie.&lt;/p&gt;&lt;p&gt;Les anciens costumes était appelés &quot;Queue de pie&quot;.&lt;/p&gt;\" text=\"&lt;p&gt;Voleuse ou bavarde, ma queue a inspiré les hommes pour leurs costumes.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Dans mon garage\" type=\"6\"/><riddle answer=\"serpen|crotal\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Long et dangereux&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un serpent.&lt;/p&gt;&lt;p&gt;Le crotale est plus communément appelé &quot;serpent à sonnette&quot;.&lt;/p&gt;\" text=\"&lt;p&gt;Lorsque l'on m'entend sonner, mieux vaut ne pas aller répondre. Très peu me considèrent de bonne compagnie.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Brrrr\" type=\"6\"/><riddle answer=\"manchot|pinguin\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Sur la banquise.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un manchot.&lt;/p&gt;\" text=\"&lt;p&gt;Je n'ai jamais les mains dans les poches mais on m'attribue un empire.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Symbole\" type=\"6\"/><riddle answer=\"ornithorynqu|ornitorinqu|ornithorin|ornytori\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;En tasmanie.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un ornithorynque.&lt;/p&gt;\" text=\"&lt;p&gt;Etrange par mes attributs, vivant sur terre et dans l'eau, je suis un des rares mammifères à pondre des œufs.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Changeforme\" type=\"6\"/><riddle answer=\"hippocampe|hyppocampe|hipocampe|hypocampe\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Cheval de mer.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un hippocampe (le cheval de mer).&lt;/p&gt;\" text=\"&lt;p&gt;Cheval se déplaçant à la verticale, c'est mon mari qui porte nos enfants.&lt;/p&gt;&lt;p&gt;Qui suis-je ?&lt;/p&gt;\" title=\"Canasson\" type=\"6\"/><riddle answer=\"chauve|souris|chiroptera\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Vampire.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une chauve-souris&lt;/p&gt;\" text=\"&lt;p&gt;Volant la nuit, je ne suis pourtant pas un oiseau.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Piou piou\" type=\"6\"/><riddle answer=\"coucou\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;2 syllabes identiques.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un coucou.&lt;/p&gt;\" text=\"&lt;p&gt;Je peux donner l'heure, mais je suis aussi une façon de saluer.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Tic-Tac\" type=\"6\"/><riddle answer=\"dodo\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;2 syllabes identiques.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un dodo.&lt;/p&gt;\" text=\"&lt;p&gt;Éteint, je réapparais quand les enfants ont sommeil.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Disparu\" type=\"6\"/><riddle answer=\"mante|mantis|mente|menthe\" answer_type=\"3\" copyright=\"\" hint=\"&lt;p&gt;Un sirop vert.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;La mante religieuse.&lt;/p&gt;\" text=\"&lt;p&gt;N'ayant aucune croyance malgré mon nom, je suis difficile à discerner dans les herbes.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Caché\" type=\"6\"/><riddle answer=\"taurau|toro|torau|taureau\" answer_type=\"3\" copyright=\"Proposée par Cloé.\" hint=\"&lt;p&gt;Bovin.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un taureau.&lt;/p&gt;\" text=\"&lt;p&gt;Célèbre dans le monde de l'astrologie, je ne discerne pas les couleurs contrairement à une idée reçue.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Riz\" type=\"6\"/><riddle answer=\"cheval\" answer_type=\"1\" copyright=\"Proposée par Maelaïg.\" hint=\"&lt;p&gt;Fidèle destrier&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un cheval.&lt;/p&gt;\" text=\"&lt;p&gt;Au temps des romains, Caligula m'a attribué un empire. J'ai 4 jambes et j'ai connu les indiens.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Mon royaume\" type=\"6\"/><riddle answer=\"coccin\" answer_type=\"1\" copyright=\"Proposée par Cloé.\" hint=\"&lt;p&gt;Rouge et noir&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une coccinelle.&lt;/p&gt;\" text=\"&lt;p&gt;Surnommé &quot;La bête à bon dieu&quot;, mes noirceurs n'indiquent pas mon âge contrairement à ce que les enfants pensent.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Petites pattes\" type=\"6\"/><riddle answer=\"cobay|inde|cochon\" answer_type=\"3\" copyright=\"Proposée par Dex.\" hint=\"&lt;p&gt;Présent dans les idées reçues.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Le cobaye (ou cochon d'Inde).&lt;/p&gt;\" text=\"&lt;p&gt;Mon nom peut faire croire que je viens de loin, je préfère la compagnie aux expériences.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Compagnie\" type=\"6\"/><riddle answer=\"canar\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Donald.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un canard.&lt;/p&gt;&lt;p&gt;Souvent représenté en jaune, le bleu canard et un froid de canard.&lt;/p&gt;\" text=\"&lt;p&gt;Souvent représenté jaune mais connu pour son bleu, on parle de moi quand il fait froid.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Jaune\" type=\"6\"/><riddle answer=\"couleuv\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Un serpent.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Une couleuvre.&lt;/p&gt;\" text=\"&lt;p&gt;Désagréable quand on m'avale, je suis inoffensif malgré mon apparence.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Le long\" type=\"6\"/><riddle answer=\"coq\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Fais la poule.&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un coq.&lt;/p&gt;&lt;p&gt;Coq en pâte et passer du coq à l'ane.&lt;/p&gt;\" text=\"&lt;p&gt;Recouvert de pâte, je change d'avis quand je vais sur l'âne.&lt;/p&gt;&lt;p&gt;Que suis-je ?&lt;/p&gt;\" title=\"Matinal\" type=\"6\"/><riddle answer=\"kaki|kiwi\" answer_type=\"3\" copyright=\"Proposée par Thefox\" hint=\"&lt;p&gt;Couleur également&lt;/p&gt;\" image=\"\" solution=\"&lt;p&gt;Un kaki.&lt;/p&gt;&#10;&lt;p&gt;Le kiwi est également accepté.&lt;/p&gt;\" text=\"&lt;p&gt;Je suis à la fois un fruit et un volatile. J'ai des ailes mais je ne peux pas voler.&lt;/p&gt;&lt;p&gt;Que suis-je?&lt;/p&gt;\" title=\"Sur des échasses\" type=\"6\"/><riddle answer=\"citron\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;Combien de tronc ?&lt;/p&gt;\" image=\"db_citron\" solution=\"&lt;p&gt;Citron&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Des troncs\" type=\"7\"/><riddle answer=\"grand\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;Un grand ?&lt;/p&gt;\" image=\"db_grandcru\" solution=\"&lt;p&gt;Un grand cru.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Qui l'eût cru ?\" type=\"7\"/><riddle answer=\"contre\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Dans le sens contraire.&lt;/p&gt;\" image=\"db_acontrecourant\" solution=\"&lt;p&gt;A contre courant.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Au courant\" type=\"7\"/><riddle answer=\"air\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Respirez.&lt;/p&gt;\" image=\"db_airdularge\" solution=\"&lt;p&gt;L'air du large.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Largesse\" type=\"7\"/><riddle answer=\"ouvert|tout\" answer_type=\"3\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Fermé.&lt;/p&gt;\" image=\"db_cestouvert\" solution=\"&lt;p&gt;C'est ouvert.&lt;/p&gt;&lt;p&gt;&quot;C'est tout&quot; est également accepté.\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Où ça ?\" type=\"7\"/><riddle answer=\"couvert\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Cadeau de mariage.&lt;/p&gt;\" image=\"db_couvertenargent\" solution=\"&lt;p&gt;Des couverts en argent.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Le coût\" type=\"7\"/><riddle answer=\"renverse\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Un déssert.&lt;/p&gt;\" image=\"db_cremerenversee\" solution=\"&lt;p&gt;Une crème renversée.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Crémeux\" type=\"7\"/><riddle answer=\"noir|blanc\" answer_type=\"3\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Charlie Chaplin.&lt;/p&gt;\" image=\"db_filmnb\" solution=\"&lt;p&gt;Un film noir et blanc.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Souriez\" type=\"7\"/><riddle answer=\"oreil\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Dodo.&lt;/p&gt;\" image=\"db_oreiller\" solution=\"&lt;p&gt;Un oreiller.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Oh oh oh\" type=\"7\"/><riddle answer=\"tous|sens\" answer_type=\"3\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Une vraie girouette.&lt;/p&gt;\" image=\"db_partirsens\" solution=\"&lt;p&gt;Partir dans tous les sens.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Là bas\" type=\"7\"/><riddle answer=\"petit|rat\" answer_type=\"3\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Ils dansent.&lt;/p&gt;\" image=\"db_ratdopera\" solution=\"&lt;p&gt;Un petit rat d'opéra.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Garnier\" type=\"7\"/><riddle answer=\"surprise\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Je le savais.&lt;/p&gt;\" image=\"db_sanssurprise\" solution=\"&lt;p&gt;Sans surprise.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Division\" type=\"7\"/><riddle answer=\"sourici|souriss\" answer_type=\"3\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Attraper un petit animal.&lt;/p&gt;\" image=\"db_souriciere\" solution=\"&lt;p&gt;Une souricière.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Pilaf\" type=\"7\"/><riddle answer=\"trou\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;J'ai oublié.&lt;/p&gt;\" image=\"db_troudememoire\" solution=\"&lt;p&gt;Trou de mémoire.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Mémoire\" type=\"7\"/><riddle answer=\"rouge\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Etre en colère.&lt;/p&gt;\" image=\"db_voirrouge\" solution=\"&lt;p&gt;Voir rouge.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Voir et revoir\" type=\"7\"/><riddle answer=\"soupir\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Pfff.&lt;/p&gt;\" image=\"db_soupirer\" solution=\"&lt;p&gt;Soupirer.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Pi ?\" type=\"7\"/><riddle answer=\"miami\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Floride.&lt;/p&gt;\" image=\"db_miami\" solution=\"&lt;p&gt;Miami.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Où ça ?\" type=\"7\"/><riddle answer=\"croise\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Chassé en croix ?&lt;/p&gt;\" image=\"db_chasse\" solution=\"&lt;p&gt;Chassé-croisé.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Chasseur\" type=\"7\"/><riddle answer=\"circulaire\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Ca coupe.&lt;/p&gt;\" image=\"db_scie\" solution=\"&lt;p&gt;Scie circulaire.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"En rond\" type=\"7\"/><riddle answer=\"lever\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Mettre en évidence.&lt;/p&gt;\" image=\"db_doute\" solution=\"&lt;p&gt;Lever un doute.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Douteux\" type=\"7\"/><riddle answer=\"debout\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Quand on est très fatigué.&lt;/p&gt;\" image=\"db_dormir\" solution=\"&lt;p&gt;Dormir debout.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Sommeil\" type=\"7\"/><riddle answer=\"faim\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Quand on a très faim.&lt;/p&gt;\" image=\"db_loup\" solution=\"&lt;p&gt;Une faim de loup.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Houp\" type=\"7\"/><riddle answer=\"bleu\" answer_type=\"3\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;D'une certain couleur.&lt;/p&gt;\" image=\"db_fleur\" solution=\"&lt;p&gt;Fleur bleue.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Jolie\" type=\"7\"/><riddle answer=\"brouill\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Pour pas se faire suivre.&lt;/p&gt;\" image=\"db_pistes\" solution=\"&lt;p&gt;Brouiller les pistes.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Pisté\" type=\"7\"/><riddle answer=\"comprim\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;R = air.&lt;/p&gt;\" image=\"db_carabine\" solution=\"&lt;p&gt;Carabine à air comprimé.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Attention\" type=\"7\"/><riddle answer=\"envers\" answer_type=\"1\" copyright=\"Proposée par Marine.\" hint=\"&lt;p&gt;Retourné.&lt;/p&gt;\" image=\"db_monde\" solution=\"&lt;p&gt;Le monde à l'envers.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Mon monde\" type=\"7\"/><riddle answer=\"ecologi\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Green peace.&lt;/p&gt;\" image=\"db_ecologie\" solution=\"&lt;p&gt;Ecologie.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Tous concernés\" type=\"7\"/><riddle answer=\"ligne\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Au plus loin.&lt;/p&gt;\" image=\"db_horizon\" solution=\"&lt;p&gt;Ligne d'horizon.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Horizontal\" type=\"7\"/><riddle answer=\"couch\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Avant la nuit.&lt;/p&gt;\" image=\"db_couche\" solution=\"&lt;p&gt;Le couché de soleil.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Rayon de lumière\" type=\"7\"/><riddle answer=\"vaut|coup\" answer_type=\"3\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Avant la nuit.&lt;/p&gt;\" image=\"db_cavaut\" solution=\"&lt;p&gt;Ca vaut le coup.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Egalité\" type=\"7\"/><riddle answer=\"belier\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Signe astrologique.&lt;/p&gt;\" image=\"db_beliers\" solution=\"&lt;p&gt;Des béliers&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Alphabet\" type=\"7\"/><riddle answer=\"droit\" answer_type=\"1\" copyright=\"©D/ PICON - Retrouvez des dingbats sur &lt;a href=&quot;http://1000.dingbats.overblog.com&quot;&gt;1000.dingbats.overblog.com.\" hint=\"&lt;p&gt;Il a le droit.&lt;/p&gt;\" image=\"db_droit\" solution=\"&lt;p&gt;Le droit de regard.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Ka\" type=\"7\"/><riddle answer=\"que\" answer_type=\"1\" copyright=\"Proposée par Silvaine.\" hint=\"&lt;p&gt;Pas si grave.&lt;/p&gt;\" image=\"db_peur\" solution=\"&lt;p&gt;Plus de peur que de mal.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Fear\" type=\"7\"/><riddle answer=\"coin\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Mesquin.&lt;/p&gt;\" image=\"db_sourire\" solution=\"&lt;p&gt;Sourire en coin.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Sourire\" type=\"7\"/><riddle answer=\"lait\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Susceptible&lt;/p&gt;\" image=\"db_soupe\" solution=\"&lt;p&gt;Soupe au lait&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Souper\" type=\"7\"/><riddle answer=\"rond\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Perte de temps.&lt;/p&gt;\" image=\"db_tourner\" solution=\"&lt;p&gt;Tourner en rond&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Cercle\" type=\"7\"/><riddle answer=\"grand\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;S'énerver&lt;/p&gt;\" image=\"db_monter\" solution=\"&lt;p&gt;Monter sur ses grands chevaux.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Un cheval, des ...\" type=\"7\"/><riddle answer=\"jaune\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Faux rire&lt;/p&gt;\" image=\"db_rire\" solution=\"&lt;p&gt;Rire jaune.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Amusant ?\" type=\"7\"/><riddle answer=\"blanche\" answer_type=\"1\" copyright=\"\" hint=\"&lt;p&gt;Couteau.&lt;/p&gt;\" image=\"db_arme\" solution=\"&lt;p&gt;Arme blanche.&lt;/p&gt;\" text=\"&lt;p&gt;Quel mot ou expression se cache derrière cette image ?&lt;/p&gt;\" title=\"Guerre\" type=\"7\"/></riddleslist>";
