$(document).bind("mobileinit", function () {
    $.mobile.pushStateEnabled = true;
});

$(function () {
    
    var App = {
        configUrl: "http://lfpdata.static.interactivecdn.com.s3.amazonaws.com/data/config_firefox_v1.json",
        filePath: "http://lfpdata.static.interactivecdn.com.s3.amazonaws.com/data/",
        config: null,
        ligaBbvaId: 1,
        goals: null,
        news: null,
        images: null,
        currentCompetitionId: 0,
        currentRoundId: 0,
        dictionaryMatches: {},
        dictionaryTeamMatches: {},
        imagesDetail: null,
        round_selected: 0,
        loadMatchDetail: null,
        matchDetailSection: "",
        urlParams: null,
        item: null,
        matchDetailSectionIni: null
    };

    var days = ['Domingo','Lunes','Martes','Miércoles','Jueves','Viernes','Sábado'];
    var days_en = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
    var isFirstLoad = true;

    /* Init app */
    getRequestUrl(App.configUrl, function(data){
        if(data != null) {
            //Load config LFP
            App.config = data;
            //Load competition selector
            loadCompetitionSelector();
            App.currentCompetitionId = App.config.competitions[0].id;
            //Load active rounds
            loadCurrentDataFromCompetition();
            
            $('a#matchesSelectorCompetitionsBtn').addClass('ui-btn-active');
        }

    });


    var l = function (string) {
        return string.toLocaleString();
    }


    var loadCurrentDataFromCompetition = function() {
        loadRounds(function(isLoaded){
            //Load matches
            if(isLoaded) {
                loadMatches(App.currentCompetitionId, App.currentRoundId);
                loadClassification();
            }  
        });

    }

    var loadCompetitionSelector = function(){
        $('#select-custom-competition option').remove();
        $.each(App.config.competitions, function(key, value) {
            if(document.webL10n.getLanguage().contains('en') && key == 5){
                var competition_item = "<option value='" + key + "' data-image='images/competitions/logo_" + value.slug + "_en@2x.png'></option>";    
            } else {
                var competition_item = "<option value='" + key + "' data-image='images/competitions/logo_" + value.slug + "@2x.png'></option>";
            }
            var li_competition_id = "<li data-option-index='" + key + "' data-icon='false' class='ui-first-child' role='option' aria-selected='true'><a competition_id='" + value.id + "' href='#'' tabindex='-1' class='ui-btn ui-btn-active'></a></li>";
            $('#select-custom-competition').append(competition_item);
            $("#select-custom-competition-menu").append(li_competition_id)
        });

        var opts = $("#select-custom-competition option");
        $( "#select-custom-competition-listbox-popup" ).on( "popupafteropen", function( event, ui ) {
            $("#select-custom-competition-menu li").each(function(index){
                if ($(this).find("img").length == 0){
                    var imageURL = opts.eq(index).data("image");
                    var imgElem = '<img src=' + imageURL + '  />';
                    $(this).find("a").prepend(imgElem);
                }
            });
        });
        $('#select-custom-competition-menu a.ui-btn').click(function(event){
            var image = $('img', $(this)).attr('src');
            $('#select-custom-competition-button').html("<img src='" + image + "' />");
            App.currentCompetitionId = $(this).attr('competition_id');
            loadCurrentDataFromCompetition();
            App.round_selected = 0;
            if (App.currentCompetitionId == "6") {
                $('#owl-rounds').hide();
            } else if ($('a#matchesSelectorCompetitionsBtn').hasClass('ui-btn-active')){
                $('#owl-rounds').show();
            }
        });
        $('#select-custom-competition-button span').html("<img src='images/competitions/logo_" + App.config.competitions[0].slug + "@2x.png' />");
    }



    $("#ligaadelante").hide();

    $('#bbvaSelectorTeamBtn').click(function(){
    	bbvaClick();
        enableSelector($(this));
    });

    $('#adelanteSelectorTeamBtn').click(function(){
    	adelanteClick();
        enableSelector($(this)); 
    });

    function enableSelector(selectorItem) {
       $('#bbvaSelectorTeamBtn, #adelanteSelectorTeamBtn').removeClass('ui-state-persist');
        selectorItem.addClass('ui-state-persist'); 
    }

	function bbvaClick(){
		$("#ligabbva").show();
		$("#ligaadelante").hide();
	}
	
	function adelanteClick(){
		$("#ligaadelante").show();
		$("#ligabbva").hide();
	}

    $('#btn_refresh_competitions').click(function(){
        loadCurrentDataFromCompetition();
    });

    $('#btn_refresh_pronosticos').click(function(){
        loadPronosticos();
    });

    $('#btn_refresh_news').click(function(){
        loadNews();
    });

    $('#btn_refresh_goals').click(function(){
        loadGoals();
    });

    $('#btn_refresh_teams').click(function(){
        loadTeams();
    });

    $('#btn_refresh_images').click(function(){
        loadImages();
    });

    $('#btn_refresh_quiniela').click(function(){
        loadQuiniela();
    });

    $('#btn_refresh_match').click(function(){
        App.loadMatchDetail(App.urlParams);
        if(App.matchDetailSection != ""){
            // $('.matchContainer *').hide();
            $('#match_detail_previewContainer *').hide();
            $('#match_detail_commentsContainer *').hide();
            $('#match_detail_lineUpContainer *').hide();
            $('#match_detail_eventsContainer *').hide();
            $('#match_detail_goalsContainer *').hide();
            $('#match_detail_reportContainer *').hide();
            $('#match_detail_imagesContainer *').hide();

            $(App.matchDetailSection + ' *').show();
        }
    });

    $("#premios").hide();

    $('#quinielaSelectorBtn').click(function(){
    	quinielaClick();
        enableQuinielaSelector($(this));
    });

    $('#premiosSelectorBtn').click(function(){
    	premiosClick();
        enableQuinielaSelector($(this));
    });

    function enableQuinielaSelector(selectorItem) {
       $('#quinielaSelectorBtn, #premiosSelectorBtn').removeClass('ui-state-persist');
        selectorItem.addClass('ui-state-persist'); 
    }


	function premiosClick(){
		$("#premios").show();
		$("#laquiniela").hide();
		loadPremiosQuiniela();
		
	}
		
	function quinielaClick(){
		$("#laquiniela").show();
		$("#premios").hide();
        $('.no_data').hide();
	}

    $(".socialNetworkBtn").click(function(){
        var url = App.config[$(this).attr('id')]
    	var activity = new MozActivity({
    	    name: "view",
    	    data: {
                type: "url",
                url: url,
    	    }
    	});
    });


    $("#classification").hide();

    $('#matchesSelectorCompetitionsBtn').click(function(){
    	matchesClick();
    });

    $('#classificationSelectorCompetitionsBtn').click(function(){
    	classificationClick();
    });


	function matchesClick(){
		$("#matches").show();
		$("#classification").hide();
        if (App.currentCompetitionId == "6") {
            $('#owl-rounds').hide();
        } else {
            $('#owl-rounds').show();
        }
	}
		
	function classificationClick(){
		$("#classification").show();
		$("#matches").hide();
        $("#owl-rounds").hide();		
	} 

/* Load list of rounds */
var loadRounds = function(callback){
    var url = App.filePath + App.config.URLActualRound;
    getRequestUrl(url, function(data){
        var currentCompetitionIndex = 0;
        for(var i = 0; i < data.competitions.length; i++) {
            var competition = data.competitions[i];
            if(competition.id == App.currentCompetitionId) {
                currentCompetitionIndex = i;
                break;
            }
        }
        App.currentRoundId = data.competitions[currentCompetitionIndex]['active_round']['round_number'];

        callback(true);

        window.setTimeout(function(){
            var owl = $(".owl-carousel").data('owlCarousel');
            owl.goTo(App.currentRoundId-1);


            $('.btnRoundSelector').click(function(evt){
                var item = $(this);
                executeRoundAction(item);
            });
        }, 300);
    });
    
}

var executeRoundAction = function(item) {
    $('#owl-rounds div.owl-item').removeClass('active');
    item.parent().parent().addClass('active');
    App.round_selected = item.attr('href').split('=')[1];
    loadMatches(App.currentCompetitionId, App.round_selected);
}

/* Load matches from competition_id and round_number */
var loadMatches = function(competition_id, round_number){
    var url = App.filePath + App.config.URLMatchs.replace('%@', competition_id).replace('%@', round_number);
    // var url = 'http://lfpdata.static.interactivecdn.com.s3.amazonaws.com/data/matches/competitions_test/matches_2_34.json';
    
    App.dictionaryMatches = {};

    var $last = $('#matchesList li.template');
	  $('ul#matchesList li:not(.template)').remove();
    var datesSportium = [];
    if(document.webL10n.getLanguage().contains('en')){
        var state = {
            2: '1H',
            3: 'HT',
            4: '2',
            5: 'PRO',
            6: 'PEN',
            7: 'FT',
            8: 'SUS'
        } 
    } else {
        var state = {
            2: '1º',
            3: 'DESC',
            4: '2ª',
            5: 'PROR',
            6: 'PEN',
            7: 'FIN',
            8: 'SUSP'
        }
    }
    getRequestUrl(url, function(data){
        $('#matchesList li:not(.template)').remove();
        $.each(data.matches.match, function(key, val) {
            if ($.inArray(val.date, datesSportium) < 0) {
                datesSportium.push(val.date);
                var dd_es = new Date( val.date.replace( /(\d{2})-(\d{2})-(\d{4})/, "$2/$1/$3") );
                
                //$('#matchesList').append("<li class='matchesDivider' href='' data-role='list-divider'><span>" + days[dd.getDay()] + ' ' + val.date + "</span></li>");
                if(document.webL10n.getLanguage().contains("en")){
                    $('#matchesList').append("<li class='matchesDivider' href='' data-role='list-divider'><span>" + days_en[dd_es.getDay()] + ' ' + val.date.replace( /(\d{2})-(\d{2})-(\d{4})/, "$2/$1/$3") + "</span></li>");
                } else {
                    $('#matchesList').append("<li class='matchesDivider' href='' data-role='list-divider'><span>" + days[dd_es.getDay()] + ' ' + val.date + "</span></li>");
                }
            }

            var state_match = parseInt(val.estado_partido);

            if(state_match == 7 ){
                /*$('#report_fin').show();
                $('#preview_fin').show();
                $('#report').hide();
                $('#preview').hide();*/
                $('#match_detail_previewContainer').show();
                $('#match_detail_previewContainer *').show();
                $('#owl-match_details .owl-item:eq(1)').addClass('active');
      /*          $('.matchContainer').hide();
                $('#match_detail_previewContainer *').hide();
                $('#match_detail_commentsContainer *').hide();
                $('#match_detail_lineUpContainer *').hide();
                $('#match_detail_eventsContainer *').hide();
                $('#match_detail_goalsContainer *').hide();
                $('#match_detail_reportContainer *').show();
                $('#match_detail_imagesContainer *').hide(); */
               
            
                
                App.matchDetailSectionIni = 1;
                

        
         
            } else {
                /*$('#report_fin').hide();
                $('#preview_fin').hide();
                $('#report').show();
                $('#preview').show();    */
                
         /*       $('.matchContainer').hide();
                $('#match_detail_previewContainer *').show();
                $('#match_detail_commentsContainer *').hide();
                $('#match_detail_lineUpContainer *').hide();
                $('#match_detail_eventsContainer *').hide();
                $('#match_detail_goalsContainer *').hide();
                $('#match_detail_reportContainer *').show();
                $('#match_detail_imagesContainer *').hide(); */
                App.matchDetailSectionIni = null;
      

               }
            
            var newItem = $last.clone().removeClass('template').attr('id', val.id_partido);

    	    $(".matches_icon_local", newItem).attr('src', App.config.URLS3ShieldsLow.replace('%@', val.local_team_slug));
            $(".matches_icon_away", newItem).attr('src', App.config.URLS3ShieldsLow.replace('%@', val.away_team_slug));
        	$(".matches_date", newItem).html(val.date);
    	    $(".matches_local_name", newItem).html(val.local_team);
            if(state_match == 1) {
                /*if(document.webL10n.getLanguage().contains("en")){
                    $(".matches_hour .date", newItem).html(formatDate(val.hour));
                } else {*/
                    $(".matches_hour .date", newItem).html(val.hour);
                //}
            } else if(state_match >= 2 && state_match < 7) {
                $(".matches_hour .date", newItem).html(state[state_match]);
                $(".matches_hour .date", newItem).addClass('green_background');
            } else {
                $(".matches_hour .date", newItem).html(state[state_match]);
                $(".matches_hour .date", newItem).addClass('red_color');
            }

    	    $(".matches_away_name", newItem).html(val.away_team);


            $('.matches_local_score', newItem).html(val.local_score);
            $('.matches_away_score', newItem).html(val.away_score);
            $('.data', newItem).attr('href', '#matchDetail?id='+ val.id_partido + '&from=teams');

            if(parseInt(val.estado_partido) != 7) {
                $('.data', newItem).addClass('actualMatch');
            }

            //La Liga TV
            if(val.laligatv != null) {
                $('.laligatv', newItem).removeClass('hidden');
                if (state_match < 2 || state_match > 6) {
                    $('img.point', newItem).addClass('hidden');
                }
            }

            App.dictionaryMatches[val.id_partido] = val;

            $('#matchesList').append(newItem);

             $('.no_data').hide();
        });

        if(isFirstLoad) {
            isFirstLoad = false;
            $('div#splash').hide();
            $('body').css('overflow-y', 'auto');
        }
    });

    $("#owl-rounds").owlCarousel({
        jsonPath : App.filePath + App.config.URLActualRound,
        jsonSuccess : customDataSuccess,
        itemsDesktop : [1000,5], //5 items between 1000px and 901px
        itemsDesktopSmall : [900,3], // betweem 900px and 601px
        itemsTablet: [600,2], //2 items between 600 and 0
        itemsMobile : [300, 2], // itemsMobile disabled - inherit from itemsTablet option
        responsive: true,
        responsiveRefreshRate : 200,
        responsiveBaseWidth: window,
        afterAction: function(el){
            var item;
            //if(this.currentItem != 0) {
            item = $('a.btnRoundSelector' ,this.$owlItems.eq(this.currentItem));
            executeRoundAction(item);
                
            //}
        }
    });

    function customDataSuccess(data){
        var content = "";
        for(var i in data.competitions[App.currentCompetitionId]['rounds']){
            var round = data.competitions[App.currentCompetitionId]['rounds'][i];
            var item = round.round_name;
            content += "<div><a href='#roundBtn?round_number=" + round.round_number  + "' class='btnCarousel btnRoundSelector ui-link ui-btn'> " + item + " </a></div>";
            App.round_selected = round;
        }
        if(document.webL10n.getLanguage().contains("en")){
            content.replaceAll("Jornada", "Week");
        }
       $("#owl-rounds").html(content);
    };


var executeMatchSectionAction = function(item) {
    $('#owl-match_details .owl-item').removeClass('active');
    item.parent().parent().addClass('active');
}

var loadSectionMatchDetail = function(item) {
    $('.matchContainer').hide();
    $('#' + item.attr('id') + 'Container').show();
    App.matchDetailSection = '#' + item.attr('id') + 'Container';
    executeMatchSectionAction(item);
    App.item = item;
    $('#matchesSelectorCompetitionsBtn').addClass('ui-btn-active');
}


$('#selector_matches_classif a').click(function(){
    $('#selector_matches_classif a').removeClass('ui-btn-active');
    $(this).addClass('ui-btn-active');
});

$('#matchDetail a.match_detail_back').click(function(){
    $('#matchesSelectorCompetitionsBtn').addClass('ui-btn-active');   
})

$('.matchContainer').hide();
$('#match_detail_previewContainer1 *').show();
/*$('#match_detail_commentsContainer *').hide();
$('#match_detail_lineUpContainer *').hide();
$('#match_detail_eventsContainer *').hide();
$('#match_detail_goalsContainer *').hide();
//$('#match_detail_reportContainer *').hide();
$('#match_detail_imagesContainer *').hide();*/
App.matchDetailSection = '#match_detail_previewContainer';

    
$('#owl-match_details .btnCarousel').click(function(evt){
    loadSectionMatchDetail($(this));
});


$.mobile.paramsHandler.addPage(
    "matchDetail",                      // id of jquery mobile page you want to accept URL parameters
    ["id"],       // required parameters for that page
    ["from"],                         // optional parameters for that page,

    // callback function for when that page is about to show
    App.loadMatchDetail = function (urlParams) {
        $("#owl-match_details").owlCarousel({
            items : 5, //10 items above 1000px browser width
            itemsDesktop : [1000,5], //5 items between 1000px and 901px
            itemsDesktopSmall : [900,3], // betweem 900px and 601px
            itemsTablet: [600,3], //2 items between 600 and 0
            itemsMobile : true, // itemsMobile disabled - inherit from itemsTablet option
            navigation: false,
            afterAction: function(el){
                var match = null;
                if(urlParams.from == "teams"){
                    match = App.dictionaryMatches[urlParams.id];
                } else {
                    match = App.dictionaryTeamMatches[urlParams.id];
                }
                App.urlParams = urlParams;
                
                $("#owl-match_details a.btnCarousel").removeClass('active');
                if(parseInt(match.estado_partido) == 7){
                    var item = $('a.btnCarousel' ,this.$owlItems.eq(this.currentItem));
                    loadSectionMatchDetail(item);
                } else {
                    var item = $('a.btnCarousel' ,this.$owlItems.eq(this.currentItem));
                    loadSectionMatchDetail(item);
                }
            }
        });

        if(urlParams.from == "teams"){
            var item = App.dictionaryMatches[urlParams.id];
        }
        else {
            var item = App.dictionaryTeamMatches[urlParams.id];
        }
        
        var state_match = parseInt(item.estado_partido);
        
        $('#owl-match_details .owl-item').removeClass('active');

        var attr1 = 'Previa';
        var attr2 = 'Crónica';
        if(document.webL10n.getLanguage().contains("en")){
            attr1 = 'Preview';
            attr2 = 'Report';
        }
        if(state_match == 7 ){
                $('.slider_match_detail #match_detail_preview').html(attr2);
                $('.slider_match_detail #match_detail_report').html(attr1);
            } else {
                $('.slider_match_detail #match_detail_preview').html(attr1);
                $('.slider_match_detail #match_detail_report').html(attr2);
            }
            App.matchDetailSectionIni = 1;
            //$('#owl-match_details .owl-item:eq(0)').addClass('active');
            var owl = $("#owl-match_details").data('owlCarousel');
            owl.goTo(0);
            $('#owl-match_details .btnCarousel').first().trigger('click');



        
        App.urlParams = urlParams;
   //     var url = App.config.URLMatchs.replace('%@', '1').replace('%@', '1');



        var newItem = $('#matchDetail');

        $(".match_detail_icon_local", newItem).attr('src', App.config.URLS3ShieldsLow.replace('%@', item.local_team_slug));
        
        $(".match_detail_local_score", newItem).html(item.local_score);

        $(".match_detail_meteorology", newItem).attr('src', 'images/iconos_tiempo/' + getIconWeatherName(parseInt(item.weather)) + '@2x.png');
        

        
        
        if(document.webL10n.getLanguage().contains("en")){
            var dd = item.date.replace( /(\d{2})-(\d{2})-(\d{4})/, "$2/$1/$3") ;
            $(".match_detail_date", newItem).html(dd);
            $(".match_detail_hour", newItem).html(formatDate(item.hour));
        } else {
            $(".match_detail_date", newItem).html(item.date);
            $(".match_detail_hour", newItem).html(item.hour);
        }
        $(".match_detail_channel", newItem).html(item.tv);

        $(".match_detail_icon_away", newItem).attr('src', App.config.URLS3ShieldsLow.replace('%@', item.away_team_slug));
        $(".match_detail_away_score", newItem).html(item.away_score);

        if(state_match >= 2) {
            if(state_match >= 2 && state_match < 7) {
                $(".match_detail_state", newItem).html(state[state_match]);
                $(".match_detail_state", newItem).addClass('green_background');
            } else {
                $(".match_detail_state", newItem).html(state[state_match]);
                $(".match_detail_state", newItem).addClass('red_color');
            }
            $('div.playedMatchContainer', newItem).show();
            $('div.notPlayedMatchContainer', newItem).hide();
        } else {
            $('div.playedMatchContainer', newItem).hide();
            $('div.notPlayedMatchContainer', newItem).show();
        }

        $('#matchDetail').append(newItem);


        //Preview
        if(document.webL10n.getLanguage().contains("en")){
            var previewUrl =  App.filePath + App.config.URLPreviewMatchDetail.replace('%@', item.id_partido).replace('%@', 'en');    
        } else {
            var previewUrl =  App.filePath + App.config.URLPreviewMatchDetail.replace('%@', item.id_partido).replace('%@', 'es');
        }

        
        if(state_match == 7 ){
                    var newItem = $('#match_detail_reportContainer');
                } else {
                    var newItem = $('#match_detail_previewContainer');
                } 
        
        
        //$('#match_detail_previewContainer *').hide();
            var failed = true;

            getRequestUrl(previewUrl, function(data){
                failed = false;

                if(data != null) {
                    var previewItem = data.xml.item;
                    $('.match_detail_preview_image', newItem).attr('src', previewItem.img);
                    $(".match_detail_preview_title", newItem).html(previewItem.title);
                    $('.match_detail_preview_description', newItem).html(previewItem.content);
                    $('*', $(newItem)).show();

                    if(state_match == 7 ){
                        $('#match_detail_reportContainer .no_data_match').hide();
                    } else {
                        $('#match_detail_previewContainer .no_data_match').hide();
                    } 
                } else {
                    $('*', $(newItem)).hide();
                    $('.no_data_match', $(newItem)).show();
                    $('.no_data_match *', $(newItem)).show();
                }

                if(state_match == 7 ){
                    $('#match_detail_reportContainer').append(newItem);
                } else {
                    $('#match_detail_previewContainer').append(newItem);
                } 
            });

        // Alineacion
         var lineUpUrl = App.filePath + App.config.URLLineupsMatchDetail.replace('%@', item.id_partido);
        //var lineUpUrl = "http://lfpdata.static.interactivecdn.com.s3.amazonaws.com/match_lineup_0000.json";
        var lineUpContainer = $('ul#lineUpList');
        $('ul#lineUpList li:not(.local_template, .away_template)').remove();

        getRequestUrl(lineUpUrl, function(data){
            if(data != null) {
                var localLineUpItem = data.local_lineup;
                var awayLineUpItem = data.visitor_lineup;

                
                var $lastLocalLineUp = $('ul#lineUpList li.local_template');
                var $lastAwayLineUp = $('ul#lineUpList li.away_template');

                $('ul#lineUpList').append("<li class='matchesDivider' data-role='list-divider'><span>" + item.local_team + ' (' + localLineUpItem.tactic + ")</span></li>");

                for(var j = 0; j < localLineUpItem.players.length; j++) {
                    var player = localLineUpItem.players[j].player;
                    var playerItem = $lastLocalLineUp.clone().removeClass('local_template');
                    $('img.player_image', playerItem).attr('src', player.imagen);
                    $('span.player_number', playerItem).html(player.dorsal);
                    $('span.player_name', playerItem).html(player.nombre);

                    $('ul#lineUpList').append(playerItem);
                }

                $('ul#lineUpList').append("<li class='matchesDivider' data-role='list-divider'><span>" + item.away_team + ' (' + awayLineUpItem.tactic + ")</span></li>");

                for(var j = 0; j < awayLineUpItem.players.length; j++) {
                    var player = awayLineUpItem.players[j].player;
                    var playerItem = $lastAwayLineUp.clone().removeClass('away_template');
                    $('img.player_image', playerItem).attr('src', player.imagen);
                    $('span.player_number', playerItem).html(player.dorsal);
                    $('span.player_name', playerItem).html(player.nombre);

                    $('ul#lineUpList').append(playerItem);
                }
                $('#match_detail_alignmentContainer *').show();
                $('#match_detail_alignmentContainer .no_data_match').hide();
            } else {
                $('#match_detail_alignmentContainer').hide();
                $('#match_detail_alignmentContainer .no_data_match').show();
            }
        });

        //Comments
            if(document.webL10n.getLanguage().contains("en")){
                var commentsUrl =  App.filePath + App.config.URLCommentsMatchDetail.replace('%@', item.id_partido).replace('%@', 'en');
            } else {
                var commentsUrl =  App.filePath + App.config.URLCommentsMatchDetail.replace('%@', item.id_partido).replace('%@', 'es');
            }
            var typeComments = {"2": "icon_info_","3": "icon_roja","4": "icon_amarilla","5": "icon_penalti","6": "icon_gol",
            "7": "icon_falta","8": "icon_inicio","9": "icon_final","10": "icon_inicio","11": "icon_huuuyy","12": "icon_corner",
            "13": "icon_fuerajuego","14": "icon_lesion","15": "icon_descuento","16": "icon_cambio","17": "icon_descuento",
            "18": "icon_inicio","19": "icon_final","20": "icon_inicio","21": "icon_final","22": "icon_penalti","24": "icon_final",
            "25": "icon_descuento","26": "icon_copa","27": "icon_info","31": "icon_info"};


            $('ul#match_detail_comments_list li:not(.template)').remove();
            getRequestUrl(commentsUrl, function(data){
                
                if(data != null){
                    
                    var $last = $('ul#match_detail_comments_list li.template');
                    $.each(data['comments'], function(key, val) {
                        var comment = val;

                        var commentItem = $last.clone().removeClass('template');
                        var type = typeComments[comment.comment_typefk];


                        $(".match_detail_comments_description", commentItem).html(comment.text);
                        $('ul#match_detail_comments_list').append(commentItem);

                        $('.match_detail_comments_min', commentItem).html(comment.minute);
                        if(type == 'icon_info_') {
                            $('.match_detail_comments_icon', commentItem).remove();
                        } else {
                            $('.match_detail_comments_icon', commentItem).attr('src', 'images/icons_comments/' + typeComments[comment.comment_typefk] + '@2x.png');
                        }
                        

                        $(".match_detail_comments_description", commentItem).html(comment.text);

                        $('ul#match_detail_comments_list').append(commentItem);
                    });
                    $('#match_detail_commentsContainer *').show();
                    $('#match_detail_commentsContainer .no_data_match').hide();
                }else {
                    $('#match_detail_commentsContainer').hide();
                    $('#match_detail_commentsContainer .no_data_match').show();
                }
            });
        
        //Events
            var eventsUrl =  App.filePath + App.config.URLEventsMatchDetail.replace('%@', item.id_partido);
            var typeEvents = {"1": "icon_amarilla", "2": "icon_roja", "3": "icon_gol", "6": "icon_cambio", "7": "icon_lesion"};
            $('ul#match_detail_events_list li:not(.local_template, .away_template)').remove();
            getRequestUrl(eventsUrl, function(data){
                
                if(data != null){
                    
                    var $local_template = $('ul#match_detail_events_list li.local_template');
                    var $away_template  = $('ul#match_detail_events_list li.away_template');
                    var events = data['xml']['match']['eventos']['evento'];
                    events.reverse();
                    $.each(events, function(key, val) {
                        var event = val;

                        
                        if(event.id_equipo == data['xml']['match']['id_equipo_local']){
                            var eventItem = $local_template.clone().removeClass('local_template');
                        } else {
                            var eventItem = $away_template.clone().removeClass('away_template');
                        }
                        var type = typeEvents[event.tipo];

                        $('.match_detail_events_min', eventItem).html(event.minuto);
                        if(type == 'icon_info_') {
                            $('.match_detail_event_icon', eventItem).remove();
                        } else {
                            if(event.tipo == "1" && event.num_tarjeta == "2"){
                                $('.match_detail_events_icon', eventItem).attr('src', 'images/icons_comments/icon_dobleamarilla@2x.png');    
                            } else {
                            $('.match_detail_events_icon', eventItem).attr('src', 'images/icons_comments/' + typeEvents[event.tipo] + '@2x.png');
                            }
                        }
                        
                        if(event.tipo == "6") {
                            $(".match_detail_events_description", eventItem).html(event.jugador_entra + " - " + event.jugador_sale);
                        }else {
                            $(".match_detail_events_description", eventItem).html(event.jugador);
                        }
                        $('ul#match_detail_events_list').append(eventItem);
                    });
                    $('#match_detail_eventsContainer *').show();
                    $('#match_detail_eventsContainer .no_data_match').hide();
                }else{
                    $('#match_detail_eventsContainer').hide();
                    $('#match_detail_eventsContainer .no_data_match').show();
                }
            });


            //Goals
            var goalsurl = App.filePath + App.config.URLGoalsMatchDetail.replace('%@', item.id_partido);
            var datesMatches = [];
            var $last = $('#match_detail_goals_list li.template');

            $('ul#match_detail_goals_list li:not(.template)').remove();
            getRequestUrl(goalsurl, function(d){
                if (d != null) {
                    if(d['goals'].length > 0){
                        App.goals = d['goals'];
                        $.each(d['goals'], function(keyg, valg) {

                            if ($.inArray(item, datesMatches) < 0) {
                                datesMatches.push(item);
                            $('#goalsList').append("<li class='goal3dDivider' data-role='list-divider'><span class='blue'>" + item + "</span></li>");
                        };
                            var goalItem = $last.clone().removeClass('template').attr('id', valg.goal3d__name);
                            $('.data', goalItem).attr('href', keyg);
                            $(".match_detail_goal_image", goalItem).attr('src', App.config.URLScreenshotGoal.replace('%@', valg.goal3d__name));
                            $(".match_detail_goal_minute", goalItem).html('min. ' + valg.minute);
                            if(document.webL10n.getLanguage().contains('en')){
                                $(".match_detail_goal_name", goalItem).html(valg.playerfk__name + ' goal!');    
                            } else {
                                $(".match_detail_goal_name", goalItem).html('¡Gol de ' + valg.playerfk__name + '!');    
                            }
                            
                            $(".match_detail_goal_match", goalItem).html(valg.local_team + ' ' + valg.result + ' ' + valg.away_team);
                            $('#match_detail_goals_list').append(goalItem);
                        });
                        $('#match_detail_goalsContainer *').show();
                        $('#match_detail_goalsContainer .no_data_match').hide();
                    } else {
                        $('#match_detail_goalsContainer').hide();
                        $('#match_detail_goalsContainer .no_data_match').show();
                    }
                }
            });

            
            $('ul#match_detail_goals_list').delegate('li', 'click', function () {
                var videoIndex = $('a', $(this)).attr('href');
                
                var item = App.goals[parseInt(videoIndex)];
                var url = App.config.URLVideoGoal.replace('%@', item['goal3d__name']);

                var activity = new MozActivity({
                    name: "view",
                    data: {
                        type: ["video/mp4"],
                        url: url,
                    }
                });
                activity.onsuccess = function () {
                    //alert("success");
                };
                activity.onerror = function () {
                    //alert("error");
                };
            });

            //Report
            if(document.webL10n.getLanguage().contains("en")){
                var reportUrl =  App.filePath + App.config.URLReportMatchDetail.replace('%@', item.id_partido).replace('%@', 'en');
            } else {
                var reportUrl =  App.filePath + App.config.URLReportMatchDetail.replace('%@', item.id_partido).replace('%@', 'es');
            }
            if(state_match == 7 ){
                var newItem2 = $('#match_detail_previewContainer');
            } else {
                var newItem2 = $('#match_detail_reportContainer');
            }
            //$('#match_detail_reportContainer *').hide();
            getRequestUrl(reportUrl, function(data){
                if(data != null) {
                    var reportItem = data.xml.item;
                    $('.match_detail_preview_image', newItem2).attr('src', reportItem.img);
                    $(".match_detail_preview_title", newItem2).html(reportItem.title);
                    $('.match_detail_preview_description', newItem2).html(reportItem.content);

                    if(state_match == 7 ){
                        $('#match_detail_previewContainer').append(newItem2);
                        $('#match_detail_previewContainer *').show();
                        $('#match_detail_previewContainer .no_data_match').hide();
                    } else {
                        $('#match_detail_reportContainer').append(newItem2);
                        $('#match_detail_reportContainer *').show();
                        $('#match_detail_reportContainer .no_data_match').hide();
                    }

                    
                } else {
                    $('#match_detail_reportContainer *').hide();
                    $('#match_detail_reportContainer .no_data_match').show();
                    $('#match_detail_reportContainer .no_data_match *').show();
                }
            });


            //Images
            var imagesDetailsUrl =  App.filePath + App.config.URLImagesMatchDetail.replace('%@', item.id_partido);
            var imageDetailItem = $('#match_detail_imagesContainer');
            $('ul#match_detail_image_list li:not(.template)').remove();
            getRequestUrl(imagesDetailsUrl, function(data){
                if(data != null) {
                    var $last = $('#match_detail_image_list li.template');
                    App.images = data['xml']['images']['image'];
                    
                    $.each(data.xml.images.image, function(key, val) {
                        var imageDetailItem = $last.clone().removeClass('template');
                        $(".images_image", imageDetailItem).attr('src', val.size170x170);
                        $(".images_data", imageDetailItem).attr('href', '#imageDetail?position=' + key);
                        $('#match_detail_image_list').append(imageDetailItem);
                    });
                    $('#match_detail_imagesContainer *').show();
                    $('#match_detail_imagesContainer .no_data_match').hide();
                }else {
                    $('#match_detail_imagesContainer').hide();
                    $('#match_detail_imagesContainer .no_data_match').show();
                }
            });
    }

);       
        // REFRESCO AUTOMÁTICO 
        // window.setInterval(function(){
        //          App.loadMatchDetail(App.urlParams);
        //          if(App.matchDetailSection != ""){
        //             $('.matchContainer').hide();
        //             $(App.matchDetailSection).show();
        //          }
        //     }, App.config.RefreshMatchesTime*1000);
    


    function refreshMatches() {
        App.loadMatchDetail(App.urlParams);
    }

    // function refreshMatchDetail() {
    //     if(App.matchDetailSection != ""){
    //         $('.matchContainer').hide();
    //         // $(App.matchDetailSection).show();
    //     }
    // }
	
 
  function customDataSuccess(data){
    var content = "";
    for(var i in data.competitions['0']['rounds']){
        var round = data.competitions['0']['rounds'][i];

        var item = round.round_name;
    if(document.webL10n.getLanguage().contains('en')){
        var item = (round.round_name).replace('Jornada', 'Week');
    }  
 
       content += "<div><a href='#roundBtn?round_number=" + round.round_number  + "' id='' class='btnCarousel btnRoundSelector ui-link ui-btn'> " + item + " </a></div>";
    }

     $("#owl-rounds").html(content);
  };

    

    
 
}; 



var loadClassification = function(){
    var url = App.filePath + App.config.URLClassification.replace('%@', App.currentCompetitionId);
    var $last = $('#classificationList li.template');
    $('#classificationList li:not(.template)').remove();
    var groups = [];
    getRequestUrl(url, function(data){
        if(data != null) {
            for(var i = 0; i < data['groups'].length; i++) {
                if ($.inArray(i, groups) < 0 && data['groups'].length > 1) {
                    groups.push(i);
                    $('#classificationList').append("<li class='classificationDivider' data-role='list-divider'><span> Grupo " + data.groups[i].group_letter + "</span></li>");
                }
            
                $.each(data['groups'][i]['teams'], function(key, val) {
                    var position = parseInt(val.position);
                    var newItem = $last.clone().removeClass('template').attr('id', val.matchtied);
                    $(".classification_team_position", newItem).html(position);
                    $(".classification_team_name", newItem).html(val.teamfk__shortname);
                    $(".classification_team_pj", newItem).html(val.matchplayed);
                    $(".classification_team_pg", newItem).html(val.matchwon);
                    $(".classification_team_pe", newItem).html(val.matchtied);
                    $(".classification_team_pp", newItem).html(val.matchlost);
                    $(".classification_team_gf", newItem).html(val.goalsfor);
                    $(".classification_team_gc", newItem).html(val.goalsagainst);
                    $(".classification_team_pts", newItem).html(val.points);

                    if(App.currentCompetitionId == 1) {
                        if(position >= 1 && position <=4){
                            $('.position_color', newItem).addClass('position_background_green');
                        } else if(position >= 5 && position <=6){
                            $('.position_color', newItem).addClass('position_background_blue');
                        } else if(position >= 18 && position <= 20) {
                            $('.position_color', newItem).addClass('position_background_red');
                        }
                    } else if(App.currentCompetitionId == 2) {
                        if(position >= 1 && position <=2){
                            $('.position_color', newItem).addClass('position_background_green');
                        } else if(position >= 3 && position <=6){
                            $('.position_color', newItem).addClass('position_background_blue');
                        } else if(position >= 19 && position <= 22) {
                            $('.position_color', newItem).addClass('position_background_red');
                        }
                    }
                    else if(App.currentCompetitionId > 2) {
                        if(position >= 1 && position <=2){
                            $('.position_color', newItem).addClass('position_background_green');
                        } 
                    }
                    
                    $('#classificationList').append(newItem);
                });
            }
            $('#classificationList').show();
            $('.no_data_standing').hide();
        } else {
            $('#classificationList').hide();
            $('.no_data_standing').show();
        }
    });
};

var loadGoals = function(){
 //    var url = App.filePath + App.config.URLGoals.replace('%@', App.ligaBbvaId);
 //    var $last = $('#goalsList li.template');
 //    getRequestUrl(url, function(data){
 //        App.goals = data['goals'];
	// $('ul#goalsList li:not(.template)').remove();
 //        $.each(data['goals'], function(key, val) {
 //            var newItem = $last.clone().removeClass('template').attr('id', val.goal3d__name);
 //            $('.data', newItem).attr('href', '#goalDetail?position=' + key);
 //            $(".goal_image", newItem).attr('src', App.config.URLScreenshotGoal.replace('%@', val.goal3d__name));
 //            $(".goal_minute", newItem).html('min. ' + val.minute);
 //            $(".goal_name", newItem).html('¡Gol de ' + val.playerfk__name + '!');
 //            $(".goal_match", newItem).html(val.local_team + ' ' + val.result + ' ' + val.away_team);
 //            $('#goalsList').append(newItem);
 //        });
 //    });
        var url = App.filePath + App.config.URLGoals.replace('%@', App.ligaBbvaId);
        
        getRequestUrl(url, function(data){
            var $last = $('#goalsList li.template');
            var datesMatches = [];
            App.goals = data['goals'];
            $('ul#goalsList li:not(.template)').remove();
            $.each(data['goals'], function(key, val) {
                var newItem = $last.clone().removeClass('template');
                var match = val.local_team + " - " + val.away_team;
                if ($.inArray(match, datesMatches) < 0) {
                    datesMatches.push(match);
                    $('#goalsList').append("<li class='goal3dDivider' data-role='list-divider'><span class='blue'>" + match + "</span></li>");
                };
                $(".data", newItem).attr('href', '' + key);
                $(".goal_image", newItem).attr('src', App.config.URLScreenshotGoal.replace('%@', val.goal3d__name));
                $(".goal_minute", newItem).html('min. ' + val.minute);
                if(document.webL10n.getLanguage().contains('en')){
                    $(".goal_name", newItem).html(val.playerfk__name + ' goal!');
                } else {
                    $(".goal_name", newItem).html('¡Gol de ' + val.playerfk__name + '!');
                }
                $(".goal_match", newItem).html(val.local_team + ' ' + val.result + ' ' + val.away_team);
                $('#goalsList').append(newItem);
            });
        });

        $('#goalsList').delegate('li', 'click', function () {
            var videoIndex = $('a', $(this)).attr('href');
            
            var item = App.goals[parseInt(videoIndex)];
            var url = App.config.URLVideoGoal.replace('%@', item['goal3d__name']);

            var activity = new MozActivity({
                name: "view",
                data: {
                    type: ["video/mp4"],
                    url: url,
                }
            });
            activity.onsuccess = function () {
                //alert("success");
            };
            activity.onerror = function () {
                //alert("error");
            };
        });
        /*$('#goalsList li').live('click', function() {
            alert("Works"); // id of clicked li by directly accessing DOMElement property
        });*/
};


/*$.mobile.paramsHandler.addPage(
    "goalDetail",                      // id of jquery mobile page you want to accept URL parameters
    ["position"],       // required parameters for that page
    [],                         // optional parameters for that page,

    // callback function for when that page is about to show
    function (urlParams) {
        var item = App.goals[parseInt(urlParams.position)];
        var url = App.config.URLVideoGoal.replace('%@', item['goal3d__name']);

        var activity = new MozActivity({
            name: "view",
            data: {
                type: ["video/mp4"],
                url: url,
            }
        });
        activity.onsuccess = function () {
            //alert("success");
        };
        activity.onerror = function () {
            //alert("error");
        };
    }
);*/



var loadNews = function(){
    if(document.webL10n.getLanguage().contains("en")){
        var url = App.filePath + App.config.URLNews.replace('%@', 'en');
    } else {
        var url = App.filePath + App.config.URLNews.replace('%@', 'es');
    }
    var $last = $('#newsList li.template');
    getRequestUrl(url, function(data){
	App.news = data['rss']['channel']['item'];
	$('ul#newsList li:not(.template)').remove();
     $.each(data.rss.channel.item, function(key, val) {
        if(val.importancia != App.config.FeaturedNews[1]){
            var newItem = $last.clone().removeClass('template').attr('id', val.title);
    	    $('.news_image', newItem).attr('href', '#newsDetail?pos=' + key);
    	    $(".images_image", newItem).attr('src', val.enclosure[0]['@url']);
    	    $(".news_date", newItem).html(getFormattedDate(val.pubDate));
    	    $(".news_title", newItem).html(val.title);
            $(".news_description", newItem).html(val.description);
            $('#newsList').append(newItem);

       }
    });


$(document).ready(function() {
 
  $("#owl-destacadas").owlCarousel({
    loop: true,
    autoPlay: 3000,
    jsonPath : url,
    jsonSuccess : customDataSuccess
  });
 
  function customDataSuccess(data){
    var content = "";
    for(var i in data['rss']['channel']['item']){
       if(data['rss']['channel']['item'][i]['importancia'] == App.config.FeaturedNews[1]){
            var img = data['rss']['channel']['item'][i].enclosure[0]['@url'];
            var alt = data['rss']['channel']['item'][i].title;
            var hrf = 'href=#newsDetail?pos=' + i;
 
            content += "<a " + hrf + " ><img src=\"" +img+ "\" alt=\"" +alt+ "\"><span> " + alt + " </span>"
        }
    }
    $("#owl-destacadas").html(content);
  }
 
});
});
    $('#newsList').reverse();
};



$.mobile.paramsHandler.addPage(
    "newsDetail",                      // id of jquery mobile page you want to accept URL parameters
    ["pos"],       // required parameters for that page
    [],                         // optional parameters for that page,

    // callback function for when that page is about to show
    function (urlParams) {
        var item = App.news[parseInt(urlParams.pos)];
        var newItem = $('#newsDetail');
        $(".newsDetailsImage", newItem).attr('src', item.enclosure[0]['@url']);
        $(".newsDetails_date", newItem).html(getFormattedDate(item.pubDate));
        $(".newsDetails_title", newItem).html(item.title);
        $(".newsDetails_description", newItem).html(item['content:encoded']);
        $('#newsDetail').append(newItem);
    }
);





var loadImages = function(){
    var url = App.filePath + App.config.URLImages;
    var $last = $('#imageList li.template');
    getRequestUrl(url, function(data){
	  App.images = data['xml']['images']['image'];
	  $('ul#imageList li:not(.template)').remove();
        var maxImages = 0;
        $.each(data.xml.images.image, function(key, val) {
            if(maxImages < 15) {
               var newItem = $last.clone().removeClass('template').attr('id', val.description);
	             $(".images_image", newItem).attr('src', val.size170x170);
	             $(".images_data", newItem).attr('href', '#imageDetail?position=' + key);
               $('#imageList').append(newItem);
               maxImages++;
            }
            
        });
    });
};
$.mobile.paramsHandler.addPage(
    "imageDetail",                      // id of jquery mobile page you want to accept URL parameters
    ["position"],       // required parameters for that page
    [],                         // optional parameters for that page,

    // callback function for when that page is about to show
    function (urlParams) {
        var item = App.images[parseInt(urlParams.position)];
	var newItem = $('#imageDetail');
       $(".imageDetail_image", newItem).attr('src', item['size467x281']);
	   $(".imageDetail_comment", newItem).html(item['descripcion']);
	   $('#imageDetail').append(newItem);
    }
);


var executeTeamSectionAction = function(item) {
    $('#owl-example div.owl-item').removeClass('active');
    item.parent().parent().addClass('active');
}

var loadSectionTeamDetail = function(item) {
    $('.teamContainer').hide();
    $('#' + item.attr('id') + 'Container').show();
    executeTeamSectionAction(item);
}



/*$('.teamContainer').hide();
$('#clubTeamContainer').show();*/
$('.owl-carousel .btnCarousel').click(function(evt){
    loadSectionTeamDetail($(this));
});

var loadTeams = function(){
    var url = App.filePath + App.config.URLTeams.replace('%@', '1');
    var $last = $('#teamList1 li.template');
    var url2 = App.filePath + App.config.URLTeams.replace('%@', '2');
    var $last2 = $('#teamList2 li.template');
    $('ul#teamList1 li:not(.template)').remove();
    $('ul#teamList2 li:not(.template)').remove();
    getRequestUrl(url, function(data){
        $.each(data['teams'], function(key, val) {
            var newItem = $last.clone().removeClass('template').attr('id', val.id_team);
            $('a', newItem).attr('href', '#teamDetail?team_id=' + val.id_team);
            $(".team_shield1", newItem).attr('src', App.config.URLS3ShieldsLow.replace('%@', val.slug));
            $(".team_name1", newItem).html(val.team_name);
            $('#teamList1').append(newItem);
        });
    });
    getRequestUrl(url2, function(data){
       	$.each(data['teams'], function(key, val) {
            var newItem = $last2.clone().removeClass('template').attr('id', val.id_team);
            $('a', newItem).attr('href', '#teamDetail?team_id=' + val.id_team);
            $(".team_shield2", newItem).attr('src', App.config.URLS3ShieldsLow.replace('%@', val.slug));
            $(".team_name2", newItem).html(val.team_name);
            $('#teamList2').append(newItem);
        });
    });
};

$.mobile.paramsHandler.addPage(
    "teamDetail",                      // id of jquery mobile page you want to accept URL parameters
    ["team_id"],       // required parameters for that page
    [],                         // optional parameters for that page,

    // callback function for when that page is about to show
    function (urlParams) {
        var url = App.filePath + App.config.URLTeamDetail.replace('%@', urlParams.team_id);
        $('div#clubTeamContainer').hide();
        getRequestUrl(url, function(data){
            $('#clubTeamContainer img.header_img').attr('src', App.config.URLImageHeaderTeam.replace('%@', data.slug));
            $('#clubTeamContainer img.stadium_img').attr('src', App.config.URLImageStadiumTeam.replace('%@', data.slug));

            $('div#clubTeamContainer span.fullname_team').html(data.fullname);
            $('div#clubTeamContainer span.president_team').html('Presidente: ' + data.presidente);
            $('div#clubTeamContainer span.address_team').html('Dirección: ' + data.direccion);
            $('div#clubTeamContainer span.web_team').html('Web: ' + data.web);
            $('div#clubTeamContainer span.twitter_team').html('Twitter: ' + data.twitter);
            $('div#clubTeamContainer span.facebook_team').html('Facebook: ' + data.facebook);
            $('div#clubTeamContainer span.mail_team').html('Correo electrónico: ' + data.mail);
            $('div#clubTeamContainer span.phone_team').html('Teléfono: ' + data.telefono);
            $('div#clubTeamContainer').show();
            $("#owl-example").owlCarousel({
                items : 5, //10 items above 1000px browser width
                itemsDesktop : [1000,5], //5 items between 1000px and 901px
                itemsDesktopSmall : [900,3], // betweem 900px and 601px
                itemsTablet: [600,3], //2 items between 600 and 0
                itemsMobile : true, // itemsMobile disabled - inherit from itemsTablet option
                navigation: false,
                afterAction: function(el){
                    var item = $('a.btnCarousel' ,this.$owlItems.eq(this.currentItem));
                    loadSectionTeamDetail(item);
                }
            });

            $("#owl-example a.btnCarousel").removeClass('active');
            loadSectionTeamDetail($("#owl-example a.btnCarousel").first());
            var owl = $("#owl-example").data('owlCarousel');
            owl.goTo(0);

            
            //Cups
            $('ul.cups li:not(.template)').remove();
            if(data.palmares != null){
                var cups = data.palmares.split('*');
                var $last = $('ul.cups li.template');
                $('ul.cups li:not(.template)').remove();
                for(var i = 0; i < cups.length; i++) {
                    var cup = cups[i];
                    if (cup.length > 0) {
                        var name = cup.split(':')[0].split(' (')[0].replaceAll(' ', '_').replaceAll('ñ', 'n').replaceAll('/', '_').replaceAll('&ntilde;', 'n').replaceAll('&oacute;', 'ó').replaceAll(' ', '');
                        var count = cup.split(':')[0].split('(')[1].split(')')[1];
                        var cup_name = cup.split(':')[0];
                        var newItem = $last.clone().removeClass('template');
                        $('img', newItem).attr('src', 'images/cups/' + name + '_cup.png').attr('onmouseover', "document.getElementById('span_cup_name').innerHTML='" + cup_name + "'");
                        $('span', newItem).html(count);
                        $('ul.cups').append(newItem);
                    }
                }
            }
            //Roster
            var roster = data.plantilla.jugador;
            var $last = $('ul#rosterList li.template');
            $('ul#rosterList li:not(.template)').remove();
            for(var j = 0; j < roster.length; j++) {
                var player = roster[j];
                var playerItem = $last.clone().removeClass('template');
                $('img.player_image', playerItem).attr('src', player.imagen);
                $('span.player_number', playerItem).html(player.dorsal);
                $('span.player_name', playerItem).html(player.nombre);
                $('span.player_date', playerItem).html(player.fecha_nacimiento);
                $('span.player_position', playerItem).html(player.posicion);
                $('span.player_height', playerItem).html(player.altura);
                $('span.player_Weight', playerItem).html(player.peso);

                $('ul#rosterList').append(playerItem);
            }

        //Goles3d
        var url2 = App.filePath + App.config.URLTeamGoals.replace('%@', urlParams.team_id);
        
        getRequestUrl(url2, function(data){
            var $last = $('#goalsTeamList li.template');
            var datesMatches = [];
            App.goals = data['goals'];
            $('ul#goalsTeamList li:not(.template)').remove();
            $.each(data['goals'], function(key, val) {
                var newItem = $last.clone().removeClass('template');
                var match = val.local_team + " - " + val.away_team;
                if ($.inArray(match, datesMatches) < 0) {
                    datesMatches.push(match);
                    $('#goalsTeamList').append("<li class='goal3dDivider' data-role='list-divider'><span class='blue'>" + match + "</span></li>");
                };
                $(".data", newItem).attr('href', key);
                $(".goal_image", newItem).attr('src', App.config.URLScreenshotGoal.replace('%@', val.goal3d__name));
                $(".goal_minute", newItem).html('min. ' + val.minute);
                if(document.webL10n.getLanguage().contains('en')){
                    $(".goal_name", newItem).html(val.playerfk__name + ' goal!');    
                } else {
                    $(".goal_name", newItem).html('¡Gol de ' + val.playerfk__name + '!');
                }
                $(".goal_match", newItem).html(val.local_team + ' ' + val.result + ' ' + val.away_team);
                $('#goalsTeamList').append(newItem);
            });
        });

        $('ul#goalsTeamList').delegate('li', 'click', function () {
            var videoIndex = $('a', $(this)).attr('href');
            
            var item = App.goals[parseInt(videoIndex)];
            var url = App.config.URLVideoGoal.replace('%@', item['goal3d__name']);

            var activity = new MozActivity({
                name: "view",
                data: {
                    type: ["video/mp4"],
                    url: url,
                }
            });
            activity.onsuccess = function () {
                //alert("success");
            };
            activity.onerror = function () {
                //alert("error");
            };
        });
        //Images
        var url3 = App.filePath + App.config.URLTeamImages.replace('%@', urlParams.team_id);
        
        getRequestUrl(url3, function(data){
            var $last = $('#imageTeamList li.template');
            App.images = data['xml']['images']['image'];
            $('ul#imageTeamList li:not(.template)').remove();
            $.each(data.xml.images.image, function(key, val) {
                var newItem = $last.clone().removeClass('template');
                $(".images_image", newItem).attr('src', val.size170x170);
                $(".images_data", newItem).attr('href', '#imageDetail?position=' + key);
                $('#imageTeamList').append(newItem);
            });
        });

        // //Matches
        var teamsMatches = App.filePath + App.config.URLTeamMatchs.replace('%@', urlParams.team_id);
    
        var $last = $('#teamMatchesList li.template');
        $('ul#teamMatchesList li:not(.template)').remove();
        var datesSportium = [];
        if(document.webL10n.getLanguage().contains('en')){
            var state = {
                2: '1H',
                3: 'HT',
                4: '2',
                5: 'PRO',
                6: 'PEN',
                7: 'FT',
                8: 'SUS'
            } 
        } else {
            var state = {
                2: '1º',
                3: 'DESC',
                4: '2ª',
                5: 'PROR',
                6: 'PEN',
                7: 'FIN',
                8: 'SUSP'
            }
        }
        getRequestUrl(teamsMatches, function(data){
            $.each(data['matches'], function(key, val) {
                if ($.inArray(val.date, datesSportium) < 0) {
                    datesSportium.push(val.date);
                    var dd = new Date( val.date.replace( /(\d{2})-(\d{2})-(\d{4})/, "$2/$1/$3") );
                    $('#teamMatchesList').append("<li class='matchesDivider' data-role='list-divider'><span>" + days[dd.getDay()] + ' ' + val.date + "</span></li>");
                }

                var state_match = parseInt(val.estado_partido);

                var newItem = $last.clone().removeClass('template').attr('id', val.id_partido);

                $(".team_matches_icon_local", newItem).attr('src', App.config.URLS3ShieldsLow.replace('%@', val.local_team_slug));
                $(".team_matches_icon_away", newItem).attr('src', App.config.URLS3ShieldsLow.replace('%@', val.away_team_slug));
                $(".team_matches_date", newItem).html(val.date);
                $("#team_matches_local_name", newItem).html(val.local_team);
                if(state_match == 1) {
                    $("#team_matches_hour .date", newItem).html(val.hour);
                } else if(state_match >= 2 && state_match < 7) {
                    $("#team_matches_hour .date", newItem).html(state[state_match]);
                    $("#team_matches_hour .date", newItem).addClass('green_background');
                } else {
                    $("#team_matches_hour .date", newItem).html(state[state_match]);
                    $("#team_matches_hour .date", newItem).addClass('red_color');
                }

                $("#team_matches_away_name", newItem).html(val.away_team);

                if((val.local_score) != "" && (val.local_score) != null){
                    $('#team_matches_local_score', newItem).html(val.local_score);
                }else{
                    $('#team_matches_local_score', newItem).html('&nbsp');
                }
                
                $('#team_matches_away_score', newItem).html(val.away_score);
                $('.team_data', newItem).attr('href', '#matchDetail?id='+ val.id_partido);

                if(parseInt(val.estado_partido) != 7) {
                    $('.team_data', newItem).addClass('actualMatch');
                }

                //La Liga TV
                if(val.laligatv != null) {
                    $('.team_laligatv', newItem).removeClass('hidden');
                    if (state_match < 2 || state_match > 6) {
                        $('img.team_point', newItem).addClass('hidden');
                    }
                }

                $('#teamMatchesList').append(newItem);
                App.dictionaryTeamMatches[val.id_partido] = val;
        });
   });
    }
);
});



function formatDate(date) {
    var d = date.split(':');
    var hh = d[0];
    var m = d[1];
    
    var dd = "AM";
    var h = hh;
    if (h >= 12) {
        h = hh-12;
        dd = "PM";
    }
    if (h == 0) {
        h = 12;
    }


    var pattern = new RegExp("0?"+hh+":"+m);

    var replacement = h+":"+m;
    /* if you want to add seconds
    replacement += ":"+s;  */
    replacement += " "+dd;    

    return date.replace(pattern,replacement);
}




var loadQuiniela = function(){
     var url = App.filePath + App.config.QuinielaActualRound;
    // var url = 'http://lfpdata.static.interactivecdn.com.s3.amazonaws.com/data/quiniela/close_actual_round.json';
    var $last = $('#laquiniela div.template_match');
    var $lastSpecial = $('#laquiniela div.template_special_match');
    $('div#laquiniela > div:not(.template_match, .template_special_match)').remove();
    getRequestUrl(url, function(data){
        $.each(data['matches'], function(key, val) {
            if (val.position < 15) {
                var newItem = $last.clone().removeClass('template_match');
                $(".numero_encuentro", newItem).html(val.position);
                $(".titulo_encuentro", newItem).html(val.local_team_name + ' - ' + val.away_team_name);
                
                if(document.webL10n.getLanguage().contains("en")){
                    var res = (val.state).split(' ');
                    if(res.length > 1) {
                        var d = res[0].replace('lun', 'Mon');
                        d = d.replace('mar', 'Tue');
                        d = d.replace('mié', 'Wed');
                        d = d.replace('jue', 'Thu');
                        d = d.replace('vie', 'Fri');
                        d = d.replace('sab', 'Sat');
                        d = d.replace('dom', 'Sun');

                        $(".date", newItem).html(d + ' ' + formatDate(res[1]));    
                    }else {
                        $(".date", newItem).html(val.state);  
                    }
                }else {
                    $(".date", newItem).html(val.state);
                }
                

                if(val.position%2 == 0){
                    newItem.addClass('row_quiniela_grey');
                } else {
                    newItem.addClass('row_quiniela_white');
                }

                if(val.symbol == '1') {
                    $('.box_1', newItem).addClass('box_1_IMPRENTA').removeClass('.box_1');
                } else if(val.symbol == 'X') {
                    $('.box_x', newItem).addClass('box_X_IMPRENTA').removeClass('.box_x');
                } else if(val.symbol == '2') {
                    $('.box_2', newItem).addClass('box_2_IMPRENTA').removeClass('.box_2');
                }
            } else {
                var newItem = $lastSpecial.clone().removeClass('template_special_match');
                $(".numero_encuentro_15", newItem).html(val.position);
                $("#titulo_encuentro_15_local", newItem).html(val.local_team_name);
                $("#titulo_encuentro_15_away", newItem).html(val.away_team_name);
                if(document.webL10n.getLanguage().contains("en")){
                    var res = (val.state).split(' ');
                    if(res.length > 1) {
                        var d = res[0].replace('lun', 'Mon');
                        d = d.replace('mar', 'Tue');
                        d = d.replace('mié', 'Wed');
                        d = d.replace('jue', 'Thu');
                        d = d.replace('vie', 'Fri');
                        d = d.replace('sab', 'Sat');
                        d = d.replace('dom', 'Sun');

                        $(".date_15", newItem).html(d + ' ' + formatDate(res[1]));    
                    }else {
                        $(".date_15", newItem).html(val.state);  
                    }
                }else {
                    $(".date_15", newItem).html(val.state);
                }

                var symbols = val.symbol.split('-');
                if(symbols.length > 1) {
                    var local_symbol = symbols[0];
                    var away_symbol = symbols[1];
                    if(local_symbol == '0') {
                        $('#box_0_15_l', newItem).addClass('box_0_15_IMPRENTA').removeClass('.box_0_15');
                    } else if(local_symbol == '1') {
                        $('#box_1_15_l', newItem).addClass('box_1_15_IMPRENTA').removeClass('.box_1_15');
                    } else if(local_symbol == '2') {
                        $('#box_2_15_l', newItem).addClass('box_2_15_IMPRENTA').removeClass('.box_2_15');
                    } else if(local_symbol == 'M') {
                        $('#box_M_15_l', newItem).addClass('box_M_15_IMPRENTA').removeClass('.box_M_15');
                    }

                    if(away_symbol == '0') {
                        $('#box_0_15_a', newItem).addClass('box_0_15_IMPRENTA').removeClass('.box_0_15');
                    } else if(away_symbol == '1') {
                        $('#box_1_15_a', newItem).addClass('box_1_15_IMPRENTA').removeClass('.box_1_15');
                    } else if(away_symbol == '2') {
                        $('#box_2_15_a', newItem).addClass('box_2_15_IMPRENTA').removeClass('.box_2_15');
                    } else if(away_symbol == 'M') {
                        $('#box_M_15_a', newItem).addClass('box_M_15_IMPRENTA').removeClass('.box_M_15');
                    }
                }
                
            }
            
            $('div#laquiniela').append(newItem);
        });
    });
};

var loadPremiosQuiniela = function(){
    var url = App.filePath + App.config.QuinielaActualRound; // DESCOMENTAR PARA PRODUCCION
	//var url = 'http://lfpdata.static.interactivecdn.com.s3.amazonaws.com/data/quiniela/rounds/round_1.json'; //Para que no salga vacía la lista. COMENTAR PARA PRODUCCION
    var $last = $('#premiosList li.template');
    $('ul#premiosList li:not(.template)').remove();
    getRequestUrl(url, function(data){
        if(data['escrutinio'].length > 0) {
            $.each(data['escrutinio'], function(key, val) {
                var newItem = $last.clone().removeClass('template').attr('id', val.winners);
                $('#premiosList').append('<li class="divider" data-role="list-divider"><span>' + val.type + '</span></li>');
                $(".premios_acertantes span.acertantes_span", newItem).html(val.winners);
                $(".premios_cantidad span.premios_span", newItem).html(val.award);
                $('#premiosList').append(newItem);
                
                $('.no_data').hide();
                $('#premiosList *').show();
            });
        } else {
            $('.no_data').show();
        }
    });
};


var loadPronosticos = function(){
    var url = App.filePath + App.config.URLSportiumMatches;
    var $last = $('#pronosticosList li.template');
    var datesSportium = [];
    var $last = $('#pronosticosList li.template');
    $('ul#pronosticosList li:not(.template)').remove();
    getRequestUrl(url, function(data){
        $.each(data.xml.matches.match, function(key, val) {
            var newItem = $last.clone().removeClass('template').attr('id', val.id_partido);
            if ($.inArray(val.date, datesSportium) < 0) {
                datesSportium.push(val.date);
                
                
                    var dd = new Date( val.date.replace( /(\d{2})-(\d{2})-(\d{4})/, "$1/$2/$3") );
                    $('#pronosticosList').append("<li class='sportiumDivider' data-role='list-divider'><span>" + days[dd.getDay()] + ' ' + val.date + "</span></li>");
                
            };
    	    //$(".pronosticos_date", newItem).html(val.date);
    	    $(".pronosticos_local_name", newItem).html(val.local_team);

            $(".pronosticos_icon_local", newItem).attr('src', App.config.URLS3ShieldsLow.replace('%@', val.local_team_slug));
            $(".pronosticos_icon_away", newItem).attr('src', App.config.URLS3ShieldsLow.replace('%@', val.away_team_slug));

    	    if(document.webL10n.getLanguage().contains("en")){
    	       $(".pronosticos_hour", newItem).html(formatDate(val.hour));
    	    } else {
                $(".pronosticos_hour", newItem).html(val.hour);
            }
    	    $(".pronosticos_away_name", newItem).html(val.away_team);

            $(".pronosticosLink", newItem).attr('href', val.link);
    	    
            if(val.valor_1 != null && val.valor_x != null && val.valor_2 != null && val.valor_1 != "" && val.valor_x != "" && val.valor_2 != ""){
                $(".pronosticos_1", newItem).html('<font color="red">1: </font>' + val.valor_1 + ' €');
                $(".pronosticos_x", newItem).html('<font color="red">x: </font>' + val.valor_x + ' €');
                $(".pronosticos_2", newItem).html('<font color="red">2: </font>' + val.valor_2 + ' €');
                if(App.config.SportiumValorText != null){
                    $(".type_sportium").show;
                    $(".type_sportium", newItem).html(App.config.SportiumValorText);
                }else{
                    $(".type_sportium").hide();
                    $(".type_sportium", newItem).html('');
                }
            }
            else if(val.market_40_1 != null && val.market_40_x != null && val.market_40_2 != null && val.market_40_1 != "" && val.market_40_x != "" && val.market_40_2 != ""){
                $(".pronosticos_1", newItem).html('<font color="red">1: </font>' + val.market_40_1 + ' €');
                $(".pronosticos_x", newItem).html('<font color="red">x: </font>' + val.market_40_x + ' €');
                $(".pronosticos_2", newItem).html('<font color="red">2: </font>' + val.market_40_2 + ' €');
                if(App.config.SportiumMarket40Text != null){
                    $(".type_sportium").show;
                    $(".type_sportium", newItem).html(App.config.SportiumMarket40Text);
                }else{
                    $(".type_sportium").hide();
                    $(".type_sportium", newItem).html('');
                }
            }
            else if(val.market_46_si != null && val.market_46_no != null && val.market_46_si != "" && val.market_46_no != ""){
                $(".pronosticos_1", newItem).html('<font color="red">Sí: </font>' + val.market_46_si + ' €');
                $(".pronosticos_2", newItem).html('<font color="red">No: </font>' + val.market_46_no + ' €');
                 if(App.config.SportiumMarket46Text != null){
                    $(".type_sportium").show;
                    $(".type_sportium", newItem).html(App.config.SportiumMarket46Text);
                }else{
                    $(".type_sportium").hide();
                    $(".type_sportium", newItem).html('');
                }
            }
            else if(val.market_245_par != null && val.market_245_impar != null && val.market_245_par != "" && val.market_245_impar != ""){
                $(".pronosticos_1", newItem).html('<font color="red">Par: </font>' + val.market_245_par + ' €');
                $(".pronosticos_2", newItem).html('<font color="red">Impar: </font>' + val.market_245_impar + ' €');
                 if(App.config.SportiumMarket245Text != null){
                    $(".type_sportium").show;
                    $(".type_sportium", newItem).html(App.config.SportiumMarket245Text);
                }else{
                    $(".type_sportium").hide();
                    $(".type_sportium", newItem).html('');
                }
            }
            else if(val.market_375_1 != null && val.market_375_ninguno != null && val.market_375_2 != null && val.market_375_1 != "" && val.market_375_ninguno != "" && val.market_375_2 != ""){
                $(".pronosticos_1", newItem).html('<font color="red">1: </font>' + val.market_375_1 + ' €');
                $(".pronosticos_x", newItem).html('<font color="red">Ninguno: </font>' + val.market_375_ninguno + ' €');
                $(".pronosticos_2", newItem).html('<font color="red">2: </font>' + val.market_375_2 + ' €');
                 if(App.config.SportiumMarket375Text != null){
                    $(".type_sportium").show;
                    $(".type_sportium", newItem).html(App.config.SportiumMarket375Text);
                }else{
                    $(".type_sportium").hide();
                    $(".type_sportium", newItem).html('');
                }
            }
            else if(val.market_380_1 != null && val.market_380_ninguno != null && val.market_380_2 != null && val.market_380_1 != "" && val.market_380_ninguno != "" && val.market_380_2 != ""){
                $(".pronosticos_1", newItem).html('<font color="red">1: </font>' + val.market_380_1 + ' €');
                $(".pronosticos_x", newItem).html('<font color="red">Ninguno: </font>' + val.market_380_ninguno + ' €');
                $(".pronosticos_2", newItem).html('<font color="red">2: </font>' + val.market_380_2 + ' €');
                 if(App.config.SportiumMarket380Text != null){
                    $(".type_sportium").show;
                    $(".type_sportium", newItem).html(App.config.SportiumMarket380Text);
                }else{
                    $(".type_sportium").hide();
                    $(".type_sportium", newItem).html('');
                }
            }

            $('#pronosticosList').append(newItem);
        });
    });
};


var menuStatus;
    var show = function() {
        if(menuStatus) {
            return;
        }
        $('#menu').show();
        $.mobile.activePage.animate({
            marginLeft: "165px",
        }, 0, function () {
            menuStatus = true
        });
        $('.header-fixed').animate({
            marginLeft: "165px",
        }, 0, function () {
            menuStatus = true
        });
    };
    var hide = function() {
        if(!menuStatus) {
            return;
        }
        $.mobile.activePage.animate({
            marginLeft: "0px",
        }, 0, function () {
            menuStatus = false
            $('#menu').hide();
        });
         $('.header-fixed').animate({
            marginLeft: "0px",
        }, 0, function () {
            menuStatus = false
        });
    };
    var toggle = function() {
        if (!menuStatus) {
            show();
            $('div#transparent').show();
        } else {
            hide();
            $('div#transparent').hide();
        }
        return false;
    };


$('#reloadAjax').click(function(){
    getRequestUrl(App.configUrl, function(data){
        //Load config LFP
        App.config = data;
        //Load competition selector
        loadCompetitionSelector();
        App.currentCompetitionId = App.config.competitions[0].id;
        //Load active rounds
        loadCurrentDataFromCompetition();
        
        $('a#matchesSelectorCompetitionsBtn').addClass('ui-btn-active');

        // window.setInterval(function(){
        //     loadPronosticos();
        //     loadClassification();

        // if(App.round_selected != 0){
        //     loadMatches(App.currentCompetitionId, App.round_selected);
        // }
        // else {
        //      loadMatches(App.currentCompetitionId, App.currentRoundId);
        // }

    
// }, App.config.RefreshMatchesTime * 1000);


    });
});


function refreshPage() {
  jQuery.mobile.pageContainer.pagecontainer('change', window.location.href, {
    allowSamePageTransition: true,
    transition: 'none',
    reloadPage: true 
    // 'reload' parameter not working yet: //github.com/jquery/jquery-mobile/issues/7406
  });
}

// Show/hide the menu
$("a.showMenu").click(toggle);

// Menu behaviour
$("#menu li a").click(function () {
    hide();
    if($(this).attr('id') == 'home') {
        loadRounds(function(){});
        if($('#classification').css('display') == 'block') {
            $('#classificationSelectorCompetitionsBtn').addClass('ui-btn-active');
        } else {
            $('#matchesSelectorCompetitionsBtn').addClass('ui-btn-active');
        }
    }else if($(this).attr('id') == 'goals') {
        loadGoals();
    }else if($(this).attr('id') == 'news') {
        loadNews();
    }else if($(this).attr('id') == 'images') {
        loadImages();
    }else if($(this).attr('id') == 'teams') {
        loadTeams();
    }else if($(this).attr('id') == 'quiniela') {
        loadQuiniela();
    }else if($(this).attr('id') == 'pronosticos') {
        loadPronosticos();
    }
    var p = $(this).parent();
    p.siblings().removeClass('active');
    p.addClass('active');
    $('div#transparent').hide();
});

});
$.mobile.paramsHandler.init();


var isLoading = false;
function progressBar(isShow) {
    if (isShow) {
        isLoading = true;
        $('#progressBar').show();
        window.setTimeout(function(){
            $('#progressBar').hide();
            if(isLoading) {
                connnectionNotAvailable(true);
            }
        }, 10000);
    } else {
        isLoading = false;
        $('#progressBar').hide();
    }
}


function connnectionNotAvailable(isShow) {
    if (isShow) {
        $('#connectionNotAvailable').show();
    } else {
        $('#connectionNotAvailable').hide();
    }
}


