//molarity
function GetUnit(value,ndec)
{
	var factor=Math.pow(10,ndec)
	if (value < 1e-9)
	{return "-12";}
	else  if (value < 1e-6)
	{return "-9";}
	else if (value < 1e-3)
	{return "-6";}
	else if (value < 1)
	{return "-3";}
	else
	{return "0";}
}

function FormatAmount(value,ndec)
{
	var factor=Math.pow(10,ndec)
	if (value < 1e-9)
	{return( Math.round((value/1e-12)*factor)/factor);}
	else  if (value < 1e-6)
	{return( Math.round((value/1e-9)*factor)/factor);}
	else if (value < 1e-3)
	{return( Math.round((value/1e-6)*factor)/factor);}
	else if (value < 1)
	{return( Math.round((value/1e-3)*factor)/factor);}
	else
	{return(Math.round((value)*factor)/factor);}
}

function CalculateMolarity(form)
{
	if(form.MolWt.value == "")
	{
		alert("Please enter a value for the Molecular Weight");
	}
	else if(form.MassUn.value < -6)
	{
		alert("Cannot use this unit of mass for this calculation");
	}
	else
	{
		var MassUn 	= parseInt(form.MassUn.value);
		var ConcUn 	= parseInt(form.ConcUn.value);
		var VolUn 	= parseInt(form.VolUn.value);
		var MolWt   = parseFloat(form.MolWt.value);

		if(form.mass.value != '')
		{
			var mass = parseFloat(form.mass.value) * Math.pow(10,MassUn);
		}

		if(form.concentration.value != '')
		{
			var conc = parseFloat(form.concentration.value) * Math.pow(10,ConcUn);
		}

		if(form.volume.value != '')
		{
			var vol = parseFloat(form.volume.value) * Math.pow(10,VolUn);
		}

		if(form.concentration.value == '')
		{
			if((form.volume.value != '') && (form.mass.value != ''))
			{
				var moles = mass / MolWt;
				var conc = moles / vol;
				form.concentration.value = FormatAmount(conc,4);
				form.ConcUn.value = GetUnit(conc,4);
			}
			else
			{
				alert("Not enough information to perform the calculation");
			}
		}
		else if(form.volume.value == '')
		{
			if((form.concentration.value != '') && (form.mass.value != ''))
			{
				var moles = mass / MolWt;
				var vol = moles / conc;
				form.volume.value = FormatAmount(vol,4);
				form.VolUn.value = GetUnit(vol,4);
			}
			else
			{
				alert("Not enough information to perform the calculation");
			}
		}
		else
		{
			if((form.concentration.value != '') && (form.volume.value != ''))
			{
				var moles = vol * conc;
				var mass = moles * MolWt;
				form.mass.value = FormatAmount(mass,4);
				form.MassUn.value = GetUnit(mass,4);
			}
			else
			{
				alert("Not enough information to perform the calculation");
			}
		}
	}
}
function clearMolarity(){
	jQuery('#mass').val('');
	jQuery('#concentration').val('');
	jQuery('#volume').val('');
	jQuery('#MolWt').val('');
var myselect1 = $("select#MassUn");
	myselect1[0].selectedIndex = 3;
	myselect1.selectmenu("refresh");
	
	var myselect2 = $("select#ConcUn");
	myselect2[0].selectedIndex = 4;
	myselect2.selectmenu("refresh");
	
	var myselect2 = $("select#VolUn");
	myselect2[0].selectedIndex = 2;
	myselect2.selectmenu("refresh");
}
//usage
function clearUsage(){
	jQuery('#startingConc').val('');
	jQuery('#desiredVol').val('');
	jQuery('#desiredVolTest').val('100');
	jQuery('#startingConcUnits').val('ug');
	jQuery('#usageResult').html('');
var myselect1 = $("select#startingConcUnits");
	myselect1[0].selectedIndex = 0;
	myselect1.selectmenu("refresh");
}
function calculateUsage(){
var startingConcentration = jQuery('#startingConc').val();	
var startingMicrogramTest = jQuery('#desiredVol').val();	
var startingDesiredVolumeTest = jQuery('#desiredVolTest').val();
var startingConcentrationUnits = jQuery('#startingConcUnits').val();	
var calculationUsage = ((startingMicrogramTest / startingConcentration) * 1000);
if(startingConcentrationUnits == 'mg'){
	calculationUsage = calculationUsage / 1000;
}
else{
	calculationUsage = calculationUsage * 1;
}
if(	startingConcentration == ''){
alert('Please Enter a Starting Concentration');
	startingConc.focus;
}
if(	startingMicrogramTest == ''){
alert('Please Enter the Desired &micro;g/Test');
	startingConc.focus;
}
if(	startingDesiredVolumeTest == ''){
alert('Please Enter the Desired Volume/Test ');
	startingConc.focus;
}
jQuery('#usageResult').html('Add '+ calculationUsage + '&micro;l of antibody to your total ' + startingDesiredVolumeTest + '&micro;l staining volume');
}


//grams and moles	
function calculateMolesandMass(){
if(jQuery('#formweightinput').val() == "")
	{
		alert("Please enter a value for the Molecular Weight");
	}
	else{
	var MassInput = parseInt(jQuery('#UnitsOfMass').val());
	var MolesInput 	= parseInt(jQuery('#UnitsOfMoles').val());
	var formweightinput = parseInt(jQuery('#formweightinput').val());	
	var massInput = jQuery('#massinput').val();
	var molesinput = jQuery('#molesinput').val();
	var factoring = 1;
	var unitDiff = MassInput - MolesInput;
	if(unitDiff == 0){
	if(massInput == ''){
	var massCalc = (molesinput * formweightinput);
	jQuery('#massinput').val(massCalc);
	}
	else{
	var molCalc = (massInput / formweightinput);
	jQuery('#molesinput').val(molCalc);	
	}	
	}
	
		//offest 1
	else if(unitDiff == -3){
	if(massInput == ''){
	//	alert('mass less than moles x 1');
	var massCalc = (molesinput * formweightinput) * 1000;
	
	jQuery('#massinput').val(massCalc);
	}
	else{
	//	alert('mass less than moles x 1');
	var molCalc = (massInput / formweightinput);
	molCalc = molCalc / 1000;
	
	jQuery('#molesinput').val(molCalc);	
	}	
	}
	
	else if(unitDiff == 3){
		if(massInput == ''){
	//	alert('mass greater than moles x 1');
	var massCalc = (molesinput * formweightinput) / 1000;
	
	jQuery('#massinput').val(massCalc);
	}
	else{
	//	alert('mass greater than moles x 1');
	var molCalc = (massInput / formweightinput);
	molCalc = molCalc * 1000;
	
	jQuery('#molesinput').val(molCalc);	
	}		
	}
	//offest 2
	else if(unitDiff == -6){
	if(massInput == ''){
	//	alert('mass less than moles x 2');
	var massCalc = (molesinput * formweightinput) * 1000000;
	
	jQuery('#massinput').val(massCalc);
	}
	else{
	//	alert('mass less than moles x 2');
	var molCalc = (massInput / formweightinput);
	molCalc = molCalc / 1000000;
	
	jQuery('#molesinput').val(molCalc);	
	}	
	}
	
	else if(unitDiff == 6){
		if(massInput == ''){
	//	alert('mass greater than moles x 2');
	var massCalc = (molesinput * formweightinput) / 1000000;
	
	jQuery('#massinput').val(massCalc);
	}
	else{
	//	alert('mass greater than moles x 2');
	var molCalc = (massInput / formweightinput);
	molCalc = molCalc * 1000000;
	
	jQuery('#molesinput').val(molCalc);	
	}		
	}
	//offest 3
	else if(unitDiff == -9){
	if(massInput == ''){
	//	alert('mass less than moles x 3');
	var massCalc = (molesinput * formweightinput) * 1000000000;
	
	jQuery('#massinput').val(massCalc);
	}
	else{
	//	alert('mass less than moles x 3');
	var molCalc = (massInput / formweightinput);
	molCalc = molCalc / 1000000000;
	
	jQuery('#molesinput').val(molCalc);	
	}	
	}
	
	else if(unitDiff == 9){
		if(massInput == ''){
	//	alert('mass greater than moles x 3');
	var massCalc = (molesinput * formweightinput) / 1000000000;
	
	jQuery('#massinput').val(massCalc);
	}
	else{
	//	alert('mass greater than moles x 3');
	var molCalc = (massInput / formweightinput);
	molCalc = molCalc * 1000000000;
	
	jQuery('#molesinput').val(molCalc);	
	}		
	}
	//offest 4
	else if(unitDiff == -12){
	if(massInput == ''){
	//	alert('mass less than moles x 4');
	var massCalc = (molesinput * formweightinput) * 1000000000000;
	
	jQuery('#massinput').val(massCalc);
	}
	else{
	//	alert('mass less than moles x 4');
	var molCalc = (massInput / formweightinput);
	molCalc = molCalc / 1000000000000;
	
	jQuery('#molesinput').val(molCalc);	
	}	
	}
	else if(unitDiff == 12){
		if(massInput == ''){
	//	alert('mass greater than moles x 4');
	var massCalc = (molesinput * formweightinput) / 1000000000000;
	
	jQuery('#massinput').val(massCalc);
	}
	else{
	//	alert('mass greater than moles x 4');
	var molCalc = (massInput / formweightinput);
	molCalc = molCalc * 1000000000000;
	
	jQuery('#molesinput').val(molCalc);	
	}		
	}
	//offest 5
	else if(unitDiff == -15){
	if(massInput == ''){
	//	alert('mass less than moles x 5');
	var massCalc = (molesinput * formweightinput) * 1000000000000000;
	
	jQuery('#massinput').val(massCalc);
	}
	else{
	//	alert('mass less than moles x 5');
	var molCalc = (massInput / formweightinput);
	molCalc = molCalc / 1000000000000000;
	
	jQuery('#molesinput').val(molCalc);	
	}	
	}
	else if(unitDiff == 15){
		if(massInput == ''){
	//	alert('mass greater than moles x 5');
	var massCalc = (molesinput * formweightinput) / 1000000000000000;
	
	jQuery('#massinput').val(massCalc);
	}
	else{
	//	alert('mass greater than moles x 5');
	var molCalc = (massInput / formweightinput);
	molCalc = molCalc * 1000000000000000;
	
	jQuery('#molesinput').val(molCalc);	
	}		
	}
	}
}
jQuery(document).ready(function(){
  var sel = jQuery("#UnitsOfMass");
  sel.data("prev",sel.val());
  sel.change(function(data){
  var jqThis = jQuery(this);
  //alert(jqThis.data("prev"));
  var cursel = parseInt(jQuery("#UnitsOfMass").val());
  var presel = parseInt(jqThis.data("prev"));
  var calcsel = cursel - presel;
  var inputMass = jQuery('#massinput').val();
  if(calcsel == -3){
	var newMass = inputMass * .001; 
	jQuery('#massinput').val(parseFloat(newMass.toPrecision(2)));  
  }
  else if(calcsel == 3){
	  var newMass = inputMass * 1000; 
	jQuery('#massinput').val(parseFloat(newMass.toPrecision(2)));  
  }
   else if(calcsel == -6){
	var newMass = inputMass * .000001; 
	jQuery('#massinput').val(parseFloat(newMass.toPrecision(2)));  
  }
  else if(calcsel == 6){
	  var newMass = inputMass * 1000000; 
	jQuery('#massinput').val(parseFloat(newMass.toPrecision(2)));  
  }
   else if(calcsel == -9){
	var newMass = inputMass * .000000001; 
	jQuery('#massinput').val(parseFloat(newMass.toPrecision(2)));  
  }
  else if(calcsel == 9){
	  var newMass = inputMass * 1000000000; 
	jQuery('#massinput').val(parseFloat(newMass.toPrecision(2)));  
  }
   else if(calcsel == -12){
	var newMass = inputMass * .000000000001; 
	jQuery('#massinput').val(parseFloat(newMass.toPrecision(2)));  
  }
  else if(calcsel == 12){
	  var newMass = inputMass * 1000000000000; 
	jQuery('#massinput').val(parseFloat(newMass.toPrecision(2)));  
  }
  else if(calcsel == -15){
	var newMass = inputMass * .000000000000001; 
	jQuery('#massinput').val(parseFloat(newMass.toPrecision(2)));  
  }
  else if(calcsel == 15){
	  var newMass = inputMass * 1000000000000000; 
	jQuery('#massinput').val(parseFloat(newMass.toPrecision(2)));  
  }
  else{
	jQuery('#massinput').val(0);  
  }
  //alert(calcsel);
  jqThis.data("prev",jqThis.val());
  });
});

jQuery(document).ready(function(){
  var selm = jQuery("#UnitsOfMoles");
  selm.data("prev",selm.val());
  selm.change(function(data){

  var jqThis2 = jQuery(this);
  //alert(jqThis.data("prev"));
  var curselm = parseInt(jQuery("#UnitsOfMoles").val());
  var preselm = parseInt(jqThis2.data("prev"));
  var calcselm = curselm - preselm;
  var inputMole = jQuery('#molesinput').val();
  if(calcselm == -3){
	var newMole = inputMole * .001; 
	jQuery('#molesinput').val(parseFloat(newMole.toPrecision(2)));  
  }
  else if(calcselm == 3){
	  var newMole = inputMole * 1000; 
	jQuery('#molesinput').val(parseFloat(newMole.toPrecision(2)));  
  }
   else if(calcselm == -6){
	var newMole = inputMole * .000001; 
	jQuery('#molesinput').val(parseFloat(newMole.toPrecision(2)));  
  }
  else if(calcselm == 6){
	  var newMole = inputMole * 1000000; 
	jQuery('#molesinput').val(parseFloat(newMole.toPrecision(2)));  
  }
   else if(calcselm == -9){
	var newMole = inputMole * .000000001; 
	jQuery('#molesinput').val(parseFloat(newMole.toPrecision(2)));  
  }
  else if(calcselm == 9){
	  var newMole = inputMole * 1000000000; 
	jQuery('#molesinput').val(parseFloat(newMole.toPrecision(2)));  
  }
   else if(calcselm == -12){
	var newMole = inputMole * .000000000001; 
	jQuery('#molesinput').val(parseFloat(newMole.toPrecision(2)));  
  }
  else if(calcselm == 12){
	  var newMole = inputMole * 1000000000000; 
	jQuery('#molesinput').val(parseFloat(newMole.toPrecision(2)));  
  }
  else if(calcselm == -15){
	var newMole = inputMole * .000000000000001; 
	jQuery('#molesinput').val(parseFloat(newMole.toPrecision(2)));  
  }
  else if(calcselm == 15){
	  var newMole = inputMole * 1000000000000000; 
	jQuery('#molesinput').val(parseFloat(newMole.toPrecision(2)));  
  }
  else{
	jQuery('#molesinput').val(0);  
  }
  //alert(calcsel);
  jqThis2.data("prev",jqThis2.val());
  });
});

function clearMolesandMass(){	
	jQuery('#massinput').val('');
	jQuery('#formweightinput').val('1');
	jQuery('#molesinput').val('');
var myselect1 = $("select#UnitsOfMass");
	myselect1[0].selectedIndex = 5;
	myselect1.selectmenu("refresh");
	
	var myselect2 = $("select#UnitsOfMoles");
	myselect2[0].selectedIndex = 5;
	myselect2.selectmenu("refresh");
}
function clearMoles(){	
	jQuery('#molesinput').val('');
}
function clearMass(){	
	jQuery('#massinput').val('');
}

//ED50

function calculateED(){
	var calculatedED = '';
	calculatedED = 1000000/jQuery('#Activity').val();
	jQuery('#ED').val(calculatedED);
	
}
function calculateActivity(){
	var calculatedActivity = '';
	calculatedActivity = 1000000/jQuery('#ED').val();
	jQuery('#Activity').val(calculatedActivity);
}

//g

function calculateGForce(){
	
	var radius = jQuery('#Radius').val();
	var rpm = jQuery('#RPM').val();
	if(radius == ''){
		
	alert('Please Enter a Radius');	
	
	}
	else{
		
	var gforce = (Math.round (1.12*radius*(rpm*rpm/1000000) * 100))/100;
	jQuery('#Gforce').val(gforce.toFixed(1));
}
}

function calculateRPM(){
	var radius = jQuery('#Radius').val();
	var gforce = jQuery('#Gforce').val();
	if(radius == ''){
	
	alert('Please Enter a Radius');	
	
	}
	else{
	var rpm = Math.round (Math.sqrt(gforce*1000000/(1.12*radius)));
	jQuery('#RPM').val(rpm.toFixed(1));
}
}

function requireRadius(){
	var radius = jQuery('#Radius').val();
	if(radius == ''){
	
	alert('Please Enter a Radius');	
	
	}
	else{
		calculateRPM();
		calculateGForce();
	}
}
function clearg(){
	jQuery('#Radius').val('');
	jQuery('#Gforce').val('');
	jQuery('#RPM').val('');
	jQuery( '#Radius' ).focus();
}

//dilution
function CalcDilute(erase)
{
	jQuery('#' + erase).val('');
	var ConcUnitsFinal = parseInt(jQuery('#ConcUnitsFinal').val());
	var ConcUnitsStart = parseInt(jQuery('#ConcUnitsStart').val());
	var VolUnitsFinal = parseInt(jQuery('#VolUnitsFinal').val());
	var VolUnitsStart = parseInt(jQuery('#VolUnitsStart').val());
	var finalconc = parseFloat(jQuery('#concentrationFinal').val()) * Math.pow(10,ConcUnitsFinal);
	var startconc = parseFloat(jQuery('#concentrationStart').val()) * Math.pow(10,ConcUnitsStart);
	var finalvolume = parseFloat(jQuery('#volumeFinal').val()) * Math.pow(10,VolUnitsFinal);
	var startvolume = parseFloat(jQuery('#volumeStart').val()) * Math.pow(10,VolUnitsStart);
	
	var VolNeeded = finalconc/startconc * finalvolume;
	var ConcNeeded = finalvolume/startvolume * finalconc;
	var ConcFinal = startvolume/finalvolume * startconc;
	var VolFinal = startconc/finalconc * startvolume;
	
	if (finalconc > startconc && jQuery('#concentrationFinal').val() != '')
	{
		jQuery('#volumeStart').val("Not possible.");
		alert('The Final Concentration cannot be larger than the Starting Concentration');
	}
	else if (finalvolume > startvolume && jQuery('#volumeFinal').val() != '')
	{
		jQuery('#concentrationStart').val("Not possible.");
		alert('The Final Volume cannot be larger than the Starting Volume');
	}
	else if(jQuery('#volumeFinal').val() != '' && jQuery('#concentrationStart').val() != '' && jQuery('#concentrationFinal').val() != '')
	{
		jQuery('#volumeStart').val(FormatAmount(VolNeeded,4));
		jQuery('#VolUnitsStart').val(GetUnit(VolNeeded,4));
  	}
	else if(jQuery('#volumeStart').val() != '' && jQuery('#concentrationStart').val() != '' && jQuery('#concentrationFinal').val() != '')
	{
		jQuery('#volumeFinal').val(FormatAmount(VolFinal,4));
		jQuery('#VolUnitsFinal').val(GetUnit(VolFinal,4));
  	}
	else if(jQuery('#volumeFinal').val() != '' && jQuery('#volumeStart').val() != '' && jQuery('#concentrationFinal').val() != '')
	{
		jQuery('#concentrationStart').val(FormatAmount(ConcNeeded,4));
		jQuery('#ConcUnitsStart').val(GetUnit(ConcNeeded,4));
  	}
	else if(jQuery('#volumeFinal').val() != '' && jQuery('#concentrationStart').val() != '' && jQuery('#volumeStart').val() != '')
	{
		jQuery('#concentrationFinal').val(FormatAmount(ConcFinal,4));
		jQuery('#ConcUnitsFinal').val(GetUnit(ConcFinal,4));
  	}
	else{
		
	}
}

function FormatAmount(value,ndec)
{
	var factor=Math.pow(10,ndec)
	if (value < 1e-15)
	{return( Math.round((value/1e-18)*factor)/factor);}
	else if (value < 1e-12)
	{return( Math.round((value/1e-15)*factor)/factor);}
	else if (value < 1e-9)
	{return( Math.round((value/1e-12)*factor)/factor);}
	else  if (value < 1e-6)
	{return( Math.round((value/1e-9)*factor)/factor);}
	else if (value < 1e-3)
	{return( Math.round((value/1e-6)*factor)/factor);}
	else if (value < 1)
	{return( Math.round((value/1e-3)*factor)/factor);}
	else
	{return(Math.round((value)*factor)/factor);}
}

function GetUnit(value,ndec)
{
	var factor=Math.pow(10,ndec)
	if (value < 1e-9)
	{return "-12";}
	else  if (value < 1e-6)
	{return "-9";}
	else if (value < 1e-3)
	{return "-6";}
	else if (value < 1)
	{return "-3";}
	else
	{return "0";}
}

function clearDilution(){
	jQuery('#concentrationStart').val('');
	jQuery('#volumeStart').val('');
	jQuery('#concentrationFinal').val('');
	jQuery('#volumeFinal').val('');
	jQuery('#ConcUnitsStart').val('-3');
	jQuery('#VolUnitsStart').val('-3');
	jQuery('#ConcUnitsFinal').val('-3');
	jQuery('#VolUnitsFinal').val('-3');
var myselect1 = $("select#ConcUnitsStart");
	myselect1[0].selectedIndex = 4;
	myselect1.selectmenu("refresh");
	
	var myselect2 = $("select#VolUnitsStart");
	myselect2[0].selectedIndex = 4;
	myselect2.selectmenu("refresh");
	
	var myselect3 = $("select#ConcUnitsFinal");
	myselect3[0].selectedIndex = 4;
	myselect3.selectmenu("refresh");
	
	var myselect4 = $("select#VolUnitsFinal");
	myselect4[0].selectedIndex = 1;
	myselect4.selectmenu("refresh");
}
//metric to standard
function calculateStandard(){
	var standardUnits = jQuery('#standardUnits').val();
	var metricUnits = jQuery('#metricUnits').val();
	var metricVal = jQuery('#metricVal').val();
	
	if(standardUnits == 'inches' && metricUnits == 'millimeters'){
	jQuery('#standardVal').val(metricVal * 0.0393700787);	
	}
	else if(standardUnits == 'inches' && metricUnits == 'centimeters'){
	jQuery('#standardVal').val(metricVal * 0.393700787);	
	}
	else if(standardUnits == 'inches' && metricUnits == 'meters'){
	jQuery('#standardVal').val(metricVal * 39.3700787);	
	}
	else if(standardUnits == 'inches' && metricUnits == 'kilometers'){
	jQuery('#standardVal').val(metricVal * 39370.0787);	
	}
	else if(standardUnits == 'feet' && metricUnits == 'millimeters'){
	jQuery('#standardVal').val(metricVal * 0.0032808399);	
	}
	else if(standardUnits == 'feet' && metricUnits == 'centimeters'){
	jQuery('#standardVal').val(metricVal * 0.032808399);	
	}
	else if(standardUnits == 'feet' && metricUnits == 'meters'){
	jQuery('#standardVal').val(metricVal * 3.2808399);	
	}
	else if(standardUnits == 'feet' && metricUnits == 'kilometers'){
	jQuery('#standardVal').val(metricVal * 3280.8399);	
	}
	else if(standardUnits == 'yards' && metricUnits == 'millimeters'){
	jQuery('#standardVal').val(metricVal * 0.0010936133);	
	}
	else if(standardUnits == 'yards' && metricUnits == 'centimeters'){
	jQuery('#standardVal').val(metricVal * 0.010936133);	
	}
	else if(standardUnits == 'yards' && metricUnits == 'meters'){
	jQuery('#standardVal').val(metricVal * 1.0936133);	
	}
	else if(standardUnits == 'yards' && metricUnits == 'kilometers'){
	jQuery('#standardVal').val(metricVal * 1093.6133);	
	}	
	else if(standardUnits == 'miles' && metricUnits == 'millimeters'){
	jQuery('#standardVal').val(metricVal * 0.000000621371192);	
	}
	else if(standardUnits == 'miles' && metricUnits == 'centimeters'){
	jQuery('#standardVal').val(metricVal * 0.000006213711921);	
	}
	else if(standardUnits == 'miles' && metricUnits == 'meters'){
	jQuery('#standardVal').val(metricVal * 0.000621371192);	
	}
	else if(standardUnits == 'miles' && metricUnits == 'kilometers'){
	jQuery('#standardVal').val(metricVal * 0.621371192);	
	}
	else{
	}
}

function calculateMetric(){
	var standardUnits = jQuery('#standardUnits').val();
	var metricUnits = jQuery('#metricUnits').val();
	var standardVal = jQuery('#standardVal').val();
	
	if(standardUnits == 'inches' && metricUnits == 'millimeters'){
	jQuery('#metricVal').val(standardVal * 25.4);	
	}
	else if(standardUnits == 'inches' && metricUnits == 'centimeters'){
	jQuery('#metricVal').val(standardVal * 2.54);	
	}
	else if(standardUnits == 'inches' && metricUnits == 'meters'){
	jQuery('#metricVal').val(standardVal * 0.0254);	
	}
	else if(standardUnits == 'inches' && metricUnits == 'kilometers'){
	jQuery('#metricVal').val(standardVal * 0.0000254);	
	}
	else if(standardUnits == 'feet' && metricUnits == 'millimeters'){
	jQuery('#metricVal').val(standardVal * 304.8);	
	}
	else if(standardUnits == 'feet' && metricUnits == 'centimeters'){
	jQuery('#metricVal').val(standardVal * 30.48);	
	}
	else if(standardUnits == 'feet' && metricUnits == 'meters'){
	jQuery('#metricVal').val(standardVal * 0.3048);	
	}
	else if(standardUnits == 'feet' && metricUnits == 'kilometers'){
	jQuery('#metricVal').val(standardVal * 0.0003048);	
	}
	else if(standardUnits == 'yards' && metricUnits == 'millimeters'){
	jQuery('#metricVal').val(standardVal * 914.4);	
	}
	else if(standardUnits == 'yards' && metricUnits == 'centimeters'){
	jQuery('#metricVal').val(standardVal * 91.44);	
	}
	else if(standardUnits == 'yards' && metricUnits == 'meters'){
	jQuery('#metricVal').val(standardVal * 0.9144);	
	}
	else if(standardUnits == 'yards' && metricUnits == 'kilometers'){
	jQuery('#metricVal').val(standardVal * 0.0009144);	
	}	
	else if(standardUnits == 'miles' && metricUnits == 'millimeters'){
	jQuery('#metricVal').val(standardVal * 1609344);	
	}
	else if(standardUnits == 'miles' && metricUnits == 'centimeters'){
	jQuery('#metricVal').val(standardVal * 160934.4);	
	}
	else if(standardUnits == 'miles' && metricUnits == 'meters'){
	jQuery('#metricVal').val(standardVal * 1609.344);	
	}
	else if(standardUnits == 'miles' && metricUnits == 'kilometers'){
	jQuery('#metricVal').val(standardVal * 1.609344);	
	}
	else{
	}
}
function clearMetric(){
	var myselect = $("select#standardUnits");
	myselect[0].selectedIndex = 0;
	myselect.selectmenu("refresh");
	
	var myselect1 = $("select#metricUnits");
	myselect1[0].selectedIndex = 0;
	myselect1.selectmenu("refresh");

	jQuery('#standardVal').val('');
	jQuery('#metricVal').val('');
}

function calculateInches(){
	var inches = jQuery('#Inches').val();
	var feet = inches * 0.0833333333;
	var yards = inches * 0.0277777778;
	var miles = inches * 0.0000157828;
	jQuery('#Feet').val(feet);
	jQuery('#Yards').val(yards);
	jQuery('#Miles').val(miles);
	
}

function calculateFeet(){
	var feet = jQuery('#Feet').val();
	
	var inches = feet * 12;
	var yards = feet * 0.333333;
	var miles = feet * 0.000189394;
	
	jQuery('#Inches').val(inches);
	jQuery('#Yards').val(yards);
	jQuery('#Miles').val(miles)
	
}

function calculateYards(){
	var yards = jQuery('#Yards').val();
	
	var inches = yards * 36;
	var feet = yards * 3;
	var miles = yards * 0.000568182;
	
	jQuery('#Inches').val(inches);
	jQuery('#Feet').val(feet);
	jQuery('#Miles').val(miles);
}

function calculateMiles(){
	
	var miles = jQuery('#Miles').val();
	
	var inches = miles * 63360;
	var feet = miles * 5280;
	var yards = miles * 1760;
	
	jQuery('#Inches').val(inches);
	jQuery('#Feet').val(feet);
	jQuery('#Yards').val(yards);
	
}
function clearStandard(){
	jQuery('#Inches').val('63360');
	jQuery('#Feet').val('5280');
	jQuery('#Yards').val('1760');
	jQuery('#Miles').val('1');
	
}