
	
document.addEvent("domready", function() {

	var lanceTranslations = {
		"pt": {
			"Roll!": "Lançar!",
			"Save": "Salvar",
			"resulting": "resultou em",
			"of": "de",
			"Unknown": "Desconhecido",
			"Not Defined": "Não definido",
			"Confirm deletion of": "Confirma exclusão de",
			"Removed": "Removido",
			"Saved": "Salvo",
			"dice set": "lance de dados",
			"Suit": "Naipe",
			"spades": "Espadas",
			"hearts": "Copas",
			"diamonds": "Ouros",
			"clubs": "Paus",
			"Card": "Carta",
			"Card in Deck": "Carta do Baralho",
			"Ace": "Ás",
			"Jack": "Valete",
			"Queen": "Dama",
			"King": "Rei",
			"Joker": "Coringa",
			"Week Day": "Dia da Semana",
			"Sunday": "Domingo",
			"Monday": "Segunda-feira",
			"Tuesday": "Terça-feira",
			"Wednesday": "Quarta-feira",
			"Thursday": "Quinta-feira",
			"Friday": "Sexta-feira",
			"Saturday": "Sábado",
			"Month": "Mês",
			"January": "Janeiro",
			"February": "Fevereiro",
			"March": "Março",
			"April": "Abril",
			"May": "Maio",
			"June": "Junho",
			"July": "Julho",
			"August": "Agosto",
			"September": "Setembro",
			"October": "Outubro",
			"November": "Novembro",
			"December": "Dezembro",
			"Generate Name": "Gerar Nome",
			"Dice set saved!": "Lance de dados salvo!",
			"Change language?": "Mudar o idioma?",
			"Restart application to apply changes?": "Reiniciar aplicativo para aplicar mudanças?"
		}
	};
	var lanceLang = "";
	var _ = function(str) {
		if (DiceList.memory.language != "") {
			if (lanceTranslations[DiceList.memory.language])
				return lanceTranslations[DiceList.memory.language][str] || str;
		}
		return str;
	};

	var diceContainer = $("custom-dices");
	var diceRE = /^(\d+)d(\d+)$/;
    var lanceStorageKey = 'Lancelot';
    var specialSuits = ["spades", "hearts", "diamonds", "clubs"];
    var specialCards = ["Ace", "2", "3", "4", "5", "6", "7", "8", "9", "10", "Jack", "Queen", "King"];
    var specialWeekDays = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
    var specialMonths = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];

	function print_log(s) {
		var n = new Date();
		$("log-output").grab(
			new Element("li").appendText(n.getHours() + ":" + n.getMinutes() + ":" + n.getSeconds() + ": " + s),
			"top"
		);
	}

	function roll_one(sides, start_in_zero) {
		var db = Math.random();
		var r =  Math.ceil(db * 10000) % sides;
		if (start_in_zero)
			r++
		return r
	}

	function roll_dice(a, b) {
		var r = 0;
		for (var i = 0; i < a; i++) {
			r += roll_one(b, true);
		}
		print_log(a + "d" + b + " " +_("resulting") + " " + r);
		return r;
	}
	
	var actual_page = -1;
	
	function change_page(np) {
		if (np != actual_page) {
			if (actual_page != -1) {
				$(actual_page).fade("out");
				$(actual_page.replace("page", "link")).setStyle("display", "block");
			}
			actual_page = np;
			$(actual_page).fade("in");
			$(np.replace("page", "link")).setStyle("display", "none");
		}
	}

	var common_vowels = ["A", "E", "I", "O", "U"];
	var uncommon_vowels = ["AE", "AI", "AO", "AU", "EA", "EI", "EU", "IA", "IE", "IO", "IU", "OA", "OE", "OI", "OU", "UA", "UE", "UI"];
	var rare_vowels = ["EO",  "EE", "OO", "UO", "OW", "AUA", "AUE", "AUI"];
	var common_consonants = ["B", "C", "D", "F", "G", "J", "K", "L", "M", "N", "P", "R", "S", "T", "V", "W", "X", "Y", "Z"];
	var uncommon_consonants = ["BR", "BL", "CR", "CH", "CL", "DR", "DL", "FR", "FL", "GR", "GL", "KR","PR", "PH", "PL", "TR"];
	var rare_consonants = ["BY", "CY", "DY", "FY", "GY", "KY", "PY", "PHR", "PHY", "PHL", "VY"];
	var final_consonants = ["Z", "W", "S", "L", "R", "H", "K", "ST"];

	function random_name() {
		var letters = roll_one(6) + 3;
		var is_vowel = roll_one(2);
		var n = "";
		var kind = false;
		for (var i = 0; i < letters; i++) {
			if (is_vowel) {
				kind = roll_one(100);
				if (kind <= 3) {
					n += rare_vowels[roll_one(rare_vowels.length)];
				} else if (kind <= 20) {
					n += uncommon_vowels[roll_one(uncommon_vowels.length)];
				} else {
					n += common_vowels[roll_one(common_vowels.length)];
				}
			} else {
				if (i < (letters - 1)) {
					kind = roll_one(100);
					if (kind <= 3) {
						n += rare_consonants[roll_one(rare_consonants.length)];
					} else if (kind <= 20) {
						n += uncommon_consonants[roll_one(uncommon_consonants.length)];
					} else {
						n += common_consonants[roll_one(common_consonants.length)];
					}
				} else {
					n += final_consonants[roll_one(final_consonants.length)];
				}
			}
			is_vowel = ! is_vowel;
		}
		return n;
	}

    var DiceList = {
		memory: {
			dices: [],
			language: "",
			version: "1.0"
		},
		handlers: function() {

            $("roll-manual").addEvent("click", function() {
				$("roll-result").set('text', roll_dice(parseInt($("the-a").get("value")), parseInt($("the-b").get("value"))));
			});
			
            $("roll-save").addEvent("click", function() {
				DiceList.insert();
				alert(_("Dice set saved!"));
			});

            $$(".roll-special").addEvent("click", function() {
				$("special-result").set("text", DiceList.rollSpecial(this.get("id")));
			});
			
			$("flag").addEvent("click", function() {
				var nl = (DiceList.memory.language == "") ? "pt" : "";				
				if (confirm(_("Change language?"))) {
					DiceList.setLanguage(nl);
				}
			});

		}, 
		rollSpecial: function(specialset, ignore_log) {
			var db = Math.random();
			var complement = "";
			var ss = "";
			var st = "";
			switch (specialset) {
				case "suit":
					ss = specialSuits;
					st = "Suit";
					break;
				case "card":
					ss = specialCards;
					st = "Card";
					break;
				case "card-in-deck":
					// Test if card is joker - 2 in 54
					if (roll_one(27) == 13) {
						ss = [_("Joker")];
					} else {
						complement = " " + _("of") + " " + DiceList.rollSpecial("suit", true);
						ss = specialCards;
						st = "Card in Deck";
					}
					break;
				case "week-day":
					ss = specialWeekDays;
					st = "Week Day";
					break;
				case "month":
					ss = specialMonths;
					st = "Month";
					break;
				case "generate-name":
					ss = Array(random_name());
					st = "Generate Name";
					break;
				default:
					ss = [_("Unknown"), _("Not defined")];
			}
			var r = _(ss[roll_one(ss.length)]) + complement;
			if (! ignore_log) {
				print_log(_(st) + " " + _("resulting") + " " + _(r));
			}
			return r;
		},

        // Insert a dice into localStorage
        insert: function(fn) {
            var num = parseInt($("the-a").get("value"));
            var siz = parseInt($("the-b").get("value"));
            if ((num > 0) && (siz > 0)) {
				var message = num + "d" + siz;
                if (! this.memory.dices.contains(message)) {
					DiceList.appendDice(message)
					this.memory.dices.push(message);
					print_log(_("Saved") + " " + message + " " + _("dice set") + ".")
					DiceList.save();
				}
				if (fn) fn();
			}
        },

        // Delete a dice from localStorage
        delete: function(msg, fn) {
			DiceList.memory.dices.erase(msg);
			DiceList.save();
			print_log(_("Removed") + " " + msg + " " + _("dice set") + ".")
			if (fn) fn();
			this.loadDices();
        },
         
        // Save dices into localStorage
        save: function() {
			localStorage.setItem(lanceStorageKey, JSON.stringify(DiceList.memory));
        },
        
        // load from localStorage
        load: function() {
			var m = JSON.parse(localStorage.getItem(lanceStorageKey));
			if (m != undefined) {
				if (m.dices) {
					DiceList.memory = m;
				} else {
					if (m.length > 0) {
						m.each(function(d) {
							if (d.message) {
								DiceList.memory.dices.push(d.message);
							}
						});
					}
				}
			}
		},

        // Retrieve dices from localStorage and append them to html
        loadDices: function() {
            if (this.memory.dices.length === 0) {
				this.memory.dices.push('3d6');
			}
			$$("#custom-dices li a").destroy();
			$$("#custom-dices li b").destroy();
			$$("#custom-dices li").destroy();
			$("custom-dices").empty();
			this.memory.dices.each(function(d) {
                DiceList.appendDice(d);
            });
        },
        
        // Append to html a new task
        appendDice: function(dice) {
			var lnk = new Element("a", {"for": dice}).appendText("X");
			lnk.addEvent("click", function() {
				if (confirm(_("Confirm deletion of") + " " +this.getProperty("for") + "?")) {
					DiceList.delete(this.getProperty("for"));
				}
			})
			var lb = new Element("b").appendText(dice);
			lb.addEvent('click', function() {
				var aux = this.get('text').split('d');
				var num = aux[0];
				var sides = aux[1];
				$("rollset-result").set("text", roll_dice(num, sides));
            });

			var lid = new Element("li");
			lid.adopt(lnk);
			lid.adopt(lb);
			$("custom-dices").adopt(lid);
        },
        
        setLanguage: function(nl) {
			DiceList.memory.language = nl;
			DiceList.save();
			if (confirm(_("Restart application to apply changes?"))) {
				document.location = "index.html";
			}
		},
		updateLanguage: function() {
			var src = (this.memory.language === "") ? "img/lang-en.png" : "img/lang-" + this.memory.language + ".png";
			$("flag").setProperty("src", src);
			$("roll-manual").set("text", _("Roll!"));
			$("roll-save").set("text", _("Save"));
			$("generate-name").set("text", _("Generate Name"));
			$("suit").set("text", _("Suit"));
			$("card").set("text", _("Card"));
			$("card-in-deck").set("text", _("Card in Deck"));
			$("week-day").set("text", _("Week Day"));
			$("month").set("text", _("Month"));
		}
         
	};

    // Start up
    DiceList.handlers();
    DiceList.load();
    DiceList.loadDices();
    DiceList.updateLanguage();
	$("nav-menu").set("text", "");
    $$("section").each(function(s) {
		var ls = new Element("a", {id: s.id.replace("page", "link")});
		ls.addEvent("click", function() {
			change_page(this.id.replace("link", "page"));
		});
		$("nav-menu").adopt(ls);
		s.fade("out");
		s.setStyle("height", document.getSize().y - 40);
	});
	change_page("dices-page");

	setTimeout(function() {
		$("splash").fade("out");
	}, 2000);	
});
