/*
 * «Copyright 2012 José F. Maldonado»
 *
 *  This file is part of Sliding Puzzles.
 *
 *  Sliding Puzzles is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Sliding Puzzles is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Sliding Puzzle. If not, see <http://www.gnu.org/licenses/>.
 */

jQuery(document).ready(function() {
    // Show menu and hide game.
    jQuery("#div_game").hide();
    jQuery("#div_file_image").hide();
    
    // Gallery images behaviors.
    jQuery("#div_gallery img.gallery").click(function() {
        // Get the image name.
        var image = jQuery(this).attr("src");
        image = image.substring(14);
       
       // Start game.
       startGame('<img src="img/'+image+'" alt="Error: the image could not be loaded" />');
    });
        
    // Custom image.
    jQuery("#div_gallery img.custom").click(function() {
        jQuery("#input_file_image").click();
    });
    document.getElementById('input_file_image').addEventListener('change', handleFileInput, false);
    
    // Drag and drop behavior.
    var dropZone = document.getElementById('div_menu');
    dropZone.addEventListener('dragover', handleDragOver, false);
    dropZone.addEventListener('drop', handleDrop, false);
    
    // Go back button.
    jQuery("#div_game_back").click(function () {
        jQuery("#div_menu").show();
        jQuery("#div_game").hide();
        return false;
    });
});

function getRowsNumber() {
    var rows = jQuery("#form_dimensions select[name='rows']").val();
    return parseInt(rows);
}

function getColumnsNumber() {
    var rows = jQuery("#form_dimensions select[name='columns']").val();
    return parseInt(rows);
}

function startGame(imgHtml) {
    // Load image in the game.
    jQuery("#div_game_img").children().remove();
    jQuery("#div_game_img").append(imgHtml);
        
    // Initialize game.
    jQuery("#div_game_img img").jqPuzzle({
        rows: getRowsNumber(),
        cols: getColumnsNumber(),
        hole: getRowsNumber() * getColumnsNumber(),
        shuffle: true
    });
        
    // Show game.
    jQuery("#div_menu").hide();
    jQuery("#div_game").show();
}

function readImageFile(files) {
    // Loop through the FileList and render image files as thumbnails.
    for (var i = 0, f; f = files[i]; i++) {    
        // Only process image files.
        if (!f.type.match('image.*')) {
            continue;
        }

        // Closure to capture the file information.
        var reader = new FileReader();
        reader.onload = (function(theFile) {
            return function(e) {
                // Start game.
                startGame('<img src="'+e.target.result+'" alt="Error: the image could not be loaded" />');
            };
        })(f);

        // Read in the image file as a data URL.
        reader.readAsDataURL(f);
    }
}

function handleFileInput(evt) {
    var files = evt.target.files; // FileList object.
    readImageFile(files);
}

function handleDrop(evt) {
    evt.stopPropagation();
    evt.preventDefault();
    
    var files = evt.dataTransfer.files; // FileList object.
    readImageFile(files);
}

function handleDragOver(evt) {
    evt.stopPropagation();
    evt.preventDefault();
    evt.dataTransfer.dropEffect = 'copy'; // Explicitly show this is a copy.
}