function Linguas () {

    this.linguaPadrao = "pt-BR";
    this.nomeCookie = "idiomaPadrao";

    this.disponiveis = new Array();
    this.disponiveis.push("pt-BR");
    this.disponiveis.push("en-US");

    this.textos = {
        "pt-BR": {
            "labelJogador1" : "Nome do Jogador 1"
        },
        "en-US": {
            "labelJogador1" : "Player Name 1"
        }
    };

    this.verificaLinguaPadrao = function() {

        var lingua              = this.disponiveis.indexOf(navigator.language);
        var linguaConfigurada   = this.cookie(this.nomeCookie);

        if (lingua < 0 && (linguaConfigurada == null || linguaConfigurada == ""))
        {
            lingua = "pt-BR";
        }
        else if (linguaConfigurada != null) {
            lingua = linguaConfigurada;
        }
        else
        {
            lingua = this.disponiveis[lingua];
        }

        this.linguaPadrao = lingua;

    }

    this.alterarIdioma = function (idioma) {
        this.linguaPadrao = idioma;
        document.cookie=this.nomeCookie + "=" + idioma;
        this.cookie(this.nomeCookie);
    }

    this.texto = function (texto){

        return this.textos[this.linguaPadrao][texto];

    }

    this.cookie = function (c_name) {
        var c_value = document.cookie;
        var c_start = c_value.indexOf(" " + c_name + "=");
        if (c_start == -1) {
            c_start = c_value.indexOf(c_name + "=");
        }
        if (c_start == -1) {
            c_value = null;
        }
        else {
            c_start = c_value.indexOf("=", c_start) + 1;
            var c_end = c_value.indexOf(";", c_start);
            if (c_end == -1) {
                c_end = c_value.length;
            }
            c_value = unescape(c_value.substring(c_start,c_end));
        }
        return c_value;
    }

    this.verificaLinguaPadrao()

}