/* global getAppVersion */
'use strict';

// JS needed for the about screen.
// Will handle app version, and also
// environments.
var About = (function Support() {

    var init = function () {
        var versionElem = document.getElementById('about-version');
        var copyrightElem = document.getElementById('about-copyright');

        getAppVersion(function (err, version) {
            if (err) {
                console.error('Error getting version: ' + err);
                return;
            }

            navigator.mozL10n.localize(versionElem,
                    'aboutVersion',
                    {version: version});

            navigator.mozL10n.localize(copyrightElem,
                    'aboutCopyright',
                    {year: new Date().getFullYear()});
        }, true); // we need the extra data for the version and year

        var content = document.querySelector('[data-l10n-id="aboutContent"]');
        // It's safe, as it's one of our translations
        content.innerHTML = navigator.mozL10n.get('aboutContent');
    };


    return {
        init: init
    };

})();

window.addEventListener('localized', function localized() {
    About.init();
});
