/* global UIManager */

(function (exports) {

    'use strict';

    var domOverlay, operationNameDOM, explanationDOM, closeButtonDOM,
            unlockButton, contactExplanationDOM, phoneNumberDOM, emailDOM, operationImgDOM;
    var DEFAULT_SERVICE_IMG = '/styles/images/default.png';

    var AccessedOverlay = {
        onLockCB: null,
        show: function (globalName, iconURL, operationName, onLock, phoneNumber, email) {

            debug('ACCESSEDOVERLAY > show');

            if (!domOverlay) {
                domOverlay = document.getElementById('accessed-overlay');
                operationNameDOM = document.getElementById('accessed-op-name');
                operationImgDOM = document.getElementById('accessed-op-img');
                explanationDOM = document.getElementById('accessed-op-explanation');
                closeButtonDOM = document.getElementById('accessed-close');
                unlockButton = document.getElementById('accessed-op-unlock');
                contactExplanationDOM = document.getElementById('accessed-op-contact');
                phoneNumberDOM = document.getElementById('accessed-op-phonenumber');
                emailDOM = document.getElementById('accessed-op-email');

                // Add listeners
                closeButtonDOM.addEventListener('click', this.hide.bind(this));
                unlockButton.addEventListener('click', function () {
                    this.onLockCB(this.hide());
                }.bind(this));
            }

            // If onLock is not defined, dummy handler
            this.onLockCB = onLock || function (cb) {
                cb();
            };
            // Set title,name and phonenumber of the operation
            operationNameDOM.textContent = operationName || '';
            // no generic phone number, if service don't have one, empty string
            phoneNumberDOM.textContent = phoneNumber || '';
            // no generic email, if service don't have one, empty string
            emailDOM.textContent = email || '';

            if (!phoneNumber && !email) {
                document.getElementById('accessed-op-contact-box').classList.add('hide');
            }
            else {
                document.getElementById('accessed-op-contact-box').classList.remove('hide');
            }

            explanationDOM.textContent = '';
            // Internationalize explanations
            navigator.mozL10n.localize(
                    explanationDOM, // Element
                    'accessedOperationInfo', // l10n Key
                    {
                        operation: operationName // Params
                    });

            contactExplanationDOM.textContent = '';
            navigator.mozL10n.localize(contactExplanationDOM, 'accessedOperationDetail');

            unlockButton.textContent = '';
            navigator.mozL10n.localize(
                    unlockButton, // Element
                    'lockOperation', // l10n Key
                    {
                        service: globalName // Params
                    });

            // Remove buttons if needed
            UIManager.logoutRequired(function (required) {
                if (required) {
                    unlockButton.classList.add('hide');
                }
                else {
                    unlockButton.classList.remove('hide');
                }
            });

            // Show the overlay
            domOverlay.classList.add('show');

            // preload the default image
            operationImgDOM.src = DEFAULT_SERVICE_IMG;

            // create a new image with the proper source
            if (iconURL) {
                var newImg = new Image();
                newImg.onload = function () {
                    operationImgDOM.src = this.src;
                };
                newImg.src = iconURL;
            }
        },
        hide: function () {
            domOverlay.classList.remove('show');
        }
    };

    exports.AccessedOverlay = AccessedOverlay;

}(this));
