

/* global UIManager */

(function (exports) {

    'use strict';

    var domOverlay,
            message,
            contactExplanationDOM,
            configureLaterButton,
            closeButton,
            serviceName,
            serviceImg,
            phoneNumberDOM,
            emailDOM;
    var DEFAULT_SERVICE_IMG = '/styles/images/default.png';

    var AppPairedDisabledOverlay = {
        onConfigureLaterCB: null,
        show: function (appName, iconURL, onConfigureLater, phone, email) {
            if (!appName || !onConfigureLater) {
                console.error('Missing parameters on loading new paired disabled op overlay');
                return;
            }
            if (!domOverlay) {
                domOverlay = document.getElementById('app-paired-disabled-overlay');
                message = document.getElementById('ap-p-d-overlay-service');
                serviceName = document.getElementById('ap-p-d-overlay-service-name');
                serviceImg = document.getElementById('ap-p-d-overlay-img');
                configureLaterButton =
                        document.getElementById('paired-disabled-back-button');
                closeButton = document.getElementById('close-app-paired-disabled-button');
                contactExplanationDOM = document.getElementById('ap-p-d-overlay-explanation');
                phoneNumberDOM = document.getElementById('ap-p-d-phonenumber');
                emailDOM = document.getElementById('ap-p-d-email');

                // Listeners
                configureLaterButton.addEventListener('click', function () {
                    this.onConfigureLaterCB();
                    this.hide();
                }.bind(this));
                closeButton.addEventListener('click', function () {
                    this.onConfigureLaterCB();
                    this.hide();
                }.bind(this));
            }
            this.onConfigureLaterCB = onConfigureLater;

            // Localize
            message.textContent = '';
            navigator.mozL10n.localize(
                    message, // Element
                    'disabled-operation-explanation', // l10n Key
                    {
                        service: appName        // Params
                    }
            );

            contactExplanationDOM.textContent = '';
            navigator.mozL10n.localize(
                    contactExplanationDOM, // Element
                    'disabled-operation-contact', // l10n Key
                    {
                        code: '#0001' // Params
                    });


            serviceName.textContent = appName || '';
            // preload the default image
            serviceImg.src = DEFAULT_SERVICE_IMG;

            if (iconURL) {
                // create a new image with the proper source
                var newImg = new Image();
                newImg.onload = function () {
                    serviceImg.src = this.src;
                };
                newImg.src = iconURL;
            }

            phoneNumberDOM.textContent = phone;
            emailDOM.textContent = email;

            // Remove buttons if needed
            UIManager.logoutRequired(function (required) {
                var pressButtonParagraph = domOverlay.querySelector('.notification-detail:last-of-type');

                if (required) {
                    pressButtonParagraph.classList.add('hide');
                    configureLaterButton.classList.add('hide');
                }
                else {
                    pressButtonParagraph.classList.remove('hide');
                    configureLaterButton.classList.remove('hide');
                }
            });

            domOverlay.classList.add('show');
        },
        hide: function () {
            domOverlay.classList.remove('show');
        }
    };

    exports.AppPairedDisabledOverlay = AppPairedDisabledOverlay;

}(this));
