

/* global UIManager */

(function (exports) {

    'use strict';

    var domOverlay,
            message,
            configureButton,
            configureLaterButton,
            closeButton,
            serviceName,
            serviceImg;
    var DEFAULT_SERVICE_IMG = '/styles/images/default.png';

    var AppPairedOverlay = {
        onConfigureLaterCB: null,
        onConfigureCB: null,
        show: function (appName, iconURL, onConfigure, onConfigureLater) {
            if (!appName || !onConfigure || !onConfigureLater) {
                console.error('Missing parameters on loading new paired op overlay');
                return;
            }
            if (!domOverlay) {
                domOverlay = document.getElementById('app-paired-overlay');
                message = document.getElementById('ap-p-overlay-service');
                serviceName = document.getElementById('ap-p-overlay-service-name');
                serviceImg = document.getElementById('ap-p-overlay-img');
                configureButton = document.getElementById('configure-button');
                configureLaterButton =
                        document.getElementById('configure-later-button');
                closeButton = document.getElementById('close-app-paired-button');

                // Listeners
                configureLaterButton.addEventListener('click', function () {
                    this.onConfigureLaterCB();
                    this.hide();
                }.bind(this));
                configureButton.addEventListener('click', function () {
                    this.onConfigureCB();
                    this.hide();
                }.bind(this));
                closeButton.addEventListener('click', function () {
                    this.onConfigureLaterCB();
                    this.hide();
                }.bind(this));
            }
            this.onConfigureLaterCB = onConfigureLater;
            this.onConfigureCB = onConfigure;

            // Localize
            message.textContent = '';
            navigator.mozL10n.localize(
                    message, // Element
                    'pairing-success-service', // l10n Key
                    {
                        service: appName        // Params
                    }
            );

            serviceName.textContent = appName || '';
            // preload the default image
            serviceImg.src = DEFAULT_SERVICE_IMG;

            if (iconURL) {
                // create a new image with the proper source
                var newImg = new Image();
                newImg.onload = function () {
                    serviceImg.src = this.src;
                };
                newImg.src = iconURL;
            }

            // Remove buttons if needed
            UIManager.logoutRequired(function (required) {
                if (required) {
                    configureButton.classList.add('hide');
                    configureLaterButton.classList.add('hide');
                }
                else {
                    configureButton.classList.remove('hide');
                    configureLaterButton.classList.remove('hide');
                }
            });

            domOverlay.classList.add('show');
        },
        hide: function () {
            domOverlay.classList.remove('show');
        }
    };

    exports.AppPairedOverlay = AppPairedOverlay;

}(this));
