

/* global UIManager */

(function (exports) {

    'use strict';

    var domOverlay,
            message,
            closeButton,
            goBackButton,
            serviceName,
            serviceImg;
    var DEFAULT_SERVICE_IMG = '/styles/images/default.png';

    var AppUnpairedOverlay = {
        onConfigureLaterCB: null,
        onConfigureCB: null,
        show: function (appName, iconURL, showMain) {
            if (!appName) {
                console.error('Missing parameters on loading unpaired op overlay');
                return;
            }
            
            debug('APPUNPAIREDOVERLAY > show method started');
            
            if (!domOverlay) {
                domOverlay = document.getElementById('app-unpaired-overlay');
                message = document.getElementById('ap-up-overlay-service');
                serviceName = document.getElementById('ap-up-overlay-service-name');
                serviceImg = document.getElementById('ap-up-overlay-img');
                closeButton = document.getElementById('close-app-unpaired-button');
                goBackButton = document.getElementById('unpaired-overlay-back');

                // Listeners
                closeButton.addEventListener('click', function () {
                    this.hide();
                }.bind(this));
                goBackButton.addEventListener('click', function () {
                    this.hide();
                }.bind(this));
            }

            message.textContent = '';
            navigator.mozL10n.localize(
                    message, // Element
                    'unpairing-success-service', // l10n Key
                    {
                        service: appName        // Params
                    }
            );

            serviceName.textContent = appName || '';
            // preload the default image
            serviceImg.src = DEFAULT_SERVICE_IMG;

            if (iconURL) {
                // create a new image with the proper source
                var newImg = new Image();
                newImg.onload = function () {
                    serviceImg.src = this.src;
                };
                newImg.src = iconURL;
            }
            
             // Remove buttons if needed
            UIManager.logoutRequired(function (required) {
                var pressButtonParagraph = domOverlay.querySelector('.notification-detail:last-of-type');
                if (required) {
                    pressButtonParagraph.classList.add('hide');
                    goBackButton.classList.add('hide');
                }
                else {
                    pressButtonParagraph.classList.remove('hide');
                    goBackButton.classList.remove('hide');
                }
            });

            domOverlay.classList.add('show');
        },
        hide: function () {
            domOverlay.classList.remove('show');
        }
    };

    exports.AppUnpairedOverlay = AppUnpairedOverlay;

}(this));
