/* global UIManager */

(function (exports) {

    'use strict';

    var domOverlay, operationNameDOM, explanationDOM, closeButtonDOM,
            unlockButton, contactExplanationDOM, phoneNumberDOM, emailDOM, operationImgDOM;
    var DEFAULT_SERVICE_IMG = '/styles/images/default.png';

    var BlockedOverlay = {
        onUnlockCB: null,
        show: function (globalName, iconURL, operationName, onUnlock, phoneNumber, email, opId) {

            if (!domOverlay) {
                domOverlay = document.getElementById('blocked-overlay');
                operationNameDOM = document.getElementById('blocked-op-name');
                operationImgDOM = document.getElementById('blocked-op-img');
                explanationDOM = document.getElementById('blocked-op-explanation');
                closeButtonDOM = document.getElementById('blocked-close');
                unlockButton = document.getElementById('blocked-op-unlock');
                contactExplanationDOM = document.getElementById('blocked-op-contact');
                phoneNumberDOM = document.getElementById('blocked-op-phonenumber');
                emailDOM = document.getElementById('blocked-op-email');

                // Add listeners
                closeButtonDOM.addEventListener('click', this.hide.bind(this));

            }

            // Remove previous click event listeners
            var clone = unlockButton.cloneNode(true);
            unlockButton.parentNode.replaceChild(clone, unlockButton);
            unlockButton = clone;

            // Set click event listener
            unlockButton.addEventListener('click', function () {
                onUnlock(opId);
            });

            // Set title,name and phonenumber of the operation
            operationNameDOM.textContent = operationName || '';
            // no generic phone number, if service don't have one, empty string
            phoneNumberDOM.textContent = phoneNumber || '';
            // no generic email, if service don't have one, empty string
            emailDOM.textContent = email || '';

            if (!phoneNumber && !email) {
                document.getElementById('blocked-op-contact-box').classList.add('hide');
            }
            else {
                document.getElementById('blocked-op-contact-box').classList.remove('hide');
            }

            explanationDOM.textContent = '';
            // Internationalize explanations
            navigator.mozL10n.localize(
                    explanationDOM, // Element
                    'contactService', // l10n Key
                    {
                        operation: operationName // Params
                    });

            contactExplanationDOM.textContent = '';
            navigator.mozL10n.localize(
                    contactExplanationDOM, // Element
                    'blockedOperationInfo', // l10n Key
                    {
                        service: globalName // Params
                    });

            unlockButton.textContent = '';
            navigator.mozL10n.localize(
                    unlockButton, // Element
                    'unlockOperation', // l10n Key
                    {
                        service: globalName // Params
                    });

            // Remove buttons if needed
            UIManager.logoutRequired(function (required) {
                if (required) {
                    unlockButton.classList.add('hide');
                }
                else {
                    unlockButton.classList.remove('hide');
                }
            });

            // Show the overlay
            domOverlay.classList.add('show');

            // preload the default image
            operationImgDOM.src = DEFAULT_SERVICE_IMG;

            // create a new image with the proper source
            if (iconURL) {
                var newImg = new Image();
                newImg.onload = function () {
                    operationImgDOM.src = this.src;
                };
                newImg.src = iconURL;
            }
        },
        hide: function () {
            domOverlay.classList.remove('show');
        }
    };

    exports.BlockedOverlay = BlockedOverlay;

}(this));
