(function (exports) {

    'use strict';

    var domOverlay, operationNameDOM, explanationDOM, closeButtonDOM,
            contactExplanationDOM, phoneNumberDOM, emailDOM, operationImgDOM;
    var DEFAULT_SERVICE_IMG = '/styles/images/default.png';

    var ChangedOverlay = {
        onUnlockCB: null,
        show: function (iconURL, operationName, phoneNumber, email) {

            if (!domOverlay) {
                domOverlay = document.getElementById('changed-overlay');
                operationNameDOM = document.getElementById('changed-op-name');
                operationImgDOM = document.getElementById('changed-op-img');
                explanationDOM = document.getElementById('changed-op-explanation');
                closeButtonDOM = document.getElementById('changed-close');
                contactExplanationDOM = document.getElementById('changed-op-contact');
                phoneNumberDOM = document.getElementById('changed-op-phonenumber');
                emailDOM = document.getElementById('changed-op-email');

                // Add listeners
                closeButtonDOM.addEventListener('click', this.hide.bind(this));
            }

            // Set title,name and phonenumber of the operation
            operationNameDOM.textContent = operationName || '';
            // no generic phone number, if service don't have one, empty string
            phoneNumberDOM.textContent = phoneNumber || '';
            // no generic email, if service don't have one, empty string
            emailDOM.textContent = email || '';

            if (!phoneNumber && !email) {
                document.getElementById('changed-op-contact-box').classList.add('hide');
            }
            else {
                document.getElementById('changed-op-contact-box').classList.remove('hide');
            }

            // Show the overlay
            domOverlay.classList.add('show');

            // preload the default image
            operationImgDOM.src = DEFAULT_SERVICE_IMG;

            // create a new image with the proper source
            if (iconURL) {
                var newImg = new Image();
                newImg.onload = function () {
                    operationImgDOM.src = this.src;
                };
                newImg.src = iconURL;
            }
        },
        hide: function () {
            UIManager.renderAllOperations();
            domOverlay.classList.remove('show');
        }
    };

    exports.ChangedOverlay = ChangedOverlay;

}(this));
