
/* global SecurityModel, ErrorManager */

var SecurityController = new function() {

    function listSessions(callback) {
        debug('Controller > list sessions');
        SecurityModel.listSessions(function (error, currentSession, otherSessions) {
            if (error) {
                ErrorManager.checkError(error);
                return;
            }
            callback(currentSession, otherSessions);
        });
    }

    function closeSingleSession(sessionId, callback) {
        debug('Cotroller > close single session ' + sessionId);
        SecurityModel.closeSingleSession(sessionId, function (error) {
            if (error) {
                ErrorManager.checkError(error);
                return;
            }
            callback();
        });
    }

    function closeAllSessions(callback) {
        debug('Cotroller > close all sessions');
        SecurityModel.closeAllSessions(function (error) {
            if (error) {
                ErrorManager.checkError(error);
                return;
            }
            callback();
        });
    }

    return {
        listSessions: listSessions,
        closeSingleSession: closeSingleSession,
        closeAllSessions: closeAllSessions
    };
};