(function (exports) {

    'use strict';

    var domOverlay,
            operationNameDOM,
            explanationDOM,
            closeButtonDOM,
            disabledOperationButton,
            contactExplanationDOM,
            phoneNumberDOM,
            emailDOM,
            operationImgDOM;
    var DEFAULT_SERVICE_IMG = '/styles/images/default.png';

    var DisabledOverlay = {
        onDisabledCB: null,
        show: function (globalName, iconURL, handler, phoneNumber, email) {

            if (!domOverlay) {
                domOverlay = document.getElementById('disabled-overlay');
                operationNameDOM = document.getElementById('disabled-op-name');
                operationImgDOM = document.getElementById('disabled-op-img');
                explanationDOM = document.getElementById('disabled-op-explanation');
                closeButtonDOM = document.getElementById('disabled-close');
                disabledOperationButton = document.getElementById('disabled-op-button');
                contactExplanationDOM = document.getElementById('disabled-op-contact');
                phoneNumberDOM = document.getElementById('disabled-op-phonenumber');
                emailDOM = document.getElementById('disabled-op-email');

                // Add listeners
                closeButtonDOM.addEventListener('click', function(){
                    this.onDisabledCB(this.hide());
                }.bind(this));
                disabledOperationButton.addEventListener('click', function () {
                    this.onDisabledCB(this.hide());
                }.bind(this));
            }

            // If onDisabled is not defined, dummy handler
            this.onDisabledCB = handler || function (cb) {
                cb();
            };
            // Set title,name and phonenumber of the operation
            operationNameDOM.textContent = globalName || '';
            // no generic phone number, if service don't have one, empty string
            phoneNumberDOM.textContent = phoneNumber || '';
            // no generic email, if service don't have one, empty string
            emailDOM.textContent = email || '';

            if (!phoneNumber && !email) {
                document.getElementById('disabled-op-contact-box').classList.add('hide');
            }
            else {
                document.getElementById('disabled-op-contact-box').classList.remove('hide');
            }

            // Internationalize explanations
            contactExplanationDOM.textContent = '';
            navigator.mozL10n.localize(
                    contactExplanationDOM, // Element
                    'disabled-operation-contact', // l10n Key
                    {
                        code: '#0002' // Params
                    });



            // Remove buttons if needed
            UIManager.logoutRequired(function (required) {
                var pressButtonParagraph = domOverlay.querySelector('.notification-detail:last-of-type');
                if (required) {
                    pressButtonParagraph.classList.add('hide');
                    disabledOperationButton.classList.add('hide');
                }
                else {
                    pressButtonParagraph.classList.remove('hide');
                    disabledOperationButton.classList.remove('hide');
                }
            });
            // Show the overlay
            domOverlay.classList.add('show');

            // preload the default image
            operationImgDOM.src = DEFAULT_SERVICE_IMG;

            // create a new image with the proper source
            if (iconURL) {
                var newImg = new Image();
                newImg.onload = function () {
                    operationImgDOM.src = this.src;
                };
                newImg.src = iconURL;
            }
        },
        hide: function () {
            domOverlay.classList.remove('show');
        }
    };

    exports.DisabledOverlay = DisabledOverlay;

}(this));
