/* global API, asyncStorage, ErrorManager, debug */
/* jshint maxstatements:50 */
'use strict';

var SecurityModel = new function() {

    function listSessions(callback){
        debug('Model > list sessions');
        API.listSessions(function(error, data){

            var currentSession = data.current;
            var otherSessions = data.sessions;

            callback(error, currentSession, otherSessions);
        });
    }

    function closeSingleSession(sessionId, callback){
        debug('Model > close single session > '+sessionId);
        API.closeOtherSession(sessionId, function(error){
            callback(error);
        });
    }

    function closeAllSessions(callback){
        closeSingleSession('', callback);
    }

    return {
        listSessions: listSessions,
        closeSingleSession: closeSingleSession,
        closeAllSessions: closeAllSessions
    };
};
