(function (exports) {

    'use strict';

    var domOverlay,
            operationNameDOM,
            explanationDOM,
            closeButtonDOM,
            contactExplanationDOM,
            operationImgDOM,
            deviceName;
    var DEFAULT_SERVICE_IMG = '/styles/images/default.png';

    var NewSessionOverlay = {
        onDisabledCB: null,
        show: function (device, handler) {

            if (!domOverlay) {
                domOverlay = document.getElementById('new-session-overlay');
                closeButtonDOM = document.getElementById('new-session-close');
                deviceName = document.getElementById('new-session-op-device-name');

                // Add listeners
                closeButtonDOM.addEventListener('click', function () {
                    this.onDisabledCB(this.hide());
                }.bind(this));
            }
            // If onDisabled is not defined, dummy handler
            this.onDisabledCB = handler || function (cb) {
                cb();
            };

            // Set the device name

            if (device.device && device.device !== '') {
                deviceName.innerHTML = device.platform + ' ' + device.os + '<br>' + device.device;
            }
            else{
                deviceName.textContent = device.platform;
            }
            
            // Show the overlay
            domOverlay.classList.add('show');

            // preload the default image
            operationImgDOM.src = DEFAULT_SERVICE_IMG;
        },
        hide: function () {
            domOverlay.classList.remove('show');
        }
    };

    exports.NewSessionOverlay = NewSessionOverlay;

}(this));
