(function (exports) {

    'use strict';

    var domOverlay,
            operationNameDOM,
            explanationDOM,
            customMessageDOM,
            closeButtonDOM,
            operationImgDOM,
            otpPassword;
    var DEFAULT_SERVICE_IMG = '/styles/images/default.png';

    var OTPOverlay = {
        show: function (globalName, iconURL, otp, customMessage) {

            if (!domOverlay) {
                domOverlay = document.getElementById('otp-overlay');
                operationNameDOM = document.getElementById('otp-op-name');
                operationImgDOM = document.getElementById('otp-op-img');
                explanationDOM = document.getElementById('otp-op-explanation');
                customMessageDOM = document.getElementById('otp-op-custom-message');
                closeButtonDOM = document.getElementById('otp-close');
                otpPassword = document.getElementById('otp-password');

                // Add listeners
                closeButtonDOM.addEventListener('click', function () {
                    this.hide();
                }.bind(this));
            }

            // Set name of the operation
            operationNameDOM.textContent = globalName || '';

            // Set custom message           
            customMessageDOM.textContent = customMessage !== undefined ? customMessage : '';

            // Set OTP password
            otpPassword.textContent = otp;

            // Show the overlay
            domOverlay.classList.add('show');

            // preload the default image
            operationImgDOM.src = DEFAULT_SERVICE_IMG;

            // create a new image with the proper source
            if (iconURL) {
                var newImg = new Image();
                newImg.onload = function () {
                    operationImgDOM.src = this.src;
                };
                newImg.src = iconURL;
            }
        },
        hide: function () {
            domOverlay.classList.remove('show');
        }
    };

    exports.OTPOverlay = OTPOverlay;

}(this));
