/* global Controller, UIManager */

window.onload = function () {

    function removeLoader() {
        var loader = document.getElementById("loader");
        loader.parentElement.removeChild(loader);
    }


    document.getElementById("settings-password-interval").addEventListener("click", function () {

        if (!Controller.checkOnline()) { return;}

        var selector = document.getElementById("settings-password-interval-select");
        selector.focus();
        selector.onblur = function () {
            var index = selector.selectedIndex;
            var currentValue = selector.options[index].innerHTML;
            var resultObject = document.getElementById("settings-password-interval-result");
            resultObject.innerHTML = currentValue;

            var currentNumberOfDays = selector.options[index].value;
            var currentNumberOfSeconds = currentNumberOfDays > 0 ? currentNumberOfDays * 24 * 60 * 60 : parseInt(currentNumberOfDays);
            Controller.storePreferences("passwordAskingTime", currentNumberOfSeconds);
        };
    });
    document.getElementById("settings-autolock-time").addEventListener("click", function () {

        if (!Controller.checkOnline()) { return;}

        var selector = document.getElementById("settings-autolock-time-select");
        selector.focus();
        selector.onblur = function () {
            var index = selector.selectedIndex;
            var currentValue = selector.options[index].innerHTML;
            var resultObject = document.getElementById("settings-autolock-time-result");
            resultObject.innerHTML = currentValue;

            var currentNumberOfMinutes = selector.options[index].value;

            Controller.storePreferences("autolock", parseInt(currentNumberOfMinutes));
        };
    });

    document.getElementById("unlockedNotificationsCheckbox").addEventListener("click", function (event) {

        var checkbox = document.getElementById("unlockedNotificationsCheckbox");

        if (!Controller.checkOnline()) {
            checkbox.checked = !checkbox.checked;
            return;
        }

        var newValue = checkbox.checked;
        Controller.storePreferences("unlockedNotifications", newValue);

    });

    UIManager.getPreferences(function (preferences) {

        removeLoader();

        // Password asking time
        var numberOfSecondsPass = preferences["passwordAskingTime"];

        var selectedOptionIdPass;
        switch (numberOfSecondsPass) {
            case -1:
                selectedOptionIdPass = "passNever";
                break;
            case 0:
                selectedOptionIdPass = "passAlways";
                break;
            default:
                var numberOfDaysPass = numberOfSecondsPass / 60 / 60 / 24;
                selectedOptionIdPass = "pass" + numberOfDaysPass + "days";
        }


        debug('selectedOptionIdPass = ' + selectedOptionIdPass);

        var selectedOptionPass = document.getElementById(selectedOptionIdPass);
        selectedOptionPass.selected = true;

        var resultPass = document.getElementById("settings-password-interval-result");
        resultPass.innerHTML = selectedOptionPass.label;

        // Autolock time
        var numberOfMinutesAutolock = preferences["autolock"];

        var selectedOptionIdAutolock = "autolock" + numberOfMinutesAutolock + "minutes";

        var selectedOptionAutolock = document.getElementById(selectedOptionIdAutolock);

        selectedOptionAutolock.selected = true;

        var resultAutolock = document.getElementById("settings-autolock-time-result");
        resultAutolock.innerHTML = selectedOptionAutolock.label;

        //unlockedNotifications

        var unlockedNotifications = preferences["unlockedNotifications"];
        document.getElementById("unlockedNotificationsCheckbox").checked = unlockedNotifications;
    });

};

