

(function (exports) {
    'use strict';

    var rdashes = /-(.)/g;

    function formatToTwoDigits(value) {
        if (value < 10) {
            return '0' + value;
        }
        return value;
    }

    function abreviateMonth(month) {
        if (month.length <= 3) {
            return month;
        }
        return month.substr(0, 3) + '.';
    }

    var Utils = {
        camelCase: function (str) {
            return str.replace(rdashes, function replacer(str, p1) {
                return p1.toUpperCase();
            });
        },
        dateToUTCString: function (date) {


            var string = date.getUTCFullYear() + '-' +
                    formatToTwoDigits(date.getUTCMonth() + 1) + '-' +
                    // TODO Add one more day if needed
                    formatToTwoDigits(date.getUTCDate()) + ' ' +
                    formatToTwoDigits(date.getUTCHours()) + ':' +
                    formatToTwoDigits(date.getUTCMinutes());
            return string;
        },
        dateToDayString: function (date, separator) {

            // Output format: d/m/yy

            var string = date.getDate() +
                    separator +
                    (date.getMonth() + 1) +
                    separator +
                    ('' + date.getFullYear()).substring(2, 4);

            return string;
        },
        utcDateToWords: function (date) {
            var _ = navigator.mozL10n.get;
            var text = formatToTwoDigits(date.getUTCDate()) + ' '
                    + abreviateMonth(_('month-' + formatToTwoDigits(date.getUTCMonth() + 1)))
                    + ' '
                    + date.getUTCFullYear()
                    + ' - '
                    + formatToTwoDigits(date.getHours()) + ':'
                    + formatToTwoDigits(date.getMinutes());
            return text;
        },
        dateToHourString: function (date, separator) {
            // Output format: hh:mm
            return formatToTwoDigits(date.getHours()) + separator + formatToTwoDigits(date.getMinutes());
        },
        dateToGMTString: function (date) {


            var string = date.getUTCFullYear() + '-' +
                    formatToTwoDigits(date.getMonth() + 1) + '-' +
                    // TODO Add one more day if needed
                    formatToTwoDigits(date.getDate()) + ' ' +
                    formatToTwoDigits(date.getHours()) + ':' +
                    formatToTwoDigits(date.getMinutes());
            return string;
        },
        validateEmail: function (email) {
            var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
            return re.test(email);
        },
        chooseName: function (operation) {
            var customName = operation.customName;
            var defaultName = operation.name;
            if (customName === undefined || customName === null) {
                return defaultName;
            }
            else {
                return customName.trim() === '' ? defaultName : customName;
            }
        },
        chooseNameIncludingGlobalParent: function (opId, operation) {
            var name = Utils.chooseName(operation);
            if (operation.globalParentId !== opId) {
                name = Utils.chooseName(operation.globalParent) + ' (' + name + ')';
            }
            return name;
        },
        parseSpanishFormat: function (dateString) {
            // 03-12-2015 14:56:06

            var day = parseInt(dateString.substring(0, 2));
            // Month range between 0 and 11
            var month = parseInt(dateString.substring(3, 5)) - 1;
            var year = parseInt(dateString.substring(6, 10));

            var hours = parseInt(dateString.substring(11, 13));
            var minutes = parseInt(dateString.substring(14, 16));
            var seconds = parseInt(dateString.substring(17, 19));

            var date = new Date();

            date.setFullYear(year);
            date.setUTCMonth(month);
            date.setUTCDate(day);
            date.setUTCHours(hours);
            date.setUTCMinutes(minutes);
            date.setUTCSeconds(seconds);

            return date;
        },
        parseUTCDate: function (dateString) {

            // Sample dateString: 2015-02-03 10:25:45
            // or
            // Sample dateString: 2015-02-03 10:25

            var year = parseInt(dateString.substring(0, 4));
            // Month range between 0 and 11
            var month = parseInt(dateString.substring(5, 7)) - 1;
            var day = parseInt(dateString.substring(8, 10));
            var hours = parseInt(dateString.substring(11, 13));
            var minutes = parseInt(dateString.substring(14, 16));
            var seconds = parseInt(dateString.substring(17, 19));

            var date = new Date();

            date.setFullYear(year);
            date.setUTCMonth(month);
            date.setUTCDate(day);
            date.setUTCHours(hours);
            date.setUTCMinutes(minutes);
            
            var secondsWereReceived = !isNaN(seconds)
            if (secondsWereReceived) {
                date.setUTCSeconds(seconds);
            }

            return date;
        },
        parseGMTDate: function (dateString) {

            // Sample dateString: 2015-02-03 10:25

            var year = parseInt(dateString.substring(0, 4));
            // Month range between 0 and 11
            var month = parseInt(dateString.substring(5, 7)) - 1;
            var day = parseInt(dateString.substring(8, 10));
            var hours = parseInt(dateString.substring(11, 13));
            var minutes = parseInt(dateString.substring(14, 16));
            var seconds = parseInt(dateString.substring(17, 19));

            var date = new Date();

            date.setFullYear(year);
            date.setMonth(month);
            date.setDate(day);
            date.setHours(hours);
            date.setMinutes(minutes);

            if (!isNaN(seconds)) {
                date.setSeconds(seconds);
            }

            return date;
        },
        getBeginningOfDay: function (date) {
            if (date === undefined) {
                date = new Date();
            }
            date.setHours(0, 0);
            return date;
        },
        getEndOfDay: function (date) {
            if (date === undefined) {
                date = new Date();
            }
            date.setHours(23, 59);
            return date;
        },
        // Return an array of the selected opion values
        // select is an HTML select element
        getSelectValues: function (select) {
            var result = [];
            var options = select && select.options;
            var opt;

            for (var i = 0, iLen = options.length; i < iLen; i++) {
                opt = options[i];

                if (opt.selected) {
                    result.push(opt.value || opt.text);
                }
            }
            return result;
        },
        // yyyy-mm-dd
        getTodayString: function () {
            var gmtString = Utils.dateToGMTString(new Date());
            return gmtString.substring(0, 10);
        },
        isInFuture: function(gmtDate){
            return new Date().getTime() < gmtDate.getTime();
        }
    };

    exports.Utils = Utils;
}(this));
