/* global Config */
'use strict';

// Utility function to get the version of the
// app via manifest

function getAppVersion(cb, extra) {
    if (typeof cb !== 'function') {
        return;
    }

    var request = navigator.mozApps.getSelf();
    request.onsuccess = function (evt) {
        var app = evt.target.result;
        var version = app.manifest.version || 'beta'; //simple fallback

        if (extra && Config.environment.versionExtra) {
            version = version + ' - ' + Config.environment.versionExtra;
        }

        cb(null, version);
    };
    request.onerror = function (evt) {
        cb(evt);
    };
}

// To avoid jshint errors
window.getAppVersion = getAppVersion;
