Keyboards.latex = {
  label: 'LaTeX',
  shortLabel: 'TeX',
  imEngine: 'latex',
  types: ['text', 'url', 'email'],
  menuLabel: 'LaTeX',
  disableAlternateLayout: true,
  alt: {
    q: [
    { value: '𝒶 ', compositeKey: '\\mathcal{q}', upperValue: '𝒞', upperCompositeKey: '\\mathcal{Q}' },
    { value: '𝕠', compositeKey: '\\mathbb{q}', upperValue: 'ℚ', upperCompositeKey: '\\mathbb{Q}' },
    { value: '𝔮', compositeKey: '\\mathfrak{q}', upperValue: '𝔔', upperCompositeKey: '\\mathfrak{Q}' }
    ],
    w: [
    { value: '𝓌', compositeKey: '\\mathcal{w}', upperValue: '𝒲', upperCompositeKey: '\\mathcal{W}' },
    { value: '𝕨', compositeKey: '\\mathbb{w}', upperValue: '𝕎', upperCompositeKey: '\\mathbb{W}' },
    { value: '𝔴', compositeKey: '\\mathfrak{w}', upperValue: '𝔚', upperCompositeKey: '\\mathfrak{W}' }
    ],
    e: [
    { value: 'é' }, { value: 'è' }, { value: 'ê' }, { value: 'ë' },
    { value: 'ē' }, { value: 'ę' }, { value: '€' }, { value: 'ɛ' },
    { value: 'ℯ', compositeKey: '\\mathcal{e}', upperValue: 'ℰ', upperCompositeKey: '\\mathcal{E}' },
    { value: '𝕖', compositeKey: '\\mathbb{e}', upperValue: '𝔼', upperCompositeKey: '\\mathbb{E}' },
    { value: '𝔢', compositeKey: '\\mathfrak{e}', upperValue: '𝔈', upperCompositeKey: '\\mathfrak{E}' }
    ],
    r: [
    { value: '𝓇', compositeKey: '\\mathcal{r}', upperValue: 'ℛ', upperCompositeKey: '\\mathcal{R}' },
    { value: '𝕣', compositeKey: '\\mathbb{r}', upperValue: 'ℝ', upperCompositeKey: '\\mathbb{R}' },
    { value: '𝔯', compositeKey: '\\mathfrak{r}', upperValue: 'ℜ', upperCompositeKey: '\\Re' }
    ],
    t: [
    { value: '𝓉', compositeKey: '\\mathcal{t}', upperValue: '𝒯', upperCompositeKey: '\\mathcal{T}' },
    { value: '𝕥', compositeKey: '\\mathbb{t}', upperValue: '𝕋', upperCompositeKey: '\\mathbb{T}' },
    { value: '𝔱', compositeKey: '\\mathfrak{t}', upperValue: '𝔗', upperCompositeKey: '\\mathfrak{T}' }
    ],
    y: [
    { value: 'ÿ' }, { value: '¥' },
    { value: '𝓎', compositeKey: '\\mathcal{y}', upperValue: '𝒴', upperCompositeKey: '\\mathcal{Y}' },
    { value: '𝕪', compositeKey: '\\mathbb{y}', upperValue: '𝕐', upperCompositeKey: '\\mathbb{Y}' },
    { value: '𝔶', compositeKey: '\\mathfrak{y}', upperValue: '𝕐', upperCompositeKey: '\\mathfrak{Y}' }
    ],
    u: [
    { value: 'ü' }, { value: 'ú' }, { value: 'ù' }, { value: 'û' }, { value: 'ū' },
    { value: '𝓊', compositeKey: '\\mathcal{u}', upperValue: '𝒰', upperCompositeKey: '\\mathcal{U}' },
    { value: '𝕦', compositeKey: '\\mathbb{u}', upperValue: '𝕌', upperCompositeKey: '\\mathbb{U}' },
    { value: '𝔲', compositeKey: '\\mathfrak{u}', upperValue: '𝔘', upperCompositeKey: '\\mathfrak{U}' }
    ],
    i: [
    { value: 'ï' }, { value: 'í' }, { value: 'ì' },
    { value: 'î' }, { value: 'ī' }, { value: 'į' },
    { value: '𝒾', compositeKey: '\\mathcal{i}', upperValue: 'ℐ', upperCompositeKey: '\\mathcal{I}' },
    { value: '𝕚', compositeKey: '\\mathbb{i}', upperValue: '𝕀', upperCompositeKey: '\\mathbb{I}' },
    { value: '𝔦', compositeKey: '\\mathfrak{i}', upperValue: 'ℑ', upperCompositeKey: '\\Im' }
    ],
    o: [
    { value: 'ö' }, { value: 'ó' }, { value: 'ò' }, { value: 'ô' },
    { value: 'ō' }, { value: 'œ' }, { value: 'ø' }, { value: 'ɵ' },
    { value: 'ℴ', compositeKey: '\\mathcal{o}', upperValue: '𝒪', upperCompositeKey: '\\mathcal{O}' },
    { value: '𝕠', compositeKey: '\\mathbb{o}', upperValue: '𝕆', upperCompositeKey: '\\mathbb{O}' },
    { value: '𝔬', compositeKey: '\\mathfrak{o}', upperValue: '𝔒', upperCompositeKey: '\\mathfrak{O}' }
    ],
    p: [
    { value: '𝓅', compositeKey: '\\mathcal{p}', upperValue: '𝒫', upperCompositeKey: '\\mathcal{P}' },
    { value: '𝕡', compositeKey: '\\mathbb{p}', upperValue: 'ℙ', upperCompositeKey: '\\mathbb{P}' },
    { value: '𝔮', compositeKey: '\\mathfrak{p}', upperValue: '𝔓', upperCompositeKey: '\\mathfrak{P}' }
    ],
    a: [
    { value: 'á' }, { value: 'à' }, { value: 'â' }, { value: 'ä' },
    { value: 'å' }, { value: 'ã' }, { value: 'ā' }, { value: 'æ' },
    { value: '𝒶', compositeKey: '\\mathcal{a}', upperValue: '𝒜', upperCompositeKey: '\\mathcal{A}' },
    { value: '𝕒', compositeKey: '\\mathbb{a}', upperValue: '𝔸', upperCompositeKey: '\\mathbb{A}' },
    { value: '𝔞', compositeKey: '\\mathfrak{a}', upperValue: '𝔄', upperCompositeKey: '\\mathfrak{A}' }
    ],
    s: [
    { value: 'ß' }, { value: 'ś' }, { value: 'š' }, { value: '$' },
    { value: '𝒷', compositeKey: '\\mathcal{s}', upperValue: '𝒮', upperCompositeKey: '\\mathcal{S}' },
    { value: '𝕤', compositeKey: '\\mathbb{s}', upperValue: '𝕊', upperCompositeKey: '\\mathbb{S}' },
    { value: '𝔰', compositeKey: '\\mathfrak{s}', upperValue: '𝔖', upperCompositeKey: '\\mathfrak{S}' }
    ],
    S: [
    { value: 'Ś' }, { value: 'Š' }, { value: '$' },
    { value: '𝓈', compositeKey: '\\mathcal{s}', upperValue: '𝒮', upperCompositeKey: '\\mathcal{S}' },
    { value: '𝕤', compositeKey: '\\mathbb{s}', upperValue: '𝕊', upperCompositeKey: '\\mathbb{S}' },
    { value: '𝔰', compositeKey: '\\mathfrak{s}', upperValue: '𝔖', upperCompositeKey: '\\mathfrak{S}' }
    ],
    d: [
    { value: '𝒹', compositeKey: '\\mathcal{d}', upperValue: '𝒟', upperCompositeKey: '\\mathcal{D}' },
    { value: '𝕕', compositeKey: '\\mathbb{d}', upperValue: '𝔻', upperCompositeKey: '\\mathbb{D}' },
    { value: '𝔡', compositeKey: '\\mathfrak{d}', upperValue: '𝔇', upperCompositeKey: '\\mathfrak{D}' }
    ],
    f: [
    { value: '𝒻', compositeKey: '\\mathcal{f}', upperValue: 'ℱ', upperCompositeKey: '\\mathcal{F}' },
    { value: '𝕗', compositeKey: '\\mathbb{f}', upperValue: '𝔽', upperCompositeKey: '\\mathbb{F}' },
    { value: '𝔣', compositeKey: '\\mathfrak{f}', upperValue: '𝔉', upperCompositeKey: '\\mathfrak{F}' }
    ],
    g: [
    { value: 'ℊ', compositeKey: '\\mathcal{g}', upperValue: '𝒢', upperCompositeKey: '\\mathcal{G}' },
    { value: '𝕘', compositeKey: '\\mathbb{g}', upperValue: '𝔾', upperCompositeKey: '\\mathbb{G}' },
    { value: '𝔤', compositeKey: '\\mathfrak{g}', upperValue: '𝔊', upperCompositeKey: '\\mathfrak{G}' }
    ],
    h: [
    { value: '𝒽', compositeKey: '\\mathcal{h}', upperValue: 'ℋ', upperCompositeKey: '\\mathcal{H}' },
    { value: '𝕙', compositeKey: '\\mathbb{h}', upperValue: 'ℍ', upperCompositeKey: '\\mathbb{H}' },
    { value: '𝔥', compositeKey: '\\mathfrak{h}', upperValue: 'ℌ', upperCompositeKey: '\\mathfrak{H}' }
    ],
    j: [
    { value: '𝒿', compositeKey: '\\mathcal{j}', upperValue: '𝒥', upperCompositeKey: '\\mathcal{J}' },
    { value: '𝕛', compositeKey: '\\mathbb{j}', upperValue: '𝕁', upperCompositeKey: '\\mathbb{J}' },
    { value: '𝔧', compositeKey: '\\mathfrak{j}', upperValue: '𝔍', upperCompositeKey: '\\mathfrak{J}' }
    ],
    k: [
    { value: '𝓀', compositeKey: '\\mathcal{k}', upperValue: '𝒦', upperCompositeKey: '\\mathcal{K}' },
    { value: '𝕜', compositeKey: '\\mathbb{k}', upperValue: '𝕂', upperCompositeKey: '\\mathbb{K}' },
    { value: '𝔨', compositeKey: '\\mathfrak{k}', upperValue: '𝔎', upperCompositeKey: '\\mathfrak{K}' }
    ],
    l: [
    { value: 'ł' }, { value: '£' },
    { value: '𝓁', compositeKey: '\\mathcal{l}', upperValue: 'ℒ', upperCompositeKey: '\\mathcal{L}' },
    { value: '𝕝', compositeKey: '\\mathbb{l}', upperValue: '𝕃', upperCompositeKey: '\\mathbb{L}' },
    { value: '𝔩', compositeKey: '\\mathfrak{l}', upperValue: '𝔏', upperCompositeKey: '\\mathfrak{L}' }
    ],
    z: [
    { value: 'ž' }, { value: 'ź' }, { value: 'ż' },
    { value: '𝓏', compositeKey: '\\mathcal{z}', upperValue: '𝒵', upperCompositeKey: '\\mathcal{Z}' },
    { value: '𝕫', compositeKey: '\\mathbb{z}', upperValue: 'ℤ', upperCompositeKey: '\\mathbb{Z}' },
    { value: '𝔷', compositeKey: '\\mathfrak{z}', upperValue: 'ℨ', upperCompositeKey: '\\mathfrak{Z}' }
    ],
    x: [
    { value: '𝓍', compositeKey: '\\mathcal{x}', upperValue: '𝒳', upperCompositeKey: '\\mathcal{X}' },
    { value: '𝕩', compositeKey: '\\mathbb{x}', upperValue: '𝕏', upperCompositeKey: '\\mathbb{X}' },
    { value: '𝔵', compositeKey: '\\mathfrak{x}', upperValue: '𝔛', upperCompositeKey: '\\mathfrak{X}' }
    ],
    c: [
    { value: 'ç' }, { value: 'ć' }, { value: 'č' },
    { value: '𝒸', compositeKey: '\\mathcal{c}', upperValue: '𝒞', upperCompositeKey: '\\mathcal{C}' },
    { value: '𝕔', compositeKey: '\\mathbb{c}', upperValue: 'ℂ', upperCompositeKey: '\\mathbb{C}' },
    { value: '𝔠', compositeKey: '\\mathfrak{c}', upperValue: 'ℭ', upperCompositeKey: '\\mathfrak{C}' }
    ],
    v: [
    { value: '𝓋', compositeKey: '\\mathcal{v}', upperValue: '𝒱', upperCompositeKey: '\\mathcal{V}' },
    { value: '𝕧', compositeKey: '\\mathbb{v}', upperValue: '𝕍', upperCompositeKey: '\\mathbb{V}' },
    { value: '𝔳', compositeKey: '\\mathfrak{v}', upperValue: '𝔙', upperCompositeKey: '\\mathfrak{V}' }
    ],
    b: [
    { value: '𝒷', compositeKey: '\\mathcal{b}', upperValue: 'ℬ', upperCompositeKey: '\\mathcal{B}' },
    { value: '𝕓', compositeKey: '\\mathbb{b}', upperValue: '𝔹', upperCompositeKey: '\\mathbb{B}' },
    { value: '𝔟', compositeKey: '\\mathfrak{b}', upperValue: '𝔅', upperCompositeKey: '\\mathfrak{B}' }
    ],
    n: [
    { value: 'ñ' }, { value: 'ń' },
    { value: '𝓃', compositeKey: '\\mathcal{n}', upperValue: '𝒩', upperCompositeKey: '\\mathcal{N}' },
    { value: '𝕟', compositeKey: '\\mathbb{n}', upperValue: 'ℕ', upperCompositeKey: '\\mathbb{N}' },
    { value: '𝔫', compositeKey: '\\mathfrak{n}', upperValue: '𝔑', upperCompositeKey: '\\mathfrak{N}' }
    ],
    m: [
    { value: '𝓂', compositeKey: '\\mathcal{m}', upperValue: 'ℳ', upperCompositeKey: '\\mathcal{M}' },
    { value: '𝕞', compositeKey: '\\mathbb{m}', upperValue: '𝕄', upperCompositeKey: '\\mathbb{M}' },
    { value: '𝔪', compositeKey: '\\mathfrak{m}', upperValue: '𝔐', upperCompositeKey: '\\mathfrak{M}' }
    ],
    '.': [
    { value: ',' }, { value: '?' }, { value: '!' },
    { value: ';' }, { value: ':' },
    { value: '…', compositeKey: '\\ldots' }, { value: '⋯', compositeKey: '\\cdots' },
    { value: '⁝', compositeKey: '\\vdots' }, { value: '⋱', compositeKey: '\\ddots' },
    { value: '⋰', compositeKey: '\\iddots' }, { value: '∴', compositeKey: '\\therefore' },
    { value: '∵', compositeKey: '\\because' }
    ]
  },
  keys: [
    [
      { value: 'CTRL', ratio: 10, keyCode: KeyboardEvent.DOM_VK_CONTROL }
    ],
    [
      { value: 'q' }, { value: 'w' }, { value: 'e' } , { value: 'r' },
      { value: 't' } , { value: 'y' }, { value: 'u' } , { value: 'i' },
      { value: 'o' }, { value: 'p' }
    ], [
      { value: 'a' }, { value: 's' }, { value: 'd' }, { value: 'f' },
      { value: 'g' } , { value: 'h' }, { value: 'j' }, { value: 'k' },
      { value: 'l' },
      { value: ':', visible: ['url']}, { value: '_', visible: ['email']}
    ], [
      { value: '⇪', ratio: 1.5, keyCode: KeyEvent.DOM_VK_CAPS_LOCK },
      { value: 'z' }, { value: 'x' }, { value: 'c' }, { value: 'v' },
      { value: 'b' }, { value: 'n' }, { value: 'm' },
      { value: '⌫', ratio: 1.5, keyCode: KeyEvent.DOM_VK_BACK_SPACE }
    ], [
      { value: '&nbsp', ratio: 8, keyCode: KeyboardEvent.DOM_VK_SPACE },
      { value: '↵', ratio: 2, keyCode: KeyEvent.DOM_VK_RETURN }
    ]
  ],
  alternateLayout: {
    disableAlternateLayout: true,
    alt: {
      '0': 'º',
      '1': '1st ',
      '2': '2nd ',
      '3': '3rd ',
      '4': '4th ',
      '5': '5th ',
      '6': '6th ',
      '7': '7th ',
      '8': '8th ',
      '9': '9th ',
      '$': '€ £ ¥',
      '?': '¿',
      '!': '¡'
    },
    keys: [
      [
        { value: 'CTRL', ratio: 10, keyCode: KeyboardEvent.DOM_VK_CONTROL }
      ],
      [
        { value: '1' }, { value: '2' }, { value: '3' } , { value: '4' },
        { value: '5' } , { value: '6' }, { value: '7' } , { value: '8' },
        { value: '9' }, { value: '0' }
      ], [
        { value: '@' }, { value: '#' },
        { value: '$', className: 'alternate-indicator' }, { value: '&' },
        { value: '*' }, { value: '-' }, { value: '_' }, { value: '/' },
        { value: '(' }, { value: ')' }
      ], [
        { value: 'ALT', ratio: 1.5, keyCode: KeyEvent.DOM_VK_ALT },
        { value: '+', supportsSwitchingValue: ',' }, { value: ':' },
        { value: ';' }, { value: '"' },
        { value: '\'' }, { value: '?' }, { value: '!' },
        { value: '⌫', ratio: 1.5, keyCode: KeyEvent.DOM_VK_BACK_SPACE }
      ], [
        { value: '&nbsp', ratio: 8, keyCode: KeyboardEvent.DOM_VK_SPACE },
        { value: '↵', ratio: 2, keyCode: KeyEvent.DOM_VK_RETURN }
      ]
    ]
  },
  symbolLayout: {
    disableAlternateLayout: true,
    keys: [
      [
        { value: 'CTRL', ratio: 10, keyCode: KeyboardEvent.DOM_VK_CONTROL }
      ],
      [
        { value: '¥' }, { value: '€' }, { value: '£' }, { value: '¢' },
        { value: '₠' }, { value: '%' }, { value: '©' }, { value: '®' },
        { value: '|' }, { value: '\\' }
      ], [
        { value: '~' }, { value: '°C', compositeKey: '°C' },
        { value: '°F', compositeKey: '°F' }, { value: '°' },
        { value: '<' }, { value: '>' }, { value: '[' }, { value: ']' },
        { value: '{' }, { value: '}' }
      ], [
        { value: 'ALT', ratio: 1.5, keyCode: KeyEvent.DOM_VK_ALT },
        { value: '`' }, { value: '^' }, { value: '±', supportsSwitchingValue: '+' },
        { value: '=' }, { value: '§' }, { value: '¿'}, {value: '¡'},
        { value: '⌫', ratio: 1.5, keyCode: KeyEvent.DOM_VK_BACK_SPACE }
      ], [
        { value: '&nbsp', ratio: 8, keyCode: KeyboardEvent.DOM_VK_SPACE },
        { value: '↵', ratio: 2, keyCode: KeyEvent.DOM_VK_RETURN }
      ]
    ]
  },
  latexGreekLayout: {
    disableAlternateLayout: true,
    keys: [
      [
        { value: 'CTRL', ratio: 10, keyCode: KeyboardEvent.DOM_VK_CONTROL }
      ],
      [
        { value: 'ς', compositeKey: '\\varsigma', upperValue: 'Σ', upperCompositeKey: '\\Sigma' },
        { value: 'ε', compositeKey: '\\epsilon', upperValue: 'E', upperCompositeKey: 'E' },
        { value: 'ρ', compositeKey: '\\rho', upperValue: 'P', upperCompositeKey: 'P' },
        { value: 'τ', compositeKey: '\\tau', upperValue: 'T', upperCompositeKey: 'T' },
        { value: 'υ', compositeKey: '\\upsilon', upperValue: 'Υ', upperCompositeKey: '\\Upsilon' },
        { value: 'θ', compositeKey: '\\theta', upperValue: 'Θ', upperCompositeKey: '\\Theta' },
        { value: 'ι', compositeKey: '\\iota', upperValue: 'I', upperCompositeKey: 'I' },
        { value: 'ο', compositeKey: '\\omicron', upperValue: 'O', uppercase: 'O' },
        { value: 'π', compositeKey: '\\pi', upperValue: 'Π', upperCompositeKey: '\\Pi' }
      ], [
        { value: 'α', compositeKey: '\\alpha', upperValue: 'A', upperCompositeKey: 'A' },
        { value: 'σ', compositeKey: '\\sigma', upperValue: 'Σ', upperCompositeKey: '\\Sigma' },
        { value: 'δ', compositeKey: '\\delta', upperValue: 'Δ', upperCompositeKey: '\\Delta' },
        { value: 'φ', compositeKey: '\\varphi', upperValue: 'Φ', upperCompositeKey: '\\Phi' },
        { value: 'γ', compositeKey: '\\gamma', upperValue: 'Γ', upperCompositeKey: '\\Gamma' },
        { value: 'η', compositeKey: '\\eta', upperValue: 'H', upperCompositeKey: 'H' },
        { value: 'ξ', compositeKey: '\\xi', upperValue: 'Ξ', upperCompositeKey: '\\Xi' },
        { value: 'κ', compositeKey: '\\kappa', upperValue: 'K', upperCompositeKey: 'K' },
        { value: 'λ', compositeKey: '\\lambda', upperValue: 'Λ', upperCompositeKey: '\\Lambda' },
      ], [
        { value: '⇪', ratio: 1.5, keyCode: KeyEvent.DOM_VK_CAPS_LOCK },
        { value: 'ζ', compositeKey: '\\zeta', upperValue: 'Z', upperCompositeKey: 'Z' },
        { value: 'χ', compositeKey: '\\chi', upperValue: 'X', upperCompositeKey: 'X' },
        { value: 'ψ', compositeKey: '\\psi', upperValue: 'Φ', upperCompositeKey: '\\Psi' },
        { value: 'ω', compositeKey: '\\omega', upperValue: 'Ω', upperCompositeKey: '\\Omega' },
        { value: 'β', compositeKey: '\\beta', upperValue: 'B', upperCompositeKey: 'B' },
        { value: 'ν', compositeKey: '\\nu', upperValue: 'N', upperCompositeKey: 'N' },
        { value: 'μ', compositeKey: '\\mu', upperValue: 'M', upperCompositeKey: 'M' },
        { value: '⌫', ratio: 1.5, keyCode: KeyEvent.DOM_VK_BACK_SPACE }
      ], [
        { value: '&nbsp', ratio: 8, keyCode: KeyboardEvent.DOM_VK_SPACE },
        { value: '↵', ratio: 2, keyCode: KeyEvent.DOM_VK_RETURN }
      ]
    ]
  },
  latexSymbolsLayout: {
  keyClassName: 'math',
  disableAlternateLayout: true,
  alt: {
    '<math><msqrt><mi>x</mi></msqrt></math>': [
        { value: '<math><mroot><mi>x</mi><mi>n</mi></mroot></math>', compositeKey: '\\sqrt[]{}', className: 'math' }
    ],
    '<math><mo>&lt;</mo></math>': [
        { value: '<math><mo>≤</mo></math>', compositeKey: '\\leq', className: 'math' },
        { value: '<math><mo>≦</mo></math>', compositeKey: '\\leqq', className: 'math' },
        { value: '<math><mo>≪</mo></math>', compositeKey: '\\ll', className: 'math' }
    ],
    '<math><mo>&gt;</mo></math>': [
        { value: '<math><mo>≥</mo></math>', compositeKey: '\\geq', className: 'math' },
        { value: '<math><mo>≧</mo></math>', compositeKey: '\\geqq', className: 'math' },
        { value: '<math><mo>≫</mo></math>', compositeKey: '\\gg', className: 'math' }
    ],
    '<math><mo>=</mo></math>': [
        { value: '<math><mo>≡</mo></math>', compositeKey: '\\equiv', className: 'math' },
        { value: '<math><mo>≠</mo></math>', compositeKey: '\\neq', className: 'math' },
        { value: '<math><mo>~</mo></math>', compositeKey: '\\sim', className: 'math' },
        { value: '<math><mo>≈</mo></math>', compositeKey: '\\approx', className: 'math' }
    ],
    '<math><mrow><mo>|</mo><mi>x</mi><mo>|</mo></mrow></math>': [
        { value: '<math><mrow><mo>‖</mo><mi>x</mi><mo>‖</mo></mrow></math>', compositeKey: '\\|\\|', className: 'math' },
    ],
    '<math><mo>∫</mo></math>': [
        { value: '<math><mo>∬</mo></math>', compositeKey: '\\iint', className: 'math' },
        { value: '<math><mo>∭</mo></math>', compositeKey: '\\iiint', className: 'math' },
        { value: '<math><mo>∮</mo></math>', compositeKey: '\\oint', className: 'math' },
        { value: '<math><mo>∯</mo></math>', compositeKey: '\\oiint', className: 'math' },
        { value: '<math><mo>∰</mo></math>', compositeKey: '\\oiiint', className: 'math' },
        { value: '<math><mo>∲</mo></math>', compositeKey: '\\ointclockwise', className: 'math' },
        { value: '<math><mo>∳</mo></math>', compositeKey: '\\ointctrclockwise', className: 'math' }
    ],
    '<math><mo>∑</mo></math>': [
        { value: '<math><mo>∏</mo></math>', compositeKey: '\\prod', className: 'math' },
    ],
    '<math><mo>(</mo><mi>x</mi><mo>)</mo></math>': [
        { value: '<math><mo>[</mo><mi>x</mi><mo>]</mo></math>', compositeKey: '\\left[\\right]', ratio: 1.5, className: 'math' },
        { value: '<math><mo>{</mo><mi>x</mi><mo>}</mo></math>', compositeKey: '\\left\\{\\right\\}', ratio: 1.5, className: 'math' },
        { value: '<math><mo>⟨</mo><mi>x</mi><mo>⟩</mo></math>', compositeKey: '\\langle\\rangle', ratio: 1.5, className: 'math' },
        { value: '<math><mo>⟪</mo><mi>x</mi><mo>⟫</mo></math>', compositeKey: '\\lang\\rang', ratio: 1.5, className: 'math' },
        { value: '<math><mo>⌈</mo><mi>x</mi><mo>⌉</mo></math>', compositeKey: '\\lceil\\rceil', ratio: 1.5, className: 'math' },
        { value: '<math><mo>⌊</mo><mi>x</mi><mo>⌋</mo></math>', compositeKey: '\\lfloor\\rfloor', ratio: 1.5, className: 'math' }
    ],
    '<math><mtable><mtr><mtd><mi>a</mi></mtd><mtd><mi>b</mi></mtd></mtr></mtable></math>': [
        { value: '<math><mfenced open="(" close=")"><mtable><mtr><mtd><mi>a</mi></mtd><mtd><mi>b</mi></mtd></mtr></mtable></mfenced></math>',
            compositeKey: '\\begin{pmatrix}\\end{pmatrix}', ratio: 2, className: 'math' },
        { value: '<math><mfenced open="[" close="]"><mtable><mtr><mtd><mi>a</mi></mtd><mtd><mi>b</mi></mtd></mtr></mtable></mfenced></math>',
            compositeKey: '\\begin{bmatrix}\\end{bmatrix}', ratio: 2, className: 'math' },
        { value: '<math><mfenced open="{" close="}"><mtable><mtr><mtd><mi>a</mi></mtd><mtd><mi>b</mi></mtd></mtr></mtable></mfenced></math>',
            compositeKey: '\\begin{Bmatrix}\\end{Bmatrix}', ratio: 2, className: 'math' },
        { value: '<math><mfenced open="|" close="|"><mtable><mtr><mtd><mi>a</mi></mtd><mtd><mi>b</mi></mtd></mtr></mtable></mfenced></math>',
            compositeKey: '\\begin{vmatrix}\\end{vmatrix}', ratio: 2, className: 'math' },
        { value: '<math><mfenced open="‖" close="‖"><mtable><mtr><mtd><mi>a</mi></mtd><mtd><mi>b</mi></mtd></mtr></mtable></mfenced></math>',
            compositeKey: '\\begin{Vmatrix}\\end{Vmatrix}', ratio: 2, className: 'math' },
        { value: '<math><mfenced open="{" close=""><mtable><mtr><mtd><mi>a</mi></mtd><mtd><mi>b</mi></mtd></mtr></mtable></mfenced></math>',
            compositeKey: '\\begin{cases}\\end{cases}', ratio: 2, className: 'math' }
    ],
    '<math><mover><mi>x</mi><mo>^</mo></mover></math>': [
        { value: '<math><mover><mi>x</mi><mo>ˇ</mo></mover></math>', compositeKey: '\\check{}', className: 'math' },
        { value: '<math><mover><mi>x</mi><mo>`</mo></mover></math>', compositeKey: '\\grave{}', className: 'math' },
        { value: '<math><mover><mi>x</mi><mo>ˊ</mo></mover></math>', compositeKey: '\\acute{}', className: 'math' },
        { value: '<math><mover><mi>x</mi><mo>~</mo></mover></math>', compositeKey: '\\tilde{}', className: 'math' },
        { value: '<math><mover><mi>x</mi><mo>-</mo></mover></math>', compositeKey: '\\bar{}', className: 'math' },
        { value: '<math><mover><mi>x</mi><mo>˘</mo></mover></math>', compositeKey: '\\breve{}', className: 'math' },
        { value: '<math><mover><mi>x</mi><mo>˳</mo></mover></math>', compositeKey: '\\mathring{}', className: 'math' },
        { value: '<math><mover><mi>x</mi><mo>˙</mo></mover></math>', compositeKey: '\\dot{}', className: 'math' },
        { value: '<math><mover><mi>x</mi><mo>˙˙</mo></mover></math>', compositeKey: '\\ddot{}', className: 'math' },
        { value: '<math><mover><mi>x</mi><mo>→</mo></mover></math>', compositeKey: '\\vec{}', className: 'math' }
    ],
    '<math><mo>∪</mo></math>': [
      { value: '<math><mo>∩</mo></math>', compositeKey: '\\cap', className: 'math' },
      { value: '<math><mo>∨</mo></math>', compositeKey: '\\vee', className: 'math' },
      { value: '<math><mo>∧</mo></math>', compositeKey: '\\wedge', className: 'math' }
    ],
    '<math><mo>∃</mo></math>': [
      { value: '<math><mo>∄</mo></math>', compositeKey: '\\nexists', className: 'math' },
      { value: '<math><mo>∀</mo></math>', compositeKey: '\\forall', className: 'math' },
      { value: '<math><mo>∁</mo></math>', compositeKey: '\\complement', className: 'math' },
      { value: '<math><mo>∅</mo></math>', compositeKey: '\\vernothing', className: 'math' },
      { value: '<math><mo>∞</mo></math>', compositeKey: '\\infty', className: 'math' },
    ],
    '<math><mo>⊂</mo></math>': [
      { value: '<math><mo>⊃</mo></math>', compositeKey: '\\supset', className: 'math' },
      { value: '<math><mo>⊄</mo></math>', compositeKey: '\\nsubset', className: 'math' },
      { value: '<math><mo>⊅</mo></math>', compositeKey: '\\nsupset', className: 'math' },
      { value: '<math><mo>⊆</mo></math>', compositeKey: '\\subseteq', className: 'math' },
      { value: '<math><mo>⊇</mo></math>', compositeKey: '\\supseteq', className: 'math' },
      { value: '<math><mo>⊈</mo></math>', compositeKey: '\\nsubseteq', className: 'math' },
      { value: '<math><mo>⊉</mo></math>', compositeKey: '\\nsupseteq', className: 'math' },
    ],
    '<math><mo>←</mo></math>': [
        { value: '<math><mo>↚</mo></math>', compositeKey: '\\nleftarrow', className: 'math' },
        { value: '<math><mo>⟵</mo></math>', compositeKey: '\\longleftarrow', ratio: 2, className: 'math' },
        { value: '<math><mo>⇐</mo></math>', compositeKey: '\\Leftarrow', className: 'math' },
        { value: '<math><mo>⇍</mo></math>', compositeKey: '\\nLeftarrow', className: 'math' },
        { value: '<math><mo>⟸</mo></math>', compositeKey: '\\Longleftarrow', ratio: 2, className: 'math' }
    ],
    '<math><mo>↔</mo></math>': [
        { value: '<math><mo>↮</mo></math>', compositeKey: '\\nleftrightarrow', className: 'math' },
        { value: '<math><mo>⟷</mo></math>', compositeKey: '\\longleftrightarrow', ratio: 2, className: 'math' },
        { value: '<math><mo>⇔</mo></math>', compositeKey: '\\Leftrightarrow', className: 'math' },
        { value: '<math><mo>⇎</mo></math>', compositeKey: '\\nLeftrightarrow', className: 'math' },
        { value: '<math><mo>⟺</mo></math>', compositeKey: '\\Longleftrightarrow', ratio: 2, className: 'math' }
    ],
    '<math><mo>→</mo></math>': [
        { value: '<math><mo>↛</mo></math>', compositeKey: '\\nrightarrow', className: 'math' },
        { value: '<math><mo>⟶</mo></math>', compositeKey: '\\longrightarrow', ratio: 2, className: 'math' },
        { value: '<math><mo>⇒</mo></math>', compositeKey: '\\Rightarrow', className: 'math' },
        { value: '<math><mo>⇏</mo></math>', compositeKey: '\\nRightarrow', className: 'math' },
        { value: '<math><mo>⟹</mo></math>', compositeKey: '\\Longrightarrow', ratio: 2, className: 'math' }
    ]
  },
  keys: [
      [
        { value: 'CTRL', ratio: 10, keyCode: KeyboardEvent.DOM_VK_CONTROL }
      ],
    [
      { value: '<math><msub><mi>x</mi><mi>y</mi></msub></math>', compositeKey: '{}_{}', className: 'math' },
      { value: '<math><msqrt><mi>x</mi></msqrt></math>', compositeKey: '\\sqrt{}', className: 'math' },
      { value: '<math><mo>&lt;</mo></math>', compositeKey: '<', className: 'math' },
      { value: '<math><mo>&gt;</mo></math>', compositeKey: '>', className: 'math' },
      { value: '<math><mo>=</mo></math>', compositeKey: '=', className: 'math' },
      { value: '<math><mrow><mo>|</mo><mi>x</mi><mo>|</mo></mrow></math>', compositeKey: '||', className: 'math' },
      { value: '<math><mfrac><mi>x</mi><mi>y</mi></mfrac>', compositeKey: '\\frac{}{}', className: 'math' },
      { value: '<math><mo>×</mo></math>', compositeKey: '\\times', className: 'math' },
      { value: '<math><msubsup><mi>x</mi><mi>y</mi><mi>z</mi></msubsup></math>', compositeKey: '{}_{}^{}', className: 'math' },
      { value: '<math><msup><mi>x</mi><mi>y</mi></msup></math>', compositeKey: '{}^{}', className: 'math' }
    ], [
      { value: '<math><munder><mi>x</mi><mi>y</mi></munder></math>', compositeKey: '\\underset{}{}', className: 'math' },
      { value: '<math><mo>∫</mo></math>', compositeKey: '\\int', className: 'math' },
      { value: '<math><mo>∂</mo></math>', compositeKey: '\\partial', className: 'math' },
      { value: '<math><mo>∇</mo></math>', compositeKey: '\\nabla', className: 'math' },
      { value: '<math><mo>∑</mo></math>', compositeKey: '\\sum', className: 'math' },
      { value: '<math><mo>(</mo><mi>x</mi><mo>)</mo></math>', compositeKey: '\\left(\\right)', className: 'math' },
      { value: '<math><mo>+</mo></math>', compositeKey: '+', className: 'math' },
      { value: '<math><mo>-</mo></math>', compositeKey: '-', className: 'math' },
      { value: '<math><munderover><mi>x</mi><mi>y</mi><mi>z</mi></munderover></math>', compositeKey: '\\underset{}{\\overset{}{}}', className: 'math' },
      { value: '<math><mover><mi>x</mi><mi>y</mi></mover></math>', compositeKey: '\\overset{}{}', className: 'math' },
    ], [
      { value: '<math><mtable><mtr><mtd><mi>a</mi></mtd><mtd><mi>b</mi></mtd></mtr></mtable></math>', compositeKey: '\\begin{matrix}\\end{matrix}', ratio: 1.5, className: 'math' },
      { value: '<math><mover><mi>x</mi><mo>^</mo></mover></math>', compositeKey: '\\hat{}', className: 'math' },
      { value: '<math><mo>∪</mo></math>', compositeKey: '\\cup', className: 'math' },
      { value: '<math><mo>∃</mo></math>', compositeKey: '\\exists', className: 'math' },
      { value: '<math><mo>⊂</mo></math>', compositeKey: '\\subset', className: 'math' },
      { value: '<math><mo>←</mo></math>', compositeKey: '\\leftarrow', className: 'math' },
      { value: '<math><mo>↔</mo></math>', compositeKey: '\\leftrightarrow', className: 'math' },
      { value: '<math><mo>→</mo></math>', compositeKey: '\\rightarrow', className: 'math' },
      { value: '⌫', ratio: 1.5, keyCode: KeyEvent.DOM_VK_BACK_SPACE }
    ], [
      { value: '&nbsp', ratio: 8, keyCode: KeyboardEvent.DOM_VK_SPACE },
      { value: '↵', ratio: 2, keyCode: KeyEvent.DOM_VK_RETURN }
    ]
  ]
  },
  latexFunctionsLayout: {
  keyClassName: 'math',
  disableAlternateLayout: true,
  keys: [
      [
        { value: 'CTRL', ratio: 10, keyCode: KeyboardEvent.DOM_VK_CONTROL }
      ],
    [
      { value: '<math><mo>min</mo></math>', compositeKey: '\\min', ratio:2, className: 'math' },
      { value: '<math><mo>sin</mo></math>', compositeKey: '\\sin', ratio:2, className: 'math' },
      { value: '<math><mo>cos</mo></math>', compositeKey: '\\cos', ratio:2, className: 'math' },
      { value: '<math><mo>tan</mo></math>', compositeKey: '\\tan', ratio:2, className: 'math' },
      { value: '<math><mo>max</mo></math>', compositeKey: '\\max', ratio:2, className: 'math' }
    ], [
      { value: '<math><mo>inf</mo></math>', compositeKey: '\\inf', ratio:2, className: 'math' },
      { value: '<math><mo>arg</mo></math>', compositeKey: '\\arg', ratio:2, className: 'math' },
      { value: '<math><mo>mod</mo></math>', compositeKey: '\\mod', ratio:2, className: 'math' },
      { value: '<math><mfenced><mfrac linethickness="0"><mi>x</mi><mi>y</mi></mfrac></mfenced></math>', compositeKey: '\\binom{}{}', className: 'math', ratio:2 },
      { value: '<math><mo>sup</mo></math>', compositeKey: '\\sup', ratio:2, className: 'math' }
    ], [
      { value: '<math><mo>det</mo></math>', compositeKey: '\\det', ratio:2, className: 'math' },
      { value: '<math><mo>deg</mo></math>', compositeKey: '\\deg', ratio:2, className: 'math' },
      { value: '<math><mo>dim</mo></math>', compositeKey: '\\dim', ratio:2, className: 'math' },
      { value: '<math><mo>ker</mo></math>', compositeKey: '\\ker', ratio:2, className: 'math' },
      { value: '⌫', ratio: 2, keyCode: KeyEvent.DOM_VK_BACK_SPACE }
    ], [
      { value: '&nbsp', ratio: 8, keyCode: KeyboardEvent.DOM_VK_SPACE },
      { value: '↵', ratio: 2, keyCode: KeyEvent.DOM_VK_RETURN }
    ]
  ]
  }
};
