/*------------------------------------------------------
 Initialize various global variables
 ------------------------------------------------------ */

var mercatorRange       = 256;      // Constant used in geographical calculations
var networkInterval     = 0;        // ID of setInternal for network detection
var canUseNetwork       = false;    // Flag set to TRUE if we have detected network availability
var howUseNetwork       = false;    // What is my network connection type?
var networkError        = false;    // Are we in the middle of a network reachability issue?
var googleMapsLoaded    = false;    // Have we loaded the Google Maps API code?
var loadedMapOnce       = false;    // Have I loaded the Google Map at least once?
var currentPosition     = false;    // A string (lat + "," + long) of our current geolocation
var positionError       = false;    // Did we get a geolocation error?
var positionInterval    = false;    // ID of watchPosition for re-establishing position
var imageFile           = false;    // Holds the photo we took with the camera
var foliageLevels       = [ 'Green', 'Turning', 'Moderate', 'Peak', 'Fading', 'Gone' ];
var foliageColors       = [ '#02D41B', '#FFFF00', '#FF9900', '#E50B0B', '#CC6600', '#C0C0C0' ];
var shownGreenWarn      = false;    // Have we shown user a warning about submitting a "green" foliage report?
var touchTextarea       = false;    // Have we touched the "description" textarea yet?
var descHeight          = 0;        // Original height of the foliagetext field

var runInSafari         = false;    // Are we going to test the app by running it in Safari?
var debugShow           = false;     // Show debug messages?
var makeScreenShots     = false;    // Set to 'true' only to set the app up for "pre-activated" screen shots.
var reportnumber        = 0;
var image_with_report   = 0;
var reportcounty        = '';
var reportlatitude      = '';
var reportlongitude     = '';
var reportloc           = '';
var reportcolorword     = '';
var last_infowindow     = false;

var currentReportID     = '';       // what's the unique ID of the current report?

/*----------------------------------------------------------------------------------
 Handle the "share" Web Activity from other apps.
 ----------------------------------------------------------------------------------- */

navigator.mozSetMessageHandler('activity', function(activityRequest) {
  var option = activityRequest.source;
  if (option.name === "share") {
    captureSuccess(option.data.blobs[0]);
  }
});

/*----------------------------------------------------------------------------------
 When this function is called, PhoneGap has been initialized and is ready to roll 
 ----------------------------------------------------------------------------------- */

function onDeviceReady() {

	$.ajaxSetup( {
		xhr: function() {
			return new window.XMLHttpRequest( {
				mozSystem: true
			} );
		}
	} );

	if (debugShow) { console.log("Starting app." ); }

    $.mobile.defaultDialogTransition = 'none';
    $.mobile.defaultPageTransition = 'none';
    $.mobile.buttonMarkup.hoverDelay = 50;

    /* Look up current geolocation */
    if (debugShow) { console.log("Triggering geolocation lookup" ); }
    navigator.geolocation.getCurrentPosition(successGeolocation, errorNoGeolocation, { maximumAge: 900000, timeout: 15000 });
    /* If we're in Safari then we're going to assume we're online and don't need to check all the time */
    if (runInSafari) {
        areWeOnline();
    }
    else {
        /* Ensure we're online once every second */
        setInterval( function() {
                    areWeOnline();
                    }, 1000);
    }
    
    /* Click on "Add Photo" opens the dialog to allow selection of Camera or Camera Roll */
    $('#takepicture,#camera').bind("click", function () {
		getPicture();
    });
    
    /* Click on State of Maine logo, opens in Mobile Browser */
    $('#advertiser').bind("click", function () {
        if (debugShow) { console.log("Click on Advertiser Logo"); }
        adurl = "http://servedby.flashtalking.com/click/3/25972;628017;50126;211;0/?ft_width=1&ft_height=1&url=4162063";
        window.open(adurl,'_system');
    });
    
    /* Click on the "Peep It" button if we warned user they didn't select a foliage color */
    $('#green-peepit-button').bind("click", function () {
        submitTheReport();
    });
    
    /* If user touches inside the "foliagetext" textarea we remove its contents if they haven't touched there before */
    $('#foliagetext').bind('tap', function(event, ui) { 
        if (!touchTextarea) {
            $('#foliagetext').val('');
            $('#foliagetext').removeClass('helptextgray');
            touchTextarea = true;
        }
    });
    
    /* Click on "Report" from Thank-you Page */
    $('#thanks-report-button').bind("click", function () {
        $.mobile.changePage( "#page-report", {reverse: true } );
    });
    
    /* Click on "Map" from Thank-you Page */
    $('#thanks-map-button').bind("click", function () { 
        $.mobile.changePage( "#page-map", {reverse: false } );
        // need to set mapcenter to the lat/lon value that was submitted as part of the report
        google.maps.event.trigger(map, 'resize');
        map.setZoom(map.getZoom());

        reportlocation = new google.maps.LatLng(reportlatitude,reportlongitude);
        map.setCenter(reportlocation);
        
        if (last_infowindow) {
            last_infowindow.close();
            last_infowindow = false;
        }
        
        var html = '<div id="report-report">Your report will be added to all other reports from this area and used to update the map each day.</div>';
        var infowindow = new google.maps.InfoWindow({maxWidth: 200});
        infowindow.setPosition(reportlocation);
        infowindow.setContent(html);
        infowindow.open(map);
        last_infowindow = infowindow;

    });
   
    /* Use Current Location */
    $('#use-current-location').bind("click", function () { 
        $("#reportposition").val(currentPosition);
        reportlatitude = currentPositionLatitude;
        reportlongitude = currentPositionLongitude;
        reportcounty        = '';
        reportloc           = '';
        reportcolorword     = '';
        $('#locationvalue').html("Current Location");
        $('#locationerrormessages').html("");
        $('.ui-dialog').dialog('close');
    });

    /* Change from current location in location field, show current location button div */
    $('#changelocationbutton').click("click", function () {
        locationValidate();
    });
    
    /* Change Location */
    $('#changelocation').bind("click", function () {
        $.mobile.changePage("#page-location-choose");
    });
    
    /* Click on "Peep It!" submits a foliage report */
    $('#submitreport').bind("click", function () {         
        if (($("#slider").val() == 1) && (!shownGreenWarn)) {
            shownGreenWarn = true;
            $("#lnkDialog").click();
        }
        else {
            submitTheReport();
        }
    });
    
    /* Share to Social Message plugin */
    $('#share-button').bind("tap", function () {
        socialMesssage();
    });
  
    /* Send Us Feedback */
    $('#sendusfeedback').bind("tap", function () {
        sendUsFeedback();
    });
    
}



function nativePluginResultHandler (result) {
    //alert('nativePluginResultHandler - '+result);
    console.log('nativePluginResultHandler: '+result);
}
        
function nativePluginErrorHandler (error) {
    //alert('nativePluginErrorHandler - '+error);
    console.log('nativePluginErrorHandler: '+error);
}

function sendUsFeedback() {

    if (debugShow) { console.log("Opening email window to send feedback." ); }

	var activity = new MozActivity({
	  // Ask for the "pick" activity
	  name: "new",

	  // Provide the data required by the filters of the activity
	  data: {
		type: "mail"
	  }
	});

	activity.onsuccess = function() {
	  var picture = this.result;
	  console.log("A picture has been retrieved");
	};

	activity.onerror = function() {
	  console.log(this.error);
	};

}

/*------------------------------------------------------ 
 'SHARE' BUTTON
 ------------------------------------------------------ */

function socialMesssage() {

    var url = "http://www.yankeefoliage.com/live-fall-foliage-map/";
    var image_url = '';
    if (image_with_report == 1) {
        // image_url = 'http://www.yankeefoliage.com/live-fall-foliage-map/photos/user/mobile/' + reportnumber + '-oriented.jpg';
        image_url = 'http://www.yankeefoliage.com/live-fall-foliage-map/photos/user/mobile/' + reportnumber + '-oriented-resized.jpg';
    }

    var title = makeSocialPost('Twitter');

    window.socialmessage.send(title);
}

/*------------------------------------------------------
 MAKE A POST FOR TWITTER, FACEBOOK OR EMAIL
 ------------------------------------------------------ */

function makeSocialPost(network) {
    if (reportloc) {
        title = 'I reported the foliage in ' + reportloc + ' as ' + reportcolorword + ".";
    }
    else if (reportcounty) {
        title = 'I reported the foliage in ' + reportcounty + ' as ' + reportcolorword + '.';
    }
    else {
        title = 'I reported the foliage as ' + reportcolorword + '.';
    }
    if (network == "Twitter") {
        title = title + " (via @yankeefoliage)";
    }
    if (network == "Email") {
        title = title + "\n\nVisit http://yankeefoliage.com/live-fall-foliage-map/ to see current foliage across New England.";
    }
    return title;
}

/*------------------------------------------------------ 
 SUBMIT A REPORT VIA AJAX
 ------------------------------------------------------ */

function submitTheReport() {
    
    /* Disable the fields and controls on the report page */
    $('.info-button').addClass('ui-disabled');
    $('.map-button').addClass('ui-disabled');
    $('#myloc_button').addClass('ui-disabled');
    $('#camera').addClass('ui-disabled');
    
    $('div.ui-slider').css('opacity','0.3');
    $('#slider').slider('disable');    
    $('#example-image').css('opacity','0.3');
    $('#camera').css('opacity','0.3');
    $('#placeholder').css('opacity','0.3');
    $('#foliagetext').css('opacity','0.3');
    $('#locationwrapper').css('opacity','0.3');
    $('#foliagetext').textinput('disable');
    $('#takepicture').button('disable');
    $('#submitreport').button('disable');
    
    /* If they didn't touch the foliagetext field, then remove the help text */
    if (!touchTextarea) {
        $('#foliagetext').val('');
    }

   	if (debugShow) { console.log("Setting up 'loading' message..."); }
    
    /* Set the "loading" message to the appropriate value */
    if (imageFile) {
        $.mobile.loadingMessage = "Sending your report... (because you added a photo, this might take a while)";
    }
    else {
        $.mobile.loadingMessage = "Sending your report...";
    }
    
    /* Show the "loading" message */
    $.mobile.loadingMessageTextVisible = true;
    $.mobile.showPageLoadingMsg();    
    
    /* Object to store the parameters we POST to the webserver */
    var locdata = {};
    locdata.position = $("#reportposition").val();
    locdata.rating = $("#slider").val();
    locdata.comment = $("#foliagetext").val();
    
    /* If we have an image, we use the PhoneGap file uploading methods, otherwise just a simple AJAX POST. */
    if (imageFile) {
      	if (debugShow) { console.log("Image detected; sending report with uploadFile()"); }
		var fd = new FormData();    
		fd.append( 'file', imageFile);
		fd.append( 'position', locdata.position );
		fd.append( 'rating', locdata.rating);
		fd.append( 'comment', locdata.comment);

        $.ajax({
		   type: "POST",
		   url: "http://www.yankeefoliage.com/live-fall-foliage-map/postreport-frommobile-2.php",
		   data: fd,
		   processData: false,
		   contentType: false,
		   dataType: "json",
		   success: reportStatus,
		   error: reportError,
		   timeout: 30000
		 });                            
    }        
    else {   
      	if (debugShow) { console.log("No image detected; sending report with .ajax()"); }
        $.ajax({
		   type: "POST",
		   url: "http://www.yankeefoliage.com/live-fall-foliage-map/postreport-frommobile-2.php",
		   data: locdata,
		   dataType: "json",
		   success: reportStatus,
		   error: reportError,
		   timeout: 30000
        });                            
    }
    
}

/*------------------------------------------------------ 
 REPORT CALLBACKS
 ------------------------------------------------------ */

/* SUCCESS callback function for the posting of a foliage report */
function reportStatus(result) {

   	if (debugShow) { console.dir(result); }

    if (result.message) {
        $("#reportmessage").html(result.message);
    }
    else {
        message = "<p>You reported the foliage as:</p><img src='images/" + ($("#slider").val()) + "-2x.png'>"; 
        $("#reportmessage").html(message);
    }        
    
    if (imageFile) {        
        image_with_report = 1;
    }
    else {
        image_with_report = 0;
	}

	if (result.colorword) {
		reportcolorword =  result.colorword;
	}
	if (result.foliagestatus.county) {
		window.localStorage.setItem("county", result.foliagestatus.county);
		reportcounty = result.foliagestatus.county;
	}
	reportnumber = result.reportnumber;
    
    /* Populate the #reportid field with a unique ID */
    currentReportID = String('id' + (new Date()).getTime());

    /* Display a thank-you page */
    $.mobile.changePage( "#page-thanks");

}

/* FAILURE callback function for the posting of a foliage report */
function reportError(error) {
    msg = "There was a problem submitting your report. Please try again.";
    navigator.notification.alert(msg, null, 'Report Not Submitted');
}

function LocError(error) {
    //    msg = "Location Error.";
    //    navigator.notification.alert(msg, null, 'Location Error');
}

function updateFoliageReportPage() {
    if (!makeScreenShots) {
        $('#report-help').html(foliageLevels[$("#slider").val()-1]);
    }
    $('.ui-slider').css("background",foliageColors[$("#slider").val()-1]);
    $('.ui-slider-handle').css("background",foliageColors[$("#slider").val()-1]);
    $('.ui-slider-track').css("background",foliageColors[$("#slider").val()-1]);

}

/*------------------------------------------------------ 
 NETWORK REACHABILITY CALLBACKS
 ------------------------------------------------------ */

function areWeOnline() {

//     if (!runInSafari) {
//         howUseNetwork = navigator.connection;
//     }
//     else {
//         howUseNetwork = Connection.WIFI;
//     }

		howUseNetwork = 1;

  // if (debugShow) { console.log("Network connection: " + howUseNetwork); }

    
    /*------------------------------------------------------ 
     We have NO network connected. Show error message and
     disable the Twitter, Facebook and Share buttons.
     ------------------------------------------------------ */
    
    if (!howUseNetwork) {
			   if (debugShow) { console.log("Network connection error: " + howUseNetwork); }
        if (!networkError) {
            canUseNetwork = false;
            networkError = true;
            $.mobile.changePage( "#page-nointernet");
        }
    }
    else {
        
        if (!canUseNetwork) {

            myRand=parseInt(Math.random()*99999999);  // cache buster
            $('#advertiser-tracking-gif').html('<img src="<img style="width:1px; height:1px;" src="http://servedby.flashtalking.com/imp/3/25972;628017;201;pixel;YankeeMagazine;FallLeefPeeperSponsorship/?cachebuster=' + myRand + '"/>">')
            googleMapsIsLoaded();
            
            if (debugShow) { console.log("Network connection: " + howUseNetwork); }
            
            if (!makeScreenShots) {
                $('.info-button').removeClass('ui-disabled');
                $('#takepicture').button('enable');
                $('#camera').removeClass('ui-disabled');
                $('#changemylocation').removeClass('ui-disabled');            
                $('#report-help').html("Slide to Rate Foliage");
                $('div.ui-slider').css('opacity','1');
                $('#example-image').css('opacity','1');
                $('#camera').css('opacity','1');
                $('#placeholder').css('opacity','1');
                $('#locationwrapper').css('opacity','1');
                $('#foliagetext').css('opacity','1');
                
                if (currentPosition) {
                    $('#submitreport').button('enable');
                    $('#submitreport').removeClass('ui-disabled');
                }
            }
        }
        if (networkError) {
            if (!currentPosition) {
                /* Look up current geolocation */
                navigator.geolocation.getCurrentPosition(successGeolocation, errorNoGeolocation, { maximumAge: 900000, timeout: 15000 });
            }
            networkError = false;
            $.mobile.changePage( "#page-report");
        }
        canUseNetwork = true;
    }
    
    return true;
}

function googleMapsIsLoaded() {
    if (debugShow) { console.log("Google Map API Code Has Loaded"); }
    
    googleMapsLoaded = true;
    if (!makeScreenShots) {
        $('.map-button').removeClass('ui-disabled');
        $('#report-map-button').attr('href','#page-map');
        $('#thanks-map-button').attr('href','#page-map');
    }
}

/*------------------------------------------------------ 
 GEOLOCATION CALLBACKS
 ------------------------------------------------------ */

function updatePosition(position) {
    currentPosition = position.coords.latitude + "," + position.coords.longitude;
}

function noPositionFound() {
    if (debugShow) { console.log("No geolocation found on update."); }
}

/* Set the center of the Google Map to the geolocation received by the device */
function successGeolocation(position) {

    $('#use-current-location').button('enable');
    $('#use-current-location').removeClass('ui-disabled');
    $('#locationvalue').html("Current Location");
    if (canUseNetwork) {
        $('#submitreport').button('enable');
        $('#submitreport').removeClass('ui-disabled');
    }
    
    currentPosition = position.coords.latitude + "," + position.coords.longitude;
    currentPositionLatitude = position.coords.latitude;
    currentPositionLongitude = position.coords.longitude;
    
    reportlatitude = position.coords.latitude;
    reportlongitude = position.coords.longitude;
    
    $("#reportposition").val(currentPosition);

    if (positionError) {
        $.mobile.changePage( "#page-report");
    }
    if (positionInterval) {
        navigator.geolocation.clearWatch(positionInterval);
    }
    positionInterval = navigator.geolocation.watchPosition(updatePosition, noPositionFound, { maximumAge: 60000, frequency: 3000 });
    positionError = false;
    
    if (debugShow) { console.log("Got geolocation: " + currentPosition); }
}


/* For debugging purposes only, show an error if we cannot get the geolocation */
function errorNoGeolocation(error) {
    if (debugShow) { console.log("No geolocation found on attempt for initial lock."); }
}

/*------------------------------------------------------ 
 PHOTO TAKING CALLBACKS
 ------------------------------------------------------ */

function getPicture() {
	
 	if (debugShow) { console.log("Getting a picture." ); }	
	
  var activity = new MozActivity({
	 name: "pick",
	 data: {
		 type: ["image/jpg", "image/jpeg" ]
	  }
  });
  
  activity.onsuccess = function () {
    captureSuccess(this.result.blob);
  };
  
  // Display an alert if we cancel the file picker operation.
  pick.onerror = function () {
    captureError("No file selected.");
  };  
  
}

function captureSuccess(imageData) {
	// Create image and set the returned blob as the src
    var img = document.createElement("img");
    img.src = window.URL.createObjectURL(imageData);

    imageFile = imageData;
    $('#placeholder').css('background-image', 'url("' + img.src + '")');
    $.mobile.changePage( "#page-report");
}

function captureError(error) {
    if (error == "no camera available") {
        msg = "It looks like you don't have a camera in this device.";
        navigator.notification.alert(msg, null, 'No Camera Found');
    }
    else if (error == "no image selected") {
        msg = "You didn't select a photo!";
        navigator.notification.alert(msg, null, 'No Photo Found');
    }
    else {
        msg = 'An error occurred during capture: ' + error.code;
        navigator.notification.alert(msg, null, 'Uh oh!');
    }
}

/*------------------------------------------------------ 
 PAGE CREATE FUNCTIONS
 ------------------------------------------------------ */

$('#page-report').on("pageinit", function(event, ui) {

	onDeviceReady();

    if (debugShow) { console.log("Calling pageinit for page-report" ); }
    $('#submitreport').button();
    $('#submitreport').button('disable');
    $('#takepicture').button();
    $('#takepicture').button('disable');
    $('#use-current-location').button();
    $('#use-current-location').button('disable');
    descHeight = $("#foliagetext").css("height");
});

$('#page-report').on("pageshow", function(event, ui) {
     
    if (debugShow) { console.log("Calling pageshow for page-report" ); }                
                     
    $('.ui-slider').css("width","85%");
    $('.ui-slider').css("background",foliageColors[0]);
    $('.ui-slider-handle').css("background",foliageColors[0]);
    $("#slider").slider("refresh"); 
    updateFoliageReportPage();

    $('.ui-slider').on('mouseup', function(event, ui) {
        updateFoliageReportPage();
    });

    $('.ui-slider').on('tap', function(event, ui) {
        updateFoliageReportPage();    
    });

    $('.ui-slider').on('touchend', function(event, ui) {
        updateFoliageReportPage();
    });

    $('.ui-slider').on('taphold', function(event, ui) {
        updateFoliageReportPage();
    }); 
});

$('#page-map').on("pageshow", function() {


    if (debugShow) { console.log("Calling pageshow for page-map" ); }
    
    if (debugShow) { console.log("Got content height of: " + getRealContentHeight()); }

    $('#content').height(getRealContentHeight());
    $('#map_canvas').height(getRealContentHeight());
                  
    if (!loadedMapOnce) {
        if (debugShow) { console.log("Starting map page creation" ); }
    
        /* We set the default center of the map to the lat/lng of the middle of New England */
        try {
            if (reportlatitude > 0) {
                var mapcenter = new google.maps.LatLng(reportlatitude,reportlongitude);
            }
            if (mapcenter) {
                initialPosition = mapcenter;
            }
            else {
                var newengland = new google.maps.LatLng(43.117024121350475, -70.938720703125);            
                initialPosition = newengland;    
            }
    
            /* Set up initial options for the Google Map - see http://code.google.com/apis/maps/documentation/javascript/reference.html#MapOptions */
            var myOptions = {
                zoom: 6,
                minZoom: 6,
                center: initialPosition,
                mapTypeControl: false   ,                
                overviewMapControl: false,
                panControl: false,
                streetViewControl: false,
                zoomControl: true,
                zoomControlOptions: {
                    style: google.maps.ZoomControlStyle.SMALL,
                    position: google.maps.ControlPosition.LEFT_BOTTOM
                },
                mapTypeId: google.maps.MapTypeId.ROADMAP
            };
            map = new google.maps.Map(document.getElementById("map_canvas"),myOptions);
    
            google.maps.event.addListener(map, 'tilesloaded', function() {
                // $("#map-loading-banner").hide();
                if (debugShow) { console.log("Map created. Bounds are: " + map.getBounds() ); }
                if (debugShow) { console.log("All tiles loaded"); }
            });
    
            if (debugShow) { console.log("Starting WMS load"); }
    
            loadWMS();
    
            if (debugShow) { console.log("WMS loaded"); }
    
            loadedMapOnce = true;
            
            var infowindow = new google.maps.InfoWindow({maxWidth: 200});
    
            var update_timeout = null;

            // hack to prevent double click from opening infowindow *and* zooming
            google.maps.event.addListener(map, 'click', function(event){
                update_timeout = setTimeout(function(){
                    if (debugShow) { console.log("click on map"); }
                    showFoliageStatus(event,infowindow);
                }, 200);        
            });
    
            google.maps.event.addListener(map, 'dblclick', function(event) {       
                clearTimeout(update_timeout);
            });
            
            map.controls[google.maps.ControlPosition.TOP_LEFT].push(new colorKeyControl());
        }
        catch(err) {
            msg = "You weren't connected to the Internet when you launched this app, so we couldn't load the map. Quit the app and restart while connected, and you'll be able to see it.";
            navigator.notification.alert(msg, null, 'Cannot Display Map');
        }
    }
    else {
        google.maps.event.trigger(map,'resize') ;
    }
});

function getRealContentHeight() {
	var header = $.mobile.activePage.find("div[data-role='header']:visible");
	var footer = $.mobile.activePage.find("div[data-role='footer']:visible");
	var content = $.mobile.activePage.find("div[data-role='content']:visible:visible");
	var viewport_height = $(window).height();

	var content_height = viewport_height - header.outerHeight() - footer.outerHeight();
	if((content.outerHeight() - header.outerHeight() - footer.outerHeight()) <= viewport_height) {
		content_height -= (content.outerHeight() - content.height());
	} 
	return content_height;
}

function colorKeyControl() {
  var colorKey = "<img src='images/colorkey-2x.png' width='310' height='25'>";
  var div = $('<div class="colorkey" style="margin: 4px 5px 0 5px"></div>').append(colorKey);
  return div.get(0);
}

$('#page-thanks').on("pageshow", function(event, ui) {
                       
    /* Reset the foliage report form to original values so we can make another report */
//    $("#smallImage").attr("src","images/tree-placeholder.png");
    $("#placeholder").css('background-image', 'url("images/placeholder-2x.png")');
    $("#foliagetext").val("Describe the foliage you see (optional)...");
    touchTextarea = false;
    $('#report-help').html("Slide to Rate Foliage");

    $('.info-button').removeClass('ui-disabled');
    $('.map-button').removeClass('ui-disabled');
    // $('#green-no-button').removeClass('ui-disabled');
    $('#myloc_button').removeClass('ui-disabled');

    $('div.ui-slider').css('opacity','1');
    $('#slider').slider('enable');    
    $('#slider').val(1).slider("refresh"); 
    $('.ui-slider').css("background",foliageColors[0]);
    $('.ui-slider-handle').css("background",foliageColors[0]);

    $('#example-image').css('opacity','1');
    $('#camera').css('opacity','1');
    $('#placeholder').css('opacity','1');

    $('#foliagetext').addClass('helptextgray');
    $('#foliagetext').css('opacity','1');
    $('#foliagetext').textinput('enable');    
    $('#foliagetext').css("height",descHeight);
    $('#locationwrapper').css('opacity','1');
    $('#takepicture').button('enable');
    $('#camera').removeClass('ui-disabled');

    $('#submitreport').button('enable');    
    // $('#green-peepit-button').button('enable');

    imageFile = '';
                       
});

/* -----------------------------------------------------------------------
 A variety of functions related to converting coordinate systems 
 ----------------------------------------------------------------------- */

function bound(value, opt_min, opt_max) {
    if (opt_min != null) { value = Math.max(value, opt_min); }
    if (opt_max != null) { value = Math.min(value, opt_max); }
    return value;
}

function degreesToRadians(deg) {
    return deg * (Math.PI / 180);
}

function radiansToDegrees(rad) {
    return rad / (Math.PI / 180);
}

function MercatorProjection() {
    this.pixelOrigin_ = new google.maps.Point(mercatorRange / 2, mercatorRange / 2);
    this.pixelsPerLonDegree_ = mercatorRange / 360;
    this.pixelsPerLonRadian_ = mercatorRange / (2 * Math.PI);
}

MercatorProjection.prototype.fromLatLngToPoint = function(latLng, opt_point) {
    var me = this;
    var point = opt_point || new google.maps.Point(0, 0);
    var origin = me.pixelOrigin_;
    point.x = origin.x + latLng.lng() * me.pixelsPerLonDegree_;
    var siny = bound(Math.sin(degreesToRadians(latLng.lat())), -0.9999, 0.9999);
    point.y = origin.y + 0.5 * Math.log((1 + siny) / (1 - siny)) * -me.pixelsPerLonRadian_;
    return point;
};

MercatorProjection.prototype.fromDivPixelToLatLng = function(pixel, zoom) {
    var me = this;
    var origin = me.pixelOrigin_;
    var scale = Math.pow(2, zoom);
    var lng = (pixel.x / scale - origin.x) / me.pixelsPerLonDegree_;
    var latRadians = (pixel.y / scale - origin.y) / -me.pixelsPerLonRadian_;
    var lat = radiansToDegrees(2 * Math.atan(Math.exp(latRadians)) - Math.PI / 2);
    return new google.maps.LatLng(lat, lng);
};

MercatorProjection.prototype.fromDivPixelToSphericalMercator = function(pixel, zoom) {
    var me = this;
    var coord = me.fromDivPixelToLatLng(pixel, zoom);
    var r= 6378137.0;
    var x = r* degreesToRadians(coord.lng());
    var latRad = degreesToRadians(coord.lat());
    var y = (r/2) * Math.log((1+Math.sin(latRad))/ (1-Math.sin(latRad)));
    return new google.maps.Point(x,y);
};

/* -----------------------------------------------------------------------
 End of coordinate utility functions
 ----------------------------------------------------------------------- */

/* Load the Foliage Map layer from the mapserver.ypi.com server */
function loadWMS() {
    
    var tileHeight = 256;
    var tileWidth = 256;
    var opacityLevel = 0.45;
    var isPng = true;
    var minZoomLevel = 6;
    var maxZoomLevel = 17;
    
    var baseURL = "http://mapserver.ypi.com/cgi-bin/mapserv?source=mobileapp&map=../maps/wms.map&";
    
    var wmsParams = [
                     "REQUEST=GetMap",
                     "SERVICE=WMS",
                     "VERSION=1.1.1",
                     "BGCOLOR=0xFFFFFF",
                     "TRANSPARENT=TRUE",
                     "SRS=EPSG:4326", // 3395? 
                     "WIDTH="+ tileWidth,
                     "HEIGHT="+ tileHeight
                     ];
    
    var parcelParams = wmsParams.concat([
                                         "FORMAT=image/gif",
                                         "LAYERS=counties",
                                         "STYLES="    
                                         ]);
    
    var imageParams = wmsParams.concat([
                                        "FORMAT=image/gif",
                                        "LAYERS=counties"
                                        ]);
    
    var overlayOptions =  {
    getTileUrl: function(coord, zoom) {
        var lULP = new google.maps.Point(coord.x*256,(coord.y+1)*256);
        var lLRP = new google.maps.Point((coord.x+1)*256,coord.y*256);
        
        var projectionMap = new MercatorProjection();
        
        var lULg = projectionMap.fromDivPixelToLatLng(lULP, zoom);
        var lLRg  = projectionMap.fromDivPixelToLatLng(lLRP, zoom);
        
        var lUL_Latitude = lULg.lat();
        var lUL_Longitude = lULg.lng();
        var lLR_Latitude = lLRg.lat();
        var lLR_Longitude = lLRg.lng();        
        
        var urlResult = baseURL + parcelParams.join("&") + "&bbox=" + lUL_Longitude + "," + lUL_Latitude + "," + lLR_Longitude + "," + lLR_Latitude;
        
        return urlResult;
    },
        
    tileSize: new google.maps.Size(tileHeight, tileWidth),
    minZoom: minZoomLevel,
    maxZoom: maxZoomLevel,
    opacity: opacityLevel,
    isPng: isPng
    };            
    
    overlayWMS = new google.maps.ImageMapType(overlayOptions);
    map.overlayMapTypes.insertAt(0, overlayWMS);
}

function showFoliageStatus(event,infowindow) {
    
    var locdata = {};
    
    locdata.lon = event.latLng.lng();
    locdata.lat = event.latLng.lat();
    
    $.ajax({
           type: "POST",
           url: "http://www.yankeefoliage.com/live-fall-foliage-map/doubleclick-query.php",
           data: locdata,
           dataType: "json",
           success: ShowStatus
    });
           
    function ShowStatus(result) {
        
        pos = event.latLng;        
        if (result.fipsfound === 0) {            
            html = "<div id='USAOnly'>";
            html = "<p>Foliage reports are only available for the USA.</p>";            
        }
        else {            
            county    = result.polygon.COUNTY;
            state    = result.polygon.STATE;            
            html = "<div id='ReportBox'>";
            html = html + '<h3 id="MarginZero">' + county + ", " + state + "</h3>";
            
            // need to decide if you want to have this button actually work so users can choose which county to report from
            //            html = html + '<p id="ReportButtonP"><input  type="button" value="Make a Foliage Report" onclick="ShowFoliageReporter(' + result.fips + ',\'' + county + '\',\'' + state + '\')"></p>';
            if (result.reports) {
                
                html = html + '<p id="Recent">Recent reports for this county:</p>';
                html = html + "<div id='AllReportsDiv'>";
                
                for (i = 0; i < result.reports.length; i += 1) {
                    var class_id = '';
                    if (result.reports[i].color == "#02D41B") {
                        class_id = "Green";
                    }
                    if (result.reports[i].color == "#FFFF00") {
                        class_id = "Yellow";
                    }
                    if (result.reports[i].color == "#FF9900") {
                        class_id = "Orange";
                    }
                    if (result.reports[i].color == "#E50B0B") {
                        class_id = "Red";
                    }
                    if (result.reports[i].color == "#CC6600") {
                        class_id = "Purple";
                    }
                    if (result.reports[i].color == "#C0C0C0") {
                        class_id = "Grey";
                    }
                    
                    html = html + '<div class="' + class_id + ' ReportDiv">';                    
                    if (result.reports[i].hasphoto == '1') {
                       html = html + '<a class="fancyboxphoto" href="http://www.yankeefoliage.com/live-fall-foliage-map/photos/user/display/' + result.reports[i].number + '.jpg" title=""  ><img src="http://www.yankeefoliage.com/live-fall-foliage-map/photos/user/thumbnail/' + result.reports[i].number + '.jpg" width="50" height="50" style="float:right"></a>';
                    }
                    html = html + '<p class="RatingWord">' + result.reports[i].ratingword + ' on ' + result.reports[i].datereported + "</p>";
                    if (result.reports[i].comment != '') {
                        html = html + '<p class="Comment">' + result.reports[i].comment + "</p>";
                    }
                    html = html + "<div class='Clear'></div>";
                    html = html + "</div>";
                    $('a.fancyboxphoto').fancybox();
                }
                html = html + "</div>";
                html = html + "<p><a href='#page-report' class='no-reports-button' data-role='button' type='button'>Make a Report</a></p>";
            }
            else {
                html = html + "<p>No foliage reports have been received for this county yet. Are you there? Please tell us what the foliage is like by making a report!</p>";
                html = html + "<p><a href='#page-report' class='no-reports-button' data-role='button' type='button'>Make a Report</a></p>";
            }
        }
        html = html + "</div>";

        if (last_infowindow) {
            last_infowindow.close()
            last_infowindow = false;
        }

//        if (debugShow) { console.log(html); }
//        infowindow.setPosition(pos);
//        infowindow.setContent(html);
//        infowindow.open(map);
//        last_infowindow = infowindow;
        
        runtimePopup(html);

        $('.no-reports-button').button();

        if (debugShow) { console.log("Setting location to " + result.location); }

        reportPosition = locdata.lat + "," + locdata.lon;            

        $("#reportposition").val(reportPosition);  

        window.localStorage.setItem("latitude", locdata.lat);
        window.localStorage.setItem("longitude", locdata.lon);
        window.localStorage.setItem("location", result.location);
        reportlatitude = locdata.lat;
        reportlongitude = locdata.lon;
        reportloc = result.location;

        $("#locationvalue").html(result.location);

        if (debugShow) { console.log(pos); }
    }
    
}

function runtimePopup(message, popupafterclose) {

    var template = "<div data-role='popup' class='ui-content messagePopup' style='max-width:280px'>"
    + "<a href='#' data-role='button' data-theme='g' data-icon='delete' data-iconpos='notext' "
    + " class='ui-btn-right closePopup'>Close</a> <span> "
    + message + " </span> </div>";

    popupafterclose = popupafterclose ? popupafterclose : function () {};
     
    $.mobile.activePage.append(template).trigger("create");
     
    $.mobile.activePage.find(".closePopup").bind("tap", function (e) {
        $.mobile.activePage.find(".messagePopup").popup("close");
    });
     
    $.mobile.activePage.find(".messagePopup").popup().popup("open").bind({
        popupafterclose: function () {
            $(this).unbind("popupafterclose").remove();
            popupafterclose();
        }
    });
}

/* 
 -----------------------------------------------------------------------
 Location-related functionality
 ----------------------------------------------------------------------- */

function locationValidate() {
    
    var locdata = {};

    if ($("#location-entry").val() != "") {
        locdata.location = $("#location-entry").val();
    }
    if (debugShow) { console.log(locdata.location); }
    
    $.ajax({
           type: "POST",
           url: "http://www.yankeefoliage.com/live-fall-foliage-map/validate-location.php",
           data: locdata,
           dataType: "json",
           success: locationValidateSuccess,
           error: locationValidateError
    });
    
}

function locationValidateError(error) {
    if (debugShow) { console.log("Location validation error"); }
    if (debugShow) { console.log(error); }
}

function locationValidateSuccess(result) {    
    
    if (debugShow) { console.log("Started location validation"); }
    
    if (result.noplace) {            
        if (result.multipleplaces) {
            $('#locationerrormessages').html("<p>We found multiple places for the location you entered. If you omitted the state or province abbreviation, try adding it. Otherwise, try entering a U.S. ZIP code or a Canadian postal code.</p>");
        }
        else {
            $('#locationerrormessages').html("<p>We couldn't find the place you entered. You can enter places as:</p><ul><li><strong>U.S. ZIP Code</strong> - like <strong>03444</strong> or <strong>90210</strong>.</li><li><strong>City, State</strong> - like <strong>Boston, MA</strong> or <strong>Los Angeles, CA</strong>.</li></ul><p>Please try entering a place again.</p>");
            if (debugShow) { console.log(result.noplace); }
        }
    }
    else {
        document.activeElement.blur();
        $("input").blur();

        reportPosition = result.latitude + "," + result.longitude;            

        $("#reportposition").val(reportPosition);  

        window.localStorage.setItem("latitude", result.latitude);
        window.localStorage.setItem("longitude", result.longitude);
        window.localStorage.setItem("location", result.location);
        reportlatitude = result.latitude;
        reportlongitude = result.longitude;
        reportloc = result.location;

        $("#locationvalue").html(result.location);

        $('#submitreport').button('enable');
        $('#submitreport').removeClass('ui-disabled');            

        $('#locationerrormessages').html(""); 
        $('.ui-dialog').dialog('close');
    }
}


/*------------------------------------------------------ 
 PARSE A QUERYSTRING
 ------------------------------------------------------ */

function getQueryVariable(url, variable) {
    var vars = url.split("&");
    for (i = 0; i < vars.length; i += 1) {
        var pair = vars[i].split("=");
        if (pair[0] == variable) {
            return unescape(pair[1]);
        }
    }
}

