var hk = null;

var hkLen = null;
var lastcard = null;
var failed = false;
var cardSet = "h";
var minimumWins = 3;
var userdata = null;
var nbProps = 3

function setCards(){
    userdata = {};
    for(var k in hk){
        var data = hk[k]
        userdata[k] = {key:k,wins:0,fails:0,wrongAnsers:[],ok:false,first:true};
    }
    console.log(userdata); 
    localStorage["userdata"] = JSON.stringify(userdata);
}

function showProgession(){
    var progdata = [0,0];
    for(var i in userdata){
        var d = userdata[i];
        var c = hk[i];
        if(cardSet.search(c.set) != -1) {
            if(d.ok)
                progdata[0] += 1;
            progdata[1] += 1
        }
    }
    
    var percent = (progdata[0]/progdata[1] * 100).toFixed(2) + "%";
    $("#prog").html(percent );
    $("#progbar").css("width",percent)
}

function showCard(){                
    failed = false; 
    function sortcards(e){
        var rounds = e.wins+e.fails;
        if(rounds == 0)
            return hk[e.key].idx
        else if(e.wins < minimumWins)
            return hk[e.key].idx + e.wins;
        else{
            var k = e.wins / (e.wins+e.fails);
            return hk[e.key].idx + k * hkLen;
        }
        
    }
    var ret = _.chain(userdata)
        .filter(function(e){
                return (cardSet.search(hk[e.key].set) != -1) && ((lastcard == null) || (e.key!=lastcard));
            })
        .sortBy(sortcards)
        .reverse()
        .value();
        
    var cardUserData = ret.pop()
    var key = cardUserData.key;
    var card = hk[key];
    
    var props = [card.rom];
    
    for(var i=0;props.length<nbProps && i<cardUserData.wrongAnsers.length;++i){
        var rom = cardUserData.wrongAnsers[i]
        if (!_.contains(props,rom))
            props.push(rom);
    }
       
    for(var i=props.length;i<nbProps;){
        var _key = ret.pop().key;
        var rom = hk[_key].rom
        if (!_.contains(props,rom)){
            props.push(rom)
            ++i
        }
    }
        
    props = _.shuffle(props);
    props = _.groupBy(props,function (e,i){return Math.floor(i/3.0)})
    
    var tpl = "";
    for(var ig in props){
        var g = props[ig];
        var lg = g.length;
        tpl += '<div class="grid grid-pad">';
        if(lg==2)
            tpl += "<div class=\"col-1-6 mobile-col-1-6\"><div class=\"content\"></div></div>"
        else if(lg==1)
            tpl += "<div class=\"col-1-3 mobile-col-1-3\"><div class=\"content\"></div></div>"
        for(ip in g){
            var p = g[ip];
            var tip = (cardUserData.first && p == card.rom)?"tip":"";
            tpl += "<div class=\"col-1-3 mobile-col-1-3\"><div class=\"content\"><div class=\"button_blue proposition " + tip + "\">"+p+"</div></div></div>"
        }
        if(lg==2)
            tpl += "<div class=\"col-1-6 mobile-col-1-6\"><div class=\"content\"></div></div>"
        else if(lg==1)
            tpl += "<div class=\"col-1-3 mobile-col-1-3\"><div class=\"content\"></div></div>"
        tpl += '</div>';
    }
        
    $("#kana").html(key);
    $("#props").html(tpl);
    
    lastcard = key;
}


function answer(jqobj){

                $("#progbar").removeClass("progwin");
                $("#progbar").removeClass("progfail");
                
    var ans = jqobj.text();
    var lc = userdata[lastcard];
    if(hk[lastcard].rom == ans){
        if(!failed){
            if(!lc.ok){
                $("#progbar").addClass("progwin");
            }
            lc.wins += 1;
            lc.ok = true;
            lc.first = false;
        }
        showProgession()
        showCard()
    }
    else{
        if(lc.ok){
            $("#progbar").addClass("progfail");            
        }
        lc.fails += 1;
        lc.ok = false;
        lc.wrongAnsers.push(ans);
        lc.wrongAnsers = _.uniq(lc.wrongAnsers)
        //jqobj.css("color","red")
        jqobj.removeClass("button")
        jqobj.addClass("button_red")
        jqobj.addClass("wrong")
        
        
        failed = true;
        showProgession()
    }
    
}

$(function(){
    
    $('#lmodehira').prop('checked', true);
    $('#b1').prop('checked', true);

    
    //$("#kana").on("click",function(){alert("kana clicked")});
    $("#props").delegate(".proposition","click",function(e){answer($(this))});
    $("#modehira").on("click",function(){
        cardSet="h";
        showProgession()
        showCard()
    });
    
    
    $("#modekata").on("click",function(){
        cardSet="k";
        showProgession()
        showCard()
    });
    
    $("#modeunion").on("click",function(){
        cardSet="hk";
        showProgession()
        showCard()
    });
    
    
    $("#modeEasy").on("click",function(){
        nbProps=3;
        showCard()
    });
    
    $("#modeNormal").on("click",function(){
        nbProps=5;
        showCard()
    });
    
    $("#modeHard").on("click",function(){
        nbProps=8;
        showCard()
    });
    
    
    $("#resetbtn").on("click",function(){
        setCards()
        showCard()
        showProgession()
    });
    


    $.ajax({
      type: 'GET',
      url: "/scripts/data.json",
      dataType: 'json',
      success: function(data) { 
            hk = data;       
            if(localStorage["userdata"] == undefined){
                setCards()
            }
            else{
                userdata = JSON.parse(localStorage["userdata"])
            }
            hkLen = Object.keys(hk).length;
            showProgession()
            showCard()            
            setInterval ( 'localStorage["userdata"] = JSON.stringify(userdata)', 10000 );
            //TODO: ajouter un test pour le faire qu'après des modifs (modified=true)
      },
      async: false
    });
    
});

