$(document).on('mobileinit', function () {

    function getLenInCurrDevice(len) {
        try {
            var referenceDPI = 192.2960680247461, // Ref device is Sony Xperia Mini Pro - SK17i.
                pRatio = window.devicePixelRatio, // Ratio of current device DPI on a square inch to that of a MDPI.
                currDPI = referenceDPI * Math.sqrt(pRatio),
                originalWInInch = len / referenceDPI;
            return Math.floor((originalWInInch / pRatio) * currDPI);
        } catch (err) {
            return len;
        }
    }

    $.support.cors = true;
    $.mobile.buttonMarkup.hoverDelay = 0;
    $.mobile.allowCrossDomainPages = true;
    $.mobile.pushStateEnabled = false;

    $.event.special.tap.emitTapOnTaphold = false;

    var threshold = getLenInCurrDevice($.event.special.swipe.scrollSupressionThreshold);
    console.log('Updating scrollSupressionThreshold from ' + $.event.special.swipe.scrollSupressionThreshold + ' to ' + threshold);
    $.event.special.swipe.scrollSupressionThreshold = threshold;

    threshold = getLenInCurrDevice($.event.special.swipe.horizontalDistanceThreshold);
    console.log('Updating horizontalDistanceThreshold from ' + $.event.special.swipe.horizontalDistanceThreshold + ' to ' + threshold);
    $.event.special.swipe.horizontalDistanceThreshold = threshold;

    threshold = getLenInCurrDevice($.event.special.swipe.verticalDistanceThreshold);
    console.log('Updating verticalDistanceThreshold from ' + $.event.special.swipe.verticalDistanceThreshold + ' to ' + threshold);
    $.event.special.swipe.verticalDistanceThreshold = threshold;

    $.event.special.swipe.durationThreshold = 2500;
});
